<?php
/**
 * 文件上传类
 *
 * 基础的文件上传类
 *
 * @author 无招之击<houbenbo@gmail.com>
 * @version 0.1
 */
class FileUpload {
	/**
	 * 配置参数
	 *
	 * @var array
	 */
	private $config = array(
		 'filename' => '', //保存文件名，默认为空，即使用原始文件名
		 'overwrite' => true, //覆盖相同文件名
		 'maxsize' => '2MB', //文件最大尺寸
		 'path' => '/', //文件上传路径
		 'dieonerror' => true, //出错是是否结束请求
		 'showerror' => true, //显示出错信息
		 'fileext' => '.jpg', //显示出错信息
		 'extension' => 'zip|jpg|gif|swf|rar|png' //允许的文件类型
		);
	
	/**
	 * 构造函数
	 *
	 * @param array $param 配置参数
	 * @return volid
	 */
	function __construct($param = array()) {
		$this->setConfig($param);
	}
	
	/**
	 * 参数设置
	 *
	 * @param string $key 配置关键字
	 * @param string $val 配置值
	 * @return void
	 */
	function setConfig($key,$val='') {
		 if(is_array($key)) $this->config = array_merge($this->config,$key);
		 else $this->config[$key] = $val;
	}

	/**
	 * 获取参数
	 * 
	 * @param string $key 关键字
	 * @return string 值
	 */
	function getConfig($key){
		if ( isset($this->config[$key]) ) return $this->config[$key];
		return '';
	}

	/**
	 * 保存文件
	 *
	 * @param object $file 文件句柄
	 * @return bool true或者false
	 */
	function save($file) {
		
		//检查扩展名
		$pathinfo = pathinfo($file['name']);
		$this->config['fileext'] = strtolower($pathinfo['extension']);
		if ( strpos($this->config['extension'], $this->config['fileext']) === false ) {
			$this->printErr('您上传的文件类型不被允许');
			return false;
		 }

		//检查文件尺寸
		if ( filesize($file['tmp_name']) > $this->filesize2bytes($this->config['maxsize']) ) {
			$this->printErr('您上传的文件超过最大限制');
			return false;
		}

		//坚持是否已经存在
		
		if ( file_exists($this->config['path'] . $this->config['filename']) && !$this->config['overwrite'] ) {
			$this->printErr('您上传的文件名已经存在并且不允许覆盖');
			return false;
		}

		//处理特殊参数
		if ( $this->config['filename'] == '' ) $this->config['filename'] = $file['name'];
		if ( !strpos($this->config['filename'], $this->config['fileext']) )
			$this->config['filename'] .= '.' . $this->config['fileext'];
		if ( substr($this->config['path'], -1) != '/' ) $this->config['path'] .= '/';

		//保存文件
		return move_uploaded_file($file["tmp_name"],$this->config['path'] . $this->config['filename']);
	}
	/**
	 * 转换文件大小
	 *
	 * @param string $str 文件尺寸各种写法
	 * @return int $bytes 文件尺寸
	 */
	function filesize2bytes($str) {
		$bytes = 0;

		$bytes_array = array(
		'B' => 1,
		'KB' => 1024,
		'MB' => 1024 * 1024,
		'GB' => 1024 * 1024 * 1024,
		'TB' => 1024 * 1024 * 1024 * 1024,
		'PB' => 1024 * 1024 * 1024 * 1024 * 1024,
		);

		$bytes = floatval($str);

		if (preg_match('#([KMGTP]?B)$#si', $str, $matches) && !empty($bytes_array[$matches[1]])) {
		$bytes *= $bytes_array[$matches[1]];
		}

		$bytes = intval(round($bytes, 2));

		return $bytes;
	}

	/**
	 * 输出错误
	 *
	 * @param string $str 错误信息
	 * return void
	 */
	function printErr($str){
		echo $str;
		if($this->config['dieonerror']) die();
	}
}