<?php
/**
 * 图片处理类
 * 
 * 处理缩略图
 *
 * @author 无招之击<houbenbo@gmail.com>
 * @version 0.1
 */
class SimpleImage {
	/**
	 * 图片文件句柄
	 *
	 * @var image
	 */
	private $image;

	/**
	 * 图片类型
	 *
	 * @var imagetype
	 */
	private $image_type;

	/**
	 * 装载图像
	 *
	 * @param string $filename 文件完整路径
	 * @return void
	 */
	function load($filename) {
		$image_info = getimagesize($filename);
		$this->image_type = $image_info[2];
		if( $this->image_type == IMAGETYPE_JPEG ) {
			$this->image = imagecreatefromjpeg($filename);
		} elseif( $this->image_type == IMAGETYPE_GIF ) {
			$this->image = imagecreatefromgif($filename);
		} elseif( $this->image_type == IMAGETYPE_PNG ) {
			$this->image = imagecreatefrompng($filename);
		}
	}

	/**
	 * 返回扩展名
	 * 
	 * @return string 扩展名
	 */
	function getExtension(){
		if( $this->image_type == IMAGETYPE_JPEG ) return 'jpg';
		elseif( $this->image_type == IMAGETYPE_GIF ) return 'gif';
		elseif( $this->image_type == IMAGETYPE_PNG ) return 'png';
	}

	/**
	 * 将图形对象保存成文件
	 *
	 * @param string $filename 文件名
	 * @param int $image_type 文件类型
	 * return volid
	 */
	function save($filename, $image_type=IMAGETYPE_JPEG) {
		if( $image_type == IMAGETYPE_JPEG ) {
			imagejpeg($this->image,$filename);
		} elseif( $image_type == IMAGETYPE_GIF ) {
			imagegif($this->image,$filename);
		} elseif( $image_type == IMAGETYPE_PNG ) {
			imagepng($this->image,$filename);
		}
	}
	
	/**
	 * 将图像输出到数据流
	 *
	 * @param int $image_type 文件类型
	 * @return void
	 */
	function output($image_type=IMAGETYPE_JPEG) {
		if( $image_type == IMAGETYPE_JPEG ) {
			imagejpeg($this->image);
		} elseif( $image_type == IMAGETYPE_GIF ) {
			imagegif($this->image);
		} elseif( $image_type == IMAGETYPE_PNG ) {
			imagepng($this->image);
		}
	}

	/**
	 * 获得图像宽度
	 *
	 * @return int 图像宽度
	 */
	function getWidth() {
		return imagesx($this->image);
	}

	/**
	 * 获得图像高度
	 *
	 * @return int 图像高度
	 */
	function getHeight() {
		return imagesy($this->image);
	}

	/**
	 * 等比例缩小到指定高度
	 * 
	 * @param int $height 指定高度
	 */
	function resizeToHeight($height) {
		$ratio = $height / $this->getHeight();
		$width = $this->getWidth() * $ratio;
		$this->resize($width,$height);
	}

	/**
	 * 缩小到指定尺寸
	 * 
	 * @param int $w 指定宽度
	 * @param int $h 指定高度
	 */
	function resizeTo($w=0, $h=0) {
		if($w>0 && $h>0) return $this->resize($w,$h);
		else if($w>0) return $this->resizeToWidth($w);
		else if($h>0) return $this->resizeToHeight($h);
	}

	/**
	 * 等比例缩小到指定宽度
	 * 
	 * @param int $width 指定宽度
	 */
	function resizeToWidth($width) {
		if($width>=$this->getWidth()) return;
		$ratio = $width / $this->getWidth();
		$height = $this->getheight() * $ratio;
		$this->resize($width,$height);
	}

	/**
	 * 维持宽高比缩小指定比例
	 * 
	 * @param int $scale 指定比例
	 */
	function scale($scale) {
		$width = $this->getWidth() * $scale/100;
		$height = $this->getheight() * $scale/100;
		$this->resize($width,$height);
	}

	/**
	 * 改变图像尺寸
	 * 
	 * @param int $width 指定宽度
	 * @param int $height 指定高度
	 */
	function resize($width,$height) {
		$new_image = imagecreatetruecolor($width, $height);
		imagecopyresampled($new_image, $this->image, 0, 0, 0, 0, $width, $height, $this->getWidth(), $this->getHeight());
		$this->image = $new_image;
	}

	/**
	 * 裁剪图像
	 *
	 * @param int $width 指定宽度
	 * @param int $height 指定高度
	 */
	function cut($width,$height){
		$new_image = imagecreatetruecolor($width, $height);
		imagecopy($new_image, $this->image, 0, 0, 0, 0, $width, $height);
		$this->image = $new_image;
	}

	/**
	 * 截取从某纵向位置开始指定高度的图像
	 *
	 * @param int $top 指定位置
	 * @param int $height 指定高度
	 */
	function vcut($top,$height){
		$width = $this->getWidth();
		$height = $this->getheight()-$top+$height;
		if($height<200) return;
		$new_image = imagecreatetruecolor($width, $height);
		imagecopy($new_image, $this->image, 0, 0, 0, $top, $width, $height);
		$this->image = $new_image;
	}
}