<?php
//列出压缩文件
function listzip($dirName = '') {
	if ( $dirName == '' ) $dirName = PW_ROOT . 'zip'; 
	if(! is_dir($dirName)){
		outErr('目录名称错误 -> '.$dirName);
		return false;
	}
	//存放文件的数组
	$files = array();
	//遍历目录列出压缩文件
	$handle = opendir($dirName);
	while( ( $file = readdir($handle) ) !== false ) {
		if ( $file == '.' || $file == '..' ) continue;
		$fileurl = $dirName . DIRECTORY_SEPARATOR . $file;
		if ( substr($file,-4) == '.zip' ) {
			$files[] = $fileurl;
		} else if ( is_dir($fileurl) ) {
			$files += listzip($fileurl);
		}
	}
	closedir($handle);
	return $files;
}
function listresize(){
//存放文件的数组
	$files = array();
	//遍历目录列出压缩文件
	$handle = opendir(PW_ROOT.'public');
	while( ( $file = readdir($handle) ) !== false ) {
		if ( $file == '.' || $file == '..' || strpos($file,'_') != false ) continue;
		$files[] = $file;
	}
	closedir($handle);
	return $files;
}
//解压
function unzip($file,$url='photo/'){
	$zip = new ZipArchive;
	if ($zip->open($file) === TRUE) {
		$zip->extractTo(PW_ROOT . $url);
		$zip->close();
		return true;
	}
	return false;
}
//循环解压
function unzipall(){
	$zips = listzip();
	if(!$_GET['a']) $_GET['a'] = 0;
	unzip($zips[$_GET['a']],'photo/');
	$str = $_GET['a']<count($zips)-1 ? '<meta http-equiv="Refresh" content="5;url=http://www.czzbz.info/picwind/index.php?a='.($_GET['a']+1).'" >' : '完成<br />';
	$str .= $zips[$_GET['a']];
	return $str;
}
//列出相片
function listphotos($url=false,$dir = 'temp'){

	if(!$url) $url = '/';
	$dirName = PW_ROOT . $dir . $url;
	if(! is_dir($dirName)){
		echo $dirName;
		trigger_error("DIR ERRO", E_USER_ERROR);
	}
	//存放文件的数组
	$files = array();
	//遍历目录列出压缩文件
	$handle = opendir($dirName);
	while(($file = readdir($handle)) !== false){
		if($file == '.' || $file == '..') continue;
		$fileurl = $url.$file;
		$ext = strtolower(substr($file,-4));
		if($ext == '.png' || $ext == '.jpg' || $ext == '.gif'){
			$files[] = $fileurl;
		}else if(is_dir($dirName.DIRECTORY_SEPARATOR.$file)){
			$files = array_merge($files,listphotos($fileurl.'/',$dir));
		}
	}
	closedir($handle);
	return $files;
}
function transTemp(){
	$dirName = PW_ROOT . 'temp';
	if(! is_dir($dirName)){
		echo $dirName;
		trigger_error("DIR ERRO", E_USER_ERROR);
	}
	//遍历目录
	$handle = opendir($dirName);
	while(($file = readdir($handle)) !== false){
		if($file == '.' || $file == '..') continue;
		$nname = $dirName.DIRECTORY_SEPARATOR.$file;
		rename($nname,str_replace('/temp/','/photo/',$nname));
	}
	closedir($handle);
	return true;
}
//导入数据库
function todb(){
	global $pwdb;
	$pwdb->begin();
	foreach(listphoto() as $row){
		$pwdb->dataAdd('t_photo',array('id'=>$pwdb->maxId('t_photo'),'key'=>$pwdb->getString(48),'title'=>'未命名','path'=>$row),array('id_n','key_s','title_s','path_s'));
	}
	$pwdb->commit();
	return 'ok';
}
//默认相册
function detaultalbum(){
	global $pwdb;
	$pwdb->begin();
	foreach($pwdb->query('select id,path from t_photo') as $row){
		addToAlbum(substr($row['path'],1,7),$row['id']);
		echo substr($row['path'],1,7)."\n";
	}
	$pwdb->commit();
}
//添加到相册
function addToAlbum($album,$photoid,$arch = false){
	global $pwdb;
	$row = $pwdb->getRow('select * from t_album where title="'.$album.'"');
	if(!$row){
		$sortby = $arch ? 0 : 1;
		$row = array('id'=>maxId('t_album'),'key'=>uString(48,true),'title'=>$album,'public'=>0,'front'=>$photoid,'sortby'=>$sortby);
		$pwdb->dataAdd('t_album',$row);
	}
	return addToAlbumByID($row['id'],$photoid);
}
function addToAlbumByID($albumid,$photoid){
	global $pwdb;
	return $pwdb->dataAdd('t_photo_album',array('photoid'=>$photoid,'albumid'=>$albumid));
}
function removeFromAlbum ($album,$photoid){
	global $pwdb;
	$row = $pwdb->getRow('select * from t_album where key="'.$album.'"');
	if(!$row) return;
	return removeFromAlbumByID($row['id'],$photoid);
}
function removeFromAlbumByID ($albumid,$photoid){
	global $pwdb;
	return $pwdb->query("delete from t_photo_album where photoid=$photoid and albumid=$albumid");
}
function removePhoto($pid){
	global $pwdb,$photosize;
	$info = $pwdb->getRow('select * from t_photo where id='.$pid);
	if (!$info) return;
	//删除缩放文件
	@unlink(PW_ROOT . 'public/' . $info['key'] . $info['ext']);
	foreach ( $photosize as $z ) @unlink(PW_ROOT . 'public/' . $z . '_' . $info['key'] . $info['ext']);
	//删除原始文件
	@unlink(PW_ROOT . 'photo' . $info['path']);
	//删除数据库记录
	$pwdb->query("delete from t_photo_album where photoid=".$pid);
	$pwdb->query("delete from t_photo where id=".$pid);


}
function removeAlbum($aid){
	global $pwdb;
	//删除数据库记录
	$pwdb->query("delete from t_photo_album where albumid=".$aid);
	$pwdb->query("delete from t_album where id=".$aid);

}
//相册列表
function listAlbum(){
	global $pwdb;
	$sortby = isLogin() && $_GET['archive']==1 ? 0 : 1;
	$str = '';
    $pwpath = PW_PATH;
	foreach(getAlbums($sortby) as $row){
		$str .= <<<HTML
			<div class="album">
				<a href="album.php?abl={$row['key']}" class="albuma"><img src="{$pwpath}public/100_{$row['frontkey']}.jpg" class="albumimg" /></a>
				<p class="albumt albumt{$row['public']}">{$row['title']}</p>
				<span class="photocount">{$row['photocount']}</span>
			</div>
HTML;
	}
	return $str;
}
//显示相片
function listPhoto($album,$una = 0){
	global $pwdb;
	if($una == 1){//未分类
		$data = $pwdb->query('select * from t_photo where id not in (select photoid from t_photo_album)');
	} else if($una == 2){//未归档
		$data = $pwdb->query('select * from t_photo where id not in (select photoid from t_photo_album where albumid in (select id from t_album where sortby=0))');
	} else if($una == 3) {//未标记
		$data = $pwdb->query('select * from t_photo where id not in (select photoid from t_photo_album where albumid in (select id from t_album where sortby=1))');
	} else{
		$data = getPhotos($album); 
	}
    $pwpath = PW_PATH;
	foreach($data as $row){
		$shorttitle = uleft($row['title'],9);
		$str .= <<<HTML
			<div class="photo">
				<a href="photo.php?p={$row['key']}" class="photoa">
					<img src="{pwpath}public/100_{$row['key']}.jpg" class="photoimg" />
				</a>
				<p class="photot" title="{$row['title']}" tag="{$row['id']}">{$shorttitle}</p>
				<p class="photob"><input type="checkbox" name="sel[]" value="{$row['id']}" /> 选择</p>
			</div>
HTML;
	}
	return $str;
}
function getPhotos($album){
	global $pwdb;
	$albumid= $pwdb->getValue('select id from t_album where key="'.$album.'"');
	return $pwdb->query('select * from t_photo where id in (select photoid from t_photo_album where albumid='.$albumid.')');
}
//相片信息
function photoInfo($p){
	global $pwdb;
	$ar = $pwdb->getRow('select * from t_photo where key="'.$p.'"');
	$ar['albums'] = $pwdb->query('select * from t_album where id in (select albumid from t_photo_album where photoid='.$ar['id'].')');
	return $ar;
}
//相册信息
function albumInfo($abl){
	global $pwdb;
	$ar = $pwdb->getRow('select * from t_album where key="'.$abl.'"');
	return $ar;
}
//相册列表
function getAlbums($t){
	global $pwdb;
	$sql = 'select * from v_album where sortby='.$t;
	if(!islogin()) $sql .= ' and public=1';
	$sql .= ' order by title desc';
	return array_map('setStatic',$pwdb->query($sql));
}
function setStatic($value){
	global $pwdb;
	$value['photocount'] = $pwdb->getValue('select count(photoid) from t_photo_album where albumid='.$value['id']);
	return $value;
}
function uploadPhoto($file,$title = '未命名',$album = '手机相册') {
	global $pwdb;
    if ( !is_dir(PW_ROOT . 'photo/upload/') ) mkdir(PW_ROOT . 'photo/upload/');
	if ( !class_exists('FileUpload') ) require (PW_INCLUDE . 'class_fileupload.php');
	$fp = new FileUpload();
	$fp->setConfig('filename',uString(6));
	$fp->setConfig('path',PW_ROOT . 'photo/upload/');
	if ( $fp->save($file) ) {
		//添加到数据库
		$data = array('id'=>maxId('t_photo'),
			'title'=>$title,
			'path'=>'/upload/' . $fp->getConfig('filename'),
			'key'=>uString(48,true),
			'date'=>date('Y-m-d H:i:s'),
			'ext'=>$fp->getConfig('fileext')
			);
		$pwdb->dataAdd('t_photo',$data);
		addToAlbum($album,$data['id']);
		$data['filename'] = $data['key'] . '.' . $data['ext'];
		return $data;
	}
	return false;
}
function clearAlbum(){
	global $pwdb;
    //修复数据（删除了封面照片的相册）
    $as = $pwdb->query('select * from t_album where front not in (select id from t_photo_album where albumid=t_album.id)');
    foreach ( $as as $a ) {
        $ar = $pwdb->getRow('select * from t_photo_album where albumid='.$a['id']);
        if ( $ar ) $pwdb->query('update t_album set front = '.$ar['photoid'] . ' where id='.$a['id']);
        else $pwdb->query('delete from t_album where id='.$a['id']);
    }
}
function clearPhoto(){
	global $pwdb,$photosize;
	$ct = 0;
	//所有照片
	$all = listphotos(false,'photo');
	//数据库中所有照片 
	$dbs = array();
	$db = $pwdb->query('select path from t_photo');
	foreach($db as $row) $dbs[] = $row['path'];
	$clears = array_diff($all,$dbs);
	foreach($clears as $c){
		unlink(PW_ROOT . 'photo' . $c);
		$ct ++;
	}
	//清理缩略图
	$allr = listresize();
	$dbrs = array();
	$dbr = $pwdb->query('select key,ext from t_photo');
	foreach($dbr as $row) $dbrs[] = $row['key'].'.'.$row['ext'];
	$clearrs = array_diff($allr,$dbrs);
	foreach($clearrs as $c){
		unlink(PW_ROOT . 'public/' . $c);
		$ct ++;
		foreach($photosize as $z) @unlink(PW_ROOT . 'public/' . $z . '_' . $c);
	}
	return $ct;

}
function clearAll(){
	exec('rm ' . PW_ROOT . 'public/*');
}
//检查登录
function islogin(){
	return isset($_COOKIE['logs']);
}
//登录
function login($ar){
	if($ar['username']== PW_LOGIN && $ar['password']== PW_PASSWORD) {
		setCookie('logs','yes',time()+3600*24*365);
		return true;
	}
	return false;
}
function logout(){
    unset($_COOKIEp['logs']);
	setcookie ('logs', "", time() - 3600);
}
function outErr($str) {
	echo $str;
}
function maxId($tablename){
	global $pwdb;
	$row = $pwdb->getRow('select maxid from t_max where tablename = "'.$tablename.'"');
	if(!$row) {
		$pwdb->dataAdd('t_max',array('tablename'=>$tablename,'maxid'=>1));
		return 1;
	} else {
		$pwdb->dataUpdate('t_max',array('maxid'=>$row['maxid'] + 1),'where tablename="'.$tablename.'"');
		return $row['maxid'] + 1;
	}
}
function toHome(){
    header('Location:' . PW_PATH);
}