<?php
/**
 * 通用函数列表
 *
 * @author 无招之击<houbenbo@gmail.com>
 * @version 0.1
 */

/**
 * 截取指定长度的中文字符
 *
 * @param string $str 要处理的字符
 * @param int $len 截取的长度
 * @param bool $afterfix 是否显示...
 * @return string 处理过的字符串
 */
function uLeft($str,$len,$afterfix = true) {
	$rt = preg_replace(array('/&[^;]+;/','/[\s]{2,}/'),array('',''),strip_tags($str));
	$rt = str_replace('　','',$rt);
	if ( mb_strlen($rt,'utf-8')<=$len) return $rt;
	return mb_substr($rt,0,$len,'utf-8') . ($afterfix ? '...' : '');
}

/**
 * 当前日期长字符串
 *
 * @return string 日期
 */
function uDate(){
	$w = array("日","一","二","三","四","五","六");
	return date("Y年m月d日 星期").$w[date("w")];
}

/**
 * 数组转换为JSON
 * 
 * @param array $data 字符键值的数据数组
 * @return string JSON字符
 */
function uJson($data){
	$tre = array();
	foreach ( $data as $row ){
		$rre=array();
		foreach ( $row as $key => $value ) {
			if ( !is_int($key) )
				$rre[] = $key . ':' . ( is_array($value) ? $this->json($value) : '"'.str_replace('"','\"',$value).'"' );
		}
		$tre[] = '{'.implode(',',$rre).'}';
	}
	return '['.implode(',',$tre).']';
}

/**
 * 列表框和单选框
 *
 * @param array $values 数据数组
 * @param string|int $sel 当前选中
 * @param string $radioname 单选框的name,默认为空，即为列表框形式
 * @param string $vcol 值字段
 * @param string $tcol 显示字段
 * @return string 选项字符串
 */
function uOption($values, $sel=-1, $radioname=false, $vcol="id", $tcol="title") {
	$str = '';
	if ( $radioname != '' ) {
		foreach ( $values as $row ) {
			$checked = $sel == $row[$vcol] ? ' checked="true"' : '';
			$id = $radioname.$row[$vcol];
			$str .= <<<HTML
				<input type="radio" value="{$row[$vcol]}" name="{$radioname}" id="{$id}"{$checked} />
				<label for="{$id}">{$row['title']}</label>
HTML;
		}
	} else {
		foreach( $values as $row ) {
			$checked = $sel == $row[$vcol] ? ' selected="true"' : '';
			$str .= '<option value="' . $row[$vcol] . '"' . $checked . '>' . $row[$tcol] . '</option>';
		}
	}
	return $str;
}
/**
 * 随机字符串
 *
 * @param int $len 长度
 * @param bool $limit 限制特殊字符
 * @return string 随机字符串
 */
function uString($len,$limit = false) {
	$str = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ" . ($limit ? "" : "_-");
	return substr(str_shuffle($str),0,$len);
}

/**
 * 分页
 * 
 * @param int $recordcount 记录数
 * @param int $pageindex 当前页数
 * @param int $pagesize 每页记录数
 * @param bool $showstatus 是否显示统计，如英文站则不应显示
 * @return string 统计的代码
 */
function uPage($recordcount,$pageindex,$pagesize = 20,$showstatus = true) {
	//总页数
	$pages = Ceil($recordcount/$pagesize);
	$status = '共'.$pages.'页 每页'.$pagesize.'项';
	if ( $pages<2) return $status;
	
	if ( $pageindex > $pages ) $pageindex = $pages;
	if ( $pageindex < 1 ) $pageindex = 1;

	//不是第一页则显示上一页
	$rtstr = $pageindex > 1 ? '<a href="?page=1">|&lt;</a><a href="?page=' . ($pageindex-1) . '">&lt;</a>' : '';

	$i = ($pages-$pageindex<10) ? $pages-9 : $pageindex;
	$m=0;
	while ( $m<10 ) {
		if ( $i>$pages ) break;
		if ( $i>0 ) {
			$rtstr .= $i == $pageindex ? "<span>" . $i . "</span>" : '<a href="?page=' . $i . '">' . $i . "</a>";
			$m++;
		}
		$i++;
	}
	$rtstr .= $pageindex < $pages ? '<a href="?page=' . ($pageindex + 1) . '">&gt;</a><a href="?page=' . $pages . '">&gt;|</a>' : '';
	$s = $_SERVER["REQUEST_URI"];
	$s = preg_replace("/[\?&]{1}page=[0-9]*/", "", $s);
	if ( strpos($s,'?') >0 ) $rtstr = str_replace("?page=", $s . "&page=", $rtstr);
	else $rtstr = str_replace("?page=",$s."?page=",$rtstr);
	if ( $showstatus ) $rtstr .= $status;
	return $rtstr;
}

/**
 * 遍历输出数据
 */
function uPrint($ar){
	echo '<pre>';
	print_r($ar);
	echo '</pre>';
}

/**
 * 发送邮件
 */
function uMail($to,$subject,$body,$from = 'info@czzbz.com') {
	ini_set('include_path','.:/usr/local/php5/lib/php:/var/chroot/home/content/c/z/z/czzbz/html/PEAR/PEAR');
	include ('Mail.php');
	$headers = array(
		'From'=>$from,
		'To'=>$to,
		'Subject'=>'=?utf8?B?' . base64_encode($subject)  . '?=',
		'Content-type' => 'text/html; charset=utf-8'
	);
	$mail_object = Mail::factory('mail');
	$mail_res = $mail_object->send($headers['To'], $headers, $body); //发送
	if(PEAR::isError($mail_res)) { //检测错误
		echo $mail_res->getMessage();
		return false;
	}
	return true;
}