<?php
/**
 * 初始化数据以及设置环境
 *
 * 连接数据库，初始化相关数据以及设置必要的常量
 *
 * @package		PicWind
 * @author		无招之击<houbenbo@gmail> 
 * @version		0.1
 */

if ( !defined('PW_MEMORY_LIMIT') ) define('PW_MEMORY_LIMIT', '32M');

if ( function_exists('memory_get_usage') && ( (int) @ini_get('memory_limit') < abs(intval(PW_MEMORY_LIMIT)) ) )
	@ini_set('memory_limit', WP_MEMORY_LIMIT);

set_magic_quotes_runtime(0);
@ini_set('magic_quotes_sybase', 0);

if ( !defined('PW_TIMEZONE') ) define('PW_TIMEZONE', 'PRC');
if ( function_exists('date_default_timezone_set') )	date_default_timezone_set(PW_TIMEZONE);

// 是否显示调试信息
if ( defined('PW_DEBUG') && PW_DEBUG ) {
	error_reporting(E_ALL ^ E_NOTICE);
	ini_set('display_errors', 1);
} else {
	define('PW_DEBUG', false);
	ini_set('display_errors', 0);
	error_reporting(E_ERROR | E_WARNING | E_PARSE | E_USER_ERROR | E_USER_WARNING);
}

session_start();

define(PW_VER,'v_0.20_100519');
define(PW_COPY,$title);

//简化写法
$get = $_GET;
$post = $_POST;

//包含必要的文件
require(PW_INCLUDE . 'class_sqlite.php');
require(PW_INCLUDE . 'functions.php');
require(PW_INCLUDE . 'ext_picwind.php');

$pwdb = new DbSqlite(PW_ROOT . PW_DATAPATH);

$photosize = array('100','240','640','1024','o');

if ( !isset($menus) ) $menus = '';