<?php
if(!defined('IN_MK')) {
        exit('Access Denied');
}
class mk_img{
        var $new_width =  160;
        var $new_height =  120;
        var $img_info;
        var $imgdir_s = 'aaa';
        var $func;
        var $base_name ;
        function get_name(){
                $this->base_name = $this->base_name ? $this->base_name : './'.time().'_'.random(6);
                return $this->base_name;
        }
        function get_info($old_img){
                if (is_file($old_img)){
                        $this->img_info = GetImageSize($old_img);
                        if ($this->img_info['2'] == 2){
                                $this->func['create'] = 'imagecreatefromjpeg';
                                $this->func['copy'] = 'imagejpeg';
                                $this->img_info['extension'] = 'jpg';
                        }elseif ($this->img_info['2'] == 1){
                                $this->func['create'] = 'imagecreatefromgif';
                                $this->func['copy'] = 'imagegif';
                                $this->img_info['extension'] = 'gif';
                        }elseif ($this->img_info['2'] == 3){
                                $this->func['create'] = 'imagecreatefrompng';
                                $this->func['copy'] = 'imagepng';
                                $this->img_info['extension'] = 'png';
                        }else{
                                $this->error('not image file');
                        }
                }else{
                        $this->error('file no find');
                }
               
        }
        function thumb_per($img_url, $img_dir='./together/0/', $in_percent=0.35,$obj_filename=''){
                $in_percent = ($in_percent>1 || $in_percent<=0) ? 0.35 : $in_percent ;
                $this->get_info($img_url);
                if ($in_percent != 0){
                        $this->new_width = ceil($this->img_info['0'] * $in_percent);
                        $this->new_height = ceil($this->img_info['1'] * $in_percent);
                }else{
                        $this->new_width = ceil($this->img_info['0']);
                        $this->new_height = ceil($this->img_info['1']);
                }
                if ($obj_filename!=''){
                        $this->new_thumb_name = $obj_filename;
                }
                $this->create_sub($img_url,$img_dir);
                return $this->file_dir.$this->base_name.'.'.$this->img_info['extension'];
        }
        function thumb_abs($img_url, $img_dir='./together/0/', $new_width=120, $new_height=120,$obj_filename=''){
                $this->get_info($img_url);
                $this->new_width = ceil(abs($new_width))>1 ? ceil(abs($new_width)) : $this->new_width ;
                $this->new_height = ceil(abs($new_height))>1 ? ceil(abs($new_height)) : $this->new_height;
                if (($this->new_width > $this->img_info['0']) && ($this->new_height > $this->img_info['1'])){
                        $this->new_width = $this->img_info['0'];
                        $this->new_height = $this->img_info['1'];
                }else{
                        if ($this->new_width && ($this->img_info['0'] < $this->img_info['1'])) {
                                $this->new_width = ($this->new_height / $this->img_info['1']) * $this->img_info['0'];
                        } else {
                                $this->new_height = ($this->new_width / $this->img_info['0']) * $this->img_info['1'];
                        }
                }
                if ($obj_filename!=''){
                        $this->new_thumb_name = $obj_filename;
                }
                $this->create_sub($img_url,$img_dir);
                return $this->file_dir.$this->base_name.'.'.$this->img_info['extension'];
        }
        //子创建
        function create_sub($img_url,$img_dir){
                $image_o = $this->func['create']($img_url);
                if(function_exists("imagecopyresampled")){
                        $image_n = imagecreatetruecolor($this->new_width, $this->new_height);
                        imagecopyresampled($image_n, $image_o, 0, 0, 0, 0, $this->new_width, $this->new_height, $this->img_info['0'], $this->img_info['1']);
                }else{
                        $image_n = imagecreate($this->new_width, $this->new_height);
                        imagecopyresized($image_n, $image_o, 0, 0, 0, 0, $this->new_width, $this->new_height, $this->img_info['0'], $this->img_info['1']);
                }
                $this->file_dir = $this->file_dir ? $this->file_dir : $img_dir;
                $this->new_thumb_name = (!empty($this->new_thumb_name)) ? $this->new_thumb_name : $this->get_name().'_s.'.$this->img_info['extension'] ;
                        $this->func['copy']($image_n,$this->file_dir.$this->new_thumb_name);               
                imagedestroy($image_n);
                return true;
        }
        function upload($attach_value,$attach_dir='',$attach_size='1024000'){
                global $_FILES;
                if(COUNT($_FILES)==0){
                        $this->error('no files');
                }
                $this->file_error = $_FILES[$attach_value]['error'];
                if ($this->file_error != 0){
                        $this->error('upload error');
                }
                $this->file_name = $_FILES[$attach_value]['name'];
                $this->file_type = $_FILES[$attach_value]['type'];
                $this->file_size = $_FILES[$attach_value]['size'];
                $this->file_tmpname = $_FILES[$attach_value]['tmp_name'];
                $this->get_info($this->file_tmpname);

                if($attach_size && $this->file_size > $attach_size) {
                        $this->error('max size:'.$this->file_size);
                }
                if(!is_dir(MK_IMGROOT.$attach_dir)) {
                        mkdir(MK_IMGROOT.$attach_dir, 0777);
                }
                $this->file_dir = MK_IMGROOT.$attach_dir;
                $this->file_newname = $attach_dir.'/'.$this->get_name().'.'.$this->img_info['extension'];
                $this->file_thumbname = $attach_dir.'/'.$this->get_name().'_s.'.$this->img_info['extension'];
                $this->file_dirname = MK_IMGROOT.$this->file_newname;

                if(function_exists('move_uploaded_file')) {
                        if(@move_uploaded_file($this->file_tmpname, $this->file_dirname)) {
                                $attach_saved = true;
                        }
                } elseif(@copy($this->file_tmpname, $this->file_dirname)) {
                        $attach_saved = true;
                }
                $return_data = '';
                if ($attach_saved){
                        $return_data = array('name'=>$this->file_newname , 'size'=>$this->file_size , 'type'=>$this->file_type, 'ext'=>$this->img_info['extension'], 'imgdir'=>$this->file_dirname, 'thumb'=>$this->file_thumbname, 'width'=>$this->img_info['0'], 'height'=>$this->img_info['1']);
                       
                }
                return $return_data;
        }
        function watermark_img($img_url){
                        if (is_readable(MK_IMGROOT.'./watermark.png')){
                                $watermark_file = MK_IMGROOT.'./watermark.png';
                                $image_w = imagecreatefrompng($watermark_file);
                        }else{
                                $watermark_file = MK_IMGROOT.'./watermark.gif';
                                $image_w = imagecreatefromgif($watermark_file);
                        }
                $this->get_info($watermark_file);
                $watermark_width = $this->img_info['0'];
                $watermark_height = $this->img_info['1'];
                $this->get_info($img_url);
                if ($this->img_info['2'] <= 3){               
                        $image_o = $this->func['create']($img_url);
                        if (function_exists("imagecreatetruecolor")){
                                $image_n = imagecreatetruecolor($this->img_info['0'], $this->img_info['1']);
                        }else{
                                $image_n = imagecreate($this->img_info['0'], $this->img_info['1']);
                        }
                        imageCopy($image_n, $image_o, 0, 0, 0, 0, $this->img_info['0'], $this->img_info['1']);
                        unset($watermark_file);
                        $watermark_x = $this->img_info['0'] - $watermark_width;
                        $watermark_y = $this->img_info['1'] - $watermark_height;
                        imageCopy($image_n, $image_w, $watermark_x, $watermark_y, 0, 0, $watermark_width, $watermark_height);

                        $this->func['copy']($image_n,$img_url);               
                        imagedestroy($image_n);                       
                }else{
                        return false;
                }
        }
        function watermark_text($img_url,$text_message='www.7ego.cn'){
                $this->get_info($img_url);       
                if ($this->img_info['2'] <= 3){               
                        $image_o = $this->func['create']($img_url);
                        if (function_exists("imagecreatetruecolor")){
                                $image_n = imagecreatetruecolor($this->img_info['0'], $this->img_info['1']);
                        }else{
                                $image_n = imagecreate($this->img_info['0'], $this->img_info['1']);
                        }
                        imageCopy($image_n, $image_o, 0, 0, 0, 0, $this->img_info['0'], $this->img_info['1']);
                        $text_font = MK_ROOT.'en.fon';
                        $text_color = imagecolorallocate($image_n, 0, 0, 0);
                        $text_bgcolor = imagecolorallocate($image_n, 150, 150, 150);
                        $bg_color = imagecolorallocate($image_n, 250, 250, 200);
                        $text_width = imagefontwidth($text_message)*(strlen($text_message)-1)*2;
                        $text_height = imagefontheight($text_message)*2;
                        imagefilledrectangle($image_n, 2, 0, $text_width, $text_height, $bg_color);
                        @imagettftext($image_n, 2, 0, 11, 11, $text_bgcolor, $text_font, $text_message);
                        imagettftext($image_n, 2, 0, 10, 10, $text_color, $text_font, $text_message);
                        $this->func['copy']($image_n,$img_url);               
                        imagedestroy($image_n);       
                }
        }
        function autoimg($attach_value,$attach_dir='',$attach_size='1024000', $new_width=120, $new_height=120){
                $imgreturn = $this->upload($attach_value,$attach_dir,$attach_size);
                //if ($imgreturn['width']>800){
                //        $this->thumb_abs($imgreturn['imgdir'], $this->file_dir, 640, 480,$imgreturn['imgdir']);
                //}
                $this->thumb_abs($imgreturn['imgdir'], $this->file_dir, $new_width, $new_height);
                if ($imgreturn['width']>160 OR $imgreturn['height']>160){
                        $this->watermark_img($imgreturn['imgdir']);
                        $this->watermark_text($imgreturn['imgdir'],'www.7ego.cn');
                }
                return $imgreturn;
        }
        function error($msg){
                global $_MK;
                showmessage($msg,$_MK['reff']);
                function_exists('mexit') ? mexit() : exit();
        }
}
?>