<?php
define('DATAFILE', 'data/data.xml');
function ParseXml()
{
	$file = file_get_contents(DATAFILE);
	if(false == $file)
		return false;

	$str = "/<Li(.*?)email=\"([\s\S]*?)\"(.*?)date=\"([\s\S]*?)\">([\s\S]*?)<\/Li>/mi";
	if(false == preg_match_all($str, $file, $matches))
		return false;

	$re = array();
	$len = count($matches[5]);
	for($i = 0;$i < $len;$i++)
	{
		$email = $matches[2][$i];
		$date = $matches[4][$i];
		$memo = str_replace(']]>', '', str_replace('<![CDATA[', '', $matches[5][$i]));
		$re[] = array('email'=>$email, 'date'=>$date, 'memo'=>$memo);
	}

	return $re;
}

function WriteXml($data)
{
	$fp = fopen(DATAFILE, 'w');
	if(false == $fp)
		return false;

	$len = count($data);
	fwrite($fp, '<?xml version="1.0" encoding="utf-8" ?>');
	fwrite($fp, "\n");
	fwrite($fp, '<List total="' . $len . '">');
	fwrite($fp, "\n");
	foreach($data as $val)
	{
		$str = '<Li email="' . $val['email'] . '" date="' . $val['date'] . '"><![CDATA[' . $val['memo'] . ']]></Li>';
		$str .= "\n";
		fwrite($fp, $str);
	}
	fwrite($fp, '</List>');
	fclose($fp);
	return true;
}


function GetValue($key)
{
	if(isset($_REQUEST[$key]))
		return trim($_REQUEST[$key]);
}

$work = GetValue('action');

	//xml
	$email = GetValue('email');
	$memo = GetValue('memo');
	$re = ParseXml();
	if(false == $re)
	{
		unset($re);
		$re = array();
	}
	$re[] = array('email'=>$email, 'date'=>date("Y-m-d H:i", time()), 'memo'=>$memo);

	if(false == WriteXml($re))
		echo "false";

	header("location:success.html");

?>