<?php

/*
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2017 The s9e Authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Plugins\Emoji;
use s9e\TextFormatter\Plugins\ParserBase;
class Parser extends ParserBase
{
	protected $asciiRegexp = '/:[-+_a-z0-9]+(?=:)/';
	protected static $map = array('+1'=>'1f44d','-1'=>'1f44e','100'=>'1f4af','1234'=>'1f522','8ball'=>'1f3b1','a'=>'1f170','ab'=>'1f18e','abc'=>'1f524','abcd'=>'1f521','accept'=>'1f251','aerial_tramway'=>'1f6a1','afghanistan'=>'1f1e6-1f1eb','airplane'=>'2708','airplane_arriving'=>'1f6ec','airplane_departure'=>'1f6eb','airplane_small'=>'1f6e9','aland_islands'=>'1f1e6-1f1fd','alarm_clock'=>'23f0','albania'=>'1f1e6-1f1f1','alembic'=>'2697','algeria'=>'1f1e9-1f1ff','alien'=>'1f47d','ambulance'=>'1f691','american_samoa'=>'1f1e6-1f1f8','amphora'=>'1f3fa','anchor'=>'2693','andorra'=>'1f1e6-1f1e9','angel'=>'1f47c','angel_tone1'=>'1f47c-1f3fb','angel_tone2'=>'1f47c-1f3fc','angel_tone3'=>'1f47c-1f3fd','angel_tone4'=>'1f47c-1f3fe','angel_tone5'=>'1f47c-1f3ff','anger'=>'1f4a2','anger_right'=>'1f5ef','angola'=>'1f1e6-1f1f4','angry'=>'1f620','anguilla'=>'1f1e6-1f1ee','anguished'=>'1f627','ant'=>'1f41c','antarctica'=>'1f1e6-1f1f6','antigua_barbuda'=>'1f1e6-1f1ec','apple'=>'1f34e','aquarius'=>'2652','argentina'=>'1f1e6-1f1f7','aries'=>'2648','armenia'=>'1f1e6-1f1f2','arrow_backward'=>'25c0','arrow_double_down'=>'23ec','arrow_double_up'=>'23eb','arrow_down'=>'2b07','arrow_down_small'=>'1f53d','arrow_forward'=>'25b6','arrow_heading_down'=>'2935','arrow_heading_up'=>'2934','arrow_left'=>'2b05','arrow_lower_left'=>'2199','arrow_lower_right'=>'2198','arrow_right'=>'27a1','arrow_right_hook'=>'21aa','arrow_up'=>'2b06','arrow_up_down'=>'2195','arrow_up_small'=>'1f53c','arrow_upper_left'=>'2196','arrow_upper_right'=>'2197','arrows_clockwise'=>'1f503','arrows_counterclockwise'=>'1f504','art'=>'1f3a8','articulated_lorry'=>'1f69b','artificial_satellite'=>'1f6f0','aruba'=>'1f1e6-1f1fc','asterisk'=>'002a-20e3','astonished'=>'1f632','athletic_shoe'=>'1f45f','atm'=>'1f3e7','atom'=>'269b','atom_symbol'=>'269b','australia'=>'1f1e6-1f1fa','austria'=>'1f1e6-1f1f9','avocado'=>'1f951','azerbaijan'=>'1f1e6-1f1ff','b'=>'1f171','baby'=>'1f476','baby_bottle'=>'1f37c','baby_chick'=>'1f424','baby_symbol'=>'1f6bc','baby_tone1'=>'1f476-1f3fb','baby_tone2'=>'1f476-1f3fc','baby_tone3'=>'1f476-1f3fd','baby_tone4'=>'1f476-1f3fe','baby_tone5'=>'1f476-1f3ff','back'=>'1f519','bacon'=>'1f953','badminton'=>'1f3f8','baggage_claim'=>'1f6c4','bahamas'=>'1f1e7-1f1f8','bahrain'=>'1f1e7-1f1ed','balance_scale'=>'2696','balloon'=>'1f388','ballot_box'=>'1f5f3','ballot_box_with_check'=>'2611','bamboo'=>'1f38d','banana'=>'1f34c','bangbang'=>'203c','bangladesh'=>'1f1e7-1f1e9','bank'=>'1f3e6','bar_chart'=>'1f4ca','barbados'=>'1f1e7-1f1e7','barber'=>'1f488','baseball'=>'26be','basketball'=>'1f3c0','basketball_man'=>'26f9','basketball_player'=>'26f9','basketball_player_tone1'=>'26f9-1f3fb','basketball_player_tone2'=>'26f9-1f3fc','basketball_player_tone3'=>'26f9-1f3fd','basketball_player_tone4'=>'26f9-1f3fe','basketball_player_tone5'=>'26f9-1f3ff','bat'=>'1f987','bath'=>'1f6c0','bath_tone1'=>'1f6c0-1f3fb','bath_tone2'=>'1f6c0-1f3fc','bath_tone3'=>'1f6c0-1f3fd','bath_tone4'=>'1f6c0-1f3fe','bath_tone5'=>'1f6c0-1f3ff','bathtub'=>'1f6c1','battery'=>'1f50b','beach'=>'1f3d6','beach_umbrella'=>'26f1','bear'=>'1f43b','bed'=>'1f6cf','bee'=>'1f41d','beer'=>'1f37a','beers'=>'1f37b','beetle'=>'1f41e','beginner'=>'1f530','belarus'=>'1f1e7-1f1fe','belgium'=>'1f1e7-1f1ea','belize'=>'1f1e7-1f1ff','bell'=>'1f514','bellhop'=>'1f6ce','bellhop_bell'=>'1f6ce','benin'=>'1f1e7-1f1ef','bento'=>'1f371','bermuda'=>'1f1e7-1f1f2','bhutan'=>'1f1e7-1f1f9','bicyclist'=>'1f6b4','bicyclist_tone1'=>'1f6b4-1f3fb','bicyclist_tone2'=>'1f6b4-1f3fc','bicyclist_tone3'=>'1f6b4-1f3fd','bicyclist_tone4'=>'1f6b4-1f3fe','bicyclist_tone5'=>'1f6b4-1f3ff','bike'=>'1f6b2','biking_man'=>'1f6b4','bikini'=>'1f459','biohazard'=>'2623','bird'=>'1f426','birthday'=>'1f382','black_circle'=>'26ab','black_flag'=>'1f3f4','black_heart'=>'1f5a4','black_joker'=>'1f0cf','black_large_square'=>'2b1b','black_medium_small_square'=>'25fe','black_medium_square'=>'25fc','black_nib'=>'2712','black_small_square'=>'25aa','black_square_button'=>'1f532','blonde_man'=>'1f471','blossom'=>'1f33c','blowfish'=>'1f421','blue_book'=>'1f4d8','blue_car'=>'1f699','blue_circle'=>'1f535','blue_heart'=>'1f499','blush'=>'1f60a','boar'=>'1f417','boat'=>'26f5','bolivia'=>'1f1e7-1f1f4','bomb'=>'1f4a3','book'=>'1f4d6','bookmark'=>'1f516','bookmark_tabs'=>'1f4d1','books'=>'1f4da','boom'=>'1f4a5','boot'=>'1f462','bosnia_herzegovina'=>'1f1e7-1f1e6','botswana'=>'1f1e7-1f1fc','bouquet'=>'1f490','bow'=>'1f647','bow_and_arrow'=>'1f3f9','bow_tone1'=>'1f647-1f3fb','bow_tone2'=>'1f647-1f3fc','bow_tone3'=>'1f647-1f3fd','bow_tone4'=>'1f647-1f3fe','bow_tone5'=>'1f647-1f3ff','bowing_man'=>'1f647','bowling'=>'1f3b3','boxing_glove'=>'1f94a','boy'=>'1f466','boy_tone1'=>'1f466-1f3fb','boy_tone2'=>'1f466-1f3fc','boy_tone3'=>'1f466-1f3fd','boy_tone4'=>'1f466-1f3fe','boy_tone5'=>'1f466-1f3ff','brazil'=>'1f1e7-1f1f7','bread'=>'1f35e','bride_with_veil'=>'1f470','bride_with_veil_tone1'=>'1f470-1f3fb','bride_with_veil_tone2'=>'1f470-1f3fc','bride_with_veil_tone3'=>'1f470-1f3fd','bride_with_veil_tone4'=>'1f470-1f3fe','bride_with_veil_tone5'=>'1f470-1f3ff','bridge_at_night'=>'1f309','briefcase'=>'1f4bc','british_indian_ocean_territory'=>'1f1ee-1f1f4','british_virgin_islands'=>'1f1fb-1f1ec','broken_heart'=>'1f494','brunei'=>'1f1e7-1f1f3','bug'=>'1f41b','building_construction'=>'1f3d7','bulb'=>'1f4a1','bulgaria'=>'1f1e7-1f1ec','bullettrain_front'=>'1f685','bullettrain_side'=>'1f684','burkina_faso'=>'1f1e7-1f1eb','burrito'=>'1f32f','burundi'=>'1f1e7-1f1ee','bus'=>'1f68c','business_suit_levitating'=>'1f574','busstop'=>'1f68f','bust_in_silhouette'=>'1f464','busts_in_silhouette'=>'1f465','butterfly'=>'1f98b','cactus'=>'1f335','cake'=>'1f370','calendar'=>'1f4c6','calendar_spiral'=>'1f5d3','call_me'=>'1f919','call_me_tone1'=>'1f919-1f3fb','call_me_tone2'=>'1f919-1f3fc','call_me_tone3'=>'1f919-1f3fd','call_me_tone4'=>'1f919-1f3fe','call_me_tone5'=>'1f919-1f3ff','calling'=>'1f4f2','cambodia'=>'1f1f0-1f1ed','camel'=>'1f42b','camera'=>'1f4f7','camera_flash'=>'1f4f8','camera_with_flash'=>'1f4f8','cameroon'=>'1f1e8-1f1f2','camping'=>'1f3d5','canada'=>'1f1e8-1f1e6','canary_islands'=>'1f1ee-1f1e8','cancer'=>'264b','candle'=>'1f56f','candy'=>'1f36c','canoe'=>'1f6f6','cape_verde'=>'1f1e8-1f1fb','capital_abcd'=>'1f520','capricorn'=>'2651','car'=>'1f697','card_box'=>'1f5c3','card_file_box'=>'1f5c3','card_index'=>'1f4c7','card_index_dividers'=>'1f5c2','caribbean_netherlands'=>'1f1e7-1f1f6','carousel_horse'=>'1f3a0','carrot'=>'1f955','cartwheel'=>'1f938','cartwheel_tone1'=>'1f938-1f3fb','cartwheel_tone2'=>'1f938-1f3fc','cartwheel_tone3'=>'1f938-1f3fd','cartwheel_tone4'=>'1f938-1f3fe','cartwheel_tone5'=>'1f938-1f3ff','cat'=>'1f431','cat2'=>'1f408','cayman_islands'=>'1f1f0-1f1fe','cd'=>'1f4bf','central_african_republic'=>'1f1e8-1f1eb','chad'=>'1f1f9-1f1e9','chains'=>'26d3','champagne'=>'1f37e','champagne_glass'=>'1f942','chart'=>'1f4b9','chart_with_downwards_trend'=>'1f4c9','chart_with_upwards_trend'=>'1f4c8','checkered_flag'=>'1f3c1','cheese'=>'1f9c0','cherries'=>'1f352','cherry_blossom'=>'1f338','chestnut'=>'1f330','chicken'=>'1f414','children_crossing'=>'1f6b8','chile'=>'1f1e8-1f1f1','chipmunk'=>'1f43f','chocolate_bar'=>'1f36b','christmas_island'=>'1f1e8-1f1fd','christmas_tree'=>'1f384','church'=>'26ea','cinema'=>'1f3a6','circus_tent'=>'1f3aa','city_dusk'=>'1f306','city_sunrise'=>'1f307','city_sunset'=>'1f307','cityscape'=>'1f3d9','cl'=>'1f191','clamp'=>'1f5dc','clap'=>'1f44f','clap_tone1'=>'1f44f-1f3fb','clap_tone2'=>'1f44f-1f3fc','clap_tone3'=>'1f44f-1f3fd','clap_tone4'=>'1f44f-1f3fe','clap_tone5'=>'1f44f-1f3ff','clapper'=>'1f3ac','classical_building'=>'1f3db','clipboard'=>'1f4cb','clock'=>'1f570','clock1'=>'1f550','clock10'=>'1f559','clock1030'=>'1f565','clock11'=>'1f55a','clock1130'=>'1f566','clock12'=>'1f55b','clock1230'=>'1f567','clock130'=>'1f55c','clock2'=>'1f551','clock230'=>'1f55d','clock3'=>'1f552','clock330'=>'1f55e','clock4'=>'1f553','clock430'=>'1f55f','clock5'=>'1f554','clock530'=>'1f560','clock6'=>'1f555','clock630'=>'1f561','clock7'=>'1f556','clock730'=>'1f562','clock8'=>'1f557','clock830'=>'1f563','clock9'=>'1f558','clock930'=>'1f564','closed_book'=>'1f4d5','closed_lock_with_key'=>'1f510','closed_umbrella'=>'1f302','cloud'=>'2601','cloud_lightning'=>'1f329','cloud_rain'=>'1f327','cloud_snow'=>'1f328','cloud_tornado'=>'1f32a','cloud_with_lightning'=>'1f329','cloud_with_lightning_and_rain'=>'26c8','cloud_with_rain'=>'1f327','cloud_with_snow'=>'1f328','clown'=>'1f921','clubs'=>'2663','cn'=>'1f1e8-1f1f3','cocktail'=>'1f378','cocos_islands'=>'1f1e8-1f1e8','coffee'=>'2615','coffin'=>'26b0','cold_sweat'=>'1f630','collision'=>'1f4a5','colombia'=>'1f1e8-1f1f4','comet'=>'2604','comoros'=>'1f1f0-1f1f2','compression'=>'1f5dc','computer'=>'1f4bb','computer_mouse'=>'1f5b1','confetti_ball'=>'1f38a','confounded'=>'1f616','confused'=>'1f615','congo_brazzaville'=>'1f1e8-1f1ec','congo_kinshasa'=>'1f1e8-1f1e9','congratulations'=>'3297','construction'=>'1f6a7','construction_site'=>'1f3d7','construction_worker'=>'1f477','construction_worker_man'=>'1f477','construction_worker_tone1'=>'1f477-1f3fb','construction_worker_tone2'=>'1f477-1f3fc','construction_worker_tone3'=>'1f477-1f3fd','construction_worker_tone4'=>'1f477-1f3fe','construction_worker_tone5'=>'1f477-1f3ff','control_knobs'=>'1f39b','convenience_store'=>'1f3ea','cook_islands'=>'1f1e8-1f1f0','cookie'=>'1f36a','cooking'=>'1f373','cool'=>'1f192','cop'=>'1f46e','cop_tone1'=>'1f46e-1f3fb','cop_tone2'=>'1f46e-1f3fc','cop_tone3'=>'1f46e-1f3fd','cop_tone4'=>'1f46e-1f3fe','cop_tone5'=>'1f46e-1f3ff','copyright'=>'00a9','corn'=>'1f33d','costa_rica'=>'1f1e8-1f1f7','cote_divoire'=>'1f1e8-1f1ee','couch'=>'1f6cb','couch_and_lamp'=>'1f6cb','couple'=>'1f46b','couple_mm'=>'1f468-2764-1f468','couple_with_heart'=>'1f491','couple_with_heart_man_man'=>'1f468-2764-1f468','couple_with_heart_woman_man'=>'1f491','couple_with_heart_woman_woman'=>'1f469-2764-1f469','couple_ww'=>'1f469-2764-1f469','couplekiss'=>'1f48f','couplekiss_man_man'=>'1f468-2764-1f48b-1f468','couplekiss_man_woman'=>'1f48f','couplekiss_woman_woman'=>'1f469-2764-1f48b-1f469','cow'=>'1f42e','cow2'=>'1f404','cowboy'=>'1f920','crab'=>'1f980','crayon'=>'1f58d','credit_card'=>'1f4b3','crescent_moon'=>'1f319','cricket'=>'1f3cf','croatia'=>'1f1ed-1f1f7','crocodile'=>'1f40a','croissant'=>'1f950','cross'=>'271d','crossed_flags'=>'1f38c','crossed_swords'=>'2694','crown'=>'1f451','cruise_ship'=>'1f6f3','cry'=>'1f622','crying_cat_face'=>'1f63f','crystal_ball'=>'1f52e','cuba'=>'1f1e8-1f1fa','cucumber'=>'1f952','cupid'=>'1f498','curacao'=>'1f1e8-1f1fc','curly_loop'=>'27b0','currency_exchange'=>'1f4b1','curry'=>'1f35b','custard'=>'1f36e','customs'=>'1f6c3','cyclone'=>'1f300','cyprus'=>'1f1e8-1f1fe','czech_republic'=>'1f1e8-1f1ff','dagger'=>'1f5e1','dancer'=>'1f483','dancer_tone1'=>'1f483-1f3fb','dancer_tone2'=>'1f483-1f3fc','dancer_tone3'=>'1f483-1f3fd','dancer_tone4'=>'1f483-1f3fe','dancer_tone5'=>'1f483-1f3ff','dancers'=>'1f46f','dancing_women'=>'1f46f','dango'=>'1f361','dark_sunglasses'=>'1f576','dart'=>'1f3af','dash'=>'1f4a8','date'=>'1f4c5','de'=>'1f1e9-1f1ea','deciduous_tree'=>'1f333','deer'=>'1f98c','denmark'=>'1f1e9-1f1f0','department_store'=>'1f3ec','derelict_house'=>'1f3da','desert'=>'1f3dc','desert_island'=>'1f3dd','desktop'=>'1f5a5','desktop_computer'=>'1f5a5','detective'=>'1f575','diamond_shape_with_a_dot_inside'=>'1f4a0','diamonds'=>'2666','disappointed'=>'1f61e','disappointed_relieved'=>'1f625','dividers'=>'1f5c2','dizzy'=>'1f4ab','dizzy_face'=>'1f635','djibouti'=>'1f1e9-1f1ef','do_not_litter'=>'1f6af','dog'=>'1f436','dog2'=>'1f415','dollar'=>'1f4b5','dolls'=>'1f38e','dolphin'=>'1f42c','dominica'=>'1f1e9-1f1f2','dominican_republic'=>'1f1e9-1f1f4','door'=>'1f6aa','doughnut'=>'1f369','dove'=>'1f54a','dragon'=>'1f409','dragon_face'=>'1f432','dress'=>'1f457','dromedary_camel'=>'1f42a','drooling_face'=>'1f924','droplet'=>'1f4a7','drum'=>'1f941','duck'=>'1f986','dvd'=>'1f4c0','e-mail'=>'1f4e7','eagle'=>'1f985','ear'=>'1f442','ear_of_rice'=>'1f33e','ear_tone1'=>'1f442-1f3fb','ear_tone2'=>'1f442-1f3fc','ear_tone3'=>'1f442-1f3fd','ear_tone4'=>'1f442-1f3fe','ear_tone5'=>'1f442-1f3ff','earth_africa'=>'1f30d','earth_americas'=>'1f30e','earth_asia'=>'1f30f','ecuador'=>'1f1ea-1f1e8','egg'=>'1f95a','eggplant'=>'1f346','egypt'=>'1f1ea-1f1ec','eight'=>'0038-20e3','eight_pointed_black_star'=>'2734','eight_spoked_asterisk'=>'2733','eject'=>'23cf','el_salvador'=>'1f1f8-1f1fb','electric_plug'=>'1f50c','elephant'=>'1f418','email'=>'2709','end'=>'1f51a','envelope'=>'2709','envelope_with_arrow'=>'1f4e9','equatorial_guinea'=>'1f1ec-1f1f6','eritrea'=>'1f1ea-1f1f7','es'=>'1f1ea-1f1f8','estonia'=>'1f1ea-1f1ea','ethiopia'=>'1f1ea-1f1f9','eu'=>'1f1ea-1f1fa','euro'=>'1f4b6','european_castle'=>'1f3f0','european_post_office'=>'1f3e4','european_union'=>'1f1ea-1f1fa','evergreen_tree'=>'1f332','exclamation'=>'2757','expressionless'=>'1f611','eye'=>'1f441','eye_in_speech_bubble'=>'1f441-1f5e8','eye_speech_bubble'=>'1f441-1f5e8','eyeglasses'=>'1f453','eyes'=>'1f440','face_palm'=>'1f926','face_palm_tone1'=>'1f926-1f3fb','face_palm_tone2'=>'1f926-1f3fc','face_palm_tone3'=>'1f926-1f3fd','face_palm_tone4'=>'1f926-1f3fe','face_palm_tone5'=>'1f926-1f3ff','face_with_head_bandage'=>'1f915','face_with_thermometer'=>'1f912','facepunch'=>'1f44a','factory'=>'1f3ed','falkland_islands'=>'1f1eb-1f1f0','fallen_leaf'=>'1f342','family'=>'1f46a','family_man_man_boy'=>'1f468-1f468-1f466','family_man_man_boy_boy'=>'1f468-1f468-1f466-1f466','family_man_man_girl'=>'1f468-1f468-1f467','family_man_man_girl_boy'=>'1f468-1f468-1f467-1f466','family_man_man_girl_girl'=>'1f468-1f468-1f467-1f467','family_man_woman_boy'=>'1f46a','family_man_woman_boy_boy'=>'1f468-1f469-1f466-1f466','family_man_woman_girl'=>'1f468-1f469-1f467','family_man_woman_girl_boy'=>'1f468-1f469-1f467-1f466','family_man_woman_girl_girl'=>'1f468-1f469-1f467-1f467','family_mmb'=>'1f468-1f468-1f466','family_mmbb'=>'1f468-1f468-1f466-1f466','family_mmg'=>'1f468-1f468-1f467','family_mmgb'=>'1f468-1f468-1f467-1f466','family_mmgg'=>'1f468-1f468-1f467-1f467','family_mwbb'=>'1f468-1f469-1f466-1f466','family_mwg'=>'1f468-1f469-1f467','family_mwgb'=>'1f468-1f469-1f467-1f466','family_mwgg'=>'1f468-1f469-1f467-1f467','family_woman_woman_boy'=>'1f469-1f469-1f466','family_woman_woman_boy_boy'=>'1f469-1f469-1f466-1f466','family_woman_woman_girl'=>'1f469-1f469-1f467','family_woman_woman_girl_boy'=>'1f469-1f469-1f467-1f466','family_woman_woman_girl_girl'=>'1f469-1f469-1f467-1f467','family_wwb'=>'1f469-1f469-1f466','family_wwbb'=>'1f469-1f469-1f466-1f466','family_wwg'=>'1f469-1f469-1f467','family_wwgb'=>'1f469-1f469-1f467-1f466','family_wwgg'=>'1f469-1f469-1f467-1f467','faroe_islands'=>'1f1eb-1f1f4','fast_forward'=>'23e9','fax'=>'1f4e0','fearful'=>'1f628','feet'=>'1f43e','fencer'=>'1f93a','ferris_wheel'=>'1f3a1','ferry'=>'26f4','field_hockey'=>'1f3d1','fiji'=>'1f1eb-1f1ef','file_cabinet'=>'1f5c4','file_folder'=>'1f4c1','film_frames'=>'1f39e','film_projector'=>'1f4fd','film_strip'=>'1f39e','fingers_crossed'=>'1f91e','fingers_crossed_tone1'=>'1f91e-1f3fb','fingers_crossed_tone2'=>'1f91e-1f3fc','fingers_crossed_tone3'=>'1f91e-1f3fd','fingers_crossed_tone4'=>'1f91e-1f3fe','fingers_crossed_tone5'=>'1f91e-1f3ff','finland'=>'1f1eb-1f1ee','fire'=>'1f525','fire_engine'=>'1f692','fireworks'=>'1f386','first_place'=>'1f947','first_quarter_moon'=>'1f313','first_quarter_moon_with_face'=>'1f31b','fish'=>'1f41f','fish_cake'=>'1f365','fishing_pole_and_fish'=>'1f3a3','fist'=>'270a','fist_tone1'=>'270a-1f3fb','fist_tone2'=>'270a-1f3fc','fist_tone3'=>'270a-1f3fd','fist_tone4'=>'270a-1f3fe','fist_tone5'=>'270a-1f3ff','five'=>'0035-20e3','flag_ac'=>'1f1e6-1f1e8','flag_ad'=>'1f1e6-1f1e9','flag_ae'=>'1f1e6-1f1ea','flag_af'=>'1f1e6-1f1eb','flag_ag'=>'1f1e6-1f1ec','flag_ai'=>'1f1e6-1f1ee','flag_al'=>'1f1e6-1f1f1','flag_am'=>'1f1e6-1f1f2','flag_ao'=>'1f1e6-1f1f4','flag_aq'=>'1f1e6-1f1f6','flag_ar'=>'1f1e6-1f1f7','flag_as'=>'1f1e6-1f1f8','flag_at'=>'1f1e6-1f1f9','flag_au'=>'1f1e6-1f1fa','flag_aw'=>'1f1e6-1f1fc','flag_ax'=>'1f1e6-1f1fd','flag_az'=>'1f1e6-1f1ff','flag_ba'=>'1f1e7-1f1e6','flag_bb'=>'1f1e7-1f1e7','flag_bd'=>'1f1e7-1f1e9','flag_be'=>'1f1e7-1f1ea','flag_bf'=>'1f1e7-1f1eb','flag_bg'=>'1f1e7-1f1ec','flag_bh'=>'1f1e7-1f1ed','flag_bi'=>'1f1e7-1f1ee','flag_bj'=>'1f1e7-1f1ef','flag_bl'=>'1f1e7-1f1f1','flag_black'=>'1f3f4','flag_bm'=>'1f1e7-1f1f2','flag_bn'=>'1f1e7-1f1f3','flag_bo'=>'1f1e7-1f1f4','flag_bq'=>'1f1e7-1f1f6','flag_br'=>'1f1e7-1f1f7','flag_bs'=>'1f1e7-1f1f8','flag_bt'=>'1f1e7-1f1f9','flag_bv'=>'1f1e7-1f1fb','flag_bw'=>'1f1e7-1f1fc','flag_by'=>'1f1e7-1f1fe','flag_bz'=>'1f1e7-1f1ff','flag_ca'=>'1f1e8-1f1e6','flag_cc'=>'1f1e8-1f1e8','flag_cd'=>'1f1e8-1f1e9','flag_cf'=>'1f1e8-1f1eb','flag_cg'=>'1f1e8-1f1ec','flag_ch'=>'1f1e8-1f1ed','flag_ci'=>'1f1e8-1f1ee','flag_ck'=>'1f1e8-1f1f0','flag_cl'=>'1f1e8-1f1f1','flag_cm'=>'1f1e8-1f1f2','flag_cn'=>'1f1e8-1f1f3','flag_co'=>'1f1e8-1f1f4','flag_cp'=>'1f1e8-1f1f5','flag_cr'=>'1f1e8-1f1f7','flag_cu'=>'1f1e8-1f1fa','flag_cv'=>'1f1e8-1f1fb','flag_cw'=>'1f1e8-1f1fc','flag_cx'=>'1f1e8-1f1fd','flag_cy'=>'1f1e8-1f1fe','flag_cz'=>'1f1e8-1f1ff','flag_de'=>'1f1e9-1f1ea','flag_dg'=>'1f1e9-1f1ec','flag_dj'=>'1f1e9-1f1ef','flag_dk'=>'1f1e9-1f1f0','flag_dm'=>'1f1e9-1f1f2','flag_do'=>'1f1e9-1f1f4','flag_dz'=>'1f1e9-1f1ff','flag_ea'=>'1f1ea-1f1e6','flag_ec'=>'1f1ea-1f1e8','flag_ee'=>'1f1ea-1f1ea','flag_eg'=>'1f1ea-1f1ec','flag_eh'=>'1f1ea-1f1ed','flag_er'=>'1f1ea-1f1f7','flag_es'=>'1f1ea-1f1f8','flag_et'=>'1f1ea-1f1f9','flag_eu'=>'1f1ea-1f1fa','flag_fi'=>'1f1eb-1f1ee','flag_fj'=>'1f1eb-1f1ef','flag_fk'=>'1f1eb-1f1f0','flag_fm'=>'1f1eb-1f1f2','flag_fo'=>'1f1eb-1f1f4','flag_fr'=>'1f1eb-1f1f7','flag_ga'=>'1f1ec-1f1e6','flag_gb'=>'1f1ec-1f1e7','flag_gd'=>'1f1ec-1f1e9','flag_ge'=>'1f1ec-1f1ea','flag_gf'=>'1f1ec-1f1eb','flag_gg'=>'1f1ec-1f1ec','flag_gh'=>'1f1ec-1f1ed','flag_gi'=>'1f1ec-1f1ee','flag_gl'=>'1f1ec-1f1f1','flag_gm'=>'1f1ec-1f1f2','flag_gn'=>'1f1ec-1f1f3','flag_gp'=>'1f1ec-1f1f5','flag_gq'=>'1f1ec-1f1f6','flag_gr'=>'1f1ec-1f1f7','flag_gs'=>'1f1ec-1f1f8','flag_gt'=>'1f1ec-1f1f9','flag_gu'=>'1f1ec-1f1fa','flag_gw'=>'1f1ec-1f1fc','flag_gy'=>'1f1ec-1f1fe','flag_hk'=>'1f1ed-1f1f0','flag_hm'=>'1f1ed-1f1f2','flag_hn'=>'1f1ed-1f1f3','flag_hr'=>'1f1ed-1f1f7','flag_ht'=>'1f1ed-1f1f9','flag_hu'=>'1f1ed-1f1fa','flag_ic'=>'1f1ee-1f1e8','flag_id'=>'1f1ee-1f1e9','flag_ie'=>'1f1ee-1f1ea','flag_il'=>'1f1ee-1f1f1','flag_im'=>'1f1ee-1f1f2','flag_in'=>'1f1ee-1f1f3','flag_io'=>'1f1ee-1f1f4','flag_iq'=>'1f1ee-1f1f6','flag_ir'=>'1f1ee-1f1f7','flag_is'=>'1f1ee-1f1f8','flag_it'=>'1f1ee-1f1f9','flag_je'=>'1f1ef-1f1ea','flag_jm'=>'1f1ef-1f1f2','flag_jo'=>'1f1ef-1f1f4','flag_jp'=>'1f1ef-1f1f5','flag_ke'=>'1f1f0-1f1ea','flag_kg'=>'1f1f0-1f1ec','flag_kh'=>'1f1f0-1f1ed','flag_ki'=>'1f1f0-1f1ee','flag_km'=>'1f1f0-1f1f2','flag_kn'=>'1f1f0-1f1f3','flag_kp'=>'1f1f0-1f1f5','flag_kr'=>'1f1f0-1f1f7','flag_kw'=>'1f1f0-1f1fc','flag_ky'=>'1f1f0-1f1fe','flag_kz'=>'1f1f0-1f1ff','flag_la'=>'1f1f1-1f1e6','flag_lb'=>'1f1f1-1f1e7','flag_lc'=>'1f1f1-1f1e8','flag_li'=>'1f1f1-1f1ee','flag_lk'=>'1f1f1-1f1f0','flag_lr'=>'1f1f1-1f1f7','flag_ls'=>'1f1f1-1f1f8','flag_lt'=>'1f1f1-1f1f9','flag_lu'=>'1f1f1-1f1fa','flag_lv'=>'1f1f1-1f1fb','flag_ly'=>'1f1f1-1f1fe','flag_ma'=>'1f1f2-1f1e6','flag_mc'=>'1f1f2-1f1e8','flag_md'=>'1f1f2-1f1e9','flag_me'=>'1f1f2-1f1ea','flag_mf'=>'1f1f2-1f1eb','flag_mg'=>'1f1f2-1f1ec','flag_mh'=>'1f1f2-1f1ed','flag_mk'=>'1f1f2-1f1f0','flag_ml'=>'1f1f2-1f1f1','flag_mm'=>'1f1f2-1f1f2','flag_mn'=>'1f1f2-1f1f3','flag_mo'=>'1f1f2-1f1f4','flag_mp'=>'1f1f2-1f1f5','flag_mq'=>'1f1f2-1f1f6','flag_mr'=>'1f1f2-1f1f7','flag_ms'=>'1f1f2-1f1f8','flag_mt'=>'1f1f2-1f1f9','flag_mu'=>'1f1f2-1f1fa','flag_mv'=>'1f1f2-1f1fb','flag_mw'=>'1f1f2-1f1fc','flag_mx'=>'1f1f2-1f1fd','flag_my'=>'1f1f2-1f1fe','flag_mz'=>'1f1f2-1f1ff','flag_na'=>'1f1f3-1f1e6','flag_nc'=>'1f1f3-1f1e8','flag_ne'=>'1f1f3-1f1ea','flag_nf'=>'1f1f3-1f1eb','flag_ng'=>'1f1f3-1f1ec','flag_ni'=>'1f1f3-1f1ee','flag_nl'=>'1f1f3-1f1f1','flag_no'=>'1f1f3-1f1f4','flag_np'=>'1f1f3-1f1f5','flag_nr'=>'1f1f3-1f1f7','flag_nu'=>'1f1f3-1f1fa','flag_nz'=>'1f1f3-1f1ff','flag_om'=>'1f1f4-1f1f2','flag_pa'=>'1f1f5-1f1e6','flag_pe'=>'1f1f5-1f1ea','flag_pf'=>'1f1f5-1f1eb','flag_pg'=>'1f1f5-1f1ec','flag_ph'=>'1f1f5-1f1ed','flag_pk'=>'1f1f5-1f1f0','flag_pl'=>'1f1f5-1f1f1','flag_pm'=>'1f1f5-1f1f2','flag_pn'=>'1f1f5-1f1f3','flag_pr'=>'1f1f5-1f1f7','flag_ps'=>'1f1f5-1f1f8','flag_pt'=>'1f1f5-1f1f9','flag_pw'=>'1f1f5-1f1fc','flag_py'=>'1f1f5-1f1fe','flag_qa'=>'1f1f6-1f1e6','flag_re'=>'1f1f7-1f1ea','flag_ro'=>'1f1f7-1f1f4','flag_rs'=>'1f1f7-1f1f8','flag_ru'=>'1f1f7-1f1fa','flag_rw'=>'1f1f7-1f1fc','flag_sa'=>'1f1f8-1f1e6','flag_sb'=>'1f1f8-1f1e7','flag_sc'=>'1f1f8-1f1e8','flag_sd'=>'1f1f8-1f1e9','flag_se'=>'1f1f8-1f1ea','flag_sg'=>'1f1f8-1f1ec','flag_sh'=>'1f1f8-1f1ed','flag_si'=>'1f1f8-1f1ee','flag_sj'=>'1f1f8-1f1ef','flag_sk'=>'1f1f8-1f1f0','flag_sl'=>'1f1f8-1f1f1','flag_sm'=>'1f1f8-1f1f2','flag_sn'=>'1f1f8-1f1f3','flag_so'=>'1f1f8-1f1f4','flag_sr'=>'1f1f8-1f1f7','flag_ss'=>'1f1f8-1f1f8','flag_st'=>'1f1f8-1f1f9','flag_sv'=>'1f1f8-1f1fb','flag_sx'=>'1f1f8-1f1fd','flag_sy'=>'1f1f8-1f1fe','flag_sz'=>'1f1f8-1f1ff','flag_ta'=>'1f1f9-1f1e6','flag_tc'=>'1f1f9-1f1e8','flag_td'=>'1f1f9-1f1e9','flag_tf'=>'1f1f9-1f1eb','flag_tg'=>'1f1f9-1f1ec','flag_th'=>'1f1f9-1f1ed','flag_tj'=>'1f1f9-1f1ef','flag_tk'=>'1f1f9-1f1f0','flag_tl'=>'1f1f9-1f1f1','flag_tm'=>'1f1f9-1f1f2','flag_tn'=>'1f1f9-1f1f3','flag_to'=>'1f1f9-1f1f4','flag_tr'=>'1f1f9-1f1f7','flag_tt'=>'1f1f9-1f1f9','flag_tv'=>'1f1f9-1f1fb','flag_tw'=>'1f1f9-1f1fc','flag_tz'=>'1f1f9-1f1ff','flag_ua'=>'1f1fa-1f1e6','flag_ug'=>'1f1fa-1f1ec','flag_um'=>'1f1fa-1f1f2','flag_us'=>'1f1fa-1f1f8','flag_uy'=>'1f1fa-1f1fe','flag_uz'=>'1f1fa-1f1ff','flag_va'=>'1f1fb-1f1e6','flag_vc'=>'1f1fb-1f1e8','flag_ve'=>'1f1fb-1f1ea','flag_vg'=>'1f1fb-1f1ec','flag_vi'=>'1f1fb-1f1ee','flag_vn'=>'1f1fb-1f1f3','flag_vu'=>'1f1fb-1f1fa','flag_wf'=>'1f1fc-1f1eb','flag_white'=>'1f3f3','flag_ws'=>'1f1fc-1f1f8','flag_xk'=>'1f1fd-1f1f0','flag_ye'=>'1f1fe-1f1ea','flag_yt'=>'1f1fe-1f1f9','flag_za'=>'1f1ff-1f1e6','flag_zm'=>'1f1ff-1f1f2','flag_zw'=>'1f1ff-1f1fc','flags'=>'1f38f','flashlight'=>'1f526','fleur-de-lis'=>'269c','fleur_de_lis'=>'269c','flight_arrival'=>'1f6ec','flight_departure'=>'1f6eb','flipper'=>'1f42c','floppy_disk'=>'1f4be','flower_playing_cards'=>'1f3b4','flushed'=>'1f633','fog'=>'1f32b','foggy'=>'1f301','football'=>'1f3c8','footprints'=>'1f463','fork_and_knife'=>'1f374','fork_knife_plate'=>'1f37d','fountain'=>'26f2','fountain_pen'=>'1f58b','four'=>'0034-20e3','four_leaf_clover'=>'1f340','fox'=>'1f98a','fr'=>'1f1eb-1f1f7','frame_photo'=>'1f5bc','framed_picture'=>'1f5bc','free'=>'1f193','french_bread'=>'1f956','french_guiana'=>'1f1ec-1f1eb','french_polynesia'=>'1f1f5-1f1eb','french_southern_territories'=>'1f1f9-1f1eb','fried_shrimp'=>'1f364','fries'=>'1f35f','frog'=>'1f438','frowning'=>'1f626','frowning2'=>'2639','frowning_face'=>'2639','frowning_woman'=>'1f64d','fu'=>'1f595','fuelpump'=>'26fd','full_moon'=>'1f315','full_moon_with_face'=>'1f31d','funeral_urn'=>'26b1','gabon'=>'1f1ec-1f1e6','gambia'=>'1f1ec-1f1f2','game_die'=>'1f3b2','gb'=>'1f1ec-1f1e7','gear'=>'2699','gem'=>'1f48e','gemini'=>'264a','georgia'=>'1f1ec-1f1ea','ghana'=>'1f1ec-1f1ed','ghost'=>'1f47b','gibraltar'=>'1f1ec-1f1ee','gift'=>'1f381','gift_heart'=>'1f49d','girl'=>'1f467','girl_tone1'=>'1f467-1f3fb','girl_tone2'=>'1f467-1f3fc','girl_tone3'=>'1f467-1f3fd','girl_tone4'=>'1f467-1f3fe','girl_tone5'=>'1f467-1f3ff','globe_with_meridians'=>'1f310','goal'=>'1f945','goat'=>'1f410','golf'=>'26f3','golfer'=>'1f3cc','golfing_man'=>'1f3cc','gorilla'=>'1f98d','grapes'=>'1f347','greece'=>'1f1ec-1f1f7','green_apple'=>'1f34f','green_book'=>'1f4d7','green_heart'=>'1f49a','greenland'=>'1f1ec-1f1f1','grenada'=>'1f1ec-1f1e9','grey_exclamation'=>'2755','grey_question'=>'2754','grimacing'=>'1f62c','grin'=>'1f601','grinning'=>'1f600','guadeloupe'=>'1f1ec-1f1f5','guam'=>'1f1ec-1f1fa','guardsman'=>'1f482','guardsman_tone1'=>'1f482-1f3fb','guardsman_tone2'=>'1f482-1f3fc','guardsman_tone3'=>'1f482-1f3fd','guardsman_tone4'=>'1f482-1f3fe','guardsman_tone5'=>'1f482-1f3ff','guatemala'=>'1f1ec-1f1f9','guernsey'=>'1f1ec-1f1ec','guinea'=>'1f1ec-1f1f3','guinea_bissau'=>'1f1ec-1f1fc','guitar'=>'1f3b8','gun'=>'1f52b','guyana'=>'1f1ec-1f1fe','haircut'=>'1f487','haircut_tone1'=>'1f487-1f3fb','haircut_tone2'=>'1f487-1f3fc','haircut_tone3'=>'1f487-1f3fd','haircut_tone4'=>'1f487-1f3fe','haircut_tone5'=>'1f487-1f3ff','haircut_woman'=>'1f487','haiti'=>'1f1ed-1f1f9','hamburger'=>'1f354','hammer'=>'1f528','hammer_and_pick'=>'2692','hammer_and_wrench'=>'1f6e0','hammer_pick'=>'2692','hamster'=>'1f439','hand'=>'270b','hand_splayed'=>'1f590','hand_splayed_tone1'=>'1f590-1f3fb','hand_splayed_tone2'=>'1f590-1f3fc','hand_splayed_tone3'=>'1f590-1f3fd','hand_splayed_tone4'=>'1f590-1f3fe','hand_splayed_tone5'=>'1f590-1f3ff','handbag'=>'1f45c','handball'=>'1f93e','handball_tone1'=>'1f93e-1f3fb','handball_tone2'=>'1f93e-1f3fc','handball_tone3'=>'1f93e-1f3fd','handball_tone4'=>'1f93e-1f3fe','handball_tone5'=>'1f93e-1f3ff','handshake'=>'1f91d','handshake_tone1'=>'1f91d-1f3fb','handshake_tone2'=>'1f91d-1f3fc','handshake_tone3'=>'1f91d-1f3fd','handshake_tone4'=>'1f91d-1f3fe','handshake_tone5'=>'1f91d-1f3ff','hankey'=>'1f4a9','hash'=>'0023-20e3','hatched_chick'=>'1f425','hatching_chick'=>'1f423','head_bandage'=>'1f915','headphones'=>'1f3a7','hear_no_evil'=>'1f649','heart'=>'2764','heart_decoration'=>'1f49f','heart_exclamation'=>'2763','heart_eyes'=>'1f60d','heart_eyes_cat'=>'1f63b','heartbeat'=>'1f493','heartpulse'=>'1f497','hearts'=>'2665','heavy_check_mark'=>'2714','heavy_division_sign'=>'2797','heavy_dollar_sign'=>'1f4b2','heavy_exclamation_mark'=>'2757','heavy_heart_exclamation'=>'2763','heavy_minus_sign'=>'2796','heavy_multiplication_x'=>'2716','heavy_plus_sign'=>'2795','helicopter'=>'1f681','helmet_with_cross'=>'26d1','herb'=>'1f33f','hibiscus'=>'1f33a','high_brightness'=>'1f506','high_heel'=>'1f460','hocho'=>'1f52a','hockey'=>'1f3d2','hole'=>'1f573','homes'=>'1f3d8','honduras'=>'1f1ed-1f1f3','honey_pot'=>'1f36f','honeybee'=>'1f41d','hong_kong'=>'1f1ed-1f1f0','horse'=>'1f434','horse_racing'=>'1f3c7','horse_racing_tone1'=>'1f3c7-1f3fb','horse_racing_tone2'=>'1f3c7-1f3fc','horse_racing_tone3'=>'1f3c7-1f3fd','horse_racing_tone4'=>'1f3c7-1f3fe','horse_racing_tone5'=>'1f3c7-1f3ff','hospital'=>'1f3e5','hot_pepper'=>'1f336','hotdog'=>'1f32d','hotel'=>'1f3e8','hotsprings'=>'2668','hourglass'=>'231b','hourglass_flowing_sand'=>'23f3','house'=>'1f3e0','house_abandoned'=>'1f3da','house_with_garden'=>'1f3e1','houses'=>'1f3d8','hugging'=>'1f917','hugs'=>'1f917','hungary'=>'1f1ed-1f1fa','hushed'=>'1f62f','ice_cream'=>'1f368','ice_hockey'=>'1f3d2','ice_skate'=>'26f8','icecream'=>'1f366','iceland'=>'1f1ee-1f1f8','id'=>'1f194','ideograph_advantage'=>'1f250','imp'=>'1f47f','inbox_tray'=>'1f4e5','incoming_envelope'=>'1f4e8','india'=>'1f1ee-1f1f3','indonesia'=>'1f1ee-1f1e9','information_desk_person'=>'1f481','information_desk_person_tone1'=>'1f481-1f3fb','information_desk_person_tone2'=>'1f481-1f3fc','information_desk_person_tone3'=>'1f481-1f3fd','information_desk_person_tone4'=>'1f481-1f3fe','information_desk_person_tone5'=>'1f481-1f3ff','information_source'=>'2139','innocent'=>'1f607','interrobang'=>'2049','iphone'=>'1f4f1','iran'=>'1f1ee-1f1f7','iraq'=>'1f1ee-1f1f6','ireland'=>'1f1ee-1f1ea','island'=>'1f3dd','isle_of_man'=>'1f1ee-1f1f2','israel'=>'1f1ee-1f1f1','it'=>'1f1ee-1f1f9','izakaya_lantern'=>'1f3ee','jack_o_lantern'=>'1f383','jamaica'=>'1f1ef-1f1f2','japan'=>'1f5fe','japanese_castle'=>'1f3ef','japanese_goblin'=>'1f47a','japanese_ogre'=>'1f479','jeans'=>'1f456','jersey'=>'1f1ef-1f1ea','jordan'=>'1f1ef-1f1f4','joy'=>'1f602','joy_cat'=>'1f639','joystick'=>'1f579','jp'=>'1f1ef-1f1f5','juggling'=>'1f939','juggling_tone1'=>'1f939-1f3fb','juggling_tone2'=>'1f939-1f3fc','juggling_tone3'=>'1f939-1f3fd','juggling_tone4'=>'1f939-1f3fe','juggling_tone5'=>'1f939-1f3ff','kaaba'=>'1f54b','kazakhstan'=>'1f1f0-1f1ff','kenya'=>'1f1f0-1f1ea','key'=>'1f511','key2'=>'1f5dd','keyboard'=>'2328','keycap_ten'=>'1f51f','kimono'=>'1f458','kiribati'=>'1f1f0-1f1ee','kiss'=>'1f48b','kiss_mm'=>'1f468-2764-1f48b-1f468','kiss_ww'=>'1f469-2764-1f48b-1f469','kissing'=>'1f617','kissing_cat'=>'1f63d','kissing_closed_eyes'=>'1f61a','kissing_heart'=>'1f618','kissing_smiling_eyes'=>'1f619','kiwi'=>'1f95d','knife'=>'1f52a','koala'=>'1f428','koko'=>'1f201','kosovo'=>'1f1fd-1f1f0','kr'=>'1f1f0-1f1f7','kuwait'=>'1f1f0-1f1fc','kyrgyzstan'=>'1f1f0-1f1ec','label'=>'1f3f7','lantern'=>'1f3ee','laos'=>'1f1f1-1f1e6','large_blue_circle'=>'1f535','large_blue_diamond'=>'1f537','large_orange_diamond'=>'1f536','last_quarter_moon'=>'1f317','last_quarter_moon_with_face'=>'1f31c','latin_cross'=>'271d','latvia'=>'1f1f1-1f1fb','laughing'=>'1f606','leaves'=>'1f343','lebanon'=>'1f1f1-1f1e7','ledger'=>'1f4d2','left_facing_fist'=>'1f91b','left_facing_fist_tone1'=>'1f91b-1f3fb','left_facing_fist_tone2'=>'1f91b-1f3fc','left_facing_fist_tone3'=>'1f91b-1f3fd','left_facing_fist_tone4'=>'1f91b-1f3fe','left_facing_fist_tone5'=>'1f91b-1f3ff','left_luggage'=>'1f6c5','left_right_arrow'=>'2194','leftwards_arrow_with_hook'=>'21a9','lemon'=>'1f34b','leo'=>'264c','leopard'=>'1f406','lesotho'=>'1f1f1-1f1f8','level_slider'=>'1f39a','levitate'=>'1f574','liberia'=>'1f1f1-1f1f7','libra'=>'264e','libya'=>'1f1f1-1f1fe','liechtenstein'=>'1f1f1-1f1ee','lifter'=>'1f3cb','lifter_tone1'=>'1f3cb-1f3fb','lifter_tone2'=>'1f3cb-1f3fc','lifter_tone3'=>'1f3cb-1f3fd','lifter_tone4'=>'1f3cb-1f3fe','lifter_tone5'=>'1f3cb-1f3ff','light_rail'=>'1f688','link'=>'1f517','lion'=>'1f981','lion_face'=>'1f981','lips'=>'1f444','lipstick'=>'1f484','lithuania'=>'1f1f1-1f1f9','lizard'=>'1f98e','lock'=>'1f512','lock_with_ink_pen'=>'1f50f','lollipop'=>'1f36d','loop'=>'27bf','loud_sound'=>'1f50a','loudspeaker'=>'1f4e2','love_hotel'=>'1f3e9','love_letter'=>'1f48c','low_brightness'=>'1f505','luxembourg'=>'1f1f1-1f1fa','lying_face'=>'1f925','m'=>'24c2','macau'=>'1f1f2-1f1f4','macedonia'=>'1f1f2-1f1f0','madagascar'=>'1f1f2-1f1ec','mag'=>'1f50d','mag_right'=>'1f50e','mahjong'=>'1f004','mailbox'=>'1f4eb','mailbox_closed'=>'1f4ea','mailbox_with_mail'=>'1f4ec','mailbox_with_no_mail'=>'1f4ed','malawi'=>'1f1f2-1f1fc','malaysia'=>'1f1f2-1f1fe','maldives'=>'1f1f2-1f1fb','male_detective'=>'1f575','mali'=>'1f1f2-1f1f1','malta'=>'1f1f2-1f1f9','man'=>'1f468','man_dancing'=>'1f57a','man_dancing_tone1'=>'1f57a-1f3fb','man_dancing_tone2'=>'1f57a-1f3fc','man_dancing_tone3'=>'1f57a-1f3fd','man_dancing_tone4'=>'1f57a-1f3fe','man_dancing_tone5'=>'1f57a-1f3ff','man_in_tuxedo'=>'1f935','man_in_tuxedo_tone1'=>'1f935-1f3fb','man_in_tuxedo_tone2'=>'1f935-1f3fc','man_in_tuxedo_tone3'=>'1f935-1f3fd','man_in_tuxedo_tone4'=>'1f935-1f3fe','man_in_tuxedo_tone5'=>'1f935-1f3ff','man_tone1'=>'1f468-1f3fb','man_tone2'=>'1f468-1f3fc','man_tone3'=>'1f468-1f3fd','man_tone4'=>'1f468-1f3fe','man_tone5'=>'1f468-1f3ff','man_with_gua_pi_mao'=>'1f472','man_with_gua_pi_mao_tone1'=>'1f472-1f3fb','man_with_gua_pi_mao_tone2'=>'1f472-1f3fc','man_with_gua_pi_mao_tone3'=>'1f472-1f3fd','man_with_gua_pi_mao_tone4'=>'1f472-1f3fe','man_with_gua_pi_mao_tone5'=>'1f472-1f3ff','man_with_turban'=>'1f473','man_with_turban_tone1'=>'1f473-1f3fb','man_with_turban_tone2'=>'1f473-1f3fc','man_with_turban_tone3'=>'1f473-1f3fd','man_with_turban_tone4'=>'1f473-1f3fe','man_with_turban_tone5'=>'1f473-1f3ff','mandarin'=>'1f34a','mans_shoe'=>'1f45e','mantelpiece_clock'=>'1f570','map'=>'1f5fa','maple_leaf'=>'1f341','marshall_islands'=>'1f1f2-1f1ed','martial_arts_uniform'=>'1f94b','martinique'=>'1f1f2-1f1f6','mask'=>'1f637','massage'=>'1f486','massage_tone1'=>'1f486-1f3fb','massage_tone2'=>'1f486-1f3fc','massage_tone3'=>'1f486-1f3fd','massage_tone4'=>'1f486-1f3fe','massage_tone5'=>'1f486-1f3ff','massage_woman'=>'1f486','mauritania'=>'1f1f2-1f1f7','mauritius'=>'1f1f2-1f1fa','mayotte'=>'1f1fe-1f1f9','meat_on_bone'=>'1f356','medal'=>'1f3c5','medal_military'=>'1f396','medal_sports'=>'1f3c5','mega'=>'1f4e3','melon'=>'1f348','memo'=>'1f4dd','menorah'=>'1f54e','mens'=>'1f6b9','metal'=>'1f918','metal_tone1'=>'1f918-1f3fb','metal_tone2'=>'1f918-1f3fc','metal_tone3'=>'1f918-1f3fd','metal_tone4'=>'1f918-1f3fe','metal_tone5'=>'1f918-1f3ff','metro'=>'1f687','mexico'=>'1f1f2-1f1fd','micronesia'=>'1f1eb-1f1f2','microphone'=>'1f3a4','microphone2'=>'1f399','microscope'=>'1f52c','middle_finger'=>'1f595','middle_finger_tone1'=>'1f595-1f3fb','middle_finger_tone2'=>'1f595-1f3fc','middle_finger_tone3'=>'1f595-1f3fd','middle_finger_tone4'=>'1f595-1f3fe','middle_finger_tone5'=>'1f595-1f3ff','military_medal'=>'1f396','milk'=>'1f95b','milky_way'=>'1f30c','minibus'=>'1f690','minidisc'=>'1f4bd','mobile_phone_off'=>'1f4f4','moldova'=>'1f1f2-1f1e9','monaco'=>'1f1f2-1f1e8','money_mouth'=>'1f911','money_mouth_face'=>'1f911','money_with_wings'=>'1f4b8','moneybag'=>'1f4b0','mongolia'=>'1f1f2-1f1f3','monkey'=>'1f412','monkey_face'=>'1f435','monorail'=>'1f69d','montenegro'=>'1f1f2-1f1ea','montserrat'=>'1f1f2-1f1f8','moon'=>'1f314','morocco'=>'1f1f2-1f1e6','mortar_board'=>'1f393','mosque'=>'1f54c','motor_boat'=>'1f6e5','motor_scooter'=>'1f6f5','motorboat'=>'1f6e5','motorcycle'=>'1f3cd','motorway'=>'1f6e3','mount_fuji'=>'1f5fb','mountain'=>'26f0','mountain_bicyclist'=>'1f6b5','mountain_bicyclist_tone1'=>'1f6b5-1f3fb','mountain_bicyclist_tone2'=>'1f6b5-1f3fc','mountain_bicyclist_tone3'=>'1f6b5-1f3fd','mountain_bicyclist_tone4'=>'1f6b5-1f3fe','mountain_bicyclist_tone5'=>'1f6b5-1f3ff','mountain_biking_man'=>'1f6b5','mountain_cableway'=>'1f6a0','mountain_railway'=>'1f69e','mountain_snow'=>'1f3d4','mouse'=>'1f42d','mouse2'=>'1f401','mouse_three_button'=>'1f5b1','movie_camera'=>'1f3a5','moyai'=>'1f5ff','mozambique'=>'1f1f2-1f1ff','mrs_claus'=>'1f936','mrs_claus_tone1'=>'1f936-1f3fb','mrs_claus_tone2'=>'1f936-1f3fc','mrs_claus_tone3'=>'1f936-1f3fd','mrs_claus_tone4'=>'1f936-1f3fe','mrs_claus_tone5'=>'1f936-1f3ff','muscle'=>'1f4aa','muscle_tone1'=>'1f4aa-1f3fb','muscle_tone2'=>'1f4aa-1f3fc','muscle_tone3'=>'1f4aa-1f3fd','muscle_tone4'=>'1f4aa-1f3fe','muscle_tone5'=>'1f4aa-1f3ff','mushroom'=>'1f344','musical_keyboard'=>'1f3b9','musical_note'=>'1f3b5','musical_score'=>'1f3bc','mute'=>'1f507','myanmar'=>'1f1f2-1f1f2','nail_care'=>'1f485','nail_care_tone1'=>'1f485-1f3fb','nail_care_tone2'=>'1f485-1f3fc','nail_care_tone3'=>'1f485-1f3fd','nail_care_tone4'=>'1f485-1f3fe','nail_care_tone5'=>'1f485-1f3ff','name_badge'=>'1f4db','namibia'=>'1f1f3-1f1e6','national_park'=>'1f3de','nauru'=>'1f1f3-1f1f7','nauseated_face'=>'1f922','necktie'=>'1f454','negative_squared_cross_mark'=>'274e','nepal'=>'1f1f3-1f1f5','nerd'=>'1f913','nerd_face'=>'1f913','netherlands'=>'1f1f3-1f1f1','neutral_face'=>'1f610','new'=>'1f195','new_caledonia'=>'1f1f3-1f1e8','new_moon'=>'1f311','new_moon_with_face'=>'1f31a','new_zealand'=>'1f1f3-1f1ff','newspaper'=>'1f4f0','newspaper2'=>'1f5de','newspaper_roll'=>'1f5de','next_track_button'=>'23ed','ng'=>'1f196','ng_woman'=>'1f645','nicaragua'=>'1f1f3-1f1ee','niger'=>'1f1f3-1f1ea','nigeria'=>'1f1f3-1f1ec','night_with_stars'=>'1f303','nine'=>'0039-20e3','niue'=>'1f1f3-1f1fa','no_bell'=>'1f515','no_bicycles'=>'1f6b3','no_entry'=>'26d4','no_entry_sign'=>'1f6ab','no_good'=>'1f645','no_good_tone1'=>'1f645-1f3fb','no_good_tone2'=>'1f645-1f3fc','no_good_tone3'=>'1f645-1f3fd','no_good_tone4'=>'1f645-1f3fe','no_good_tone5'=>'1f645-1f3ff','no_good_woman'=>'1f645','no_mobile_phones'=>'1f4f5','no_mouth'=>'1f636','no_pedestrians'=>'1f6b7','no_smoking'=>'1f6ad','non-potable_water'=>'1f6b1','norfolk_island'=>'1f1f3-1f1eb','north_korea'=>'1f1f0-1f1f5','northern_mariana_islands'=>'1f1f2-1f1f5','norway'=>'1f1f3-1f1f4','nose'=>'1f443','nose_tone1'=>'1f443-1f3fb','nose_tone2'=>'1f443-1f3fc','nose_tone3'=>'1f443-1f3fd','nose_tone4'=>'1f443-1f3fe','nose_tone5'=>'1f443-1f3ff','notebook'=>'1f4d3','notebook_with_decorative_cover'=>'1f4d4','notepad_spiral'=>'1f5d2','notes'=>'1f3b6','nut_and_bolt'=>'1f529','o'=>'2b55','o2'=>'1f17e','ocean'=>'1f30a','octagonal_sign'=>'1f6d1','octopus'=>'1f419','oden'=>'1f362','office'=>'1f3e2','oil'=>'1f6e2','oil_drum'=>'1f6e2','ok'=>'1f197','ok_hand'=>'1f44c','ok_hand_tone1'=>'1f44c-1f3fb','ok_hand_tone2'=>'1f44c-1f3fc','ok_hand_tone3'=>'1f44c-1f3fd','ok_hand_tone4'=>'1f44c-1f3fe','ok_hand_tone5'=>'1f44c-1f3ff','ok_woman'=>'1f646','ok_woman_tone1'=>'1f646-1f3fb','ok_woman_tone2'=>'1f646-1f3fc','ok_woman_tone3'=>'1f646-1f3fd','ok_woman_tone4'=>'1f646-1f3fe','ok_woman_tone5'=>'1f646-1f3ff','old_key'=>'1f5dd','older_man'=>'1f474','older_man_tone1'=>'1f474-1f3fb','older_man_tone2'=>'1f474-1f3fc','older_man_tone3'=>'1f474-1f3fd','older_man_tone4'=>'1f474-1f3fe','older_man_tone5'=>'1f474-1f3ff','older_woman'=>'1f475','older_woman_tone1'=>'1f475-1f3fb','older_woman_tone2'=>'1f475-1f3fc','older_woman_tone3'=>'1f475-1f3fd','older_woman_tone4'=>'1f475-1f3fe','older_woman_tone5'=>'1f475-1f3ff','om'=>'1f549','om_symbol'=>'1f549','oman'=>'1f1f4-1f1f2','on'=>'1f51b','oncoming_automobile'=>'1f698','oncoming_bus'=>'1f68d','oncoming_police_car'=>'1f694','oncoming_taxi'=>'1f696','one'=>'0031-20e3','open_book'=>'1f4d6','open_file_folder'=>'1f4c2','open_hands'=>'1f450','open_hands_tone1'=>'1f450-1f3fb','open_hands_tone2'=>'1f450-1f3fc','open_hands_tone3'=>'1f450-1f3fd','open_hands_tone4'=>'1f450-1f3fe','open_hands_tone5'=>'1f450-1f3ff','open_mouth'=>'1f62e','open_umbrella'=>'2602','ophiuchus'=>'26ce','orange'=>'1f34a','orange_book'=>'1f4d9','orthodox_cross'=>'2626','outbox_tray'=>'1f4e4','owl'=>'1f989','ox'=>'1f402','package'=>'1f4e6','page_facing_up'=>'1f4c4','page_with_curl'=>'1f4c3','pager'=>'1f4df','paintbrush'=>'1f58c','pakistan'=>'1f1f5-1f1f0','palau'=>'1f1f5-1f1fc','palestinian_territories'=>'1f1f5-1f1f8','palm_tree'=>'1f334','panama'=>'1f1f5-1f1e6','pancakes'=>'1f95e','panda_face'=>'1f43c','paperclip'=>'1f4ce','paperclips'=>'1f587','papua_new_guinea'=>'1f1f5-1f1ec','paraguay'=>'1f1f5-1f1fe','parasol_on_ground'=>'26f1','park'=>'1f3de','parking'=>'1f17f','part_alternation_mark'=>'303d','partly_sunny'=>'26c5','passenger_ship'=>'1f6f3','passport_control'=>'1f6c2','pause_button'=>'23f8','paw_prints'=>'1f43e','peace'=>'262e','peace_symbol'=>'262e','peach'=>'1f351','peanuts'=>'1f95c','pear'=>'1f350','pen'=>'1f58a','pen_ballpoint'=>'1f58a','pen_fountain'=>'1f58b','pencil'=>'1f4dd','pencil2'=>'270f','penguin'=>'1f427','pensive'=>'1f614','performing_arts'=>'1f3ad','persevere'=>'1f623','person_frowning'=>'1f64d','person_frowning_tone1'=>'1f64d-1f3fb','person_frowning_tone2'=>'1f64d-1f3fc','person_frowning_tone3'=>'1f64d-1f3fd','person_frowning_tone4'=>'1f64d-1f3fe','person_frowning_tone5'=>'1f64d-1f3ff','person_with_blond_hair'=>'1f471','person_with_blond_hair_tone1'=>'1f471-1f3fb','person_with_blond_hair_tone2'=>'1f471-1f3fc','person_with_blond_hair_tone3'=>'1f471-1f3fd','person_with_blond_hair_tone4'=>'1f471-1f3fe','person_with_blond_hair_tone5'=>'1f471-1f3ff','person_with_pouting_face'=>'1f64e','person_with_pouting_face_tone1'=>'1f64e-1f3fb','person_with_pouting_face_tone2'=>'1f64e-1f3fc','person_with_pouting_face_tone3'=>'1f64e-1f3fd','person_with_pouting_face_tone4'=>'1f64e-1f3fe','person_with_pouting_face_tone5'=>'1f64e-1f3ff','peru'=>'1f1f5-1f1ea','philippines'=>'1f1f5-1f1ed','phone'=>'260e','pick'=>'26cf','pig'=>'1f437','pig2'=>'1f416','pig_nose'=>'1f43d','pill'=>'1f48a','pineapple'=>'1f34d','ping_pong'=>'1f3d3','pisces'=>'2653','pitcairn_islands'=>'1f1f5-1f1f3','pizza'=>'1f355','place_of_worship'=>'1f6d0','plate_with_cutlery'=>'1f37d','play_or_pause_button'=>'23ef','play_pause'=>'23ef','point_down'=>'1f447','point_down_tone1'=>'1f447-1f3fb','point_down_tone2'=>'1f447-1f3fc','point_down_tone3'=>'1f447-1f3fd','point_down_tone4'=>'1f447-1f3fe','point_down_tone5'=>'1f447-1f3ff','point_left'=>'1f448','point_left_tone1'=>'1f448-1f3fb','point_left_tone2'=>'1f448-1f3fc','point_left_tone3'=>'1f448-1f3fd','point_left_tone4'=>'1f448-1f3fe','point_left_tone5'=>'1f448-1f3ff','point_right'=>'1f449','point_right_tone1'=>'1f449-1f3fb','point_right_tone2'=>'1f449-1f3fc','point_right_tone3'=>'1f449-1f3fd','point_right_tone4'=>'1f449-1f3fe','point_right_tone5'=>'1f449-1f3ff','point_up'=>'261d','point_up_2'=>'1f446','point_up_2_tone1'=>'1f446-1f3fb','point_up_2_tone2'=>'1f446-1f3fc','point_up_2_tone3'=>'1f446-1f3fd','point_up_2_tone4'=>'1f446-1f3fe','point_up_2_tone5'=>'1f446-1f3ff','point_up_tone1'=>'261d-1f3fb','point_up_tone2'=>'261d-1f3fc','point_up_tone3'=>'261d-1f3fd','point_up_tone4'=>'261d-1f3fe','point_up_tone5'=>'261d-1f3ff','poland'=>'1f1f5-1f1f1','police_car'=>'1f693','policeman'=>'1f46e','poodle'=>'1f429','poop'=>'1f4a9','popcorn'=>'1f37f','portugal'=>'1f1f5-1f1f9','post_office'=>'1f3e3','postal_horn'=>'1f4ef','postbox'=>'1f4ee','potable_water'=>'1f6b0','potato'=>'1f954','pouch'=>'1f45d','poultry_leg'=>'1f357','pound'=>'1f4b7','pout'=>'1f621','pouting_cat'=>'1f63e','pouting_woman'=>'1f64e','pray'=>'1f64f','pray_tone1'=>'1f64f-1f3fb','pray_tone2'=>'1f64f-1f3fc','pray_tone3'=>'1f64f-1f3fd','pray_tone4'=>'1f64f-1f3fe','pray_tone5'=>'1f64f-1f3ff','prayer_beads'=>'1f4ff','pregnant_woman'=>'1f930','pregnant_woman_tone1'=>'1f930-1f3fb','pregnant_woman_tone2'=>'1f930-1f3fc','pregnant_woman_tone3'=>'1f930-1f3fd','pregnant_woman_tone4'=>'1f930-1f3fe','pregnant_woman_tone5'=>'1f930-1f3ff','previous_track_button'=>'23ee','prince'=>'1f934','prince_tone1'=>'1f934-1f3fb','prince_tone2'=>'1f934-1f3fc','prince_tone3'=>'1f934-1f3fd','prince_tone4'=>'1f934-1f3fe','prince_tone5'=>'1f934-1f3ff','princess'=>'1f478','princess_tone1'=>'1f478-1f3fb','princess_tone2'=>'1f478-1f3fc','princess_tone3'=>'1f478-1f3fd','princess_tone4'=>'1f478-1f3fe','princess_tone5'=>'1f478-1f3ff','printer'=>'1f5a8','projector'=>'1f4fd','puerto_rico'=>'1f1f5-1f1f7','punch'=>'1f44a','punch_tone1'=>'1f44a-1f3fb','punch_tone2'=>'1f44a-1f3fc','punch_tone3'=>'1f44a-1f3fd','punch_tone4'=>'1f44a-1f3fe','punch_tone5'=>'1f44a-1f3ff','purple_heart'=>'1f49c','purse'=>'1f45b','pushpin'=>'1f4cc','put_litter_in_its_place'=>'1f6ae','qatar'=>'1f1f6-1f1e6','question'=>'2753','rabbit'=>'1f430','rabbit2'=>'1f407','race_car'=>'1f3ce','racehorse'=>'1f40e','racing_car'=>'1f3ce','radio'=>'1f4fb','radio_button'=>'1f518','radioactive'=>'2622','rage'=>'1f621','railway_car'=>'1f683','railway_track'=>'1f6e4','rainbow'=>'1f308','rainbow_flag'=>'1f3f3-1f308','raised_back_of_hand'=>'1f91a','raised_back_of_hand_tone1'=>'1f91a-1f3fb','raised_back_of_hand_tone2'=>'1f91a-1f3fc','raised_back_of_hand_tone3'=>'1f91a-1f3fd','raised_back_of_hand_tone4'=>'1f91a-1f3fe','raised_back_of_hand_tone5'=>'1f91a-1f3ff','raised_hand'=>'270b','raised_hand_tone1'=>'270b-1f3fb','raised_hand_tone2'=>'270b-1f3fc','raised_hand_tone3'=>'270b-1f3fd','raised_hand_tone4'=>'270b-1f3fe','raised_hand_tone5'=>'270b-1f3ff','raised_hand_with_fingers_splayed'=>'1f590','raised_hands'=>'1f64c','raised_hands_tone1'=>'1f64c-1f3fb','raised_hands_tone2'=>'1f64c-1f3fc','raised_hands_tone3'=>'1f64c-1f3fd','raised_hands_tone4'=>'1f64c-1f3fe','raised_hands_tone5'=>'1f64c-1f3ff','raising_hand'=>'1f64b','raising_hand_tone1'=>'1f64b-1f3fb','raising_hand_tone2'=>'1f64b-1f3fc','raising_hand_tone3'=>'1f64b-1f3fd','raising_hand_tone4'=>'1f64b-1f3fe','raising_hand_tone5'=>'1f64b-1f3ff','raising_hand_woman'=>'1f64b','ram'=>'1f40f','ramen'=>'1f35c','rat'=>'1f400','record_button'=>'23fa','recycle'=>'267b','red_car'=>'1f697','red_circle'=>'1f534','regional_indicator_a'=>'1f1e6','regional_indicator_b'=>'1f1e7','regional_indicator_c'=>'1f1e8','regional_indicator_d'=>'1f1e9','regional_indicator_e'=>'1f1ea','regional_indicator_f'=>'1f1eb','regional_indicator_g'=>'1f1ec','regional_indicator_h'=>'1f1ed','regional_indicator_i'=>'1f1ee','regional_indicator_j'=>'1f1ef','regional_indicator_k'=>'1f1f0','regional_indicator_l'=>'1f1f1','regional_indicator_m'=>'1f1f2','regional_indicator_n'=>'1f1f3','regional_indicator_o'=>'1f1f4','regional_indicator_p'=>'1f1f5','regional_indicator_q'=>'1f1f6','regional_indicator_r'=>'1f1f7','regional_indicator_s'=>'1f1f8','regional_indicator_t'=>'1f1f9','regional_indicator_u'=>'1f1fa','regional_indicator_v'=>'1f1fb','regional_indicator_w'=>'1f1fc','regional_indicator_x'=>'1f1fd','regional_indicator_y'=>'1f1fe','regional_indicator_z'=>'1f1ff','registered'=>'00ae','relaxed'=>'263a','relieved'=>'1f60c','reminder_ribbon'=>'1f397','repeat'=>'1f501','repeat_one'=>'1f502','rescue_worker_helmet'=>'26d1','restroom'=>'1f6bb','reunion'=>'1f1f7-1f1ea','revolving_hearts'=>'1f49e','rewind'=>'23ea','rhino'=>'1f98f','ribbon'=>'1f380','rice'=>'1f35a','rice_ball'=>'1f359','rice_cracker'=>'1f358','rice_scene'=>'1f391','right_anger_bubble'=>'1f5ef','right_facing_fist'=>'1f91c','right_facing_fist_tone1'=>'1f91c-1f3fb','right_facing_fist_tone2'=>'1f91c-1f3fc','right_facing_fist_tone3'=>'1f91c-1f3fd','right_facing_fist_tone4'=>'1f91c-1f3fe','right_facing_fist_tone5'=>'1f91c-1f3ff','ring'=>'1f48d','robot'=>'1f916','rocket'=>'1f680','rofl'=>'1f923','roll_eyes'=>'1f644','roller_coaster'=>'1f3a2','rolling_eyes'=>'1f644','romania'=>'1f1f7-1f1f4','rooster'=>'1f413','rose'=>'1f339','rosette'=>'1f3f5','rotating_light'=>'1f6a8','round_pushpin'=>'1f4cd','rowboat'=>'1f6a3','rowboat_tone1'=>'1f6a3-1f3fb','rowboat_tone2'=>'1f6a3-1f3fc','rowboat_tone3'=>'1f6a3-1f3fd','rowboat_tone4'=>'1f6a3-1f3fe','rowboat_tone5'=>'1f6a3-1f3ff','rowing_man'=>'1f6a3','ru'=>'1f1f7-1f1fa','rugby_football'=>'1f3c9','runner'=>'1f3c3','runner_tone1'=>'1f3c3-1f3fb','runner_tone2'=>'1f3c3-1f3fc','runner_tone3'=>'1f3c3-1f3fd','runner_tone4'=>'1f3c3-1f3fe','runner_tone5'=>'1f3c3-1f3ff','running'=>'1f3c3','running_man'=>'1f3c3','running_shirt_with_sash'=>'1f3bd','rwanda'=>'1f1f7-1f1fc','sa'=>'1f202','sagittarius'=>'2650','sailboat'=>'26f5','sake'=>'1f376','salad'=>'1f957','samoa'=>'1f1fc-1f1f8','san_marino'=>'1f1f8-1f1f2','sandal'=>'1f461','santa'=>'1f385','santa_tone1'=>'1f385-1f3fb','santa_tone2'=>'1f385-1f3fc','santa_tone3'=>'1f385-1f3fd','santa_tone4'=>'1f385-1f3fe','santa_tone5'=>'1f385-1f3ff','sao_tome_principe'=>'1f1f8-1f1f9','satellite'=>'1f4e1','satellite_orbital'=>'1f6f0','satisfied'=>'1f606','saudi_arabia'=>'1f1f8-1f1e6','saxophone'=>'1f3b7','scales'=>'2696','school'=>'1f3eb','school_satchel'=>'1f392','scissors'=>'2702','scooter'=>'1f6f4','scorpion'=>'1f982','scorpius'=>'264f','scream'=>'1f631','scream_cat'=>'1f640','scroll'=>'1f4dc','seat'=>'1f4ba','second_place'=>'1f948','secret'=>'3299','see_no_evil'=>'1f648','seedling'=>'1f331','selfie'=>'1f933','selfie_tone1'=>'1f933-1f3fb','selfie_tone2'=>'1f933-1f3fc','selfie_tone3'=>'1f933-1f3fd','selfie_tone4'=>'1f933-1f3fe','selfie_tone5'=>'1f933-1f3ff','senegal'=>'1f1f8-1f1f3','serbia'=>'1f1f7-1f1f8','seven'=>'0037-20e3','seychelles'=>'1f1f8-1f1e8','shallow_pan_of_food'=>'1f958','shamrock'=>'2618','shark'=>'1f988','shaved_ice'=>'1f367','sheep'=>'1f411','shell'=>'1f41a','shield'=>'1f6e1','shinto_shrine'=>'26e9','ship'=>'1f6a2','shirt'=>'1f455','shit'=>'1f4a9','shoe'=>'1f45e','shopping'=>'1f6cd','shopping_bags'=>'1f6cd','shopping_cart'=>'1f6d2','shower'=>'1f6bf','shrimp'=>'1f990','shrug'=>'1f937','shrug_tone1'=>'1f937-1f3fb','shrug_tone2'=>'1f937-1f3fc','shrug_tone3'=>'1f937-1f3fd','shrug_tone4'=>'1f937-1f3fe','shrug_tone5'=>'1f937-1f3ff','sierra_leone'=>'1f1f8-1f1f1','signal_strength'=>'1f4f6','singapore'=>'1f1f8-1f1ec','sint_maarten'=>'1f1f8-1f1fd','six'=>'0036-20e3','six_pointed_star'=>'1f52f','ski'=>'1f3bf','skier'=>'26f7','skull'=>'1f480','skull_and_crossbones'=>'2620','skull_crossbones'=>'2620','sleeping'=>'1f634','sleeping_accommodation'=>'1f6cc','sleeping_bed'=>'1f6cc','sleepy'=>'1f62a','slight_frown'=>'1f641','slight_smile'=>'1f642','slightly_frowning_face'=>'1f641','slightly_smiling_face'=>'1f642','slot_machine'=>'1f3b0','slovakia'=>'1f1f8-1f1f0','slovenia'=>'1f1f8-1f1ee','small_airplane'=>'1f6e9','small_blue_diamond'=>'1f539','small_orange_diamond'=>'1f538','small_red_triangle'=>'1f53a','small_red_triangle_down'=>'1f53b','smile'=>'1f604','smile_cat'=>'1f638','smiley'=>'1f603','smiley_cat'=>'1f63a','smiling_imp'=>'1f608','smirk'=>'1f60f','smirk_cat'=>'1f63c','smoking'=>'1f6ac','snail'=>'1f40c','snake'=>'1f40d','sneezing_face'=>'1f927','snowboarder'=>'1f3c2','snowflake'=>'2744','snowman'=>'26c4','snowman2'=>'2603','snowman_with_snow'=>'2603','sob'=>'1f62d','soccer'=>'26bd','solomon_islands'=>'1f1f8-1f1e7','somalia'=>'1f1f8-1f1f4','soon'=>'1f51c','sos'=>'1f198','sound'=>'1f509','south_africa'=>'1f1ff-1f1e6','south_georgia_south_sandwich_islands'=>'1f1ec-1f1f8','south_sudan'=>'1f1f8-1f1f8','space_invader'=>'1f47e','spades'=>'2660','spaghetti'=>'1f35d','sparkle'=>'2747','sparkler'=>'1f387','sparkles'=>'2728','sparkling_heart'=>'1f496','speak_no_evil'=>'1f64a','speaker'=>'1f508','speaking_head'=>'1f5e3','speech_balloon'=>'1f4ac','speech_left'=>'1f5e8','speedboat'=>'1f6a4','spider'=>'1f577','spider_web'=>'1f578','spiral_calendar'=>'1f5d3','spiral_notepad'=>'1f5d2','spoon'=>'1f944','spy'=>'1f575','spy_tone1'=>'1f575-1f3fb','spy_tone2'=>'1f575-1f3fc','spy_tone3'=>'1f575-1f3fd','spy_tone4'=>'1f575-1f3fe','spy_tone5'=>'1f575-1f3ff','squid'=>'1f991','sri_lanka'=>'1f1f1-1f1f0','st_barthelemy'=>'1f1e7-1f1f1','st_helena'=>'1f1f8-1f1ed','st_kitts_nevis'=>'1f1f0-1f1f3','st_lucia'=>'1f1f1-1f1e8','st_pierre_miquelon'=>'1f1f5-1f1f2','st_vincent_grenadines'=>'1f1fb-1f1e8','stadium'=>'1f3df','star'=>'2b50','star2'=>'1f31f','star_and_crescent'=>'262a','star_of_david'=>'2721','stars'=>'1f320','station'=>'1f689','statue_of_liberty'=>'1f5fd','steam_locomotive'=>'1f682','stew'=>'1f372','stop_button'=>'23f9','stopwatch'=>'23f1','straight_ruler'=>'1f4cf','strawberry'=>'1f353','stuck_out_tongue'=>'1f61b','stuck_out_tongue_closed_eyes'=>'1f61d','stuck_out_tongue_winking_eye'=>'1f61c','studio_microphone'=>'1f399','stuffed_flatbread'=>'1f959','sudan'=>'1f1f8-1f1e9','sun_behind_large_cloud'=>'1f325','sun_behind_rain_cloud'=>'1f326','sun_behind_small_cloud'=>'1f324','sun_with_face'=>'1f31e','sunflower'=>'1f33b','sunglasses'=>'1f60e','sunny'=>'2600','sunrise'=>'1f305','sunrise_over_mountains'=>'1f304','surfer'=>'1f3c4','surfer_tone1'=>'1f3c4-1f3fb','surfer_tone2'=>'1f3c4-1f3fc','surfer_tone3'=>'1f3c4-1f3fd','surfer_tone4'=>'1f3c4-1f3fe','surfer_tone5'=>'1f3c4-1f3ff','surfing_man'=>'1f3c4','suriname'=>'1f1f8-1f1f7','sushi'=>'1f363','suspension_railway'=>'1f69f','swaziland'=>'1f1f8-1f1ff','sweat'=>'1f613','sweat_drops'=>'1f4a6','sweat_smile'=>'1f605','sweden'=>'1f1f8-1f1ea','sweet_potato'=>'1f360','swimmer'=>'1f3ca','swimmer_tone1'=>'1f3ca-1f3fb','swimmer_tone2'=>'1f3ca-1f3fc','swimmer_tone3'=>'1f3ca-1f3fd','swimmer_tone4'=>'1f3ca-1f3fe','swimmer_tone5'=>'1f3ca-1f3ff','swimming_man'=>'1f3ca','switzerland'=>'1f1e8-1f1ed','symbols'=>'1f523','synagogue'=>'1f54d','syria'=>'1f1f8-1f1fe','syringe'=>'1f489','taco'=>'1f32e','tada'=>'1f389','taiwan'=>'1f1f9-1f1fc','tajikistan'=>'1f1f9-1f1ef','tanabata_tree'=>'1f38b','tangerine'=>'1f34a','tanzania'=>'1f1f9-1f1ff','taurus'=>'2649','taxi'=>'1f695','tea'=>'1f375','telephone'=>'260e','telephone_receiver'=>'1f4de','telescope'=>'1f52d','tennis'=>'1f3be','tent'=>'26fa','thailand'=>'1f1f9-1f1ed','thermometer'=>'1f321','thermometer_face'=>'1f912','thinking'=>'1f914','third_place'=>'1f949','thought_balloon'=>'1f4ad','three'=>'0033-20e3','thumbsdown'=>'1f44e','thumbsdown_tone1'=>'1f44e-1f3fb','thumbsdown_tone2'=>'1f44e-1f3fc','thumbsdown_tone3'=>'1f44e-1f3fd','thumbsdown_tone4'=>'1f44e-1f3fe','thumbsdown_tone5'=>'1f44e-1f3ff','thumbsup'=>'1f44d','thumbsup_tone1'=>'1f44d-1f3fb','thumbsup_tone2'=>'1f44d-1f3fc','thumbsup_tone3'=>'1f44d-1f3fd','thumbsup_tone4'=>'1f44d-1f3fe','thumbsup_tone5'=>'1f44d-1f3ff','thunder_cloud_rain'=>'26c8','ticket'=>'1f3ab','tickets'=>'1f39f','tiger'=>'1f42f','tiger2'=>'1f405','timer'=>'23f2','timer_clock'=>'23f2','timor_leste'=>'1f1f9-1f1f1','tipping_hand_woman'=>'1f481','tired_face'=>'1f62b','tm'=>'2122','togo'=>'1f1f9-1f1ec','toilet'=>'1f6bd','tokelau'=>'1f1f9-1f1f0','tokyo_tower'=>'1f5fc','tomato'=>'1f345','tone1'=>'1f3fb','tone2'=>'1f3fc','tone3'=>'1f3fd','tone4'=>'1f3fe','tone5'=>'1f3ff','tonga'=>'1f1f9-1f1f4','tongue'=>'1f445','tools'=>'1f6e0','top'=>'1f51d','tophat'=>'1f3a9','tornado'=>'1f32a','tr'=>'1f1f9-1f1f7','track_next'=>'23ed','track_previous'=>'23ee','trackball'=>'1f5b2','tractor'=>'1f69c','traffic_light'=>'1f6a5','train'=>'1f68b','train2'=>'1f686','tram'=>'1f68a','triangular_flag_on_post'=>'1f6a9','triangular_ruler'=>'1f4d0','trident'=>'1f531','trinidad_tobago'=>'1f1f9-1f1f9','triumph'=>'1f624','trolleybus'=>'1f68e','trophy'=>'1f3c6','tropical_drink'=>'1f379','tropical_fish'=>'1f420','truck'=>'1f69a','trumpet'=>'1f3ba','tshirt'=>'1f455','tulip'=>'1f337','tumbler_glass'=>'1f943','tunisia'=>'1f1f9-1f1f3','turkey'=>'1f983','turkmenistan'=>'1f1f9-1f1f2','turks_caicos_islands'=>'1f1f9-1f1e8','turtle'=>'1f422','tuvalu'=>'1f1f9-1f1fb','tv'=>'1f4fa','twisted_rightwards_arrows'=>'1f500','two'=>'0032-20e3','two_hearts'=>'1f495','two_men_holding_hands'=>'1f46c','two_women_holding_hands'=>'1f46d','u5272'=>'1f239','u5408'=>'1f234','u55b6'=>'1f23a','u6307'=>'1f22f','u6708'=>'1f237','u6709'=>'1f236','u6e80'=>'1f235','u7121'=>'1f21a','u7533'=>'1f238','u7981'=>'1f232','u7a7a'=>'1f233','uganda'=>'1f1fa-1f1ec','uk'=>'1f1ec-1f1e7','ukraine'=>'1f1fa-1f1e6','umbrella'=>'2614','umbrella2'=>'2602','unamused'=>'1f612','underage'=>'1f51e','unicorn'=>'1f984','united_arab_emirates'=>'1f1e6-1f1ea','unlock'=>'1f513','up'=>'1f199','upside_down'=>'1f643','upside_down_face'=>'1f643','urn'=>'26b1','uruguay'=>'1f1fa-1f1fe','us'=>'1f1fa-1f1f8','us_virgin_islands'=>'1f1fb-1f1ee','uzbekistan'=>'1f1fa-1f1ff','v'=>'270c','v_tone1'=>'270c-1f3fb','v_tone2'=>'270c-1f3fc','v_tone3'=>'270c-1f3fd','v_tone4'=>'270c-1f3fe','v_tone5'=>'270c-1f3ff','vanuatu'=>'1f1fb-1f1fa','vatican_city'=>'1f1fb-1f1e6','venezuela'=>'1f1fb-1f1ea','vertical_traffic_light'=>'1f6a6','vhs'=>'1f4fc','vibration_mode'=>'1f4f3','video_camera'=>'1f4f9','video_game'=>'1f3ae','vietnam'=>'1f1fb-1f1f3','violin'=>'1f3bb','virgo'=>'264d','volcano'=>'1f30b','volleyball'=>'1f3d0','vs'=>'1f19a','vulcan'=>'1f596','vulcan_salute'=>'1f596','vulcan_tone1'=>'1f596-1f3fb','vulcan_tone2'=>'1f596-1f3fc','vulcan_tone3'=>'1f596-1f3fd','vulcan_tone4'=>'1f596-1f3fe','vulcan_tone5'=>'1f596-1f3ff','walking'=>'1f6b6','walking_man'=>'1f6b6','walking_tone1'=>'1f6b6-1f3fb','walking_tone2'=>'1f6b6-1f3fc','walking_tone3'=>'1f6b6-1f3fd','walking_tone4'=>'1f6b6-1f3fe','walking_tone5'=>'1f6b6-1f3ff','wallis_futuna'=>'1f1fc-1f1eb','waning_crescent_moon'=>'1f318','waning_gibbous_moon'=>'1f316','warning'=>'26a0','wastebasket'=>'1f5d1','watch'=>'231a','water_buffalo'=>'1f403','water_polo'=>'1f93d','water_polo_tone1'=>'1f93d-1f3fb','water_polo_tone2'=>'1f93d-1f3fc','water_polo_tone3'=>'1f93d-1f3fd','water_polo_tone4'=>'1f93d-1f3fe','water_polo_tone5'=>'1f93d-1f3ff','watermelon'=>'1f349','wave'=>'1f44b','wave_tone1'=>'1f44b-1f3fb','wave_tone2'=>'1f44b-1f3fc','wave_tone3'=>'1f44b-1f3fd','wave_tone4'=>'1f44b-1f3fe','wave_tone5'=>'1f44b-1f3ff','wavy_dash'=>'3030','waxing_crescent_moon'=>'1f312','waxing_gibbous_moon'=>'1f314','wc'=>'1f6be','weary'=>'1f629','wedding'=>'1f492','weight_lifting_man'=>'1f3cb','western_sahara'=>'1f1ea-1f1ed','whale'=>'1f433','whale2'=>'1f40b','wheel_of_dharma'=>'2638','wheelchair'=>'267f','white_check_mark'=>'2705','white_circle'=>'26aa','white_flag'=>'1f3f3','white_flower'=>'1f4ae','white_large_square'=>'2b1c','white_medium_small_square'=>'25fd','white_medium_square'=>'25fb','white_small_square'=>'25ab','white_square_button'=>'1f533','white_sun_cloud'=>'1f325','white_sun_rain_cloud'=>'1f326','white_sun_small_cloud'=>'1f324','wilted_rose'=>'1f940','wind_blowing_face'=>'1f32c','wind_chime'=>'1f390','wind_face'=>'1f32c','wine_glass'=>'1f377','wink'=>'1f609','wolf'=>'1f43a','woman'=>'1f469','woman_tone1'=>'1f469-1f3fb','woman_tone2'=>'1f469-1f3fc','woman_tone3'=>'1f469-1f3fd','woman_tone4'=>'1f469-1f3fe','woman_tone5'=>'1f469-1f3ff','womans_clothes'=>'1f45a','womans_hat'=>'1f452','womens'=>'1f6ba','world_map'=>'1f5fa','worried'=>'1f61f','wrench'=>'1f527','wrestlers'=>'1f93c','wrestlers_tone1'=>'1f93c-1f3fb','wrestlers_tone2'=>'1f93c-1f3fc','wrestlers_tone3'=>'1f93c-1f3fd','wrestlers_tone4'=>'1f93c-1f3fe','wrestlers_tone5'=>'1f93c-1f3ff','writing_hand'=>'270d','writing_hand_tone1'=>'270d-1f3fb','writing_hand_tone2'=>'270d-1f3fc','writing_hand_tone3'=>'270d-1f3fd','writing_hand_tone4'=>'270d-1f3fe','writing_hand_tone5'=>'270d-1f3ff','x'=>'274c','yellow_heart'=>'1f49b','yemen'=>'1f1fe-1f1ea','yen'=>'1f4b4','yin_yang'=>'262f','yum'=>'1f60b','zambia'=>'1f1ff-1f1f2','zap'=>'26a1','zero'=>'0030-20e3','zimbabwe'=>'1f1ff-1f1fc','zipper_mouth'=>'1f910','zipper_mouth_face'=>'1f910','zzz'=>'1f4a4');
	protected $unicodeRegexp = '((?:[#*0-9]\\xEF\\xB8\\x8F(?:\\xE2\\x83\\xA3)?|\\xC2[\\xA9\\xAE]\\xEF\\xB8\\x8F|\\xE2(?:\\x80\\xBC\\xEF\\xB8\\x8F|\\x81\\x89\\xEF\\xB8\\x8F|\\x84[\\xA2\\xB9]\\xEF\\xB8\\x8F|\\x86[\\x94-\\x99\\xA9\\xAA]\\xEF\\xB8\\x8F|\\x8C(?:[\\x9A\\x9B](?:\\xEF\\xB8\\x8F)?|\\xA8\\xEF\\xB8\\x8F)|\\x8F(?:[\\x8F\\xAD-\\xAF\\xB1\\xB2\\xB8-\\xBA]\\xEF\\xB8\\x8F|[\\xA9-\\xAC\\xB0\\xB3](?:\\xEF\\xB8\\x8F)?)|\\x93\\x82\\xEF\\xB8\\x8F|\\x96[\\xAA\\xAB\\xB6]\\xEF\\xB8\\x8F|\\x97(?:[\\x80\\xBB\\xBC]\\xEF\\xB8\\x8F|[\\xBD\\xBE](?:\\xEF\\xB8\\x8F)?)|\\x98(?:[\\x80-\\x84\\x8E\\x91\\x98\\xA0\\xA2\\xA3\\xA6\\xAA\\xAE\\xAF\\xB8-\\xBA]\\xEF\\xB8\\x8F|[\\x94\\x95](?:\\xEF\\xB8\\x8F)?|\\x9D(?:\\xEF\\xB8\\x8F|\\xF0\\x9F\\x8F[\\xBB-\\xBF]))|\\x99(?:[\\x88-\\x93\\xBF](?:\\xEF\\xB8\\x8F)?|[\\xA0\\xA3\\xA5\\xA6\\xA8\\xBB]\\xEF\\xB8\\x8F)|\\x9A(?:[\\x92\\x94\\x96\\x97\\x99\\x9B\\x9C\\xA0\\xB0\\xB1]\\xEF\\xB8\\x8F|[\\x93\\xA1\\xAA\\xAB\\xBD\\xBE](?:\\xEF\\xB8\\x8F)?)|\\x9B(?:[\\x84\\x85\\x8E\\x94\\xAA\\xB2\\xB3\\xB5\\xBA\\xBD](?:\\xEF\\xB8\\x8F)?|[\\x88\\x8F\\x91\\x93\\xA9\\xB0\\xB1\\xB4\\xB7\\xB8]\\xEF\\xB8\\x8F|\\xB9(?:\\xEF\\xB8\\x8F|\\xF0\\x9F\\x8F[\\xBB-\\xBF]))|\\x9C(?:[\\x82\\x88\\x89\\x8F\\x92\\x94\\x96\\x9D\\xA1\\xB3\\xB4]\\xEF\\xB8\\x8F|[\\x85\\xA8](?:\\xEF\\xB8\\x8F)?|[\\x8A\\x8B](?:\\xEF\\xB8\\x8F|\\xF0\\x9F\\x8F[\\xBB-\\xBF])?|[\\x8C\\x8D](?:\\xEF\\xB8\\x8F|\\xF0\\x9F\\x8F[\\xBB-\\xBF]))|\\x9D(?:[\\x84\\x87\\xA3\\xA4]\\xEF\\xB8\\x8F|[\\x8C\\x8E\\x93-\\x95\\x97](?:\\xEF\\xB8\\x8F)?)|\\x9E(?:[\\x95-\\x97\\xB0\\xBF](?:\\xEF\\xB8\\x8F)?|\\xA1\\xEF\\xB8\\x8F)|\\xA4[\\xB4\\xB5]\\xEF\\xB8\\x8F|\\xAC(?:[\\x85-\\x87]\\xEF\\xB8\\x8F|[\\x9B\\x9C](?:\\xEF\\xB8\\x8F)?)|\\xAD[\\x90\\x95](?:\\xEF\\xB8\\x8F)?)|\\xE3(?:\\x80[\\xB0\\xBD]|\\x8A[\\x97\\x99])\\xEF\\xB8\\x8F|\\xF0\\x9F(?:\\x80\\x84(?:\\xEF\\xB8\\x8F)?|\\x83\\x8F(?:\\xEF\\xB8\\x8F)?|\\x85[\\xB0\\xB1\\xBE\\xBF]\\xEF\\xB8\\x8F|\\x86[\\x8E\\x91-\\x9A](?:\\xEF\\xB8\\x8F)?|\\x87[\\xA6-\\xBF](?:\\xEF\\xB8\\x8F|\\xF0\\x9F\\x87[\\xA6-\\xBF])?|\\x88(?:[\\x81\\x9A\\xAF\\xB2-\\xB6\\xB8-\\xBA](?:\\xEF\\xB8\\x8F)?|[\\x82\\xB7]\\xEF\\xB8\\x8F)|\\x89[\\x90\\x91](?:\\xEF\\xB8\\x8F)?|\\x8C(?:[\\x80-\\xA0\\xAD-\\xB5\\xB7-\\xBF](?:\\xEF\\xB8\\x8F)?|[\\xA1\\xA4-\\xAC\\xB6]\\xEF\\xB8\\x8F)|\\x8D(?:[\\x80-\\xBC\\xBE\\xBF](?:\\xEF\\xB8\\x8F)?|\\xBD\\xEF\\xB8\\x8F)|\\x8E(?:[\\x80-\\x84\\x86-\\x93\\xA0-\\xBF](?:\\xEF\\xB8\\x8F)?|[\\x96\\x97\\x99-\\x9B\\x9E\\x9F]\\xEF\\xB8\\x8F|\\x85(?:\\xEF\\xB8\\x8F|\\xF0\\x9F\\x8F[\\xBB-\\xBF])?)|\\x8F(?:[\\x80-\\x82\\x85-\\x89\\x8F-\\x93\\xA0-\\xB0\\xB4\\xB8-\\xBF](?:\\xEF\\xB8\\x8F)?|[\\x83\\x84\\x8A](?:\\xEF\\xB8\\x8F|\\xF0\\x9F\\x8F[\\xBB-\\xBF])?|[\\x8C-\\x8E\\x94-\\x9F\\xB3\\xB5\\xB7]\\xEF\\xB8\\x8F|\\x8B(?:\\xEF\\xB8\\x8F|\\xF0\\x9F\\x8F[\\xBB-\\xBF]))|\\x90(?:[\\x80-\\xBE](?:\\xEF\\xB8\\x8F)?|\\xBF\\xEF\\xB8\\x8F)|\\x91(?:[\\x80\\x84\\x85\\x91-\\xA5\\xAA-\\xAD\\xAF\\xB9-\\xBB\\xBD-\\xBF](?:\\xEF\\xB8\\x8F)?|[\\x82\\x83\\x86-\\x90\\xA6\\xA7\\xAE\\xB0-\\xB8\\xBC](?:\\xEF\\xB8\\x8F|\\xF0\\x9F\\x8F[\\xBB-\\xBF])?|\\x81(?:\\xE2\\x80\\x8D\\xF0\\x9F\\x97\\xA8|\\xEF\\xB8\\x8F)|\\xA8(?:\\xE2\\x80\\x8D(?:\\xE2\\x9D\\xA4\\xEF\\xB8\\x8F\\xE2\\x80\\x8D\\xF0\\x9F(?:\\x92\\x8B\\xE2\\x80\\x8D\\xF0\\x9F)?\\x91\\xA8|\\xF0\\x9F\\x91[\\xA8\\xA9]\\xE2\\x80\\x8D\\xF0\\x9F\\x91(?:\\xA6(?:\\xE2\\x80\\x8D\\xF0\\x9F\\x91\\xA6)?|\\xA7(?:\\xE2\\x80\\x8D\\xF0\\x9F\\x91[\\xA6\\xA7])?))|\\xEF\\xB8\\x8F|\\xF0\\x9F\\x8F[\\xBB-\\xBF])?|\\xA9(?:\\xE2\\x80\\x8D(?:\\xE2\\x9D\\xA4\\xEF\\xB8\\x8F\\xE2\\x80\\x8D\\xF0\\x9F(?:\\x92\\x8B\\xE2\\x80\\x8D\\xF0\\x9F)?\\x91[\\xA8\\xA9]|\\xF0\\x9F\\x91\\xA9\\xE2\\x80\\x8D\\xF0\\x9F\\x91(?:\\xA6(?:\\xE2\\x80\\x8D\\xF0\\x9F\\x91\\xA6)?|\\xA7(?:\\xE2\\x80\\x8D\\xF0\\x9F\\x91[\\xA6\\xA7])?))|\\xEF\\xB8\\x8F|\\xF0\\x9F\\x8F[\\xBB-\\xBF])?)|\\x92(?:[\\x80\\x84\\x88-\\xA9\\xAB-\\xBF](?:\\xEF\\xB8\\x8F)?|[\\x81-\\x83\\x85-\\x87\\xAA](?:\\xEF\\xB8\\x8F|\\xF0\\x9F\\x8F[\\xBB-\\xBF])?)|\\x93(?:[\\x80-\\xBC\\xBF](?:\\xEF\\xB8\\x8F)?|\\xBD\\xEF\\xB8\\x8F)|\\x94[\\x80-\\xBD](?:\\xEF\\xB8\\x8F)?|\\x95(?:[\\x89\\x8A\\xAF\\xB0\\xB3\\xB4\\xB6-\\xB9]\\xEF\\xB8\\x8F|[\\x8B-\\x8E\\x90-\\xA7](?:\\xEF\\xB8\\x8F)?|\\xB5(?:\\xEF\\xB8\\x8F|\\xF0\\x9F\\x8F[\\xBB-\\xBF])|\\xBA(?:\\xEF\\xB8\\x8F|\\xF0\\x9F\\x8F[\\xBB-\\xBF])?)|\\x96(?:[\\x87\\x8A-\\x8D\\xA5\\xA8\\xB1\\xB2\\xBC]\\xEF\\xB8\\x8F|[\\x95\\x96](?:\\xEF\\xB8\\x8F|\\xF0\\x9F\\x8F[\\xBB-\\xBF])?|\\x90(?:\\xEF\\xB8\\x8F|\\xF0\\x9F\\x8F[\\xBB-\\xBF])|\\xA4(?:\\xEF\\xB8\\x8F)?)|\\x97(?:[\\x82-\\x84\\x91-\\x93\\x9C-\\x9E\\xA1\\xA3\\xA8\\xAF\\xB3\\xBA]\\xEF\\xB8\\x8F|[\\xBB-\\xBF](?:\\xEF\\xB8\\x8F)?)|\\x98[\\x80-\\xBF](?:\\xEF\\xB8\\x8F)?|\\x99(?:[\\x80-\\x84\\x88-\\x8A](?:\\xEF\\xB8\\x8F)?|[\\x85-\\x87\\x8B-\\x8F](?:\\xEF\\xB8\\x8F|\\xF0\\x9F\\x8F[\\xBB-\\xBF])?)|\\x9A(?:[\\x80-\\xA2\\xA4-\\xB3\\xB7-\\xBF](?:\\xEF\\xB8\\x8F)?|[\\xA3\\xB4-\\xB6](?:\\xEF\\xB8\\x8F|\\xF0\\x9F\\x8F[\\xBB-\\xBF])?)|\\x9B(?:[\\x81-\\x85\\x8C\\x90-\\x92\\xAB\\xAC\\xB4-\\xB6](?:\\xEF\\xB8\\x8F)?|[\\x8B\\x8D-\\x8F\\xA0-\\xA5\\xA9\\xB0\\xB3]\\xEF\\xB8\\x8F|\\x80(?:\\xEF\\xB8\\x8F|\\xF0\\x9F\\x8F[\\xBB-\\xBF])?)|\\xA4(?:[\\x90-\\x97\\xA0-\\xA5\\xA7\\xBA](?:\\xEF\\xB8\\x8F)?|[\\x98-\\x9E\\xA6\\xB0\\xB3-\\xB9\\xBC-\\xBE](?:\\xEF\\xB8\\x8F|\\xF0\\x9F\\x8F[\\xBB-\\xBF])?)|\\xA5[\\x80-\\x85\\x87-\\x8B\\x90-\\x9E](?:\\xEF\\xB8\\x8F)?|\\xA6[\\x80-\\x91](?:\\xEF\\xB8\\x8F)?|\\xA7\\x80(?:\\xEF\\xB8\\x8F)?))(?!\\xEF\\xB8\\x8E))S';

	public function parse($text, array $matches)
	{
		$this->parseAliases($text);
		$this->parseAsciiEmoji($text);
		$this->parseUnicodeEmoji($text);
	}
	protected function addTag($tagPos, $tagLen, $seq)
	{
		$this->parser->addSelfClosingTag($this->config['tagName'], $tagPos, $tagLen, 10)
		             ->setAttribute($this->config['attrName'], $seq);
	}
	protected function getSequence($str)
	{
		$str = \str_replace("\xEF\xB8\x8F", '', \str_replace("\xE2\x80\x8D", '', $str));
		$seq = array();
		$i   = 0;
		do
		{
			$cp = \ord($str[$i]);
			if ($cp >= 0xF0)
				$cp = ($cp << 18) + (\ord($str[++$i]) << 12) + (\ord($str[++$i]) << 6) + \ord($str[++$i]) - 0x3C82080;
			elseif ($cp >= 0xE0)
				$cp = ($cp << 12) + (\ord($str[++$i]) << 6) + \ord($str[++$i]) - 0xE2080;
			elseif ($cp >= 0xC0)
				$cp = ($cp << 6) + \ord($str[++$i]) - 0x3080;
			$seq[] = \sprintf('%04x', $cp);
		}
		while (++$i < \strlen($str));
		return \implode('-', $seq);
	}
	protected function parseAliases($text)
	{
		if (empty($this->config['aliases']))
			return;
		$matchPos = 0;
		if (isset($this->config['aliasesQuickMatch']))
		{
			$matchPos = \strpos($text, $this->config['aliasesQuickMatch']);
			if ($matchPos === \false)
				return;
		}
		\preg_match_all($this->config['aliasesRegexp'], $text, $matches, \PREG_OFFSET_CAPTURE, $matchPos);
		foreach ($matches[0] as $_8bb89e38)
		{
			list($alias, $tagPos) = $_8bb89e38;
			if (isset($this->config['aliases'][$alias]))
			{
				$emoji = $this->config['aliases'][$alias];
				$this->addTag($tagPos, \strlen($alias), $this->getSequence($emoji));
			}
		}
	}
	protected function parseAsciiEmoji($text)
	{
		$matchPos = \strpos($text, ':');
		if ($matchPos === \false)
			return;
		\preg_match_all($this->asciiRegexp, $text, $matches, \PREG_OFFSET_CAPTURE, $matchPos);
		foreach ($matches[0] as $_765c1971)
		{
			list($shortName, $tagPos) = $_765c1971;
			$shortName = \substr($shortName, 1);
			if (isset(self::$map[$shortName]))
				$this->addTag($tagPos, 2 + \strlen($shortName), self::$map[$shortName]);
		}
	}
	protected function parseUnicodeEmoji($text)
	{
		if (\strpos($text, "\xE2") === \false && \strpos($text, "\xEF") === \false && \strpos($text, "\xF0") === \false)
			return;
		\preg_match_all($this->unicodeRegexp, $text, $matches, \PREG_OFFSET_CAPTURE);
		foreach ($matches[0] as $_e20330bd)
		{
			list($emoji, $tagPos) = $_e20330bd;
			$this->addTag($tagPos, \strlen($emoji), $this->getSequence($emoji));
		}
	}
}