<?php
/**
*
* This file is part of the phpBB Forum Software package.
* @正體中文化 竹貓星球 <http://phpbb-tw.net/phpbb/>
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'  => '正體中文語系由 <a href="http://phpbb-tw.net/" onclick="window.open(this.href);return false;"> <strong>竹貓星球</strong> </a> 維護製作',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|d M Y|',	// 01 Jan 2007 (with Relative days enabled)
	'DATETIME_FORMAT'	=> '|d M Y, H:i|',	// 01 Jan 2007, 13:37 (with Relative days enabled)
	'USER_LANG'         => 'zh-cmn-hant',

	// 在這裡，您可以為複數形式的確定，定義不同的規則。
	// 參考 http://wiki.phpbb.com/Plural_Rules 以獲得更多的資訊
	// 或者，詢問翻譯團隊以獲得協助。
	'PLURAL_RULE'		=> 1,

	'1_DAY' => '1天',
	'1_MONTH'   => '1個月',
	'1_YEAR'    => '1年',
	'2_WEEKS'   => '2週',
	'3_MONTHS'  => '3個月',
	'6_MONTHS'  => '6個月',
	'7_DAYS'    => '7天',

	'ACCOUNT_ALREADY_ACTIVATED' => '您的帳號已經被啟用。',
	'ACCOUNT_DEACTIVATED'   => '您的帳號已經被停用，並且只有管理員才能重新啟用。',
	'ACCOUNT_NOT_ACTIVATED' => '您的帳號尚未被啟用',
	'ACP'   => '管理員控制台',
	'ACP_SHORT'						=> 'ACP',
	'ACTIVE'    => '啟用',
	'ACTIVE_ERROR'  => '您指定了一個未被啟用的會員名稱。如果您有啟用帳號的問題，那麼請聯絡管理員。',
	'ADMINISTRATOR' => '管理員',
	'ADMINISTRATORS'    => '管理員',
	'AGE'   => '年齡',
	'AIM'							=> 'AIM',
	'AJAX_ERROR_TITLE'              => 'AJAX 錯誤',
	'AJAX_ERROR_TEXT'               => '當處理您的請求時發生了錯誤。',
	'AJAX_ERROR_TEXT_ABORT'         => '使用者中止請求。',
	'AJAX_ERROR_TEXT_TIMEOUT'       => '您的請求超過時間；請重新再試一次。',
	'AJAX_ERROR_TEXT_PARSERERROR'   => '該請求發生了錯誤，伺服器返回一個無效的回覆。',
	'ALLOWED'   => '允許',
	'ALL_FILES' => '所有檔案',
	'ALL_FORUMS'    => '所有版面',
	'ALL_MESSAGES'  => '所有訊息',
	'ALL_POSTS' => '所有文章',
	'ALL_TIMES' => '所有顯示的時間為 <abbr title="%2$s">%1$s</abbr>',
	'ALL_TOPICS'    => '所有主題',
	'AND'   => '和',
	'ARE_WATCHING_FORUM'    => '您訂閱了這個版面，版面更新時會發送通知給您。',
	'ARE_WATCHING_TOPIC'    => '您訂閱了這個主題，主題更新時會發送通知給您。',
	'ASCENDING' => '依序遞增',
	'ATTACHMENTS'   => '附加檔案',
	'ATTACHED_IMAGE_NOT_IMAGE'  => '您所附加的圖檔是無效的。',
	'AUTHOR'    => '發表人',
	'AUTH_NO_PROFILE_CREATED'   => '建立會員資料失敗。',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_ENTRY'               => '無效的資料庫條目。',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_SERVICE_TYPE'        => '提供 OAuth 的服務處理程序是無效的服務類型。',
	'AUTH_PROVIDER_OAUTH_ERROR_SERVICE_NOT_CREATED'         => '沒有建立 OAuth 的服務',
	'AUTH_PROVIDER_OAUTH_SERVICE_BITLY'						=> 'Bitly',
	'AUTH_PROVIDER_OAUTH_SERVICE_FACEBOOK'					=> 'Facebook',
	'AUTH_PROVIDER_OAUTH_SERVICE_GOOGLE'					=> 'Google',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_NOT_STORED'            => 'OAuth 的憑證沒有儲存。',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_INCORRECTLY_STORED'    => 'OAuth 的憑證儲存錯誤。',
	'AVATAR_DISALLOWED_CONTENT'     => '上傳被拒絕，因為上傳的檔案被認定具有可能的攻擊成分。',
	'AVATAR_DISALLOWED_EXTENSION'   => '副檔名 %s 已經被停用。',
	'AVATAR_EMPTY_REMOTE_DATA'  => '頭像無法上傳，遠端伺服器的資料無效或損壞。',
	'AVATAR_EMPTY_FILEUPLOAD'   => '上傳的頭像檔案是空的。',
	'AVATAR_INVALID_FILENAME'   => '%s 是無效的檔案名稱。',
	'AVATAR_NOT_UPLOADED'   => '無法上傳頭像。',
	'AVATAR_NO_SIZE'    => '無法自動取得頭像的尺寸，請手動輸入合適的數值。',
	'AVATAR_PARTIAL_UPLOAD' => '上傳的檔案只上傳了一部分。',
	'AVATAR_PHP_SIZE_NA'    => '頭像檔案太大。<br />無法判斷伺服器 PHP 允許的最大檔案大小限制。',
	'AVATAR_PHP_SIZE_OVERRUN'   => '頭像檔案太大，伺服器允許的最大檔案大小是 %1$d %2$s。<br />請注意這個限制是根據伺服器上 php.ini 的設定，所以無法變更。',
	'AVATAR_REMOTE_UPLOAD_TIMEOUT'      => '指定的頭像因為超過時間而無法上傳。',
	'AVATAR_URL_INVALID'    => '指定的連結無效。',
	'AVATAR_URL_NOT_FOUND'  => '無法找到指定的檔案。',
	'AVATAR_WRONG_FILESIZE' => '頭像檔案大小必須介於 0 和 %1$d %2$s 之間。',
	'AVATAR_WRONG_SIZE' => '您送出的頭像寬度是 %5$s，高度是 %6$s。頭像的寬度必須大於 %1$s，高度必須大於 %2$s，並且寬度不得超過 %3$s，高度不得超過 %4$s。',

	'BACK_TO_TOP'   => '回頂端',
	'BACK_TO_PREV'  => '回到前一頁',
	'BAN_TRIGGERED_BY_EMAIL'    => '您的 e-mail 位址已經被封鎖。',
	'BAN_TRIGGERED_BY_IP'   => '您的 IP 位址已經被封鎖。',
	'BAN_TRIGGERED_BY_USER' => '您的會員名稱已經被封鎖。',
	'BBCODE_GUIDE'  => 'BBCode 使用手冊',
	'BCC'   => '密件副本',
	'BIRTHDAYS' => '生日',
	'BOARD_BAN_PERM'    => '您被這個討論區 <strong>永久地</strong> 封鎖。<br /><br />請與 %2$s討論區管理員%3$s 聯絡，以獲得更多的資訊。',
	'BOARD_BAN_REASON'  => '被封鎖的理由是： <strong>%s</strong> ',
	'BOARD_BAN_TIME'    => '您被這個討論區封鎖，直到 <strong>%1$s</strong> 為止。<br /><br />請與 %2$s討論區管理員%3$s 聯絡，以獲得更多的資訊。',
	'BOARD_DISABLE' => '很抱歉！ 目前討論區暫時關閉中。',
	'BOARD_DISABLED'    => '討論區目前關閉中。',
	'BOARD_UNAVAILABLE' => '很抱歉！ 目前討論區暫時無法使用，請稍後再登入。',
	'BROWSING_FORUM'        => '正在瀏覽這個版面的使用者：%1$s',
	'BROWSING_FORUM_GUESTS'	=> array(
		1   => '正在瀏覽這個版面的使用者：%2$s 和 %1$d 位訪客',
		2   => '正在瀏覽這個版面的使用者：%2$s 和 %1$d 位訪客',
	),
	'BUTTON_EDIT'           => '編輯',
	'BUTTON_FORUM_LOCKED'   => '版面已鎖定',
	'BUTTON_NEW_TOPIC'      => '發表主題',
	'BUTTON_PM'             => '私訊',
	'BUTTON_PM_FORWARD'     => '轉寄',
	'BUTTON_PM_NEW'         => '發送私訊',
	'BUTTON_PM_REPLY'       => '回覆',
	'BUTTON_PM_REPLY_ALL'   => '回覆所有人',
	'BUTTON_POST_REPLY'     => '回覆文章',
	'BUTTON_QUOTE'          => '引言',
	'BUTTON_TOPIC_LOCKED'   => '主題已鎖定',
	'BYTES'					=> 'Bytes',
	'BYTES_SHORT'			=> 'B',

	'CANCEL'    => '取消',
	'CHANGE'    => '變更',
	'CHANGE_FONT_SIZE'  => '變更字體大小',
	'CHANGING_PREFERENCES'  => '變更版面引用',
	'CHANGING_PROFILE'  => '變更版面資料設定',
	'CHARACTERS'			=> array(
		1   => '%d 字元',
		2   => '%d 字元',
	),
	'COLLAPSE_VIEW' => '收縮瀏覽',
	'CLOSE_WINDOW'  => '關閉視窗',
	'COLOUR_SWATCH' => '顏色取樣',
	'COLON'					=> ':',
	'COMMA_SEPARATOR'   => '、', // Comma used to join lists into a single string, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'   => '確認',
	'CONFIRM_CODE'  => '確認代碼',
	'CONFIRM_CODE_EXPLAIN'   => '請正確輸入它所顯示的代碼，不必區分大小寫。',
	'CONFIRM_CODE_WRONG'    => '您輸入的確認代碼有誤。',
	'CONFIRM_OPERATION' => '您確定要執行這個操作嗎？',
	'CONFIRM_AVATAR_DELETE' => '您確定要刪除這個頭像？',
	'CONGRATULATIONS'   => '恭喜您',
	'CONNECTION_FAILED' => '連線失敗。',
	'CONNECTION_SUCCESS'    => '連線成功！',
	'CONTACT'               => '聯繫',
	'CONTACT_USER'          => '聯繫 %s',
	'CONTACT_US'            => '聯繫我們',
	'COOKIES_DELETED'   => '所有的 Cookies 都已經被清除。',
	'CURRENT_TIME'  => '現在的時間是 %s',

	'DAY'   => '日',
	'DAYS'  => '天',
	'DELETE'    => '刪除',
	'DELETE_ALL'    => '刪除全部',
	'DELETE_COOKIES'    => '刪除所有討論區 Cookies',
	'DELETE_MARKED' => '刪除選取',
	'DELETE_POST'   => '刪除文章',
	'DELIMITER' => '分隔符號',
	'DESCENDING'    => '依序遞減',
	'DISABLED'  => '停用',
	'DISPLAY'   => '顯示',
	'DISPLAY_GUESTS'    => '顯示訪客 ',
	'DISPLAY_MESSAGES'  => '顯示訊息 ',
	'DISPLAY_POSTS' => '顯示文章 ',
	'DISPLAY_TOPICS'    => '顯示主題 ',
	'DOWNLOADED'    => '已下載',
	'DOWNLOADING_FILE'  => '正在下載檔案中',
	'DOWNLOAD_COUNTS'		=> array(
		0   => '尚未被下載',
		1   => '已下載 %d 次',
		2   => '已下載 %d 次',
	),

	'EDIT_POST' => '編輯文章',
	'ELLIPSIS'							=>	'…',
	'EMAIL' => 'E-mail',// EMAIL_ADDRESS 的簡寫
	'EMAIL_ADDRESS' => 'E-mail 位址',
	'EMAIL_INVALID_EMAIL'               => '您輸入的 e-mail 位址是無效的。',
	'EMAIL_SMTP_ERROR_RESPONSE' => '發送 e-mail 在 <strong>第 %1$s 行</strong> 遇到問題。回應訊息：%2$s。',
	'EMPTY_SUBJECT' => '您必須為新主題指定一個標題。',
	'EMPTY_MESSAGE_SUBJECT' => '您沒有輸入標題。',
	'ENABLED'   => '啟用',
	'ENCLOSURE' => '包圍',
	'ENTER_USERNAME'                    => '輸入會員名稱',
	'ERR_CHANGING_DIRECTORY'    => '無法變更資料夾。',
	'ERR_CONNECTING_SERVER' => '連接伺服器錯誤。',
	'ERR_JAB_AUTH'  => '無法取得 Jabber 伺服器授權。',
	'ERR_JAB_CONNECT'       => '無法連線到 Jabber 伺服器。',
	'ERR_UNABLE_TO_LOGIN'   => '您提供的會員名稱或密碼錯誤。',
	'ERR_UNWATCHING'                    => '當試著取消訂閱時發生一個錯誤。',
	'ERR_WATCHING'                      => '當試著訂閱時發生一個錯誤。',
	'ERR_WRONG_PATH_TO_PHPBB'   => '輸入的 phpBB 路徑無效。',
	'ERROR'                                 => '錯誤',
	'EXPAND_VIEW'   => '展開瀏覽',
	'EXTENSION' => '副檔名',
	'EXTENSION_DISABLED'                => '副檔名 <strong>%s</strong> 未啟用。',
	'EXTENSION_DISABLED_AFTER_POSTING'  => '副檔名 <strong>%s</strong> 已經被停用且不再顯示。',
	'EXTENSION_DOES_NOT_EXIST'          => '副檔名 <strong>%s</strong> 不存在。',

	'FACEBOOK'				=> 'Facebook',
	'FAQ'   => '問答集',
	'FAQ_EXPLAIN'   => '問答集',
	'FILENAME'  => '檔案名稱',
	'FILESIZE'  => '檔案大小',
	'FILEDATE'  => '檔案日期',
	'FILE_COMMENT'  => '檔案註釋',
	'FILE_CONTENT_ERR'      => '無法讀取檔案的內容：%s',
	'FILE_JSON_DECODE_ERR'  => '無法解碼 json 檔案：%s',
	'FILE_NOT_FOUND'    => '找不到必須的檔案：%s',
	'FIND_USERNAME' => '搜尋會員',
	'FOLDER'    => '資料夾',
	'FORGOT_PASS'   => '我忘記了自己的密碼',
	'FORM_INVALID'  => '表單送出無效。請再執行一次。',
	'FORUM' => '版面',
	'FORUMS'    => '版面',
	'FORUMS_MARKED'         => '版面已經被標示為已閱讀。',
	'FORUM_CAT' => '版面類別',
	'FORUM_INDEX'   => '討論區首頁',
	'FORUM_LINK'    => '版面連結',
	'FORUM_LOCATION'    => '版面位置',
	'FORUM_LOCKED'  => '版面鎖定',
	'FORUM_RULES'   => '版面規則',
	'FORUM_RULES_LINK'  => '請點選這裡檢視版面規則',
	'FROM'  => '從',
	'FSOCK_DISABLED'    => '操作無法完成，因為 <var>fsockopen</var> 函數被停用或是伺服器沒有回應。',
	'FSOCK_TIMEOUT'         => '當從網路串流讀取時，發生逾時。',

	'FTP_FSOCK_HOST'    => 'FTP 主機',
	'FTP_FSOCK_HOST_EXPLAIN'    => '您的 FTP 伺服器連結位址。',
	'FTP_FSOCK_PASSWORD'    => 'FTP 密碼',
	'FTP_FSOCK_PASSWORD_EXPLAIN'    => '登入您 FTP 伺服器的使用者密碼。',
	'FTP_FSOCK_PORT'    => 'FTP 連接埠',
	'FTP_FSOCK_PORT_EXPLAIN'    => '連接到您 FTP 伺服器的埠號，預設為 21。',
	'FTP_FSOCK_ROOT_PATH'   => 'phpBB 資料夾路徑。',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'   => '連接到您 phpBB 討論區程式的資料夾路徑。',
	'FTP_FSOCK_TIMEOUT' => 'FTP 連線逾時。',
	'FTP_FSOCK_TIMEOUT_EXPLAIN' => '您的伺服器連線回應逾時時間 (秒)。',
	'FTP_FSOCK_USERNAME'    => 'FTP 帳號',
	'FTP_FSOCK_USERNAME_EXPLAIN'    => '登入您 FTP 伺服器的使用者帳號。',

	'FTP_HOST'  => 'FTP 主機',
	'FTP_HOST_EXPLAIN'  => '您的 FTP 伺服器連結位址。',
	'FTP_PASSWORD'  => 'FTP 密碼',
	'FTP_PASSWORD_EXPLAIN'  => '登入您 FTP 伺服器的使用者密碼。',
	'FTP_PORT'  => 'FTP 連接埠',
	'FTP_PORT_EXPLAIN'  => '連接到您 FTP 伺服器的埠號，預設為 21。',
	'FTP_ROOT_PATH' => 'phpBB 資料夾路徑',
	'FTP_ROOT_PATH_EXPLAIN' => '連接到您 phpBB 討論區程式的資料夾路徑。',
	'FTP_TIMEOUT'   => 'FTP 連線逾時',
	'FTP_TIMEOUT_EXPLAIN'   => '您的伺服器連線回應逾時時間 (秒)。',
	'FTP_USERNAME'  => 'FTP 帳號',
	'FTP_USERNAME_EXPLAIN'  => '登入您 FTP 伺服器的使用者帳號。',

	'GENERAL_ERROR' => '一般性錯誤',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',
	'GO'						=> 'Go',
	'GOOGLEPLUS'				=> 'Google+',
	'GOTO_FIRST_POST'           => '前往第一篇文章',
	'GOTO_LAST_POST'            => '前往最後一篇文章',
	'GOTO_PAGE' => '前往頁數',
	'GROUP' => '群組',
	'GROUPS'    => '群組',
	'GROUP_ERR_TYPE'    => '不適當的群組屬性。',
	'GROUP_ERR_USERNAME'    => '沒有指定群組名稱。',
	'GROUP_ERR_USER_LONG'   => '群組名稱不能超過 60 個字元。指定的群組名稱太長了。',
	'GUEST' => '訪客',
	'GUEST_USERS_ONLINE'		=> array(
		1   => '共有 %d 位訪客上線',
		2   => '共有 %d 位訪客上線',
	),
	'GUEST_USERS_TOTAL'			=> array(
		1   => '%d 位訪客',
		2   => '%d 位訪客',
	),
	'G_ADMINISTRATORS'  => '管理員',
	'G_BOTS'    => '機器人',
	'G_GUESTS'  => '訪客',
	'G_REGISTERED'  => '註冊會員',
	'G_REGISTERED_COPPA'    => '註冊 COPPA 會員',
	'G_GLOBAL_MODERATORS'   => '全域版主',
	'G_NEWLY_REGISTERED'        => '新註冊會員',

	'HIDDEN_USERS_ONLINE'		=> array(
		1   => '%d 位隱形會員上線',
		2   => '%d 位隱形會員上線',
	),
	'HIDDEN_USERS_TOTAL'		=> array(
		1   => '%d 位隱形會員',
		2   => '%d 位隱形會員',
	),
	'HIDE_GUESTS'   => '隱藏訪客',
	'HIDE_ME'   => '此次登入請隱藏我的上線狀態',
	'HOURS' => '小時',
	'HOME'  => '首頁',

	'ICQ'						=> 'ICQ',
	'IF'    => '如果',
	'IMAGE' => '圖檔',
	'IMAGE_FILETYPE_INVALID'    => '不支援的圖檔類型：%d mimetype %s 。',
	'IMAGE_FILETYPE_MISMATCH'   => '圖檔類型不符：預期的副檔名是 %1$s ，但您提供的是 %2$s。',
	'IN'    => '位於',
	'INACTIVE'					=> '未啟用',
	'INDEX' => '首頁',
	'INFORMATION'   => '系統訊息',
	'INSECURE_REDIRECT'         => '試圖重新導向到潛在的不安全之網址。',
	'INTERESTS' => '興趣',
	'INVALID_DIGEST_CHALLENGE'  => '無效的摘要需求。',
	'INVALID_EMAIL_LOG' => ' <strong>%s</strong> 可能是無效的 e-mail 位址？',
	'INVALID_PLURAL_RULE'       => '所選擇的複數規則是無效的。有效值為 0 到 15 之間的整數。',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'    => '您的 IP %1$s 已經被封鎖，因為它在封鎖列表中。細節請參考 <a href="%2$s">%2$s</a>。',

	'JABBER'				=> 'Jabber',
	'JOINED'    => '註冊時間',
	'JUMP_PAGE'             => '輸入您想要前往的頁數',
	'JUMP_TO'   => '前往 ',
	'JUMP_TO_PAGE'          => '跳轉到頁',
	'JUMP_TO_PAGE_CLICK'    => '點選要前往的頁面...',

	'KB'					=> 'KB',
	'KIB'					=> 'KiB',

	'LAST_POST' => '最後發表',
	'LAST_UPDATED'  => '最後更新',
	'LAST_VISIT'    => '最後訪問',
	'LDAP_NO_LDAP_EXTENSION'    => 'LDAP 模組無法使用。',
	'LDAP_NO_SERVER_CONNECTION' => '無法連線到 LDAP 伺服器。',
	'LDAP_SEARCH_FAILED'            => '當搜尋 LDAP 目錄時發生錯誤。',
	'LEGEND'    => '顏色說明',
	'LIVE_SEARCHES_NOT_ALLOWED'         => '在線搜尋是不允許的。',
	'LOADING'                           => '加載中',
	'LOCATION'  => '來自',
	'LOCK_POST' => '鎖定文章',
	'LOCK_POST_EXPLAIN' => '防止文章被編輯',
	'LOCK_TOPIC'    => '鎖定主題',
	'LOGIN' => '登入',
	'LOGIN_CHECK_PM'    => '登入檢查您的私人訊息。',
	'LOGIN_CONFIRMATION'    => '登入確認',
	'LOGIN_CONFIRM_EXPLAIN'            => '為了防止暴力破解會員帳號，論壇將會要求您在超過最大嘗試登入次數後輸入一組確認代碼，確認代碼顯示在如下所示的圖檔中。如果您有視覺相關問題因而無法瀏覽判斷時，請聯絡 %s論壇管理員%s。', // 不使用的
	'LOGIN_ERROR_ATTEMPTS'            => '您的登入錯誤，超過了討論區設定的嘗試次數上限。現在除了輸入您的會員名稱和密碼外，還需要解決底下的 CAPTCHA。',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'  => '您的瀏覽未獲 Apache 伺服器授權。',
	'LOGIN_ERROR_OAUTH_SERVICE_DOES_NOT_EXIST'  => '一個不存在的 OAuth 服務已被請求。',
	'LOGIN_ERROR_PASSWORD'  => '您輸入了一個無效的密碼。請確認後重新嘗試登入。如果問題依舊存在請聯絡 %s管理員%s。',
	'LOGIN_ERROR_PASSWORD_CONVERT'  => '在討論區升級中無法轉換您的密碼。請 %s申請一個新密碼%s。如果您還遇到其他的問題，請聯絡 %s管理員%s。',
	'LOGIN_ERROR_USERNAME'  => '您輸入了一個無效的會員名稱。請檢查後重新輸入。如果問題依舊存在請聯絡 %s管理員%s。',
	'LOGIN_FORUM'   => '您需要輸入符合的密碼才能瀏覽這個版面。',
	'LOGIN_INFO'    => '您必須註冊後才能登入。註冊僅需要很短的時間，但是會給您更多的權限。在註冊前請確認您已經明白我們的使用條款和隱私政策。當瀏覽討論區時請確認您已經閱讀過版面規則。',
	'LOGIN_VIEWFORUM'   => '您必須註冊並且登入後才能瀏覽這個版面。',
	'LOGIN_EXPLAIN_EDIT'    => '您必須註冊並且登入後才能編輯版面文章。',
	'LOGIN_EXPLAIN_VIEWONLINE'  => '您必須註冊並且登入後才能檢視誰在線上。',
	'LOGIN_REQUIRED'                    => '您需要登入後才能執行此動作。',
	'LOGOUT'    => '登出',
	'LOGOUT_USER'   => '登出 [ %s ]',
	'LOG_ME_IN' => '記得我',

	'MAIN'                  => '主要的',
	'MARK'  => '標示',
	'MARK_ALL'  => '選擇全部',
	'MARK_ALL_READ'         => '標示全部為已閱讀',
	'MARK_FORUMS_READ'  => '將版面標示為已閱讀',
	'MARK_READ'             => '標示為已閱讀',
	'MARK_SUBFORUMS_READ'   => '將子版面標示為已閱讀',
	'MB'					=> 'MB',
	'MIB'					=> 'MiB',
	'MCP'   => '版主控制台',
	'MCP_SHORT'				=> 'MCP',
	'MEMBERLIST'    => '會員列表',
	'MEMBERLIST_EXPLAIN'    => '檢視完整的會員列表',
	'MERGE' => '合併',
	'MERGE_POSTS'           => '移動文章',
	'MERGE_TOPIC'   => '合併主題',
	'MESSAGE'   => '內容',
	'MESSAGES'  => '內容',
	'MESSAGES_COUNT'		=> array(
		1   => '%d 則訊息',
		2   => '%d 則訊息',
	),
	'MESSAGE_BODY'  => '文章內容',
	'MINUTES'   => '分鐘',
	'MODERATE'  => '管理',
	'MODERATOR' => '版主',
	'MODERATORS'    => '版主',
	'MODULE_NOT_ACCESS'     => '模組無法使用',
	'MODULE_NOT_FIND'       => '找不到 %s 模組',
	'MODULE_FILE_INCORRECT_CLASS'   => '模組檔案 %s 沒有包含正確的級別 [%s]',
	'MONTH' => '月',
	'MOVE'  => '移動',

	'NA'						=> 'N/A',
	'NEWEST_USER'   => '我們的最新會員：<strong>%s</strong>',
	'NEW_MESSAGE'   => '新訊息',
	'NEW_MESSAGES'  => '新訊息',
	'NEW_POST'               => '有新文章',   // 不再使用
	'NEW_POSTS'               => '有新文章',   // 不再使用
	'NEXT'  => '下一頁',
	'NEXT_STEP' => '下一步',
	'NEVER' => '從未',
	'NO'    => '否',
	'NO_NOTIFICATIONS'          => '您沒有通知',
	'NOT_ALLOWED_MANAGE_GROUP'  => '您不能從管理員控制台管理這個會員群組。',
	'NOT_AUTHORISED'    => '您沒有權限瀏覽這塊區域。',
	'NOT_WATCHING_FORUM'    => '您已經取消這個版面的訂閱，版面更新訊息停止發送。',
	'NOT_WATCHING_TOPIC'    => '您已經取消這個主題的訂閱。',
	'NOTIFICATIONS'				=> '通知',
	// This applies for NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	// %1$s will return a list of users that's concatenated using "," and "and" - see STRING_LIST
	// Once the user count reaches 5 users or more, the list is trimmed using NOTIFICATION_X_OTHERS
	// Once the user count reaches 20 users or more, the list is trimmed using NOTIFICATION_MANY_OTHERS
	// Examples:
	// A replied...
	// A and B replied...
	// A, B and C replied...
	// A, B, C and 2 others replied...
	// A, B, C and others replied...
	'NOTIFICATION_BOOKMARK'				=> array(
		1   => '來自 %1$s 的 <strong>回覆</strong> 在我的最愛主題：',
	),
	'NOTIFICATION_FORUM'                => '<em>版面：</em>%1$s',
	'NOTIFICATION_GROUP_REQUEST'        => '來自 %1$s 的 <strong>群組要求</strong> 想要加入 %2$s 群組。',
	'NOTIFICATION_GROUP_REQUEST_APPROVED'   => ' <strong>群組要求已核准</strong> 可加入群組 %1$s。',
	'NOTIFICATION_PM'                   => '來自 %1$s 的 <strong>私人訊息</strong> ：',
	'NOTIFICATION_POST'					=> array(
		1   => '來自 %1$s 的 <strong>回覆</strong> 在主題：',
	),
	'NOTIFICATION_POST_APPROVED'        => ' <strong>文章已核准</strong> ：',
	'NOTIFICATION_POST_DISAPPROVED'     => ' <strong>文章已拒絕</strong> ：',
	'NOTIFICATION_POST_IN_QUEUE'        => '來自 %1$s 的 <strong>文章核准</strong> 請求：',
	'NOTIFICATION_QUOTE'				=> array(
		1   => ' <strong>已引言</strong> 由 %1$s 在：',
	),
	'NOTIFICATION_REFERENCE'            => '「%1$s」',
	'NOTIFICATION_REASON'               => '<em>理由：</em>%1$s。',
	'NOTIFICATION_REPORT_PM'            => ' <strong>私訊已檢舉</strong> 由 %1$s：',
	'NOTIFICATION_REPORT_POST'          => ' <strong>文章已檢舉</strong> 由 %1$s：',
	'NOTIFICATION_REPORT_CLOSED'        => ' <strong>檢舉已結案</strong> 由 %1$s，因為：',
	'NOTIFICATION_TOPIC'                => ' <strong>新的主題</strong> 由 %1$s：',
	'NOTIFICATION_TOPIC_APPROVED'       => ' <strong>主題已核准</strong> ：',
	'NOTIFICATION_TOPIC_DISAPPROVED'    => ' <strong>主題已拒絕</strong> ：',
	'NOTIFICATION_TOPIC_IN_QUEUE'       => '來自 %1$s 的 <strong>主題核准</strong> 請求：',
	'NOTIFICATION_TYPE_NOT_EXIST'       => '通知類型「%s」從檔案系統中遺失。',
	'NOTIFICATION_ADMIN_ACTIVATE_USER'	=> '<strong>帳號啟用請求</strong>由已停用帳號或新的註冊會員「%1$s」',
	// Used in conjuction with NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	'NOTIFICATION_MANY_OTHERS'          => '其餘的全部',
	'NOTIFICATION_X_OTHERS'				=> array(
		2   => '%d 其餘的全部',
	),
	'NOTIFY_ADMIN'  => '請通知管理員或網站管理者。',
	'NOTIFY_ADMIN_EMAIL'    => '請通知管理員或網站管理者：<a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'  => '您不被允許使用這個檔案。',
	'NO_ACTION' => '沒有指定的動作。',
	'NO_ADMINISTRATORS'         => '沒有管理員。',
	'NO_AUTH_ADMIN' => '您沒有管理權限，因此不能使用管理員控制台。',
	'NO_AUTH_ADMIN_USER_DIFFER' => '您不能被重新授權為另一個會員。',
	'NO_AUTH_OPERATION' => '您沒有完成這個操作所需要的權限。',
	'NO_AVATARS'                => '目前沒有可用的頭像',
	'NO_CONNECT_TO_SMTP_HOST'   => '無法連接 SMTP 伺服器 ：%s ：%s',
	'NO_BIRTHDAYS'  => '今天沒有人生日',
	'NO_EMAIL_MESSAGE'  => '沒有 e-mail 內容。',
	'NO_EMAIL_RESPONSE_CODE'    => '無法得到郵件伺服器回應碼。',
	'NO_EMAIL_SUBJECT'  => '沒有 e-mail 主題。',
	'NO_FORUM'  => '您選擇的版面不存在。',
	'NO_FORUMS' => '這個討論區還沒有版面。',
	'NO_GROUP'  => '請求的會員群組不存在。',
	'NO_GROUP_MEMBERS'  => '這個會員群組還沒有成員。',
	'NO_IPS_DEFINED'    => '沒有設定 IP 位址或主機名稱',
	'NO_MEMBERS'    => '這個搜尋規則下沒有找到符合的會員。',
	'NO_MESSAGES'   => '沒有訊息',
	'NO_MODE'   => '沒有指定模式。',
	'NO_MODERATORS' => '沒有版主。',
	'NO_NEW_MESSAGES'   => '沒有新的訊息',
	'NO_NEW_POSTS'            => '無新文章',   // 不再使用
	'NO_ONLINE_USERS'   => '沒有註冊會員',
	'NO_POSTS'  => '沒有文章',
	'NO_POSTS_TIME_FRAME'   => '在選定的時段中這個主題沒有文章存在。',
	'NO_FEED_ENABLED'           => '在這個論壇的消息來源是不可用的。',
	'NO_FEED'                   => '所需求的消息來源是不可用的。',
	'NO_STYLE_DATA'             => '無法得到風格的資料',
	'NO_SUBJECT'    => '沒有輸入標題',
	'NO_SUCH_SEARCH_MODULE' => '指定的搜尋模組不存在。',
	'NO_SUPPORTED_AUTH_METHODS' => '沒有可支援的認證方式。',
	'NO_TOPIC'  => '請求的主題不存在。',
	'NO_TOPIC_FORUM'            => '主題或版面不再存在。',
	'NO_TOPICS' => '這個版面還沒有主題或文章。',
	'NO_TOPICS_TIME_FRAME'  => '在選定的時段中這個版面沒有主題存在。',
	'NO_UNREAD_POSTS'           => '沒有未閱讀文章',
	'NO_UPLOAD_FORM_FOUND'  => '上傳已經開始，但是沒有有效的上傳檔案表單。',
	'NO_USER'   => '該會員不存在。',
	'NO_USERS'  => '該會員不存在。',
	'NO_USER_SPECIFIED' => '沒有指定會員名稱。',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_ATTACHMENTS'		=> array(
		1   => '%d 個附加檔案',
		2   => '%d 個附加檔案',
	),
	'NUM_POSTS_IN_QUEUE'		=> array(
		0           => '沒有文章待審',        // 0
		1           => '1 篇文章待審',       // 1
		2           => '%d 篇文章待審',      // 2+
	),

	'OCCUPATION'    => '職業',
	'OFFLINE'   => '離線',
	'ONLINE'    => '線上',
	'ONLINE_BUDDIES'    => '線上好友',
	// "... :: x registered and y hidden"
	'ONLINE_USERS_TOTAL'		=> array(
		1   => '線上共有 <strong>%1$d</strong> 位使用者：%2$s以及 %3$s',
		2   => '線上共有 <strong>%1$d</strong> 位使用者：%2$s以及 %3$s',
	),
	// "... :: x registered, y hidden and z guests"
	'ONLINE_USERS_TOTAL_GUESTS'	=> array(
		1   => '線上共有 <strong>%1$d</strong> 位使用者：%2$s、%3$s以及 %4$s',
		2   => '線上共有 <strong>%1$d</strong> 位使用者：%2$s、%3$s以及 %4$s',
	),
	'OPTIONS'   => '選項',

	'PAGE_OF'   => '第 <strong>%1$d</strong> 頁 (共 <strong>%2$d</strong> 頁)',
	'PAGE_TITLE_NUMBER'     => '第 %s 頁',
	'PASSWORD'  => '密碼',
	'PIXEL'                 => '像素',
	'PIXELS'				=> array(
		1   => '%d 像素',
		2   => '%d 像素',
	),
	'PLAY_QUICKTIME_FILE'   => '播放 Quicktime 檔案',
	'PLEASE_WAIT'           => '請稍候。',
	'PM'					=> 'PM',
	'PM_REPORTED'           => '點選以查看檢舉',
	'POSTING_MESSAGE'   => '發表訊息於 %s',
	'POSTING_PRIVATE_MESSAGE'   => '編寫私人訊息',
	'POST'  => '文章',
	'POST_ANNOUNCEMENT' => '公告',
	'POST_STICKY'   => '置頂',
	'POSTED'    => '發表於 ',
	'POSTED_IN_FORUM'   => '發表於',
	'POSTED_ON_DATE'    => '發表於',
	'POSTS' => '文章',
	'POSTS_UNAPPROVED'  => '這個主題裡至少有一篇文章未被核准。',
	'POSTS_UNAPPROVED_FORUM'=> '這個版面裡至少有一篇文章未被核准。',
	'POST_BY_AUTHOR'    => '由',
	'POST_BY_FOE'           => '這篇文章由 <strong>%1$s</strong> 發表，此人目前在您的黑名單中。',
	'POST_DISPLAY'          => '%1$s顯示這篇文章%2$s。',
	'POST_DAY'  => '平均每天 %.2f 篇文章',
	'POST_DELETED_ACTION'   => '刪除的文章：',
	'POST_DELETED'          => '該文章已被刪除。',
	'POST_DELETED_BY'       => ' <strong>%2$s</strong> 已刪除由 <strong>%1$s</strong> 發表在 %3$s 的文章。',
	'POST_DELETED_BY_REASON'=> ' <strong>%2$s</strong> 已刪除由 <strong>%1$s</strong> 發表在 %3$s 的文章，因為以下的理由：%4$s',
	'POST_DETAILS'  => '文章細節',
	'POST_NEW_TOPIC'    => '發表新文章',
	'POST_PCT'  => '所有文章的 %.2f%%',
	'POST_PCT_ACTIVE'   => '會員文章的 %.2f%%',
	'POST_PCT_ACTIVE_OWN'   => '您的文章的 %.2f%%',
	'POST_REPLY'    => '發表回覆',
	'POST_REPORTED' => '點選檢視檢舉內容',
	'POST_SUBJECT'  => '文章主題 ',
	'POST_TIME' => '發表時間 ',
	'POST_TOPIC'    => '發表新主題',
	'POST_UNAPPROVED_ACTION'    => '文章正在等待核准：',
	'POST_UNAPPROVED'   => '這篇文章沒有被核准',
	'POWERED_BY'			=> 'Powered by %s',
	'PREVIEW'   => '預覽',
	'PREVIOUS'  => '上一頁',
	'PREVIOUS_STEP' => '上一步',
	'PRIVACY'   => '隱私政策',
	'PRIVATE_MESSAGE'   => '私人訊息',
	'PRIVATE_MESSAGES'  => '私人訊息',
	'PRIVATE_MESSAGING' => '私人訊息',
	'PROFILE'   => '會員控制台',

	'QUICK_LINKS'           => '快速連結',

	'RANK'                      => '等級',
	'READING_FORUM' => '正在檢視 %s 版面的主題',
	'READING_GLOBAL_ANNOUNCE'   => '檢視全域公告',
	'READING_LINK'  => '下面的版面連結 %s',
	'READING_TOPIC' => '正在閱讀 %s 版面的主題',
	'READ_PROFILE'  => '個人資料',
	'REASON'    => '理由',
	'RECORD_ONLINE_USERS'   => '最高線上人數記錄為 <strong>%1$s</strong> 人 [記錄時間：<strong>%2$s</strong>]',
	'REDIRECT'  => '重新導向',
	'REDIRECTS' => '轉向總數',
	'REGISTER'  => '註冊',
	'REGISTERED_USERS'  => '註冊會員：',
	// "... and 2 hidden users online"
	'REG_USERS_ONLINE'			=> array(
		1   => '線上有 %1$d 位註冊會員以及 %2$s',
		2   => '線上有 %1$d 位註冊會員以及 %2$s',
	),
	'REG_USERS_TOTAL'			=> array(
		1   => '%d 位註冊會員',
		2   => '%d 位註冊會員',
	),
	'REMOVE'    => '刪除',
	'REMOVE_INSTALL'    => '在開始使用討論區前請刪除，移除或重新命名 install 檔案夾。如果這個資料夾依然存在，那麼您只能使用管理員控制台 (ACP)。',
	'REPLIES'   => '回覆',
	'REPLY_WITH_QUOTE'  => '引用回覆',
	'REPLYING_GLOBAL_ANNOUNCE'  => '回覆全域公告',
	'REPLYING_MESSAGE'  => '回覆文章於 %s',
	'REPORT_BY' => '檢舉人',
	'REPORT_POST'   => '檢舉此文章',
	'REPORTING_POST'    => '檢舉文章',
	'RESEND_ACTIVATION' => '重寄啟用 e-mail',
	'RESET' => '重新設定',
	'RESTORE_PERMISSIONS'   => '恢復權限',
	'RETURN_INDEX'  => '%s回到首頁%s',
	'RETURN_FORUM'  => '%s回到最近瀏覽的版面%s',
	'RETURN_PAGE'   => '%s回到先前的頁面%s',
	'RETURN_TOPIC'  => '%s回到最近瀏覽的主題%s',
	'RETURN_TO'                 => '回到「%s」',
	'RETURN_TO_INDEX'           => '回到論壇首頁',
	'FEED'                      => '消息來源',
	'FEED_NEWS'                 => '新聞',
	'FEED_TOPICS_ACTIVE'        => '最近討論的主題',
	'FEED_TOPICS_NEW'           => '新的主題',
	'RULES_ATTACH_CAN'  => '您 <strong>可以</strong> 在這個版面上傳附加檔案',
	'RULES_ATTACH_CANNOT'   => '您 <strong>不能</strong> 在這個版面上傳附加檔案',
	'RULES_DELETE_CAN'  => '您 <strong>可以</strong> 在這個版面刪除您的文章',
	'RULES_DELETE_CANNOT'   => '您 <strong>不能</strong> 在這個版面刪除您的文章',
	'RULES_DOWNLOAD_CAN'    => '您 <strong>可以</strong> 在這個版面下載附加檔案',
	'RULES_DOWNLOAD_CANNOT' => '您 <strong>不能</strong> 在這個版面下載附加檔案',
	'RULES_EDIT_CAN'    => '您 <strong>可以</strong> 在這個版面編輯您的文章',
	'RULES_EDIT_CANNOT' => '您 <strong>不能</strong> 在這個版面編輯您的文章',
	'RULES_LOCK_CAN'    => '您 <strong>可以</strong> 在這個版面鎖定您的文章',
	'RULES_LOCK_CANNOT' => '您 <strong>不能</strong> 在這個版面鎖定您的文章',
	'RULES_POST_CAN'    => '您 <strong>可以</strong> 在這個版面發表主題',
	'RULES_POST_CANNOT' => '您 <strong>不能</strong> 在這個版面發表主題',
	'RULES_REPLY_CAN'   => '您 <strong>可以</strong> 在這個版面回覆主題',
	'RULES_REPLY_CANNOT'    => '您 <strong>不能</strong> 在這個版面回覆主題',
	'RULES_VOTE_CAN'    => '您 <strong>可以</strong> 在這個版面建立投票',
	'RULES_VOTE_CANNOT' => '您 <strong>不能</strong> 在這個版面建立投票',

	'SEARCH'    => '搜尋',
	'SEARCH_MINI'   => '搜尋...',
	'SEARCH_ADV'    => '進階搜尋',
	'SEARCH_ADV_EXPLAIN'    => '檢視進階搜尋選項',
	'SEARCH_KEYWORDS'   => '搜尋關鍵字',
	'SEARCHING_FORUMS'  => '搜尋版面',
	'SEARCH_ACTIVE_TOPICS'  => '最近討論的主題',
	'SEARCH_FOR'    => '搜尋',
	'SEARCH_FORUM'  => '搜尋這個版面...',
	'SEARCH_NEW'    => '新的文章',
	'SEARCH_POSTS_BY'   => '搜尋文章，依照',
	'SEARCH_SELF'   => '您的文章',
	'SEARCH_TOPIC'  => '搜尋這個主題...',
	'SEARCH_UNANSWERED' => '沒有回覆的主題',
	'SEARCH_UNREAD'             => '沒有閱讀的文章',
	'SEARCH_USER_POSTS'         => '搜尋會員的文章',
	'SECONDS'   => '秒',
	'SEE_ALL'                   => '看見所有',
	'SELECT'    => '選擇',
	'SELECT_ALL_CODE'   => '選擇全部',
	'SELECT_DESTINATION_FORUM'  => '請選擇一個目的版面',
	'SELECT_FORUM'  => '選擇一個版面',
	'SEND_EMAIL'                => '發送 email',              // Used for submit buttons
	'SEND_EMAIL_USER'           => '發送 email 給 %s',
	'SEND_PRIVATE_MESSAGE'  => '發送私人訊息',
	'SETTINGS'  => '設定',
	'SIGNATURE' => '簽名',
	'SKIP'  => '跳到內容',
	'SKYPE'						=> 'Skype',
	'SMTP_NO_AUTH_SUPPORT'  => 'SMTP 伺服器不支援驗證',
	'SORRY_AUTH_READ'   => '您沒有閱讀這個版面的權限。',
	'SORRY_AUTH_VIEW_ATTACH'    => '您沒有下載這個附加檔案的權限。',
	'SORT_BY'   => '排序',
	'SORT_JOINED'   => '註冊時間',
	'SORT_LOCATION' => '來自',
	'SORT_RANK' => '等級',
	'SORT_POSTS'                => '文章',
	'SORT_TOPIC_TITLE'  => '主題',
	'SORT_USERNAME' => '會員名稱',
	'SPLIT_TOPIC'   => '分割主題',
	'SQL_ERROR_OCCURRED'    => '當讀出此頁的時候發生一個 SQL 錯誤。如果問題一直存在，那麼請連絡 %s管理員%s。',
	'STATISTICS'    => '統計資料',
	'START_WATCHING_FORUM'  => '訂閱版面',
	'START_WATCHING_TOPIC'  => '訂閱主題',
	'STOP_WATCHING_FORUM'   => '退訂版面',
	'STOP_WATCHING_TOPIC'   => '退訂主題',
	'STRING_LIST_MULTI'         => '%1$s、以及 %2$s',
	'STRING_LIST_SIMPLE'        => '%1$s 以及 %2$s',
	'SUBFORUM'  => '子版面',
	'SUBFORUMS' => '子版面',
	'SUBJECT'   => '主題',
	'SUBMIT'    => '送出',

	'TB'				=> 'TB',
	'TERMS_USE' => '使用條款',
	'TEST_CONNECTION'   => '連結測試',
	'THE_TEAM'  => '管理團隊',
	'TIB'				=> 'TiB',
	'TIME'  => '時間',
	'TIMEOUT_PROCESSING_REQ'            => '請求逾時。',

	'TOO_LARGE'                     => '您輸入的值太大。',
	'TOO_LARGE_MAX_RECIPIENTS'      => '這個 <strong>每個私人訊息所允許的最大收件人數</strong> 設定，您輸入的值太大。',

	'TOO_LONG'                      => '您輸入的數值太長。',

	'TOO_LONG_CONFIRM_CODE' => '您輸入的確認代碼太長了。',
	'TOO_LONG_DATEFORMAT'           => '您輸入的時間格式太長了。',
	'TOO_LONG_JABBER'   => '您輸入的 Jabber 帳號名稱太長了。',
	'TOO_LONG_NEW_PASSWORD' => '您輸入的密碼太長了。',
	'TOO_LONG_PASSWORD_CONFIRM' => '您輸入的確認密碼太長了。',
	'TOO_LONG_USER_PASSWORD'    => '您輸入的密碼太長了。',
	'TOO_LONG_USERNAME' => '您輸入的會員名稱太長了。',
	'TOO_LONG_EMAIL'    => '您輸入的 e-mail 位址太長了。',

	'TOO_MANY_VOTE_OPTIONS' => '您在投票中選擇了過多的選項。',

	'TOO_SHORT'                     => '您輸入的數值太短。',

	'TOO_SHORT_CONFIRM_CODE'    => '您輸入的確認代碼太短了。',
	'TOO_SHORT_DATEFORMAT'          => '您輸入的時間格式太短了。',
	'TOO_SHORT_JABBER'  => '您輸入的 Jabber 帳號名稱太短了。',
	'TOO_SHORT_NEW_PASSWORD'    => '您輸入的密碼太短了。',
	'TOO_SHORT_PASSWORD_CONFIRM'    => '您輸入的確認密碼太短了。',
	'TOO_SHORT_USER_PASSWORD'   => '您輸入的密碼太短了。',
	'TOO_SHORT_USERNAME'    => '您輸入的會員名稱太短了。',
	'TOO_SHORT_EMAIL'   => '您輸入的 e-mail 位址太短了。',
	'TOO_SHORT_EMAIL_CONFIRM'   => '您輸入的確認 e-mail 位址太短了。',
	'TOO_SMALL'                     => '您輸入的值太小。',
	'TOO_SMALL_MAX_RECIPIENTS'      => '這個 <strong>每個私人訊息所允許的最大收件人數</strong> 設定，您輸入的值太小。',

	'TOPIC' => '主題',
	'TOPICS'    => '主題',
	'TOPICS_UNAPPROVED' => '在這論壇至少有一個主題沒有被核准。',
	'TOPIC_ICON'    => '主題圖示',
	'TOPIC_LOCKED'  => '這個主題已被鎖定，您不能編輯或回覆這個主題。',
	'TOPIC_LOCKED_SHORT'=> '主題已鎖定',
	'TOPIC_MOVED'   => '移動主題',
	'TOPIC_REVIEW'  => '主題瀏覽',
	'TOPIC_TITLE'   => '標題',
	'TOPIC_UNAPPROVED'  => '這個主題尚未被核准。',
	'TOPIC_DELETED'     => '這個主題已被刪除。',
	'TOTAL_ATTACHMENTS' => '附加檔案',
	'TOTAL_LOGS'		=> array(
		1   => '%d 個記錄',
		2   => '%d 個記錄',
	),
	'TOTAL_PMS'		=> array(
		1   => '總共有 %d 個私人訊息',
		2   => '總共有 %d 個私人訊息',
	),
	'TOPIC_POLL'        => '這個主題有一項投票。',
	'TOTAL_POSTS'   => '文章總數',
	'TOTAL_POSTS_COUNT'	=> array(
		2   => '總共有 <strong>%d</strong> 篇文章',
	),
	'TOPIC_REPORTED'    => '這個主題已被檢舉',
	'TOTAL_TOPICS'		=> array(
		2   => '總共有 <strong>%d</strong> 個主題',
	),
	'TOTAL_USERS'		=> array(
		2   => '總共有 <strong>%d</strong> 位會員',
	),
	'TRACKED_PHP_ERROR' => '已追蹤 PHP 錯誤：%s',
	'TWITTER'			=> 'Twitter',

	'UNABLE_GET_IMAGE_SIZE' => '無法瀏覽圖檔，或者此檔案不是一個有效的圖檔。請確認您輸入的網址是否正確。',
	'UNABLE_TO_DELIVER_FILE'    => '無法傳送檔案。',
	'UNKNOWN_BROWSER'   => '無法瀏覽',
	'UNMARK_ALL'    => '取消全選',
	'UNREAD_MESSAGES'   => '未讀訊息',
	'UNREAD_POST'           => '未閱讀文章',
	'UNREAD_POSTS'          => '未閱讀文章',
	'UNWATCH_FORUM_CONFIRM'     => '您確定要取消訂閱這個版面嗎？',
	'UNWATCH_FORUM_DETAILED'    => '您確定要取消訂閱「%s」版面嗎？',
	'UNWATCH_TOPIC_CONFIRM'     => '您確定要取消訂閱這個主題嗎？',
	'UNWATCH_TOPIC_DETAILED'    => '您確定要取消訂閱「%s」主題嗎？',
	'UNWATCHED_FORUMS'  => '您將不再訂閱這些選取的版面。',
	'UNWATCHED_TOPICS'  => '您將不再訂閱這些選取的主題。',
	'UNWATCHED_FORUMS_TOPICS'   => '您將不再訂閱這些選取的文章。',
	'UPDATE'    => '更新',
	'UPLOAD_IN_PROGRESS'    => '正在上傳。',
	'URL_REDIRECT'  => '如果您的瀏覽器不支援 meta 重新導向，那麼請點選 %s這裡%s 連結。',
	'USERGROUPS'    => '會員群組',
	'USERNAME'  => '會員名稱',
	'USERNAMES' => '會員名稱',
	'USER_AVATAR'   => '頭像',
	'USER_CANNOT_READ'  => '您不能閱讀這個版面的文章。',
	'USER_POSTS'			=> array(
		1   => '%d 篇文章',
		2   => '%d 篇文章',
	),
	'USERS' => '會員',
	'USE_PERMISSIONS'   => '測試此會員的權限',

	'USER_NEW_PERMISSION_DISALLOWED'    => '很抱歉！您沒有權限使用這個功能。您只是剛在這裡註冊，您需要有更多地參與討論，才可使用這個功能。',

	'VARIANT_DATE_SEPARATOR'    => ' / ',
	'VIEWED'    => '已觀看',
	'VIEWED_COUNTS'		=> array(
		0   => '尚未被瀏覽',
		1   => '已瀏覽 %d 次',
		2   => '已瀏覽 %d 次',
	),
	'VIEWING_CONTACT_ADMIN'     => '檢視聯繫頁面',
	'VIEWING_FAQ'   => '檢視問答集',
	'VIEWING_MEMBERS'   => '檢視會員細節',
	'VIEWING_ONLINE'    => '檢視誰在線上',
	'VIEWING_MCP'   => '檢視版主控制台',
	'VIEWING_MEMBER_PROFILE'    => '檢視會員個人資料',
	'VIEWING_PRIVATE_MESSAGES'  => '檢視私人訊息',
	'VIEWING_REGISTER'  => '正在註冊帳號',
	'VIEWING_UCP'   => '檢視會員控制台',
	'VIEWS' => '觀看',
	'VIEW_BOOKMARKS'    => '檢視我的最愛',
	'VIEW_FORUM_LOGS'   => '檢視記錄',
	'VIEW_LATEST_POST'  => '檢視最後發表',
	'VIEW_NEWEST_POST'  => '檢視第一篇未讀文章',
	'VIEW_NOTES'    => '檢視會員記錄',
	'VIEW_ONLINE_TIMES'			=> array(
		1   => '這些資料是根據過去 %d 分鐘內使用者的活動記錄',
		2   => '這些資料是根據過去 %d 分鐘內使用者的活動記錄',
	),
	'VIEW_TOPIC'    => '檢視主題',
	'VIEW_TOPIC_ANNOUNCEMENT'   => '公告：',
	'VIEW_TOPIC_GLOBAL' => '全域公告：',
	'VIEW_TOPIC_LOCKED' => '已鎖定：',
	'VIEW_TOPIC_LOGS'   => '檢視記錄',
	'VIEW_TOPIC_MOVED'  => '已移動：',
	'VIEW_TOPIC_POLL'   => '投票：',
	'VIEW_TOPIC_STICKY' => '置頂：',
	'VISIT_WEBSITE' => '參觀網站',

	'WARNINGS'  => '警告',
	'WARN_USER' => '警告會員',
	'WATCH_FORUM_CONFIRM'   => '您確定要訂閱這個版面嗎？',
	'WATCH_FORUM_DETAILED'  => '您確定要訂閱「%s」版面嗎？',
	'WATCH_TOPIC_CONFIRM'   => '您確定要訂閱這個主題嗎？',
	'WATCH_TOPIC_DETAILED'  => '您確定要訂閱「%s」主題嗎？',
	'WELCOME_SUBJECT'   => '歡迎來到 %s 討論區',
	'WEBSITE'   => '網站',
	'WHOIS'				=> 'Whois',
	'WHO_IS_ONLINE' => '誰在線上',
	'WLM'				=> 'WLM',
	'WRONG_PASSWORD'    => '您輸入了錯誤的密碼。',

	'WRONG_DATA_COLOUR'         => '您輸入的顏色值是無效的。',
	'WRONG_DATA_JABBER' => '您輸入的名字不是一個有效的 Jabber 帳號。',
	'WRONG_DATA_LANG'   => '您指定了一個無效的語言。',
	'WRONG_DATA_POST_SD'        => '您所指定的文章排序方向是無效的。',
	'WRONG_DATA_POST_SK'        => '您所指定的文章排序選項是無效的。',
	'WRONG_DATA_TOPIC_SD'       => '您所指定的主題排序方向是無效的。',
	'WRONG_DATA_TOPIC_SK'       => '您所指定的主題排序選項是無效的。',
	'WROTE' => '寫',

	'YAHOO'             => 'Yahoo 即時通',
	'YOUTUBE'			=> 'YouTube',
	'YEAR'  => '年',
	'YEAR_MONTH_DAY'	=> '(YYYY-MM-DD)',
	'YES'   => '是',
	'YOU_LAST_VISIT'    => '最後訪問是：%s',

	'datetime'			=> array(
	'TODAY' => '今天',
	'TOMORROW'  => '明天',
	'YESTERDAY' => '昨天',
		'AGO'		=> array(
	    0       => '少於 1 分鐘以前',
	    1       => '%d 分鐘以前',
	    2       => '%d 分鐘以前',
		),

	'Sunday'    => '星期天',
	'Monday'    => '星期一',
	'Tuesday'   => '星期二',
	'Wednesday' => '星期三',
	'Thursday'  => '星期四',
	'Friday'    => '星期五',
	'Saturday'  => '星期六',

	'Sun'   => '週日',
	'Mon'   => '週一',
	'Tue'   => '週二',
	'Wed'   => '週三',
	'Thu'   => '週四',
	'Fri'   => '週五',
	'Sat'   => '週六',

	'January'   => '一月',
	'February'  => '二月',
	'March' => '三月',
	'April' => '四月',
	'May'   => '五月',
	'June'  => '六月',
	'July'  => '七月',
	'August'    => '八月',
	'September' => '九月',
	'October'   => '十月',
	'November'  => '十一月',
	'December'  => '十二月',

	'Jan'   => '1月',
	'Feb'   => '2月',
	'Mar'   => '3月',
	'Apr'   => '4月',
	'May_short' => '5月',
	'Jun'   => '6月',
	'Jul'   => '7月',
	'Aug'   => '8月',
	'Sep'   => '9月',
	'Oct'   => '10月',
	'Nov'   => '11月',
	'Dec'   => '12月',
	),

	// Timezones can be translated. We use this for the Etc/GMT timezones here,
	// because they are named invers to their offset.
	'timezones'		=> array(
		'UTC'					=> 'UTC',
		'UTC_OFFSET'			=> 'UTC%1$s',
		'UTC_OFFSET_CURRENT'	=> 'UTC%1$s - %2$s',

		'Etc/GMT-12'	=> 'UTC+12',
		'Etc/GMT-11'	=> 'UTC+11',
		'Etc/GMT-10'	=> 'UTC+10',
		'Etc/GMT-9'		=> 'UTC+9',
		'Etc/GMT-8'		=> 'UTC+8',
		'Etc/GMT-7'		=> 'UTC+7',
		'Etc/GMT-6'		=> 'UTC+6',
		'Etc/GMT-5'		=> 'UTC+5',
		'Etc/GMT-4'		=> 'UTC+4',
		'Etc/GMT-3'		=> 'UTC+3',
		'Etc/GMT-2'		=> 'UTC+2',
		'Etc/GMT-1'		=> 'UTC+1',
		'Etc/GMT+1'		=> 'UTC-1',
		'Etc/GMT+2'		=> 'UTC-2',
		'Etc/GMT+3'		=> 'UTC-3',
		'Etc/GMT+4'		=> 'UTC-4',
		'Etc/GMT+5'		=> 'UTC-5',
		'Etc/GMT+6'		=> 'UTC-6',
		'Etc/GMT+7'		=> 'UTC-7',
		'Etc/GMT+8'		=> 'UTC-8',
		'Etc/GMT+9'		=> 'UTC-9',
		'Etc/GMT+10'	=> 'UTC-10',
		'Etc/GMT+11'	=> 'UTC-11',
		'Etc/GMT+12'	=> 'UTC-12',

		'Africa/Abidjan'    => '非洲/阿比讓',
		'Africa/Accra'      => '非洲/阿克拉',
		'Africa/Addis_Ababa'    => '非洲/亞的斯亞貝巴',
		'Africa/Algiers'    => '非洲/阿爾及爾',
		'Africa/Asmara'     => '非洲/阿斯馬拉',
		'Africa/Bamako'     => '非洲/巴馬科',
		'Africa/Bangui'     => '非洲/班吉',
		'Africa/Banjul'     => '非洲/班珠爾',
		'Africa/Bissau'     => '非洲/比紹',
		'Africa/Blantyre'   => '非洲/布蘭太爾',
		'Africa/Brazzaville'    => '非洲/布拉柴維爾',
		'Africa/Bujumbura'  => '非洲/布瓊布拉',
		'Africa/Cairo'      => '非洲/開羅',
		'Africa/Casablanca' => '非洲/卡薩布蘭卡',
		'Africa/Ceuta'      => '非洲/休達',
		'Africa/Conakry'    => '非洲/科納克里',
		'Africa/Dakar'      => '非洲/達喀爾',
		'Africa/Dar_es_Salaam'  => '非洲/達累斯薩拉姆',
		'Africa/Djibouti'   => '非洲/吉布提',
		'Africa/Douala'     => '非洲/杜阿拉',
		'Africa/El_Aaiun'   => '非洲/阿尤恩',
		'Africa/Freetown'   => '非洲/弗里敦',
		'Africa/Gaborone'   => '非洲/哈博羅內',
		'Africa/Harare'     => '非洲/哈拉雷',
		'Africa/Johannesburg'   => '非洲/約翰尼斯堡',
		'Africa/Juba'       => '非洲/朱巴',
		'Africa/Kampala'    => '非洲/坎培拉',
		'Africa/Khartoum'   => '非洲/喀土穆',
		'Africa/Kigali'     => '非洲/基加利',
		'Africa/Kinshasa'   => '非洲/金沙薩',
		'Africa/Lagos'      => '非洲/拉各斯',
		'Africa/Libreville' => '非洲/利伯維爾',
		'Africa/Lome'       => '非洲/洛美',
		'Africa/Luanda'     => '非洲/羅安達',
		'Africa/Lubumbashi' => '非洲/盧本巴希',
		'Africa/Lusaka'     => '非洲/盧薩卡',
		'Africa/Malabo'     => '非洲/馬拉博',
		'Africa/Maputo'     => '非洲/馬普托',
		'Africa/Maseru'     => '非洲/馬塞盧',
		'Africa/Mbabane'    => '非洲/姆巴巴內',
		'Africa/Mogadishu'  => '非洲/摩加迪沙',
		'Africa/Monrovia'   => '非洲/蒙羅維亞',
		'Africa/Nairobi'    => '非洲/內羅畢',
		'Africa/Ndjamena'   => '非洲/恩賈梅納',
		'Africa/Niamey'     => '非洲/尼亞美',
		'Africa/Nouakchott' => '非洲/努瓦克肖特',
		'Africa/Ouagadougou'    => '非洲/瓦加杜古',
		'Africa/Porto-Novo' => '非洲/波多諾伏',
		'Africa/Sao_Tome'   => '非洲/聖多美',
		'Africa/Tripoli'    => '非洲/的黎波里',
		'Africa/Tunis'      => '非洲/突尼斯',
		'Africa/Windhoek'   => '非洲/溫得和克',

		'America/Adak'      => '美洲/埃達克',
		'America/Anchorage' => '美洲/安克雷奇',
		'America/Anguilla'  => '美洲/安圭拉',
		'America/Antigua'   => '美洲/安提瓜',
		'America/Araguaina' => '美洲/阿拉瓜伊納',

		'America/Argentina/Buenos_Aires'    => '美洲/阿根廷/布宜諾斯艾利斯',
		'America/Argentina/Catamarca'   => '美洲/阿根廷/卡塔馬卡',
		'America/Argentina/Cordoba'     => '美洲/阿根廷/科爾多瓦',
		'America/Argentina/Jujuy'       => '美洲/阿根廷/胡胡伊',
		'America/Argentina/La_Rioja'    => '美洲/阿根廷/拉里奧哈',
		'America/Argentina/Mendoza'     => '美洲/阿根廷/門多薩',
		'America/Argentina/Rio_Gallegos'    => '美洲/阿根廷/里奧加耶戈斯',
		'America/Argentina/Salta'       => '美洲/阿根廷/薩爾塔',
		'America/Argentina/San_Juan'    => '美洲/阿根廷/聖胡安',
		'America/Argentina/San_Luis'    => '美洲/阿根廷/聖路易斯',
		'America/Argentina/Tucuman'     => '美洲/阿根廷/圖庫曼',
		'America/Argentina/Ushuaia'     => '美洲/阿根廷/烏斯懷亞',

		'America/Aruba'         => '美洲/阿魯巴',
		'America/Asuncion'      => '美洲/亞松森',
		'America/Atikokan'      => '美洲/Atikokan',
		'America/Bahia'         => '美洲/巴伊亞',
		'America/Bahia_Banderas'    => '美洲/巴伊亞班德拉斯',
		'America/Barbados'      => '美洲/巴巴多斯',
		'America/Belem'         => '美洲/貝倫',
		'America/Belize'        => '美洲/伯利茲',
		'America/Blanc-Sablon'  => '美洲/勒布朗 - 拉姆',
		'America/Boa_Vista'     => '美洲/博阿維斯塔',
		'America/Bogota'        => '美洲/波哥大',
		'America/Boise'         => '美洲/博伊西',
		'America/Cambridge_Bay' => '美洲/劍橋灣',
		'America/Campo_Grande'  => '美洲/大坎普',
		'America/Cancun'        => '美洲/坎昆',
		'America/Caracas'       => '美洲/加拉加斯',
		'America/Cayenne'       => '美洲/卡宴',
		'America/Cayman'        => '美洲/開曼',
		'America/Chicago'       => '美洲/芝加哥',
		'America/Chihuahua'     => '美洲/奇瓦瓦',
		'America/Costa_Rica'    => '美洲/哥斯大黎加',
		'America/Creston'       => '美洲/克雷斯頓',
		'America/Cuiaba'        => '美洲/庫亞巴',
		'America/Curacao'       => '美洲/庫拉索',
		'America/Danmarkshavn'  => '美洲/丹馬沙',
		'America/Dawson'        => '美洲/道森',
		'America/Dawson_Creek'  => '美洲/道森克里克',
		'America/Denver'        => '美洲/丹佛',
		'America/Detroit'       => '美洲/底特律',
		'America/Dominica'      => '美洲/多米尼加',
		'America/Edmonton'		=> '美洲/埃德蒙頓',
		'America/Eirunepe'		=> '美洲/Eirunepe',
		'America/El_Salvador'	=> '美洲/薩爾瓦多',
		'America/Fortaleza'		=> '美洲/福塔雷薩',
		'America/Glace_Bay'		=> '美洲/格萊斯貝',
		'America/Godthab'		=> '美洲/哥特哈布',
		'America/Goose_Bay'		=> '美洲/鵝灣',
		'America/Grand_Turk'	=> '美洲/大特克島',
		'America/Grenada'		=> '美洲/格林納達',
		'America/Guadeloupe'	=> '美洲/瓜德羅普島',
		'America/Guatemala'		=> '美洲/瓜地馬拉',
		'America/Guayaquil'		=> '美洲/瓜亞基爾',
		'America/Guyana'		=> '美洲/圭亞那',
		'America/Halifax'		=> '美洲/哈利法克斯',
		'America/Havana'		=> '美洲/哈瓦那',
		'America/Hermosillo'		=> '美洲/埃莫西',
		'America/Indiana/Indianapolis'	=> '美洲/印第安納州/印第安納波利斯',
		'America/Indiana/Knox'		=> '美洲/印第安納州/諾克斯',
		'America/Indiana/Marengo'	=> '美洲/印第安納州/馬倫哥',
		'America/Indiana/Petersburg'	=> '美洲/印第安納州/聖彼得堡',
		'America/Indiana/Tell_City'	=> '美洲/印第安納州/特爾城',
		'America/Indiana/Vevay'		=> '美洲/印第安納州/維維',
		'America/Indiana/Vincennes'	=> '美洲/印第安納州/文森斯',
		'America/Indiana/Winamac'	=> '美洲/印第安納州/威納馬克',
		'America/Inuvik'		=> '美洲/伊努維克',
		'America/Iqaluit'		=> '美洲/伊魁特',
		'America/Jamaica'		=> '美洲/牙買加',
		'America/Juneau'		=> '美洲/朱諾',
		'America/Kentucky/Louisville'	=> '美洲/肯塔基州/路易斯維爾',
		'America/Kentucky/Monticello'	=> '美洲/肯塔基州/蒙蒂塞洛',
		'America/Kralendijk'	=> '美洲/克拉倫代克',
		'America/La_Paz'		=> '美洲/拉巴斯',
		'America/Lima'			=> '美洲/利馬',
		'America/Los_Angeles'	=> '美洲/洛杉磯',
		'America/Lower_Princes'	=> '美洲/下王子',
		'America/Maceio'		=> '美洲/馬塞約',
		'America/Managua'		=> '美洲/馬那瓜',
		'America/Manaus'		=> '美洲/馬瑙斯',
		'America/Marigot'		=> '美洲/馬里戈特',
		'America/Martinique'    => '美洲/馬提尼克',
		'America/Matamoros'     => '美洲/馬塔莫羅斯',
		'America/Mazatlan'      => '美洲/馬薩特蘭',
		'America/Menominee'     => '美洲/梅諾米尼',
		'America/Merida'        => '美洲/梅里達',
		'America/Metlakatla'    => '美洲/Metlakatla',
		'America/Mexico_City'   => '美洲/墨西哥城',
		'America/Miquelon'      => '美洲/密克隆群島',
		'America/Moncton'       => '美洲/蒙克頓',
		'America/Monterrey'     => '美洲/蒙特雷',
		'America/Montevideo'    => '美洲/蒙得維的亞',
		'America/Montreal'      => '美洲/蒙特利爾',
		'America/Montserrat'    => '美洲/蒙特塞拉特',
		'America/Nassau'        => '美洲/拿騷',
		'America/New_York'      => '美洲/紐約',
		'America/Nipigon'       => '美洲/尼皮貢',
		'America/Nome'          => '美洲/諾姆',
		'America/Noronha'       => '美洲/迪諾羅尼亞',
		'America/North_Dakota/Beulah'       => '美洲/北達科他州/比尤拉',
		'America/North_Dakota/Center'       => '美洲/北達科他州/中心',
		'America/North_Dakota/New_Salem'    => '美洲/北達科他州/新塞勒姆',
		'America/Ojinaga'       => '美洲/Ojinaga',
		'America/Panama'        => '美洲/巴拿馬',
		'America/Pangnirtung'   => '美洲/龐納唐',
		'America/Paramaribo'    => '美洲/帕拉馬里博',
		'America/Phoenix'       => '美洲/鳳凰城',
		'America/Port-au-Prince'    => '美洲/太子港',
		'America/Port_of_Spain' => '美洲/西班牙港',
		'America/Porto_Velho'   => '美洲/波多韋柳',
		'America/Puerto_Rico'   => '美洲/波多黎各',
		'America/Rainy_River'   => '美洲/雷尼里弗',
		'America/Rankin_Inlet'  => '美洲/蘭金因萊特',
		'America/Recife'        => '美洲/累西腓',
		'America/Regina'        => '美洲/里賈納',
		'America/Resolute'      => '美洲/堅決',
		'America/Rio_Branco'    => '美洲/里奧布朗庫',
		'America/Santa_Isabel'  => '美洲/聖伊莎貝爾',
		'America/Santarem'      => '美洲/聖塔倫',
		'America/Santiago'      => '美洲/聖地亞哥',
		'America/Santo_Domingo' => '美洲/聖多明各',
		'America/Sao_Paulo'     => '美洲/聖保羅',
		'America/Scoresbysund'  => '美洲/斯科斯比松',
		'America/Shiprock'      => '美洲/Shiprock',
		'America/Sitka'         => '美洲/錫特卡',
		'America/St_Barthelemy' => '美洲/聖．繆',
		'America/St_Johns'      => '美洲/聖．約翰斯',
		'America/St_Kitts'      => '美洲/聖．聖基茨',
		'America/St_Lucia'      => '美洲/聖．聖盧西亞',
		'America/St_Thomas'     => '美洲/聖．托馬斯',
		'America/St_Vincent'    => '美洲/聖．文森特',
		'America/Swift_Current' => '美洲/斯威夫特卡倫特',
		'America/Tegucigalpa'   => '美洲/特古西加爾巴',
		'America/Thule'         => '美洲/圖勒',
		'America/Thunder_Bay'   => '美洲/桑德貝',
		'America/Tijuana'       => '美洲/蒂華納',
		'America/Toronto'       => '美洲/多倫多',
		'America/Tortola'       => '美洲/托爾托拉',
		'America/Vancouver'     => '美洲/溫哥華',
		'America/Whitehorse'    => '美洲/白馬',
		'America/Winnipeg'      => '美洲/溫尼伯',
		'America/Yakutat'       => '美洲/亞庫塔特',
		'America/Yellowknife'   => '美洲/耶洛奈夫',

		'Antarctica/Casey'      => '南極洲/凱西',
		'Antarctica/Davis'      => '南極洲/戴維斯',
		'Antarctica/DumontDUrville' => '南極洲/迪蒙迪維爾站',
		'Antarctica/Macquarie'  => '南極洲/麥格理',
		'Antarctica/Mawson'     => '南極洲/莫森',
		'Antarctica/McMurdo'    => '南極洲/麥克默多',
		'Antarctica/Palmer'     => '南極洲/帕爾默',
		'Antarctica/Rothera'    => '南極洲/羅西拉',
		'Antarctica/South_Pole' => '南極洲/南極',
		'Antarctica/Syowa'      => '南極洲/昭和',
		'Antarctica/Vostok'     => '南極洲/東方',

		'Arctic/Longyearbyen'   => '北極/朗伊爾城',

		'Asia/Aden'         => '亞洲/亞丁',
		'Asia/Almaty'       => '亞洲/阿拉木圖',
		'Asia/Amman'        => '亞洲/安曼',
		'Asia/Anadyr'       => '亞洲/阿納德爾',
		'Asia/Aqtau'        => '亞洲/阿克陶',
		'Asia/Aqtobe'       => '亞洲/阿克托別',
		'Asia/Ashgabat'     => '亞洲/阿什哈巴德',
		'Asia/Baghdad'      => '亞洲/巴格達',
		'Asia/Bahrain'      => '亞洲/巴林',
		'Asia/Baku'         => '亞洲/巴庫',
		'Asia/Bangkok'      => '亞洲/曼谷',
		'Asia/Beirut'       => '亞洲/貝魯特',
		'Asia/Bishkek'      => '亞洲/比什凱克',
		'Asia/Brunei'       => '亞洲/文萊',
		'Asia/Choibalsan'   => '亞洲/喬巴山',
		'Asia/Chongqing'    => '亞洲/重慶',
		'Asia/Colombo'      => '亞洲/科倫坡',
		'Asia/Damascus'     => '亞洲/大馬士革',
		'Asia/Dhaka'        => '亞洲/達卡',
		'Asia/Dili'         => '亞洲/帝力',
		'Asia/Dubai'        => '亞洲/杜拜',
		'Asia/Dushanbe'     => '亞洲/杜尚別',
		'Asia/Gaza'         => '亞洲/加沙',
		'Asia/Harbin'       => '亞洲/哈爾濱',
		'Asia/Hebron'       => '亞洲/希伯倫',
		'Asia/Ho_Chi_Minh'  => '亞洲/胡志明',
		'Asia/Hong_Kong'    => '亞洲/香港',
		'Asia/Hovd'         => '亞洲/科布多',
		'Asia/Irkutsk'      => '亞洲/伊爾庫茨克',
		'Asia/Jakarta'      => '亞洲/雅加達',
		'Asia/Jayapura'     => '亞洲/查亞普拉',
		'Asia/Jerusalem'    => '亞洲/耶路撒冷',
		'Asia/Kabul'        => '亞洲/喀布爾',
		'Asia/Kamchatka'    => '亞洲/堪察加',
		'Asia/Karachi'      => '亞洲/卡拉奇',
		'Asia/Kashgar'      => '亞洲/喀什',
		'Asia/Kathmandu'    => '亞洲/加德滿都',
		'Asia/Khandyga'     => '亞洲/ Khandyga',
		'Asia/Kolkata'      => '亞洲/加爾各答',
		'Asia/Krasnoyarsk'  => '亞洲/克拉斯諾亞爾斯克',
		'Asia/Kuala_Lumpur' => '亞洲/吉隆坡',
		'Asia/Kuching'      => '亞洲/古晉',
		'Asia/Kuwait'       => '亞洲/科威特',
		'Asia/Macau'        => '亞洲/澳門',
		'Asia/Magadan'      => '亞洲/馬加丹',
		'Asia/Makassar'     => '亞洲/望加錫',
		'Asia/Manila'       => '亞洲/馬尼拉',
		'Asia/Muscat'       => '亞洲/馬斯喀特',
		'Asia/Nicosia'      => '亞洲/尼科西亞',
		'Asia/Novokuznetsk' => '亞洲/新庫茲涅茨克',
		'Asia/Novosibirsk'  => '亞洲/新西伯利亞',
		'Asia/Omsk'         => '亞洲/鄂木斯克',
		'Asia/Oral'         => '亞洲/西哈薩克斯坦',
		'Asia/Phnom_Penh'   => '亞洲/金邊',
		'Asia/Pontianak'    => '亞洲/坤甸',
		'Asia/Pyongyang'    => '亞洲/平壤',
		'Asia/Qatar'        => '亞洲/卡塔爾',
		'Asia/Qyzylorda'    => '亞洲/克孜勒奧爾達',
		'Asia/Rangoon'      => '亞洲/仰光',
		'Asia/Riyadh'       => '亞洲/利雅得',
		'Asia/Sakhalin'     => '亞洲/薩哈林',
		'Asia/Samarkand'    => '亞洲/撒馬爾罕',
		'Asia/Seoul'        => '亞洲/首爾',
		'Asia/Shanghai'     => '亞洲/上海',
		'Asia/Singapore'    => '亞洲/新加坡',
		'Asia/Taipei'       => '亞洲/台北',
		'Asia/Tashkent'     => '亞洲/塔什幹',
		'Asia/Tbilisi'      => '亞洲/第比利斯',
		'Asia/Tehran'       => '亞洲/德黑蘭',
		'Asia/Thimphu'      => '亞洲/廷布',
		'Asia/Tokyo'        => '亞洲/東京',
		'Asia/Ulaanbaatar'  => '亞洲/烏蘭巴托',
		'Asia/Urumqi'       => '亞洲/烏魯木齊',
		'Asia/Ust-Nera'     => '亞洲/烏斯季挪拉',
		'Asia/Vientiane'    => '亞洲/萬象',
		'Asia/Vladivostok'  => '亞洲/符拉迪沃斯托克',
		'Asia/Yakutsk'      => '亞洲/雅庫茨克',
		'Asia/Yekaterinburg'    => '亞洲/葉卡捷琳堡',
		'Asia/Yerevan'      => '亞洲/埃里溫',

		'Atlantic/Azores'       => '大西洋/亞速爾群島',
		'Atlantic/Bermuda'      => '大西洋/百慕達',
		'Atlantic/Canary'       => '大西洋/加那利',
		'Atlantic/Cape_Verde'   => '大西洋/佛得角',
		'Atlantic/Faroe'        => '大西洋/法羅',
		'Atlantic/Madeira'      => '大西洋/馬德拉',
		'Atlantic/Reykjavik'    => '大西洋/雷克雅未克',
		'Atlantic/South_Georgia'    => '大西洋/南喬治亞',
		'Atlantic/St_Helena'    => '大西洋/聖．海倫娜',
		'Atlantic/Stanley'      => '大西洋/斯坦利',

		'Australia/Adelaide'    => '澳洲/阿德萊德',
		'Australia/Brisbane'    => '澳洲/布里斯班',
		'Australia/Broken_Hill' => '澳洲/斷山',
		'Australia/Currie'      => '澳洲/柯里',
		'Australia/Darwin'      => '澳洲/達爾文',
		'Australia/Eucla'       => '澳洲/尤克拉',
		'Australia/Hobart'      => '澳洲/霍巴特',
		'Australia/Lindeman'    => '澳洲/林德曼',
		'Australia/Lord_Howe'   => '澳洲/豪勳爵',
		'Australia/Melbourne'   => '澳洲/墨爾本',
		'Australia/Perth'       => '澳洲/珀斯',
		'Australia/Sydney'      => '澳洲/雪梨',

		'Europe/Amsterdam'  => '歐洲/阿姆斯特丹',
		'Europe/Andorra'    => '歐洲/安道爾',
		'Europe/Athens'     => '歐洲/雅典',
		'Europe/Belgrade'   => '歐洲/貝爾格萊德',
		'Europe/Berlin'     => '歐洲/柏林',
		'Europe/Bratislava' => '歐洲/布拉迪斯拉發',
		'Europe/Brussels'   => '歐洲/布魯塞爾',
		'Europe/Bucharest'  => '歐洲/布加勒斯特',
		'Europe/Budapest'   => '歐洲/布達佩斯',
		'Europe/Busingen'   => '歐洲/布辛根',
		'Europe/Chisinau'   => '歐洲/基希訥烏',
		'Europe/Copenhagen' => '歐洲/哥本哈根',
		'Europe/Dublin'     => '歐洲/都柏林',
		'Europe/Gibraltar'  => '歐洲/直布羅陀',
		'Europe/Guernsey'   => '歐洲/根西島',
		'Europe/Helsinki'   => '歐洲/赫爾辛基',
		'Europe/Isle_of_Man'    => '歐洲/馬恩島',
		'Europe/Istanbul'   => '歐洲/伊斯坦布爾',
		'Europe/Jersey'     => '歐洲/新澤西',
		'Europe/Kaliningrad'    => '歐洲/加里寧格勒',
		'Europe/Kiev'		=> '歐洲/基輔',
		'Europe/Lisbon'		=> '歐洲/里斯本',
		'Europe/Ljubljana'	=> '歐洲/盧布爾雅那',
		'Europe/London'		=> '歐洲/倫敦',
		'Europe/Luxembourg'	=> '歐洲/盧森堡',
		'Europe/Madrid'		=> '歐洲/馬德里',
		'Europe/Malta'		=> '歐洲/馬耳他',
		'Europe/Mariehamn'	=> '歐洲/瑪麗港',
		'Europe/Minsk'		=> '歐洲/明斯克',
		'Europe/Monaco'		=> '歐洲/摩納哥',
		'Europe/Moscow'		=> '歐洲/莫斯科',
		'Europe/Oslo'		=> '歐洲/奧斯陸',
		'Europe/Paris'		=> '歐洲/巴黎',
		'Europe/Podgorica'	=> '歐洲/波德戈里察',
		'Europe/Prague'		=> '歐洲/布拉格',
		'Europe/Riga'		=> '歐洲/裡加',
		'Europe/Rome'		=> '歐洲/羅馬',
		'Europe/Samara'		=> '歐洲/薩馬拉',
		'Europe/San_Marino' => '歐洲/聖馬力諾',
		'Europe/Sarajevo'   => '歐洲/薩拉熱窩',
		'Europe/Simferopol' => '歐洲/辛菲羅波爾',
		'Europe/Skopje'     => '歐洲/斯科普里',
		'Europe/Sofia'      => '歐洲/索非亞',
		'Europe/Stockholm'  => '歐洲/斯德哥爾摩',
		'Europe/Tallinn'    => '歐洲/塔林',
		'Europe/Tirane'     => '歐洲/地拉那',
		'Europe/Uzhgorod'   => '歐洲/烏日哥羅德',
		'Europe/Vaduz'      => '歐洲/瓦杜茲',
		'Europe/Vatican'    => '歐洲/梵蒂岡',
		'Europe/Vienna'     => '歐洲/維也納',
		'Europe/Vilnius'    => '歐洲/維爾紐斯',
		'Europe/Volgograd'  => '歐洲/伏爾加格勒',
		'Europe/Warsaw'     => '歐洲/華沙',
		'Europe/Zagreb'     => '歐洲/薩格勒布',
		'Europe/Zaporozhye' => '歐洲/扎波羅熱',
		'Europe/Zurich'     => '歐洲/蘇黎世',

		'Indian/Antananarivo'   => '印度/塔那那利佛',
		'Indian/Chagos'     => '印度/查戈斯',
		'Indian/Christmas'  => '印度/聖誕',
		'Indian/Cocos'      => '印度/科科斯',
		'Indian/Comoro'     => '印度/科摩羅',
		'Indian/Kerguelen'  => '印度/凱爾蓋朗',
		'Indian/Mahe'       => '印度/馬埃',
		'Indian/Maldives'   => '印度/馬爾地夫',
		'Indian/Mauritius'  => '印度/毛里求斯',
		'Indian/Mayotte'    => '印度/馬約特島',
		'Indian/Reunion'    => '印度/留尼汪',

		'Pacific/Apia'      => '太平洋/阿皮亞',
		'Pacific/Auckland'  => '太平洋/奧克蘭',
		'Pacific/Chatham'   => '太平洋/查塔姆',
		'Pacific/Chuuk'     => '太平洋/特魯克',
		'Pacific/Easter'    => '太平洋/復活島',
		'Pacific/Efate'     => '太平洋/埃法特島',
		'Pacific/Enderbury' => '太平洋/恩德貝里',
		'Pacific/Fakaofo'   => '太平洋/法考福',
		'Pacific/Fiji'      => '太平洋/斐濟',
		'Pacific/Funafuti'  => '太平洋/富納富提',
		'Pacific/Galapagos' => '太平洋/加拉帕戈斯',
		'Pacific/Gambier'   => '太平洋/甘比爾',
		'Pacific/Guadalcanal'   => '太平洋/瓜達爾卡納爾島',
		'Pacific/Guam'      => '太平洋/關島',
		'Pacific/Honolulu'  => '太平洋/火奴魯魯',
		'Pacific/Johnston'  => '太平洋/約翰斯頓',
		'Pacific/Kiritimati'    => '太平洋/克里斯馬斯',
		'Pacific/Kosrae'    => '太平洋/科斯雷',
		'Pacific/Kwajalein' => '太平洋/誇賈林',
		'Pacific/Majuro'    => '太平洋/馬朱羅',
		'Pacific/Marquesas' => '太平洋/馬克薩斯',
		'Pacific/Midway'    => '太平洋/中途島',
		'Pacific/Nauru'     => '太平洋/瑙魯',
		'Pacific/Niue'      => '太平洋/紐埃',
		'Pacific/Norfolk'   => '太平洋/諾福克',
		'Pacific/Noumea'    => '太平洋/努美阿',
		'Pacific/Pago_Pago' => '太平洋/帕果帕果',
		'Pacific/Palau'     => '太平洋/帛琉',
		'Pacific/Pitcairn'  => '太平洋/皮特克恩',
		'Pacific/Pohnpei'   => '太平洋/波納佩',
		'Pacific/Port_Moresby'  => '太平洋/莫爾茲比港',
		'Pacific/Rarotonga' => '太平洋/拉羅湯加島',
		'Pacific/Saipan'    => '太平洋/塞班島',
		'Pacific/Tahiti'    => '太平洋/塔希提島',
		'Pacific/Tarawa'    => '太平洋/塔拉瓦',
		'Pacific/Tongatapu' => '太平洋/湯加塔布',
		'Pacific/Wake'      => '太平洋/威克島',
		'Pacific/Wallis'    => '太平洋/沃利斯',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'j日 M Y年, H:i'          => '1日 1月 2007年, 13:37',
		'Y-m-d, H:i'                => '2007-01-01, 13:37',
		'M 第j天, \'y年, H:i'      => '1月 第1天, \'07年, 13:37',
		'D M j日, Y年 g:i a'      => '週一 1月 1日, 2007年 1:37 pm',
		'F 第j天, Y年, g:i a'      => '一月 第j天, 2007年, 1:37 pm',
		'|j日 M Y年|, H:i'            => '今天, 13:37 / 1日 1月 2007年, 13:37',
		'|F 第j天, Y年|, g:i a'        => '今天, 1:37 pm / 一月 第j天, 2007年, 1:37 pm',
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'    => 'Y年 M j日, H:i', // 2007年 1月 1日, 13:37

));
