<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice beta2 2013.12.30
 * @link        http://www.dzzoffice.com
 * @author      zyx(zyx@dzz.cc)
 */

//php 权限控制类
/*目前使用的简易权限
1    	flag	    1     	标准位为1表示权限设置否则表示未设置，继承上级
2       read	 	2		只读
2		write     	4      	可写权限   
	
*/
/*权限表说明:
位   描述       	权限值  描述
1    flag			1       标准位为1表示权限设置否则表示未设置，继承上级；
2 	 upload      	2		上传	
3 	newfolder   	4		新建文件夹
4	 newlink		8		新建链接
5 	 newdoc			16		新建文档
6    newtopic       32      新建话题
6	 addapp			32		添加应用
7 	 addwidget		64		添加挂件
8 	 delete			128		允许所有者删除自己的文件或文件夹
9 	 permedit		256		允许所有者编辑容器权限
10	 share			512		允许分享



有新的权限在这里添加 
由于数据库存储是smallint(6),最大支持16位权限；（32位系统最多支持32位，64位系统最多支持64位；
 */ 
class perm_binPerm{  
  
  var $power = "";  //权限存贮变量,十进制整数 
  var $powerarr=array('flag' 		=> 1,		//标志位为1表示权限设置,否则表示未设置，继承上级；
  					  'read'		=> 2,		//只读
					  'write'		=> 4,		//可写
					
					);
   var $powertitle=array( 
					  'flag' 	    => '不继承上级权限',		
					  'read'	    => '允许上传',			
					  'write'		 => '可写',	
					);
	 var $powertip=array( 
					  'flag' 	    => '只有选中此按钮，才能有效的设置，否则只会继承上级的权限',				//标志位为1表示权限设置,否则表示未设置，继承上级
					  'read'	    => '只读',				//上传
					  'write' 		=> '可写',	
					);
    
  function __construct($power){  
    $this->power = intval($power);  
  }  


  function addPower($action){ 
  	 
    //利用逻辑或添加权限
	 if(isset($this->powerarr[$action])) $this->power = $this->power | intval($this->powerarr[$action]);  
  }  
   
  function mergePower($perm) { //合成权限，使用于系统权限和用户权限合成
	 $this->power = intval($this->power & intval($perm));  
  }
    
  function delPower($action){  
    //删除权限，先将预删除的权限取反，再进行与操作  
    if(isset($this->powerarr[$action]))  $this->power = $this->power & ~intval($this->powerarr[$action]);  
  }  
    
  function isPower($action){  
    //权限比较时，进行与操作，得到0的话，表示没有权限
	
    if(($this->power & intval($this->powerarr[$action])) == 0 ) return 0;  
    return 1;  
  }  
    
  function returnPower(){  
    //为了减少存贮位数，返回也可以转化为十六进制  
    return $this->power;  
  }  
 function returnPowerArr($noflag=false){
	  //返回当前所有权限的值数组
	  $arr=array();
	  foreach($this->powerarr as $action =>$val){
		  if($noflag && $action=='flag') continue;
		 $arr[$action] = array($val,$this->powertitle[$action],$this->isPower($action),$this->powertip[$action]);
	  }
	  return $arr;
  }
}  
?>
