<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice beta2 2013.12.30
 * @link        http://www.dzzoffice.com
 * @author      zyx(zyx@dzz.cc)
 */

if(!defined('IN_DZZ')) {
	exit('Access Denied');
}

class table_feed_attach extends dzz_table
{
	public function __construct() {

		$this->_table = 'feed_attach';
		$this->_pk    = 'qid';

		parent::__construct();
	}
	public function fetch_by_qid($qid){
		global $_G;
		if(!$data=self::fetch($qid)) return false;
		$attach=C::t('attachment')->fetch($data['aid']);
		
		if(in_array(strtolower($attach['filetype']),array('png','jpeg','jpg','gif'))){
				$attach['img']=getAttachUrl($attach);
				$attach['isimage']=1;
			}else{
				$attach['img']=geticonfromext($attach['filetype'],'');
				$attach['isimage']=0;
			}
			$attach['url']=getAttachUrl($attach);
		return array_merge($attach,$data);
		
	}
    public function delete_by_pid($pids){
		$qids=array();
		foreach(DB::fetch_all("select qid,aid from %t where pid IN (%n) ",array('feed_attach',$pids)) as $value){
		   C::t('attachment')->delete_by_aid($value['aid']);
		   $qids[]=$value['qid'];
	   }
	   self::delete($qids);
	}
	public function fetch_all_by_pid($pid){
		global $_G;
		$data=array();
		$openext=C::t('app_open')->fetch_all_orderby_ext($_G['uid']);
		foreach(DB::fetch_all("select * from %t where pid= %d",array($this->_table,$pid)) as $value){
			$attach=C::t('attachment')->fetch($value['aid']);
			if(in_array(strtolower($attach['filetype']),array('png','jpeg','jpg','gif','bmp'))){
				$attach['img']=getAttachUrl($attach);
				$attach['isimage']=1;
			}else{
				$attach['img']=geticonfromext($attach['filetype'],'');
				$attach['isimage']=0;
			}
			if(isset($openext[$attach['filetype']])) $attach['preview']=1;
			$attach['filesize']=formatsize($attach['filesize']);
			$data[$value['qid']]=array_merge($value,$attach);
		}
		return $data;
	}
}

?>
