<?php
defined('WEKIT_VERSION') or exit(403);
Wind::import('ADMIN:library.AdminBaseController');
/**
 * 后台访问入口
 *
 * generated by phpwind.com
 */
class ManageController extends AdminBaseController {
	
	public function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);
		//TODO do something before all the action
	}
	
	public function run() {
        $conf = Wekit::C('app_oculus');
		$this->setOutput($conf, 'conf');
	}

    public function doRunAction()
	{       
            
        Wind::import('EXT:oculus.lib.OculusApi');
        $is_reg_open = $this->getInput('is_reg_open', 'post');
        $is_login_open = $this->getInput('is_login_open', 'post');
        $is_bbspost_open = $this->getInput('is_bbspost_open', 'post');


        $afs_key = Wekit::C('app_oculus', 'afs_key');
        if(isset($afs_key) && strlen($afs_key) > 0) {
            $oculus_config = new PwConfigSet('app_oculus');
            $oculus_config->set("is_reg_open", $is_reg_open)
                ->set("is_login_open", $is_login_open)
                ->set("is_bbspost_open", $is_bbspost_open)
                ->set("afs_key", $afs_key)
                ->flush();
            $this->showMessage('success');
            return;
        }


        Wind::import('EXT:oculus.top.TopClient');
        $top_client = new TopClient();
        $top_client->format = 'json';

        $account_id = uniqid();
        Wind::import('EXT:oculus.top.request.AlibabaSecurityTuringPlatformAccessAddPlatformUserRequest');
        $req = new AlibabaSecurityTuringPlatformAccessAddPlatformUserRequest();
        Wind::import('EXT:oculus.top.domain.PlatformUserInfo');
        $platform_user_info = new PlatformUserInfo();

        $site_name = Wekit::C('site', 'info.name');
        if(! isset($site_name) || $site_name == '') {
            $site_name = 'default_site_name';
        }
        $site_name = urlencode($site_name);
        if(strlen($site_name) > 50) {
            $site_name = substr($site_name, 0, 50);
        }
        $platform_user_info->account_name = $site_name;
        $platform_user_info->app_id = $site_name;
        $platform_user_info->account_id = $account_id;


        $site_url = Wekit::C('site', 'info.url');
        if(! isset($site_url) || $site_url == '') {
            $site_url = "default_url";
        }
        $site_url = urlencode($site_url);
        if(strlen($site_url) > 100) {
            $site_url = substr($site_url, 0, 100);
        }
        $platform_user_info->company_name = $site_url;
        $platform_user_info->user_type = "10";
        $platform_user_info->web_type_list = array (
            2,
            4
        );
        $req->setPlatformUserInfo(json_encode($platform_user_info));
        $times = 0;
        do {
            $resp = $top_client->execute($req);
            $times ++;
        } while(! isset($resp->data) && $times <= 3);

        $project_id = 0;
        if(isset($resp->data)) {
            $project_id = intval($resp->data->turing_riskcontorl_project_id);
        } else {
            throw new Exception("Create Account Error!" . json_encode($resp));
        }

        Wind::import('EXT:oculus.top.request.AlibabaSecurityTuringPlatformAccessJsFetchRequest');
        $fetchJsReq = new AlibabaSecurityTuringPlatformAccessJsFetchRequest();
        Wind::import('EXT:oculus.top.domain.PlatformJsParam');
        $platform_js_param = new PlatformJsParam();
        $platform_js_param->turing_riskcontrol_project_id = $project_id;
        $fetchJsReq->setPlatformJsParam(json_encode($platform_js_param));
        $fetchJsResp = $top_client->execute($fetchJsReq);
        $afs_key = "";
        if(isset($fetchJsResp->data)) {
            $afs_key = $fetchJsResp->data->afs_key;
        }
        if(isset($afs_key) && $afs_key != "") {
            $oculus_config = new PwConfigSet('app_oculus');
            $oculus_config->set("is_reg_open", $is_reg_open)
                ->set("is_login_open", $is_login_open)
                ->set("is_bbspost_open", $is_bbspost_open)
                ->set("afs_key", $afs_key)
                ->flush();
        } else {
            throw new Exception("Create Account Error!" . json_encode($resp));
        }

		$this->showMessage('success');
	}
}
?>