<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'admin/control/admin_control.class.php';

class api_control extends admin_control {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->_checked = array('bbs'=>' class="checked"');
		$this->check_admin_group();
	}
	public function on_index(){
		if($this->form_submit()){
			$post=array();
			$post['name']=core::gpc('name','P');	
		    $post['fid']=intval(core::gpc('fid','P'));	
			$post['digest']=intval(core::gpc('digest','P'));
			$post['top']=intval(core::gpc('top','P'));	
			$post['typeid']=intval(core::gpc('typeid','P'));	
			$post['rank']=intval(core::gpc('rank','P'));	
			$post['num']=intval(core::gpc('num','P'));
			$post['cache']=intval(core::gpc('cache','P'));
			
			$post['name']=misc::safe_str($post['name']);
			if(empty($post['name'])) $this->message('请填写调用名称');
			$post=core::json_encode($post);
			$this->api->create(array('setting'=>$post));
			$this->message('调用添加成功',1,'?api.htm');
		}
		$apilist=$this->api->index_fetch(array(),array('id'=>-1),0,100);
		foreach($apilist as &$a){
			$this->api->format($a);
			$wh=$this->conf['urlrewrite']?'':'?';
			$a['tpl']='{xc:api id="'.$a['id'].'"}';
			$a['src']='<script type="text/javascript" src="'.$this->conf['post_url'].$wh.'api-topic-id-'.$a['id'].'-f-json.htm"></script>';
		}
		$input=array();
		$input['digest']=form::get_radio('digest',array(0=>'所有帖子',1=>'全部精华',2=>'精华一','3'=>'精华二',4=>'精华三'),0);
		$input['top']=form::get_radio('top',array(0=>'所有帖子',1=>'全站置顶',2=>'本吧置顶'),0);
		$input['typeid']=form::get_text('typeid','0',100);
		$input['uid']=form::get_text('uid','0',100);
		$input['rank']=form::get_radio('rank',array(0=>'发表时间',1=>'回复时间',2=>'回帖数量'),0);
		$input['num']=form::get_text('num','10',100);
		$input['name']=form::get_text('name','',200);
		$input['cache']=form::get_text('cache','0',100);
		
		
		$this->view->assign('apilist',$apilist);
		$this->view->assign('input',$input);
		$this->view->display('api_index.html');
	}
	public function on_delete(){
		if($this->form_submit()){
			$ids=(array)core::gpc('ids','P');
			foreach($ids as $id){
			  $id=intval($id);
			  $this->api->delete($id);	
			}
			$this->message('删除成功',1,'?api.htm');
		}
	}
	
}

?>