<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'core/control/common_control.class.php';

class forum_mod_control extends common_control {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->check_login();
		if($this->_user['groupid'] > 5) {
			$this->message('对不起，您没有权限访问此版块。');
		}
		
		// 加载精华积分策略
		$this->conf += $this->kv->xget('conf_ext');
		
		// 检查IP 屏蔽
		$this->check_ip();
	}
	public function on_index(){
		$fid=intval(core::gpc('fid'));
		$forum = $this->forum->read($fid);
		if(!$forum) $this->message('板块不存在',0);
		$ismod = $this->is_mod($forum, $this->_user);
		if(!$ismod) $this->message('您无权查看该页面',0);
		if($this->form_submit()){
		     $description=htmlspecialchars(core::gpc('description','P'));	
			 $description=strip_tags($description);
			 $description=utf8::safe_substr($description,0,255);
			 $user_join=intval(core::gpc('user_join','P'));
			 $user_post=intval(core::gpc('user_post','P'));
			 $forum_bg=core::gpc('forum_bg','P');
			 
			 
			 
			 $error=array();
			 if($forum_bg && !check::is_url($forum_bg)) $error['forum_bg']='板块背景图片不正确';
			 if(!array_filter($error)){
				 $forum['description']=$description;
				 $forum['user_join']=$user_join;
				 $forum['user_post']=$user_post;
				 $forum['forum_bg']=$forum_bg;
				 if($this->_user['groupid']==1){
					 // 版主
					$post = array();
					$post['modnames'] = trim(core::gpc('modnames', 'P'));
					$modids = $modnames = '';
					$post['modnames'] = str_replace(array('　', "\t", '  '), ' ', $post['modnames']);
					$modnamearr = explode(' ', $post['modnames']);
					$modnamearr = array_unique($modnamearr);
					$modnamearr = array_slice($modnamearr, 0, 6);	// 最多6个
					foreach($modnamearr as $modname) {
						if(trim($modname)=='') continue;
						$_user = $this->member->get_user_by_username($modname);
						if($_user) {
							$_user && $modids .= ' '.$_user['uid'];
							$modnames .= ' '.$_user['username'];
							// 调整用户组
							$groupid = 4;
							$user = $this->member->read($_user['uid']);
							$user['groupid'] = $groupid > $user['groupid'] ? $user['groupid'] : $groupid;// 提升版主权限
							$this->member->update($user);
						}
					}
					$forum['modids'] = trim($modids);
					$forum['modnames'] = trim($modnames);
				 }
				 $this->forum->update($forum);
				 $this->mcache->clear('forum',$fid);
				 
				 $this->modlog->create(array(
					'uid'=>$this->_user['uid'],
					'username'=>$this->_user['username'],
					'fid'=>$fid,
					'dateline'=>$_SERVER['time'],
					'subject'=>'',
					'credits'=>0,
					'golds'=>0,
					'action'=>'forum_edit',
					'comment'=>'',
				));
				 
				 $this->message('操作成功');
			 }else{ 
				$this->message($error['forum_bg'],0); 
			 }
			
			
		}
		
		
		
		$this->forum->format($forum);
		
		$this->_checked['forum_mod']=' class="ui-tab-active"';
		$this->_checked['base_info']=' class="current"';
		
		$this->_title[]='贴吧管理';
		
		//是否本吧成员
		$forum_follow=0;
		$this->_user['uid'] && $forum_follow=$this->forum_users->check_status($fid,$this->_user['uid']);
		//forum category
		$cate=array();
		empty($_SERVER['miscarr']) && $_SERVER['miscarr'] = $this->mcache->read('miscarr');
		$miscarr = $_SERVER['miscarr'];
		$cate['pname']=isset($miscarr['category'][$forum['cat_tid']]) ? $miscarr['category'][$forum['cat_tid']] : '';
		$cate['name']=isset($miscarr['category'][$forum['cat_id']]) ? $miscarr['category'][$forum['cat_id']] : '';
		
		$input = array();
		//$input['status'] = form::get_radio_yes_no('status', $forum['status']);
		//$input['recommend'] = form::get_radio_yes_no('recommend', $forum['recommend']);
		//$input['type_default']=form::get_select('type_default',array('topic_all'=>'全部帖子','digest'=>'精华帖子','pic'=>'图片帖子'),$forum['type_default']);
		//$input['typeid']=form::get_select('typeid',$typearr,$forum['typeid']);
		$input['user_join']=form::get_radio('user_join',array(1=>'禁止加入',2=>'自动审核',3=>'吧主审核'),$forum['user_join']);
		$input['user_post']=form::get_radio('user_post',array('1'=>'可发帖',2=>'只能回帖',3=>'禁止发帖'),$forum['user_post']);
		
		$this->view->assign('input',$input);
		$this->view->assign('ismod',$ismod);
		$this->view->assign('fid',$fid);
		$this->view->assign('forum',$forum);
		$this->view->assign('c',$cate);
		$this->view->assign('forum_follow',$forum_follow);
		$this->view->display('forum_mod_index.html');
	}
	//成员管理
	public function on_users(){
	    $fid = intval(core::gpc('fid'));
        $forum = $this->forum->read($fid);
		$this->check_forum_exists($forum);
		
		$ismod = $this->is_mod($forum, $this->_user);
		if(!$ismod) $this->message('您无权查看该页面',0);	
		
		$this->_title[]='成员管理_'.$forum['name'];
		$this->_checked['forum_mod']=' class="ui-tab-active"';
		$this->_checked['forum_mod_users']=' class="current"';
		
		$rank=core::gpc('rank');
		$page=misc::page();
		$limit=10;
		$start=($page-1)*$limit;
		if(in_array($rank,array('topics','posts','lastpost','lastsign','sign_days','dateline','lastsign'))){
		    $order=	array($rank=>-1);
		}else{
			$rank='dateline';
			$order=array('dateline'=>-1);
			//$order=$rank=='posts'?array('posts'=>-1):($rank=='lastpost'?array('lastpost'=>-1):($rank=='signs'?array('sign_days'=>-1):array('dateline'=>-1)));
		}
		$this->_checked['rank_'.$rank]='<font style="font-size:16px;">↓</font>';
		
		$userlist=$this->forum_users->get_list(array('fid'=>$fid),$order,$start,$limit);

		$pages=misc::pages("?forum_mod-users-fid-$fid-rank-$rank.htm",$forum['users'],$page,$limit);
		
		//是否本吧成员
		$forum_follow=0;
		$this->_user['uid'] && $forum_follow=$this->forum_users->check_status($fid,$this->_user['uid']);
		//forum category
		$cate=array();
		empty($_SERVER['miscarr']) && $_SERVER['miscarr'] = $this->mcache->read('miscarr');
		$miscarr = $_SERVER['miscarr'];
		$cate['pname']=isset($miscarr['category'][$forum['cat_tid']]) ? $miscarr['category'][$forum['cat_tid']] : '';
		$cate['name']=isset($miscarr['category'][$forum['cat_id']]) ? $miscarr['category'][$forum['cat_id']] : '';
		
		$this->forum->format($forum);
		
		$this->view->assign('ismod', $ismod);
		$this->view->assign('forum_follow', $forum_follow);
		$this->view->assign('forum',$forum);
		$this->view->assign('rank',$rank);
		$this->view->assign('userlist',$userlist);
		$this->view->assign('fid',$fid);
		$this->view->assign('c',$cate);
		$this->view->assign('pages',$pages);
		$this->view->display('forum_mod_users.html');
	}
	public function on_users_do(){
		$fid = intval(core::gpc('fid'));
        $forum = $this->forum->read($fid);
		$this->check_forum_exists($forum);
		
		$ismod = $this->is_mod($forum, $this->_user);
		if(!$ismod) $this->message('您无权查看该页面',0);	
		
		$t=core::gpc('t');
		$uids=(array)core::gpc('uids','P');
		if($t=='audit'){
			foreach($uids as $uid){
			   $uid=intval($uid);
			   if(!$uid) continue;
			   $rs=$this->forum_users->check_status($fid,$uid);	
			   if($rs && $rs['status']!=1){
				   $rs['status']=1;
				   $this->forum_users->update($rs);
				   $forum['users']++;
			   }
			}
			$this->forum->update($forum);
		    $this->mcache->clear('forum',$fid);
			$action='audit_user';
		}elseif($t=='del'){
			foreach($uids as $uid){
			   $uid=intval($uid);
			   if(!$uid) continue;
			   $rs=$this->forum_users->check_status($fid,$uid);	
			   if($rs){
				   $this->forum_users->delete($fid,$uid);
				   $rs['status']==1 &&  $forum['users']--;
			   }
			}
			$this->forum->update($forum);
		    $this->mcache->clear('forum',$fid);
			$action='del_user';
		}elseif($t=='ref'){
			foreach($uids as $uid){
			   $uid=intval($uid);
			   if(!$uid) continue;
			   $rs=$this->forum_users->check_status($fid,$uid);	
			   if($rs){
				   $rs['status']==1 &&  $forum['users']--;
				   $rs['status']=2;
				   $this->forum_users->update($rs); 
			   }
			}
			$this->forum->update($forum);
		    $this->mcache->clear('forum',$fid);
			$action='audit_user';
		}
		$this->modlog->create(array(
			'uid'=>$this->_user['uid'],
			'username'=>$this->_user['username'],
			'fid'=>$fid,
			'dateline'=>$_SERVER['time'],
			'subject'=>'',
			'credits'=>0,
			'golds'=>0,
			'action'=>$action,
			'comment'=>'',
		));
		$this->message('操作成功',1,'?forum_mod-users-fid-'.$fid.'.htm');	
	}
	//管理记录
	public function on_log(){
		$fid = intval(core::gpc('fid'));
        $forum = $this->forum->read($fid);
		$this->check_forum_exists($forum);
		
		$ismod = $this->is_mod($forum, $this->_user);
		if(!$ismod) $this->message('您无权查看该页面',0);	
		
		$this->_title[]='操作记录_'.$forum['name'];
		$this->_checked['forum_mod']=' class="ui-tab-active"';
		$this->_checked['forum_mod_log']=' class="current"';
		
		$page=misc::page();
		$limit=10;
		//$start=($page-1)*$limit;
        
		$count=$this->modlog->index_count(array('fid'=>$fid));
		$loglist=$this->modlog->get_list_by_fid($fid, $page, $limit) ;

		$pages=misc::pages("?forum_mod-log-fid-$fid.htm",$count,$page,$limit);
		
		//是否本吧成员
		$forum_follow=0;
		$this->_user['uid'] && $forum_follow=$this->forum_users->check_status($fid,$this->_user['uid']);
		//forum category
		$cate=array();
		empty($_SERVER['miscarr']) && $_SERVER['miscarr'] = $this->mcache->read('miscarr');
		$miscarr = $_SERVER['miscarr'];
		$cate['pname']=isset($miscarr['category'][$forum['cat_tid']]) ? $miscarr['category'][$forum['cat_tid']] : '';
		$cate['name']=isset($miscarr['category'][$forum['cat_id']]) ? $miscarr['category'][$forum['cat_id']] : '';
		
		$this->forum->format($forum);
		
		$this->view->assign('ismod', $ismod);
		$this->view->assign('forum_follow', $forum_follow);
		$this->view->assign('forum',$forum);
		$this->view->assign('rank',$rank);
		$this->view->assign('list',$loglist);
		$this->view->assign('fid',$fid);
		$this->view->assign('c',$cate);
		$this->view->assign('pages',$pages);
		$this->view->display('forum_mod_log.html');
		
		
	}
	public function on_upload_icon(){
		
		$fid = intval(core::gpc('fid'));
        $forum = $this->forum->read($fid);
		$this->check_forum_exists($forum);
		
		$ismod = $this->is_mod($forum, $this->_user);
		if(!$ismod) $this->message('您无权查看该页面',0);
		
		if(!$this->attachment->is_safe_image($_FILES['Filedata']['tmp_name'])) {
			$this->message('系统检测到你上传的图片不是安全的，请更换其他图片试试！', 0);
		}
		
		$tmpfile = $this->conf['upload_path']."forum/{$fid}_tmp.jpg";

		$smallfile = $this->conf['upload_path']."forum/{$fid}_small.gif";
		$middlefile = $this->conf['upload_path']."forum/{$fid}_middle.gif";
		$bigfile = $this->conf['upload_path']."forum/{$fid}_big.gif";
		$bigurl = $this->conf['upload_url']."forum/{$fid}_big.gif";
	
		$arr = image::thumb($_FILES['Filedata']['tmp_name'], $tmpfile, 800, 800);
		
		image::thumb($tmpfile, $smallfile, $this->conf['forumicon_width_small'], $this->conf['forumicon_width_small']);
		image::thumb($tmpfile, $middlefile, $this->conf['forumicon_width_middle'], $this->conf['forumicon_width_middle']);
		image::thumb($tmpfile, $bigfile, $this->conf['forumicon_width_big'], $this->conf['forumicon_width_big']);	
		
		
		unlink($tmpfile);
		
		if(is_file($bigfile)) {
			$forum['icon'] = $_SERVER['time'];
			$this->forum->update($forum);

			$this->mcache->clear('forum', $fid);
			$this->mcache->clear('forum_fn', $forum['name']);
			
			$this->modlog->create(array(
				'uid'=>$this->_user['uid'],
				'username'=>$this->_user['username'],
				'fid'=>$fid,
				'dateline'=>$_SERVER['time'],
				'subject'=>'',
				'credits'=>0,
				'golds'=>0,
				'action'=>'forum_icon',
				'comment'=>'',
		    ));
		
			$this->message($bigurl.'?'.$_SERVER['time'],1);
		} else {
			$this->message('保存失败', 0);
		}
	}
	public function on_upload_bg(){
		
		$fid = intval(core::gpc('fid'));
        $forum = $this->forum->read($fid);
		$this->check_forum_exists($forum);
		
		$ismod = $this->is_mod($forum, $this->_user);
		if(!$ismod) $this->message('您无权查看该页面',0);
		
		if(!$this->attachment->is_safe_image($_FILES['Filedata']['tmp_name'])) {
			$this->message('系统检测到你上传的图片不是安全的，请更换其他图片试试！', 0);
		}
		
		$bgfile = $this->conf['upload_path']."forum/{$fid}_bg.jpg";
	    $bgurl=$this->conf['upload_url']."forum/{$fid}_bg.jpg";
		$arr = image::thumb($_FILES['Filedata']['tmp_name'], $bgfile, 1900, 30000);

		if(is_file($bgfile)) {
			/*$forum['forum_bg'] = $bgurl;
			$this->forum->update($forum);

			$this->mcache->clear('forum', $fid);
			$this->mcache->clear('forum_fn', $forum['name']);*/
			$this->modlog->create(array(
				'uid'=>$this->_user['uid'],
				'username'=>$this->_user['username'],
				'fid'=>$fid,
				'dateline'=>$_SERVER['time'],
				'subject'=>'',
				'credits'=>0,
				'golds'=>0,
				'action'=>'forum_bg',
				'comment'=>'',
		    ));
			
			$this->message($bgurl.'?'.$_SERVER['time'],1);
		} else {
			$this->message('保存失败', 0);
		}
	}
	
}

?>