<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'core/control/common_control.class.php';

class message_control extends common_control {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->check_login();
		
		// 初始化用户信息
		$uid = $this->_user['uid'];
		$user = $this->member->get($uid);
		$this->check_user_exists($user);
		$this->member->format($user);
		
		empty($_SERVER['miscarr']) && $_SERVER['miscarr'] = $this->mcache->read('miscarr');
		$user['groupname'] = $_SERVER['miscarr']['group'][$user['groupid']];
		$this->_user = $user;
	}
	
	public function on_inbox(){
		$this->_title[]='收件箱';
		$_user = $this->_user;
		$uid = $_user['uid'];
		
		$page = misc::page();
		$pagesize = 40;
		
		$map=array('send_to_id'=>$_user['username'],'del_type'=>0);
		$list = $this->message->get_message_list($map, ($page-1)*$pagesize, $pagesize);
		
		$pages = misc::simple_page("?message-inbox.html", count($list), $page, $pagesize);
		foreach($list as $k=>&$v){
			$this->message->format($v);
			$list[$k]['reply_num']=$this->message->up_count('replyid='.$v['messageid']);
		}
		$this->view->assign('pages', $pages);
		$this->view->assign('list', $list);
		
		// hook my_post_after.php
		$this->view->display('message_inbox.html');
		
	}
	public function on_outbox(){
		$this->_title[]='发件箱';
		$_user = $this->_user;
		$uid = $_user['uid'];
		
		$page = misc::page();
		$pagesize = 40;
		
		$map=array('send_from_id'=>$_user['username'],'del_type'=>0);
		$list = $this->message->get_message_list($map, ($page-1)*$pagesize, $pagesize);
		
		$pages = misc::simple_page("?message-outbox.html", count($list), $page, $pagesize);
		foreach($list as $k=>&$v){
			$this->message->format($v);
			$list[$k]['reply_num']=$this->message->up_count('replyid='.$v['messageid']);
		}
		$this->view->assign('pages', $pages);
		$this->view->assign('list', $list);
		
		// hook my_post_after.php
		$this->view->display('message_inbox.html');
		
	}
	public function on_send(){
		$this->_title[]='发送消息';
		$_user = $this->_user;
		$uid = $_user['uid'];
		
		$to_user=urldecode(core::gpc('username','G'));
		
		if($this->form_submit()){
			if(!isset($_SESSION)){
				session_start();
			}
			$verifyNum = strtolower(trim($_POST['code']));
	        if($_SESSION['verify']!=$verifyNum) $this->message('验证码错误');
			
			$info=core::gpc('info','P');
			
			$username = $_user['username'];
			$this->member->check_username($info['send_to_id']);
			$tousername = $info['send_to_id'];
			$subject = $info['subject'];
			$content = $info['content'];
			
			if($tousername==$_user['username']) $this->message('不能给自己发信息！');
			
			$subject = htmlspecialchars($subject);
		    $subject = misc::html_space($subject);
		    $subject = utf8::safe_substr($subject, 0, 100);	
			
			$content = htmlspecialchars($content);
		    $content = misc::html_space($content);
		    $content = utf8::safe_substr($content, 0, 254);		// 安全截取
			
			$this->message->add_message($tousername,$username,$subject,$content,true);
			$this->message('消息发送成功！',1,'?message-send.html');
		}
		$this->view->assign('to_user',$to_user);
		$this->view->display('message_send.html');
	}
	/**
	 * 查看短消息 - 对当前用户是否有权限查看
	 */
	public function check_user($messageid,$where){
		$_user = $this->_user;
		$uid = $_user['uid'];
		$username = $_user['username'];
		$messageid = intval($messageid);
		if($where=="to"){
			$result = $this->message->index_fetch(array("send_to_id"=>$username,"messageid"=>$messageid));
		}else{
			$result = $this->message->index_fetch(array("send_from_id"=>$username,"messageid"=>$messageid));
		}
 		if(!$result){//不是当前用户的消息，不能查看
			$this->message('请勿非法访问！');
 		} 
	}
	public function on_read_only() { 
	    $this->_title[]='查看消息';
	    $_user = $this->_user;
		$uid = $_user['uid'];
		$messageid=core::gpc('messageid','G');
		$messageid = intval($messageid);
		//判断是否属于当前用户
		$check_user = $this->check_user($messageid,'from'); 
		
		$page = misc::page();
		$pagesize = 40;
		$map=array('send_from_id'=>$_user['username'],'del_type'=>0);
		//查询消息详情
		$infos = $this->message->read($messageid);
		
		$from_uid=$this->member->get_uid_by_username($infos['send_from_id']);
		//$from_avatar=$this->getavatar($from_uid,1);
		
		$to_uid=$_user['uid'];
		//$to_avatar=$this->getavatar($to_uid,1);
		//if($infos['send_from_id']!='SYSTEM') $infos = new_html_special_chars($infos);
		//查询回复消息
	    $where = array('replyid'=>$infos['messageid']);
        $reply_infos = $this->message->get_message_list($where, ($page-1)*$pagesize, $pagesize);

		$pages = misc::simple_page('?message-read_only-messageid-'.$messageid.'.html', count($reply_infos), $page, $pagesize);
		//$show_validator = $show_scroll = $show_header = true;
		$this->view->assign('pages', $pages);
		$this->view->assign('from_uid',$from_uid);
		$this->view->assign('to_uid',$to_uid);
		$this->view->assign('infos',$infos);
		$this->view->assign('reply_infos', $reply_infos);
		$this->view->display('message_read.html');
	}
	public function on_read() { 
	    $this->_title[]='查看消息';
	    $_user = $this->_user;
		$uid = $_user['uid'];
		$messageid=core::gpc('messageid','G');
		$messageid = intval($messageid);
		//判断是否属于当前用户
		$check_user = $this->check_user($messageid,'to'); 
		
		$page = misc::page();
		$pagesize = 40;
		$map=array('send_to_id'=>$_user['username'],'del_type'=>0);
		//查询消息详情
		$infos = $this->message->read($messageid);
		$ninfos=array_merge($infos,array('status'=>'0'));
		$this->message->set($messageid,$ninfos);
		$this->message->member_newpms($_user['username'],-1);
		
		$from_uid=$this->member->get_uid_by_username($infos['send_from_id']);
		//$from_avatar=$this->getavatar($from_uid,1);
		
		$to_uid=$_user['uid'];
		//$to_avatar=$this->getavatar($to_uid,1);
		//if($infos['send_from_id']!='SYSTEM') $infos = new_html_special_chars($infos);
		//查询回复消息
	    $where = array('replyid'=>$infos['messageid']);
        $reply_infos = $this->message->get_message_list($where, ($page-1)*$pagesize, $pagesize);

		$pages = misc::simple_page('?message-read-messageid-'.$messageid.'.html', count($reply_infos), $page, $pagesize);
		//$show_validator = $show_scroll = $show_header = true;
		$this->view->assign('pages', $pages);
		$this->view->assign('from_uid',$from_uid);
		$this->view->assign('to_uid',$to_uid);
		$this->view->assign('infos',$infos);
		$this->view->assign('reply_infos', $reply_infos);
		$this->view->display('message_read.html');
	}
	/**
	 * 回复短消息 
	 */
	public function on_reply() {
		$_user = $this->_user;
		$uid = $_user['uid'];

		if($this->form_submit()) {
			if(!isset($_SESSION)){
				session_start();
			}
			$verifyNum = strtolower(trim($_POST['code']));
	        if($_SESSION['verify']!=$verifyNum) $this->message('验证码错误');
			
			$info=core::gpc('info','P');
			$messageid = intval($info['replyid']);
			//判断当前会员，是否可发，短消息．
			//$this->message_db->messagecheck($this->_userid);
			//检查此消息是否有权限回复 
			$this->check_user($messageid,'to');
			$username = $_user['username'];
			$this->member->check_username($info['send_to_id']);
			$tousername = $info['send_to_id'];
			$subject = $info['subject'];
			$content = $info['content'];
			
			$subject = htmlspecialchars($subject);
		    $subject = misc::html_space($subject);
		    $subject = utf8::safe_substr($subject, 0, 100);	
			
			$content = htmlspecialchars($content);
		    $content = misc::html_space($content);
		    $content = utf8::safe_substr($content, 0, 254);		// 安全截取
			
			$this->message->add_message($tousername,$username,$subject,$content,true);

			$this->message('回复信息成功！');
			
		} else {
			//include template('message_send');
		}

	}
	
	/**
	 * 删除收件箱-短消息 
	 * @param	intval	$sid	短消息ID，递归删除(修改状态为outbox)
	 */
	public function on_delete() {
		$_user = $this->_user;
		$uid = $_user['uid'];
		$username = $_user['username'];
		if((!isset($_POST['messageid']) || empty($_POST['messageid']))) {
			$this->message('请选择要删除的信息！');
		} else {
				if(is_array($_POST['messageid'])){
					foreach($_POST['messageid'] as $messageid_arr) {
						$messageid_arr = intval($messageid_arr);
						$this->check_user($messageid_arr,'to');
						//查询消息详情
		              $infos = $this->message->read($messageid_arr);
		              $ninfos=array_merge($infos,array('del_type'=>'1'));
		              $this->message->set($messageid_arr,$ninfos);
					  if($infos['status']==1){
						  $this->message->member_newpms($username,-1);
					  }
					 
					}
					$this->message('信息删除成功！',2,'?message-inbox.html');
				} 
		}
	}
	
		/**
	 * 删除发件箱 - 短消息 
	 * @param	intval	$sid	短消息ID，递归删除( 修改状态为del_type =1 )
	 */
	public function del_type() {
		$userInfo=$this->userinfo;
		$username = $userInfo['name'];
		if((!isset($_POST['messageid']) || empty($_POST['messageid']))) {
			error('请选择要删除的信息！');
		} else {
				if(is_array($_POST['messageid'])){
					foreach($_POST['messageid'] as $messageid_arr) {
						$messageid_arr = intval($messageid_arr);
 						$this->model->table('message')->where(array('messageid'=>$messageid_arr,'send_from_id'=>$username))->data(array('del_type'=>'1'))->update();
					}
					$this->success('信息删除成功！');
				} 
		}
	}
	
	// 获取新短消息，如果有，则返回
	public function on_new() {
		
		$this->check_login();
		
		$uid = $this->_user['uid'];
		$user = $this->member->read($uid);
		
		// 可能用户被删除，退出登录，用户组变更？
		if(empty($user)) {
			misc::set_cookie($this->conf['cookie_pre'].'auth', '', 0, '/');
			$this->message('用户不存在，或者已经被删除。', 0);
			exit;
		}
		
		// 更新在线表，标示是否在线, $this->conf['online_hold_time']
		// 五分钟更新一次
		if($_SERVER['time'] - $user['lastdate'] > 300) {
			$user['lastdate'] = $_SERVER['time'];
			$this->member->update($uid, $user);
			
			// 更新在线，如果不存在，则不更新(common_control.class.php 每隔5分钟会自动创建一次 online)
			$this->update_online();
		}
		
		// 如果用户组发生改变，此处更新。
		$this->member->update_group($user, $this->_user['groupid']);
		// 获取最新消息
		if($user['newpms'] > 0) {
			// hook pm_new_before.php
			$this->message($user['newpms'], 1);
		} else {
			// hook pm_new_no_before.php
			$this->message('没有短消息', 2);
		}
		
	}
}
?>