<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'core/control/common_control.class.php';

class search_control extends common_control {
	

    function __construct(&$conf) {
		parent::__construct($conf);
		$this->_checked = array('bbs'=>' class="checked"');
	}
	
	// 首页
	public function on_index() {
		
		// hook search_index_before.php
		$keyword = urldecode(core::gpc('q', 'R'));
		$this->_title[]=$keyword.'_搜索结果';
		$this->_seo_keywords = $keyword.',贴吧,'.$this->conf['seo_keywords'];
		$this->_seo_description = $keyword.',贴吧,'.$this->conf['seo_description'];
		
		$t=core::gpc('t','R');
		$keyword=misc::safe_str($keyword);
        $keyword=utf8::safe_substr($keyword, 0, 20);
        
		$keyword_url = urlencode($keyword);
		$page = misc::page();
        
		if($page==1&&!empty($keyword)){
		  //加入标签
            $this->tags->_create($keyword);
		    $forum=array();//$this->forum->index_fetch(array('name'=>$keyword),array(),0,1);
            //if($forum) $forum=array_pop($forum);
			$forumlist=$this->get_forum_list($keyword);
			foreach($forumlist as $f){
				if(strip_tags($f['name'])==$keyword){
					$forum=$f;
					break;
				}
				
			}
		    $this->view->assign('forumlist', $forumlist);
			$this->view->assign('st', $t);
            $this->view->assign('match_forum',$forum);
		    // hook search_index_after.php
		    //$this->view->display('search_forum.html');
			//exit;
		}
		
		
		preg_match('#(?:http|https)://(.*?)/.*?#', $this->conf['app_url'], $m);
		$site = empty($m[1]) ? '' : $m[1];
		
		//$searchtype = $this->conf['search_type'];
		//if(empty($searchtype)) {
			//$this->message('搜索功能未开启!');
		//}
		$pagesize = 20; // 搜索结果大小
		$nextpage = 0;
		
		if(!empty($keyword)) {
		//	if($t=='author'){
			 //  $topiclist = $this->get_list_by_author($keyword, $page, $pagesize);
		    //}else{
		       $topiclist = $this->get_list_by_title($keyword, $page, $pagesize);
		//	}
			// 点击数
			$readtids = implode(',', misc::arrlist_values($topiclist, 'tid'));
			$click_server = $this->conf['click_server']."?r=$readtids";
			$this->view->assign('readtids', $readtids);
			$this->view->assign('click_server', $click_server);
		} else {
			$click_server = '';
			$this->view->assign('click_server', $click_server);
			$topiclist = array();
		}
		
		$pages = misc::simple_pages("?search-index-q-$keyword_url-t-$t.htm", count($topiclist), $page, $pagesize);
		
		$fid=0;
		$this->view->assign('fid',$fid);
		$this->view->assign('st', $t);
        $this->view->assign('page', $page);
		$this->view->assign('pages', $pages);
		$this->view->assign('keyword', $keyword);
		$this->view->assign('keyword_url', $keyword_url);
		$this->view->assign('threadlist', $topiclist);
		// hook search_index_after.php
		$this->view->display('search_index.html');
	}
	private function get_list_by_title($keyword, $page, $pagesize) {

		$threadlist = $this->topic->index_fetch(array('subject'=>array('LIKE'=>$keyword)), array(), ($page - 1) * $pagesize, $pagesize);
		foreach($threadlist as &$thread) {
			$this->topic->format($thread);
			$thread['subject'] = str_replace($keyword, '<span class="clr-red">'.$keyword.'</span>', $thread['subject']);
		}
		return $threadlist;
	}
	private function get_list_by_author($keyword, $page, $pagesize) {
        $uid=$this->member->get_uid_by_username($keyword);
		if(empty($uid)) return array();
		$threadlist = $this->topic->index_fetch(array('authorid'=>$uid), array(), ($page - 1) * $pagesize, $pagesize);
		foreach($threadlist as &$thread) {
			$this->topic->format($thread);
			$thread['subject'] = str_replace($keyword, '<span class="clr-red">'.$keyword.'</span>', $thread['subject']);
		}
		return $threadlist;
	}
	
	private function get_forum_list($keyword) {
		
        /**
 * $forum=$this->forum->index_fetch(array('name'=>$keyword),array(),0,1);
 * 		
 * 		if(!empty($forum)){
 * 			foreach($forum as $v){
 * 				$fid=$v['fid'];
 * 				break;
 * 			}
 * 			$this->location("?forum-index-fid-$fid.htm");
 * 			//header("location:".$this->conf['app_url']."?forum-index-fid-$fid.html");
 * 			exit;
 * 		}
 */
		$forumlist=$this->forum->index_fetch(array('name'=>array('LIKE'=>$keyword)),array(),0,100);
		foreach($forumlist as &$forum){
			$this->forum->format($forum);
			$forum['name'] = str_replace($keyword, '<span class="clr-red">'.$keyword.'</span>', $forum['name']);
		}
		return $forumlist;
	}
	
	public function on_create_forum(){
		
		$userinfo=$this->_user;
		$uid=$userinfo['uid'];
		if(!$userinfo['uid']) $this->message('请先登录',0);
		
		if($this->form_submit()){
			$fname=core::gpc('fname','P');
			$message=core::gpc('message','P');
			
			$fname = htmlspecialchars($fname);
		    $fname = misc::safe_str($fname);
		    $fname = utf8::safe_substr($fname, 0, 20);	
			
			      if(empty($_SESSION)){
				       session_start();	
				   }
				   $verifynum=strtolower(trim(core::gpc('verifyNum','P')));
				   if(empty($verifynum)||($verifynum!=$_SESSION['verify'])) $this->message('验证码错误！',0);
				   

			$condition=array('name'=>$fname);
			$rs=$this->forum->index_fetch($condition,array(),0,1);
			$rs2=$this->forum_temp->index_fetch($condition,array(),0,1);
			if($rs||$rs2) $this->message('该吧已经存在，或者审核中',0);
			$data=array();
			$data['name']=$fname;
			$data['synopsis']=misc::html_space($message);
			$data['ipaddress']=ip2long($_SERVER['ip']);
			$data['dateline']=$_SERVER['time'];
			$data['founder']=$userinfo['username'];
			$this->forum_temp->create($data);
			$this->message('申请成功，等待审核');
		}else{
		    $keyword = urldecode(core::gpc('q', 'R'));
		    misc::safe_str($keyword);
		    $keyword_url = urlencode($keyword);
            $this->view->assign('keyword',$keyword);
			$this->view->display('search_create_forum_ajax.html');
		}
		
	}
	
}

?>