<?php

/*
 * Copyright (C) xiuno.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'core/control/common_control.class.php';

class you_control extends common_control {
	
	private $you;
	function __construct(&$conf) {
		parent::__construct($conf);
		
		// 初始化用户信息
		$uid = intval(core::gpc('uid'));
		empty($uid) && $uid = $this->_user['uid'];
		$user = $this->member->read($uid);
		$this->check_user_exists($user);
		$this->member->format($user);
		$this->member->format_follow($user, $this->_user['uid'], $uid);
		$user['groupname'] = $this->conf['grouparr'][$user['groupid']];
		
		$this->you = $user;
		$this->view->assign('you', $this->you);
        
        
	}
	
	// 我看别人的空间首页，个人资料
	public function on_index() {
       
		$this->_checked['you_index'] = ' current"';
		$user = $this->you;
        $uid=$user['uid'];
		$this->last_visit($user['uid']);
        
		$this->_title[] = $user['username'].'的个人主页';
		$this->_nav[] = '个人主页';
        
		$mypostlist = $this->mypost->get_list_by_uid($user['uid'], 1, 20);

		foreach($mypostlist as &$post) {
			$this->mypost->format($post);
		}
        $mypostlist=array_filter($mypostlist);
        
        // 粉丝
		$followedlist = $this->follow->get_followedlist_by_uid($uid, 1, 12);

		$this->view->assign('followedlist', $followedlist);
        //最新访客
        $visitorlist=$this->member_visitor->get_last_visitor($user['uid'],12);
        
        $this->view->assign('visitorlist',$visitorlist);
		$this->view->assign('mypostlist', $mypostlist);
        $this->view->assign('hotuser', $hotuser);
		// hook you_index_after.php
		$this->view->display('you_index.html');
	}
	
	// ajax
	public function on_profile() {

		// hook you_profile_after.php
		
		$this->view->display('you_profile_ajax.html');
	}
	
	// 别人的发帖
	public function on_post() {
		$this->_checked['you_post'] = 'current';
		
		$user = $this->you;
		$uid = $user['uid'];

		$this->_title[] = '参与主题';
		$this->_nav[] = '参与主题';
		
		// hook you_post_before.php
		$page = misc::page();
		$pagesize = 40;
		$mypostlist = $this->mypost->get_list_by_uid($uid, $page, $pagesize);
		$pages = misc::simple_pages("?you-post-uid-$uid.htm", count($mypostlist), $page, $pagesize);

		foreach($mypostlist as &$post) {
			//$post['forumname'] = isset($this->conf['forumarr'][$post['fid']]) ? $this->conf['forumarr'][$post['fid']] : '';
			$this->mypost->format($post);
		}
        $mypostlist=array_filter($mypostlist);
		$this->view->assign('pages', $pages);
		$this->view->assign('mypostlist', $mypostlist);
		
		// hook you_post_after.php
		$this->view->display('you_post.html');
	}
	
	// 别人的关注，一次全部取出。最多100个。
	public function on_follow() {
		$this->_checked['you_follow'] = 'current';
		
		$user = $this->you;
		$uid = $user['uid'];
		
		$this->_title[] = '他的关注';
		$this->_nav[] = '他的关注';
		
		// hook you_follow_before.php
		$page = misc::page();
		$pagesize = 64;
		$followlist = $this->follow->get_list_by_uid($uid, $page, $pagesize);
		$pages = misc::simple_pages("?you-follow-uid-$uid.htm", count($followlist), $page, $pagesize);
		$this->view->assign('pages', $pages);
		$this->view->assign('userlist', $followlist);
		
		// hook you_follow_after.php
		$this->view->display('you_follow.html');
		
	}
	
	// 别人的粉丝 100个
	public function on_followed() {
		$this->_checked['you_followed'] = 'current';
		
		$user = $this->you;
		$uid = $user['uid'];
		
		$this->_title[] = '他的粉丝';
		$this->_nav[] = '他的粉丝';
		
		// hook you_followed_before.php
		
		$page = misc::page();
		$pagesize = 64;
		$followedlist = $this->follow->get_followedlist_by_uid($uid, $page, $pagesize);
		$pages = misc::simple_pages("?you-follow-uid-$uid.htm", count($followedlist), $page, $pagesize);
		$this->view->assign('pages', $pages);
		$this->view->assign('userlist', $followedlist);
		
		// hook you_followed_after.php
		$this->view->display('you_followed.html');
	}
	//记录访客
    private function last_visit($uid,$_uid=0){
        !$_uid && $_uid=$this->_user['uid'];
        if($_uid){
            $rs=$this->member_visitor->read($uid,$_uid);
            if($rs){
                if($_SERVER['time']-$rs['dateline']>3600){
                    $rs['dateline']=$_SERVER['time'];
                    $rs['num']++;
                    $this->member_visitor->update($rs);
                }
            }else{
                $arr=array('uid'=>$uid,'vuid'=>$_uid,'dateline'=>$_SERVER['time'],'num'=>1);
                $this->member_visitor->create($arr);
            }
            
        }
    }
	//hook you_control_after.php
}

?>