<?php

/*
 * Copyright (C) xiuno.com
 */

class forum_users extends base_model {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->table = 'forum_users';
		$this->primarykey = array('fid','uid');
		// hook forum_users_construct_end.php
	}
	public function check_status($fid,$uid){
		$rs=$this->read($fid,$uid);
		if(!$rs){
		   return 0;
		}
		//$r=!$rs['status']?'待审核':($rs['status']==1?'已加入':'已拒绝');
		return  $rs;
	}
	public function get_list($cond,$order,$start,$limit){
	    $list=$this->index_fetch($cond,$order,$start,$limit);
		$uids=$infos=array();
		foreach($list as $v){
			$uids[]=$v['uid'];
			$v['dateline_fmt']=date('Y-m-d H:i',$v['dateline']);
			$v['lastpost_fmt']=$v['lastpost']>0?misc::minidate($v['lastpost']):'无';
			$v['lastsign_fmt']=$v['lastsign']>0?misc::minidate($v['lastsign']):'无';
			$v['posts_all']=$v['posts']+$v['topics'];
			$v['status_fmt']=$v['status']==1?'<font color="green">已审核</font>':($v['status']==2?'<font color="red">已拒绝</font>':'待审核');
			$infos[$v['uid']]=$v;
		}
		$uids=array_unique($uids);
		$userlist=$this->member->mget($uids);
		$rlist=array();
		foreach($userlist as $u){
			if(empty($u)){
			  // $this->delete();	
			}else{
			   $this->member->format($u);
			   $u=array_merge($u,$infos[$u['uid']]);
			   $rlist[$u['uid']]=$u;	
			}
		}
		return $rlist;
	}
	
}

?>