<?php

/*
 * Copyright (C) xgcms.com
 */

class modlog extends base_model {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->table = 'modlog';
		$this->primarykey = array('logid');
		$this->maxcol = 'logid';
	}
	
	public function _delete($logid) {
		$return = $this->delete($logid);
		if($return) {
			$this->count('-1');
		}
		return $return;
	}
	
	public function delete_by_fid($fid) {
		// 最多支持 100000
		$keys = $this->index_fetch_id(array('fid'=>$fid), array(), 0, 100000);
		foreach($keys as $key) {
			$this->delete($key);
		}
		return count($keys);
	}
	
	public function delete_by_fid_tid($fid, $tid) {
		$modloglist = $this->get_list_by_fid_tid($fid, $tid);
		foreach($modloglist as &$modlog) {
			$this->_delete($modlog['logid']);
		}
	}
	public function get_list_by_fid($fid, $page, $pagesize) {
		$start = ($page - 1) * $pagesize;
		$modloglist = $this->index_fetch(array('fid'=>$fid), array('logid'=>0), $start, $pagesize);
		foreach($modloglist as &$modlog) {
			$this->format($modlog);
			$modlog['thread'] = $this->topic->read($modlog['fid'], $modlog['tid']);
			$modlog['msg']=$modlog['action_fmt'].' '.$modlog['subject'].' '.$modlog['comment'];
		}
		return $modloglist;
	}
	// 某个版主的管理操作。
	public function get_list_by_uid($uid, $page, $pagesize) {
		$start = ($page - 1) * $pagesize;
		$modloglist = $this->index_fetch(array('uid'=>$uid), array('logid'=>0), $start, $pagesize);
		foreach($modloglist as &$modlog) {
			$this->format($modlog);
			$modlog['thread'] = $this->topic->read($modlog['fid'], $modlog['tid']);
		}
		return $modloglist;
	}
	
	// 返回某个主题下的操作日志。
	public function get_list_by_fid_tid($fid, $tid) {
		$modloglist = $this->index_fetch(array('fid'=>$fid, 'tid'=>$tid), array(), 0, 256);
		misc::arrlist_multisort($modloglist, 'logid', TRUE);
		return $modloglist;
	}
	
	// 用来显示给用户
	public function format(&$modlog) {
		
		empty($_SERVER['miscarr']) && $_SERVER['miscarr'] = $this->mcache->read('miscarr');
		
		$arr = array('digest'=>'加精华', 'undigest'=>'取消精华', 'top'=>'置顶', 'untop'=>'取消置顶', 'delete'=>'删除', 'move'=>'移动', 'type'=>'主题分类','forum_edit'=>'修改板块设置','audit_user'=>'审核成员','del_user'=>'删除成员','forum_icon'=>'上传板块图标','forum_bg'=>'上传板块背景');
		$modlog['action_fmt'] = $arr[$modlog['action']];
		$modlog['credits_fmt'] = $modlog['credits'] ? '+'.$modlog['credits'] : '---';
		$modlog['golds_fmt'] = $modlog['golds'] ? '+'.$modlog['golds'] : '---';
		$modlog['dateline_fmt'] = misc::humandate($modlog['dateline']);
		//$modlog['forumname'] = $_SERVER['miscarr']['forum'][$modlog['fid']];
	}
}
?>