// 原图/缩略图 的比例 >=1
var UserHeadUtil = {
	ratio: 1,
	view_H:250,
	view_W:300,
	initialize:function(path){ 
		 init=false;
		$("#user_head_origin").attr("src", path);
		$("#head_img_100").attr("src", path);
		$("#head_img_50").attr("src", path);
		var img = new Image();
		img.src = path;
		if(img.width==0){
			var obj = this;
			img.onload = function(){ 
				obj.imgOperate(img, init);
			};
		}else{
			this.imgOperate(img, init);
		}
	},
	imgOperate:function(img, init){
		if(img){
			this.resize('user_head_origin', img.width, img.height, 300, 300);
			if(init){
				this.resize('head_img_100', img.width, img.height, 100, 100);
				this.resize('head_img_50', img.width, img.height, 50, 50);
			}else{
				var x=0,y=0,size=0;
				if(this.view_W > this.view_H ){
					x = (this.view_W - this.view_H)/2;
					size = this.view_H;
				}else if(this.view_W < this.view_H){
					y = (this.view_H - this.view_W)/2;
					size = this.view_W;
				}else{
					size = this.view_W;
				}
				var obj = this;
				var imgArea = $('#user_head_origin').imgAreaSelect({
					aspectRatio:"1:1",
					handles: "corners",
					persistent:true,
					show:true,
					imageWidth: obj.view_W,
					imageHeight: obj.view_H,
					x1: x,
					y1: y,
					x2: x + size,
					y2: y + size, 
					onSelectChange: function(img, selection){
						obj.preview('head_img_100', obj.view_W, obj.view_H, selection.x1, selection.y1, selection.width, selection.height, 100, 100);
						obj.preview('head_img_50', obj.view_W, obj.view_H, selection.x1, selection.y1, selection.width, selection.height, 50, 50);
						obj.setCutParams(selection.x1, selection.y1, selection.width, selection.height);
					}
				});
				this.preview('head_img_100', this.view_W, this.view_H, x, y, size, size, 100, 100);
				this.preview('head_img_50', this.view_W, this.view_H, x, y, size, size, 50, 50);
				this.setCutParams(x, y, size, size);
			}
		}
	},
	resize:function(id, width, height, limit_W, limit_H){
		if(width>0 && height>0){
			if(width/height >= limit_W/limit_H){
				if(width > limit_W){
					this.view_W = limit_W;
					this.view_H = (limit_W/width)*height;
				}
			}else{
				if(height > limit_H){
					this.view_H = limit_H;
					this.view_W = (limit_H/height)*width;
				}
			}
			
			$('#'+id).attr( {
				"width" : this.view_W,
				"height" : this.view_H
			});
			
			this.ratio = width / this.view_W;
		}
	},
	preview:function(id, width, height, x, y, cut_W, cut_H, show_W, show_H){
		var scaleX = show_W / (cut_W * this.ratio || 1);
		var scaleY = show_H / (cut_H * this.ratio || 1);
		$('#'+id).css({
			width: Math.round(scaleX * width * this.ratio) + 'px',
			height: Math.round(scaleY * height * this.ratio) + 'px',
			marginLeft: '-' + Math.round(scaleX * x * this.ratio) + 'px',
			marginTop: '-' + Math.round(scaleY * y * this.ratio) + 'px'
		}); 
	},
	setCutParams:function(x, y, width, height){
		$('#head_x').val(Math.round(x * this.ratio));
		$('#head_y').val(Math.round(y * this.ratio));
		$('#head_width').val(Math.round(width * this.ratio));
		$('#head_height').val(Math.round(height * this.ratio));
	}
};
	function cancelHead(){
		// window.location.reload();
		$('#user_head_origin').imgAreaSelect({ remove: true });
		$("#user_head_show_box").hide();
		$("#user_head_upload_box").show();
		$("#user_head_origin").attr({
		"src": "view/imgages/upload.png",
		"width" : "100%",
		"height" : "100%"
		});
		//var path = $("img#origin_user_head_75").attr("src");
		 
	 
		$("#head_img_100").attr("src",$("#head_img_100").attr("org")).css({
		width: 100 + 'px',
		height: 100 + 'px',
		marginLeft: 0,
		marginTop: 0
		});
		$("#head_img_50").attr("src", $("#head_img_50").attr("org")).css({
		width: 50 + 'px',
		height: 50 + 'px',
		marginLeft: 0,
		marginTop: 0
		});
		 
}