<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'admin/control/admin_control.class.php';

class forum_control extends admin_control {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->_checked = array('bbs'=>' class="checked"');
		$this->check_admin_group();
	}
	// 列表
	public function on_index() {
		$this->on_list();
	}	
	public function on_search(){
		$this->_title[] = '贴吧列表';
		$this->_nav[] = '<a href="./">贴吧列表</a>';
		$keyword=core::gpc('keyword','P');
		$keyword=misc::safe_str($keyword);
		$forumlist = $this->forum->get_forum_list(array('name'=>array('LIKE'=>$keyword)),0, 10);
		$cid=0;
        $_POST=array();
		$this->view->assign('cid',$cid);
		$this->view->assign('forumlist', $forumlist);
		$this->view->display('forum_list.html');
	}
	public function on_list() {
		$this->_title[] = '贴吧列表';
		$this->_nav[] = '<a href="./">贴吧列表</a>';
		
		$error = array();
		$cid=core::gpc('cid', 'G');
		if($this->form_submit()) {
			
			// 修改
			//$namearr = core::gpc('name', 'P');
			$rankarr = core::gpc('rank', 'P');
			
			// hook admin_forum_list_gpc_after.php
			
			if(!empty($rankarr)) {
				foreach($rankarr as $fid=>$rank) {
					$fid = intval($fid);
					$forum = $this->forum->read($fid);
					$forum['rank'] = intval($rank);
					$this->forum->update($forum);
					// 清除缓存
			        $this->mcache->clear('forum', $fid);
					$this->mcache->clear('cateforum', $forum['cat_tid']);
			
				};
				$this->runtime->xupdate('forumarr');
				//$this->mcache->clear('forumlist');
				//$this->mcache->clear('miscarr');
			}
			
		}
		
		$page = misc::page();
		$pagesize = 15;
		$start=($page-1)*$pagesize;
		if($cid){
		    $forumlist = $this->forum->index_fetch(array('cat_id'=>$cid), array(), $start, $pagesize);	
			$pages = misc::simple_pages("?forum-list-cid-$cid.htm", count($forumlist), $page, $pagesize);
		}else{
		    $forums = $this->forum->count();
		    $forumlist = $this->forum->get_forum_list(array(),$start, $pagesize);
			$pages = misc::pages("?forum-list.htm", $forums, $page, $pagesize);
		}
		foreach($forumlist as &$forum) {
			$this->forum->format($forum);
		}
		
		$this->view->assign('pages', $pages);
		// hook admin_forum_list_view_before.php
		
		$this->view->assign('error', $error);
		$this->view->assign('cid', $cid);
		$this->view->assign('forumlist', $forumlist);
		$this->view->display('forum_list.html');
	}
	public function on_new(){
		$this->_title[] = '添加贴吧';
		$this->_nav[] = '<a href="./">添加贴吧</a>';
		
		$error = array();
		if($this->form_submit()) {
			$namearr = core::gpc('name', 'P');
			$rankarr = core::gpc('rank', 'P');
			$cat_idarr=core::gpc('cat_id', 'P');
			$keywordsarr=core::gpc('keywords', 'P');
			$description=core::gpc('description', 'P');
			if(!empty($namearr)) {
				
				foreach($namearr as $id=>$name) {
					$id = intval($id);
					$name=trim($name);
					//!isset($newfuparr[$cid]) && $newfuparr[$cid] = 0;
					//!isset($newrankarr[$cid]) && $newrankarr[$cid] = 0;
					if(empty($name)||$name=='') continue;
					$forum = array(
						'name'=>$name,
						'rank'=>intval($rankarr[$id]),
						'cat_id'=>intval($cat_idarr[$id]),
						'cat_tid'=>$this->category->get_fup_by_cid(intval($cat_idarr[$id])),
						'description'=>$description[$id],
						'keywords'=>$keywordsarr[$id],
					);
					// hook admin_forum_create_before.htm
					
					$forumid = $this->forum->create($forum);
					$this->mcache->clear('cateforum', $forum['cat_tid']);
				}
			}
			$this->location('?forum-list.htm');
			
		}
		$cateoptions = $this->forum->get_forum_options(0, 1);
		
		$this->view->assign('error', $error);
		$this->view->assign('cateoptions', $cateoptions);
		$this->view->display('forum_new.html');
		
	}
	// 修改
	public function on_update() {
		$this->_title[] = '修改贴吧';
		$this->_nav[] = '修改贴吧';
		$fid = intval(core::gpc('fid'));

		$forum = $this->forum->get($fid);
		$this->check_forum_exists($forum);
		
		$input = $error = array();
		if($this->form_submit()) {
			
			// 准备更新数据
			$post = array();
			
			$post['cat_id'] = intval(core::gpc('cat_id', 'P'));
			$post['cat_tid']=$this->category->get_fup_by_cid($post['cat_id']);
			$post['name'] = core::gpc('name', 'P');
			$post['rank'] = intval(core::gpc('rank', 'P'));
			$post['status'] = intval(core::gpc('status', 'P'));
			$post['recommend'] = intval(core::gpc('recommend', 'P'));
			$post['modnames'] = trim(core::gpc('modnames', 'P'));
			$post['keywords'] = trim(core::gpc('keywords', 'P'));
			$post['description'] = trim(core::gpc('description', 'P'));
			
			// 版主
			$modids = $modnames = '';
			$post['modnames'] = str_replace(array('　', "\t", '  '), ' ', $post['modnames']);
			$modnamearr = explode(' ', $post['modnames']);
			$modnamearr = array_unique($modnamearr);
			$modnamearr = array_slice($modnamearr, 0, 6);	// 最多6个
			foreach($modnamearr as $modname) {
				if(trim($modname)=='') continue;
				$_user = $this->member->get_user_by_username($modname);
				if($_user) {
					$_user && $modids .= ' '.$_user['uid'];
					$modnames .= ' '.$_user['username'];
					// 调整用户组
					$groupid = 4;
					$user = $this->member->read($_user['uid']);
					$user['groupid'] = $groupid > $user['groupid'] ? $user['groupid'] : $groupid;// 提升版主权限
					$this->member->update($user);
				}
			}
			$post['modids'] = trim($modids);
			$post['modnames'] = trim($modnames);
		
			$error['name'] = $this->forum->check_name($post['name']);

			if(!array_filter($error)) {
				$error = array();

				$forum = array_merge($forum, $post);
				
				// hook admin_forum_update_after.php
				$this->forum->update($forum);
			}
			
			// 继承
			$forum = $this->forum->read($fid);
			
			// 清除缓存
			$this->mcache->clear('forum', $fid);
			$this->mcache->clear('forum_fn', $forum['name']);
			$this->mcache->clear('cateforum', $forum['cat_tid']);
			$this->runtime->xupdate('forumarr');
		}
		
		$cateoptions = $this->forum->get_forum_options($forum['cat_id'], 1);
		$this->view->assign('cateoptions', $cateoptions);

		// hook admin_forum_update_listtype_before.php
		
		$input = array();
		$input['status'] = form::get_radio_yes_no('status', $forum['status']);
		$input['recommend'] = form::get_radio_yes_no('recommend', $forum['recommend']);
		
		//$input['indexforums'] = form::get_text('indexforums', $forum['indexforums'], 32);
		$this->forum->format($forum);

		$admin_auth = core::gpc($this->conf['cookie_pre'].'admin_auth', 'C');
		$this->view->assign('input', $input);
		$this->view->assign('admin_auth', $admin_auth);
		$this->view->assign('fid', $forum['fid']);
		$this->view->assign('forum', $forum);
		$this->view->assign('error', $error);
		
		// hook admin_forum_update_before.php
		
		$this->view->display('forum_update.html');
	}
	public function on_uploadicon() {
		
        $fid = intval(core::gpc('fid'));
		$destfile = $this->conf['upload_path']."forum/{$fid}_tmp.jpg";
		$desturl = $this->conf['upload_url']."forum/{$fid}_tmp.jpg?".$_SERVER['time'];
		

		if(!$this->attachment->is_safe_image($_FILES['Filedata']['tmp_name'])) {
			$this->message('系统检测到你上传的图片不是安全的，请更换其他图片试试！', 0);
		}
				
		$arr = image::thumb($_FILES['Filedata']['tmp_name'], $destfile, 800, 800);
		$json = array('width'=>$arr['width'], 'height'=>$arr['height'], 'body'=>$desturl);
		
		// hook user_uploadavatar_after.php
		$this->message($json, 1);
	}
	
	public function on_clipicon() {
		
		
		$fid = intval(core::gpc('fid'));
		$forum = $this->forum->read($fid);
		$this->check_forum_exists($forum);
		
		$x = intval(core::gpc('x', 'P'));
		$y = intval(core::gpc('y', 'P'));
		$w = intval(core::gpc('w', 'P'));
		$h = intval(core::gpc('h', 'P'));
		
		$srcfile = $this->conf['upload_path']."forum/{$fid}_tmp.jpg";
		$tmpfile = $this->conf['upload_path']."forum/{$fid}_tmp_clip.jpg";
		$smallfile = $this->conf['upload_path']."forum/{$fid}_small.gif";
		$middlefile = $this->conf['upload_path']."forum/{$fid}_middle.gif";
		$bigfile = $this->conf['upload_path']."forum/{$fid}_big.gif";
		$bigurl = $this->conf['upload_url']."forum/{$fid}_big.gif";
		
		image::clip($srcfile, $tmpfile, $x, $y, $w, $h);
		
		
		image::thumb($tmpfile, $smallfile, $this->conf['forumicon_width_small'], $this->conf['forumicon_width_small']);
		image::thumb($tmpfile, $middlefile, $this->conf['forumicon_width_middle'], $this->conf['forumicon_width_middle']);
		image::thumb($tmpfile, $bigfile, $this->conf['forumicon_width_big'], $this->conf['forumicon_width_big']);
		unlink($srcfile);
		unlink($tmpfile);
		if(is_file($bigfile)) {
			$forum['icon'] = $_SERVER['time'];
			$this->forum->update($forum);

			$this->mcache->clear('forum', $fid);
			$this->runtime->xupdate('forumarr');
			// hook admin_forum_clipicon_after.php
			
			$this->message($bigurl,1);
		} else {
			$this->message('保存失败', 0);
		}

	}

	
	public function on_delete() {
		$this->_title[] = '删除贴吧';
		$this->_nav[] = '删除贴吧';
		
		$fid = intval(core::gpc('fid'));
		
	    $starttid = intval(core::gpc('starttid'));//tid
		$threads = intval(core::gpc('threads'));//fid
		$limit = 200;

		$forum = $this->forum->get($fid);
		
		if(empty($forum)) {
			$this->message('贴吧已经被删除。', 1, '?forum-list.htm');
		}
		
		if($starttid >= $threads) {
			// fid++ tid=0 跳转
			// hook admin_forum_delete_complete.php
			
			// 统一删除数据量较小的表：
			$this->forum_access->delete_by_fid($fid);

			$this->modlog->delete_by_fid($fid);
			
			$this->forum->delete($fid);
			
			$this->mcache->clear('forum', $fid);
			$this->mcache->clear('forum_fn', $forum['name']);
			$this->mcache->clear('cateforum', $forum['cat_tid']);
			$this->runtime->xupdate('forumarr');
			$this->message('删除完毕', 1, '?forum-list.htm');
		} else {
			// 分批删除主题。
			$tidkeys = $this->topic->index_fetch_id(array('fid'=>$fid), array(), 0, $limit);
			$return = array();
			foreach($tidkeys as $key) {
				list($table, $_, $_, $_, $tid) = explode('-', $key);
				$tid = intval($tid);
				// hook admin_forum_delete_tid_before.php
				$return2 = $this->topic->xdelete($fid, $tid, FALSE);
				$this->topic->xdelete_merge_return($return, $return2);
			}
			$this->topic->xdelete_update($return);
			$starttid += $limit;
			$this->message("删除 fid: $fid, tid: $starttid ...", 1, "?forum-delete-fid-$fid-threads-$threads-starttid-$starttid.htm");
		}
		// 清除缓存
			
		// hook admin_forum_delete_after.php
		
		// 删除首页的缓存
		
		
	}
	public function on_apply(){
		$this->_title[] = '审核吧主';
		$this->_nav[] = '审核吧主';
		$aid=core::gpc('aid','G');
		$fid=core::gpc('fid','G');
		$do=core::gpc('do','G');
		if($this->form_submit()){
			$aid=(array)core::gpc('aid','P');
			foreach($aid as $a){
				$this->apply->delete($a);
			}
			$this->message('删除成功！',1,'?forum-apply.html');
		}
		if(!empty($aid)) {
			$apply=$this->apply->get($aid);
			empty($apply) && $this->message('该申请不存在！');
			if($do=='1'){
				// 发送系统消息：
					$pmsubject = '管理员已经拒绝你的吧主申请';
					$pmmessage = "非常抱歉，由于你不符合吧主条件，管理员已经拒绝你对【".$apply['fname']."】吧的吧主申请<a href=\"?forum-index-fid-$fid.html\" target=\"_blank\">【".$apply['fname']."】</a>";
					$this->message->add_message($apply['uname'],'SYSTEM',$pmsubject,$pmmessage);
					$this->apply->delete($aid);
			        $this->message('拒绝申请成功！！',1,'?forum-apply.htm');
			}
			$forum = $this->forum->get($fid);
		    $this->check_forum_exists($forum);
			// 版主
			$modids = $modnames = '';
			$post=array();
			$post['modnames'] = $forum['modnames'].' '.$apply['uname'];
			$modnamearr = explode(' ', $post['modnames']);
			$modnamearr = array_unique($modnamearr);
			$modnamearr = array_slice($modnamearr, 0, 6);	// 最多6个
			foreach($modnamearr as $modname) {
				if(trim($modname)=='') continue;
				$_user = $this->member->get_user_by_username($modname);
				if($_user) {
					$_user && $modids .= ' '.$_user['uid'];
					$modnames .= ' '.$_user['username'];
					// 调整用户组
					$groupid = 4;
					$user = $this->member->read($_user['uid']);
					$user['groupid'] = $groupid > $user['groupid'] ? $user['groupid'] : $groupid;// 提升版主权限
					$this->member->update($user);
				}
			}
			$post['modids'] = trim($modids);
			$post['modnames'] = trim($modnames);

			$forum = array_merge($forum, $post);
				// hook admin_forum_update_after.php
			$this->forum->update($forum);
			
			// 发送系统消息：
					$pmsubject = '管理员已经审核通过你的吧主申请';
					$pmmessage = "恭喜您，管理员已经审核通过你对【".$apply['fname']."】吧的吧主申请<a href=\"?forum-index-fid-$fid.html\" target=\"_blank\">【".$apply['fname']."】</a>";
					$this->message->add_message($apply['uname'],'SYSTEM',$pmsubject,$pmmessage);
            $this->apply->delete($aid);
			// 清除缓存
			$this->mcache->clear('forum', $fid);
			$this->mcache->clear('forum_fn', $forum['name']);
			$this->runtime->xupdate('forumarr');
			$this->message('审核成功！',1,'?forum-apply.htm');
			
		}
		$list=$this->apply->get_apply_list();
		$this->view->assign('list',$list);
		$this->view->display('forum_apply.html');
	}
	public function on_audit(){
		$this->_title[] = '审核贴吧';
		$this->_nav[] = '审核贴吧';
		$fid = intval(core::gpc('fid','G'));
		$error=array();
		if($fid){
			$forum=$this->forum_temp->read($fid);
			if(!empty($forum)){
				$f=array(
						'name'=>$forum['name'],
						'rank'=>'1',
						'cat_id'=>'0',
						'description'=>'',
						'keywords'=>'',
					);
				$forum = $this->forum->create($f);
				$this->forum_temp->_delete($fid);
				$this->message('审核通过！',1,'?forum-audit.htm');
			}
		}
		if($this->form_submit()) {
			$fid = core::gpc('fid','P');
			if(!empty($fid)&&is_array($fid))foreach($fid as $k=>$v){
				$v=intval($v);
				$this->forum_temp->_delete($v);
			}
			
		}
		$list=$this->forum_temp->get_forum_list();
		$this->view->assign('list',$list);
		$this->view->display('forum_audit.html');
	}
	public function on_up_count(){
		$this->_title[] = '更新统计数据';
		$this->_nav[] = '更新统计数据';
		
		$forum = core::gpc('forum', 'R');
		$topic = core::gpc('topic', 'R');
		$postpage = core::gpc('postpage', 'R');
		$mypost = core::gpc('mypost', 'R');
		$num = intval(core::gpc('num', 'R'))>0?intval(core::gpc('num', 'R')):100;
		$start = intval(core::gpc('start', 'R'))>0?intval(core::gpc('start', 'R')):0;
		$end = intval(core::gpc('end', 'R'))>0?intval(core::gpc('end', 'R')):1;
		if($forum){
			$arr=array();
			$forumlist=$this->forum->get_all_forum();
			foreach($forumlist as $k=>$v){
				$forum=$this->forum->get($v['fid']);
				$where=array('fid'=>$v['fid']);
				//hook admin_forum_up_count_forum_count_before.php
				$forum['topics']=$this->topic->index_count($where);
				$forum['posts']=$this->post->index_count($where);
			  $this->forum->update($forum);
			  $this->mcache->clear('forum',$v['fid']);
			  $this->mcache->clear('forum_fn',$v['name']);
			}
			// hook admin_forum_update_after.php
			$this->message('帖吧帖子数更新完成',0,'?forum-up_count.htm');
		}
		if($topic){
		    $page = misc::page();
		    $pagesize = $num;//每次更新100
		    $start1=($page-1)*$pagesize;
			$cond=array('tid'=>array('>='=>$start,'<='=>$end));
			$topiclist=$this->topic->index_fetch($cond,array('tid'=>-1),$start1,$pagesize);
			if(empty($topiclist)) $this->message('帖子回帖数更新完成',0,'?forum-up_count.htm');
			foreach($topiclist as $k=>$v){
				$where=array('tid'=>$v['tid']);
				$v['posts']=$this->post->index_count($where);
				$this->topic->update($v);
			}
			$url='?forum-up_count-topic-1-num-'.$num.'-start-'.$start.'-end-'.$end.'-page-'.($page+1).'.htm';
			$this->message('正在更新帖子回帖数TID:'.$start1.'-'.($start1+$pagesize),1,$url);
		}
		if($postpage){
			$page = misc::page();
		    $pagesize = $num;//每次更新200
		    $start1=($page-1)*$pagesize;
			
			$cond=array('pid'=>array('>='=>$start,'<='=>$end));
			$postlist=$this->post->index_fetch($cond,array('pid'=>1),$start1,$pagesize);
			if(empty($postlist)) $this->message('回帖分页更新完成',0,'?forum-up_count.htm');
			
			$postpagesize=$this->conf['pagesize'];
			
			foreach($postlist as $k=>$v){
				$arr=array();
				$where=array('tid'=>$v['tid'],'pid'=>array('<='=>$v['pid']));
				$count=$this->post->index_count($where);
				$v['page']=ceil($count/$postpagesize);
				$this->post->update($v);
               
				//$this->post->rebuild_page($v['fid'], $v['tid'], $v['pid'], $startpage=1);

			}
			$url='?forum-up_count-postpage-1-num-'.$num.'-start-'.$start.'-end-'.$end.'-page-'.($page+1).'.htm';
			$this->message('正在更新回帖分页PID:'.$start1.'-'.($start1+$pagesize),1,$url);
			
		}
		if($mypost){
			$page = misc::page();
		    $pagesize = $num;//每次更新200
		    $start1=($page-1)*$pagesize;
			
			$cond=array();//array('uid'=>array('>='=>$start,'<='=>$end));
			
			$userlist=$this->member->index_fetch($cond,array('uid'=>1),$start1,$pagesize);
			
			if(empty($userlist)) $this->message('用户帖子更新完成',0,'?forum-up_count.htm');

			foreach($userlist as $k=>$v){
				$arr=array();
				$where=array('authorid'=>$v['uid']);
				//$arr['replies']=$this->reply->up_count($where);
				$arr['posts']=$this->post->index_count($where);
				$arr['topics']=$this->topic->index_count($where);
				$arr['myposts']=$this->mypost->index_count(array('uid'=>$v['uid']));
	            $topiclist=$this->topic->index_fetch(array('authorid'=>$v['uid']),array('tid'=>1),0,100);
	      if(!empty($topiclist)){
					foreach($topiclist as $t){
						$rs='';//$this->mypost->have_tid($v['uid'],$t['fid'],$t['tid']);
						if(empty($rs)){
							$my=array(
						   'uid'=>$v['uid'],
							 'fid'=>$t['fid'],
							 'tid'=>$t['tid'],
							 'pid'=>$t['firstpid'],
						   );
						   $this->mypost->create($my);
					  }
					}
				}
				$user = array_merge($v, $arr);
				$this->member->update($user);
			}
			$url='?forum-up_count-mypost-1-num-'.$num.'-start-'.$start.'-end-'.$end.'-page-'.($page+1).'.htm';
			$this->message('正在更新用户UID:'.$start1.'-'.($start1+$pagesize),1,$url);
			
		}
		$this->view->display('forum_count.html');
		
	}

}

?>