<?php

/*
 * Copyright (C) xgcms.com
 */

/*
	此模块可以供版主管理，其他模块一律不允许版主访问！
*/

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include BBS_PATH.'admin/control/admin_control.class.php';

class mod_control extends admin_control {
	
	function __construct() {
		parent::__construct();
	}
	
	public function on_index() {
		$this->on_setforum();
	}
	
	// 设置版规，简介
	public function on_setforum() {
		$this->_checked['mod_setforum'] = 'class="checked"';
		
		$this->_title[] = '基本资料';
		$this->_nav[] = '基本资料';
		
		$fid = intval(core::gpc('fid'));
		
		$error = array();
		if($this->form_submit()) {
			$rule = core::gpc('rule', 'P');
			$brief = core::gpc('brief', 'P');
			
			// 检查权限
			$forum = $this->forum->read($fid);
			$pforum = $this->forum->read($forum['fup']);
			if(!$this->is_mod($forum, $pforum, $this->_user)) {
				$this->message('您没有权限管理此版块。');
			}
			
			$brief = htmlspecialchars(strip_tags($brief));
			$rule = $this->post->html_safe($rule);
			$rule = misc::html_space($rule, TRUE);
			
			$error['rule'] = $this->forum->check_rule($rule);
			$error['brief'] = $this->forum->check_brief($brief);
			
			if(misc::values_empty($error)) {
				$forum = $this->forum->read($fid);
				$forum['rule'] = $rule;
				$forum['brief'] = $brief;
				$this->forum->update($fid, $forum);
				$this->mcache->clear('forum', $fid);
				$error = array();
			}
		}
		$this->view->assign('error', $error);
		
		$forumoptions = $this->forum->get_priv_forumoptions($this->_user, $fid);
		$this->view->assign('forumoptions', $forumoptions);
		$this->view->assign('fid', $fid);
		
		$forum = $this->forum->read($fid);
		$forum['rule'] = str_replace(array('<br>', '<br />'), "\r\n", $forum['rule']);
		$this->view->assign('forum', $forum);
		
		$this->view->display('mod_setforum.htm');
	}
	
	// 列出版主管理日志
	public function on_listlog() {
		$this->_checked['mod_listlog'] = 'class="checked"';
		
		$this->_title[] = '操作日志';
		$this->_nav[] = '操作日志';
		
		$uid = $this->_user['uid'];
		
		$fid = intval(core::gpc('fid'));
		$oldfid = $fid;
		$forumoptions = $this->forum->get_priv_forumoptions($this->_user, $fid);
		$this->view->assign('forumoptions', $forumoptions);
		$this->view->assign('fid', $fid);
		
		if(empty($fid) && empty($oldfid)) {
			$this->message('你没有可管理的板块。');
		}
		
		// 检查权限
		$forum = $this->forum->read($fid);
		$pforum = $this->forum->read($forum['fup']);
		if(!$this->is_mod($forum, $pforum, $this->_user)) {
			$this->message('您没有权限管理此版块。');
		}
		
		$page = misc::page();
		$pagesize = 20;
		$loglist = $this->modlog->get_list_by_uid($uid, $page, $pagesize);
		$pages = misc::simple_page("?mod-listlog-fid-$fid.htm", count($loglist), $page, $pagesize);
		$this->view->assign('pages', $pages);
		$this->view->assign('loglist', $loglist);
		
		$this->view->display('mod_listlog.htm');
	}
	
	// 列出版主评分日志
	public function on_ratelog() {
		$this->_checked['mod_ratelog'] = 'class="checked"';
		
		$this->_title[] = '评分日志';
		$this->_nav[] = '评分日志';
		
		$uid = $this->_user['uid'];
		
		$fid = intval(core::gpc('fid'));
		
		$oldfid = $fid;
		$forumoptions = $this->forum->get_priv_forumoptions($this->_user, $fid);
		$this->view->assign('forumoptions', $forumoptions);
		$this->view->assign('fid', $fid);
		
		if(empty($fid) && empty($oldfid)) {
			$this->message('你没有可管理的板块。');
		}
		
		// 检查权限
		$forum = $this->forum->read($fid);
		$pforum = $this->forum->read($forum['fup']);
		if(!$this->is_mod($forum, $pforum, $this->_user)) {
			$this->message('您没有权限管理此版块。');
		}
		
		$page = misc::page();
		$pagesize = 20;
		$loglist = $this->rate->get_list_by_uid($uid, $page, $pagesize);
		$pages = misc::simple_page("?mod-ratelog.htm", count($loglist), $page, $pagesize);
		$this->view->assign('pages', $pages);
		$this->view->assign('loglist', $loglist);
		
		$this->view->display('mod_ratelog.htm');
	}
	
	// 管理回复
	public function on_reply() {
		$this->_title[] = '回复管理';
		$this->_nav[] = '回复管理';
		$this->_checked['mod_reply'] = 'class="checked"';
		
		// 检查权限
		$fid = intval(core::gpc('fid'));
		$forumoptions = $this->forum->get_priv_forumoptions($this->_user, $fid);
		$this->view->assign('forumoptions', $forumoptions);
		$this->view->assign('fid', $fid);
		
		$forum = $this->forum->read($fid);
		$pforum = $this->forum->read($forum['fup']);
		
		$page = misc::page();
		// 删除
		if($this->form_submit()) {	
			$this->check_access($forum, 'delete');
			$replyidarr = (array)core::gpc('replyid', 'P');
			foreach($replyidarr as $replyid) {
				$replyid = intval($replyid);
				$reply = $this->reply->read($fid, $replyid);
				
				// 删除
				// hook admin_mod_reply_before_reply.php
				$this->reply->xdelete($fid, $replyid);
			}
		}
		
		$pagesize = 20;
		$replylist = $this->reply->get_list_by_fid($fid, $page, $pagesize);
		foreach($replylist as &$reply) {
			$this->reply->format($reply);
			$reply['thread'] = $this->thread->read($reply['fid'], $reply['tid']);
			$reply['post'] = $this->post->read($reply['fid'], $reply['pid']);
		}
		$this->view->assign('replylist', $replylist);
		
		// pages
		$pages = misc::pages("?mod-reply-fid-$fid.htm", $forum['replies'], $page, $pagesize);
		$this->view->assign('pages', $pages);
		
		$this->view->display('mod_reply.htm');
	}
	
	// 禁止用户 / 删除用户
	public function on_manageuser() {
		// 搜索
		$this->_title[] = '用户管理';
		$this->_nav[] = '用户管理';
		$this->_checked['mod_manageuser'] = 'class="checked"';
		
		// 搜索用户
		$do = core::gpc('do');
		if(empty($do)) {
			$user = $error = array();
			if($this->form_submit()) {
				$email = trim(core::gpc('email', 'P'));
				if(empty($email)) {
					$error['email'] = '请输入用户名。';
				} else {
					$user = $this->user->get_user_by_email($email);
					empty($user) && $user = $this->user->get_user_by_username($email);
					empty($user) && $user = $this->user->read($email);
					if(empty($user)) {
						$error['email'] = '用户名不存在。';
					}
					$this->user->format($user);
				}
			}
			$this->view->assign('user', $user);
			$this->view->assign('email', $email);
			$this->view->assign('error', $error);
			$this->view->display('mod_manageuser.htm');
		} elseif($do == 'banuser') {
			if(!$this->_group['allowbanuser']) {
				$this->message('对不起，您没有禁止用户的权限', 0);
			}
			
			$uid = intval(core::gpc('uid'));
			$user = $this->user->read($uid);
			$this->check_user_exists($user);
			
			if($this->_group['groupid'] >= $user['groupid']) {
				$this->message('对不起，您没有权限管理此用户', 0);
			}
			
			$access = $this->user_access->read($uid);
			if(empty($access)) {
				$access = array(
					'uid'=>$uid,
					'allowread'=>1,
					'allowthread'=>1,
					'allowpost'=>1,
					'allowreply'=>1,
					'allowattach'=>1,
					'allowdown'=>1,
					'expiry'=>$_SERVER['time'] + 86400 * 365
				);
			}
			
			$input = $error = array();
			if($this->form_submit()) {
				$post = array('uid'=>$uid);
				$post['allowpost'] = intval(!core::gpc('allowpost', 'P'));
				$post['allowreply'] = intval(!core::gpc('allowreply', 'P'));
				$post['allowthread'] = intval(!core::gpc('allowthread', 'P'));
				$post['allowattach'] = intval(!core::gpc('allowattach', 'P'));
				$post['allowdown'] = intval(!core::gpc('allowdown', 'P'));
				$post['allowread'] = intval(!core::gpc('allowread', 'P'));
				$post['expiry'] = strtotime(core::gpc('expiry', 'P'));	// 时差问题？
				
				if(misc::values_empty($error)) {
					$error = array();
					$access = array_merge($access, $post);
					$this->user_access->update($uid, $access);
				}
			}
			
			$input['allowpost'] = form::get_checkbox_yes_no('allowpost', empty($access['allowpost']));
			$input['allowreply'] = form::get_checkbox_yes_no('allowreply', empty($access['allowreply']));
			$input['allowthread'] = form::get_checkbox_yes_no('allowthread', empty($access['allowthread']));
			$input['allowattach'] = form::get_checkbox_yes_no('allowattach', empty($access['allowattach']));
			$input['allowdown'] = form::get_checkbox_yes_no('allowdown', empty($access['allowdown']));
			$input['allowread'] = form::get_checkbox_yes_no('allowread', empty($access['allowread']));
			$input['expiry'] = form::get_text('expiry', misc::date($access['expiry'], 'Y-n-j'), 150);
			
			$this->view->assign('do', $do);
			$this->view->assign('input', $input);
			$this->view->assign('user', $user);
			$this->view->assign('error', $error);
			
			// hook admin_user_access_view_before.php
			
			$this->view->display('mod_manageuser.htm');
		} elseif($do == 'deleteuser') {
			if(!$this->_group['allowdeleteuser']) {
				$this->message('对不起，您没有删除用户的权限', 0);
			}
			
			$uid = intval(core::gpc('uid'));
			$user = $this->user->get($uid);
			$this->check_user_exists($user);
			
			if($uid == 1) {
				$this->message('NO.1 管理员不能删除！', 0);
			} elseif($uid == $this->conf['system_uid']) {
				$this->message('系统账户不能删除！', 0);
			} elseif($user['groupid'] <= 5) {
				$this->message('管理用户组不能删除！', 0);
			} else {
				$this->user->xdelete($uid);
				
				// hook admin_user_delete_after.php
				
				$this->message('删除用户成功！', 1, '?mod-manageuser.htm');
			}
		}
	}
	
	//hook admin_mod_control_after.php
}

?>