<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'core/control/common_control.class.php';

class mod_control extends common_control {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->check_login();
		if($this->_user['groupid'] > 5) {
			$this->message('对不起，您没有权限访问此版块。');
		}
		
		// 加载精华积分策略
		$this->conf += $this->kv->xget('conf_ext');
		
		// 检查IP 屏蔽
		$this->check_ip();
	}
	
	public function on_index() {
		$this->on_setforum();
	}
	
	// 设置置顶 各种置顶最多十个！
	public function on_top() {
		$this->_title[] = '设置置顶';
		$this->_nav[] = '设置置顶';
		
		$this->check_login();
		
		$fid = intval(core::gpc('fid'));
		$tidarr = $this->get_fid_tids();
		
		$forum = $this->forum->read($fid);

		$this->check_access($forum, 'top');
		
		// 去除非本版块的置顶主题
		foreach($tidarr as $k=>$v) {
			$_fid = $v[0];
			$_tid = $v[1];
			$thread = $this->topic->read($_fid, $_tid);
			if(empty($thread)) unset($tidarr[$k]);
		}
		
		if(!$this->form_submit()) {
			
			// 初始化控件状态
			$this->init_view_thread($tidarr, 'top');
			
			$this->view->assign('fid', $fid);
			
			$this->view->display('mod_top_ajax.html');
		} else {
			$rank = intval(core::gpc('rank', 'P'));
			$systempm = intval(core::gpc('systempm', 'P'));
			$comment = core::gpc('comment', 'P');
			$this->check_comment($comment);
			
			if(($this->_user['groupid'] == 4 || $this->_user['groupid'] == 5) && $rank > 1) {
				$this->message('您只有本版块置顶权限！', 0);
			}
			
			// -------> 统计 top_1 2 3 的总数，是否超过5个。
			$n = count($tidarr);
			if($rank == 1) {
				// 1 级置顶
				$keys = array();
				$this->tidkeys_to_keys($keys, $forum['toptids']);
				if(count($keys) + $n > 8) {
					$this->message('一级置顶的个数不能超过8个。', 0);
				}
			} elseif($rank == 3) {
				$keys = array();
				$this->tidkeys_to_keys($keys, $this->conf['toptids']);
				if(count($keys) + $n > 8) {
					$this->message('三级置顶的个数不能超过8个。', 0);
				}
			}
			// end
			
			// hook mod_top_after.php
			
			// 先去除已有，然后加入
			$this->topic_top->delete_top_1($forum, $tidarr);
			$this->topic_top->delete_top_3($tidarr);
			
			if($rank == 0) {
				
			} elseif($rank == 1) {
				$this->topic_top->add_top_1($forum, $tidarr);
			} elseif($rank == 3) {
				$this->topic_top->add_top_3($tidarr);
			}
			
			// 记录到版主操作日志
			foreach($tidarr as &$v) {			// 此处也得用 &
				// 初始化数据
				$fid = intval($v[0]);
				$tid = intval($v[1]);
				
				$thread = $this->topic->read($fid, $tid);
				if(empty($thread)) continue;
				$this->modlog->create(array(
					'uid'=>$this->_user['uid'],
					'username'=>$this->_user['username'],
					'fid'=>$fid,
					'dateline'=>$_SERVER['time'],
					'tid'=>$tid,
					'pid'=>0,
					'subject'=>$thread['subject'],
					'credits'=>0,
					'golds'=>0,
					'dateline'=>$_SERVER['time'],
					'action'=>$rank == 0 ? 'untop' : 'top',
					'comment'=>$comment,
				));
				
				$this->inc_modnum($fid, $tid);
				
				// 发送系统消息：
				if($systempm) {
					$pmsubject = utf8::substr($thread['subject'], 0, 32);
					$pmmessage = "您的主题<a href=\"?topic-index-fid-$fid-tid-$tid.htm\" target=\"_blank\">【{$pmsubject}】</a>被【{$this->_user['username']}】".($rank > 0 ? '置顶' : '取消置顶')."。";
					$this->pm->system_send($thread['authorid'], $thread['author'], $pmmessage);
				}
			}
			
			// hook mod_top_succeed.php
			
			$this->message('操作成功！', 1);
		}
		
	}
	
	public function on_digest() {
		$this->_title[] = '设置精华';
		$this->_nav[] = '设置精华';
		
		$this->check_login();
		
		$fid = intval(core::gpc('fid'));
		$tidarr = $this->get_fid_tids();
		
		$forum = $this->forum->read($fid);
		$this->check_forum_exists($forum);
		
		$this->check_access($forum, 'digest');
		
		if(!$this->form_submit()) {
			
			// 第一个元素作为选中状态
			$fid_tid = array_shift($tidarr);
			$fid=$fid_tid[0];
			$tid=$fid_tid[1];
			$thread = $this->topic->read($fid, $tid);
			$this->check_topic_exists($thread);
			
			$this->view->assign('thread', $thread);
			$this->view->assign('fid', $fid);
			$this->view->assign('tid', $tid);
			
			// hook mod_digest_before.php
			$this->view->display('mod_digest_ajax.html');
		} else {
			// 修改精华等级，分类。
			$rank = intval(core::gpc('rank', 'P'));
			$systempm = intval(core::gpc('systempm', 'P'));
			$comment = core::gpc('comment', 'P');
			$this->check_comment($comment);
			
			$fidarr = $creditarr = $goldarr = $digestarr = array();
			
			// hook mod_digest_after.php
			$tidnum = 0;
			foreach($tidarr as &$v) {			// 此处也得用 &
				// 初始化数据
				$fid = intval($v[0]);
				$tid = intval($v[1]);
				$thread = $this->topic->read($fid, $tid);
				if(empty($thread)) continue;
				
				$tidnum++;	// 帖子数，用来统计精华数
				
				// 更新论坛精华数 todo: 准确？ 没啥用
				$forum = $this->forum->read($fid);
				$rank == 0 ? ($thread['digest'] && $forum['digests']--) : (!$thread['digest'] && $forum['digests']++);
				$this->forum->xupdate($forum);
				$fidarr[$fid] = $fid;
				
				// 更新用户精华数，积分
				!isset($creditarr[$thread['authorid']]) && $creditarr[$thread['authorid']] = 0;
				!isset($goldarr[$thread['authorid']]) && $goldarr[$thread['authorid']] = 0;
				!isset($digestarr[$thread['authorid']]) && $digestarr[$thread['authorid']] = 0;
				// 先减去积分，否则会造成重复加分
				if($thread['digest'] > 0) {
					$creditarr[$thread['authorid']] -= $this->conf['credits_policy_digest_'.$thread['digest']];
					$goldarr[$thread['authorid']] -= $this->conf['golds_policy_digest_'.$thread['digest']];
				}
				if($rank > 0) {
					$creditarr[$thread['authorid']] += $this->conf['credits_policy_digest_'.$rank];
					$goldarr[$thread['authorid']] += $this->conf['golds_policy_digest_'.$rank];
				}
				// 加入精华
				if($rank > 0 && $thread['digest'] == 0) {
					$digestarr[$thread['authorid']]++;
					$this->topic_digest->create(array('fid'=>$fid, 'tid'=>$tid, 'digest'=>$rank));
				// 取消精华
				} elseif($rank == 0 && $thread['digest'] > 0) {
					$digestarr[$thread['authorid']]--;
					$this->topic_digest->delete($tid);
				// 更新精华
				} elseif($rank > 0 && $thread['digest'] > 0 && $rank != $thread['digest']) {
					$thread_digest = $this->topic_digest->read($tid);
					$thread_digest['digest'] = $rank;
					$this->topic_digest->update($thread_digest);
				} else {
					continue;
				}
				
				// 记录到版主操作日志
				$credits2 = $rank == 0 ? 0 - $this->conf['credits_policy_digest_'.$thread['digest']] : $this->conf['credits_policy_digest_'.$rank];
				$golds2 = $rank == 0 ? 0 - $this->conf['golds_policy_digest_'.$thread['digest']] : $this->conf['golds_policy_digest_'.$rank];
				$this->modlog->create(array(
					'uid'=>$this->_user['uid'],
					'username'=>$this->_user['username'],
					'fid'=>$fid,
					'tid'=>$tid,
					'pid'=>0,
					'subject'=>$thread['subject'],
					'credits'=> $credits2,
					'golds'=> $golds2,
					'dateline'=>$_SERVER['time'],
					'action'=>$rank == 0 ? 'undigest' : 'digest',
					'comment'=>$comment,
				));
				
				$thread['digest'] = $rank;
				
				$this->topic->update($thread);
				
				$this->inc_modnum($fid, $tid);
				
				// 发送系统消息：
				if($systempm) {
					$pmsubject = utf8::substr($thread['subject'], 0, 32);
					$pmmessage = "您的主题<a href=\"?topic-index-fid-$fid-tid-$tid.htm\" target=\"_blank\">【{$pmsubject}】</a>被【{$this->_user['username']}】".($rank > 0 ? '设置精华' : '取消精华')."。";
					$this->pm->system_send($thread['authorid'], $thread['author'], $pmmessage);
				}
				
				// hook mod_digest_loop_after.php
			}
			
			foreach($creditarr as $uid=>$credits) {
				$uid = intval($uid);
				$user = $this->member->read($uid);
				$user['credits'] += $credits;
				$user['golds'] += $goldarr[$uid];
				$user['digests'] += $digestarr[$uid];
				$this->member->update($user);
			}
			
			// hook mod_digest_succeed.php
			$this->message('操作成功！');
		}
	}

	
	public function on_delete() {
		$this->_title[] = '删除主题';
		$this->_nav[] = '删除主题';
		
		$this->check_login();
		
		$fid = intval(core::gpc('fid'));
		$tidarr = $this->get_fid_tids();

		$forum = $this->forum->read($fid);

		$this->check_access($forum, 'delete');
		
		if(!$this->form_submit()) {
			
			$this->view->assign('fid', $fid);
			
			// hook mod_delete_before.php
			$this->view->display('mod_delete_ajax.html');
		} else {
			
			$systempm = intval(core::gpc('systempm', 'P'));
			$comment = core::gpc('comment', 'P');
			$this->check_comment($comment);
			
			// hook mod_delete_after.php
			foreach($tidarr as $v) {

				$fid = $v[0];
			    $tid = $v[1];
				// 记录到版主操作日志
				$thread = $this->topic->read($fid, $tid);
				$this->modlog->create(array(
					'uid'=>$this->_user['uid'],
					'username'=>$this->_user['username'],
					'fid'=>$fid,
					'tid'=>$tid,
					'pid'=>0,
					'subject'=>$thread['subject'],
					'credits'=>0,
					'golds'=>0,
					'dateline'=>$_SERVER['time'],
					'action'=>'delete',
					'comment'=>$comment,
				));
				
				// hook mod_delete_loop_after.php
				
				// 发送系统消息：
				if($systempm) {
					$pmsubject = utf8::substr($thread['subject'], 0, 32);
					$pmmessage = "您的帖子【{$pmsubject}】被【{$this->_user['username']}】删除。";
					$this->pm->system_send($thread['authorid'], $thread['author'], $pmmessage);
				}
				
				$this->topic->xdelete($fid, $tid, TRUE);
			}
			
			// hook mod_delete_succeed.php
			$this->message('操作成功！');
		}
	}
	
	// copy from thread_control.class.php
	private function tidkeys_to_keys(&$keys, $tidkeys) {
		if($tidkeys) {
			$fidtidlist = explode(' ', trim($tidkeys));
			foreach($fidtidlist as $fidtid) {
				list($fid, $tid) = explode('-', $fidtid);
				$tid && $keys[] = "thread-fid-$fid-tid-$tid";
			}
		}
	}
	
	// 截取前几个字符串，分隔符为
	private function substr_by_sep($string, $sep, $n) {
		$arr = explode($sep, $string);
		$arr2 = array_slice($arr, 0, $n);
		return implode($sep, $arr2);
	}
	// 传递 tid
	private function get_fid_tids() {
		$fid_tids = core::gpc('fid_tids'); // 字符串: 123_100__123_101__123_102
		$r = array();
		$arr = explode('__', $fid_tids);
		foreach((array)$arr as $v) {
			$arr2 = explode('_', $v);
			//if(!isset($arr2[1])) continue;
			$r[] = array(intval($arr2[0]), intval($arr2[1]));
		}
		//$fidtidarr = misc::explode('_', '__', $fid_tids);
		$threads = count($r);
		$this->view->assign('fid_tids', $fid_tids);
		$this->view->assign('threads', $threads);
		return $r;
	}
	
	// 增加版主操作次数
	private function inc_modnum($fid, $tid) {
		$thread = $this->topic->read($fid, $tid);
		$thread['modnum']++;
		$this->topic->update($thread);
	}
	
// 初始化控件的初始值。
	private function init_view_thread($fidtidarr, $action = '') {
		$thread = $modlog = array();
		foreach($fidtidarr as &$v) {
			$fid = $v[0];
			$tid = $v[1];
			$thread = $this->topic->read($fid, $tid);
			break;
		}
		$this->view->assign('thread', $thread);
		
		// modlog, 最后一次的操作
		if(!empty($thread)) {
			$modloglist = $this->modlog->get_list_by_fid_tid($thread['fid'], $thread['tid']);
			foreach($modloglist as &$modlog) {
				if($modlog['action'] == $action) {
					break;
				}
			}
			$this->view->assign('modlog', $modlog);
		}
	}
	
	private function check_comment(&$comment) {
		core::htmlspecialchars($comment);
		if(utf8::strlen($comment) > 64) {
			$this->message('评价不能超过64个字符！', 0);
		}
	}
	
	// copy from post_control.class.php
	private function init_type_select($forum, $typeid1 = 0, $typeid2 = 0, $typeid3 = 0, $typeid4 = 0) {
		$typearr1 = empty($forum['types'][1]) ? array() : array('0'=>'&gt;'.$forum['typecates'][1]) + (array)$forum['types'][1];
		$typearr2 = empty($forum['types'][2]) ? array() : array('0'=>'&gt;'.$forum['typecates'][2]) + (array)$forum['types'][2];
		$typearr3 = empty($forum['types'][3]) ? array() : array('0'=>'&gt;'.$forum['typecates'][3]) + (array)$forum['types'][3];
		$typearr4 = empty($forum['types'][4]) ? array() : array('0'=>'&gt;'.$forum['typecates'][4]) + (array)$forum['types'][4];
		$typeselect1 = $typearr1 && !empty($forum['typecates'][1]) ? form::get_select('typeid1', $typearr1, $typeid1, '') : '';
		$typeselect2 = $typearr2 && !empty($forum['typecates'][2]) ? form::get_select('typeid2', $typearr2, $typeid2, '') : '';
		$typeselect3 = $typearr3 && !empty($forum['typecates'][3]) ? form::get_select('typeid3', $typearr3, $typeid3, '') : '';
		$typeselect4 = $typearr4 && !empty($forum['typecates'][4]) ? form::get_select('typeid4', $typearr4, $typeid4, '') : '';
		$this->view->assign('typeselect1', $typeselect1);
		$this->view->assign('typeselect2', $typeselect2);
		$this->view->assign('typeselect3', $typeselect3);
		$this->view->assign('typeselect4', $typeselect4);
	}
	
	//hook mod_control_after.php
}

?>