<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'core/control/common_control.class.php';

class modaction_control extends common_control {
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->check_login();
		if($this->_user['groupid'] > 5) {
			$this->message('对不起，您没有权限访问此板块。');
		}
	}
	
		
	// tpdo: 删除帖子，删除主题, todayposts 未更新
	public function on_delete() {
		$this->_title[] = '删除帖子';
		$this->_nav[] = '删除帖子';
		
		$this->check_login();
		$this->check_forbidden_group();
		
		$pid = intval(core::gpc('pid'));
		$fid = intval(core::gpc('fid'));
		
		$uid = $this->_user['uid'];
		$username = $this->_user['username'];
		$user = $this->member->read($uid);
		$this->check_user_delete($user);
		
		// 板块权限检查
		$forum = $this->mcache->read('forum', $fid);
		
		$this->check_forum_exists($forum);
		$this->check_forum_status($forum);

		$this->check_access($forum, 'thread');
		
		$post = $this->post->read($fid, $pid);
		$this->check_post_exists($post);
		$tid = $post['tid'];
		
		$thread = $this->topic->get($fid, $tid);
		$this->check_topic_exists($thread);
		
		// 编辑权限检查：管理员，版主，可以编辑
		if($post['authorid'] != $this->_user['uid']) {
			$this->check_access($forum, 'delete');
		}
		
		$isfirst = $thread['firstpid'] == $pid;
		
		if($isfirst) {
			
			// hook post_delete_post_before.php
			$this->topic->xdelete($fid, $tid, TRUE);	// 删除 $postlist, 更新 $forum $userlist
			// hook post_delete_post_after.php
			
			$this->clear_forum_cache($fid);
			
			$this->location("?forum-index-fid-$fid.htm");
			
		} else {
			
			// hook post_delete_thread_before.php
			$this->post->xdelete($fid, $pid, TRUE);
			// hook post_delete_thread_after.php
			
			// 重建页数
			$this->post->rebuild_page($fid, $tid, $pid, $post['page']);
			
			$this->location("?topic-index-fid-$fid-tid-$tid-page-$post[page].htm");
		}
	}
		// 设置置顶 各种置顶最多十个！
	public function on_top() {
		$this->_title[] = '设置置顶';
		$this->_nav[] = '设置置顶';
		
		$this->check_login();
		
		$fid = intval(core::gpc('fid'));
		$tid = intval(core::gpc('tid'));
		//$tidarr = $this->get_tidarr();
		$tidarr=array(0=>$fid.'-'.$tid);
		
		$forum = $this->forum->read($fid);

		$this->check_access($forum, 'top');
		
		if(!$this->form_submit()) {
			
			// 初始化控件状态
			$this->init_view_thread($tidarr, 'top');
			
			$this->view->assign('fid', $fid);
			
			$this->view->assign('tid', $tid);
			
			$this->view->display('mod_top_ajax.html');
		} else {
			$rank = intval(core::gpc('rank', 'P'));
			$digest_rank=intval(core::gpc('digest_rank', 'P'));
			$lock= intval(core::gpc('lock', 'P'));
			
			$systempm = intval(core::gpc('systempm', 'P'));
			$comment = core::gpc('comment', 'P');
			$this->check_comment($comment);
			
			$this->set_digest($fid,$tidarr,$digest_rank,$systempm,$comment);//精华操作
			
			if($this->_user['groupid'] == 3 && $rank != 1) {
				$this->message('您只能对帖子进行板块置顶！', 0);
			}
			if($this->_user['groupid'] == 2 && $rank == 3) {
				$this->message('您不能对帖子进行全站置顶！', 0);
			}
			
			// -------> 统计 top_1 2 3 的总数，是否超过5个。
			$n = 1;
			if($rank == 1) {
				// 1 级置顶
				$keys = array();
				$this->tidkeys_to_keys($keys, $forum['toptids']);
				if(count($keys) + $n > 8) {
					$this->message('一级置顶的个数不能超过8个。', 0);
				}
			} elseif($rank == 2) {
				$keys = array();
				$this->tidkeys_to_keys($keys, $pforum['toptids']);
				if(count($keys) + $n > 8) {
					$this->message('二级置顶的个数不能超过8个。', 0);
				}
			} elseif($rank == 3) {
				$keys = array();
				$this->tidkeys_to_keys($keys, $this->conf['runtime']['toptids']);
				if(count($keys) + $n > 8) {
					$this->message('三级置顶的个数不能超过8个。', 0);
				}
			}
			// end
			
			// hook mod_top_after.php
			
			// 先去除已有，然后加入
			$this->topic_top->delete_top_1($forum, $tidarr);
			//$this->topic_top->delete_top_2($forum, $tidarr, $pforum);
			$this->topic_top->delete_top_3($forum, $tidarr);
			
			if($rank == 0) {
				
			} elseif($rank == 1) {
				$this->topic_top->add_top_1($forum, $tidarr);
			} elseif($rank == 2) {
				//$this->topic_top->add_top_2($forum, $tidarr, $pforum);
			} elseif($rank == 3) {
				$this->topic_top->add_top_3($forum, $tidarr);
			}
			
			// 记录到版主操作日志
			foreach($tidarr as &$v) {			// 此处也得用 &
				// 初始化数据
				list($fid, $tid) = explode('-', $v);
				//$fid = intval($fid);
				$tid = intval($tid);
				
				$thread = $this->topic->read($fid, $tid);
				if(empty($thread)) continue;
				$this->modlog->create(array(
					'uid'=>$this->_user['uid'],
					'username'=>$this->_user['username'],
					'fid'=>$fid,
					'tid'=>$tid,
					'pid'=>0,
					'subject'=>$thread['subject'],
					'credits'=>0,
					'golds'=>0,
					'action'=>$rank == 0 ? 'untop' : 'top',
					'comment'=>$comment,
				));
				// 帖子锁定 
				if($lock!=$thread['lockout']){
				    $thread['lockout'] = $lock;
				    $this->topic->update($fid, $tid, $thread);
				}
				
				//$this->inc_modnum($fid, $tid);
				
/*				// 发送系统消息：
				if($systempm&&$thread['authorid']>0) {
					$pmsubject = utf8::substr($thread['subject'], 0, 32);
					$pmmessage = "您的主题<a href=\"?topic-index-fid-$fid-tid-$tid.html\" target=\"_blank\">【{$pmsubject}】</a>被版主【{$this->_user['username']}】".($rank > 0 ? '置顶' : '取消置顶')."。";
					$this->message->add_message($thread['author'],'SYSTEM',"【".$pmsubject.($rank > 0 ? '】被置顶' : '】被取消置顶'),$pmmessage);
				}*/
				// 发送系统消息：
				if($systempm) {
					$pmsubject = utf8::substr($thread['subject'], 0, 32);
					$pmmessage = "您的主题<a href=\"?topic-index-fid-$fid-tid-$tid.htm\" target=\"_blank\">【{$pmsubject}】</a>被【{$this->_user['username']}】".($rank > 0 ? '置顶' : '取消置顶')."。";
					$this->pm->system_send($thread['uid'], $thread['username'], $pmmessage);
				}
			}
			
			// hook mod_top_succeed.php
			
			$this->message('操作成功！', 1);
		}
		
	}
	
	public function set_digest($fid,$tidarr,$rank,$systempm,$comment) {
			$fidarr = $uidarr = array();	
			// hook mod_digest_after.php
			$tidnum = 0;
			foreach($tidarr as &$v) {			// 此处也得用 &
				// 初始化数据
				list($fid, $tid) = explode('-', $v);
				//$fid = intval($fid);
				$tid = intval($tid);
				$thread = $this->topic->read($fid, $tid);
				if(empty($thread)) continue;
				if($rank == 0 && $thread['digest'] == 0) continue;
				
				// 更新 digestcate.threads
				$tidnum++;	// 帖子数，用来统计精华数
				// 更新论坛精华数 todo: 准确？
				$forum = $this->forum->read($fid);
				$rank == 0 ? ($thread['digest'] && $forum['digests']--) : (!$thread['digest'] && $forum['digests']++);
				$this->forum->update($fid, $forum);
				$fidarr[$fid] = $fid;
				
				// 更新用户精华数，积分
				!isset($uidarr[$thread['authorid']]) && $uidarr[$thread['authorid']] = 0;
				// 先减去积分，否则会造成重复加分
				if($thread['digest'] > 0) {
					$uidarr[$thread['authorid']] -= $this->conf['credits_policy_digest_'.$thread['digest']];
					$uidarr[$thread['authorid']] -= $this->conf['golds_policy_digest_'.$thread['digest']];
				}
				if($rank > 0) {
					$uidarr[$thread['authorid']] += $this->conf['credits_policy_digest_'.$rank];
					$uidarr[$thread['authorid']] += $this->conf['golds_policy_digest_'.$rank];
				}
				
				// 记录到版主操作日志
				$credits2 = $rank == 0 ? 0 - $this->conf['credits_policy_digest_'.$thread['digest']] : $this->conf['credits_policy_digest_'.$rank];
				$golds2 = $rank == 0 ? 0 - $this->conf['golds_policy_digest_'.$thread['digest']] : $this->conf['golds_policy_digest_'.$rank];
				$this->modlog->create(array(
					'uid'=>$this->_user['uid'],
					'username'=>$this->_user['username'],
					'fid'=>$fid,
					'tid'=>$tid,
					'pid'=>0,
					'subject'=>$thread['subject'],
					'credits'=> $credits2,
					'golds'=> $golds2,
					'dateline'=>$_SERVER['time'],
					'action'=>$rank == 0 ? 'undigest' : 'digest',
					'comment'=>$comment,
				));
				
				// 帖子精华信息 
				$thread['digest'] = $rank;
				$this->topic->update($fid, $tid, $thread);
				
				if($rank == 0) {
					$this->digest->delete_by_fid_tid($fid, $tid);
				} else {
					// 先删除所有的分类，然后添加进去。
					$this->digest->delete_by_fid_tid($fid, $tid);
						$arr = array(
							'fid'=>$fid,
							'tid'=>$tid,
							'digest'=>$rank,
							'subject'=>$thread['subject'],
							'rank'=>$rank,
						);
						$this->digest->create($arr);
					//}
				}
				// 发送系统消息：
				if($systempm&&$thread['authorid']>0) {
					$pmsubject = utf8::substr($thread['subject'], 0, 32);
					$pmmessage = "您的主题<a href=\"?topic-index-fid-$fid-tid-$tid.html\" target=\"_blank\">【{$pmsubject}】</a>被版主【{$this->_user['username']}】".($rank > 0 ? '设置精华' : '取消精华')."。";
					$this->message->add_message($thread['author'],'SYSTEM',"【".$pmsubject.($rank > 0 ? '】被设置精华' : '】被取消精华'),$pmmessage);
				}
				
				// hook mod_digest_loop_after.php
			}
			foreach($fidarr as $fid) {
				$this->mcache->clear('forum', $fid);
			}
			
			foreach($uidarr as $uid=>$credits) {
				$uid = intval($uid);
				$user = $this->member->read($uid);
				$user['credits'] += $credits;
				$credits > 0 ? $user['digests']++ : $user['digests']--;
				$this->member->update($uid, $user);
			}
			
			// hook mod_digest_succeed.php
	}
	private function lock_topic(){
		
		
	}
	
	// 传递 tid
	private function get_tidarr() {
		$tid=intval(core::gpc('tid'));
		$fid=intval(core::gpc('fid'));
		$tidarr=array(0=>$fid.'-'.$tid);
		//$tidarr[]=$fid.'-'.$tid;
		$this->view->assign('threads', 1);
		return $tidarr;
		
		/*
		$tidarr = (array)core::gpc('tidarr');
		$tidsurl = '';
		foreach($tidarr as $fid_tid) {$tidsurl .= '&tidarr[]='.$fid_tid;}
		$threads = count($tidarr);
		$this->view->assign('tidsurl', $tidsurl);
		$this->view->assign('threads', $threads);
		return $tidarr;
		*/
	}
	// copy from thread_control.class.php
	private function tidkeys_to_keys(&$keys, $tidkeys) {
		if($tidkeys) {
			$fidtidlist = explode(' ', trim($tidkeys));
			foreach($fidtidlist as $fidtid) {
				list($fid, $tid) = explode('-', $fidtid);
				$tid && $keys[] = "topic-fid-$fid-tid-$tid";
			}
		}
	}
		// 初始化控件的初始值。
	private function init_view_thread($tidarr, $action = '') {
		$thread = $modlog = array();
		foreach($tidarr as &$v) {
			list($fid, $tid) = explode('-', $v);
			$tid = intval($tid);
			$thread = $this->topic->read($fid, $tid);
			break;
		}
		$this->view->assign('thread', $thread);
		
		// modlog, 最后一次的操作
		if(!empty($thread)) {
			$modloglist = $this->modlog->get_list_by_fid_tid($thread['fid'], $thread['tid']);
			foreach($modloglist as &$modlog) {
				if($modlog['action'] == $action) {
					break;
				}
			}
			$this->view->assign('modlog', $modlog);
		}
	}
	
	private function check_comment(&$comment) {
		core::htmlspecialchars($comment);
		if(utf8::strlen($comment) > 64) {
			$this->message('评价不能超过64个字符！', 0);
		}
	}
}

?>