<?php

/*
 * Copyright (C) xiuno.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'core/control/common_control.class.php';

class tag_control extends common_control {

	function __construct(&$conf) {
		parent::__construct($conf);
	}
	public function on_index(){
		$tag=core::gpc('q');
		$tag=urldecode($tag);
		$tag=misc::safe_str($tag);
		$tag_url=urlencode($tag);
		
		$this->_title[]=$tag.'_标签';
		$this->_seo_keywords = $tag.',贴吧,'.$this->conf['seo_keywords'];
		$this->_seo_description = $tag.',贴吧,'.$this->conf['seo_description'];
		
		
		$page=misc::page();
		$pagesize=20;
		
		$taginfo=$this->tags->_read($tag);
		
		$topiclist=array();
		if($taginfo){
			$topiclist=$this->tags_data->get_list_by_tagid($taginfo['id'],$page,$pagesize);
			foreach($topiclist as &$topic){
				$this->topic->format($topic);
			}
		}
		$pages = misc::simple_pages("?tag-index-q-$tag_url.htm", count($topiclist), $page, $pagesize);
		$this->view->assign('tag',$tag);
		$this->view->assign('threadlist',$topiclist);
		$this->view->display('tag_index.html');	
	}
	public function on_get_tag(){
		$s=core::gpc('s','P');
		$s=misc::safe_str($s);
		if($s){
			try{
			   $rs=misc::fetch_url('http://post.xgcms.com/api/keyword.php',2,"s=$s");
			   echo $rs;
			}catch(Exception $e) {
				
			   echo 0; 
			}
		}else{
		   	echo 0;
		}
	}
	
}

?>