<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'core/control/common_control.class.php';

class topic_control extends common_control {
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->_checked = array('bbs'=>' class="checked"');
	}
	public function on_index(){
		// hook topic_index_before.php
		
		$fid = intval(core::gpc('fid'));
		$tid = intval(core::gpc('tid'));
		$uid = $this->_user['uid'];
		$page = misc::page();
		// hook topic_index_read_topic_before.php
		$topic=$this->topic->read($fid,$tid);
		$this->check_topic_exists($topic);
		$this->topic->format($topic);
		$fpage = intval(core::gpc($this->conf['cookie_pre'].'page', 'C'));
		
		// 板块权限检查
		$forum = $this->mcache->read('forum', $fid);
		$this->check_forum_exists($forum);
		$this->check_forum_status($forum);
		$this->check_access($forum, 'read');
		
		// hook topic_index_check_access_after.php
		// SEO 优化
		$this->_title[] = $topic['subject'];
		$this->_title[] = '_'.$forum['name'];
		$this->_seo_keywords = $topic['seo_keywords'] ? $topic['seo_keywords'] : $topic['subject'];
		$this->_seo_description=$topic['brief'];
		
		// hook thread_index_fetch_before.php
		
		$totalpage = max(1,ceil($topic['posts'] / $this->conf['pagesize']));
		$page > $totalpage && $page = $totalpage;
		$postlist = $this->post->index_fetch(array('fid'=>$fid, 'tid'=>$tid, 'page'=>$page<1?1:$page), array(), 0, $this->conf['pagesize']);
			
		$postlist = array_filter($postlist);
		// php order by pid，一般情况下不用排序，但是偶尔数据库返回的数据为乱序。这里排序有问题！
		//ksort($postlist);	// key 为字符串，排序不稳定。 fid-2-pid-999 fid-2-pid-1000 这种情
		misc::arrlist_multisort($postlist, 'pid', TRUE);

		// 附件，用户
		$uids = $uid ? array($uid) : array();
		
		foreach($postlist as &$post) {
			
			$this->post->format($post);
			if($post['attachnum'] > 0) {
				$post['attachlist'] = $this->attachment->get_list_by_fid_pid($fid, $post['pid'], 0);
			}
			//$post['floor'] = $i++;
			$uids[] = $post['authorid'];
		}

		
		$uids = array_unique($uids);
		$userlist = $this->member->mget($uids);
		foreach($userlist as $uk=>&$user) {
			if(empty($user))  continue;
			$this->member->format($user);
			$userlist[$user['uid']] = $user;
			unset($userlist[$uk]);
		}
		//$uid && $this->_user = $userlist[$uid];
		// 分页
		if($this->conf['urlrewrite']){	
			$url_forum=substr($this->conf['url_forum'],stripos($this->conf['url_forum'],'|')+1);
			$url_forum=$this->conf['app_url'].$url_forum;
			$url_digest=str_replace(array('[fid]','[name]','[type]','[page]'),array($fid,$forum['name'],'digest',1),$url_forum);
			$url_pic=str_replace(array('[fid]','[name]','[type]','[page]'),array($fid,$forum['name'],'pic',1),$url_forum);
			
			$url_page=substr($this->conf['url_topic'],stripos($this->conf['url_topic'],'|')+1);
			$url_page=$this->conf['app_url'].str_replace(array('[fid]','[tid]'),array($fid,$tid),$url_page);
		}else{
			$url_digest='?forum-index-fid-'.$fid.'-type-digest.htm';
			$url_pic='?forum-index-fid-'.$fid.'-type-pic.htm';
			$url_page='?topic-index-fid-'.$fid.'-tid-'.$tid.'.htm';
		}
		$pages = misc::pages($url_page, $topic['posts'], $page, $this->conf['pagesize'],'page',$this->conf['urlrewrite']);
		
		// 点击数服务器 seo notfollow
		//$click_server = $this->conf['click_server']."?db=tid&w=$tid&r=$tid";
		$viewsid=$fid.'_'.$tid;
		$click_server = $this->conf['click_server'].'?db=tid&w='.$viewsid.'&r='.$viewsid;
		
		$scrollbottom = core::gpc('scrollbottom');
		
		
		// 版主
		$ismod = $this->is_mod($forum, $this->_user);
		
		// userlist

           // 作者其他帖子
			$authorpostlist = $authorposts=array();
            if($topic['authorid']>0){
			    $authorpostlist = $this->mypost->get_list_by_uid($topic['authorid'],1,10);
			    foreach($authorpostlist as &$v) {
                    $this->mypost->sim_format($v);
                    $authorposts[]=array(
                        'fid'=> $v['topic']['fid'],
					    'tid'=> $v['topic']['tid'],
					    'subject'=> $v['topic']['subject'],
                    );
			   }
            }
		$type='';
        $this->view->assign('authorpostlist',$authorposts);
		$this->view->assign('click_server', $click_server);
		$this->view->assign('scrollbottom', $scrollbottom);
		$this->view->assign('fid', $fid);
		$this->view->assign('tid', $tid);
		$this->view->assign('type', $type);
		$this->view->assign('page', $page);
		$this->view->assign('fpage', $fpage);
		$this->view->assign('pages', $pages);
		$this->view->assign('topic', $topic);
		$this->view->assign('forum', $forum);
		$this->view->assign('postlist', $postlist);
		$this->view->assign('userlist', $userlist);
		$this->view->assign('ismod', $ismod);
		$this->view->assign('url_digest', $url_digest);
		$this->view->assign('url_pic', $url_pic);
		// hook topic_index_after.php
		$this->view->display('topic_index.html');
		
	}
	//帖子举报
	public function on_report(){
		$userinfo=$this->_user;
		$uid=intval($userinfo['uid']);
		if($uid<1) $this->message('请先登录');
		// fid
		$fid =intval(core::gpc('fid'));
		$forum = $this->mcache->read('forum', $fid);
		$this->check_forum_exists($forum);
		$this->check_forum_status($forum);
		
		$pid =intval(core::gpc('pid'));
		$post = $this->post->read($fid, $pid);
		$this->check_post_exists($post);
		$tid = intval($post['tid']);
		$thread = $this->topic->get($fid, $tid);
		$this->check_topic_exists($thread);
		
		if($this->form_submit()){
			
			$ishave=$this->report->get_by_uid_pid($uid,$pid);
			if(!empty($ishave)) $this->message('你已经举报过该帖子，请等待处理！',0);
			$message=core::gpc('message','P');
			
			$message = htmlspecialchars($message);
		    $message = misc::html_space($message);
		    $message = utf8::safe_substr($message, 0, 200);	
			
			$data=array();
			$data['uid']=$userinfo['uid'];
			$data['uname']=$userinfo['username'];
			$data['subject']=$thread['subject'];
			$data['pid']=$pid;
			$data['tid']=$tid;
			$data['fid']=$fid;
			$data['author']=$post['author'];
			$data['authorid']=$post['authorid'];
			$data['message']=$message;
			$data['dateline']=$_SERVER['time'];

			$this->report->create($data);
			$this->message('举报成功，等待处理',1);
		}else{
			$this->view->assign('fid',$fid);
			$this->view->assign('topic',$thread);
			$this->view->assign('post',$post);
			$this->view->assign('forum',$forum);
			$this->view->display('topic_report.html');
		}
		
	}
	public function on_count(){
		$fid = intval(core::gpc('fid'));
		$tid = intval(core::gpc('tid'));


        $views=intval(core::gpc('views'));
		
		$topic=$this->topic->read($fid,$tid);
		
		if(!empty($topic)){
			$topic['views']=$views>$topic['views']?$views:$topic['views']+1;
			$this->topic->update($topic);
		}
		
		
		
	}
	
}