<?php

/*
 * Copyright (C) xgcms.com
 */

class category extends base_model {
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->table = 'category';
		$this->primarykey = array('id');
		$this->maxcol = 'id';
	}
		// 取分类列表，二级
	public function get_category_list() {
		$catelist = $this->index_fetch(array('pid'=>0), array('rank'=>-1), 0, 1000);
		foreach($catelist as &$cate) {
			$cate['catelist_son'] = $this->index_fetch(array('pid'=>$cate['id']), array('rank'=>1), 0, 1000);
		}
		return $catelist;
	}
		// 取分类列表
	public function get_category_all_list() {
		$catelist = $this->index_fetch(array(), array('rank'=>1), 0, 1000);
		return $catelist;
	}

	public function _delete($cid) {
		$return = $this->delete($cid);
		if($return) {
			$this->count('-1');
		}
		return $return;
	}
	// 生成 <option>，超版和管理员能看到所有版块？
	public function get_category_options($checkedfid = 0, $groupid = 0) {
		$s = '<option value="0" style="font-weight: 800;">一级分类</option>';
		$catelist = $this->get_category_list();
		foreach($catelist as &$cate) {
			$checked = $checkedfid == $cate['id'] ? ' selected="selected"' : '';
			$s .= '<option value="'.$cate['id'].'"'.$checked.' style="font-weight: 800;">'.$cate['name'].'</option>';
			/*foreach($cate['catelist_son'] as &$cate_s) {
				$checked = $checkedfid == $cate_s['pid'] ? ' selected="selected"' : '';
				$s .= '<option value="'.$cate_s['id'].'"'.$checked.'>    &nbsp;   &nbsp; |-'.$cate_s['name'].'</option>';
			}*/
		}
		return $s;
	}
	public function check_name(&$name) {
		if(empty($name)) {
			return '分类名称不能为空。';
		}
		return '';
	}
	// 返回简单格式 typeid=>typename
	public function get_list_by_cid($cid) {
		$catelist = $this->index_fetch(array('id'=>$cid), array(), 0, 1);
		misc::arrlist_multisort($catelist, 'rank', TRUE);
		foreach($catelist as $v){
			return $v['name'];
		}
		return '未知';
	}
	// 返回简单格式 typeid=>typename
	public function get_fup_by_cid($cid) {
		$catelist = $this->index_fetch(array('id'=>$cid), array(), 0, 1);
		misc::arrlist_multisort($catelist, 'rank', TRUE);
		foreach($catelist as $v){
			return $v['pid'];
		}
		return '0';
	}
}
?>