<?php
/**
* @package phpBB-WAP
* @copyright (c) phpBB Group
* @Оптимизация под WAP: Гутник Игорь ( чел ).
* @简体中文：中文phpBB-WAP团队
* @license http://opensource.org/licenses/gpl-license.php
**/

/**
* 这是一款自由软件, 您可以在 Free Software Foundation 发布的
* GNU General Public License 的条款下重新发布或修改; 您可以
* 选择目前 version 2 这个版本（亦可以选择任何更新的版本，由
* 你喜欢）作为新的牌照.
**/

if ( !defined('IN_PHPBB') )
{
	die('非法访问');
}

if (isset($_GET[POST_FORUM_URL]))
{
	$forum_id = get_var(POST_FORUM_URL, 0);
	
	if (!$forum_id)
	{
		trigger_error('请指定论坛的ID', E_USER_ERROR);
	}

	$sql = 'SELECT forum_id 
		FROM ' . FORUMS_TABLE . ' 
		WHERE forum_id = ' . $forum_id;
		
	if (!($result = $db->sql_query($sql)))
	{ 
		trigger_error('无法取得论坛信息', E_USER_WARNING); 
	} 

	if ($db->sql_numrows($result))
	{

		require (ROOT_PATH . 'includes/attach/attachment_mod.php');

		$auth = auth(AUTH_ALL, $forum_id, $userdata);
		
		$_max_filesize = $board_config['max_filesize'];

		if (!($auth['auth_attachments'] && $auth['auth_view']))
		{
			trigger_error('网站不允许在论坛中使用附件，如需开启请联系系统管理员', E_USER_ERROR);
		}

		$sql = 'SELECT group_id, group_name, max_filesize, forum_permissions
			FROM ' . EXTENSION_GROUPS_TABLE . ' 
			WHERE allow_group = 1 
			ORDER BY group_name ASC';

		if (!($result = $db->sql_query($sql)))
		{ 
			trigger_error('Could not query Extension Groups.', E_USER_WARNING);
		} 

		$allowed_filesize 	= array(); 
		$rows 				= $db->sql_fetchrowset($result); 
		$num_rows 			= $db->sql_numrows($result); 
		$db->sql_freeresult($result);

		$nothing = true;
		for ($i = 0; $i < $num_rows; $i++)
		{
			$auth_cache = trim($rows[$i]['forum_permissions']);
			$permit = ($privmsg) ? true : ((is_forum_authed($auth_cache, $forum_id)) || trim($rows[$i]['forum_permissions']) == '');

			if ($permit)
			{
				$nothing = false;
				$group_name = $rows[$i]['group_name'];
				$f_size = intval(trim($rows[$i]['max_filesize']));
				$det_filesize = (!$f_size) ? $_max_filesize : $f_size;
				$size_lang = ($det_filesize >= 1048576) ? 'MB' : (($det_filesize >= 1024) ? 'KB' : 'Bytes'); 

				if ($det_filesize >= 1048576) 
				{
					$det_filesize = round($det_filesize / 1048576 * 100) / 100; 
				}
				else if ($det_filesize >= 1024) 
				{ 
					$det_filesize = round($det_filesize / 1024 * 100) / 100; 
				} 

				$max_filesize = ($det_filesize == 0) ? '没有限制' : $det_filesize . ' ' . $size_lang;

				$template->assign_block_vars('group_row', array(
					'GROUP_RULE_HEADER' => $group_name . ' -> 最大上传的大小: ' . $max_filesize)
				);

				$sql = 'SELECT extension
					FROM ' . EXTENSIONS_TABLE . " 
					WHERE group_id = " . (int) $rows[$i]['group_id'] . " 
					ORDER BY extension ASC";

				if (!($result = $db->sql_query($sql))) 
				{ 
					trigger_error('Could not query Extensions.', E_USER_WARNING); 
				} 

				$e_rows = $db->sql_fetchrowset($result);
				$e_num_rows = $db->sql_numrows($result);
				$db->sql_freeresult($result);

				for ($j = 0; $j < $e_num_rows; $j++)
				{
					$template->assign_block_vars('group_row.extension_row', array(
						'EXTENSION' => $e_rows[$j]['extension'])
					);
				}
			}
		}

		if ($nothing)
		{
			$template->assign_block_vars('switch_nothing', array());
		}

		$page_title = '附件说明';

		page_header($page_title);

		$template->set_filenames(array(
			'body' => 'rules/rule_attach.tpl')
		);

		$template->assign_vars(array(
			'U_RULES' 		=> append_sid('rules.php'),
			'U_FAQ'			=> append_sid('rules.php?mode=faq'),
			'U_VIEWFORUM'	=> append_sid('viewforum.php?f=' . abs(intval($_GET[POST_FORUM_URL]))))
		);
		$template->pparse('body');
		
		page_footer();
	}
	else
	{
		trigger_error('没有这个论坛', E_USER_ERROR);
	}
}
else
{
	$viewcat = ( !empty($HTTP_GET_VARS[POST_CAT_URL]) ) ? $HTTP_GET_VARS[POST_CAT_URL] : -1;
	
	if( (!$board_config['index_spisok'] && !$userdata['session_logged_in']) || ($userdata['session_logged_in'] && !$userdata['user_index_spisok']) )
	{
		if ( $viewcat < 0 )
		{
			$viewcat = -2;
		}
	}
	
	$sql = 'SELECT * 
		FROM ' . FORUMS_TABLE . ' 
		ORDER BY forum_id';
	if (!$result = $db->sql_query($sql))
	{
		trigger_error('数据查询失败', E_USER_WARNING);
	}
	
	$forum_data = array();
	while( $row = $db->sql_fetchrow($result) )
	{
		$forum_data[] = $row;
	}
	
	require (ROOT_PATH . 'includes/attach/attachment_mod.php');
	
	$is_auth_ary = array();
	$is_auth_ary = auth(AUTH_ALL, AUTH_LIST_ALL, $userdata, $forum_data);
	
	// 取得论坛的分类
	$sql = 'SELECT cat_id, cat_title, cat_order, cat_icon
		FROM ' . CATEGORIES_TABLE . '
		ORDER BY cat_order';	
	if( !($result = $db->sql_query($sql)) )
	{
		trigger_error('Could not query categories list', E_USER_WARNING);
	}
	$category_rows = array();
	while ($row = $db->sql_fetchrow($result))
	{
		$category_rows[] = $row;
	}
	
	$db->sql_freeresult($result);
	$total_categories = count($category_rows);

	$sql = 'SELECT forum_id, forum_name, forum_icon, cat_id
		FROM ' . FORUMS_TABLE . '
		ORDER BY cat_id, forum_order';
		
	if ( !($result = $db->sql_query($sql)) )
	{
		trigger_error('Could not query forums information', E_USER_WARNING);
	}

	$forum_data = array();
	while( $row = $db->sql_fetchrow($result) )
	{
		$forum_data[] = $row;
	}
	$db->sql_freeresult($result);

	$total_forums = count($forum_data);
	
	$display_categories = array();

	for ($i = 0; $i < $total_forums; $i++ )
	{
		if ($is_auth_ary[$forum_data[$i]['forum_id']]['auth_view'])
		{
			$display_categories[$forum_data[$i]['cat_id']] = true;
		}
	}

	for($i = 0; $i < $total_categories; $i++)
	{
		$cat_id = $category_rows[$i]['cat_id'];

		if (isset($display_categories[$cat_id]) && $display_categories[$cat_id])
		{
			if ($category_rows[$i]['cat_icon'] != '')
			{
				$c_icon = '&nbsp;<img src="' . $category_rows[$i]['cat_icon'] . '"/>&nbsp;';
			}
			else 
			{
				$c_icon = '';
			}
			$template->assign_block_vars('catrow', array(
				'CAT_DESC' 		=> $category_rows[$i]['cat_title'],
				'CAT_ICON' 		=> $c_icon,
				'U_VIEWCAT' 	=> append_sid('rules.php?mode=faq&amp;act=attach&amp;' . POST_CAT_URL . '=' . $cat_id))
			);

			if ( $viewcat == $cat_id || $viewcat == -1 )
			{
				for($j = 0; $j < $total_forums; $j++)
				{
					if ( $forum_data[$j]['cat_id'] == $cat_id )
					{
						$forum_id = $forum_data[$j]['forum_id'];

						if ( $is_auth_ary[$forum_id]['auth_view'] )
						{
							
							if ($forum_data[$j]['forum_icon'] != '')
							{
								$f_icon = '&nbsp;<img src="'.$forum_data[$j]['forum_icon'].'">&nbsp;';
							}
							else 
							{
								$f_icon = '';	
							}
							$template->assign_block_vars('catrow.forumrow',	array(
								'FORUM_ICON' 	=> $f_icon,
								'FORUM_NAME' 	=> $forum_data[$j]['forum_name'],
								'U_VIEWFORUM' 	=> append_sid('rules.php?mode=faq&amp;act=attach&amp;' . POST_FORUM_URL . '=' . $forum_id))
							);
						}
					}
				}
			}
		}
	}
	
	$page_title = '论坛列表';
	
	page_header($page_title);
	
	$template->set_filenames(array(
		'body' => 'rules/faq_attach_forums.tpl')
	);
	
	$template->assign_vars(array(
		'U_RULES' 		=> append_sid('rules.php'),
		'U_FAQ'			=> append_sid('rules.php?mode=faq'))
	);
	
	$template->pparse('body');
	
	page_footer();
}
?>