<?php
/**
* @package phpBB-WAP
* @copyright (c) phpBB Group
* @Оптимизация под WAP: Гутник Игорь ( чел ).
* @简体中文：中文phpBB-WAP团队
* @license http://opensource.org/licenses/gpl-license.php
**/

/**
* 这是一款自由软件, 您可以在 Free Software Foundation 发布的
* GNU General Public License 的条款下重新发布或修改; 您可以
* 选择目前 version 2 这个版本（亦可以选择任何更新的版本，由
* 你喜欢）作为新的牌照.
**/

if ( !defined('IN_PHPBB') )
{
	die("Hacking attempt");
}
$cat = '';
if( $rule_cat_id )
{
	$sql = 'SELECT * 
		FROM ' . RULES_CAT_TABLE . ' 
		WHERE cat_r_id = ' . $rule_cat_id;
	if( !($result = $db->sql_query($sql)) )
	{
		trigger_error('Could not obtain rules information.', E_USER_WARNING);
	}
	$cat = $db->sql_fetchrow($result);

	$sql = 'SELECT * 
		FROM ' . RULES_TABLE . ' 
		WHERE rule_cat_id = ' . $rule_cat_id . ' 
		ORDER BY rule_id';
	if( !($result = $db->sql_query($sql)) )
	{
		trigger_error('Could not obtain rules information.', E_USER_WARNING);
	}

	$rulesrow = array();
	while ($row = $db->sql_fetchrow($result))
	{
		$rulesrow[] = $row;
	}

	for($i=0; $i < count($rulesrow); $i++)
	{
		$row_class = ( !($i % 2) ) ? 'row1' : 'row2';
		$rule_subject = str_replace("\n", "\n<br/>\n", $rulesrow[$i]['rule_subj']);
		$edit_rule = $delete = '';
		if ( $is_rules_auth )
		{
			$edit_rule = '【<a href="' . append_sid("rules.php?mode=editrule&amp;r=" . $rulesrow[$i]['rule_id']) . '">编辑</a> / ';
			$delete = '<a href="' . append_sid("rules.php?mode=delrule&amp;r=" . $rulesrow[$i]['rule_id']) . '">删除</a>】';
		}
		

		
		$template->assign_block_vars('rulesrow', array(
			'ROW_CLASS'			=> $row_class,
			'RULE_MOD' 			=> ( ($rulesrow[$i]['rule_moder'] == 1) && $is_rules_auth ) ? '(MOD)' : '',
			'RULE_NAME' 		=> $rulesrow[$i]['rule_name'],
			'RULE_EDIT' 		=> $edit_rule,
			'RULE_DELETE' 		=> $delete,
			'RULE_SUBJ' 		=> $rule_subject)
		);
	}
	$template->assign_block_vars('is_rules_body', array());
}
else
{
	$template->assign_block_vars('is_body', array());
}

$sql = 'SELECT * 
	FROM ' . RULES_CAT_TABLE . '
	ORDER BY cat_r_id';
	
if( !($result = $db->sql_query($sql)) )
{
	trigger_error('Could not obtain category rules information.', E_USER_WARNING);
}

$total_other_rule = $db->sql_numrows($result);

$other_rule = array();

while ($row = $db->sql_fetchrow($result))
{
	$other_rule[] = $row;
}

for($i = 0; $i < $total_other_rule; $i++)
{
	$edit_rule = $delete_rule = '';
	if( $is_rules_auth )
	{
		$edit_rule = '【<a href="'.append_sid("rules.php?mode=editcat&amp;crid=" . $other_rule[$i]['cat_r_id']) . '">编辑</a> / ';
		$delete_rule = '<a href="' . append_sid("rules.php?mode=delcat&amp;crid=" . $other_rule[$i]['cat_r_id']) . '">删除</a>】';
	}
	$row_class = ( !($i % 2) ) ? 'row1' : 'row2';
	$template->assign_block_vars('other_rule', array(
		'CLASS'					=> $row_class,
		'RULE_CAT' 				=> $other_rule[$i]['cat_r_name'],
		'U_RULE'				=> append_sid("rules.php?crid=" . $other_rule[$i]['cat_r_id']),
		'EDIT_RULE'				=> $edit_rule,
		'DELETE_RULE'			=> $delete_rule)
	);
}

$u_add_rule_cat = $u_add_rule = '';

if( $is_rules_auth )
{
	$template->assign_block_vars('rule_cat_auth', array());
	$u_add_rule_cat = append_sid('rules.php?mode=addcat');
	if( $cat )
	{
		$template->assign_block_vars('rule_auth', array());
		$u_add_rule = append_sid('rules.php?mode=addrule&amp;crid=' . $cat['cat_r_id']);
	}
}

page_header('规则');

$template->set_filenames(array(
	'body' => 'rules/index_body.tpl')
);

$template->assign_vars(array(
	'CAT_RULES' 		=> ( $cat ) ? $cat['cat_r_name'] : '',
	'U_FAQ_RULES'		=> append_sid("rules.php?mode=faq"),
	'U_SMILES_RULES'	=> append_sid("rules.php?mode=smiles"),
	'U_ADD_RULE_CAT' 	=> $u_add_rule_cat,
	'U_ADD_RULE' 		=> $u_add_rule)
);

$template->pparse('body');
page_footer();
?>