
--
-- 数据库: `zhangyun`
--

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_album`
--

CREATE TABLE IF NOT EXISTS `phpbb_album` (
  `pic_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pic_filename` varchar(255) NOT NULL,
  `pic_thumbnail` varchar(255) DEFAULT NULL,
  `pic_title` varchar(255) NOT NULL,
  `pic_desc` text,
  `pic_user_id` mediumint(8) NOT NULL,
  `pic_username` varchar(32) DEFAULT NULL,
  `pic_user_ip` char(8) NOT NULL DEFAULT '0',
  `pic_time` int(11) unsigned NOT NULL,
  `pic_cat_id` mediumint(8) unsigned NOT NULL DEFAULT '1',
  `pic_view_count` int(11) unsigned NOT NULL DEFAULT '0',
  `pic_lock` tinyint(3) NOT NULL DEFAULT '0',
  `pic_approval` tinyint(3) NOT NULL DEFAULT '1',
  PRIMARY KEY (`pic_id`),
  KEY `pic_cat_id` (`pic_cat_id`),
  KEY `pic_user_id` (`pic_user_id`),
  KEY `pic_time` (`pic_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- 转存表中的数据 `phpbb_album`
--

INSERT INTO `phpbb_album` (`pic_id`, `pic_filename`, `pic_thumbnail`, `pic_title`, `pic_desc`, `pic_user_id`, `pic_username`, `pic_user_ip`, `pic_time`, `pic_cat_id`, `pic_view_count`, `pic_lock`, `pic_approval`) VALUES
(4, '9569ecf3a99366881d8774c4496d1004.jpg', '', '萌不？', '', 2, 'Crazy', '714d2906', 1402376488, 2, 813, 0, 1),
(3, 'ab357bca845f23f07c3c578596f033ca.jpg', '', '网络最红双胞胎小萝莉秒杀众宅男', '', 2, 'Crazy', '714d2906', 1402376383, 1, 827, 0, 1),
(5, 'afcfedf7a53859c504e894c0b779b2c2.jpg', '', '花', '', 2, 'Crazy', '714d2906', 1402376614, 3, 1293, 0, 1),
(6, 'b8a30804491609d2eb617af9777070ee.jpg', '', '唯美', '', 2, 'Crazy', '77903fa2', 1402583969, 1, 481, 0, 1),
(7, 'eecf501c1ab4654bc57f40ca1459225a.jpg', '', '小妹妹', '', 2, 'Crazy', '77903fa2', 1402583995, 1, 482, 0, 1);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_album_cat`
--

CREATE TABLE IF NOT EXISTS `phpbb_album_cat` (
  `cat_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `cat_title` varchar(255) NOT NULL,
  `cat_desc` text,
  `cat_order` mediumint(8) NOT NULL,
  `cat_view_level` tinyint(3) NOT NULL DEFAULT '-1',
  `cat_upload_level` tinyint(3) NOT NULL DEFAULT '0',
  `cat_rate_level` tinyint(3) NOT NULL DEFAULT '0',
  `cat_comment_level` tinyint(3) NOT NULL DEFAULT '0',
  `cat_edit_level` tinyint(3) NOT NULL DEFAULT '0',
  `cat_delete_level` tinyint(3) NOT NULL DEFAULT '2',
  `cat_view_groups` varchar(255) DEFAULT NULL,
  `cat_upload_groups` varchar(255) DEFAULT NULL,
  `cat_rate_groups` varchar(255) DEFAULT NULL,
  `cat_comment_groups` varchar(255) DEFAULT NULL,
  `cat_edit_groups` varchar(255) DEFAULT NULL,
  `cat_delete_groups` varchar(255) DEFAULT NULL,
  `cat_moderator_groups` varchar(255) DEFAULT NULL,
  `cat_approval` tinyint(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cat_id`),
  KEY `cat_order` (`cat_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- 转存表中的数据 `phpbb_album_cat`
--

INSERT INTO `phpbb_album_cat` (`cat_id`, `cat_title`, `cat_desc`, `cat_order`, `cat_view_level`, `cat_upload_level`, `cat_rate_level`, `cat_comment_level`, `cat_edit_level`, `cat_delete_level`, `cat_view_groups`, `cat_upload_groups`, `cat_rate_groups`, `cat_comment_groups`, `cat_edit_groups`, `cat_delete_groups`, `cat_moderator_groups`, `cat_approval`) VALUES
(1, '人物', '明星、美女、帅哥', 10, -1, 0, 0, 0, 0, 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
(2, '动物', '猫、狗、鸡、鸭、鹅等等', 20, -1, 0, 0, 0, 0, 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
(3, '静物', '汽车、风景、物品、书画之类的', 30, -1, 0, 0, 0, 0, 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0),
(4, '综合', '神马都有', 40, -1, 0, 0, 0, 0, 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_album_comment`
--

CREATE TABLE IF NOT EXISTS `phpbb_album_comment` (
  `comment_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `comment_pic_id` int(11) unsigned NOT NULL,
  `comment_user_id` mediumint(8) NOT NULL,
  `comment_username` varchar(32) DEFAULT NULL,
  `comment_user_ip` char(8) NOT NULL,
  `comment_time` int(11) unsigned NOT NULL,
  `comment_text` text,
  `comment_edit_time` int(11) unsigned DEFAULT NULL,
  `comment_edit_count` smallint(5) unsigned NOT NULL DEFAULT '0',
  `comment_edit_user_id` mediumint(8) DEFAULT NULL,
  PRIMARY KEY (`comment_id`),
  KEY `comment_pic_id` (`comment_pic_id`),
  KEY `comment_user_id` (`comment_user_id`),
  KEY `comment_user_ip` (`comment_user_ip`),
  KEY `comment_time` (`comment_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_album_config`
--

CREATE TABLE IF NOT EXISTS `phpbb_album_config` (
  `config_name` varchar(255) NOT NULL,
  `config_value` varchar(255) NOT NULL,
  PRIMARY KEY (`config_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `phpbb_album_config`
--

INSERT INTO `phpbb_album_config` (`config_name`, `config_value`) VALUES
('max_pics', '-1'),
('user_pics_limit', '50'),
('mod_pics_limit', '-1'),
('max_file_size', '1024000'),
('max_width', '1200'),
('max_height', '1200'),
('rows_per_page', '3'),
('cols_per_page', '1'),
('fullpic_popup', '1'),
('thumbnail_quality', '100'),
('thumbnail_size', '125'),
('thumbnail_cache', '0'),
('sort_method', 'pic_time'),
('sort_order', 'DESC'),
('jpg_allowed', '1'),
('png_allowed', '1'),
('gif_allowed', '1'),
('desc_length', '512'),
('hotlink_prevent', '0'),
('hotlink_allowed', 'smartor.is-root.com'),
('personal_gallery', '0'),
('personal_gallery_private', '0'),
('personal_gallery_limit', '10'),
('personal_gallery_view', '-1'),
('rate', '1'),
('rate_scale', '10'),
('comment', '1'),
('gd_version', '2'),
('album_version', '.0.54');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_album_rate`
--

CREATE TABLE IF NOT EXISTS `phpbb_album_rate` (
  `rate_pic_id` int(11) unsigned NOT NULL,
  `rate_user_id` mediumint(8) NOT NULL,
  `rate_user_ip` char(8) NOT NULL,
  `rate_point` tinyint(3) unsigned NOT NULL,
  KEY `rate_pic_id` (`rate_pic_id`),
  KEY `rate_user_id` (`rate_user_id`),
  KEY `rate_user_ip` (`rate_user_ip`),
  KEY `rate_point` (`rate_point`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_articles`
--

CREATE TABLE IF NOT EXISTS `phpbb_articles` (
  `article_id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `article_class` mediumint(8) NOT NULL,
  `article_title` varchar(255) NOT NULL,
  `article_poster` mediumint(8) NOT NULL,
  `article_time` int(11) NOT NULL DEFAULT '0',
  `article_views` int(11) NOT NULL DEFAULT '0',
  `article_approval` tinyint(1) NOT NULL DEFAULT '0',
  `article_text` text NOT NULL,
  PRIMARY KEY (`article_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- 转存表中的数据 `phpbb_articles`
--

INSERT INTO `phpbb_articles` (`article_id`, `article_class`, `article_title`, `article_poster`, `article_time`, `article_views`, `article_approval`, `article_text`) VALUES
(1, 2, '一个捡破烂的妇女', 888, 1397644217, 49, 1, '一天中午，一个捡破烂的妇女，把捡来的破烂物品送到废品收购站卖掉后，骑着三轮车往回走，经过一条无人的小巷时，从小巷的拐角处，猛地窜出一个歹徒来。这歹徒手里拿着一把刀，他用刀抵住妇女的胸部，凶狠的命令妇女将身上的钱全部交出来。妇女吓傻了，站在那儿一动不动。 \r\n歹徒便开始搜身，他从妇女的衣袋里搜出一个塑料袋，塑料袋里包着一沓钞票。 \r\n\r\n歹徒拿着那沓钞票，转身就走。这时，那位妇女反应过来，立即扑上前去，劈手夺下了塑料袋。歹徒用刀对着妇女，作势要捅她，威胁她放手。妇女却双手紧紧地攥住盛钱的袋子，死活不松手。 \r\n\r\n妇女一面死死的护住袋子，一面拼命呼救，呼救声惊动了小巷子里的居民，人们闻声赶来，合力逮住了歹徒。 \r\n\r\n众人押着歹徒搀着妇女走进了附近的派出所，一位民警接待了他们。审讯时，歹徒对抢劫一事供认不讳。而那位妇女站在那儿直打哆嗦，脸上冷汗直冒。民警便安慰她：“你不必害怕。”妇女回答说：“我好疼，我的手指被他掰断了。”说着抬起右手，人们这才发现，她右手的食指软绵绵的耷拉着。 \r\n\r\n宁可手指被掰断也不松手放掉钱袋子，可见那钱袋的数目和分量。民警便打开那包着钞票的塑料袋，顿时，在场的人都惊呆了，那袋子里总共只有8块5毛钱，全是一毛和两毛的零钞。 \r\n\r\n为8块5毛钱，一个断了手指，一个沦为罪犯，真是太不值得了。一时，小城哗然。 \r\n\r\n民警迷惘了：是什么力量在支撑着这位妇女，使她能在折断手指的剧痛中仍不放弃这区区的8块5毛钱呢？他决定探个究竟。所以，将妇女送进医院治疗以后，他就尾随在妇女的身后，以期找到问题的答案。 \r\n\r\n但令人惊讶的是，妇女走出医院大门不久，就在一个水果摊儿上挑起了水果，而且挑得那么认真。她用8块5毛钱买了一个梨子、一个苹果、一个橘子、一个香蕉、一节甘蔗、一枚草莓，凡是水果摊儿上有的水果，她每样都挑一个，直到将8块5毛钱花得一分不剩。 \r\n\r\n民警吃惊地张大了嘴巴。难道不惜牺牲一根手指才保住的8块5毛钱，竟是为了买一点水果尝尝？ \r\n\r\n妇女提了一袋子水果，径直出了城，来到郊外的公墓。民警发现，妇女走到一个僻静处，那里有一座新墓。妇女在新墓前伫立良久，脸上似乎有了欣慰的笑意。然后她将袋子倚着墓碑，喃喃自语：“儿啊，妈妈对不起你。妈没本事，没办法治好你的病，竟让你刚13岁时就早早地离开了人世。还记得吗？你临去的时候，妈问你最大的心愿是什么，你说：我从来没吃过完好的水果，要是能吃一个好水果该多好呀。妈愧对你呀，竟连你最后的愿望都不能满足，为了给你治病，家里已经连买一个水果的钱都没有了。可是，孩子，到昨天，妈妈终于将为你治病借下的债都还清了。妈今天又挣了8块5毛钱，孩子，妈可以买到水果了，你看，有橘子、有梨、有苹果，还有香蕉......都是好的。都是妈花钱给你买的完好的水果，一点都没烂，妈一个一个仔细挑过的，你吃吧，孩子，你尝尝吧......”'),
(2, 1, '心的距离', 888, 1402239255, 30, 1, '心，与花的距离，在于欣赏，在于懂得；心，与世界的距离，在于容纳，在于敬畏；心，与心的距离，在于理解，在于真诚。水，本清澈，无念；人，本善良，无为；心，本质洁，无心。——巴山夜雨\n\n生活中，有时候无道理可言。\n\n明明尽了力，眨眼间却烟消云散，让人哭笑不得；明明尽了心，生活却视而不见，让人苦涩难耐；明明属于自己，转瞬间却物是人非，让人欲哭无泪。生活，不需要太多的解释，太多的纠缠，太多的不舍。\n\n拥有一方纯净的天空，一份飞翔的心情，一生无悔！\n\n生活中，有一种无言的爱，叫自爱。\n\n它，是一条静静的溪流，不需要别人懂得，是独自的流淌；它，是一曲曼妙的音乐，不需要刻意雕饰，是独自的聆听；它，是一朵清丽的闲花，不需要所谓的追逐，所谓的奢望，是独自的微笑，独自的世界。其实，每个人的心里，都有一片属于自己的原野，尽管有时贫瘠，却充实；尽管有时简单，却幸福。\n\n生活中，有一些情怀，只有经历才会深深懂得。\n\n最难走的是路，遥远而疲惫，许是因为没有方向，没有自我；最难懂的是心，时而清晰，时而模糊，许是因为太多烦扰，太多追求；最难舍的是自己，忘不了，也丢不下，因为已经成为习惯，成为生命。在美丽的风景中，纯澈自己；在奔波的忙碌中，实现自己；在无憾的岁月里，懂得自己。\n\n人生，就是在经历中懂得，在懂得中经历！\n\n其实，每个人的心里，都有一本书。\n\n独自的时候，总想翻开，因为那些地方，那些人，那些事；疲惫的时候，总想触摸，因为能给人生活的力量，给人活下去的勇气；想起的时候，总是难以释怀，因为只有自己懂得，自己最明白。这本书，就像洋葱，一层一层的剥开，总让人流泪；这本书，就像首歌，一遍一遍的唱着，总是忘记了时间，忘记了自我；这本书，只是书，也许只有尘封，才可永远！\n\n其实，每个人的心里，都有一道伤口，想起来就会痛。\n\n伤口，是时间的印痕，疼在记忆里，也疼在心里；伤口，是斑驳的思绪，有泪的苦涩，有心的迷离；伤口，是一首难言的旋律，不需多说，更不需解释，只有自己最清晰。不提及，是已经封存已经放弃；不修葺，是怕新的伤口，新的记忆。有时候，我们只能用伤痛来治愈伤痛，用时间来慢慢治愈自己。\n\n其实，每个人，也总有睡不着的时候。\n\n不是不想睡，而是有太多的放不下，太多的纠缠；不是不累，而是有太多的苦楚，太多的负累。心不静，则意乱，意乱，则神迷。清水无忧，皆因随性；落叶无憾，只因心空。放下所有的所有，阅一卷书，听一首曲，饮一盏茶，夜来赏夜，风来临风，梦来即梦。\n\n人生，有时就在半梦半醒之间！\n\n做人，不仅要阳光，要自信，更要有一个平和的心态。做一个清澈的人，一个善良的人，一个坦坦荡荡的人！守住一颗心，学会爱惜自己，学会珍惜生活，学会用爱来爱，就是最美！\n\n心，与花的距离，在于欣赏，在于懂得；心，与世界的距离，在于容纳，在于敬畏；心，与心的距离，在于理解，在于真诚。水，本清澈，无念；人，本善良，无为；心，本质洁，无心。——巴山夜雨\n\n生活中，有时候无道理可言。\n\n明明尽了力，眨眼间却烟消云散，让人哭笑不得；明明尽了心，生活却视而不见，让人苦涩难耐；明明属于自己，转瞬间却物是人非，让人欲哭无泪。生活，不需要太多的解释，太多的纠缠，太多的不舍。\n\n拥有一方纯净的天空，一份飞翔的心情，一生无悔！\n\n生活中，有一种无言的爱，叫自爱。\n\n它，是一条静静的溪流，不需要别人懂得，是独自的流淌；它，是一曲曼妙的音乐，不需要刻意雕饰，是独自的聆听；它，是一朵清丽的闲花，不需要所谓的追逐，所谓的奢望，是独自的微笑，独自的世界。其实，每个人的心里，都有一片属于自己的原野，尽管有时贫瘠，却充实；尽管有时简单，却幸福。\n\n生活中，有一些情怀，只有经历才会深深懂得。\n\n最难走的是路，遥远而疲惫，许是因为没有方向，没有自我；最难懂的是心，时而清晰，时而模糊，许是因为太多烦扰，太多追求；最难舍的是自己，忘不了，也丢不下，因为已经成为习惯，成为生命。在美丽的风景中，纯澈自己；在奔波的忙碌中，实现自己；在无憾的岁月里，懂得自己。\n\n人生，就是在经历中懂得，在懂得中经历！\n\n其实，每个人的心里，都有一本书。\n\n独自的时候，总想翻开，因为那些地方，那些人，那些事；疲惫的时候，总想触摸，因为能给人生活的力量，给人活下去的勇气；想起的时候，总是难以释怀，因为只有自己懂得，自己最明白。这本书，就像洋葱，一层一层的剥开，总让人流泪；这本书，就像首歌，一遍一遍的唱着，总是忘记了时间，忘记了自我；这本书，只是书，也许只有尘封，才可永远！'),
(4, 1, '幸福啊，为什么总站在痛苦的尽头', 888, 1402246886, 27, 1, '痛苦的生活有时是一把双刃剑，并非百无一利，它也能教会我们用怎样的态度对待人生。网友康儿在QQ里对我回忆她曾经的苦难，说就像奶香里淡淡的咖啡的苦涩。听完他的讲述，我感觉往日的痛苦历练了康儿的灵魂，升华了她对幸福的感觉。     \n人人都想远离不幸，然而不幸会跟每个人打交道。痛苦总是难免的，然而上帝却跟康儿开了一个过了头的、让她无法接受的玩笑--------家是人的心灵温馨的港湾，她的家不仅让她感受不到温暖，反而渐渐地寒透了她天真烂漫的心。自记事以来，康儿就生活在父母无休止的争吵与打闹中，成了父母“战争”的牺牲品，几乎从不超过一个星期就会挨打一次，无论对错，也可以说是根本没有对错。她从心底深处厌倦这个家，却又无法摆脱这种生活。随着年龄的增长，他开始默默地在生与死之间做着抉择。19岁那年，考上大学的康儿由于父亲的反对不能继续去读书，逃离这个家的梦想破灭了，她坚定地选择了放弃生命。 \n绝望之中的康儿如临深渊，如履薄冰。人们悲观时往往低头看到无数的陷阱，纵身下去便是极乐世界，而坚强的康儿不屈的心依然在飞翔，总想找到哪怕一根救命稻草。就在康儿绝望地走出家门，在夜里寻找上帝的光明的时候，她没有遇到带她进入天堂的上帝，而是遇到了现在成为她老公的明。遇到明的时候是在深夜，明看到彷徨无助的康儿就搭讪宽慰，看到他眼中那份深切的关爱与疼惜，康儿的心又充满了光明。原来，爱情能熨平一切创伤，康儿感到了生命中围绕着玫瑰的馨香。无论在他面前开心地大笑还是伤心地落泪，无论是娓娓地倾诉还是专注地聆听，心情都是那样的放松。康儿坚定地选择了死的时候，是一丝的爱把死击了个粉碎。有希望的人会比绝望的人更加坚强，在与明分手的瞬间，康儿告诉自己，一定要活着，就算只为这一夜，就算只为他。风雨过后是彩虹，康儿成为了明美丽的新娘，她说她听到了自己心儿的歌唱。\n    生儿育女是自己生命的延续，应该是女人最伟大，最幸福的时刻。结婚不久，康儿为明孕育了新的生命。康儿说腹中的乖女儿常常默默地给她传递喜悦，像娇嫩的花蕾慢慢成长，等待绽放。喜悦之情，溢于言表。十月怀胎，就在康儿将要亲吻女儿的那一天，医院的误诊让孩子匆匆离开了这个世界。她用泪水这无声的语言为只来了这个世界一天的女儿饯行。 梦中女儿像天使一样地在花中飞舞，醒来飞舞的花像天使一样的女儿。 悲痛的心一直到康儿有了现在的聪明可爱的儿子才得以缓解。就在康儿沉浸在亲昵爱子的喜悦中的时候，却被公婆当成了家贼，于是被迫离开了公婆的家，抱着周岁的儿子整整流浪了7天！康儿自幼就渴求亲情，做事情始终抱着宽容和忍让的态度，回报她的竟是这样的结果。她对人间处处有真情产生了怀疑，为了儿子和老公，她告诉自己必须坚强地活下去。就这样，康儿一路走来，直到有了现在真正属于自己的家。 \n     在经历了许多的痛苦之后，康儿对幸福的理解更现实、更真切、更深邃了。 她说：“即便是苦难，那也是在你拥有了生命之后才能拥有的权利！平安， 原来才是人得到一切的根本！于是，我不再去记恨任何人，不再对过去的一切耿耿于怀！于是我成了今天最最快乐的我！无论是开心还是失意，我都能坦然面对。”\n    有了这份痛苦尽头才得来的幸福，康儿说她感激明，是他像磐石一样坚定的爱她、支持她、信任她，为她撑起了属于自己的一片蓝天。明是一个普普通通的石油工人，康儿说这她这就很知足了。幸福属于满足的人们，康儿说“平安就是福，加上快乐就是幸福。”  其实，康儿还应该感谢“勇气”二字，它是逆境中的光明。');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_articles_class`
--

CREATE TABLE IF NOT EXISTS `phpbb_articles_class` (
  `ac_id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `ac_name` varchar(255) NOT NULL,
  `ac_sort` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ac_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- 转存表中的数据 `phpbb_articles_class`
--

INSERT INTO `phpbb_articles_class` (`ac_id`, `ac_name`, `ac_sort`) VALUES
(1, '新闻', 0),
(2, '励志', 0),
(3, '日记', 0),
(10, '其它', 4);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_attachments`
--

CREATE TABLE IF NOT EXISTS `phpbb_attachments` (
  `attach_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `post_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `privmsgs_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_id_1` mediumint(8) NOT NULL,
  `user_id_2` mediumint(8) NOT NULL,
  KEY `attach_id_post_id` (`attach_id`,`post_id`),
  KEY `attach_id_privmsgs_id` (`attach_id`,`privmsgs_id`),
  KEY `post_id` (`post_id`),
  KEY `privmsgs_id` (`privmsgs_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_attachments_desc`
--

CREATE TABLE IF NOT EXISTS `phpbb_attachments_desc` (
  `attach_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `physical_filename` varchar(255) NOT NULL,
  `real_filename` varchar(255) NOT NULL,
  `download_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `comment` varchar(255) DEFAULT NULL,
  `extension` varchar(100) DEFAULT NULL,
  `mimetype` varchar(100) DEFAULT NULL,
  `filesize` int(20) NOT NULL,
  `filetime` int(11) NOT NULL DEFAULT '0',
  `thumbnail` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`attach_id`),
  KEY `filetime` (`filetime`),
  KEY `physical_filename` (`physical_filename`(10)),
  KEY `filesize` (`filesize`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=29 ;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_attach_quota`
--

CREATE TABLE IF NOT EXISTS `phpbb_attach_quota` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `group_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `quota_type` smallint(2) NOT NULL DEFAULT '0',
  `quota_limit_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  KEY `quota_type` (`quota_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `phpbb_attach_quota`
--

INSERT INTO `phpbb_attach_quota` (`user_id`, `group_id`, `quota_type`, `quota_limit_id`) VALUES
(2, 0, 1, 3);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_auth_access`
--

CREATE TABLE IF NOT EXISTS `phpbb_auth_access` (
  `group_id` mediumint(8) NOT NULL DEFAULT '0',
  `forum_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `auth_view` tinyint(1) NOT NULL DEFAULT '0',
  `auth_read` tinyint(1) NOT NULL DEFAULT '0',
  `auth_post` tinyint(1) NOT NULL DEFAULT '0',
  `auth_reply` tinyint(1) NOT NULL DEFAULT '0',
  `auth_edit` tinyint(1) NOT NULL DEFAULT '0',
  `auth_delete` tinyint(1) NOT NULL DEFAULT '0',
  `auth_sticky` tinyint(1) NOT NULL DEFAULT '0',
  `auth_announce` tinyint(1) NOT NULL DEFAULT '0',
  `auth_marrow` tinyint(1) NOT NULL DEFAULT '0',
  `auth_vote` tinyint(1) NOT NULL DEFAULT '0',
  `auth_pollcreate` tinyint(1) NOT NULL DEFAULT '0',
  `auth_attachments` tinyint(1) NOT NULL DEFAULT '0',
  `auth_mod` tinyint(1) NOT NULL DEFAULT '0',
  `auth_download` tinyint(1) NOT NULL DEFAULT '0',
  KEY `group_id` (`group_id`),
  KEY `forum_id` (`forum_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_bank`
--

CREATE TABLE IF NOT EXISTS `phpbb_bank` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) NOT NULL,
  `holding` int(10) unsigned DEFAULT '0',
  `totalwithdrew` int(10) unsigned DEFAULT '0',
  `totaldeposit` int(10) unsigned DEFAULT '0',
  `opentime` int(10) unsigned NOT NULL,
  `fees` char(5) NOT NULL DEFAULT 'on',
  PRIMARY KEY (`user_id`),
  KEY `id` (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_bank_config`
--

CREATE TABLE IF NOT EXISTS `phpbb_bank_config` (
  `config_name` varchar(255) NOT NULL,
  `config_value` varchar(255) NOT NULL,
  PRIMARY KEY (`config_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `phpbb_bank_config`
--

INSERT INTO `phpbb_bank_config` (`config_name`, `config_value`) VALUES
('bankinterest', '2'),
('bankfees', '2'),
('bankpayouttime', '86400'),
('bankname', '虚拟银行'),
('bankopened', 'on'),
('bankholdings', '0'),
('banktotaldeposits', '0'),
('banktotalwithdrew', '0'),
('banklastrestocked', '1402743276'),
('bank_minwithdraw', '0'),
('bank_mindeposit', '0'),
('bank_interestcut', '0');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_banlist`
--

CREATE TABLE IF NOT EXISTS `phpbb_banlist` (
  `ban_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `ban_userid` mediumint(8) NOT NULL,
  `ban_ip` char(8) NOT NULL,
  `ban_email` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ban_id`),
  KEY `ban_ip_user_id` (`ban_ip`,`ban_userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_categories`
--

CREATE TABLE IF NOT EXISTS `phpbb_categories` (
  `cat_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `cat_title` varchar(100) DEFAULT NULL,
  `cat_icon` varchar(100) DEFAULT NULL,
  `cat_order` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`cat_id`),
  KEY `cat_order` (`cat_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- 转存表中的数据 `phpbb_categories`
--

INSERT INTO `phpbb_categories` (`cat_id`, `cat_title`, `cat_icon`, `cat_order`) VALUES
(1, '技术专区', '', 10),
(2, '休闲娱乐', '', 20),
(3, '站内事务', '', 30);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_class`
--

CREATE TABLE IF NOT EXISTS `phpbb_class` (
  `class_id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(25) NOT NULL,
  `class_forum` mediumint(8) NOT NULL,
  PRIMARY KEY (`class_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- 转存表中的数据 `phpbb_class`
--

INSERT INTO `phpbb_class` (`class_id`, `class_name`, `class_forum`) VALUES
(1, '精品应用', 1),
(2, '每日推荐', 1),
(3, '精品应用', 2),
(4, '每日推荐', 2),
(5, '编程工具', 3),
(6, '每日推荐', 3),
(7, '每日推荐', 5);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_config`
--

CREATE TABLE IF NOT EXISTS `phpbb_config` (
  `config_name` varchar(255) NOT NULL,
  `config_value` varchar(255) NOT NULL,
  PRIMARY KEY (`config_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `phpbb_config`
--

INSERT INTO `phpbb_config` (`config_name`, `config_value`) VALUES
('config_id', '1'),
('board_disable', '0'),
('sitename', '掌云社区'),
('site_desc', '掌云社区是一个注重于编程技术的WAP交流平台,其内容涵盖编程技术交流,电脑技术交流,手机技术交流,文学交流'),
('cookie_name', 'phpbb2mysql'),
('cookie_path', '/'),
('cookie_domain', ''),
('cookie_secure', '0'),
('session_length', '3600'),
('allow_html', '0'),
('allow_html_tags', 'b,i,u,pre'),
('allow_bbcode', '1'),
('allow_smilies', '1'),
('allow_sig', '1'),
('allow_namechange', '1'),
('allow_theme_create', '0'),
('allow_avatar_remote', '1'),
('allow_avatar_upload', '1'),
('enable_confirm', '1'),
('allow_autologin', '1'),
('max_autologin_time', '0'),
('posts_per_page', '15'),
('topics_per_page', '15'),
('max_poll_options', '10'),
('max_sig_chars', '255'),
('max_inbox_privmsgs', '50'),
('max_sentbox_privmsgs', '25'),
('max_savebox_privmsgs', '50'),
('board_email_sig', '这是一封来自掌云网的邮件，请不要回复此邮件'),
('board_email', ''),
('smtp_delivery', '1'),
('smtp_host', ''),
('smtp_username', ''),
('smtp_password', ''),
('sendmail_fix', '0'),
('require_activation', '0'),
('flood_interval', '15'),
('search_flood_interval', '15'),
('search_min_chars', '3'),
('max_login_attempts', ''),
('login_reset_time', ''),
('board_email_form', '1'),
('avatar_filesize', '204800'),
('avatar_max_width', '80'),
('avatar_max_height', '80'),
('avatar_path', 'images/avatars'),
('smilies_path', 'images/smiles'),
('default_style', '1'),
('default_dateformat', 'Y年m月d日 H:i'),
('board_timezone', '0'),
('prune_enable', '1'),
('privmsg_disable', '0'),
('record_online_users', '0'),
('record_online_date', '0'),
('server_name', 'zhangyun.org'),
('server_port', '80'),
('script_path', '/'),
('version', '5.1'),
('rand_seed', '4d648bf70d0ad3526014fc5972d392c6'),
('online_time', '60'),
('max_user_topics_per_page', '50'),
('max_user_posts_per_page', '50'),
('birthday_greeting', '1'),
('max_user_age', '100'),
('min_user_age', '5'),
('birthday_check_day', '7'),
('index_announcement', ''),
('index_spisok', '1'),
('min_login_regdate', '0'),
('time_click', '100'),
('time_last_click', '0'),
('sites', '1'),
('posl_red', '1'),
('captcha_in_topic', '0'),
('max_smiles_in_message', '3'),
('message_quote', '1'),
('points_name', '金币'),
('beian_info', '京ICP备00000000'),
('guide_progress', '-1'),
('site_logo', 'logo.png'),
('open_rewrite', '0'),
('quick_answer', '1'),
('upload_dir', 'download'),
('upload_img', 'images/icons/topic/attachment.gif'),
('topic_icon', 'images/icons/topic/attachment.gif'),
('display_order', '1'),
('max_filesize', '20971520'),
('attachment_quota', '0'),
('max_attachments', '20'),
('max_attachments_pm', '3'),
('disable_mod', '0'),
('attachment_topic_review', '0'),
('allow_ftp_upload', '0'),
('show_apcp', '0'),
('default_upload_quota', '0'),
('default_pm_quota', '0'),
('ftp_server', ''),
('ftp_path', ''),
('ftp_user', ''),
('ftp_pass', ''),
('ftp_pasv_mode', '1'),
('img_display_inlined', '1'),
('img_max_width', '0'),
('img_max_height', '0'),
('img_link_width', '0'),
('img_link_height', '0'),
('img_create_thumbnail', '0'),
('img_min_thumb_filesize', '12000'),
('img_imagick', ''),
('use_gd2', '0'),
('wma_autoplay', '0'),
('flash_autoplay', '0'),
('download_cut_points', '1'),
('download_add_points', '1'),
('patch_version', '0'),
('display_login', '1'),
('use_tpl_css', '1'),
('board_startdate', '1402364852'),
('allow_guests_gb', '1'),
('gb_posts', '10'),
('gb_quick', '1');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_confirm`
--

CREATE TABLE IF NOT EXISTS `phpbb_confirm` (
  `confirm_id` char(32) NOT NULL DEFAULT '',
  `session_id` char(32) NOT NULL DEFAULT '',
  `code` char(6) NOT NULL DEFAULT '',
  PRIMARY KEY (`session_id`,`confirm_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `phpbb_confirm`
--

INSERT INTO `phpbb_confirm` (`confirm_id`, `session_id`, `code`) VALUES
('95877fb6c8a3180d8e906989956f04be', 'bb12b3ef15441946abc8f7939c7ab196', '80701');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_disallow`
--

CREATE TABLE IF NOT EXISTS `phpbb_disallow` (
  `disallow_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `disallow_username` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`disallow_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_extensions`
--

CREATE TABLE IF NOT EXISTS `phpbb_extensions` (
  `ext_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `extension` varchar(100) NOT NULL,
  `comment` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`ext_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=29 ;

--
-- 转存表中的数据 `phpbb_extensions`
--

INSERT INTO `phpbb_extensions` (`ext_id`, `group_id`, `extension`, `comment`) VALUES
(1, 1, 'gif', ''),
(2, 1, 'png', ''),
(3, 1, 'jpeg', ''),
(4, 1, 'jpg', ''),
(5, 1, 'tif', ''),
(6, 1, 'tga', ''),
(7, 2, 'gtar', ''),
(8, 2, 'gz', ''),
(9, 2, 'tar', ''),
(10, 2, 'zip', ''),
(11, 2, 'rar', ''),
(12, 2, 'ace', ''),
(13, 3, 'txt', ''),
(14, 3, 'c', ''),
(15, 3, 'h', ''),
(16, 3, 'cpp', ''),
(17, 3, 'hpp', ''),
(18, 3, 'diz', ''),
(19, 4, 'xls', ''),
(20, 4, 'doc', ''),
(21, 4, 'dot', ''),
(22, 4, 'pdf', ''),
(23, 4, 'ai', ''),
(24, 4, 'ps', ''),
(25, 4, 'ppt', ''),
(26, 5, 'rm', ''),
(27, 6, 'wma', ''),
(28, 7, 'swf', '');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_extension_groups`
--

CREATE TABLE IF NOT EXISTS `phpbb_extension_groups` (
  `group_id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `group_name` char(20) NOT NULL,
  `cat_id` tinyint(2) NOT NULL DEFAULT '0',
  `allow_group` tinyint(1) NOT NULL DEFAULT '0',
  `download_mode` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `upload_icon` varchar(100) DEFAULT '',
  `max_filesize` int(20) NOT NULL DEFAULT '0',
  `forum_permissions` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- 转存表中的数据 `phpbb_extension_groups`
--

INSERT INTO `phpbb_extension_groups` (`group_id`, `group_name`, `cat_id`, `allow_group`, `download_mode`, `upload_icon`, `max_filesize`, `forum_permissions`) VALUES
(1, '图像', 1, 1, 1, '', 0, ''),
(2, '文档', 0, 1, 1, '', 0, ''),
(3, '文本', 0, 1, 1, '', 0, ''),
(4, '文件', 0, 1, 1, '', 0, ''),
(5, '音频', 0, 1, 2, '', 0, ''),
(6, '流媒体', 1, 0, 1, '', 0, ''),
(7, 'Flash', 3, 1, 1, '', 0, '');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_forbidden_extensions`
--

CREATE TABLE IF NOT EXISTS `phpbb_forbidden_extensions` (
  `ext_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `extension` varchar(100) NOT NULL,
  PRIMARY KEY (`ext_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- 转存表中的数据 `phpbb_forbidden_extensions`
--

INSERT INTO `phpbb_forbidden_extensions` (`ext_id`, `extension`) VALUES
(2, 'php3'),
(3, 'php4'),
(4, 'phtml'),
(5, 'pl'),
(6, 'asp'),
(7, 'cgi'),
(8, 'php5'),
(9, 'php6');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_forums`
--

CREATE TABLE IF NOT EXISTS `phpbb_forums` (
  `forum_id` smallint(5) unsigned NOT NULL,
  `cat_id` mediumint(8) unsigned NOT NULL,
  `forum_name` varchar(150) DEFAULT NULL,
  `forum_desc` text,
  `forum_icon` varchar(100) DEFAULT NULL,
  `forum_status` tinyint(4) NOT NULL DEFAULT '0',
  `forum_order` mediumint(8) unsigned NOT NULL DEFAULT '1',
  `forum_posts` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `forum_postcount` tinyint(1) NOT NULL DEFAULT '1',
  `forum_topics` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `forum_last_post_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `prune_next` int(11) DEFAULT NULL,
  `prune_enable` tinyint(1) NOT NULL DEFAULT '0',
  `auth_view` tinyint(2) NOT NULL DEFAULT '0',
  `auth_read` tinyint(2) NOT NULL DEFAULT '0',
  `auth_post` tinyint(2) NOT NULL DEFAULT '0',
  `auth_reply` tinyint(2) NOT NULL DEFAULT '0',
  `auth_edit` tinyint(2) NOT NULL DEFAULT '0',
  `auth_delete` tinyint(2) NOT NULL DEFAULT '0',
  `auth_sticky` tinyint(2) NOT NULL DEFAULT '0',
  `auth_announce` tinyint(2) NOT NULL DEFAULT '0',
  `auth_marrow` tinyint(2) NOT NULL DEFAULT '0',
  `auth_vote` tinyint(2) NOT NULL DEFAULT '0',
  `auth_pollcreate` tinyint(2) NOT NULL DEFAULT '0',
  `auth_attachments` tinyint(2) NOT NULL DEFAULT '0',
  `auth_download` tinyint(2) NOT NULL DEFAULT '0',
  `forum_money` int(12) DEFAULT '0',
  PRIMARY KEY (`forum_id`),
  KEY `forums_order` (`forum_order`),
  KEY `cat_id` (`cat_id`),
  KEY `forum_last_post_id` (`forum_last_post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `phpbb_forums`
--

INSERT INTO `phpbb_forums` (`forum_id`, `cat_id`, `forum_name`, `forum_desc`, `forum_icon`, `forum_status`, `forum_order`, `forum_posts`, `forum_postcount`, `forum_topics`, `forum_last_post_id`, `prune_next`, `prune_enable`, `auth_view`, `auth_read`, `auth_post`, `auth_reply`, `auth_edit`, `auth_delete`, `auth_sticky`, `auth_announce`, `auth_marrow`, `auth_vote`, `auth_pollcreate`, `auth_attachments`, `auth_download`, `forum_money`) VALUES
(1, 1, '电脑交流', '', 'images/icons/forum/dn.png', 0, 10, 0, 1, 0, 0, NULL, 0, 0, 0, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 0, 0),
(2, 1, '手机交流', '', 'images/icons/forum/sj.png', 0, 20, 3, 1, 3, 63, NULL, 0, 0, 0, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 0),
(3, 1, '编程交流', '', 'images/icons/forum/bc.png', 0, 30, 0, 1, 0, 0, NULL, 0, 0, 0, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 0),
(4, 2, '灌水大本营', '', 'images/icons/forum/gs.png', 0, 10, 7, 1, 1, 19, NULL, 0, 0, 0, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 0),
(5, 2, '文学大比拼', '', 'images/icons/forum/wx.png', 0, 20, 3, 1, 1, 27, NULL, 0, 0, 0, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 0),
(6, 3, '投诉建议', '', 'images/icons/forum/jy.png', 0, 10, 0, 1, 0, 0, NULL, 0, 0, 0, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 0),
(7, 3, '职务申请', '', 'images/icons/forum/sq.png', 0, 20, 1, 1, 1, 5, NULL, 0, 0, 0, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 0),
(8, 3, '活动公告', '', 'images/icons/forum/gg.png', 0, 30, 0, 1, 0, 0, NULL, 0, 0, 0, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 0),
(9, 2, '图说天下', '', 'images/icons/forum/mt.png', 0, 30, 0, 1, 0, 0, NULL, 0, 0, 0, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 0),
(10, 2, '买卖交易', '', 'images/icons/forum/shop.png', 0, 40, 0, 1, 0, 0, NULL, 0, 0, 0, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 0),
(11, 1, '你问我答', '', 'images/icons/forum/wd.png', 0, 40, 0, 1, 0, 0, NULL, 0, 0, 0, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 0);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_forum_module`
--

CREATE TABLE IF NOT EXISTS `phpbb_forum_module` (
  `module_id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `module_forum` mediumint(8) NOT NULL,
  `module_top` text NOT NULL,
  `module_bottom` text NOT NULL,
  PRIMARY KEY (`module_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- 转存表中的数据 `phpbb_forum_module`
--

INSERT INTO `phpbb_forum_module` (`module_id`, `module_forum`, `module_top`, `module_bottom`) VALUES
(1, 1, '', '');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_forum_prune`
--

CREATE TABLE IF NOT EXISTS `phpbb_forum_prune` (
  `prune_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `forum_id` smallint(5) unsigned NOT NULL,
  `prune_days` smallint(5) unsigned NOT NULL,
  `prune_freq` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`prune_id`),
  KEY `forum_id` (`forum_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_friends`
--

CREATE TABLE IF NOT EXISTS `phpbb_friends` (
  `friend_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` mediumint(8) NOT NULL,
  `remark` varchar(25) NOT NULL,
  `ucp_id` mediumint(8) NOT NULL,
  PRIMARY KEY (`friend_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_groups`
--

CREATE TABLE IF NOT EXISTS `phpbb_groups` (
  `group_id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `group_type` tinyint(4) NOT NULL DEFAULT '1',
  `group_name` varchar(40) NOT NULL DEFAULT '',
  `group_description` varchar(255) NOT NULL,
  `group_moderator` mediumint(8) NOT NULL DEFAULT '0',
  `group_single_user` tinyint(1) NOT NULL DEFAULT '1',
  `guestbook_enable` tinyint(1) NOT NULL DEFAULT '1',
  `group_logo` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`group_id`),
  KEY `group_single_user` (`group_single_user`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- 转存表中的数据 `phpbb_groups`
--

INSERT INTO `phpbb_groups` (`group_id`, `group_type`, `group_name`, `group_description`, `group_moderator`, `group_single_user`, `guestbook_enable`, `group_logo`) VALUES
(1, 1, '匿名用户', 'Personal User', 0, 1, 1, ''),
(2, 1, '超级管理员', 'Personal User', 0, 1, 1, '');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_groups_guestbook`
--

CREATE TABLE IF NOT EXISTS `phpbb_groups_guestbook` (
  `gb_id` int(10) NOT NULL AUTO_INCREMENT,
  `group_id` int(10) NOT NULL DEFAULT '0',
  `poster_id` int(10) NOT NULL DEFAULT '0',
  `bbcode` varchar(64) NOT NULL DEFAULT '',
  `gb_time` int(10) NOT NULL DEFAULT '0',
  `message` text NOT NULL,
  PRIMARY KEY (`gb_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_guestbook`
--

CREATE TABLE IF NOT EXISTS `phpbb_guestbook` (
  `gb_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gb_time` int(11) unsigned NOT NULL DEFAULT '0',
  `gb_ip` char(8) NOT NULL DEFAULT '',
  `gb_username` varchar(255) NOT NULL DEFAULT '',
  `gb_password` varchar(32) NOT NULL DEFAULT '',
  `gb_title` varchar(255) NOT NULL DEFAULT '',
  `gb_text` text NOT NULL,
  `gb_reply` text NOT NULL,
  PRIMARY KEY (`gb_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_linkclass`
--

CREATE TABLE IF NOT EXISTS `phpbb_linkclass` (
  `linkclass_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `linkclass_name` varchar(255) NOT NULL,
  `linkclass_sort` int(8) unsigned NOT NULL DEFAULT '0',
  `linkclass_desc` text,
  PRIMARY KEY (`linkclass_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- 转存表中的数据 `phpbb_linkclass`
--

INSERT INTO `phpbb_linkclass` (`linkclass_id`, `linkclass_name`, `linkclass_sort`, `linkclass_desc`) VALUES
(1, '综合', 0, ''),
(2, '社区', 1, ''),
(3, '网址', 2, ''),
(4, '文学', 3, ''),
(5, '下载', 4, ''),
(6, '购物', 5, '');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_links`
--

CREATE TABLE IF NOT EXISTS `phpbb_links` (
  `link_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `link_class_id` mediumint(8) unsigned NOT NULL,
  `link_title` varchar(25) NOT NULL,
  `link_name` varchar(4) NOT NULL DEFAULT '',
  `link_url` varchar(255) NOT NULL,
  `link_desc` text,
  `link_join_time` int(11) unsigned NOT NULL DEFAULT '0',
  `link_last_visit` int(11) unsigned NOT NULL DEFAULT '0',
  `link_in` int(10) unsigned NOT NULL DEFAULT '0',
  `link_out` int(10) unsigned NOT NULL DEFAULT '0',
  `link_show` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `link_admin_user` mediumint(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`link_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- 转存表中的数据 `phpbb_links`
--

INSERT INTO `phpbb_links` (`link_id`, `link_class_id`, `link_title`, `link_name`, `link_url`, `link_desc`, `link_join_time`, `link_last_visit`, `link_in`, `link_out`, `link_show`, `link_admin_user`) VALUES
(1, 2, '颜兮之家', '颜兮', 'http://iyanxi.com/link/gourl.aspx?id=1000_372', 'QQ、刷钻、交友', 1402501876, 1402501876, 0, 7, 1, 1),
(2, 1, '百度', '百度', 'http://baidu.com', '百度', 1402502072, 1402502072, 0, 1, 1, 1),
(3, 1, '新浪网', '新浪', 'http://m.sina.com.cn', '', 1402502168, 1402502168, 0, 1, 1, 1),
(4, 3, '好123导航', '好网', 'http://wap.hao123.com', 'hao123网址导航', 1402502278, 1402502278, 0, 2, 1, 1),
(5, 1, '手机腾讯网', 'ＱＱ', 'http://3g.qq.com', '手机腾讯网', 1402502784, 1402502784, 0, 1, 1, 1);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_mods`
--

CREATE TABLE IF NOT EXISTS `phpbb_mods` (
  `mod_id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `mod_name` varchar(12) NOT NULL,
  `mod_dir` varchar(25) NOT NULL,
  `mod_desc` text NOT NULL,
  `mod_author` varchar(25) NOT NULL,
  `mod_support` varchar(255) NOT NULL,
  `mod_version` varchar(12) NOT NULL,
  `mod_show` int(1) NOT NULL DEFAULT '0',
  `mod_power` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`mod_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=20 ;

--
-- 转存表中的数据 `phpbb_mods`
--

INSERT INTO `phpbb_mods` (`mod_id`, `mod_name`, `mod_dir`, `mod_desc`, `mod_author`, `mod_support`, `mod_version`, `mod_show`, `mod_power`) VALUES
(15, 'QQ登录', 'qqlogin', ' 腾讯QQ互联登录功能', ' 爱疯的云', ' http://phpbb-wap.com/mod', ' v6.0', 0, 1),
(16, '专题调用插件', 'class_mbb', ' 专题调用插件', ' Crazy', ' http://zhangyun.org', ' v6.0', 0, 1),
(14, '聊天室', 'bbchat', ' phpbbb-wap聊天室插件', ' 爱疯的云', ' http://phpbb-wap.com', ' v6.0', 1, 1),
(4, '虚拟商店', 'shop', ' 系统虚拟商店', ' Crazy', ' http://phpbb-wap.com', ' v1.0', 1, 1),
(5, '签到插件', 'sign', ' 你多少天没签到了？', ' Crazy', ' http://phpbb-wap.com', ' v6.0', 1, 1),
(6, '挖豆', 'wadou', ' 资速网原挖豆插件', ' 熊大', ' http://zisuw.com', ' v6.0', 1, 1),
(7, '虚拟银行', 'bank', ' 系统虚拟银行', ' Crazy', ' http://phpbb-wap.com', ' v1.0', 1, 1),
(8, '金币管理', 'money_mod', ' 金币交易、管理发放工资、增删会员金币等', ' kill、Crazy', ' http://www.zisuw.com', ' v6.0', 1, 1),
(9, '虚拟商店', 'shop', ' 系统虚拟商店', ' Crazy', ' http://phpbb-wap.com', ' v1.0', 1, 1);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_modules`
--

CREATE TABLE IF NOT EXISTS `phpbb_modules` (
  `module_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module_title` varchar(255) NOT NULL DEFAULT '',
  `module_text` text NOT NULL,
  `module_param` varchar(255) NOT NULL DEFAULT '',
  `module_hide` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `module_br` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `module_type` tinyint(3) NOT NULL,
  `module_sort` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `module_page` mediumint(8) unsigned NOT NULL,
  `module_needle` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`module_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=26 ;

--
-- 转存表中的数据 `phpbb_modules`
--

INSERT INTO `phpbb_modules` (`module_id`, `module_title`, `module_text`, `module_param`, `module_hide`, `module_br`, `module_type`, `module_sort`, `module_page`, `module_needle`) VALUES
(1, '', '[html]\n&amp;lt;div class=&amp;quot;index-cat&amp;quot;&amp;gt;\n[显示底部广告]\n[/html]', '', 0, 0, -2, 0, 0, 0),
(2, '', '[html]\n&amp;lt;div class=&amp;quot;index-cat&amp;quot;&amp;gt;\n&amp;lt;div class=&amp;quot;left&amp;quot; style=&amp;quot;width:50%;&amp;quot;&amp;gt;&amp;lt;a href=&amp;quot;links.php&amp;quot;&amp;gt;友链&amp;lt;/a&amp;gt;&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;right center&amp;quot; style=&amp;quot;width:50%;&amp;quot;&amp;gt;&amp;lt;a href=&amp;quot;memberlist.php?admin&amp;quot;&amp;gt;团队&amp;lt;/a&amp;gt;.&amp;lt;a href=&amp;quot;guestbook.php&amp;quot;&amp;gt;留言&amp;lt;/a&amp;gt;.&amp;lt;a href=&amp;quot;index.php?page=12&amp;quot;&amp;gt;联系&amp;lt;/a&amp;gt;.&amp;lt;a href=&amp;quot;index.php?page=13&amp;quot;&amp;gt;关于&amp;lt;/a&amp;gt;&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;clear&amp;quot;&amp;gt;&amp;lt;/div&amp;gt;\n&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;clear&amp;quot;&amp;gt;&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;index-row&amp;quot;&amp;gt;\n&amp;lt;div class=&amp;quot;row1 square&amp;quot;&amp;gt;\n&amp;lt;a href=&amp;quot;http://9acl.com&amp;quot;&amp;gt;潮流&amp;lt;/a&amp;gt;\n&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;row2 square&amp;quot;&amp;gt;\n&amp;lt;a href=&amp;quot;http://wapnkw.com&amp;quot;&amp;gt;内库&amp;lt;/a&amp;gt;\n&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;row1 square&amp;quot;&amp;gt;\n&amp;lt;a href=&amp;quot;http://code.zhangyun.org&amp;quot;&amp;gt;代码&amp;lt;/a&amp;gt;\n&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;row2 square&amp;quot;&amp;gt;\n&amp;lt;a href=&amp;quot;http://sigxz.com&amp;quot;&amp;gt;时光&amp;lt;/a&amp;gt;\n&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;row1 square&amp;quot;&amp;gt;\n&amp;lt;a href=&amp;quot;#&amp;quot;&amp;gt;招固&amp;lt;/a&amp;gt;\n&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;clear&amp;quot;&amp;gt;&amp;lt;/div&amp;gt;\n&amp;lt;/div&amp;gt;\n[/html]', '', 0, 0, -3, 0, 0, 0),
(3, '', '[html]&amp;lt;img src=&amp;quot;[LOGO]&amp;quot; alt=&amp;quot;.&amp;quot; title=&amp;quot;Logo&amp;quot;/&amp;gt;\n[/html]', '', 0, 0, -1, 0, 0, 0),
(4, '', '[html]&amp;lt;div class=&amp;quot;index_bottom&amp;quot;&amp;gt;版权所有 (c) 掌云 2014&amp;lt;/div&amp;gt;&amp;lt;script type=&amp;quot;text/javascript&amp;quot; src=&amp;quot;http://tajs.qq.com/stats?sId=22841363&amp;quot; charset=&amp;quot;UTF-8&amp;quot;&amp;gt;&amp;lt;/script&amp;gt;\n[/html]', '', 0, 0, -4, 0, 0, 0),
(5, '', '[html]\n    &amp;lt;meta name=&amp;quot;author&amp;quot; content=&amp;quot;掌云社区 - 中国WAP编程社区 zhangyun.org&amp;quot; /&amp;gt;\n    &amp;lt;meta name=&amp;quot;keywords&amp;quot; content=&amp;quot;[网页标题]&amp;quot; /&amp;gt;\n   &amp;lt;meta name=&amp;quot;description&amp;quot; content=&amp;quot;掌云社区是一个注重于编程技术的WAP交流平台,其内容涵盖编程技术交流,电脑技术交流,手机技术交流,文学交流等&amp;quot; /&amp;gt;\n    &amp;lt;link rel=&amp;quot;shortcut icon&amp;quot; href=&amp;quot; /favicon.ico&amp;quot; /&amp;gt;\n   &amp;lt;meta name=&amp;quot;viewport&amp;quot; content=&amp;quot;width=device-width; initial-scale=1.0; minimum-scale=1.0; maximum-scale=2.0&amp;quot; /&amp;gt;\n    &amp;lt;meta name=&amp;quot;apple-mobile-web-app-capable&amp;quot; content=&amp;quot;yes&amp;quot; /&amp;gt;\n    &amp;lt;meta name=&amp;quot;apple-mobile-web-app-status-bar-style&amp;quot; content=&amp;quot;black&amp;quot; /&amp;gt;\n   &amp;lt;style type=&amp;quot;text/css&amp;quot;&amp;gt;\n   .square{width:20%;float: left;text-align: center;}\n    &amp;lt;/style&amp;gt;\n[/html]', '', 0, 0, -5, 0, 0, 0),
(24, '关于本站', '', '', 1, 0, 0, 99, 0, 13),
(6, '导航隐藏模块', '[html]&amp;lt;/div&amp;gt;[/html]', '1', 1, 0, 0, 1, 0, 1),
(7, '下载', '[html]&amp;lt;div class=&amp;quot;index_top&amp;quot;&amp;gt;\n&amp;lt;a href=&amp;quot;forum.php&amp;quot;&amp;gt;论坛&amp;lt;/a&amp;gt;\n&amp;lt;a href=&amp;quot;mods.php&amp;quot;&amp;gt;应用&amp;lt;/a&amp;gt;\n&amp;lt;a href=&amp;quot;article.php&amp;quot;&amp;gt;文章&amp;lt;/a&amp;gt;\n&amp;lt;a href=&amp;quot;memberlist.php&amp;quot;&amp;gt;会员&amp;lt;/a&amp;gt;\n&amp;lt;a href=&amp;quot;[MOD=wadou]&amp;quot;&amp;gt;挖豆&amp;lt;/a&amp;gt;&amp;lt;br /&amp;gt;\n&amp;lt;a href=&amp;quot;groupcp.php&amp;quot;&amp;gt;小组&amp;lt;/a&amp;gt;\n&amp;lt;a href=&amp;quot;rules.php&amp;quot;&amp;gt;规则&amp;lt;/a&amp;gt;\n&amp;lt;a href=&amp;quot;viewonline.php&amp;quot;&amp;gt;在线&amp;lt;/a&amp;gt;\n&amp;lt;a href=&amp;quot;[MOD=sign]&amp;quot;&amp;gt;签到&amp;lt;/a&amp;gt;\n&amp;lt;a href=&amp;quot;[MOD=bbchat]&amp;quot;&amp;gt;聊天&amp;lt;/a&amp;gt;&amp;lt;br /&amp;gt;\n&amp;lt;a href=&amp;quot;[MOD=bank]&amp;quot;&amp;gt;银行&amp;lt;/a&amp;gt;\n&amp;lt;a href=&amp;quot;album.php&amp;quot;&amp;gt;相册&amp;lt;/a&amp;gt;\n&amp;lt;a href=&amp;quot;[MOD=shop]&amp;quot;&amp;gt;商店&amp;lt;/a&amp;gt;\n[/html]', '1', 0, 0, 0, 2, 0, 2),
(8, '工具', '', '1', 0, 0, 0, 3, 0, 3),
(9, '论坛帖子隐藏模块', '[html]\n&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;index-cat&amp;quot;&amp;gt;网站动态&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;index-row&amp;quot;&amp;gt;\n[聊天动态]\n欢迎新会员 &amp;lt;a href=&amp;quot;[我的地盘_[新ID]]&amp;quot;&amp;gt;[新会员]&amp;lt;/a&amp;gt;\n&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;index-cat&amp;quot;&amp;gt;\n&amp;lt;div class=&amp;quot;left&amp;quot; style=&amp;quot;width:50%;&amp;quot;&amp;gt;最新帖子&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;right center&amp;quot; style=&amp;quot;width:50%;&amp;quot;&amp;gt;&amp;lt;a href=&amp;quot;forum.php&amp;quot;&amp;gt;进入论坛&amp;lt;/a&amp;gt;&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;clear&amp;quot;&amp;gt;&amp;lt;/div&amp;gt;\n&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;index-row index-topic&amp;quot;&amp;gt;\n[调用帖子_0_1_2_1_5]\n&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;clear&amp;quot;&amp;gt;&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;index-cat&amp;quot;&amp;gt;会员最新照片&amp;lt;/div&amp;gt;\n[调用相册_3_80_80_5]\n&amp;lt;div class=&amp;quot;index-cat&amp;quot;&amp;gt;\n&amp;lt;div class=&amp;quot;left&amp;quot; style=&amp;quot;width:50%;&amp;quot;&amp;gt;&amp;lt;a href=&amp;quot;forum.php?c=1&amp;quot;&amp;gt;技术&amp;lt;/a&amp;gt;&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;right center&amp;quot; style=&amp;quot;width:50%;&amp;quot;&amp;gt;\n&amp;lt;a href=&amp;quot;viewforum.php?f=1&amp;quot;&amp;gt;电脑&amp;lt;/a&amp;gt; . \n&amp;lt;a href=&amp;quot;viewforum.php?f=2&amp;quot;&amp;gt;手机&amp;lt;/a&amp;gt; .\n&amp;lt;a href=&amp;quot;viewforum.php?f=3&amp;quot;&amp;gt;编程&amp;lt;/a&amp;gt;\n&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;clear&amp;quot;&amp;gt;&amp;lt;/div&amp;gt;\n&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;index-row index-topic&amp;quot;&amp;gt;\n[调用帖子_1,2,3_1_2_6_5]\n&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;clear&amp;quot;&amp;gt;&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;index-cat&amp;quot;&amp;gt;\n&amp;lt;div class=&amp;quot;left&amp;quot; style=&amp;quot;width:50%;&amp;quot;&amp;gt;&amp;lt;a href=&amp;quot;forum.php?c=2&amp;quot;&amp;gt;休闲&amp;lt;/a&amp;gt;&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;right center&amp;quot; style=&amp;quot;width:50%;&amp;quot;&amp;gt;\n&amp;lt;a href=&amp;quot;viewforum.php?f=4&amp;quot;&amp;gt;灌水&amp;lt;/a&amp;gt;.\n&amp;lt;a href=&amp;quot;viewforum.php?f=5&amp;quot;&amp;gt;文学&amp;lt;/a&amp;gt;.\n&amp;lt;a href=&amp;quot;viewforum.php?f=9&amp;quot;&amp;gt;交易&amp;lt;/a&amp;gt;.\n&amp;lt;a href=&amp;quot;viewforum.php?f=10&amp;quot;&amp;gt;美图&amp;lt;/a&amp;gt;\n&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;clear&amp;quot;&amp;gt;&amp;lt;/div&amp;gt;\n&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;index-row index-topic&amp;quot;&amp;gt;\n[调用帖子_4,5,9,10_1_2_6_5]\n&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;clear&amp;quot;&amp;gt;&amp;lt;/div&amp;gt;\n[/html]', '1', 1, 0, 0, 6, 0, 4),
(22, '', '[html]&amp;lt;div class=&amp;quot;title&amp;quot;&amp;gt;实用工具&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;module&amp;quot;&amp;gt;&amp;lt;a href=&amp;quot;[MOD=iconv]&amp;quot;&amp;gt;文字转HTML实体&amp;lt;/a&amp;gt;&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;module&amp;quot;&amp;gt;&amp;lt;a href=&amp;quot;[MOD=cssp]&amp;quot;&amp;gt;CSS格式化工具&amp;lt;/a&amp;gt;&amp;lt;/div&amp;gt;[/html]', '', 0, 0, -2, 0, 3, 0),
(11, '', '[html]&amp;lt;div class=&amp;quot;title&amp;quot;&amp;gt;电脑相关&amp;lt;/div&amp;gt;&amp;lt;div class=&amp;quot;index-row index-topic&amp;quot;&amp;gt;[调用专题_1_10]\n&amp;lt;a href=&amp;quot;viewclass.php?f=1&amp;amp;class=1&amp;quot;&amp;gt;点击查看更多&amp;gt;&amp;gt;&amp;gt;&amp;lt;/a&amp;gt;\n&amp;lt;/div&amp;gt;\n\n&amp;lt;div class=&amp;quot;clear&amp;quot;&amp;gt;&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;title&amp;quot;&amp;gt;手机相关&amp;lt;/div&amp;gt;&amp;lt;div class=&amp;quot;title&amp;quot;&amp;gt;图片相关&amp;lt;/div&amp;gt;&amp;lt;div class=&amp;quot;title&amp;quot;&amp;gt;其它&amp;lt;/div&amp;gt;&amp;lt;div class=&amp;quot;nav&amp;quot;&amp;gt;&amp;lt;a href=&amp;quot;./&amp;quot;&amp;gt;返回上级&amp;lt;/a&amp;gt; / &amp;lt;a href=&amp;quot;./&amp;quot;&amp;gt;返回首页&amp;lt;/a&amp;gt;&amp;lt;/div&amp;gt;[/html]', '', 0, 0, -2, 0, 2, 0),
(10, '素材', '', '1', 1, 0, 0, 999, 0, 5),
(21, '', '', '', 0, 0, -3, 0, 2, 0),
(18, '联系方式', '', '', 1, 0, 0, 9999, 0, 12),
(19, '', '[html]\n&amp;lt;div class=&amp;quot;title&amp;quot;&amp;gt;联系方式&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;box module&amp;quot;&amp;gt;\nＱＱ：&amp;lt;a target=&amp;quot;_blank&amp;quot; href=&amp;quot;http://wpa.qq.com/msgrd?v=3&amp;amp;uin=&amp;amp;site=qq&amp;amp;menu=yes&amp;quot; title=&amp;quot;点击发起聊天&amp;quot;&amp;gt;53109774&amp;lt;/a&amp;gt;&amp;lt;br /&amp;gt;&amp;lt;br /&amp;gt;\nＱ群：&amp;lt;a target=&amp;quot;_blank&amp;quot; href=&amp;quot;http://shang.qq.com/wpa/qunwpa?idkey=e89ee576c26f911f914179fadb4da6bd9f79600cac81b6598fb792276d62ce20&amp;quot;&amp;gt;&amp;lt;img border=&amp;quot;0&amp;quot; src=&amp;quot;http://pub.idqqimg.com/wpa/images/group.png&amp;quot; alt=&amp;quot;掌云&amp;quot; title=&amp;quot;掌云&amp;quot;&amp;gt;&amp;lt;/a&amp;gt;&amp;lt;br /&amp;gt;&amp;lt;br /&amp;gt;\n邮箱：admin#zhangyun.org（把#改成@）\n&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;nav&amp;quot;&amp;gt;&amp;lt;a href=&amp;quot;./&amp;quot;&amp;gt;返回上级&amp;lt;/a&amp;gt; / &amp;lt;a href=&amp;quot;./&amp;quot;&amp;gt;返回首页&amp;lt;/a&amp;gt;&amp;lt;/div&amp;gt;\n[/html]', '', 0, 0, -2, 0, 12, 0),
(20, '', '', '', 0, 0, -3, 0, 12, 0),
(23, '', '[html]&amp;lt;div class=&amp;quot;nav&amp;quot;&amp;gt;&amp;lt;a href=&amp;quot;./&amp;quot;&amp;gt;返回上级&amp;lt;/a&amp;gt; / &amp;lt;a href=&amp;quot;./&amp;quot;&amp;gt;返回首页&amp;lt;/a&amp;gt;&amp;lt;/div&amp;gt;[/html]', '', 0, 0, -3, 0, 3, 0),
(25, '', '[html]&amp;lt;div class=&amp;quot;title&amp;quot;&amp;gt;关于本站&amp;lt;/a&amp;gt;&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;module box&amp;quot;&amp;gt;\n  &amp;lt;div class=&amp;quot;module&amp;quot;&amp;gt;\n    &amp;lt;div class=&amp;quot;module&amp;quot;&amp;gt;\n      &amp;lt;p style=&amp;quot;text-indent:2em&amp;quot;&amp;gt;掌云社区建立于2014年06月10日，是一个专注于编程交流的社区，其内容涵盖编程技术交流,电脑技术交流,手机技术交流,文学交流等&amp;lt;/p&amp;gt;\n   &amp;lt;/div&amp;gt;\n    &amp;lt;div class=&amp;quot;module&amp;quot;&amp;gt;\n      &amp;lt;p&amp;gt;创始人：&amp;lt;a href=&amp;quot;http://zhangyun.org&amp;quot;&amp;gt;Crazy&amp;lt;/a&amp;gt;&amp;lt;/p&amp;gt;\n      &amp;lt;p&amp;gt;域名：&amp;lt;a href=&amp;quot;http://zhangyun.org&amp;quot;&amp;gt;zhangyun.org&amp;lt;/a&amp;gt;&amp;lt;/p&amp;gt;\n    &amp;lt;/div&amp;gt;\n  &amp;lt;/div&amp;gt;\n&amp;lt;/div&amp;gt;\n&amp;lt;div class=&amp;quot;nav&amp;quot;&amp;gt;&amp;lt;a href=&amp;quot;./&amp;quot;&amp;gt;返回上级&amp;lt;/a&amp;gt; / &amp;lt;a href=&amp;quot;./&amp;quot;&amp;gt;返回首页&amp;lt;/a&amp;gt;&amp;lt;/div&amp;gt;[/html]', '', 0, 0, -2, 0, 13, 0);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_pages`
--

CREATE TABLE IF NOT EXISTS `phpbb_pages` (
  `page_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `page_ago` mediumint(8) NOT NULL DEFAULT '0',
  `page_title` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`page_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=14 ;

--
-- 转存表中的数据 `phpbb_pages`
--

INSERT INTO `phpbb_pages` (`page_id`, `page_ago`, `page_title`) VALUES
(1, 0, '导航隐藏模块'),
(2, 0, '下载'),
(3, 0, '工具'),
(4, 0, '论坛帖子隐藏模块'),
(5, 0, '素材'),
(12, 0, '联系方式'),
(13, 0, '关于本站');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_posts`
--

CREATE TABLE IF NOT EXISTS `phpbb_posts` (
  `post_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `topic_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `forum_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `poster_id` mediumint(8) NOT NULL DEFAULT '0',
  `post_time` int(11) NOT NULL DEFAULT '0',
  `poster_ip` char(8) NOT NULL,
  `post_username` varchar(25) DEFAULT NULL,
  `enable_bbcode` tinyint(1) NOT NULL DEFAULT '1',
  `enable_html` tinyint(1) NOT NULL DEFAULT '0',
  `enable_smilies` tinyint(1) NOT NULL DEFAULT '1',
  `enable_sig` tinyint(1) NOT NULL DEFAULT '1',
  `post_edit_time` int(11) DEFAULT NULL,
  `post_edit_count` smallint(5) unsigned NOT NULL DEFAULT '0',
  `post_reviews` smallint(8) unsigned NOT NULL DEFAULT '0',
  `post_locked` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `post_attachment` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`post_id`),
  KEY `forum_id` (`forum_id`),
  KEY `topic_id` (`topic_id`),
  KEY `poster_id` (`poster_id`),
  KEY `post_time` (`post_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=66 ;

--
-- 转存表中的数据 `phpbb_posts`
--

INSERT INTO `phpbb_posts` (`post_id`, `topic_id`, `forum_id`, `poster_id`, `post_time`, `poster_ip`, `post_username`, `enable_bbcode`, `enable_html`, `enable_smilies`, `enable_sig`, `post_edit_time`, `post_edit_count`, `post_reviews`, `post_locked`, `post_attachment`) VALUES
(5, 4, 7, 1, 1402405446, '714d2906', '', 1, 0, 1, 0, NULL, 0, 0, 0, 0),
(8, 7, 2, -1, 1402410149, '714d2906', 'Crazy', 1, 0, 1, 0, NULL, 0, 0, 0, 0),
(11, 10, 2, -1, 1402472283, '714d2906', 'Crazy', 1, 0, 1, 0, NULL, 0, 0, 0, 0),
(12, 11, 4, -1, 1402474909, '714d2906', 'Crazy', 1, 0, 1, 0, NULL, 0, 0, 0, 0),
(13, 11, 4, -1, 1402474929, '714d2906', 'Crazy', 1, 0, 1, 0, NULL, 0, 0, 0, 0),
(15, 11, 4, -1, 1402475597, '714d2906', 'Crazy', 1, 0, 1, 0, NULL, 0, 0, 0, 0),
(16, 11, 4, -1, 1402475626, '714d2906', 'Crazy', 1, 0, 1, 0, NULL, 0, 0, 0, 0),
(17, 11, 4, -1, 1402475645, '714d2906', 'Crazy', 1, 0, 1, 0, NULL, 0, 0, 0, 0),
(18, 11, 4, -1, 1402475664, '714d2906', 'Crazy', 1, 0, 1, 0, NULL, 0, 0, 0, 0),
(19, 11, 4, -1, 1402475798, '714d2906', 'Crazy', 1, 0, 1, 0, NULL, 0, 0, 0, 0),
(22, 15, 5, -1, 1402487988, '7793e191', 'sun', 1, 0, 1, 0, NULL, 0, 0, 0, 0),
(26, 15, 5, -1, 1402495957, '7793e191', 'sun', 1, 0, 1, 0, NULL, 0, 0, 0, 0),
(27, 15, 5, -1, 1402495996, '7793e191', 'sun', 1, 0, 1, 0, NULL, 0, 0, 0, 0),
(63, 53, 2, -1, 1402612696, '77903fa2', 'Crazy', 1, 0, 1, 0, NULL, 0, 0, 0, 1);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_posts_text`
--

CREATE TABLE IF NOT EXISTS `phpbb_posts_text` (
  `post_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `bbcode_uid` char(10) NOT NULL DEFAULT '',
  `post_subject` char(60) DEFAULT NULL,
  `post_text` text,
  PRIMARY KEY (`post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `phpbb_posts_text`
--

INSERT INTO `phpbb_posts_text` (`post_id`, `bbcode_uid`, `post_subject`, `post_text`) VALUES
(5, 'dcb9fa4fe7', '招聘论坛版主和管理员', '为了规范论坛的管理制度，优化版主队伍，维持更洁净的版面秩序，决定征选新一批的版主们！\r\n根据大家的意愿报名，这里不需要有太多的压力，只要你热情、热心、有责任心。如果你心里没底，请相信我们可以互相帮助！可以自荐也可以推荐，大家快快申请吧！\r\n加入我们的管理队伍，为网站发展贡献添砖加瓦，为网站的繁荣我们一起努力！！\r\n\r\n[color=red:dcb9fa4fe7][b:dcb9fa4fe7][size=18:dcb9fa4fe7]副站长（1人）[/size:dcb9fa4fe7][/b:dcb9fa4fe7][/color:dcb9fa4fe7]\r\n\r\n[b:dcb9fa4fe7]申请条件：[/b:dcb9fa4fe7]\r\n\r\n* 一星期最少5天在线，在线能保证2小时以上\r\n* 有策划力，活跃度，能善于和各版主之间沟通\r\n* 负责网站的一些工作，例如：工资（指的是Ｙ币）发放之类的\r\n\r\n[color=red:dcb9fa4fe7][b:dcb9fa4fe7][size=18:dcb9fa4fe7]版主(每个版块1人)[/size:dcb9fa4fe7][/b:dcb9fa4fe7][/color:dcb9fa4fe7]\r\n根据特长或兴趣，某一版块的版主\r\n[b:dcb9fa4fe7]申请条件：[/b:dcb9fa4fe7]\r\n\r\n* 一星期最少3天在线，在线能保证1小时以上\r\n* 自愿、义务地为论坛网友服务\r\n* 有策划力，活跃度。和各版主之间能多协作与配合。\r\n* 提升版面人气，活跃论坛氛围。策划有新意的好活动，好策划，为论坛的发展献计献策！\r\n\r\n[color=red:dcb9fa4fe7][b:dcb9fa4fe7][size=18:dcb9fa4fe7]奖励[/size:dcb9fa4fe7][/b:dcb9fa4fe7][/color:dcb9fa4fe7]\r\n副站长每月可获得【超级QQ、黄钻、绿钻、会员一个月（业务只能选一个）】和话费10元\r\n版主每个月可获得【超级QQ、黄钻、绿钻、会员一个月（业务只能选一个）】和100Ｙ币\r\n\r\n[color=red:dcb9fa4fe7][b:dcb9fa4fe7][size=18:dcb9fa4fe7]申请方法[/size:dcb9fa4fe7][/b:dcb9fa4fe7][/color:dcb9fa4fe7]\r\n\r\n在职务申请版面发表一个帖子，其格式为：\r\n\r\n申请 XXXX 论坛版主\r\n\r\n申请人用户名：\r\n申请的版面名称：\r\n特长爱好：\r\n上网时段：\r\n申请理由：\r\n面对网友的投诉或指责，您会怎样去做：\r\n\r\n\r\n如版主长时间不负责的，会提出提醒，如没有改正的，将被开除。,由于某些原因，你不再是版主，我们论坛还是感谢你的付出！！'),
(8, '3e8803f7a1', '越狱大神树人表示 iOS 8目前可以越狱', '　　iOS8发布之后，很多果粉都在喜大普奔称以后用不着越狱了，因为iOS8支持第三方输入法，针对中国用户新增了农历，而在锁屏状态下也可以在通知中心直接回复短信，这些，在之前都是要越狱之后借助插件才能做到的。 \r\n　　虽然，有不少果粉都抱着这样的心思，但相信还是会有很多人选择越狱的，因为越狱之后有更多的插件可以选择，这绝对不是iOS8中新增加的几项功能可以比拟的。而现在，好消息来了！ \r\n　　就在今天，前越狱大神树人在Twitter上表示，经过他对iOS8 beta1的测试过后，发现只要对他本人的越狱工具经过一些代码修改就可以支持iOS8测试版了。而在此前，树人已经演示过iOS7.1.1的越狱视频。 \r\n　　树人，前iOS著名越狱黑客，近几年树人的工作已经转向安全研究，同时他还开设了iOS黑客课程，同时和Charlie Miller(0xcharlie)等多名黑客推出了《iOS黑客手册》(去年已推出中文版)。这本手册列举了所有已发现的iOS漏洞，以及这些漏洞会为iOS系统带来的危害等内容。 \r\n　　不过这个人虽然能力很强，但他的习惯一向是自己制作出越狱工具但不放出来..只是会广而告之：我做出越狱了，但我就是不给你们。当然，他如果肯定iOS8能越狱的话，那么还是很可信的。'),
(11, '023d5c1236', '手机，让无处不在', '从纸质走向数字，从PC互联网走向移动互联网，从书房走向公交车……我们的阅读方式正迎来新的革命。今天，移动运营商天翼阅读在杭州发布了2014年第一季度手机阅读榜单：基于对2亿多用户的阅读行为分析来看，全国最爱阅读城市榜中，南宁最多，杭州以平均阅读1.89本排在最爱按本阅读城市榜第七位。\r\n\r\n据《第十一次全国国民阅读调查》数据显示，2013年中国年人均阅读量只有4.77本。但从天翼阅读发布的趣味数据来看，仅在第一季度，就有南宁、北京、天津、苏州、合肥、杭州等十个城市的人均阅读量超过1.8本，预计这些城市2014年平均阅读都将超过7本书，大大高于全国平均阅读本数。位于中西部的广西南宁市，其以第一季度人均2.53本荣膺最爱按本阅读城市榜榜首。\r\n\r\n手机阅读，渐成趋势。记者今天从中国移动手机阅读基地获得的数据显示，手机阅读上线4年来，该平台的日均点击量6.5亿次，汇聚近40万册优质正版图书，去年优质首发图书数达180本，今年还计划在100个城市举办超过100场名人名家讲座。\r\n\r\n作为手机阅读内容的中坚力量—原创文学阅读榜中，浙江夺魁。最爱原创小说阅读城市榜中，浙江有5个城市排名前十，其中绍兴以人均102.97章节的优势超越人均102.42章节的江苏苏州，成为阅读网络原创小说的冠军城市，其他上榜的4个城市分别是杭州、宁波、台州和金华。从受欢迎的程度来看，原创文学中都市类和言情类，书籍出版中影视剧本和经管类，杂志则以漫画、时尚、幽默为主。\r\n\r\n“上下班路太堵了，看书既能增长知识又能打发时间。”在杭州延安路上班的徐先生是个阅读达人，这两天他正在看《陆犯焉识》。数据显示，利用这些碎片化时间，在一天中，下午1点和晚上9点至12点，也就是说，午饭后，睡觉前大家都在看书；而从一周来看，周六、周日逐渐成为手机用户的“阅读日”，周末读书是一个不错的好现象。在阅读时间上，80%的读者阅读时间在半个小时以上。\r\n手机看电子书，多大才合适？趣味数据显示，“低头族”最喜欢用4寸至4.5寸手机看电子书，约占总数的36%，其次，5寸以上的手机屏幕约占22%。也就是说，有八成的人使用4寸以上大屏手机看电子书，这个数据基本与当前主流手机的屏幕大小吻合。在这里，还有一个数据要伤广大“果粉”的心了，数据显示苹果不是读者阅读最爱的手机，华为、三星、中兴成为阅读电子书最多的三个品牌。\r\n\r\n除了读，边走边听，也是手机阅读的一个新趋势。在天翼阅读客户端，去年新上线的栏目“氧气听书”，记者看到评书相声、儿童读物等2万多部有声作品，随时随地都能点播；而国内一些手机阅读软件像Ireader、塔读文学等也纷纷研发了“边听边读”的应用模式。当眼睛在工作或是休息时，让耳朵来阅读吧。'),
(12, 'b041d8d2f5', '我水', '测试帖子'),
(13, 'b6e454b53a', '', '[quote:b6e454b53a="Crazy"]测试帖子[/quote:b6e454b53a]'),
(15, 'd70646dc55', '', '[quote:d70646dc55="Crazy"][quote:d70646dc55="Crazy"]测试帖子[/quote:d70646dc55][/quote:d70646dc55]'),
(16, '46c5ff3c93', '', '[quote:46c5ff3c93="Crazy"][quote:46c5ff3c93="Crazy"][quote:46c5ff3c93="Crazy"]测试帖子[/quote:46c5ff3c93][/quote:46c5ff3c93][/quote:46c5ff3c93]'),
(17, 'eca55672ff', '', '[quote:eca55672ff="Crazy"][quote:eca55672ff="Crazy"][quote:eca55672ff="Crazy"][quote:eca55672ff="Crazy"]测试帖子[/quote:eca55672ff][/quote:eca55672ff][/quote:eca55672ff][/quote:eca55672ff]good'),
(18, '2fb734878a', '', '[quote:2fb734878a="Crazy"][quote:2fb734878a="Crazy"][quote:2fb734878a="Crazy"][quote:2fb734878a="Crazy"][quote:2fb734878a="Crazy"]测试帖子[/quote:2fb734878a][/quote:2fb734878a][/quote:2fb734878a][/quote:2fb734878a]good[/quote:2fb734878a]good'),
(19, '2c44ff9312', '', '[quote:2c44ff9312="Crazy"][quote:2c44ff9312="Crazy"][quote:2c44ff9312="Crazy"][quote:2c44ff9312="Crazy"][quote:2c44ff9312="Crazy"][quote:2c44ff9312="Crazy"]测试帖子[/quote:2c44ff9312][/quote:2c44ff9312][/quote:2c44ff9312][/quote:2c44ff9312]good[/quote:2c44ff9312]good[/quote:2c44ff9312]good'),
(22, '9f91548156', '朋友，你好吗', '你好吗？我隔屏相望的朋友。\r\n　　在茫茫网海中不经意的一次相遇，让我们相互牵伴。每一次爬网，都在冥冥之中默默的期待着，静静地等候着你的出现，每一次看到你上线，心中总有一种莫名的颤动。轻轻点击你的名字，会有一种暖意慢慢袭来，在线的时间总是过的那样快，每次下线，总是依依不舍，心中又在期盼着下一次的相遇。\r\n　　你好吗？我远方的朋友。\r\n　　虽然我们相隔千里，但心心相通，你每时每刻都在关心着我的一切。每当我看到简短的留言，虽然是平平常常的几句：天冷了。记得穿衣服；今天嗓子怎么不好了，多喝水，记得吃饭啊，开开心心每一天。心中会涌起阵阵的暖意，使我远在他乡也感受到了你最真切的关怀。\r\n　　你好吗？我异乡的知己。\r\n　　在这大千世界里，我怎么会与你相识相知呢。每当我感到孤独，遇到忧愁，是你为我唱一首歌，读一篇文章，用温情的话语让我除去烦恼。你丝丝话语都注入了我的心田，我沉浸在温馨的感觉里......\r\n　　你好吗？我今生的好友。\r\n　　虽然我们相隔千里，但网络把我们拉的很近很近，我们总能真真切切地感受到彼此的存在，彼此的心情，彼此的感觉。你也许不知道你已经悄悄地走入了我的心中，每当想起你，心底最深处哪种甜甜的感觉，深夜里总会暖暖地传遍我的全身。\r\n　　你好吗？我一世的知己。\r\n　　虽然我们不在同一座城市，虽然我们不曾谋面，也许今生也无缘相见，但真心我们付出过，真心给予过，真真切切地牵挂着。丝丝思念的痛，使孤独寂寞不在，有的是永远的真情，永远的最纯真的感情......\r\n　　你好吗？我的朋友！一声声的问候给你，就是希望你也开心快乐，希望你的心里永远都充满阳光!\r\n即使我们的相聚要变成离别，我们也不会有丝毫伤感。因为我们有是一张张回味无穷的美景，记忆中芬芳的园地里，必珍藏这些心动的瞬间，当我们在。蓦然回首的刹那，依旧如当初一般感动！'),
(26, '1fce769393', '', 'gggg'),
(27, '55a9182fa6', '', 'gfggfg'),
(63, 'c734aa1bcf', 'Cydia已更新至1.1.10: 更好地兼容于iOS 7', '[quote:c734aa1bcf]Saurik 本周四发布了 Cydia 1.1.10，为越狱用户带来更方便更快速的使用体验。除此之外，新版本的 Cydia 还添加了一些新特性，比如更合理的用户界面和一个 iOS 7 风格的图标。[/quote:c734aa1bcf]\r\n　　将近半年过去后，Cydia 终于又迎来了更新。威锋网消息，Saurik 本周四发布了 Cydia 1.1.10，为越狱用户带来更方便更快速的使用体验。除此之外，新版本的 Cydia 还添加了一些新特性，比如更合理的用户界面和一个 iOS 7 风格的图标。另外，Cydia 1.1.10 还对前一个版本的部分漏洞进行了修复，同时进一步改善了平台内的翻译质量。\r\n\r\n　　据了解，目前 Cydia 支持的语言及文字包括：阿拉伯语、简体/繁体中文、荷兰语、英语、法语、德语、希腊语、希伯来语、意大利语、日语、韩语、波兰语、葡萄牙语/巴西葡萄牙语、俄语、西班牙语、瑞典语、泰语、土耳其语以及越南语。越狱用户现在就可以直接在设备上的 Cydia 平台内进行更新。\r\n\r\n　　目前越狱社区又恢复了之前的平静。虽然前段时间不断有黑客放出 iOS 7.1.1 的越狱消息，但是其越狱工具的发布已经可以说是几乎无望。由于苹果在 WWDC 大会上发布了首个 iOS 8 测试版，因此按照一般流程来讲，黑客都会等到苹果发布 iOS 8 正式版之后才会将越狱工具放出。');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_post_reports`
--

CREATE TABLE IF NOT EXISTS `phpbb_post_reports` (
  `report_id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `post_id` mediumint(8) NOT NULL DEFAULT '0',
  `reporter_id` mediumint(8) NOT NULL DEFAULT '0',
  `report_status` tinyint(1) NOT NULL DEFAULT '0',
  `report_time` int(11) NOT NULL DEFAULT '0',
  `report_comments` text,
  `last_action_user_id` mediumint(8) DEFAULT '0',
  `last_action_time` int(11) NOT NULL DEFAULT '0',
  `last_action_comments` text,
  PRIMARY KEY (`report_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_privmsgs`
--

CREATE TABLE IF NOT EXISTS `phpbb_privmsgs` (
  `privmsgs_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `privmsgs_type` tinyint(4) NOT NULL DEFAULT '0',
  `privmsgs_subject` varchar(255) NOT NULL DEFAULT '0',
  `privmsgs_from_userid` mediumint(8) NOT NULL DEFAULT '0',
  `privmsgs_to_userid` mediumint(8) NOT NULL DEFAULT '0',
  `privmsgs_date` int(11) NOT NULL DEFAULT '0',
  `privmsgs_ip` char(8) NOT NULL,
  PRIMARY KEY (`privmsgs_id`),
  KEY `privmsgs_from_userid` (`privmsgs_from_userid`),
  KEY `privmsgs_to_userid` (`privmsgs_to_userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_privmsgs_text`
--

CREATE TABLE IF NOT EXISTS `phpbb_privmsgs_text` (
  `privmsgs_text_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `privmsgs_text` text,
  PRIMARY KEY (`privmsgs_text_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_profile_guestbook`
--

CREATE TABLE IF NOT EXISTS `phpbb_profile_guestbook` (
  `gb_id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `user_id` mediumint(8) NOT NULL DEFAULT '0',
  `poster_id` mediumint(8) NOT NULL,
  `gb_time` int(11) NOT NULL DEFAULT '0',
  `master_look` tinyint(1) NOT NULL DEFAULT '0',
  `message` text NOT NULL,
  PRIMARY KEY (`gb_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

--
-- 转存表中的数据 `phpbb_profile_guestbook`
--

INSERT INTO `phpbb_profile_guestbook` (`gb_id`, `user_id`, `poster_id`, `gb_time`, `master_look`, `message`) VALUES
(1, 2, 2, 0, 0, 'TEst'),
(2, 1, 1, 0, 0, '11111111'),
(3, 2, 2, 1402660246, 0, '测试'),
(4, 2, 2, 1402660779, 0, 'haha'),
(5, 2, 2, 1402661949, 1, '5'),
(6, 2, 2, 1402663758, 0, '范德萨'),
(7, 2, 2, 1402663792, 0, '范德萨'),
(8, 2, 2, 1402663908, 0, '范德萨'),
(9, 2, 2, 1402664053, 1, '范德萨'),
(10, 2, 2, 1402664173, 1, '反打'),
(11, 2, 2, 1402664628, 1, '发大水'),
(12, 2, 2, 1402665176, 0, '范德萨');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_quota_limits`
--

CREATE TABLE IF NOT EXISTS `phpbb_quota_limits` (
  `quota_limit_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `quota_desc` varchar(20) NOT NULL DEFAULT '',
  `quota_limit` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`quota_limit_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- 转存表中的数据 `phpbb_quota_limits`
--

INSERT INTO `phpbb_quota_limits` (`quota_limit_id`, `quota_desc`, `quota_limit`) VALUES
(1, '低', 1048576),
(2, '中', 2097152),
(3, '高', 20971520);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_ranks`
--

CREATE TABLE IF NOT EXISTS `phpbb_ranks` (
  `rank_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `rank_title` varchar(50) NOT NULL,
  `rank_min` mediumint(8) NOT NULL DEFAULT '0',
  `rank_special` tinyint(1) DEFAULT '0',
  `rank_image` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rank_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- 转存表中的数据 `phpbb_ranks`
--

INSERT INTO `phpbb_ranks` (`rank_id`, `rank_title`, `rank_min`, `rank_special`, `rank_image`) VALUES
(1, '最强王者', -1, 1, NULL),
(2, '菜鸟', 0, 0, NULL),
(3, '新手', 20, 0, NULL),
(4, '入门', 50, 0, NULL),
(5, '老鸟', 100, 0, NULL),
(6, '小虾', 200, 0, NULL),
(7, '大虾', 500, 0, NULL),
(8, '元老', 1000, 0, NULL);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_rules`
--

CREATE TABLE IF NOT EXISTS `phpbb_rules` (
  `rule_id` int(11) NOT NULL,
  `rule_cat_id` int(11) NOT NULL,
  `rule_name` varchar(200) NOT NULL,
  `rule_subj` text NOT NULL,
  `rule_moder` tinyint(4) NOT NULL,
  PRIMARY KEY (`rule_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `phpbb_rules`
--

INSERT INTO `phpbb_rules` (`rule_id`, `rule_cat_id`, `rule_name`, `rule_subj`, `rule_moder`) VALUES
(1, 1, '1.1', '您好！这是一条测试的规则，如果你不喜欢您可以删除、编辑它。', 1);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_rules_cat`
--

CREATE TABLE IF NOT EXISTS `phpbb_rules_cat` (
  `cat_r_id` int(11) NOT NULL,
  `cat_r_name` varchar(200) NOT NULL,
  PRIMARY KEY (`cat_r_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `phpbb_rules_cat`
--

INSERT INTO `phpbb_rules_cat` (`cat_r_id`, `cat_r_name`) VALUES
(1, '测试规则分类');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_search_results`
--

CREATE TABLE IF NOT EXISTS `phpbb_search_results` (
  `search_id` int(11) unsigned NOT NULL DEFAULT '0',
  `session_id` char(32) NOT NULL DEFAULT '',
  `search_time` int(11) NOT NULL DEFAULT '0',
  `search_array` text NOT NULL,
  PRIMARY KEY (`search_id`),
  KEY `session_id` (`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `phpbb_search_results`
--

INSERT INTO `phpbb_search_results` (`search_id`, `session_id`, `search_time`, `search_array`) VALUES
(1144140465, 'fc7a6ab7b06884d3f55a88f645f53ac2', 1402765448, 'a:7:{s:14:"search_results";s:207:"2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 24, 25, 28, 29, 30, 31, 32, 33, 37, 38, 39, 40, 41, 42, 43, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63";s:17:"total_match_count";i:54;s:12:"split_search";a:0:{}s:7:"sort_by";i:0;s:8:"sort_dir";s:4:"DESC";s:12:"show_results";s:5:"posts";s:12:"return_chars";i:200;}');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_search_wordlist`
--

CREATE TABLE IF NOT EXISTS `phpbb_search_wordlist` (
  `word_text` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `word_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `word_common` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`word_text`),
  KEY `word_id` (`word_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1222 ;

--
-- 转存表中的数据 `phpbb_search_wordlist`
--

INSERT INTO `phpbb_search_wordlist` (`word_text`, `word_id`, `word_common`) VALUES
('phpbb', 3, 0),
('1', 30, 0),
('小清新的大爱', 29, 0),
('xxxx', 54, 0),
('上网时段：', 55, 0),
('副站长（1人）', 56, 0),
('奖励', 57, 0),
('每个版块1人', 58, 0),
('版主', 59, 0),
('特长爱好：', 60, 0),
('由于某些原因，你不再是版主，我们论坛还是感谢你的付出！！', 61, 0),
('申请', 62, 0),
('申请方法', 63, 0),
('申请条件：', 64, 0),
('申请理由：', 65, 0),
('论坛版主', 66, 0),
('10', 356, 0),
('7', 353, 0),
('0xcharlie', 92, 0),
('1的越狱视频。', 93, 0),
('8目前可以越狱', 94, 0),
('beta1的测试过后，发现只要对他本人的越狱工具经过一些代码修改就可以支持ios8测试版了。而在此前', 95, 0),
('ios', 96, 0),
('miller', 97, 0),
('去年已推出中文版', 98, 0),
('4平方公里的区域。而根据纽约市的人口密度，在某些地区黑客的潜在目标达到每平方公里7万人。如果使用售价', 101, 0),
('53本荣膺最爱按本阅读城市榜榜首。', 113, 0),
('5亿次，汇聚近40万册优质正版图书，去年优质首发图书数达180本，今年还计划在100个城市举办超过1', 114, 0),
('5寸手机看电子书，约占总数的36', 115, 0),
('77本。但从天翼阅读发布的趣味数据来看，仅在第一季度，就有南宁、北京、天津、苏州、合肥、杭州等十个城', 116, 0),
('89本排在最爱按本阅读城市榜第七位。', 117, 0),
('97章节的优势超越人均102', 118, 0),
('。也就是说，有八成的人使用4寸以上大屏手机看电子书，这个数据基本与当前主流手机的屏幕大小吻合。在这里', 119, 0),
('的读者阅读时间在半个小时以上。', 120, 0),
('我水', 121, 0),
('测试帖子', 122, 0),
('good', 124, 0),
('registerglobals', 129, 0),
('true', 300, 0),
('http', 298, 0),
('str', 347, 0),
('isset', 333, 0),
('for', 322, 0),
('create', 318, 0),
('crazy', 317, 0),
('朋友，你好吗', 364, 0),
('linux版', 233, 0),
('phpstudy', 240, 0),
('win版同步上线', 246, 0),
('sublime', 255, 0),
('false', 260, 0),
('gggg', 366, 0),
('gfggfg', 367, 0),
('。', 383, 0),
('为自己的第一份真正的工作做好准备。如果你不想成为其中之一，请学学以下这10项无需手把手指导就能学会的', 384, 0),
('imgautosize', 472, 0),
('null', 481, 0),
('post', 518, 0),
('select', 521, 0),
('utf8', 527, 0),
('value', 528, 0),
('8版，我用的是最新版，还有很多软件100tv视频播放器、淘宝、等等还需自测。建议把网络禁用，其他版本', 566, 0),
('analysis：查找数据字典，检查表、列是否正确，在所要求的对象上获取语法分析锁，使得在语句的语法', 573, 0),
('off', 609, 0),
('临时表并不是不可使用，适当地使用它们可以使某些例程更有效，例如，当需要重复引用大型表或常用表中的某个', 625, 0),
('和', 632, 0),
('在使用索引字段作为条件时，如果该索引是复合索引，那么必须使用到该索引中的第一个字段作为条件时才能保证', 633, 0),
('尽量使用数字型字段，若只含数值信息的字段尽量不要设计为字符型，这会降低查询和连接的性能，并会增加存储', 643, 0),
('并不是所有索引对查询都有效，sql是根据表中数据来进行查询优化的，当索引列有大量数据重复时，sql查', 648, 0),
('而，如果在编译时建立访问计划，变量的值还是未知的，因而无法作为索引选择的输入项。如下面语句将进行全表', 664, 0),
('color', 702, 0),
('contentlength', 703, 0),
('gt', 711, 0),
('lt', 717, 0),
('path', 720, 0),
('post方式不是绝对安全），讲述的主要是关于用各种方法模拟get和post请求的问题。其中有一段是关', 722, 0),
('gbk', 775, 0),
('intel架构，而另一些是采用高位先发送的方式，在网络中交换数据时，为了核对双方对于高低位的认识是否', 776, 0),
('iso就直接规定必须用两个字节，也就是16位来统一表示所有的字符，对于ascii里的那些“半角”字符', 777, 0),
('unicode', 781, 0),
('打印机就打印反白的字，或者终端就用彩色显示字母。他们看到这样很好，于是就把这些0x20以下的字节状态', 805, 0),
('和postcheck。precheck扩展名定义了这样一段时间间隔（以秒记）：即在这段时间间隔之后，', 852, 0),
('include', 861, 0),
('o', 862, 0),
('size', 872, 0),
('length', 907, 0),
('x', 916, 0),
('mvc框架设计者们并没有有意识地将url当作抽象的资源来看待和设计，所以导致一个比较严重的问题是传统', 947, 0),
('request则可以获取get和post两种请求中的数据。值得注意的是，jsp中使用request和', 952, 0),
('。对于其他浏览器，如netscape、firefox等，理论上没有长度限制，其限制取决于操作系统的支', 965, 0),
('请求一般不应产生副作用。就是说，它仅仅是获取资源信息，就像数据库查询一样，不会修改，增加数据，不会影', 973, 0),
('invalid', 990, 0),
('iostream', 991, 0),
('least', 993, 0),
('once', 996, 0),
('only', 997, 0),
('pause', 998, 0),
('std', 1000, 0),
('the', 1001, 0),
('twice', 1003, 0),
('using', 1004, 0),
('which', 1005, 0),
('bool', 1014, 0),
('contains', 1015, 0),
('n', 1026, 0),
('num1', 1027, 0),
('number', 1029, 0),
('numbers', 1030, 0),
('unsigned', 1035, 0),
('void', 1036, 0),
('const', 1041, 0),
('greater', 1047, 0),
('greatest', 1048, 0),
('参考代码：', 1071, 0),
('autoincrement', 1108, 0),
('终于又迎来了更新。威锋网消息，saurik', 1140, 0),
('繁体中文、荷兰语、英语、法语、德语、希腊语、希伯来语、意大利语、日语、韩语、波兰语、葡萄牙语', 1139, 0),
('测试版，因此按照一般流程来讲，黑客都会等到苹果发布', 1137, 0),
('的越狱消息，但是其越狱工具的发布已经可以说是几乎无望。由于苹果在', 1138, 0),
('正式版之后才会将越狱工具放出。', 1136, 0),
('saurik', 1133, 0),
('wwdc', 1134, 0),
('本周四发布了', 1135, 0),
('cydia已更新至1', 1132, 0),
('cydia', 1131, 0),
('还对前一个版本的部分漏洞进行了修复，同时进一步改善了平台内的翻译质量。', 1141, 0),
('风格的图标。', 1142, 0),
('风格的图标。另外，cydia', 1143, 0);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_search_wordmatch`
--

CREATE TABLE IF NOT EXISTS `phpbb_search_wordmatch` (
  `post_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `word_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `title_match` tinyint(1) NOT NULL DEFAULT '0',
  KEY `post_id` (`post_id`),
  KEY `word_id` (`word_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `phpbb_search_wordmatch`
--

INSERT INTO `phpbb_search_wordmatch` (`post_id`, `word_id`, `title_match`) VALUES
(5, 55, 0),
(5, 54, 0),
(5, 56, 0),
(5, 57, 0),
(5, 58, 0),
(5, 59, 0),
(5, 60, 0),
(5, 61, 0),
(5, 62, 0),
(5, 63, 0),
(5, 64, 0),
(5, 65, 0),
(5, 66, 0),
(8, 92, 0),
(8, 93, 0),
(8, 97, 0),
(8, 98, 0),
(8, 94, 1),
(8, 96, 1),
(11, 113, 0),
(11, 115, 0),
(11, 117, 0),
(11, 118, 0),
(11, 120, 0),
(12, 122, 0),
(12, 121, 1),
(13, 122, 0),
(15, 122, 0),
(16, 122, 0),
(17, 124, 0),
(17, 122, 0),
(18, 124, 0),
(18, 122, 0),
(19, 124, 0),
(19, 122, 0),
(22, 364, 1),
(26, 366, 0),
(27, 367, 0),
(63, 1132, 1),
(63, 353, 1),
(63, 356, 1),
(63, 1143, 0),
(63, 1142, 0),
(63, 1141, 0),
(63, 1140, 0),
(63, 1139, 0),
(63, 1138, 0),
(63, 1137, 0),
(63, 1136, 0),
(63, 1135, 0),
(63, 1134, 0),
(63, 1133, 0),
(63, 96, 0),
(63, 1131, 0),
(63, 30, 0);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_sessions`
--

CREATE TABLE IF NOT EXISTS `phpbb_sessions` (
  `session_id` char(32) NOT NULL DEFAULT '',
  `session_user_id` mediumint(8) NOT NULL DEFAULT '0',
  `session_start` int(11) NOT NULL DEFAULT '0',
  `session_time` int(11) NOT NULL DEFAULT '0',
  `session_ip` char(8) NOT NULL DEFAULT '0',
  `session_page` int(11) NOT NULL DEFAULT '0',
  `session_logged_in` tinyint(1) NOT NULL DEFAULT '0',
  `session_admin` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`session_id`),
  KEY `session_user_id` (`session_user_id`),
  KEY `session_id_ip_user_id` (`session_id`,`session_ip`,`session_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `phpbb_sessions`
--

INSERT INTO `phpbb_sessions` (`session_id`, `session_user_id`, `session_start`, `session_time`, `session_ip`, `session_page`, `session_logged_in`, `session_admin`) VALUES
('98cc7c5a1e12ade4545d089e2be173a4', -1, 1402785834, 1402785834, '51908a22', 2, 0, 0),
('e068f4773d3ec739a4194b9a10109bf4', -1, 1402785901, 1402785901, '51908a22', 5, 0, 0),
('17cd3c437744c6c95a132a105ab7805b', -1, 1402785915, 1402785915, '51908a22', 10, 0, 0),
('61862a614ccdfa7bafe462047966a80e', -1, 1402785797, 1402785797, '42f94d10', 0, 0, 0),
('6c02d3589cb8cd4ecbee03b7f25bdb17', -1, 1402785626, 1402785626, '51908a22', -4, 0, 0),
('b8eb22859fb30de335619f20c38506b5', -1, 1402775446, 1402786561, '42f94d10', -12, 0, 0),
('cdcc978eec61b8a3ce57950744fa884f', -1, 1402785674, 1402785674, '51908a22', -11, 0, 0),
('28c1d107e50ad96a9d309efc97d9f802', -1, 1402785643, 1402785643, '51908a22', -12, 0, 0),
('399126db3ad4ffd83a233d60dfbd02e0', -1, 1402785842, 1402785842, '51908a22', 3, 0, 0),
('5d2dfb7d25fd3fb1f126ed0a9348c100', -1, 1402785828, 1402785828, '51908a22', 1, 0, 0),
('92bc2228eed5f30542b28d5c0e6e995b', -1, 1402785619, 1402785619, '51908a22', -1, 0, 0),
('ac66fb8e8c5662e4073712a8daebee0f', -1, 1402785651, 1402785651, '51908a22', -18, 0, 0),
('a0e468ffea7c8c84a8cf333c37adb246', -1, 1402785658, 1402785658, '51908a22', -7, 0, 0),
('ad62102b401d796a17fef7ac3e8d6a7a', -1, 1402785717, 1402785717, '51908a22', -19, 0, 0),
('fbb981ca04fbdc8af22a67b0b24f47d2', -1, 1402785688, 1402785688, '51908a22', -6, 0, 0),
('2de0ac24cdcf9524cbde2769bbbd8c15', -1, 1402785908, 1402785908, '51908a22', 9, 0, 0),
('49cadd0c2abaa04051c72fcde8c72201', -1, 1402785632, 1402785632, '51908a22', 0, 0, 0),
('7b86334e9e9b0219b68f861e8a6905a1', -1, 1402785886, 1402785886, '51908a22', 0, 0, 0),
('aabcb7b867a128200fe27bcafc61522f', -1, 1402785682, 1402785682, '51908a22', -14, 0, 0),
('f7ee64ab8e0236ebdf207867ed2126db', -1, 1402785892, 1402785892, '51908a22', 4, 0, 0),
('fed21bd132e8e316fac14363be21f290', -1, 1402785604, 1402785945, '51908a22', 5, 0, 0),
('48450b7422a9df95465ba5d2a1553aef', -1, 1402785819, 1402785819, '51908a22', 0, 0, 0),
('c8bc2a920f6dfe7714744ebe6963e50c', 1, 1402788286, 1402788309, '7f000001', -19, 1, 0);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_sessions_keys`
--

CREATE TABLE IF NOT EXISTS `phpbb_sessions_keys` (
  `key_id` varchar(32) NOT NULL DEFAULT '0',
  `user_id` mediumint(8) NOT NULL DEFAULT '0',
  `last_ip` varchar(8) NOT NULL DEFAULT '0',
  `last_login` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`key_id`,`user_id`),
  KEY `last_login` (`last_login`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `phpbb_sessions_keys`
--

INSERT INTO `phpbb_sessions_keys` (`key_id`, `user_id`, `last_ip`, `last_login`) VALUES
('d26b7823819d8e2c4124a10b4e59b18c', 1, '7f000001', 1402788306);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_shop_ad`
--

CREATE TABLE IF NOT EXISTS `phpbb_shop_ad` (
  `ad_id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `ad_name` varchar(255) NOT NULL,
  `ad_type` tinyint(1) NOT NULL,
  `ad_time` int(11) NOT NULL,
  `ad_url` varchar(255) NOT NULL,
  PRIMARY KEY (`ad_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- 转存表中的数据 `phpbb_shop_ad`
--

INSERT INTO `phpbb_shop_ad` (`ad_id`, `ad_name`, `ad_type`, `ad_time`, `ad_url`) VALUES
(1, 'Crazy', 0, 1402764206, 'http://baidu.com');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_shop_config`
--

CREATE TABLE IF NOT EXISTS `phpbb_shop_config` (
  `config_name` varchar(25) NOT NULL,
  `config_value` varchar(255) NOT NULL,
  PRIMARY KEY (`config_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `phpbb_shop_config`
--

INSERT INTO `phpbb_shop_config` (`config_name`, `config_value`) VALUES
('top_ad', '100'),
('foot_ad', '100'),
('max_day', '7'),
('min_day', '1'),
('max_top_ad', '4'),
('max_foot_ad', '3'),
('buy_username', '100'),
('buy_namecolor', '1000'),
('buy_rank', '100'),
('time_click', '86400'),
('good', '0'),
('ad', '0');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_shop_good`
--

CREATE TABLE IF NOT EXISTS `phpbb_shop_good` (
  `good_id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `good_name` varchar(255) NOT NULL,
  `good_url` varchar(255) NOT NULL,
  `good_points` int(11) NOT NULL,
  PRIMARY KEY (`good_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_shop_qq`
--

CREATE TABLE IF NOT EXISTS `phpbb_shop_qq` (
  `qq` int(11) NOT NULL,
  `points` int(11) NOT NULL,
  `password` varchar(255) NOT NULL,
  UNIQUE KEY `qq` (`qq`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_shout`
--

CREATE TABLE IF NOT EXISTS `phpbb_shout` (
  `shout_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `shout_username` varchar(25) NOT NULL,
  `shout_user_id` mediumint(8) NOT NULL,
  `shout_session_time` int(11) NOT NULL,
  `shout_ip` char(8) NOT NULL,
  `shout_text` text NOT NULL,
  `enable_bbcode` tinyint(1) NOT NULL,
  `enable_html` tinyint(1) NOT NULL,
  `enable_smilies` tinyint(1) NOT NULL,
  `shout_bbcode_uid` varchar(10) NOT NULL,
  KEY `shout_id` (`shout_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- 转存表中的数据 `phpbb_shout`
--

INSERT INTO `phpbb_shout` (`shout_id`, `shout_username`, `shout_user_id`, `shout_session_time`, `shout_ip`, `shout_text`, `enable_bbcode`, `enable_html`, `enable_smilies`, `shout_bbcode_uid`) VALUES
(1, 'Crazy', 2, 1402374975, '714d2906', '我们聊天吧[/微笑]', 1, 0, 1, '88c82f6128'),
(2, 'Crazy', 2, 1402476514, '714d2906', '来了', 1, 0, 1, '140d409f91');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_sign`
--

CREATE TABLE IF NOT EXISTS `phpbb_sign` (
  `sign_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `sign_user_id` mediumint(8) NOT NULL DEFAULT '-1',
  `sign_time` int(11) NOT NULL DEFAULT '0',
  `sign_talk` text,
  PRIMARY KEY (`sign_id`),
  KEY `sign_user_id` (`sign_user_id`),
  KEY `sign_time` (`sign_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- 转存表中的数据 `phpbb_sign`
--

INSERT INTO `phpbb_sign` (`sign_id`, `sign_user_id`, `sign_time`, `sign_talk`) VALUES
(1, 2, 1402372735, '[/微笑]第一次签到'),
(2, 2, 1402586166, '签到');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_smilies`
--

CREATE TABLE IF NOT EXISTS `phpbb_smilies` (
  `smilies_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(50) DEFAULT NULL,
  `smile_url` varchar(100) DEFAULT NULL,
  `emoticon` varchar(75) DEFAULT NULL,
  PRIMARY KEY (`smilies_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=91 ;

--
-- 转存表中的数据 `phpbb_smilies`
--

INSERT INTO `phpbb_smilies` (`smilies_id`, `code`, `smile_url`, `emoticon`) VALUES
(1, '[/微笑]', '1.gif', ' '),
(2, '[/撇嘴]', '2.gif', ' '),
(3, '[/色]', '3.gif', ' '),
(4, '[/发呆]', '4.gif', ' '),
(5, '[/得意]', '5.gif', ' '),
(6, '[/流泪]', '6.gif', ' '),
(7, '[/害羞]', '7.gif', ' '),
(8, '[/闭嘴]', '8.gif', ' '),
(9, '[/睡]', '9.gif', ' '),
(10, '[/大哭]', '10.gif', ' '),
(11, '[/尴尬]', '11.gif', ' '),
(12, '[/发怒]', '12.gif', ' '),
(13, '[/调皮]', '13.gif', ' '),
(14, '[/龇牙]', '14.gif', ' '),
(15, '[/惊讶]', '15.gif', ' '),
(16, '[/难过]', '16.gif', ' '),
(17, '[/酷]', '17.gif', ' '),
(18, '[/冷汗]', '18.gif', ' '),
(19, '[/抓狂]', '19.gif', ' '),
(20, '[/吐]', '20.gif', ' '),
(21, '[/偷笑]', '21.gif', ' '),
(22, '[/可爱]', '22.gif', ' '),
(23, '[/白眼]', '23.gif', ' '),
(24, '[/傲慢]', '24.gif', ' '),
(25, '[/饥饿]', '25.gif', ' '),
(26, '[/困]', '26.gif', ' '),
(27, '[/惊恐]', '27.gif', ' '),
(28, '[/流汗]', '28.gif', ' '),
(29, '[/憨笑]', '29.gif', ' '),
(30, '[/大兵]', '30.gif', ' '),
(31, '[/奋斗]', '31.gif', ' '),
(32, '[/咒骂]', '32.gif', ' '),
(33, '[/疑问]', '33.gif', ' '),
(34, '[/嘘]', '34.gif', ' '),
(35, '[/晕]', '35.gif', ' '),
(36, '[/折磨]', '36.gif', ' '),
(37, '[/衰]', '37.gif', ' '),
(38, '[/骷髅]', '38.gif', ' '),
(39, '[/敲打]', '39.gif', ' '),
(40, '[/再见]', '40.gif', ' '),
(41, '[/擦汗]', '41.gif', ' '),
(42, '[/抠鼻]', '42.gif', ' '),
(43, '[/鼓掌]', '43.gif', ' '),
(44, '[/糗大了]', '44.gif', ' '),
(45, '[/坏笑]', '45.gif', ' '),
(46, '[/左哼哼]', '46.gif', ' '),
(47, '[/右哼哼]', '47.gif', ' '),
(48, '[/打哈欠]', '48.gif', ' '),
(49, '[/鄙视]', '49.gif', ' '),
(50, '[/委屈]', '50.gif', ' '),
(51, '[/快哭了]', '51.gif', ' '),
(52, '[/阴险]', '52.gif', ' '),
(53, '[/亲亲]', '53.gif', ' '),
(54, '[/吓]', '54.gif', ' '),
(55, '[/可怜]', '55.gif', ' '),
(56, '[/菜刀]', '56.gif', ' '),
(57, '[/西瓜]', '57.gif', ' '),
(58, '[/啤酒]', '58.gif', ' '),
(59, '[/篮球]', '59.gif', ' '),
(60, '[/乒乓球]', '60.gif', ' '),
(61, '[/咖啡]', '61.gif', ' '),
(62, '[/饭]', '62.gif', ' '),
(63, '[/猪头]', '63.gif', ' '),
(64, '[/玫瑰]', '64.gif', ' '),
(65, '[/凋谢]', '65.gif', ' '),
(66, '[/嘴唇]', '66.gif', ' '),
(67, '[/爱心]', '67.gif', ' '),
(68, '[/心碎]', '68.gif', ' '),
(69, '[/蛋糕]', '69.gif', ' '),
(70, '[/闪电]', '70.gif', ' '),
(71, '[/炸弹]', '71.gif', ' '),
(72, '[/匕首]', '72.gif', ' '),
(73, '[/足球]', '73.gif', ' '),
(74, '[/瓢虫]', '74.gif', ' '),
(75, '[/便便]', '75.gif', ' '),
(76, '[/月亮]', '76.gif', ' '),
(77, '[/太阳]', '77.gif', ' '),
(78, '[/礼物]', '78.gif', ' '),
(79, '[/拥抱]', '79.gif', ' '),
(80, '[/强]', '80.gif', ' '),
(81, '[/弱]', '81.gif', ' '),
(82, '[/握手]', '82.gif', ' '),
(83, '[/胜利]', '83.gif', ' '),
(84, '[/抱拳]', '84.gif', ' '),
(85, '[/勾引]', '85.gif', ' '),
(86, '[/拳头]', '86.gif', ' '),
(87, '[/差劲]', '87.gif', ' '),
(88, '[/爱你]', '88.gif', ' '),
(89, '[/no]', '89.gif', ' '),
(90, '[/ok]', '90.gif', ' ');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_topics`
--

CREATE TABLE IF NOT EXISTS `phpbb_topics` (
  `topic_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `forum_id` smallint(8) unsigned NOT NULL DEFAULT '0',
  `topic_title` char(60) NOT NULL,
  `topic_poster` mediumint(8) NOT NULL DEFAULT '0',
  `topic_time` int(11) NOT NULL DEFAULT '0',
  `topic_views` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `topic_replies` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `topic_status` tinyint(3) NOT NULL DEFAULT '0',
  `topic_vote` tinyint(1) NOT NULL DEFAULT '0',
  `topic_type` tinyint(3) NOT NULL DEFAULT '0',
  `topic_first_post_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `topic_last_post_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `topic_moved_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `topic_attachment` tinyint(1) NOT NULL DEFAULT '0',
  `topic_closed` mediumint(8) NOT NULL DEFAULT '0',
  `topic_color` varchar(6) DEFAULT NULL,
  `topic_marrow` tinyint(1) DEFAULT '0',
  `topic_class` mediumint(8) DEFAULT '0',
  PRIMARY KEY (`topic_id`),
  KEY `forum_id` (`forum_id`),
  KEY `topic_moved_id` (`topic_moved_id`),
  KEY `topic_status` (`topic_status`),
  KEY `topic_type` (`topic_type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=55 ;

--
-- 转存表中的数据 `phpbb_topics`
--

INSERT INTO `phpbb_topics` (`topic_id`, `forum_id`, `topic_title`, `topic_poster`, `topic_time`, `topic_views`, `topic_replies`, `topic_status`, `topic_vote`, `topic_type`, `topic_first_post_id`, `topic_last_post_id`, `topic_moved_id`, `topic_attachment`, `topic_closed`, `topic_color`, `topic_marrow`, `topic_class`) VALUES
(4, 7, '招聘论坛版主和管理员', 1, 1402405446, 27, 0, 0, 0, 0, 5, 5, 0, 0, 0, NULL, 0, 0),
(7, 2, '越狱大神树人表示 iOS 8目前可以越狱', -1, 1402410149, 13, 0, 0, 0, 0, 8, 8, 0, 0, 0, NULL, 0, 0),
(10, 2, '手机，让无处不在', -1, 1402472283, 34, 0, 1, 0, 0, 11, 11, 0, 0, 2, NULL, 0, 0),
(11, 4, '我水', -1, 1402474909, 17, 6, 0, 0, 0, 12, 19, 0, 0, 0, NULL, 0, 0),
(15, 5, '朋友，你好吗', -1, 1402487988, 30, 2, 0, 0, 0, 22, 27, 0, 0, 0, NULL, 1, 0),
(53, 2, 'Cydia已更新至1.1.10: 更好地兼容于iOS 7', -1, 1402612696, 42, 0, 0, 0, 0, 63, 63, 0, 1, 0, NULL, 1, 0);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_topics_watch`
--

CREATE TABLE IF NOT EXISTS `phpbb_topics_watch` (
  `topic_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_id` mediumint(8) NOT NULL DEFAULT '0',
  `notify_status` tinyint(1) NOT NULL DEFAULT '0',
  KEY `topic_id` (`topic_id`),
  KEY `user_id` (`user_id`),
  KEY `notify_status` (`notify_status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_topic_collect`
--

CREATE TABLE IF NOT EXISTS `phpbb_topic_collect` (
  `tc_id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `tc_topic` mediumint(8) NOT NULL,
  `tc_user` mediumint(8) NOT NULL,
  `tc_title` varchar(255) NOT NULL,
  PRIMARY KEY (`tc_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_ucp_main`
--

CREATE TABLE IF NOT EXISTS `phpbb_ucp_main` (
  `um_id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `um_user` mediumint(8) NOT NULL,
  `um_name` varchar(255) NOT NULL,
  `um_header` text NOT NULL,
  `um_body` text NOT NULL,
  PRIMARY KEY (`um_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- 转存表中的数据 `phpbb_ucp_main`
--

INSERT INTO `phpbb_ucp_main` (`um_id`, `um_user`, `um_name`, `um_header`, `um_body`) VALUES
(5, 2, 'Crazy', '&lt;link href=&quot;./template/theme/style.css&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot; media=&quot;screen, projection&quot;/&gt; \r\n         &lt;link rel=&quot;shortcut icon&quot; href=&quot; /favicon.ico&quot; /&gt;\r\n         &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width; initial-scale=1.0; minimum-scale=1.0; maximum-scale=2.0&quot; /&gt;\r\n          &lt;meta name=&quot;apple-mobile-web-app-capable&quot; content=&quot;yes&quot; /&gt;\r\n          &lt;meta name=&quot;apple-mobile-web-app-status-bar-style&quot; content=&quot;black&quot; /&gt;\r\n         &lt;style type=&quot;text/css&quot;&gt;\r\n           .square{width:20%;float: left;text-align: center;}\r\n          &lt;/style&gt;', '&lt;div id=&quot;wrap&quot;&gt;&lt;header&gt;&lt;a href=&quot;./&quot;/&gt;&lt;img src=&quot;./images/logo.png&quot; alt=&quot;.&quot; title=&quot;Logo&quot;/&gt;&lt;/a&gt;&lt;/header&gt;&lt;div id=&quot;main&quot;&gt;&lt;div class=&quot;module box&quot;&gt;欢迎使用用户空间主页功能，当看到这个页面时表示您已经开通了空间主页功能！&lt;/div&gt;&lt;/div&gt;&lt;footer&gt;&lt;div class=&quot;index_bottom&quot;&gt;版权所有 (c) Crazy&lt;/div&gt;&lt;/footer&gt;&lt;/div&gt;');

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_users`
--

CREATE TABLE IF NOT EXISTS `phpbb_users` (
  `user_id` mediumint(8) NOT NULL,
  `user_active` tinyint(1) DEFAULT '1',
  `username` varchar(25) NOT NULL,
  `user_password` varchar(32) NOT NULL,
  `user_session_time` int(11) NOT NULL DEFAULT '0',
  `user_session_page` smallint(5) NOT NULL DEFAULT '0',
  `user_lastvisit` int(11) NOT NULL DEFAULT '0',
  `user_regdate` int(11) NOT NULL DEFAULT '0',
  `user_level` tinyint(4) DEFAULT '0',
  `user_posts` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_timezone` decimal(5,2) NOT NULL DEFAULT '0.00',
  `user_dateformat` varchar(14) NOT NULL DEFAULT 'Y m d H:i',
  `user_new_privmsg` smallint(5) unsigned NOT NULL DEFAULT '0',
  `user_unread_privmsg` smallint(5) unsigned NOT NULL DEFAULT '0',
  `user_last_privmsg` int(11) NOT NULL DEFAULT '0',
  `user_login_tries` smallint(5) unsigned NOT NULL DEFAULT '0',
  `user_last_login_try` int(11) NOT NULL DEFAULT '0',
  `user_emailtime` int(11) DEFAULT NULL,
  `user_viewemail` tinyint(1) DEFAULT NULL,
  `user_attachsig` tinyint(1) DEFAULT NULL,
  `user_allowhtml` tinyint(1) DEFAULT '1',
  `user_allowbbcode` tinyint(1) DEFAULT '1',
  `user_allowsmile` tinyint(1) DEFAULT '1',
  `user_allowavatar` tinyint(1) NOT NULL DEFAULT '1',
  `user_allow_pm` tinyint(1) NOT NULL DEFAULT '1',
  `user_allow_viewonline` tinyint(1) NOT NULL DEFAULT '1',
  `user_notify_to_email` tinyint(1) NOT NULL DEFAULT '1',
  `user_notify_to_pm` tinyint(1) NOT NULL DEFAULT '1',
  `user_notify_pm` tinyint(1) NOT NULL DEFAULT '0',
  `user_popup_pm` tinyint(1) NOT NULL DEFAULT '0',
  `user_rank` int(11) DEFAULT '0',
  `user_avatar` varchar(100) DEFAULT NULL,
  `user_avatar_type` tinyint(4) NOT NULL DEFAULT '0',
  `user_email` varchar(255) DEFAULT NULL,
  `user_qq` varchar(15) DEFAULT NULL,
  `user_number` varchar(15) DEFAULT NULL,
  `user_website` varchar(100) DEFAULT NULL,
  `user_from` varchar(100) DEFAULT NULL,
  `user_sig` text,
  `user_sig_bbcode_uid` char(10) DEFAULT NULL,
  `user_aim` varchar(255) DEFAULT NULL,
  `user_yim` varchar(255) DEFAULT NULL,
  `user_msnm` varchar(255) DEFAULT NULL,
  `user_occ` varchar(100) DEFAULT NULL,
  `user_interests` varchar(255) DEFAULT NULL,
  `user_actkey` varchar(32) DEFAULT NULL,
  `user_newpasswd` varchar(32) DEFAULT NULL,
  `user_warnings` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `user_topics_per_page` tinyint(2) NOT NULL DEFAULT '15',
  `user_posts_per_page` tinyint(2) NOT NULL DEFAULT '15',
  `user_birthday` int(11) NOT NULL DEFAULT '999999',
  `user_next_birthday_greeting` int(11) NOT NULL DEFAULT '0',
  `user_gender` tinyint(4) NOT NULL DEFAULT '0',
  `user_on_off` tinyint(4) NOT NULL DEFAULT '1',
  `user_attach_mod` tinyint(4) NOT NULL DEFAULT '1',
  `user_nic_color` varchar(100) NOT NULL DEFAULT '',
  `user_quick_answer` tinyint(4) NOT NULL DEFAULT '0',
  `user_index_spisok` tinyint(4) NOT NULL DEFAULT '0',
  `user_zvanie` varchar(50) DEFAULT '',
  `user_purse` varchar(50) DEFAULT '',
  `user_points` int(100) NOT NULL DEFAULT '0',
  `user_post_leng` smallint(6) NOT NULL DEFAULT '0',
  `time_last_click` int(12) DEFAULT '0',
  `user_posl_red` tinyint(4) NOT NULL DEFAULT '1',
  `user_java_otv` tinyint(4) NOT NULL DEFAULT '0',
  `user_bb_panel` tinyint(4) NOT NULL DEFAULT '0',
  `user_report_optout` tinyint(1) NOT NULL DEFAULT '0',
  `user_message_quote` tinyint(1) NOT NULL DEFAULT '1',
  `user_view_latest_post` tinyint(1) NOT NULL DEFAULT '0',
  `user_style` mediumint(8) DEFAULT '1',
  `qq_openid` varchar(32) NOT NULL DEFAULT '',
  `user_email_new_gb` tinyint(1) NOT NULL DEFAULT '0',
  `user_can_gb` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`user_id`),
  KEY `user_session_time` (`user_session_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `phpbb_users`
--

INSERT INTO `phpbb_users` (`user_id`, `user_active`, `username`, `user_password`, `user_session_time`, `user_session_page`, `user_lastvisit`, `user_regdate`, `user_level`, `user_posts`, `user_timezone`, `user_dateformat`, `user_new_privmsg`, `user_unread_privmsg`, `user_last_privmsg`, `user_login_tries`, `user_last_login_try`, `user_emailtime`, `user_viewemail`, `user_attachsig`, `user_allowhtml`, `user_allowbbcode`, `user_allowsmile`, `user_allowavatar`, `user_allow_pm`, `user_allow_viewonline`, `user_notify_to_email`, `user_notify_to_pm`, `user_notify_pm`, `user_popup_pm`, `user_rank`, `user_avatar`, `user_avatar_type`, `user_email`, `user_qq`, `user_number`, `user_website`, `user_from`, `user_sig`, `user_sig_bbcode_uid`, `user_aim`, `user_yim`, `user_msnm`, `user_occ`, `user_interests`, `user_actkey`, `user_newpasswd`, `user_warnings`, `user_topics_per_page`, `user_posts_per_page`, `user_birthday`, `user_next_birthday_greeting`, `user_gender`, `user_on_off`, `user_attach_mod`, `user_nic_color`, `user_quick_answer`, `user_index_spisok`, `user_zvanie`, `user_purse`, `user_points`, `user_post_leng`, `time_last_click`, `user_posl_red`, `user_java_otv`, `user_bb_panel`, `user_report_optout`, `user_message_quote`, `user_view_latest_post`, `user_style`, `qq_openid`, `user_email_new_gb`, `user_can_gb`) VALUES
(-1, 0, '匿名用户', '', 0, 0, 0, 1402364852, 0, 0, '0.00', '', 0, 0, 1402689893, 0, 0, NULL, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, NULL, '', 0, '', '', NULL, '', '', '', NULL, '', '', '', '', '', '', '', 0, 15, 15, 999999, 0, 0, 1, 1, '', 0, 0, '', '', 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, '', 0, 1),
(1, 1, 'admin', '21232f297a57a5a743894a0e4a801fc3', 1402788309, -19, 1402788268, 1402364852, 1, 1, '0.00', 'Y年m月d日 H:i', 0, 0, 1402689893, 0, 0, NULL, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, '', 0, 'admin@zhangyun.org', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 15, 15, 999999, 0, 0, 1, 1, '', 0, 0, '', '', 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, '', 0, 1);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_user_group`
--

CREATE TABLE IF NOT EXISTS `phpbb_user_group` (
  `group_id` mediumint(8) NOT NULL DEFAULT '0',
  `user_id` mediumint(8) NOT NULL DEFAULT '0',
  `user_pending` tinyint(1) DEFAULT NULL,
  KEY `group_id` (`group_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `phpbb_user_group`
--

INSERT INTO `phpbb_user_group` (`group_id`, `user_id`, `user_pending`) VALUES
(1, -1, 0),
(2, 1, 0);

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_vote_desc`
--

CREATE TABLE IF NOT EXISTS `phpbb_vote_desc` (
  `vote_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `topic_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vote_text` text NOT NULL,
  `vote_start` int(11) NOT NULL DEFAULT '0',
  `vote_length` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`vote_id`),
  KEY `topic_id` (`topic_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_vote_results`
--

CREATE TABLE IF NOT EXISTS `phpbb_vote_results` (
  `vote_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vote_option_id` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `vote_option_text` varchar(255) NOT NULL,
  `vote_result` int(11) NOT NULL DEFAULT '0',
  KEY `vote_option_id` (`vote_option_id`),
  KEY `vote_id` (`vote_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_vote_voters`
--

CREATE TABLE IF NOT EXISTS `phpbb_vote_voters` (
  `vote_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vote_user_id` mediumint(8) NOT NULL DEFAULT '0',
  `vote_user_ip` char(8) NOT NULL,
  KEY `vote_id` (`vote_id`),
  KEY `vote_user_id` (`vote_user_id`),
  KEY `vote_user_ip` (`vote_user_ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `phpbb_words`
--

CREATE TABLE IF NOT EXISTS `phpbb_words` (
  `word_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `word` char(100) NOT NULL,
  `replacement` char(100) NOT NULL,
  PRIMARY KEY (`word_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

