<?php
class Home_Service_Common extends Home_Service_Base{

	#获取默认apps路径
	function getDefaultDirectory(){
		$defaultAppName = Zend_Controller_Front::getInstance()->getDefaultModule();
		return Zend_Controller_Front::getInstance()->getModuleDirectory($defaultAppName);
	}

	#获取网站名称
	function getSiteName(){
		$config = My_Config::getInstance()->getInit();
		return $config['appname'];
	}

	#检查验证码
	function checkCaptcha($captcha){
		My_Tool::importOpen("php_verify/verify.php");
		$session = new My_Session_Namespace(YL_Security_Secoder::$seKey);
		$code = $session->code;
		if(strtolower($code) == strtolower($captcha)) return true;
		return false;
	}

	#获取app路径
	function getAppPath($appName=''){
		if($appName){
			$appName = strtolower($appName);
			return Zend_Controller_Front::getInstance()->getModuleDirectory($appName);
		}else{
			return Zend_Controller_Front::getInstance()->getModuleDirectory();
		}
	}

	#清空app文件
	function clearAppFile($appName){
		$appName = strtolower($appName);
		$path = APPLICATION_PATH . DS.$appName;
		My_Tool_File::deldir($path);
		$resPath = ROOT_DIR."/res/asset/" . $appName;
		My_Tool_File::deldir($resPath);
		$libPath = ROOT_LIB."/".ucfirst($appName);
		My_Tool_File::deldir($libPath);
		$configPath = ROOT_DIR."/configs/" . $appName;
		My_Tool_File::deldir($configPath);
		return true;
	}

	#卸载
	function uninstall($appName){
		if(!$appName) return false;
		set_time_limit(0);
 		$appPath = $this->getAppPath($appName);
		$sqlPath = $appPath."/data/sql/uninstall.sql";
		if(is_file($sqlPath)){
			My_Tool::importOpen("Install.class.php");
			$sqlArr = FInstall::mysql($sqlPath);
			if($sqlArr){
				foreach ($sqlArr as $sv){
					Home::dao()->getCommon()->exec($sv, array(), 0);
				}
			}
		}
		//删除文件
		$this->clearAppFile($appName);
		return true;
	}

	#安装
	function install($appName){
		if(!$appName) return false;
		set_time_limit(0);
 		$appPath = APPLICATION_PATH . DS. strtolower($appName);
		$sqlPath = $appPath."/data/sql/install.sql";
		if(is_file($sqlPath)){
		    $txt = file_get_contents($sqlPath);
		    if(!$txt) return true;
			My_Tool::importOpen("Install.class.php");
			$sqlArr = FInstall::mysql($sqlPath);
			if($sqlArr){
				foreach ($sqlArr as $sv){
					Home::dao()->get()->exec($sv, array(), 0);
				}
			}
 		}
		return true;
	}

	#上传图片
	function upImg($savePath){
	 	$upload = new My_Tool_Upload();
		//设置上传文件大小
		$upload->maxSize=1024*1024*1;//最大1M
		//设置上传文件类型
		$upload->allowExts  = explode(',','jpg,png,jpeg,bmp');
		//设置附件上传目录
		$upload->savePath = $savePath;
		if(!is_dir($upload->savePath)) mkdir($upload->savePath, 0777, true);
		$upload->saveRule = "uniqid";
		if(!$upload->upload())
		 {
			 $appName = Zend_Controller_Front::getInstance()->getRequest()->getModuleName();
			 $isAdmin = $appName == 'admin' ? 1:0;
			 if($isAdmin){
				//捕获上传异常
				Admin_Tool::showMsg("上传失败，只支持jpg,png,jpeg,bmp格式，大小不大于1M的图片，请重新上传!");
			 }else{
				 //捕获上传异常
				 Admin_Tool::showMsg("上传失败，只支持jpg,png,jpeg,bmp格式，大小不大于1M的图片，请重新上传!");
			 }
		}
		else
		{
			//取得成功上传的文件信息
			$info = $upload->getUploadFileInfo();
			return $info;
	    }
	}

	#裁剪图片
	function cutImg($oldPath, $newPath, $sizes=array("160x160","48x48", "24x24","330x235")){
		foreach ($sizes as $v){
			list($w, $h) = explode('x', $v);
			My_Tool_Image::makethumb($oldPath, $newPath."_".$w."x".$w.".jpg",$w,$h);
		}
		$savepath = str_replace(ROOT_DIR, "", $newPath);
		$savepath = str_replace('\\', '/', $newPath);
		return $savepath;
	}

	//保存系统配置
	function saveSysData($key,$content){
		if(!$key) return My_Tool::errorReturn("系统配置参数为空!");
		$info = Home::dao()->getSysdata()->get(array("sys_key"=>$key));
		if($info){
			$data['sys_content'] = serialize($content);
			return Home::dao()->getSysdata()->update($data,array("id"=>$info['id']));
		}else{
			$data['sys_key'] = $key;
			$data['sys_content'] = serialize($content);
			$data['created_at'] = date('Y-m-d H:i:s',time());
			return Home::dao()->getSysdata()->insert($data);
		}
	}

	//获取系统配置
	function getSysData($key){
		if(!$key) return My_Tool::errorReturn("系统配置参数为空!");
		$cache = 0;
		if(!isDebug()){
			$sysDataKey = "sysdata_".$key;
			$cache = My_Cache::get($sysDataKey);
		}

		if($cache){
			$info = $cache;
		}else{
            $info = array();
            $sysDefault = array();
            if(My_Init::$isInstall){
			    $info = Home::dao()->getSysdata()->get(array("sys_key"=>$key));
            }
			if(!$info){
				$sysDefault = My::config()->getSysdataDefault();
				$karr = explode('.',$key);
				$str = '$sysDefault';
				foreach($karr as $v){
					$str .= '["'.$v.'"]';
				}
				$configTmp = "";
				$str = "if(isset(".$str.")) \$configTmp=".$str.";";
				eval($str);
				$configRs = $configTmp?$configTmp:"";
				return $configRs;
			} 
			My_Cache::set($sysDataKey,$info);
		}
		return unserialize($info['sys_content']);
	}
	
	//清空数据库数据缓存
	function clearDbCache(){
		$list = Home::dao()->getSysdata()->gets();
		if(!$list) return false;
		foreach($list as $v){
			$key = "sysdata_".$v['sys_key'];
			My_Cache::delete($key);
		}
		return true;
	}

	//内容是否需要审核
	function contentNeedCheck(){
		$key = "site.config.content.is.check";
		$info = Home::dao()->getSysdata()->get(array("sys_key"=>$key));
		if(!$info) return 1;//默认需要审核
		return unserialize($info['sys_content'])?0:1;
	}
	
	function clearAllCache(){
		Admin::service()->getSys()->clearCache();
		Admin::service()->getSys()->scannerActions();
		Home::service()->getCommon()->clearDbCache();
	}


}