<?php
class Home_Service_Ucenter extends Home_Service_Base{
	const UC_IS_OPEN_KEY = "uc.config.is.open";
	private $isOpen = 0;
	function __construct(){
		$this->isOpen = Home::service()->getCommon()->getSysData(self::UC_IS_OPEN_KEY);
		if($this->isOpen){
			include_once PUBLIC_DIR.'/api/config.inc.php';
			include_once PUBLIC_DIR.'/api/uc_client/client.php';
		}else{
			return true;
		}
	}
	
	function isOpen(){
		return $this->isOpen;
	}
	
	//注册
	function uc_user_register($nickname, $pwd, $username,$uid){
		$ucuid = uc_user_register($nickname, $pwd, $username);
		if($ucuid){
			User::dao()->getInfo()->update(array("uc_uid"=>$ucuid),array("id"=>$uid));
		}else{
				if($uid == -1) {
					return My_Tool::errorReturn('用户名不合法');
				} elseif($uid == -2) {
					return My_Tool::errorReturn('包含要允许注册的词语');
				} elseif($uid == -3) {
					return My_Tool::errorReturn('用户名已经存在');
				} elseif($uid == -4) {
					return My_Tool::errorReturn('Email 格式有误');
				} elseif($uid == -5) {
					return My_Tool::errorReturn('Email 不允许注册');
				} elseif($uid == -6) {
					return My_Tool::errorReturn('该 Email 已经被注册');
				} else {
					return My_Tool::errorReturn('未定义错误');
				}
		}
		return true;
	}
	
	//登录
	function uc_user_login($username, $pwd,$isuid=2){
		list($ucuid, $username, $password, $email) = uc_user_login($username, $pwd,$isuid);
		User::dao()->getInfo()->update(array("uc_synlogin"=>0),array("uc_uid"=>$ucuid));
		User::dao()->getInfo()->update(array("uc_synlogout"=>1),array("uc_uid"=>$ucuid));
		
		return array($ucuid, $username, $password, $email);
	}
	
	//获取用户数据
	function uc_get_user($ucuid){
		if(!$this->isOpen) return true; 
		if(!$ucuid) return false;
		$info = uc_get_user($ucuid,1);
		return $info;
	}
	
	//修改用户数据
	function uc_user_edit($uid,$oldpw='',$newpw='',$username='',$ignoreoldpw=1){
		if(!$this->isOpen) return true; 
		$info = User::dao()->getInfo()->get(array("id"=>$uid));
		if(!$username) $username = $info['nickname'];
		$email = $info['username'];
		$result = uc_user_edit($username , $oldpw , $newpw , $email,$ignoreoldpw);
		if($result == 1) return true;
		exit($result);
		if($result == -1) {
			return My_Tool::errorReturn('旧密码不正确');
		} elseif($uid == -4) {
			return My_Tool::errorReturn('Email 格式有误');
		} elseif($uid == -5) {
			return My_Tool::errorReturn('Email 不允许注册');
		} elseif($uid == -6) {
			return My_Tool::errorReturn('该 Email 已经被注册');
		} elseif($uid == -8) {
			return My_Tool::errorReturn('该用户受保护无权限更改');
		}else{
			return My_Tool::errorReturn('未定义错误');
		}
	}
	
	//删除用户
	function uc_user_delete($ucuid){
		if(!$this->isOpen) return true; 
		$rs = uc_user_delete($ucuid);
		return $rs;
	}
	
	//同步登录
	function uc_user_synlogin($ucuid){
		if(!$this->isOpen) return ""; 
		if(!$ucuid) return "";
		$info = User::dao()->getInfo()->get(array("uc_uid"=>$ucuid));
		if(!$info) return "";
		if($info['uc_synlogin']) return "";
		$rs = uc_user_synlogin($ucuid);
		if($rs){
			User::dao()->getInfo()->update(array("uc_synlogin"=>1),array("uc_uid"=>$ucuid));
			User::dao()->getInfo()->update(array("uc_synlogout"=>1),array("uc_uid"=>$ucuid));
		}
		return $rs;
	}
	
	//同步登出
	function uc_user_synlogout($ucuid){
		if(!$this->isOpen) return ""; 
		if(!$ucuid) return "";
		$info = User::dao()->getInfo()->get(array("uc_uid"=>$ucuid));
		if(!$info) return "";
		if($info['uc_synlogout']) return "";
		$rs = uc_user_synlogout();
		User::dao()->getInfo()->update(array("uc_synlogout"=>1),array("uc_uid"=>$ucuid));
		User::dao()->getInfo()->update(array("uc_synlogin"=>1),array("uc_uid"=>$ucuid));
		return $rs;
	}
	
	//检查email
	function uc_user_checkemail($email){
		if(!$this->isOpen) return true; 
		$ucresult = uc_user_checkemail($email);
		if($ucresult >0) return true;
		if($ucresult == -4) {
			return My_Tool_Error::add('Email 格式有误');
		} elseif($ucresult == -5) {
			return My_Tool_Error::add('Email 不允许注册');
		} elseif($ucresult == -6) {
			return My_Tool_Error::add('该 Email 已经被注册');
		}else{
			return My_Tool_Error::add('未定义错误');
		}
	}
	
	function uc_user_checkname($username){
		if(!$this->isOpen) return true;
		$ucresult = uc_user_checkname($username);
		if($ucresult >0) return true;
		if($ucresult == -1) {
			return My_Tool_Error::add('用户名不合法');
		} elseif($ucresult == -2) {
			return My_Tool_Error::add('包含要允许注册的词语');
		} elseif($ucresult == -3) {
			return My_Tool_Error::add('用户名已经存在');
		}else{
			return My_Tool_Error::add('未定义错误');
		}
	}
	
}