<?php
/*============================*\
|| ###########################||
|| # vBulletin PHPFORCEǿ#||
|| # -------------------------||
|| # http://www.phpforce.cn  #||
|| ###########################||
\*============================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('user', 'cpuser', 'cprank');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminusers'))
{
	print_cp_no_permission();
}

// ############################# LOG ACTION ###############################
log_admin_action(iif($_REQUEST['onlinerankid'] != 0, "onlinerank id = $_REQUEST[onlinerankid]"));

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['onlinerank_manager']);


if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'modify';
}

// ###################### Start add #######################
if ($_REQUEST['do'] == 'add')
{
	// Add multiple
	print_form_header('onlinetime', 'insert');
	print_table_header($vbphrase['add_new_onlinerank']);
	print_input_row($vbphrase['onlinerank_max_num'], 'onlinerankmaxnum', '3');
	print_input_row($vbphrase['onlinerank_level'], 'onlineranklevel', '');
	print_input_row($vbphrase['onlinerank_file_path'], 'onlinerankpath', 'images/');
	print_submit_row($vbphrase['save']);
}

// ###################### Start insert #######################
if ($_POST['do'] == 'insert')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'onlinerankmaxnum' => TYPE_INT,
		'onlineranklevel' => TYPE_INT,
		'onlinerankpath' => TYPE_STR,
		'doinsert' => TYPE_STR,
	));
	
	if (!$vbulletin->GPC['onlinerankmaxnum'] OR !$vbulletin->GPC['onlineranklevel'])
	{
		if ($vbulletin->GPC['doinsert'])
		{
			echo '<p><b>' . $vbphrase['invalid_file_path_specified'] . '</b></p>';
			$onlinerankpath = $vbulletin->GPC['doinsert'];
		}
		else
		{
			print_stop_message('please_complete_required_fields');
		}

	}

	$onlinerankpath = preg_replace('/\/$/s', '', $vbulletin->GPC['onlinerankpath']);
	if($dirhandle = @opendir('./' . $onlinerankpath))
	{ // Valid directory!
		chdir('./' . $onlinerankpath);
		readdir($dirhandle);
		readdir($dirhandle);
		while ($filename = readdir($dirhandle))
		{
			$onlinerankname = $onlinerankpath . '/' . $filename;
			if (@is_file($filename) AND (($filelen = strlen($filename)) >= 5))
			{
				$fileext = strtolower(substr($filename, $filelen - 4, $filelen - 1));
				if ($fileext == '.gif' OR $fileext == '.bmp' OR $fileext == '.jpg' OR $fileext == 'jpeg' OR $fileext == 'png')
				{
					$FileArray[] = addslashes($filename);
				}
			}
		}
		if (!is_array($FileArray))
		{
		  	print_stop_message('no_matches_found');
		}

		print_form_header('onlinetime', 'insert', 0, 1, 'name', '');
		print_table_header($vbphrase['images']);
		construct_hidden_code('onlinerankmaxnum', $vbulletin->GPC['onlinerankmaxnum']);
		construct_hidden_code('onlineranklevel', $vbulletin->GPC['onlineranklevel']);
		construct_hidden_code('doinsert', $vbulletin->GPC['onlinerankpath']);
		foreach ($FileArray AS $key => $val)
		{
			print_yes_row("<img src='../$onlinerankpath/$val' border='0' alt='' align='center' />", 'onlinerankpath', '', '', "$onlinerankpath/$val");
		}
		print_submit_row($vbphrase['save']);
		closedir($dirhandle);
		exit;
	}
	else
	{ // Not a valid dir so assume it is a filename
		if (!(@is_file('./' . $onlinerankpath)))
		{
			print_stop_message('invalid_file_path_specified');
		}
	}

	$db->query("
		INSERT INTO " . TABLE_PREFIX . "onlineranks
		(onlinerankimg, maxnum, onlineranklevel)
		VALUES
		('" . addslashes($onlinerankpath) . "', '".$vbulletin->GPC['onlinerankmaxnum']."', '".$vbulletin->GPC['onlineranklevel']."')
	");
	
	build_onlineranks();
	define('CP_REDIRECT', 'onlinetime.php?do=modify');
	print_stop_message('saved_onlinerank_successfully');
}

// ###################### Start edit #######################
if ($_REQUEST['do'] == 'edit')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'onlinerankid' 	=> TYPE_INT
	));

	$onlinerank = $db->query_first("
					SELECT onlineranks.*
					FROM " . TABLE_PREFIX . "onlineranks AS onlineranks
					WHERE onlinerankid = ".$vbulletin->GPC['onlinerankid']."
	");

	print_form_header('onlinetime', 'doupdate');
	construct_hidden_code('onlinerankid', $onlinerank['onlinerankid']);
	print_table_header(construct_phrase($vbphrase['x_y_id_z'], $vbphrase['online_rank'], '', $onlinerank['onlinerankid']));
	print_input_row($vbphrase['onlinerank_max_num'], 'onlinerankmaxnum', $onlinerank['maxnum']);
	print_input_row($vbphrase['onlinerank_level'], 'onlineranklevel', $onlinerank['onlineranklevel']);
	print_input_row($vbphrase['onlinerank_file_path'], 'onlinerankpath', $onlinerank['onlinerankimg']);
 	print_submit_row();
}

// ###################### Start do update #######################
if ($_POST['do'] == 'doupdate')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'onlinerankid' => TYPE_INT,
		'onlinerankmaxnum' => TYPE_INT,
		'onlineranklevel' => TYPE_INT,
		'onlinerankpath' => TYPE_STR,
	));

	if (!$vbulletin->GPC['onlinerankmaxnum'] OR !$vbulletin->GPC['onlineranklevel'])
	{
		print_stop_message('please_complete_required_fields');
	}

	if (!(@is_file('./' . $vbulletin->GPC['onlinerankpath'])))
	{
		print_stop_message('invalid_file_path_specified');
	}

	$db->query("
		UPDATE " . TABLE_PREFIX . "onlineranks
  		SET onlineranklevel = ".$vbulletin->GPC['onlineranklevel'].",
			maxnum = ".$vbulletin->GPC['onlinerankmaxnum'].",
			onlinerankimg = '" . addslashes($vbulletin->GPC['onlinerankpath']) . "'
  		WHERE onlinerankid = ".$vbulletin->GPC['onlinerankid']."
	");
  	
	build_onlineranks();

	define('CP_REDIRECT', 'onlinetime.php?do=modify');
	print_stop_message('saved_onlinerank_successfully');
}
// ###################### Start Remove #######################

if ($_REQUEST['do'] == 'remove')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'onlinerankid' 	=> TYPE_INT
	));

	print_form_header('onlinetime', 'kill');
	construct_hidden_code('onlinerankid', $vbulletin->GPC['onlinerankid']);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row($vbphrase['are_you_sure_you_want_to_delete_this_onlinerank_image']);
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);

}

// ###################### Start Kill #######################

if ($_POST['do'] == 'kill')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'onlinerankid' => TYPE_INT,
	));

	$db->query("DELETE FROM " . TABLE_PREFIX . "onlineranks WHERE onlinerankid = ".$vbulletin->GPC['onlinerankid']."");

	build_onlineranks();

	define('CP_REDIRECT', 'onlinetime.php?do=modify');
	print_stop_message('deleted_onlinerank_successfully');
}

// ###################### Start modify #######################
if ($_REQUEST['do'] == 'modify')
{
	$onlineranks = $db->query("
		SELECT onlinerankid, onlinerankimg, maxnum, onlineranklevel
		FROM " . TABLE_PREFIX . "onlineranks AS onlineranks
		ORDER BY onlineranklevel
	");

	print_form_header('', '');
	print_table_header($vbphrase['onlinerank_manager']);
	print_description_row($vbphrase['onlinerank_desc'],'',0);
	print_table_footer();

	if ($db->num_rows($onlineranks) == 0)
	{
		print_stop_message('no_onlinerank_defined');
	}

	print_form_header('', '');

	print_table_header($vbphrase['images'], 4, 1);
	print_cells_row(array($vbphrase['onlinerank_levelnum'], $vbphrase['onlinerank_images'], $vbphrase['onlinerank_maxnum'], $vbphrase['controls']), 1, '', -1);
	while ($onlinerank = $db->fetch_array($onlineranks))
	{
		$onlinerankimg = "<img src=\"../$onlinerank[onlinerankimg]\" border=\"0\" alt=\"\" />";

		$cell = array(
			$onlinerank['onlineranklevel'],
			$onlinerankimg,
			vb_number_format($onlinerank['maxnum']),
			construct_link_code($vbphrase['edit'], "onlinetime.php?$session[sessionurl]do=edit&onlinerankid=$onlinerank[onlinerankid]") . construct_link_code($vbphrase['delete'], "onlinetime.php?$session[sessionurl]do=remove&onlinerankid=$onlinerank[onlinerankid]")
		);
		print_cells_row($cell, 0, '', -1);

	}
	print_table_footer();
echo "<center><a href=onlinetime.php?do=add>".$vbphrase['add_new_onlinerank']."</a></center>";
}
print_cp_footer();

function build_onlineranks()
{

	global $db;

	$onlineranks = $db->query("
		SELECT onlinerankid, onlinerankimg, maxnum, onlineranklevel
		FROM " . TABLE_PREFIX . "onlineranks AS onlineranks
		ORDER BY onlineranklevel
	");
	
	$tempoutput = "";
	$tempstep = 1;
	while ($onlinerank = $db->fetch_array($onlineranks))
	{
		if (!$firstimg)
		{
			$firstimg = $onlinerank['onlinerankimg'];
		}
		$lastimg = $onlinerank['onlinerankimg'];
		$lastmax = $onlinerank['maxnum']+1;

		$tempstepnext = ($onlinerank['maxnum']+1)*$tempstep;
		$tempout = "";
		$tempout .= "\t\$tempcount = 0;\n";
		$tempout .= "\twhile (\$tempcount++ < ".$onlinerank['maxnum'].")\n";
		$tempout .= "\t{\n";
		$tempout .= "\t\tif (\$temprank < ".$tempstepnext." AND \$temprank >= ".$tempstep.")\n";
		$tempout .= "\t\t{\n";
		$tempout .= "\t\t\t\$userinfo['onlinerankimg'] .= \"<img class=\\\"inlineimg\\\"src=\\\"".$onlinerank['onlinerankimg']."\\\" alt=\\\"级别:\".\$userinfo['onlinerank'].\" | 在线时长:\".\$userinfo['onlinehours'].\"小时 | 升级还需:\".\$userinfo['nextneedhours'].\"小时\\\" border=\\\"0\\\" />\";\n";
		$tempout .= "\t\t\t\$temprank = \$temprank - ".$tempstep.";\n";
		$tempout .= "\t\t}\n";
		$tempout .= "\t\telse\n";
		$tempout .= "\t\t{\n";
		$tempout .= "\t\t\tbreak;\n";
		$tempout .= "\t\t}\n";
		$tempout .= "\t}\n";
		$tempout .= "\n";
		
		$tempoutput = $tempout.$tempoutput;
		$tempstep = $tempstepnext;
	}

	$output = "";
	$output .= "\$userinfo['onlinehours'] = floor (\$userinfo['online_time']/3600);\n";
	$output .= "\$userinfo['onlinerank'] = floor (( \$vbulletin->options['onlstephours']/2 - \$vbulletin->options['onlstarthours'] + sqrt (pow (\$vbulletin->options['onlstarthours'] - \$vbulletin->options['onlstephours']/2, 2) + 2*\$vbulletin->options['onlstephours']*\$userinfo['onlinehours']) )/\$vbulletin->options['onlstephours'] );\n";
	$output .= "\$userinfo['nextneedhours'] = (\$vbulletin->options['onlstephours']/2*pow(\$userinfo['onlinerank'] + 1, 2) + (\$vbulletin->options['onlstarthours']-\$vbulletin->options['onlstephours']/2)*(\$userinfo['onlinerank'] + 1))-\$userinfo['onlinehours'];\n";
	$output .= "\n";
	$output .= "\$temprank = \$userinfo['onlinerank'];\n";
	$output .= "if (\$temprank > 0)\n";
	$output .= "{\n";

	$output .= $tempoutput;

	$output .= "\tif (\$temprank > ".$tempstep.")\n";
	$output .= "\t{\n";
	$output .= "\t\t\$tempcount = 0;\n";
	$output .= "\t\twhile (\$tempcount++ < ".$lastmax.")\n";
	$output .= "\t\t{\n";
	$output .= "\t\t\t\$userinfo['onlinerankimg'] .= \"<img class=\\\"inlineimg\\\"src=\\\"".$lastimg."\\\" alt=\\\"级别:\".\$userinfo['onlinerank'].\" | 在线时长:\".\$userinfo['onlinehours'].\"小时 | 升级还需:\".\$userinfo['nextneedhours'].\"小时\\\" border=\\\"0\\\" />\";\n";
	$output .= "\t\t}\n";
	$output .= "\t}\n";

	$output .= "}\n";
	$output .= "else\n";
	$output .= "{\n";
	$output .= "\t\$userinfo['onlinerankimg'] = \"<img class=\\\"inlineimg\\\"src=\\\"".$firstimg."\\\" style=\\\"filter:gray\\\" alt=\\\"级别:\".\$userinfo['onlinerank'].\" | 在线时长:\".\$userinfo['onlinehours'].\"小时 | 升级还需:\".\$userinfo['nextneedhours'].\"小时\\\" border=\\\"0\\\" />\";\n";
	$output .= "}\n";

	if ($output)
	{
		$output .= "\n";
	}

	build_datastore('onlinerankphp', $output);

}

/*========================================*\
|| ########################################
|| ########################################
\*========================================*/
?>
