<?php
/*============================*\
|| ###########################||
|| # vBulletin PHPFORCE增强包#||
|| # -------------------------||
|| # http://www.phpforce.cn  #||
|| ###########################||
\*============================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
//define('CVS_REVISION', '$RCSfile: pm.php,v $ - $Revision: 1.60 $');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('user', 'cpuser', 'messaging', 'cprofilefield');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_profilefield.php');
require_once(DIR . '/includes/adminfunctions_user.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminusers'))
{
	print_cp_no_permission();
}

// ############################# LOG ACTION ###############################
log_admin_action();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['pm_manager']);

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'start';
}

// *************************** Send a page of emails **********************
if ($_POST['do'] == 'dosendpm')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'user'              => TYPE_ARRAY,
		'profile'           => TYPE_ARRAY,
		'serializeduser'    => TYPE_STR,
		'serializedprofile' => TYPE_STR,
		'septext'           => TYPE_NOTRIM,
		'perpage'           => TYPE_UINT,
		'startat'           => TYPE_UINT,
		'test'              => TYPE_BOOL,
		'from'              => TYPE_STR,
		'subject'           => TYPE_STR,
		'message'           => TYPE_STR,
	));

	$vbulletin->GPC['septext'] = nl2br(htmlspecialchars_uni($vbulletin->GPC['septext']));

	if (!empty($vbulletin->GPC['serializeduser']))
	{
		$vbulletin->GPC['user'] = @unserialize($vbulletin->GPC['serializeduser']);
		$vbulletin->GPC['profile'] = @unserialize($vbulletin->GPC['serializedprofile']);
	}

	$condition = fetch_user_search_sql($vbulletin->GPC['user'], $vbulletin->GPC['profile']);
	if (!$condition)
	{
		$condition = ' 1=1 ';
	}

	$finalcondition = "$condition";

	if (empty($vbulletin->GPC['perpage']))
	{
		$vbulletin->GPC['perpage'] = 500;
	}

	@set_time_limit(0);

	$counter = $db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "user AS user
		WHERE $finalcondition
	");
	if ($counter['total'] == 0)
	{
		print_stop_message('no_users_matched_your_query');
	}
	else
	{
		$users = $db->query_read("
			SELECT user.username
			FROM " . TABLE_PREFIX . "user AS user
			WHERE $finalcondition
			ORDER BY userid
			LIMIT " . $vbulletin->GPC['startat'] . ", " . $vbulletin->GPC['perpage'] . "
		");
		if ($db->num_rows($users))
		{
			$page = $vbulletin->GPC['startat'] / $vbulletin->GPC['perpage'] + 1;
			$totalpages = ceil($counter['total'] / $vbulletin->GPC['perpage']);

			echo '<p><b>' . $vbphrase['pming'] . '<br />' . construct_phrase($vbphrase['showing_users_x_to_y_of_z'], vb_number_format($vbulletin->GPC['startat'] + 1), iif ($vbulletin->GPC['startat'] + $vbulletin->GPC['perpage'] > $counter['total'], vb_number_format($counter['total']), vb_number_format($vbulletin->GPC['startat'] + $vbulletin->GPC['perpage'])), vb_number_format($counter['total'])) . '</b></p>';

			echo $vbphrase['sending'];

				$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
				$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
				$pmdm->set('fromusername', $vbulletin->GPC['from']);
				$pmdm->setr('title', $vbulletin->GPC['subject']);
				$pmdm->overridequota = true;
				while ($user = $db->fetch_array($users))
						{
							$recipients .= $user['username'].';';
							echo $user['username']."....<br />";
						}
				$permissions['pmsendmax'] = 65535;
				$pmdm->set_recipients($recipients, $permissions, 'cc');
				$pmdm->setr('message', $vbulletin->GPC['message']);
				$pmdm->set('dateline', TIMENOW);
				$pmdm->set('allowsmilie', 1);
				$pmdm->pre_save();
						if (empty($pmdm->errors))
							{
								$pmdm->save();
							}
					echo $vbphrase['okay'] . "<br />\n";
			$_REQUEST['do'] = 'donext';
		}
		else
		{
			define('CP_REDIRECT', 'pm.php?' . $vbulletin->session->vars['sessionurl']);
			print_stop_message('pms_sent_successfully');
		}
	}
}

// *************************** Link to next page of emails to send **********************
if ($_REQUEST['do'] == 'donext')
{

	$vbulletin->GPC['startat'] += $vbulletin->GPC['perpage'];

	print_form_header('pm', 'dosendpm');
//	construct_hidden_code('test', $vbulletin->GPC['test']);
	construct_hidden_code('serializeduser', serialize($vbulletin->GPC['user']));
	construct_hidden_code('serializedprofile', serialize($vbulletin->GPC['profile']));
	construct_hidden_code('from', $vbulletin->GPC['from']);
	construct_hidden_code('subject', $vbulletin->GPC['subject']);
	construct_hidden_code('message', $vbulletin->GPC['message']);
	construct_hidden_code('startat', $vbulletin->GPC['startat']);
	construct_hidden_code('perpage', $vbulletin->GPC['perpage']);

	print_submit_row($vbphrase['next_page'], 0);

}

// *************************** Main email form **********************
if ($_REQUEST['do'] == 'start')
{
?>
<script type="text/javascript">
function check_all_usergroups(formobj, toggle_status)
{
	for (var i = 0; i < formobj.elements.length; i++)
	{
		var elm = formobj.elements[i];
		if (elm.type == "checkbox" && elm.name == 'user[usergroupid][]')
		{
			elm.checked = toggle_status;
		}
	}
}
</script>
<?php
	print_form_header('pm', 'dosendpm');
	print_table_header($vbphrase['pm_manager']);
	print_input_row($vbphrase['pm_to_send_at_once'], 'perpage', ($permissions['pmsendmax'] > 1000) ? 1000 : $permissions['pmsendmax']);
	print_input_row($vbphrase['from'], 'from', $vbulletin->userinfo['username']);
	print_input_row($vbphrase['subject'], 'subject');
	print_textarea_row($vbphrase['message'], 'message', '', 10, 50);
	$text = $vbphrase['send'];

	print_table_break();
	print_table_header($vbphrase['search_criteria']);
	print_user_search_rows(true);

	print_table_break();
	print_submit_row($text);
}

print_cp_footer();

/*========================================*\
|| ########################################
|| Downloaded: Tue Jan 2nd 2007 00:27:41
|| ########################################
\*========================================*/
?>
