<?php
/*============================*\
|| ###########################||
|| # vBulletin PHPFORCE增强包#||
|| # -------------------------||
|| # http://www.phpforce.cn  #||
|| ###########################||
\*============================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('CVS_REVISION', '$RCSfile: rate.php,v $ - $Revision: 1.70 $');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('user', 'cpuser', 'messaging', 'cprofilefield');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_profilefield.php');
require_once(DIR . '/includes/adminfunctions_user.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminusers'))
{
	print_cp_no_permission();
}

// ############################# LOG ACTION ###############################
log_admin_action();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['rate_users']);

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'start';
}

// *************************** Send a page of emails **********************
if ($_POST['do'] == 'dorate')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'user'              => TYPE_ARRAY,
		'profile'           => TYPE_ARRAY,
		'serializeduser'    => TYPE_STR,
		'serializedprofile' => TYPE_STR,
		'perpage'           => TYPE_UINT,
		'startat'           => TYPE_UINT,
		'reputation'        => TYPE_INT,
		'money'             => TYPE_INT
	));

	// 过滤过大值
	if (abs($vbulletin->GPC['money']) > 1000000 OR abs($vbulletin->GPC['reputation']) > 1000000)
	{
		print_stop_message('number_abs_too_large', 1000000);
	}
	else
	{
		$money = $vbulletin->GPC['money'];
		$reputation = $vbulletin->GPC['reputation'];
	}

	if (!empty($vbulletin->GPC['serializeduser']))
	{
		$vbulletin->GPC['user'] = @unserialize($vbulletin->GPC['serializeduser']);
		$vbulletin->GPC['profile'] = @unserialize($vbulletin->GPC['serializedprofile']);
	}

	$condition = fetch_user_search_sql($vbulletin->GPC['user'], $vbulletin->GPC['profile']);
	if (!$condition)
	{
		$condition = ' 1=1 ';
	}

	$finalcondition = "
		$condition";

	$users = $db->query_read("
		SELECT user.userid AS userid
		FROM " . TABLE_PREFIX . "user AS user
		LEFT JOIN " . TABLE_PREFIX . "userfield AS userfield ON (userfield.userid = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (usertextfield.userid = user.userid)
		WHERE $finalcondition
	");
	if ($db->num_rows($users) > 0)
	{
		while ($user = $db->fetch_array($users))
		{
			$userids .= ', '. $user['userid'];
		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "reputation (postid, reputation, userid, whoadded, reason, dateline)
			VALUES ('', $reputation, ".$user['userid'].", " . $vbulletin->userinfo['userid'] . ", '" . $db->escape_string(fetch_censored_text($vbulletin->GPC['reason'])) . "','" . TIMENOW . "')
		");
		}
		// 更新金钱声望
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "user
			SET money = money + $money,
				reputation = reputation + $reputation
			WHERE userid IN (-1$userids)
		");
		echo $db->num_rows($users) . ' ' . $vbphrase['users']. $vbphrase['done'];
	}
	else
	{
		print_stop_message('no_users_matched_your_query');
	}
}

// *************************** Main email form **********************
if ($_REQUEST['do'] == 'start')
{
?>
<script type="text/javascript">
function check_all_usergroups(formobj, toggle_status)
{
	for (var i = 0; i < formobj.elements.length; i++)
	{
		var elm = formobj.elements[i];
		if (elm.type == "checkbox" && elm.name == 'user[usergroupid][]')
		{
			elm.checked = toggle_status;
		}
	}
}
</script>
<?php
	if ($_REQUEST['do'] == 'start')
	{
		print_form_header('rate', 'dorate');
		print_table_header($vbphrase['rate_users']);
		print_input_row($vbphrase['reputation'], 'reputation', 0);
		print_input_row($vbphrase['money'], 'money', 0);
		$text = $vbphrase['go'];
	}

	print_table_break();
	print_table_header($vbphrase['search_criteria']);
	print_user_search_rows(true);

	print_table_break();
	print_submit_row($text);
}

print_cp_footer();

/*========================================*\
|| ########################################
|| ########################################
\*========================================*/
?>
