<?php
/*============================*\
|| ###########################||
|| # vBulletin PHPFORCE增强包#||
|| # -------------------------||
|| # http://www.phpforce.cn  #||
|| ###########################||
\*============================*/

error_reporting(E_ALL & ~E_NOTICE);

define('THIS_SCRIPT', 'upgrade_zhplus.php');
define('VERSION', '3.6.4');
define('ZHVERSION', '3.0.7');
define('PREV_VERSION', '3.6.4');

$phrasegroups = array();
$specialtemplates = array(
	'forumcache'
);
// #############################################################################
// require the code that makes it all work...
require_once('./upgradecore.php');

// #############################################################################
// welcome step
if ($vbulletin->GPC['step'] == 'welcome')
{
	echo "<blockquote><p>&nbsp;</p>";
	echo $vbphrase[upgrade_pl_start_message];
	echo "<p>&nbsp;</p></blockquote>";
}

// #############################################################################
if ($vbulletin->GPC['step'] == 1)
{
	$query[] = "CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "bank_log (
		id INT UNSIGNED NOT NULL AUTO_INCREMENT,
		userid INT UNSIGNED NOT NULL DEFAULT '0',
		operate SMALLINT NOT NULL DEFAULT '0',
		sum INT NOT NULL DEFAULT '0',
		logtime INT UNSIGNED NOT NULL DEFAULT '0',
		note TEXT DEFAULT '',
		PRIMARY KEY  (id),
		KEY id (id)
	)";
	$explain[] = "正在添加 " . TABLE_PREFIX . "bank_log 数据表";

	$query[] = "CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "rating (
		  `ratingid` INT NOT NULL auto_increment,
		  `rating` INT DEFAULT '0',
		  `fromuserid` INT DEFAULT '0',
		  `touserid` INT DEFAULT '0',
		  `topostid` INT DEFAULT '0',
		  `dateline` INT DEFAULT '0',
		PRIMARY KEY (ratingid)
	  )";
	$explain[] = "正在添加 " . TABLE_PREFIX . "rating 数据表";

	$query[] = "CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "sitelink (
		sitelinkid INT UNSIGNED NOT NULL AUTO_INCREMENT,
		title CHAR(100) NOT NULL DEFAULT '',
		url VARCHAR(255) NOT NULL DEFAULT '',
		logourl VARCHAR(255) NOT NULL DEFAULT '',
		description MEDIUMTEXT,
		displayorder SMALLINT NOT NULL DEFAULT '0',
		fullrow BOOL NOT NULL,
		PRIMARY KEY (sitelinkid)
	)";
	$explain[] = "正在添加 " . TABLE_PREFIX . "sitelink 数据表";

	$query[] = "CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "threadcat (
	  `threadcatid` smallint NOT NULL auto_increment,
	  `title` varchar(250) NOT NULL DEFAULT '',
	  `titlecolor` varchar(10) NOT NULL DEFAULT '',
	  `forumid` smallint NOT NULL DEFAULT '0',
	  `displayorder` smallint NOT NULL DEFAULT '1',
	  `url` varchar(255) NOT NULL DEFAULT '',
	  `nodisplay` BOOL NOT NULL,
		PRIMARY KEY (threadcatid)
	)";
	$explain[] = "正在添加 " . TABLE_PREFIX . "threadcat 数据表";

	$query[] = "CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "onlineranks (
		onlinerankid smallint unsigned NOT NULL AUTO_INCREMENT ,
		onlinerankimg mediumtext,
		maxnum smallint unsigned NOT NULL default '1',
		onlineranklevel smallint unsigned NOT NULL default '0',
		PRIMARY KEY (onlinerankid) ,
		KEY onlineranklevel (onlineranklevel)
		)";
	$explain[] = "正在添加 " . TABLE_PREFIX . "onlineranks 数据表";

	exec_queries();
}

// #############################################################################
if ($vbulletin->GPC['step'] == 2)
{
	$db->hide_errors();

	$db->query_first("SELECT qq FROM " . TABLE_PREFIX . "user LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "user ADD qq CHAR(20) NOT NULL DEFAULT ''";
		$explain[] = "正在为 " . TABLE_PREFIX . "user 数据表添加 qq(QQ) 字段";
	}

	$db->query_first("SELECT gender FROM " . TABLE_PREFIX . "user LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "user ADD gender SMALLINT UNSIGNED NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "user 数据表添加 gender(性别) 字段";
	}

	$db->query_first("SELECT money FROM " . TABLE_PREFIX . "user LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "user ADD money INT NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "user 数据表添加 user(金钱) 字段";
	}

	$db->query_first("SELECT bank FROM " . TABLE_PREFIX . "user LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "user ADD bank INT NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "user 数据表添加 bank(活期银行) 字段";
	}

	$db->query_first("SELECT savemt FROM " . TABLE_PREFIX . "user LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "user ADD savemt INT NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "user 数据表添加 savemt() 字段";
	}

	$db->query_first("SELECT goodnees FROM " . TABLE_PREFIX . "user LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "user ADD goodnees INT UNSIGNED NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "user 数据表添加 goodnees(精华) 字段";
	}

	$db->query_first("SELECT integral FROM " . TABLE_PREFIX . "user LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "user ADD integral INT NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "user 数据表添加 integral(积分) 字段";
	}

	$db->query_first("SELECT online_time FROM " . TABLE_PREFIX . "user LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "user ADD online_time INT NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "user 数据表添加 online_time(在线时长) 字段";
	}

	$db->query_first("SELECT hack_joey_permissions FROM " . TABLE_PREFIX . "usergroup LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "usergroup ADD hack_joey_permissions int unsigned NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "usergroup 数据表添加 hack_joey_permissions(权限管理) 字段";
	}

	$db->query_first("SELECT anymediapermissions FROM " . TABLE_PREFIX . "usergroup LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "usergroup ADD anymediapermissions int unsigned NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "usergroup 数据表添加 anymediapermissions(万用多媒体bb权限管理) 字段";
	}

	$db->errno = 0;
	$db->show_errors();

	exec_queries();

	echo $vbphrase['done'];
}

// #############################################################################
if ($vbulletin->GPC['step'] == 3)
{
	$db->hide_errors();

	$db->query_first("SELECT banknewthread FROM " . TABLE_PREFIX . "forum LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "forum ADD banknewthread VARCHAR(100) NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "forum 数据表添加 banknewthread(新主题奖励) 字段";
	}

	$db->query_first("SELECT banknewreply FROM " . TABLE_PREFIX . "forum LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "forum ADD banknewreply VARCHAR(100) NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "forum 数据表添加 banknewreply(新贴奖励) 字段";
	}

	$db->query_first("SELECT bankdeletethread FROM " . TABLE_PREFIX . "forum LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "forum ADD bankdeletethread INT NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "forum 数据表添加 bankdeletethread(删除主题扣除金钱) 字段";
	}

	$db->query_first("SELECT bankdeletepost FROM " . TABLE_PREFIX . "forum LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "forum ADD bankdeletepost INT NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "forum 数据表添加 bankdeletepost(删除帖子扣除金钱) 字段";
	}

	$db->query_first("SELECT goodneesmoney FROM " . TABLE_PREFIX . "forum LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "forum ADD goodneesmoney INT NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "forum 数据表添加 goodneesmoney(精华奖励) 字段";
	}

	$db->query_first("SELECT threadcatcache FROM " . TABLE_PREFIX . "forum LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "forum ADD threadcatcache MEDIUMTEXT";
		$explain[] = "正在为 " . TABLE_PREFIX . "forum 数据表添加 threadcatcache(专题缓存) 字段";
	}

	$db->query_first("SELECT forumimgs FROM " . TABLE_PREFIX . "forum LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "forum ADD forumimgs VARCHAR( 250 ) NOT NULL";
		$explain[] = "正在为 " . TABLE_PREFIX . "forum 数据表添加 forumimgs(子论坛图标) 字段";
	}

	$db->query_first("SELECT subforumcolumns FROM " . TABLE_PREFIX . "forum LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "forum ADD subforumcolumns TINYINT UNSIGNED  NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "forum 数据表添加 subforumcolumns(每排显示论坛个数) 字段";
	}

	$db->errno = 0;
	$db->show_errors();

	exec_queries();

	echo $vbphrase['done'];
}

// #############################################################################
if ($vbulletin->GPC['step'] == 4)
{
	$db->hide_errors();

	$db->query_first("SELECT hidetype FROM " . TABLE_PREFIX . "post LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "post ADD hidetype VARCHAR(10) NOT NULL";
		$explain[] = "正在为 " . TABLE_PREFIX . "post 数据表添加 hidetype(隐藏) 字段";
	}

	$db->query_first("SELECT hideparam FROM " . TABLE_PREFIX . "post LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "post ADD hideparam VARCHAR(255) NOT NULL";
		$explain[] = "正在为 " . TABLE_PREFIX . "post 数据表添加 hideparam(隐藏) 字段";
	}

	$db->query_first("SELECT reputationval FROM " . TABLE_PREFIX . "post LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "post ADD reputationval INT NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "post 数据表添加 reputationval(声望) 字段";
	}

	$db->query_first("SELECT buyers FROM " . TABLE_PREFIX . "post LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "post ADD buyers MEDIUMTEXT";
		$explain[] = "正在为 " . TABLE_PREFIX . "post 数据表添加 buyers(购买帖子者) 字段";
	}

	$db->query_first("SELECT bonus FROM " . TABLE_PREFIX . "post LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "post ADD bonus INT NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "post 数据表添加 bonus(奖励) 字段";
	}
	
	$checkword = $db->query_first("DESCRIBE " . TABLE_PREFIX . "post reputationval");
	if (strtoupper(substr($checkword['Type'], 0, 3)) != 'INT')
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "post CHANGE reputationval reputationval INT NOT NULL DEFAULT '0'";
		$explain[] = "正修改 " . TABLE_PREFIX . "post 中 reputationval 字段的属性";
	}

	$db->errno = 0;
	$db->show_errors();

	exec_queries();

	echo $vbphrase['done'];
}
// #############################################################################
if ($vbulletin->GPC['step'] == 5)
{
	$db->hide_errors();

	$db->query_first("SELECT titlecolor FROM " . TABLE_PREFIX . "thread LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "thread ADD titlecolor VARCHAR(10) NOT NULL DEFAULT ''";
		$explain[] = "正在为 " . TABLE_PREFIX . "thread 数据表添加 titlecolor(标题颜色) 字段";
	}

	$db->query_first("SELECT titlebold FROM " . TABLE_PREFIX . "thread LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "thread ADD titlebold SMALLINT UNSIGNED NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "thread 数据表添加 titlebold(标题加粗) 字段";
	}

	$db->query_first("SELECT globalsticky FROM " . TABLE_PREFIX . "thread LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "thread ADD globalsticky INT NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "thread 数据表添加 globalsticky(区域置顶) 字段";
	}


	$db->query_first("SELECT goodnees FROM " . TABLE_PREFIX . "thread LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "thread ADD goodnees SMALLINT NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "thread 数据表添加 goodnees(精华) 字段";
	}

	$db->query_first("SELECT tcatid FROM " . TABLE_PREFIX . "thread LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "thread ADD tcatid SMALLINT NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "thread 数据表添加 tcatid(专题) 字段";
	}

	$checkword = $db->query_first("DESCRIBE " . TABLE_PREFIX . "thread goodnees");
	if (strtoupper(substr($checkword['Type'], 0, 8)) != 'SMALLINT')
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "thread CHANGE goodnees goodnees SMALLINT NOT NULL DEFAULT '0'";
		$explain[] = "正修改 " . TABLE_PREFIX . "thread 中 goodnees 字段的属性";
	}

	$checkword = $db->query_first("DESCRIBE " . TABLE_PREFIX . "thread globalsticky");
	if (strtoupper(substr($checkword['Type'], 0, 3)) != 'INT')
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "thread CHANGE globalsticky globalsticky INT NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "thread 数据表更新 globalsticky(区域置顶) 字段";
	}


	$db->errno = 0;
	$db->show_errors();

	exec_queries();

	echo $vbphrase['done'];
}

// #############################################################################
if ($vbulletin->GPC['step'] == 6)
{
	$db->hide_errors();

	$db->query_first("SELECT ishide FROM " . TABLE_PREFIX . "attachment LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "attachment ADD ishide SMALLINT UNSIGNED NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "attachment 数据表添加 ishide(附件隐藏) 字段";
	}

	$db->query_first("SELECT note FROM " . TABLE_PREFIX . "bank_log LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "bank_log ADD note TEXT";
		$explain[] = "正在为 " . TABLE_PREFIX . "bank_log 数据表添加 note(银行日志描述) 字段";
	}

	$db->query_first("SELECT ratingid FROM " . TABLE_PREFIX . "rating LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE `" . TABLE_PREFIX . "rating` ADD `ratingid` INT NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST";
		$explain[] = "正在为 " . TABLE_PREFIX . "rating 数据表添加 ratingid 字段";
	}

	$checkword = $db->query_first("DESCRIBE " . TABLE_PREFIX . "rating ratingid");
	if (strtoupper(substr($checkword['Type'], 0, 3)) != 'INT')
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "rating CHANGE ratingid ratingid INT NOT NULL AUTO_INCREMENT";
		$explain[] = "正修改 " . TABLE_PREFIX . "rating 中 ratingid 字段的属性";
	}

	$checkword = $db->query_first("DESCRIBE " . TABLE_PREFIX . "bank_log note");
	if (strtoupper(substr($checkword['Type'], 0, 4)) != 'TEXT')
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "bank_log CHANGE note note TEXT";
		$explain[] = "正修改 " . TABLE_PREFIX . "bank_log 中 note 字段的属性";
	}

	$checkword = $db->query_first("DESCRIBE " . TABLE_PREFIX . "rating rating");
	if (strtoupper(substr($checkword['Type'], 0, 3)) != 'INT')
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "rating CHANGE rating rating INT NOT NULL DEFAULT '0'";
		$explain[] = "正修改 " . TABLE_PREFIX . "rating 中 rating 字段的属性";
	}

	$checkword = $db->query_first("DESCRIBE " . TABLE_PREFIX . "rating fromuserid");
	if (strtoupper(substr($checkword['Type'], 0, 3)) != 'INT')
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "rating CHANGE fromuserid fromuserid int NOT NULL DEFAULT '0'";
		$explain[] = "正修改 " . TABLE_PREFIX . "rating 中 fromuserid 字段的属性";
	}

	$checkword = $db->query_first("DESCRIBE " . TABLE_PREFIX . "rating touserid");
	if (strtoupper(substr($checkword['Type'], 0, 3)) != 'INT')
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "rating CHANGE touserid touserid INT NOT NULL DEFAULT '0'";
		$explain[] = "正修改 " . TABLE_PREFIX . "rating 中 touserid 字段的属性";
	}

	$checkword = $db->query_first("DESCRIBE " . TABLE_PREFIX . "rating topostid");
	if (strtoupper(substr($checkword['Type'], 0, 3)) != 'INT')
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "rating CHANGE topostid topostid INT NOT NULL DEFAULT '0'";
		$explain[] = "正修改 " . TABLE_PREFIX . "rating 中 topostid 字段的属性";
	}

	$checkword = $db->query_first("DESCRIBE " . TABLE_PREFIX . "rating dateline");
	if (strtoupper(substr($checkword['Type'], 0, 3)) != 'INT')
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "rating CHANGE dateline dateline int NOT NULL DEFAULT '0'";
		$explain[] = "正修改 " . TABLE_PREFIX . "rating 中 dateline 字段的属性";
	}

	$db->query_first("SELECT `desc`  FROM " . TABLE_PREFIX . "sitelink  LIMIT 1");
	if (!$db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "sitelink CHANGE `desc` `description` MEDIUMTEXT";
		$explain[] = "正在为存在的 " . TABLE_PREFIX . "sitelink(友情连接) 数据表更新 desc(描述) 字段为 description(描述)以修正数据导出导入出错的问题.";
	}

	$db->query_first("SELECT `fullrow`  FROM " . TABLE_PREFIX . "sitelink  LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "sitelink ADD `fullrow` BOOL NOT NULL";
		$explain[] = "正在为存在的 " . TABLE_PREFIX . "fullrow(友情连接相关字段).";
	}

	$db->query_first("SELECT threadcatcache FROM " . TABLE_PREFIX . "forum LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "forum ADD threadcatcache mediumtext";
		$explain[] = "正在为 " . TABLE_PREFIX . "forum 数据表添加 threadcatcache(专题) 字段";
	}

	$db->query_first("SELECT tcatid FROM " . TABLE_PREFIX . "thread LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "thread ADD tcatid smallint NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "thread 数据表添加 tcatid(专题) 字段";
	}

	$db->query_first("SELECT url FROM " . TABLE_PREFIX . "threadcat LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "threadcat ADD url varchar(255) NOT NULL DEFAULT ''";
		$explain[] = "正在为 " . TABLE_PREFIX . "threadcat 数据表添加 url(连接) 字段";
	}

	$db->query_first("SELECT nodisplay FROM " . TABLE_PREFIX . "threadcat LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "threadcat ADD nodisplay BOOL NOT NULL";
		$explain[] = "正在为 " . TABLE_PREFIX . "threadcat 数据表添加 nodisplay(显示) 字段";
	}

	$db->query_first("SELECT titlecolor FROM " . TABLE_PREFIX . "threadcat LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "threadcat ADD titlecolor varchar(10) NOT NULL DEFAULT ''";
		$explain[] = "正在为 " . TABLE_PREFIX . "threadcat 数据表添加 titlecolor(颜色) 字段";
	}

	$db->query_first("SELECT logid FROM " . TABLE_PREFIX . "bank_log LIMIT 1");
	if (!$db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "bank_log CHANGE logid id INT UNSIGNED NOT NULL AUTO_INCREMENT";
		$explain[] = "正修改 " . TABLE_PREFIX . "bank_log 中 id 字段的属性";
	}

	$db->query_first("SELECT tcatid FROM " . TABLE_PREFIX . "rssfeed LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "rssfeed ADD tcatid INT NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "rssfeed 数据表添加 tcatid(专题) 字段";
	}

	$db->query_first("SELECT threadid FROM " . TABLE_PREFIX . "announcement LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "announcement ADD threadid INT NOT NULL DEFAULT '0'";
		$explain[] = "正在为 " . TABLE_PREFIX . "announcement 数据表添加 threadid(主题ID) 字段";
	}

	$db->query_first("SELECT whodown FROM " . TABLE_PREFIX . "attachment LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "attachment ADD whodown MEDIUMTEXT NOT NULL DEFAULT ''";
		$explain[] = "正在为 " . TABLE_PREFIX . "attachment 数据表添加 whodown(下载者) 字段";
	}


	$db->errno = 0;
	$db->show_errors();

	exec_queries();

	echo $vbphrase['done'];
}

// #############################################################################
if ($vbulletin->GPC['step'] == 7)
{
	$db->hide_errors();

	$psql = $db->query_first("SELECT fieldname FROM " . TABLE_PREFIX . "phrasetype WHERE fieldname = 'bank'");
	if (!$psql)
	{
		$query[] = "INSERT INTO " . TABLE_PREFIX . "phrasetype 
								(`fieldname` , `title` , `editrows` , `product` ) 
								VALUES ('bank', '银行(bank)', '3', '')
								";

		$explain[] = "正在为 " . TABLE_PREFIX . "phrasetype 数据表添加银行分组数据";
	}

	$db->query_first("SELECT phrasegroup_bank FROM " . TABLE_PREFIX . "language LIMIT 1");
	if ($db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "language ADD `phrasegroup_bank` MEDIUMTEXT";
		$explain[] = "正在为 " . TABLE_PREFIX . "language 数据表添加 phrasegroup_bank 字段";
	}

	$db->query_first("SELECT hack_17cp_permissions FROM " . TABLE_PREFIX . "usergroup LIMIT 1");
	if (!$db->errno())
	{
		$h17cp_permissions = $db->query_read("SELECT hack_17cp_permissions,usergroupid,forumpermissions FROM " . TABLE_PREFIX . "usergroup");
		while ($h17permissions = $db->fetch_array($h17cp_permissions))
		{
			$opt = ($h17permissions['hack_17cp_permissions'] & 1) ? '1' : '0';
			$opt = ($h17permissions['hack_17cp_permissions'] & 2) ? ($opt + 8) : $opt;
			$opt = ($h17permissions['hack_17cp_permissions'] & 4) ? ($opt + 16) : $opt;
			$opt = ($h17permissions['hack_17cp_permissions'] & 8) ? ($opt + 32) : $opt;
			$opt = ($h17permissions['hack_17cp_permissions'] & 16) ? ($opt + 64) : $opt;
			$opt = ($h17permissions['hack_17cp_permissions'] & 32) ? ($opt + 128) : $opt;
			$opt = ($h17permissions['forumpermissions'] & 1048576) ? ($opt + 2) : $opt;
			$opt = ($h17permissions['forumpermissions'] & 2097152) ? ($opt + 4) : $opt;
				$db->query_write("UPDATE " . TABLE_PREFIX . "usergroup
							SET hack_joey_permissions = ".$opt."
							WHERE `usergroupid` = " . $h17permissions['usergroupid'] . "
							");
		}
		$jsthumb = $db->query_first("SELECT value FROM " . TABLE_PREFIX . "setting WHERE varname = 'jsthumb'");
		if ($jsthumb['value']=='1')
		{
			$query[] = "UPDATE " . TABLE_PREFIX . "setting SET value = '' WHERE varname = 'jsthumb'";
			$explain[] = "正在清空原JS缩图设置,请升级后手工重新设置";
		}
		
		$rs=$db->query_read("select SUM(sum) as sums,userid from " . TABLE_PREFIX . "bank_log where (operate=2 AND note<>'已提款') GROUP BY userid");
		while ($rsx = $db->fetch_array($rs))
		{
			$query[] = "UPDATE " . TABLE_PREFIX . "user SET money = money+".$rsx['sums']."  WHERE userid = ".$rsx['userid']."";
			$explain[] = "正在自动提取用户".$rsx['userid']."的定期存款";
		}		
		$rs=$db->query_read("select banksafe,userid from " . TABLE_PREFIX . "user where banksafe<>'0'");
		while ($rsx = $db->fetch_array($rs))
		{
			$query[] = "UPDATE " . TABLE_PREFIX . "user SET money = money+".$vbulletin->options['bank_cost3']." WHERE userid = ".$rsx['userid']."";
			$explain[] = "正在恢复用户".$rsx['userid']."购买保险箱的费用";
		}		
		$db->query_write("UPDATE " . TABLE_PREFIX . "user
			SET money = money + banksafe
			");
		$query[] = "UPDATE " . TABLE_PREFIX . "user	SET money = (money + banksafe)";
		$explain[] = "正在恢复所有用户保险箱中的费用";
		$query[] = "TRUNCATE TABLE `" . TABLE_PREFIX . "bank_log` ";
		$explain[] = "正在清空原有日志";
			$db->query_first("SELECT globalsticky FROM " . TABLE_PREFIX . "thread LIMIT 1");
			if ($db->errno())
			{
				$query[] = "UPDATE " . TABLE_PREFIX . "thread	SET globalsticky = '-1'";
				$explain[] = "正在重置总顶设置";
			}
		
		$h17cp = true;
	}

	$db->query_first("SELECT bankpermissions FROM " . TABLE_PREFIX . "usergroup LIMIT 1");
	if (!$db->errno() && !$h17cp)
	{
		$h17cp_permissions = $db->query_read("SELECT bankpermissions,usergroupid,forumpermissions FROM " . TABLE_PREFIX . "usergroup");
		while ($h17permissions = $db->fetch_array($h17cp_permissions))
		{
			$opt = ($h17permissions['bankpermissions'] & 1) ? '8' : '0';
			$opt = ($h17permissions['bankpermissions'] & 2) ? ($opt + 16) : $opt;
			$opt = ($h17permissions['bankpermissions'] & 4) ? ($opt + 32) : $opt;
			$opt = ($h17permissions['bankpermissions'] & 8) ? ($opt + 64) : $opt;
			$opt = ($h17permissions['bankpermissions'] & 16) ? ($opt + 128) : $opt;
			$opt = ($h17permissions['bankpermissions'] & 32) ? ($opt + 256) : $opt;
			$opt = ($h17permissions['forumpermissions'] & 1048576) ? ($opt + 2) : $opt;
			$opt = ($h17permissions['forumpermissions'] & 2097152) ? ($opt + 4) : $opt;
						$db->query_write("
							UPDATE `" . TABLE_PREFIX . "usergroup`
							SET `hack_joey_permissions` = '".$opt."'
							WHERE `usergroupid` =".$h17permissions['usergroupid']."
						");
		}
			$db->query_first("SELECT globalsticky FROM " . TABLE_PREFIX . "thread LIMIT 1");
			if ($db->errno())
			{
				$query[] = "UPDATE " . TABLE_PREFIX . "thread	SET globalsticky = '-1'";
				$explain[] = "正在重置总顶设置";
			}
	}

	$db->query_first("SELECT bankfollowdefault FROM " . TABLE_PREFIX . "forum LIMIT 1");
	if (!$db->errno() && !$h17cp)
	{
		$h17cp_permissions = $db->query_read("SELECT bankfollowdefault,forumid,options FROM " . TABLE_PREFIX . "forum");
		while ($h17permissions = $db->fetch_array($h17cp_permissions))
		{
			$opt = ($h17permissions['bankfollowdefault'] && !($h17permissions['bankfollowdefault'] & 524288)) ? '524288' : '0';
						$db->query_write("
							UPDATE `" . TABLE_PREFIX . "forum`
							SET `options` = options + ".$opt."
							WHERE `forumid` =".$h17permissions['forumid']."
						");
		}
	} 

	$db->errno = 0;
	$db->show_errors();
	exec_queries();

	echo "<br /><span class=\"smallfont\"><b>$vbphrase[ok]</b></span></p>";
}

// #############################################################################
if ($vbulletin->GPC['step'] == 8)
{

	$db->hide_errors();
	$db->query_first("SELECT tclass FROM " . TABLE_PREFIX . "forum LIMIT 1");
	if (!$db->errno())
	{
		$foruminfos = $db->query_read("SELECT forumid, title, tclass FROM " . TABLE_PREFIX . "forum");
		while ($foruminfo = $db->fetch_array($foruminfos))
		{
			if ($foruminfo['tclass'] != '')
			{
				$threadsclass = explode("\r\n", $foruminfo[tclass]);
				for($x=0; $x < count($threadsclass); $x++)
				{
					$thclass = explode("||", $threadsclass[$x]);
					if($thclass[0])
					{
						++$u;
						$db->query_write("
						INSERT INTO `" . TABLE_PREFIX . "threadcat` ( `threadcatid` , `title` , `forumid` , `displayorder` )
						VALUES ($u, '".$thclass[1]."', '".$foruminfo['forumid']."', '1')
						");
						echo "添加论坛 ".$foruminfo['title']." 专题".$thclass[1]."到专题表 ---";
						$db->query_write("
							UPDATE `" . TABLE_PREFIX . "thread`
							SET `tcatid` = '".$u."'
							WHERE `threadclass` =".$thclass[0]." AND forumid=".$foruminfo['forumid']."
						");
						echo "更改主题表中专题".$thclass[1]."的ID 成功<br />";
					}
				}
			}
		}
	}

foreach ($vbulletin->forumcache AS $forumid => $val)
{

	$threadcats = $db->query_read("
		SELECT
			threadcatid, title, nodisplay, url, titlecolor
		FROM " . TABLE_PREFIX . "threadcat AS threadcat
		WHERE forumid = " . $forumid . "
		ORDER BY forumid, displayorder
	");
	unset($threadcatcache);
	while ($threadcat = $db->fetch_array($threadcats))
	{
		$threadcatcache[$threadcat['threadcatid']]['title'] = $threadcat['title'];
		$threadcatcache[$threadcat['threadcatid']]['titlecolor'] = $threadcat['titlecolor'];
		$threadcatcache[$threadcat['threadcatid']]['nodisplay'] = $threadcat['nodisplay'];
		$threadcatcache[$threadcat['threadcatid']]['url'] = $threadcat['url'];
	}

	if ($forumid != -1)
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "forum
			SET threadcatcache = '" . $vbulletin->db->escape_string(trim(serialize($threadcatcache))) . "'
			WHERE forumid = " . $forumid . "
		");
		build_forum_permissions();
	}
	echo "插入相关数据到forum表及缓存<br />";
}

	$db->errno = 0;
	$db->show_errors();

	exec_queries();

	echo $vbphrase['done'];
}

// #############################################################################
if ($vbulletin->GPC['step'] == 9)
{
	$db->hide_errors();

	$db->query_first("SELECT threadclass FROM " . TABLE_PREFIX . "thread LIMIT 1");
	if (!$db->errno())
	{
		$query[] = "ALTER TABLE `" . TABLE_PREFIX . "thread` DROP `threadclass`";
		$explain[] = "正在删除 " . TABLE_PREFIX . "thread 数据表中threadclass字段";
	}

	$db->query_first("SELECT tclass FROM " . TABLE_PREFIX . "forum LIMIT 1");
	if (!$db->errno())
	{
		$query[] = "ALTER TABLE `" . TABLE_PREFIX . "forum` DROP tclass";
		$explain[] = "正在删除 " . TABLE_PREFIX . "forum 数据表中tclass字段";
	}

	$db->query_first("SELECT hack_17cp_permissions FROM " . TABLE_PREFIX . "usergroup LIMIT 1");
	if (!$db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "usergroup DROP hack_17cp_permissions";
		$explain[] = "正在删除 " . TABLE_PREFIX . "usergroup 的 hack_17cp_permissions(权限) 字段";
	}

	$db->query_first("SELECT bankpermissions FROM " . TABLE_PREFIX . "usergroup LIMIT 1");
	if (!$db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "usergroup DROP bankpermissions";
		$explain[] = "正在删除 " . TABLE_PREFIX . "usergroup 的 bankpermissions(银行权限) 字段";
	}

	$db->query_first("SELECT bankfollowdefault FROM " . TABLE_PREFIX . "forum LIMIT 1");
	if (!$db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "forum DROP bankfollowdefault ";
		$explain[] = "正在删除 " . TABLE_PREFIX . "forum 的 bankfollowdefault(银行继承) 字段";
	}

	$db->query_first("SELECT banksafe FROM " . TABLE_PREFIX . "user LIMIT 1");
	if (!$db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "user DROP banksafe";
		$explain[] = "正在删除 " . TABLE_PREFIX . "user 的 banksafe(保险箱) 字段";
	}
	$db->query_first("SELECT bankaccount  FROM " . TABLE_PREFIX . "user LIMIT 1");
	if (!$db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "user DROP bankaccount";
		$explain[] = "正在删除 " . TABLE_PREFIX . "user 的 bankaccount (银行相关) 字段";
	}

	$db->query_first("SELECT bankpass  FROM " . TABLE_PREFIX . "user LIMIT 1");
	if (!$db->errno())
	{
		$query[] = "ALTER TABLE " . TABLE_PREFIX . "user DROP bankpass  ";
		$explain[] = "正在删除 " . TABLE_PREFIX . "user 的 bankpass (银行密码) 字段";
	}

	$db->query_first("SELECT title FROM " . TABLE_PREFIX . "datastore WHERE title = 'gstickycache'");
	if (!$db->errno())
	{
		$query[] = "DELETE FROM `" . TABLE_PREFIX . "datastore` WHERE `title` = 'gstickycache' LIMIT 1";
		$explain[] = "正在删除总顶缓存";
	}

	$db->errno = 0;
	$db->show_errors();

	exec_queries();

	echo $vbphrase['done'];
}

// #############################################################################
if ($vbulletin->GPC['step'] == 10)
{
	echo '正在插入默认数据';
	$db->hide_errors();

	$ranks1 = $db->query_first("SELECT rankid FROM " . TABLE_PREFIX . "ranks");
	if (!$ranks1)
	{
		$query[] = "INSERT INTO " . TABLE_PREFIX . "ranks (minposts, ranklevel, rankimg, usergroupid, type) VALUES
						(0, 1, 'images/ranks/level0.gif', 2, 0),
						(10, 1, 'images/ranks/level1.gif', 2, 0),
						(50, 1, 'images/ranks/level2.gif', 2, 0),
						(100, 1, 'images/ranks/level3.gif', 2, 0),
						(300, 1, 'images/ranks/level4.gif', 2, 0),
						(1000, 1, 'images/ranks/level5.gif', 2, 0),
						(2000, 1, 'images/ranks/level6.gif', 2, 0),
						(5000, 1, 'images/ranks/level7.gif', 2, 0),
						(10000, 1, 'images/ranks/level8.gif', 2, 0),
						(0, 1, 'images/ranks/admin_level.gif', 6, 0),
						(0, 1, 'images/ranks/mod_level.gif', 7, 0),
						(0, 1, 'images/ranks/superm_level.gif', 5, 0)
						";

		$explain[] = "正在为 " . TABLE_PREFIX . "ranks 数据表添加数据";
	}

	$onlineranks1 = $db->query_first("SELECT onlinerankid FROM " . TABLE_PREFIX . "onlineranks");
	if (!$onlineranks1)
	{
		$query[] = "INSERT INTO " . TABLE_PREFIX . "onlineranks (onlinerankimg, maxnum, onlineranklevel) VALUES
					('images/onlineranks/level1.gif', 3, 1),
					('images/onlineranks/level2.gif', 3, 2),
					('images/onlineranks/level3.gif', 3, 3)
					";

		$explain[] = "正在为 " . TABLE_PREFIX . "onlineranks 数据表添加数据";
	}


		$forumb = $db->query_read("SELECT options FROM " . TABLE_PREFIX . "forum");
		while ($forubx = $db->fetch_array($forumb))
		{
			if ($forubx['options'] & 524288)
			{
				$foptions = true;
			}
		}

		if (!$foptions)
		{
			$query[] = "UPDATE `" . TABLE_PREFIX . "forum` SET `options` = options + 524288 ";
			$explain[] = "正在更新 " . TABLE_PREFIX . "forum 的银行设置";
		}



	$db->errno = 0;
	$db->show_errors();

	exec_queries();

	echo $vbphrase['done'];
}

// #############################################################################
if ($vbulletin->GPC['step'] == 11)
{
	echo '正在重建 Bitfields...';

	require_once(DIR . '/includes/class_bitfield_builder.php');
	vB_Bitfield_Builder::save($db);
	build_forum_permissions();
	// VBZH - PHPForce - Joey修改在线时长
	$onlineranks = $db->query("
		SELECT onlinerankid, onlinerankimg, maxnum, onlineranklevel
		FROM " . TABLE_PREFIX . "onlineranks AS onlineranks
		ORDER BY onlineranklevel
	");

	$tempoutput = "";
	$tempstep = 1;
	while ($onlinerank = $db->fetch_array($onlineranks))
	{
		if (!$firstimg)
		{
			$firstimg = $onlinerank['onlinerankimg'];
		}
		$lastimg = $onlinerank['onlinerankimg'];
		$lastmax = $onlinerank['maxnum']+1;

		$tempstepnext = ($onlinerank['maxnum']+1)*$tempstep;
		$tempout = "";
		$tempout .= "\t\$tempcount = 0;\n";
		$tempout .= "\twhile (\$tempcount++ < ".$onlinerank['maxnum'].")\n";
		$tempout .= "\t{\n";
		$tempout .= "\t\tif (\$temprank < ".$tempstepnext." AND \$temprank >= ".$tempstep.")\n";
		$tempout .= "\t\t{\n";
		$tempout .= "\t\t\t\$userinfo['onlinerankimg'] .= \"<img class=\\\"inlineimg\\\"src=\\\"".$onlinerank['onlinerankimg']."\\\" alt=\\\"级别:\".\$userinfo['onlinerank'].\" | 在线时长:\".\$userinfo['onlinehours'].\"小时 | 升级还需:\".\$userinfo['nextneedhours'].\"小时\\\" border=\\\"0\\\" />\";\n";
		$tempout .= "\t\t\t\$temprank = \$temprank - ".$tempstep.";\n";
		$tempout .= "\t\t}\n";
		$tempout .= "\t\telse\n";
		$tempout .= "\t\t{\n";
		$tempout .= "\t\t\tbreak;\n";
		$tempout .= "\t\t}\n";
		$tempout .= "\t}\n";
		$tempout .= "\n";

		$tempoutput = $tempout.$tempoutput;
		$tempstep = $tempstepnext;
	}

	$output = "";
	$output .= "\$userinfo['onlinehours'] = floor (\$userinfo['online_time']/3600);\n";
	$output .= "\$userinfo['onlinerank'] = floor (( \$vbulletin->options['onlstephours']/2 - \$vbulletin->options['onlstarthours'] + sqrt (pow (\$vbulletin->options['onlstarthours'] - \$vbulletin->options['onlstephours']/2, 2) + 2*\$vbulletin->options['onlstephours']*\$userinfo['onlinehours']) )/\$vbulletin->options['onlstephours'] );\n";
	$output .= "\$userinfo['nextneedhours'] = (\$vbulletin->options['onlstephours']/2*pow(\$userinfo['onlinerank'] + 1, 2) + (\$vbulletin->options['onlstarthours']-\$vbulletin->options['onlstephours']/2)*(\$userinfo['onlinerank'] + 1))-\$userinfo['onlinehours'];\n";
	$output .= "\n";
	$output .= "\$temprank = \$userinfo['onlinerank'];\n";
	$output .= "if (\$temprank > 0)\n";
	$output .= "{\n";

	$output .= $tempoutput;

	$output .= "\tif (\$temprank > ".$tempstep.")\n";
	$output .= "\t{\n";
	$output .= "\t\t\$tempcount = 0;\n";
	$output .= "\t\twhile (\$tempcount++ < ".$lastmax.")\n";
	$output .= "\t\t{\n";
	$output .= "\t\t\t\$userinfo['onlinerankimg'] .= \"<img class=\\\"inlineimg\\\"src=\\\"".$lastimg."\\\" alt=\\\"级别:\".\$userinfo['onlinerank'].\" | 在线时长:\".\$userinfo['onlinehours'].\"小时 | 升级还需:\".\$userinfo['nextneedhours'].\"小时\\\" border=\\\"0\\\" />\";\n";
	$output .= "\t\t}\n";
	$output .= "\t}\n";

	$output .= "}\n";
	$output .= "else\n";
	$output .= "{\n";
	$output .= "\t\$userinfo['onlinerankimg'] = \"<img class=\\\"inlineimg\\\"src=\\\"".$firstimg."\\\" style=\\\"filter:gray\\\" alt=\\\"级别:\".\$userinfo['onlinerank'].\" | 在线时长:\".\$userinfo['onlinehours'].\"小时 | 升级还需:\".\$userinfo['nextneedhours'].\"小时\\\" border=\\\"0\\\" />\";\n";
	$output .= "}\n";

	if ($output)
	{
		$output .= "\n";
	}

	build_datastore('onlinerankphp', $output);
	// VBZH - PHPForce - Joey修改结束 

	echo $vbphrase['done'];
}

// #############################################################################
// FINAL step (notice the SCRIPTCOMPLETE define)
if ($vbulletin->GPC['step'] == 12)
{
	// tell log_upgrade_step() that the script is done
	define('SCRIPTCOMPLETE', true);
}

// #############################################################################

print_next_step();
print_upgrade_footer();

/*========================================*\
|| ########################################
|| Downloaded: Tue Jan 2nd 2007 00:27:41
|| ########################################
\*========================================*/
?>
