<?php

namespace admin\controller;
/**
 * 
 */
class File extends Admin {
	
	
	public function lists(){
		$spk = array (
		    'pk1' => array('type' => 'INF_MAX'),
		    'pk2' => '',
		    'pk3' => '',
		    'pk4' => '',
		);
		$epk = array (
		    'pk1' =>  array('type' => 'INF_MIN'),
		    'pk2' => '',
		    'pk3' => '',
		    'pk4' => '',
		);
		
		//搜索
		if(I('uid')){
			$spk['pk1']=I('uid');
			$epk['pk1']=I('uid');
			$spk['pk2']=array('type' => 'INF_MAX');
			$epk['pk2']=array('type' => 'INF_MIN');
			if(I('pk4')){
				$list[0]=O('file')->find(array('pk'=>array(
					'pk1'=>I('uid'),
					'pk2'=>'',
					'pk3'=>'',
					'pk4'=>I('pk4'),
				)));
			}else if(I('folder')){
				$filter=array(
					'folder'=>array('eq',I('folder')),
				);
				$list=O('file')->select(array(
					'spk'=>$spk,
					'epk'=>$epk,
					'filter'=>$filter,
				));
			}else{
				$list=O('file')->select(array(
					'spk'=>$spk,
					'epk'=>$epk,
				));
			}
		}else if(I('pk4')){
			$this->error('请输入用户ID');
		}else{
			$filter=array(
				'pk4'=>array('gt',mktime(0,0,0,date('m'),date('d')-1,date('Y'))*1000),
			);
			$list=O('file')->select(array(
				'spk'=>$spk,
				'epk'=>$epk,
				'filter'=>$filter,
			));
		}
		
		
		
		
		
		foreach ($list as $k => &$v) {
			if ($v['size']<1048576) {
				$v['size']=floor($v['size']/1024).'KB';
			}else if($v['size']<1073741824){
				$v['size']=floor($v['size']/1048576).'MB';
			}else if($v['size']<1073741824){
				$v['size']=(floor($v['size']/1099511627776*100)/100).'GB';
			}
			$v['uid']=substr($v['pk1'], 5);
			$v['ctime']=date('Y-m-d H:i:s',$v['pk4']/1000);
			$v['pk']=base64_encode(json_encode(array('pk1'=>$v['pk1'],'pk2'=>$v['pk2'],'pk3'=>$v['pk3'],'pk4'=>$v['pk4'])));
			
			//下载链接
			$qiniu_file=C($v['qiniu']);
			Vendor('Qiniu.autoload');
			$auth = new \Qiniu\Auth($qiniu_file['accessKey'], $qiniu_file['secretKey']);
			$v['downurl']=$auth->privateDownloadUrl('http://'.$qiniu_file['domain'].'/'.$v['key']).'&attname='.$v['name'];
			
		}
		unset($v);
		$this->list=$list;
		$this->display();
	}

	public function del($pk=''){
		$id=I('id',false);
		if($id){
		    foreach ($id as $k => $v) {
		    	$pk=json_decode(base64_decode($v),true);
				O('file')->delete(array('pk'=>$pk));
		    }
		}else{
			$pk=json_decode(base64_decode($pk),true);
			O('file')->delete(array('pk'=>$pk));
		}
		$this->ajaxReturn(array(
			'status'=>1
		));
		
	}
	
	/**
	 * 冻结
	 */
	public function dongjie($pk=''){
		$pk=json_decode(base64_decode($pk),true);
		O('file')->save(array(
			'pk'=>$pk,
			'attr'=>array('status'=>'-2')
		));
		$this->ajaxReturn(array(
			'status'=>1
		));
		
	}
	
	/**
	 * 解冻
	 */
	public function jiedong($pk=''){
		$pk=json_decode(base64_decode($pk),true);
		O('file')->save(array(
			'pk'=>$pk,
			'attr'=>array('status'=>'0')
		));
		$this->ajaxReturn(array(
			'status'=>1
		));
		
	}
	
	public function recycle(){
		$spk = array (
		    'pk1' => 'file_9999999999999999999999',
		    'pk2' => '',
		    'pk3' => '',
		    'pk4' => '',
		);
		$epk = array (
		    'pk1' => 'file_0',
		    'pk2' => '',
		    'pk3' => '',
		    'pk4' => '',
		);
		$filter=array(
			'pk4'=>array('gt',mktime(0,0,0,date('m'),date('d')-1,date('Y'))*1000),
			'status'=>array('eq',-1)
		);
		if(I('pk4')){
		    $filter['pk4']=array('eq',I('pk4'));
		}
		if(I('uid')){
		    $filter['pk1']=array('eq','file_'.I('uid'));
		}
		$list=O('file')->select(array(
			'spk'=>$spk,
			'epk'=>$epk,
			'filter'=>$filter,
		));
		foreach ($list as $k => &$v) {
			if ($v['size']<1048576) {
				$v['size']=floor($v['size']/1024).'KB';
			}else if($v['size']<1073741824){
				$v['size']=floor($v['size']/1048576).'MB';
			}else if($v['size']<1073741824){
				$v['size']=(floor($v['size']/1099511627776*100)/100).'GB';
			}
			$v['uid']=substr($v['pk1'], 5);
			$v['ctime']=date('Y-m-d H:i:s',$v['pk4']/1000);
		}
		$this->list=$list;
		$this->display();
	}
	
    /* 文件上传 */
    public function upload(){
		$return  = array('status' => 1, 'info' => '上传成功', 'data' => '');
		/* 调用文件上传组件上传文件 */
		$File = D('File');
		$file_driver = C('DOWNLOAD_UPLOAD_DRIVER');
		$info = $File->upload(
			$_FILES,
			C('DOWNLOAD_UPLOAD'),
			C('DOWNLOAD_UPLOAD_DRIVER'),
			C("UPLOAD_{$file_driver}_CONFIG")
		);

        /* 记录附件信息 */
        if($info){
            $return['data'] = think_encrypt(json_encode($info['download']));
            $return['info'] = $info['download']['name'];
        } else {
            $return['status'] = 0;
            $return['info']   = $File->getError();
        }

        /* 返回JSON数据 */
        $this->ajaxReturn($return);
    }

    /* 下载文件 */
    public function download($id = null){
        if(empty($id) || !is_numeric($id)){
            $this->error('参数错误！');
        }

        $logic = D('Download', 'Logic');
        if(!$logic->download($id)){
            $this->error($logic->getError());
        }

    }

    /**
     * 上传图片
     * @author huajie <banhuajie@163.com>
     */
    public function uploadPicture(){
        //TODO: 用户登录检测

        /* 返回标准数据 */
        $return  = array('status' => 1, 'info' => '上传成功', 'data' => '');

        /* 调用文件上传组件上传文件 */
        $Picture = D('Picture');
        $pic_driver = C('PICTURE_UPLOAD_DRIVER');
        $info = $Picture->upload(
            $_FILES,
            C('PICTURE_UPLOAD'),
            C('PICTURE_UPLOAD_DRIVER'),
            C("UPLOAD_{$pic_driver}_CONFIG")
        ); //TODO:上传到远程服务器

        /* 记录图片信息 */
        if($info){
            $return['status'] = 1;
            $return = array_merge($info['download'], $return);
        } else {
            $return['status'] = 0;
            $return['info']   = $Picture->getError();
        }

        /* 返回JSON数据 */
        $this->ajaxReturn($return);
    }
}
