<?php
namespace admin\controller;

/**
 * 控制器
 * 
 */
class User extends Admin {
	
	private $model="MemberAdmin"; 
	private $pk="id"; 
	
	protected function _initialize(){
		parent::_initialize();
		if(session('user_auth.id')!=C('USER_ADMINISTRATOR')){
		    $this->error('你没有相关权限');
		}
    }
	
	// 管理列表
	public function index(){

		$this->display();
    }
	
	
	// 管理列表
	public function lists(){
		// 记录当前列表页的cookie
        cookie('__forward__',$_SERVER['REQUEST_URI']);
		
		$m=D($this->model);
		$where=array();
		$order=$this->pk." desc";
		$count=$m->where($where)->count();
		$page       = new \source\Page($count,20); //3.2
		$nowPage = I("p",1);
		$this->page  = $page->show();
		$this->list=$m->order($order)->where($where)->page($nowPage.','.$page->listRows)->select();
		$this->display();
		
		
    }
	
	
	
	//添加
	public function add(){
		$m = D($this->model);
		if(IS_POST){
			if($m->create() && $m->add()){
				$this->success('添加成功',Cookie('__forward__'));
			}else{
				$this->error($m->getError());
			}
			
		}else{
			$this->display();
		}
	}
	
	//修改
	public function mod($id){
		$m = D($this->model);
		if(IS_POST){
			if($m->create() && $m->save()){
				$this->success('修改成功',Cookie('__forward__'));
			}else{
				$this->error($m->getError());
			}
		}else{
			$this->modval = $m->find($id);
			$this->display();
		}
	}
	
	//删除
	public function del($ids){
		//数据准备
		$m = D($this->model);
		$where[$this->pk]=array('in',$ids);
		$m->where($where)->delete();
		$this->success('删除成功',Cookie('__forward__'));
	}

}