<?php
/**
 * @description 万能控制器，主要涉及  模型表model，必须读懂此控制器，方能以不变应万变
 * @version 1.0.2
 * @author 建站宝_赵  QQ 613600010
 * @time 2017-07-24
 */

namespace admin\controller;
class X extends Admin {
	
	/**
	 * @description 属性
	 * @param $table 表
	 * @param $debug 开启调试
	 * @param $tpl   模板
	 */
	private $debug = false;
	private $table = false;
	private $model = '';
	private $tpl   = '';
	
	/**
	 * @description 初始加载
	 */
	protected function _initialize(){
		parent::_initialize();
		$this->model=I('model',false);
		$this->tpl=I('tpl',false);
		if(!$this->model){
		    $this->error('请传入模型信息');
		}
    }
	
	/**
	 * @description 创建表
	 * @param $table 表名
	 */
	public function table(){
		$re=O($this->model)->createTable();
		dump($re);
	}
	
	
	public function cs($model){
		header("Content-type: text/html; charset=utf-8");
		$spk = array (
	        'pk3' => '',
	        'pk4' => '',
		);
		$epk = array (
	        'pk3' => '',
	        'pk4' => '',
		);
		$list=O($model)->select(array(
			'spk'=>$spk,
			'epk'=>$epk,
			'limit'=>200,
		));
		dump($list);
		if(I('del')==1 && $list){
		    $data=array(
				'del'=>$list,
			);
			O($model)->write($data);
		}
	}
	
	public function view($tpl,$param=''){
		foreach ($param as $k => $v) {
			$this->assign($k,$v);
		}
		$this->display($tpl);
	}
	
	public function ac($model,$ac){
		O($model)->$ac();
	}
	
	/**
	 * @description 频道页
	 */
	public function index(){
		$this->isadmin=O($this->model)->isadmin();
		$this->data=O($this->model)->index();
		$this->tpl=I('tpl',$this->model.'_index');
		$this->display(ucfirst($this->tpl));
	}
	
	/**
	 * @description 列表
	 */
	public function lists(){
		$list=O1($this->model)->select(array(
			'limit'=>10,
		));
		dump($list);die;
		if(empty($list)){
			$this->error('暂无数据');
		}
		if(IS_AJAX){
		    $this->ajaxReturn(array('data'=>$list));
		}else{
			$this->list=$list;
		}
		$this->tpl=I('tpl',$this->model.'_lists');
		$this->display(ucfirst($this->tpl));
	}
	
	/**
	 * @description 详情
	 */
	public function show(){
		$pk=I('pk');
		$info=O(I('model'))->find($pk);
		if($info['imgs']){
		    $info['imgs']=explode(',', $info['imgs']);
		}
		if(empty($info)){
			$this->error('数据不存在，可能已删除');
		}
		$this->info=$info;
		$this->isadmin=O($this->model)->isadmin();
		$this->tpl=I('tpl',$this->model.'_show');
		$this->display(ucfirst($this->tpl));
	}
	
	
	/**
	 * @description 添加
	 */
	public function add(){
		if(method_exists(O($this->model),'is_admin_add')){
		    if(!O($this->model)->is_admin_add()){
		        $this->error('你没有相关权限');
		    }
		}
		if(IS_POST){
			$re=O($this->model)->add(I('post.'));
			$gourl=I('gourl',false);
			if(IS_AJAX){
			    if($re){
				    $this->ajaxReturn(array('status'=>1,'info'=>$re));
				}else{
					$this->ajaxReturn(array('status'=>0));
				}
			}else if($gourl){
				header("location:$gourl");
			}else if(!empty($_SERVER['HTTP_REFERER'])){
				header("location:".$_SERVER['HTTP_REFERER']);
			}
	    	
		}else{
			//模板
			$this->isadmin=O($this->model)->isadmin();
			$this->tpl=I('tpl',$this->model.'_add');
			$this->display(ucfirst($this->tpl));
		}
	}
	
	/**
	 * @description 前台编辑
	 */
	public function mod(){
		if(method_exists(O($this->model),'is_admin_mod')){
		    if(!O($this->model)->is_admin_mod()){
		        $this->error('你没有相关权限');
		    }
		}
		if(IS_POST){
			$re=O($this->model)->save(I('post.'));
			$gourl=I('gourl',false);
			if(IS_AJAX){
			    $this->ajaxReturn(array(
					'status'=>1,
					're'=>$re,
				));
			}else if($gourl){
				header("location:$gourl");
			}else if(!empty($_SERVER['HTTP_REFERER'])){
				header("location:".$_SERVER['HTTP_REFERER']);
			}
	    	
		}else{
			$this->isadmin=O($this->model)->isadmin();
			$pk=I('pk');
			$this->modval=O($this->model)->find($pk);
			$this->tpl=I('tpl',$this->model.'_mod');
			$this->display(ucfirst($this->tpl));
		}
	}
	
	/**
	 * @description 前台删除
	 */
	public function del(){
		$uid=session("user_auth.id");
		$pk=I('pk');
		O($this->model)->delete($pk);
		$this->ajaxReturn(array('status'=>1));
	}
	
	
	public function error($info){
		$this->info=$info;
		$this->display('Reminder_error');
		die;
	}
	
	
	
	
	
}

