<?php
/**
 * 106云盘自动发卡平台网盘系统
 * ============================================================================
 * 版权所有 2016-2028 扎兰屯市姝妍计算机服务有限公司，并保留所有权利。
 * 网站地址: http://www.106ym.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 */
namespace member\controller;
class X extends Member {
	
	/**
	 * @description 属性
	 * @param $table 表
	 * @param $debug 开启调试
	 * @param $tpl   模板
	 */
	private $debug = false;
	private $table = false;
	private $model = '';
	private $tpl   = '';
	
	/**
	 * @description 初始加载，下面四个参数至少传递一个
	 * @param $category_id 栏目id
	 * @param $category_name 栏目名称
	 * @param $model_id 模型id
	 * @param $model_name 模型名称
	 */
	protected function _initialize(){
		parent::_initialize();
		$model_id=I('model_id',false);
		$model_name=I('model_name',false);
		if(!$model_id && !$model_name){
		    $this->error('请传入模型信息');
		}
		//获取模型信息
		if($model_id){//有模型id，直接根据模型id获取
			$this->model=M('model')->find($model_id);
		}else if($model_name){//有模型名称，直接根据模型名称获取
			$where=array(
				'name'=>$model_name
			);
			$this->model=M('model')->where($where)->find();
		}
		$this->table=$this->model['name'];
    }
	
	/**
	 * @description 详情
	 */
	public function show(){
	}
	
	/**
	 * @description 添加
	 */
	public function add(){
		if($this->model['model_allow']<2){
		    $this->error('禁止发布');
			exit;
		}
		if(IS_POST){
			$uid=session("user_auth.id");
			if(I('uid')!=$uid){
			    $this->error('请登录');
				exit;
			}
			$pk1=I('pk1',false);
			if(!$pk1){
			    $this->error('需传入pk1');
				exit;
			}
			$pk=array ( 
		        'pk1' => $pk1,
		        'pk2' => I('pk2',''),
		        'pk3' => I('pk3',''),
		        'pk4' => I('pk4',''),
		    );
			$attr=$_REQUEST;
			unset($attr['pk1']);
			unset($attr['pk2']);
			unset($attr['pk3']);
			unset($attr['pk4']);
			$re=O($this->table)->add(array(
				'pk'=>$pk,
				'attr'=>$attr,
			));
			$gourl=I('gourl',false);
			if(IS_AJAX){
			    $this->ajaxReturn(array(
					'status'=>1,
					're'=>$re,
				));
			}else if($gourl){
				header("location:$gourl");
			}else if(!empty($_SERVER['HTTP_REFERER'])){
				header("location:".$_SERVER['HTTP_REFERER']);
			}
	    	
		}else{
			//模板
			$this->tpl=I('tpl',ucfirst($this->table).'_add');
			$this->display($this->tpl);
		}
	}
	
	/**
	 * @description 前台编辑
	 */
	public function mod(){
		if($this->model['model_allow']<2){
		    $this->error('禁止修改');
			exit;
		}
		$pk1=I('pk1',false);
		if(!$pk1){
		    $this->error('需传入pk1');
		}
		$pk=array ( 
	        'pk1' => I('pk1',''),
	        'pk2' => I('pk2',''),
	        'pk3' => I('pk3',''),
	        'pk4' => I('pk4',''),
	    );
		if(IS_POST){
			$uid=session("user_auth.id");
			if(I('uid')!=$uid){
			    $this->error('请登录');
				exit;
			}
			$attr=$_REQUEST;
			unset($attr['pk1']);
			unset($attr['pk2']);
			unset($attr['pk3']);
			unset($attr['pk4']);
			$re=O($this->table)->save(array(
				'pk'=>$pk,
				'attr'=>$attr,
			));
			$gourl=I('gourl',false);
			if(IS_AJAX){
			    $this->ajaxReturn(array(
					'status'=>1,
					're'=>$re,
				));
			}else if($gourl){
				header("location:$gourl");
			}else if(!empty($_SERVER['HTTP_REFERER'])){
				header("location:".$_SERVER['HTTP_REFERER']);
			}
	    	
		}else{
			$this->modval=O($this->table)->find(array(
				'pk'=>$pk
			));
			//模板
			$this->tpl=I('tpl',ucfirst($this->table).'_mod');
			$this->display($this->tpl);
		}
	}
	
	/**
	 * @description 前台删除
	 */
	public function del(){
		if(I('uid')!=$uid){
		    $this->error('请登录');
			exit;
		}
	}
	
}

