<?php
/**
 * excel操作类
 */
namespace Wd;
class Excel{
    /**
     +----------------------------------------------------------
     * Export Excel | 2013.08.23
     * Author:HongPing <hongping626@qq.com>
     +----------------------------------------------------------
     * @param $expTitle     string File name
     +----------------------------------------------------------
     * @param $expCellName  array  Column name
     +----------------------------------------------------------
     * @param $expTableData array  Table data
     +----------------------------------------------------------
     */
    public function exportExcel($expTitle,$expCellName,$expTableData,$fileName){
        $xlsTitle = iconv('utf-8', 'gb2312', $expTitle[0]);//文件名称
        $fileName = iconv('utf-8', 'gb2312', $fileName).date('_YmdHis');//or $xlsTitle 文件名称可根据自己情况设定
        
        vendor("PHPExcel.PHPExcel");
        $objPHPExcel = new \PHPExcel();
        $cellName = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','AA','AB','AC','AD','AE','AF','AG','AH','AI','AJ','AK','AL','AM','AN','AO','AP','AQ','AR','AS','AT','AU','AV','AW','AX','AY','AZ');
        foreach($expTitle as $k=>$v){
			if($k>0){
				$objPHPExcel->createSheet(); 
			}
			$cellNum = count($expCellName[$k]);
        	$dataNum = count($expTableData[$k]);
			//第一行添加标题
			$objPHPExcel->setActiveSheetIndex($k);
			$objPHPExcel->getActiveSheet()->setTitle($expTitle[$k]);
			$objPHPExcel->getActiveSheet($k)->mergeCells('A1:'.$cellName[$cellNum-1].'1');//合并单元格
			$objPHPExcel->setActiveSheetIndex($k)->setCellValue('A1', $expTitle[$k]); 
			//添加列名
			for($i=0;$i<$cellNum;$i++){
				$objPHPExcel->setActiveSheetIndex($k)->setCellValue($cellName[$i].'2', $expCellName[$k][$i][1]); 
			} 
			//写入数据 
			for($i=0;$i<$dataNum;$i++){
			  for($j=0;$j<$cellNum;$j++){
				$objPHPExcel->getActiveSheet($k)->setCellValue($cellName[$j].($i+3), $expTableData[$k][$i][$expCellName[$k][$j][0]]);				
			  }             
			} 
		}
        
        header('pragma:public');
        header('Content-type:application/vnd.ms-excel;charset=utf-8;name="'.$fileName.'.xls"');
        header("Content-Disposition:attachment;filename=$fileName.xls");//attachment新窗口打印inline本窗口打印
        $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');  
        $objWriter->save('php://output'); 
        exit;   
    }
     

	/**
	 * 读取excel
	 * @param unknown_type $excelPath：excel路径
	 * @param unknown_type $allColumn：读取的列数
	 * @param unknown_type $sheet：读取的工作表
	 */
	public function reader($excelPath, $allColumn = 0, $sheet = 0) {
		vendor("PHPExcel.PHPExcel");
		$excel_arr = array();
		
		//默认用excel2007读取excel,若格式 不对，则用之前的版本进行读取
		$PHPReader = new \PHPExcel_Reader_Excel2007();
		if(!$PHPReader->canRead($excelPath)) {
			$PHPReader = new \PHPExcel_Reader_Excel5();
			if(!$PHPReader->canRead($excelPath)) {
				//返回空的数组
				return $excel_arr;	
			}
		}
		
		//载入excel文件
		$PHPExcel  = new \PHPExcel();
		$PHPExcel  = $PHPReader->load($excelPath);
		
		//获取工作表总数
		$sheetCount = $PHPExcel->getSheetCount();
		
		//判断是否超过工作表总数，取最小值
		$sheet = $sheet < $sheetCount ? $sheet : $sheetCount;
		
		//默认读取excel文件中的第一个工作表
		$currentSheet = $PHPExcel->getSheet($sheet);
		
		if(empty($allColumn)) {
			//取得最大列号，这里输出的是大写的英文字母，ord()函数将字符转为十进制，65代表A
			$allColumn = ord($currentSheet->getHighestColumn()) - 65 + 1;
		}
		
		//取得一共多少行
		$allRow = $currentSheet->getHighestRow();
		
		//从第二行开始输出，因为excel表中第一行为列名
		for($currentRow = 1; $currentRow <= $allRow; $currentRow++) {
			for($currentColumn = 0; $currentColumn <= $allColumn - 1; $currentColumn++) {
				$val = $currentSheet->getCellByColumnAndRow($currentColumn, $currentRow)->getValue();
				$excel_arr[$currentRow - 1][$currentColumn] = $val;
			}
		}
		
		//返回二维数组
		return $excel_arr;
	}
   
}

?>