<?php
/**
 * 支付宝接口类
 */
namespace pay;

class Alipay{
	
    public function __construct($config=array()){
    	foreach ($config as $k => $v) {
    		$this->$k=$v;
    	}
		vendor('autoload');
   		$this->aop=new \alipay\aop\AopClient();
		$this->aop->gatewayUrl = isset($config['gatewayUrl'])?$config['gatewayUrl']:"https://openapi.alipay.com/gateway.do";
		$this->aop->appId = isset($config['appId'])?$config['appId']:C('ALIPAY_appId');
		$this->aop->rsaPrivateKey=isset($config['rsaPrivateKey'])?$config['rsaPrivateKey']:C('ALIPAY_rsaPrivateKey');
		$this->aop->alipayrsaPublicKey=isset($config['alipayrsaPublicKey'])?$config['alipayrsaPublicKey']:C('ALIPAY_alipayrsaPublicKey');
		$this->aop->format = "json";
		$this->aop->charset = isset($config['charset'])?$config['charset']:"UTF-8";
		$this->aop->signType = isset($config['sign_type'])?$config['sign_type']:"RSA2";
    }
    


	/**
	 * app支付  2018-04-04
	 * $param 数组
	 * title  商品标题
	 * orderno 订单号
	 * amount 付款金额
	 * notify_url 支付回调地址
	 * return_url 支付成功跳转地址
	 * other 其它参数
	 */
	function pc($param){
		vendor('autoload');
		$data=array(
			'subject'=>$param['title'],
			'total_amount'=>$param['amount'],
			'out_trade_no'=>$param['orderno'],
			'notify_url'=>$param['notify_url'],
			'return_url'=>$param['return_url'],
		);
		if(isset($param['other'])){
		    $data['passback_params']=$param['other'];
		}
		$request = new \alipay\aop\request\AlipayTradePagePayRequest();
		$data['product_code']='FAST_INSTANT_TRADE_PAY';
		$request->setNotifyUrl($data['notify_url']);
		$request->setReturnUrl($data['return_url']);
		$bizcontent = json_encode($data);
		$request->setBizContent($bizcontent);
		$response = $this->aop->pageExecute($request);
		echo $response;
	}

	/**
    * 生成手机版网页支付代码
    * @param   array   $param      订单信息
    */
	function wap($param){
		$orderno = $param['order_no'];
		$title = isset($param['title'])?$param['title']:'订单'.$orderno;//订单名称，必填
		$amount = $param['amount'];//付款金额，必填
		$body = isset($param['body'])?$param['body']:'订单'.$orderno;//商品描述，可空
	    $timeout_express="1m";//超时时间
	
	    $payRequestBuilder = new \alipay\wappay\buildermodel\AlipayTradeWapPayContentBuilder();
	    $payRequestBuilder->setBody($body);
	    $payRequestBuilder->settitle($title);
	    $payRequestBuilder->setOutTradeNo($orderno);
	    $payRequestBuilder->setTotalAmount($amount);
	    $payRequestBuilder->setTimeExpress($timeout_express);
	
	    $payResponse = new \alipay\wappay\service\AlipayTradeService($this->config);
	    $result=$payResponse->wapPay($payRequestBuilder,$this->config['return_url'],$this->config['notify_url']);
	}
	
	/**
	 * app支付  2018-04-02
	 * $param 数组
	 * title  商品标题
	 * orderno 订单号
	 * amount 付款金额
	 * notify_url 支付回调地址
	 */
   	public function app($param){
   		vendor('autoload');
		$request = new \alipay\aop\request\AlipayTradeAppPayRequest();
		$param['product_code']='QUICK_MSECURITY_PAY';
		$request->setNotifyUrl($param['notify_url']);
		$bizcontent = json_encode($param);
		$request->setBizContent($bizcontent);
		$response = $this->aop->sdkExecute($request);
		return $response;//就是orderString 可以直接给客户端请求，无需再做处理。
	}
	
	/**
	 * 验签方法 2018-04-04
	 * @return boolean
	 */
	function check(){
		if( isset($_POST['trade_status']) && $_POST['trade_status']!='TRADE_SUCCESS'){
		    return false;
		}
		if($this->aop->rsaCheckV1($_POST, NULL, "RSA2")){
		    $redata=array(
				'orderno'=>$_POST['out_trade_no'],
				'amount'=>$_POST['total_amount'],
				'other'=>$_POST['passback_params'],
				'pay_id'=>$_POST['trade_no'],
				'pay_way'=>'支付宝',
				'pay_time'=>strtotime($_POST['gmt_payment']),
			);
			return $redata;
		}
	}
	
	/**
	 * 回调通知
	 */
	function notifyReturn(){
		return 'success';
	}
	
	
}