<?php
/**
 * 支付宝接口类
 */
namespace pay;

class Codealipay{
	
	protected $codepay_id;
	protected $codepay_key;
	
	
    public function __construct($config=array()){
    	$config = api('Config/lists');
        C($config);
		$pay_codepay=C('PAY_CODEPAY');
		$this->codepay_id=$pay_codepay['codepay_id'];
		$this->codepay_key=$pay_codepay['codepay_key'];
    	foreach ($config as $k => $v) {
    		$this->$k=$v;
    	}
    }
    


	/**
	 * app支付  2018-04-04
	 * $param 数组
	 * title  商品标题
	 * orderno 订单号
	 * amount 付款金额
	 * notify_url 支付回调地址
	 * return_url 支付成功跳转地址
	 * other 其它参数
	 */
	function pc($param){
		$data = array(
		    "id" => $this->codepay_id,//你的码支付ID
		    "pay_id" => $param['orderno'], //唯一标识 可以是用户ID,用户名,session_id(),订单ID,ip 付款后返回
		    "type" => 1,//1支付宝支付 3微信支付 2QQ钱包
		    "price" => $param['amount'],//金额100元
		    "param" => "",//自定义参数
		    "notify_url"=>$param['notify_url'],//通知地址
		    "return_url"=>$param['return_url'],//跳转地址
		); //构造需要传递的参数
		
		
		ksort($data); //重新排序$data数组
		reset($data); //内部指针指向数组中的第一个元素
		
		$sign = ''; //初始化需要签名的字符为空
		$urls = ''; //初始化URL参数为空
		
		foreach ($data AS $key => $val) { //遍历需要传递的参数
		    if ($val == ''||$key == 'sign') continue; //跳过这些不参数签名
		    if ($sign != '') { //后面追加&拼接URL
		        $sign .= "&";
		        $urls .= "&";
		    }
		    $sign .= "$key=$val"; //拼接为url参数形式
		    $urls .= "$key=" . urlencode($val); //拼接为url参数形式并URL编码参数值
		
		}
		$query = $urls . '&sign=' . md5($sign .$this->codepay_key); //创建订单所需的参数
		$url = "http://api2.fateqq.com:52888/creat_order/?{$query}"; //支付页面
		
		
        R('Pay/view',array(array(
			'orderno'=>$param['orderno'],
			'ctime'=>time(),
			'code'=>$url,
			'model'=>$param['model'],
			'amount'=>$param['amount'],
			'gourl'=>$param['return_url'],
			'pay_way'=>'dzwxpay',
			'tpl'=>'Pay_alipay_pc',
		)));
	}

	/**
    * 生成手机版网页支付代码
    * @param   array   $param      订单信息
    */
	function wap($param){
		$this->pc($param);
	}
	
	
	/**
	 * 验签方法 2018-04-04
	 * @return boolean
	 */
	function check(){
		$data = $_POST; //构造需要传递的参数
		
		ksort($data); //重新排序$data数组
		reset($data); //内部指针指向数组中的第一个元素
		
		$sign = ''; //初始化需要签名的字符为空
		$urls = ''; //初始化URL参数为空
		
		foreach ($data AS $key => $val) { //遍历需要传递的参数
		    if ($val == ''||$key == 'sign') continue; //跳过这些不参数签名
		    if ($sign != '') { //后面追加&拼接URL
		        $sign .= "&";
		        $urls .= "&";
		    }
		    $sign .= "$key=$val"; //拼接为url参数形式
		    $urls .= "$key=" . urlencode($val); //拼接为url参数形式并URL编码参数值
		
		}
		$sign=md5($sign .$this->codepay_key);
		
		
		if($sign==$data['sign'] && $_POST['money']>=$_POST['price']){
		  	$redata=array(
				'orderno'=>$_POST['pay_id'],
				'amount'=>$_POST['price'],
				'other'=>'',
				'pay_id'=>$_POST['trade_no'],
				'pay_way'=>'码支付支付宝',
				'pay_time'=>time(),
			);
			return $redata;
		}else{
		    return false;
		}
	}
	
	/**
	 * 回调通知
	 */
	function notifyReturn(){
		return 'ok';
	}
	
	
}