<?php
/**
 * 支付宝接口类
 */
namespace pay;

class Dzqqpay{
	
    public function __construct($config=array()){
    	import('vendor.dianzhui.lib.DzPay#Api','','.php');
    	foreach ($config as $k => $v) {
    		$this->$k=$v;
    	}
    }
    


	/**
	 * app支付  2018-04-04
	 * $param 数组
	 * title  商品标题
	 * orderno 订单号
	 * amount 付款金额
	 * notify_url 支付回调地址
	 * return_url 支付成功跳转地址
	 * other 其它参数
	 */
	function pc($param){
		$input = new \QQScancode();
		$input->SetProductName($param['title']);
		$input->SetProductDescription($param['title']);
		$input->SetAmount($param['amount']);
		$input->SetMerchantOrderNo($param['orderno']);
		$input->SetNotifyUrl($param['notify_url']);
		$input->SetExtMsg($param['other']);
		$pay = new \Pay();
        $result = $pay->Payment($input,5);
        if($result->GetSuccess())
        {
        	R('Pay/view',array(array(
				'orderno'=>$param['orderno'],
				'ctime'=>time(),
				'code'=>$result->GetData("ToPayData"),
				'model'=>$param['model'],
				'amount'=>$param['amount'],
				'gourl'=>$param['return_url'],
				'pay_way'=>'qqpay',
				'tpl'=>'Pay_qqpay_pc',
			)));
        }else{
            echo $result->GetData("RespMessage");
        }
	}

	/**
    * 生成手机版网页支付代码
    * @param   array   $param      订单信息
    */
	function wap($param){
		$orderno = $param['order_no'];
		$title = isset($param['title'])?$param['title']:'订单'.$orderno;//订单名称，必填
		$amount = $param['amount'];//付款金额，必填
		$body = isset($param['body'])?$param['body']:'订单'.$orderno;//商品描述，可空
	    $timeout_express="1m";//超时时间
	
	    $payRequestBuilder = new \alipay\wappay\buildermodel\AlipayTradeWapPayContentBuilder();
	    $payRequestBuilder->setBody($body);
	    $payRequestBuilder->settitle($title);
	    $payRequestBuilder->setOutTradeNo($orderno);
	    $payRequestBuilder->setTotalAmount($amount);
	    $payRequestBuilder->setTimeExpress($timeout_express);
	
	    $payResponse = new \alipay\wappay\service\AlipayTradeService($this->config);
	    $result=$payResponse->wapPay($payRequestBuilder,$this->config['return_url'],$this->config['notify_url']);
	}
	
	/**
	 * app支付  2018-04-02
	 * $param 数组
	 * title  商品标题
	 * orderno 订单号
	 * amount 付款金额
	 * notify_url 支付回调地址
	 */
   	public function app($param){
   		vendor('autoload');
		$request = new \alipay\aop\request\AlipayTradeAppPayRequest();
		$param['product_code']='QUICK_MSECURITY_PAY';
		$request->setNotifyUrl($param['notify_url']);
		$bizcontent = json_encode($param);
		$request->setBizContent($bizcontent);
		$response = $this->aop->sdkExecute($request);
		return $response;//就是orderString 可以直接给客户端请求，无需再做处理。
	}
	
	/**
	 * 验签方法 2018-04-04
	 * @return boolean
	 */
	function check(){
		$result = \Respbase::InitFromArray($_REQUEST);
		if($result->GetSuccess()){
		    $platformOrderNo = $result->GetData("PlatformOrderNo");//平台单号
		    $merchantOrderNo = $result->GetData("MerchantOrderNo");//商户单号
		    $amount = $result->GetData("Amount");//订单金额
		    $status = $result->GetData("Status");//订单状态
		    if($status!=1){
		       return false; 
		    }
		  	$redata=array(
				'orderno'=>$merchantOrderNo,
				'amount'=>$amount,
				'other'=>$result->GetData("ExtMsg"),
				'pay_id'=>$platformOrderNo,
				'pay_way'=>'点缀QQ',
				'pay_time'=>time(),
			);
			return $redata;
		}else{
		    return false;
		}
	}
	
	/**
	 * 回调通知
	 */
	function notifyReturn(){
		return 'ok';
	}
	
	
}