<?php
/**
 * Config.php
 * Niushop商城系统 - 团队十年电商经验汇集巨献!
 * =========================================================
 * Copy right 2015-2025 山西牛酷信息科技有限公司, 保留所有权利。
 * ----------------------------------------------
 * 官方网址: http://www.niushop.com.cn
 * 这不是一个自由软件！您只能在不用于商业目的的前提下对程序代码进行修改和使用。
 * 任何企业和个人不允许对程序代码以任何形式任何目的再发布。
 * =========================================================
 * @author : niuteam
 * @date : 2015.1.17
 * @version : v1.0.0.0
 */
namespace app\admin\controller;

use app\api\controller\User;
use data\extend\Send;
use data\service\Address as DataAddress;
use data\service\Config as WebConfig;
use data\service\Platform;
use data\service\Promotion;
use data\service\Shop as Shop;
use think\Config as thinkConfig;

/**
 * 网站设置模块控制器
 *
 * @author Administrator
 *        
 */
class Config extends BaseController
{

    public $backup_path = "runtime/dbsql/";

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * 网站设置
     */
    public function webConfig()
    {
        if ($_POST) {
            // 网站设置
            $title = $_POST['title']; // 网站标题
            $logo = $_POST['logo']; // 网站logo
            $web_desc = $_POST['web_desc']; // 网站描述
            $key_words = $_POST['key_words']; // 网站关键字
            $web_icp = $_POST['web_icp']; // 网站备案号
            $web_style = $_POST['web_style']; // 网站风格
            $web_qrcode = $_POST['web_qrcode']; // 网站公众号二维码
            $web_url = $_POST['web_url']; // 店铺网址
            $web_phone = $_POST['web_phone']; // 网站联系方式
            $web_email = $_POST['web_email']; // 网站邮箱
            $web_qq = $_POST['web_qq']; // 网站qq号
            $web_weixin = $_POST['web_weixin']; // 网站微信号
            $web_address = $_POST['web_address']; // 网站联系地址
            
            $web_status = request()->post("web_status", ''); // 网站运营状态
            $wap_status = request()->post("wap_status", ''); // 手机端网站运营状态
            $third_count = request()->post("third_count", ''); // 第三方统计
            $close_reason = request()->post("close_reason", ''); // 站点关闭原因
            
            $retval = $this->website->updateWebSite($title, $logo, $web_desc, $key_words, $web_icp, $web_style, $web_qrcode, $web_url, $web_phone, $web_email, $web_qq, $web_weixin, $web_address, $web_status, $wap_status, $third_count, $close_reason);
            return AjaxReturn($retval);
        } else {
            
            $child_menu_list = array(
                array(
                    'url' => "config/webconfig.html",
                    'menu_name' => "网站设置",
                    "active" => 1
                ),
                array(
                    'url' => "config/seoConfig.html",
                    'menu_name' => "SEO设置",
                    "active" => 0
                )
            );
            
            $this->assign('child_menu_list', $child_menu_list);
            $list = $this->website->getWebSiteInfo();
            $style_list = $this->website->getWebStyleList();
            if (! file_exists('upload/qrcode/url.png')) {
                $path = getQRcode(request()->domain() . thinkConfig::get('view_replace_str.APP_MAIN'), 'upload/qrcode', 'url');
            } else {
                $path = 'upload/qrcode/url.png';
            }
            $this->assign('style_list', $style_list);
            $this->assign("website", $list);
            $this->assign("qrcode_path", $path);
            return view($this->style . "Config/webConfig");
        }
    }

    /*
     * public function webSeoConfig(){
     * $config = new WebConfig();
     * $seo_config = $config->getConfig(0, 'SEO_TITLE,SEO_DESC,SEO_META,SEO_OTHER');
     * var_dump($seo_config);
     *
     * }
     */
    /**
     * seo设置
     */
    public function seoConfig()
    {
        $child_menu_list = array(
            array(
                'url' => "config/webconfig.html",
                'menu_name' => "网站设置",
                "active" => 0
            ),
            array(
                'url' => "config/seoconfig.html",
                'menu_name' => "SEO设置",
                "active" => 1
            )
        );
        
        $this->assign('child_menu_list', $child_menu_list);
        
        if (request()->isAjax()) {
            $shop_id = $this->instance_id;
            $seo_title = request()->post("seo_title", '');
            $seo_meta = request()->post("seo_meta", '');
            $seo_desc = request()->post("seo_desc", '');
            $seo_other = request()->post("seo_other", '');
            $Config = new WebConfig();
            $retval = $Config->SetSeoConfig($shop_id, $seo_title, $seo_meta, $seo_desc, $seo_other);
            return AjaxReturn($retval);
        } else {
            $Config = new WebConfig();
            $shop_id = $this->instance_id;
            $shopSet = $Config->getSeoConfig($shop_id);
            $this->assign("info", $shopSet);
        }
        return view($this->style . "Config/seoConfig");
    }

    /**
     * qq登录配置
     *
     * @return Ambigous <\think\response\View, \think\response\$this, \think\response\View>
     */
    public function loginQQConfig()
    {
        $appkey = isset($_POST['appkey']) ? $_POST['appkey'] : '';
        $appsecret = isset($_POST['appsecret']) ? $_POST['appsecret'] : '';
        $url = isset($_POST['url']) ? $_POST['url'] : '';
        $call_back_url = isset($_POST['call_back_url']) ? $_POST['call_back_url'] : '';
        $is_use = isset($_POST['is_use']) ? $_POST['is_use'] : 0;
        $web_config = new WebConfig();
        // 获取数据
        $retval = $web_config->setQQConfig($this->instance_id, $appkey, $appsecret, $url, $call_back_url, $is_use);
        return AjaxReturn($retval);
    }

    /**
     * 微信登录配置
     *
     * @return Ambigous <\think\response\View, \think\response\$this, \think\response\View>
     */
    public function loginWeixinConfig()
    {
        $appid = isset($_POST['appkey']) ? $_POST['appkey'] : '';
        $appsecret = isset($_POST['appsecret']) ? $_POST['appsecret'] : '';
        $url = isset($_POST['url']) ? $_POST['url'] : '';
        $call_back_url = isset($_POST['call_back_url']) ? $_POST['call_back_url'] : '';
        $is_use = isset($_POST['is_use']) ? $_POST['is_use'] : 0;
        $web_config = new WebConfig();
        // 获取数据
        $retval = $web_config->setWchatConfig($this->instance_id, $appid, $appsecret, $url, $call_back_url, $is_use);
        return AjaxReturn($retval);
    }

    /**
     * 第三方登录 页面显示
     */
    public function loginConfig()
    {
        $type = isset($_GET["type"]) ? $_GET["type"] : "qq";
        if ($type == "qq") {
            $child_menu_list = array(
                array(
                    'url' => "config/loginconfig?type=qq",
                    'menu_name' => "qq登录",
                    "active" => 1
                )
            );
        } else {
            $child_menu_list = array(
                array(
                    'url' => "config/loginconfig?type=wchat",
                    'menu_name' => "微信登录",
                    "active" => 1
                )
            );
        }
        $this->assign('child_menu_list', $child_menu_list);
        $this->assign("type", $type);
        $web_config = new WebConfig();
        // qq登录配置
        // 获取当前域名
        $domain_name = \think\Request::instance()->domain();
        // 获取回调域名qq回调域名
        $qq_call_back = $domain_name . \think\Request::instance()->root() . '/wap/login/callback';
        // 获取qq配置信息
        $qq_config = $web_config->getQQConfig($this->instance_id);
        $qq_config['value']["AUTHORIZE"] = $domain_name;
        $qq_config['value']["CALLBACK"] = $qq_call_back;
        $this->assign("qq_config", $qq_config);
        // 微信登录配置
        // 微信登录返回
        $wchat_call_back = $domain_name . \think\Request::instance()->root() . '/wap/Login/callback';
        $wchat_config = $web_config->getWchatConfig($this->instance_id);
        $wchat_config['value']["AUTHORIZE"] = $domain_name;
        $wchat_config['value']["CALLBACK"] = $wchat_call_back;
        $this->assign("wchat_config", $wchat_config);
        
        return view($this->style . "Config/loginConfig");
    }

    /**
     * 支付配置--微信
     *
     * @return Ambigous <\think\response\View, \think\response\$this, \think\response\View>
     */
    public function payConfig()
    {
        if (request()->isAjax()) {
            $type = isset($_POST['type']) ? $_POST['type'] : '';
            if ($type == 'wchat') {
                // 微信支付
                $appkey = str_replace(' ', '', request()->post('appkey', ''));
                $appsecret = str_replace(' ', '', request()->post('appsecret', ''));
                $paySignKey = str_replace(' ', '', request()->post('paySignKey', ''));
                $MCHID = str_replace(' ', '', request()->post('MCHID', ''));
                $is_use = isset($_POST['is_use']) ? $_POST['is_use'] : 0;
                $web_config = new WebConfig();
                // 获取数据
                $retval = $web_config->setWpayConfig($this->instance_id, $appkey, $appsecret, $MCHID, $paySignKey, $is_use);
                return AjaxReturn($retval);
            } /*
               * else {
               * // 支付宝
               * $partnerid = isset($_POST['partnerid']) ? $_POST['partnerid'] : '';
               * $seller = isset($_POST['seller']) ? $_POST['seller'] : '';
               * $ali_key = isset($_POST['ali_key']) ? $_POST['ali_key'] : '';
               * $is_use = isset($_POST['is_use']) ? $_POST['is_use'] : 0;
               * $web_config = new WebConfig();
               * // 获取数据
               * $retval = $web_config->setAlipayConfig($this->instance_id, $partnerid, $seller, $ali_key, $is_use);
               * return AjaxReturn($retval);
               * }
               */
        } else {
            $type = isset($_GET['type']) ? $_GET['type'] : 'wchat';
            if ($type == 'wchat') {
                
                /*
                 * $child_menu_list = array(
                 * array(
                 * 'url' => "Config/payConfig?type=wchat",
                 * 'menu_name' => "微信支付",
                 * "active" => 1
                 * ),
                 * array(
                 * 'url' => "Config/payConfig?type=ali",
                 * 'menu_name' => "支付宝支付",
                 * "active" => 0
                 * )
                 * );
                 * $this->assign('child_menu_list', $child_menu_list);
                 */
                $web_config = new WebConfig();
                $data = $web_config->getWpayConfig($this->instance_id);
                // var_dump($data);die;
                $this->assign("config", $data);
                return view($this->style . "Config/payConfig");
            } /*
               * else {
               * $child_menu_list = array(
               * array(
               * 'url' => "Config/payConfig?type=wchat",
               * 'menu_name' => "微信支付",
               * "active" => 0
               * ),
               * array(
               * 'url' => "Config/payConfig?type=ali",
               * 'menu_name' => "支付宝支付",
               * "active" => 1
               * )
               * );
               * $this->assign('child_menu_list', $child_menu_list);
               * $web_config = new WebConfig();
               * $data = $web_config->getAlipayConfig($this->instance_id);
               * $this->assign("config", $data);
               * return view($this->style . "Config/payAliConfig");
               * }
               */
        }
    }

    /**
     * 支付宝配置
     */
    public function payAliConfig()
    {
        if (request()->isAjax()) {
            // 支付宝
            $partnerid = str_replace(' ', '', request()->post('partnerid', ''));
            $seller = str_replace(' ', '', request()->post('seller', ''));
            $ali_key = str_replace(' ', '', request()->post('ali_key', ''));
            $is_use = isset($_POST['is_use']) ? $_POST['is_use'] : 0;
            $web_config = new WebConfig();
            // 获取数据
            $retval = $web_config->setAlipayConfig($this->instance_id, $partnerid, $seller, $ali_key, $is_use);
            return AjaxReturn($retval);
        }
        $web_config = new WebConfig();
        $data = $web_config->getAlipayConfig($this->instance_id);
        $this->assign("config", $data);
        return view($this->style . "Config/payAliConfig");
    }

    /**
     * 设置微信和支付宝开关状态是否启用
     */
    public function setStatus()
    {
        $web_config = new WebConfig();
        if (request()->isAjax()) {
            $is_use = request()->post("is_use", '');
            $type = request()->post("type", '');
            $retval = $web_config->setWpayStatusConfig($this->instance_id, $is_use, $type);
            return AjaxReturn($retval);
        }
    }

    /**
     * 广告列表
     */
    public function shopAdList()
    {
        if (request()->isAjax()) {
            $shop_ad = new Shop();
            
            $list = $shop_ad->getShopAdList(1, 10, [
                'shop_id' => $this->instance_id
            ], 'sort');
            return $list;
        }
        return view($this->style . "Config/shopAdList");
    }

    /**
     * 添加店铺广告
     *
     * @return \think\response\View
     */
    public function addShopAd()
    {
        if (request()->isAjax()) {
            $ad_image = isset($_POST['ad_image']) ? $_POST['ad_image'] : '';
            $link_url = isset($_POST['link_url']) ? $_POST['link_url'] : '';
            $sort = isset($_POST['sort']) ? $_POST['sort'] : 0;
            $type = isset($_POST['type']) ? $_POST['type'] : 0;
            $background = isset($_POST['background']) ? $_POST['background'] : '#FFFFFF';
            $shop_ad = new Shop();
            $res = $shop_ad->addShopAd($ad_image, $link_url, $sort, $type, $background);
            return AjaxReturn($res);
        }
        return view($this->style . "Config/addShopAd");
    }

    /**
     * 修改店铺广告
     */
    public function updateShopAd()
    {
        if (request()->isAjax()) {
            $id = isset($_POST['id']) ? $_POST['id'] : '';
            $ad_image = isset($_POST['ad_image']) ? $_POST['ad_image'] : '';
            $link_url = isset($_POST['link_url']) ? $_POST['link_url'] : '';
            $sort = isset($_POST['sort']) ? $_POST['sort'] : 0;
            $type = isset($_POST['type']) ? $_POST['type'] : 0;
            $background = isset($_POST['background']) ? $_POST['background'] : '#FFFFFF';
            $shop_ad = new Shop();
            $res = $shop_ad->updateShopAd($id, $ad_image, $link_url, $sort, $type, $background);
            return AjaxReturn($res);
        }
        $shop_ad = new Shop();
        $id = isset($_GET['id']) ? $_GET['id'] : '';
        $info = $shop_ad->getShopAdDetail($id);
        $this->assign('info', $info);
        return view($this->style . "Config/updateShopAd");
    }

    public function delShopAd()
    {
        $id = isset($_POST['id']) ? $_POST['id'] : '';
        $res = 0;
        if (! empty($id)) {
            $shop_ad = new Shop();
            $res = $shop_ad->delShopAd($id);
        }
        return AjaxReturn($res);
    }

    /**
     * 店铺导航列表
     */
    public function shopNavigationList()
    {
        if (request()->isAjax()) {
            $shop = new Shop();
            $page_index = request()->post("page_index", 1);
            $page_size = request()->post('page_size', PAGESIZE);
            $list = $shop->ShopNavigationList($page_index, $page_size, '', 'sort');
            return $list;
        } else {
            return view($this->style . "Config/shopNavigationList");
        }
    }

    /**
     * 店铺导航添加
     *
     * @return multitype:unknown
     */
    public function addShopNavigation()
    {
        if (request()->isAjax()) {
            $shop = new Shop();
            $nav_title = isset($_POST['nav_title']) ? $_POST['nav_title'] : '';
            $nav_url = isset($_POST['nav_url']) ? $_POST['nav_url'] : '';
            $type = isset($_POST['type']) ? $_POST['type'] : '';
            $sort = isset($_POST['sort']) ? $_POST['sort'] : '';
            $align = isset($_POST['align']) ? $_POST['align'] : '';
            $nav_type = request()->post("nav_type", '');
            $is_blank = request()->post("is_blank", '');
            $template_name = request()->post("template_name", '');
            $retval = $shop->addShopNavigation($nav_title, $nav_url, $type, $sort, $align, $nav_type, $is_blank, $template_name);
            return AjaxReturn($retval);
        } else {
            $shop = new Shop();
            $shopNavTemplate = $shop->getShopNavigationTemplate(1);
            $this->assign("shopNavTemplate", $shopNavTemplate);
            return view($this->style . "Config/addShopNavigation");
        }
    }

    /**
     * 修改店铺导航
     *
     * @return multitype:unknown
     */
    public function updateShopNavigation()
    {
        if (request()->isAjax()) {
            $shop = new Shop();
            $nav_id = isset($_POST['nav_id']) ? $_POST['nav_id'] : '';
            $nav_title = isset($_POST['nav_title']) ? $_POST['nav_title'] : '';
            $nav_url = isset($_POST['nav_url']) ? $_POST['nav_url'] : '';
            $type = isset($_POST['type']) ? $_POST['type'] : '';
            $sort = isset($_POST['sort']) ? $_POST['sort'] : '';
            $align = isset($_POST['align']) ? $_POST['align'] : '';
            $nav_type = request()->post("nav_type", '');
            $is_blank = request()->post("is_blank", '');
            $template_name = request()->post("template_name", '');
            $retval = $shop->updateShopNavigation($nav_id, $nav_title, $nav_url, $type, $sort, $align, $nav_type, $is_blank, $template_name);
            return AjaxReturn($retval);
        } else {
            $shop = new Shop();
            $nav_id = isset($_GET['nav_id']) ? $_GET['nav_id'] : '';
            $data = $shop->shopNavigationDetail($nav_id);
            $this->assign('data', $data);
            $shopNavTemplate = $shop->getShopNavigationTemplate(1);
            $this->assign("shopNavTemplate", $shopNavTemplate);
            return view($this->style . "Config/updateShopNavigation");
        }
    }

    /**
     * 删除店铺导航
     *
     * @return multitype:unknown
     */
    public function delShopNavigation()
    {
        if (request()->isAjax()) {
            $shop = new Shop();
            $nav_id = isset($_POST['nav_id']) ? $_POST['nav_id'] : '';
            $retval = $shop->delShopNavigation($nav_id);
            return AjaxReturn($retval);
        }
    }

    /**
     * 修改店铺导航排序
     *
     * @return multitype:unknown
     */
    public function modifyShopNavigationSort()
    {
        if (request()->isAjax()) {
            $shop = new Shop();
            $nav_id = isset($_POST['nav_id']) ? $_POST['nav_id'] : '';
            $sort = isset($_POST['sort']) ? $_POST['sort'] : '';
            $retval = $shop->modifyShopNavigationSort($nav_id, $sort);
            return AjaxReturn($retval);
        }
    }

    /**
     * 友情链接列表
     *
     * @return unknown[]
     */
    public function linkList()
    {
        if (request()->isAjax()) {
            $page_index = request()->post("page_index", 1);
            $page_size = request()->post('page_size', PAGESIZE);
            $search_text = isset($_POST['search_text']) ? $_POST['search_text'] : '';
            $platform = new Platform();
            $list = $platform->getLinkList($page_index, $page_size, [
                'link_title' => array(
                    'like',
                    '%' . $search_text . '%'
                )
            ], 'link_sort ASC');
            return $list;
        }
        return view($this->style . "Config/linkList");
    }

    /**
     * 添加友情链接
     *
     * @return unknown[]
     */
    public function addLink()
    {
        if (request()->isAjax()) {
            $link_title = isset($_POST["link_title"]) ? $_POST["link_title"] : '';
            $link_url = isset($_POST["link_url"]) ? $_POST["link_url"] : '';
            $link_pic = isset($_POST["link_pic"]) ? $_POST["link_pic"] : '';
            $link_sort = isset($_POST["link_sort"]) ? $_POST["link_sort"] : 0;
            $is_blank = request()->post("is_blank", '');
            $is_show = request()->post("is_show", '');
            $platform = new Platform();
            $res = $platform->addLink($link_title, $link_url, $link_pic, $link_sort, $is_blank, $is_show);
            return AjaxReturn($res);
        }
        return view($this->style . "Config/addLink");
    }

    /**
     * 修改友情链接
     */
    public function updateLink()
    {
        if (request()->isAjax()) {
            $link_id = isset($_POST["link_id"]) ? $_POST["link_id"] : '';
            $link_title = isset($_POST["link_title"]) ? $_POST["link_title"] : '';
            $link_url = isset($_POST["link_url"]) ? $_POST["link_url"] : '';
            $link_pic = isset($_POST["link_pic"]) ? $_POST["link_pic"] : '';
            $link_sort = isset($_POST["link_sort"]) ? $_POST["link_sort"] : 0;
            $is_blank = request()->post("is_blank", '');
            $is_show = request()->post("is_show", '');
            $platform = new Platform();
            $res = $platform->updateLink($link_id, $link_title, $link_url, $link_pic, $link_sort, $is_blank, $is_show);
            return AjaxReturn($res);
        }
        $link_id = isset($_GET["link_id"]) ? $_GET["link_id"] : '';
        $platform = new Platform();
        $link_info = $platform->getLinkDetail($link_id);
        $this->assign('link_info', $link_info);
        return view($this->style . "Config/updateLink");
    }

    /**
     * 删除友情链接
     *
     * @return unknown[]
     */
    public function delLink()
    {
        $link_id = isset($_POST["link_id"]) ? $_POST["link_id"] : '';
        $platform = new Platform();
        $res = $platform->deleteLink($link_id);
        return AjaxReturn($res);
    }

    /**
     * 搜索设置
     */
    public function searchConfig()
    {
        $type = isset($_GET["type"]) ? $_GET["type"] : "hot";
        if ($type == "hot") {
            $child_menu_list = array(
                array(
                    'url' => "Config/searchConfig?type=hot",
                    'menu_name' => "热门搜索",
                    "active" => 1
                ),
                array(
                    'url' => "Config/searchConfig?type=default",
                    'menu_name' => "默认搜索",
                    "active" => 0
                )
            );
        } else {
            
            $child_menu_list = array(
                array(
                    'url' => "Config/searchConfig?type=hot",
                    'menu_name' => "热门搜索",
                    "active" => 0
                ),
                array(
                    'url' => "Config/searchConfig?type=default",
                    'menu_name' => "默认搜索",
                    "active" => 1
                )
            );
        }
        $web_config = new WebConfig();
        // 热门搜索
        $keywords_array = $web_config->getHotsearchConfig($this->instance_id);
        if (! empty($keywords_array)) {
            $keywords = implode(",", $keywords_array);
        } else {
            $keywords = '';
        }
        $this->assign('hot_keywords', $keywords);
        // 默认搜索
        $default_keywords = $web_config->getDefaultSearchConfig($this->instance_id);
        $this->assign('default_keywords', $default_keywords);
        $this->assign('child_menu_list', $child_menu_list);
        $this->assign('type', $type);
        return view($this->style . "Config/searchConfig");
    }

    /**
     * 热门搜索 提交修改
     */
    public function hotSearchConfig()
    {
        $keywords = isset($_POST["keywords"]) ? $_POST["keywords"] : '';
        if (! empty($keywords)) {
            $keywords_array = explode(",", $keywords);
        } else {
            $keywords_array = array();
        }
        $web_config = new WebConfig();
        $res = $web_config->setHotsearchConfig($this->instance_id, $keywords_array, 1);
        return AjaxReturn($res);
    }

    /**
     * 默认搜索 提交修改
     */
    public function defaultSearchConfig()
    {
        $keywords = isset($_POST["default_keywords"]) ? $_POST["default_keywords"] : '';
        $web_config = new WebConfig();
        $res = $web_config->setDefaultSearchConfig($this->instance_id, $keywords, 1);
        return AjaxReturn($res);
    }

    /**
     * 验证码设置
     *
     * @return \think\response\View
     */
    public function codeConfig()
    {
        $webConfig = new WebConfig();
        if (request()->isAjax()) {
            $platform = 0; // isset($_POST['platform']) ? $_POST['platform'] : '';
            $admin = isset($_POST['adminCode']) ? $_POST['adminCode'] : 0;
            $pc = isset($_POST['pcCode']) ? $_POST['pcCode'] : 0;
            $res = $webConfig->setLoginVerifyCodeConfig($this->instance_id, $platform, $admin, $pc);
            return AjaxReturn($res);
        }
        $code_config = $webConfig->getLoginVerifyCodeConfig($this->instance_id);
        $this->assign('code_config', $code_config["value"]);
        return view($this->style . 'Config/codeConfig');
    }

    /**
     * 邮件短信接口设置
     */
    public function messageConfig()
    {
        $type = isset($_GET["type"]) ? $_GET["type"] : "email";
        if ($type == 'email') {
            $child_menu_list = array(
                array(
                    'url' => "Config/messageConfig?type=email",
                    'menu_name' => "邮箱设置",
                    "active" => 1
                ),
                array(
                    'url' => "Config/messageConfig?type=sms",
                    'menu_name' => "短信设置",
                    "active" => 0
                )
            );
        } else {
            $child_menu_list = array(
                array(
                    'url' => "Config/messageConfig?type=email",
                    'menu_name' => "邮箱设置",
                    "active" => 0
                ),
                array(
                    'url' => "Config/messageConfig?type=sms",
                    'menu_name' => "短信设置",
                    "active" => 1
                )
            );
        }
        $config = new WebConfig();
        $email_message = $config->getEmailMessage($this->instance_id);
        $this->assign('email_message', $email_message);
        $mobile_message = $config->getMobileMessage($this->instance_id);
        $this->assign('mobile_message', $mobile_message);
        $this->assign('child_menu_list', $child_menu_list);
        $this->assign('type', $type);
        return view($this->style . 'Config/messageConfig');
    }

    /**
     * ajax 邮件接口
     */
    public function setEmailMessage()
    {
        $email_host = isset($_POST['email_host']) ? $_POST['email_host'] : '';
        $email_port = isset($_POST['email_port']) ? $_POST['email_port'] : '';
        $email_addr = isset($_POST['email_addr']) ? $_POST['email_addr'] : '';
        $email_id = isset($_POST['email_id']) ? $_POST['email_id'] : '';
        $email_pass = isset($_POST['email_pass']) ? $_POST['email_pass'] : '';
        $is_use = isset($_POST['is_use']) ? $_POST['is_use'] : '';
        $config = new WebConfig();
        $res = $config->setEmailMessage($this->instance_id, $email_host, $email_port, $email_addr, $email_id, $email_pass, $is_use);
        return AjaxReturn($res);
    }

    /**
     * ajax 短信接口
     *
     * @return unknown[]
     */
    public function setMobileMessage()
    {
        $app_key = isset($_POST['app_key']) ? $_POST['app_key'] : '';
        $secret_key = isset($_POST['secret_key']) ? $_POST['secret_key'] : '';
        $free_sign_name = isset($_POST['free_sign_name']) ? $_POST['free_sign_name'] : '';
        $is_use = isset($_POST['is_use']) ? $_POST['is_use'] : '';
        $config = new WebConfig();
        $res = $config->setMobileMessage($this->instance_id, $app_key, $secret_key, $free_sign_name, $is_use);
        return AjaxReturn($res);
    }

    /**
     * 邮件发送测试接口
     *
     * @return unknown[]
     */
    public function testSend()
    {
        $send = new Send();
        $toemail = $_POST['email_test'];
        $title = 'Niushop测试邮箱发送';
        $content = '测试邮箱发送成功不成功？';
        $config = new WebConfig();
        $email_message = $config->getEmailMessage($this->instance_id);
        $email_value = $email_message["value"];
        $res = emailSend($email_value['email_host'], $email_value['email_id'], $email_value['email_pass'], $email_value['email_addr'], $toemail, $title, $content);
        if ($res) {
            return AjaxReturn(1);
        } else {
            return AjaxReturn(- 1);
        }
    }

    /**
     * 帮助类型
     *
     * @return unknown
     */
    public function helpclass()
    {
        if (request()->isAjax()) {
            $page_index = request()->post("page_index", 1);
            $page_size = request()->post('page_size', PAGESIZE);
            $platform = new Platform();
            $list = $platform->getPlatformHelpClassList($page_index, $page_size, [
                'type' => 1
            ], 'sort');
            return $list;
        }
        return view($this->style . "Config/helpClass");
    }

    /**
     * 修改帮助类型
     * 任鹏强
     * 2017年2月18日14:26:20
     */
    public function updateClass()
    {
        if (request()->isAjax()) {
            $class_id = isset($_POST['class_id']) ? $_POST['class_id'] : '';
            $type = isset($_POST['type']) ? $_POST['type'] : 1;
            $class_name = isset($_POST['class_name']) ? $_POST['class_name'] : '';
            $parent_class_id = isset($_POST['parent_class_id']) ? $_POST['parent_class_id'] : 0;
            $sort = isset($_POST['sort']) ? $_POST['sort'] : '';
            $platform = new Platform();
            $res = $platform->updatePlatformClass($class_id, $type, $class_name, $parent_class_id, $sort);
            return AjaxReturn($res);
        }
    }

    /**
     * 删除帮助类型
     */
    public function classDelete()
    {
        $class_id = request()->post('class_id', '');
        $platform = new Platform();
        $retval = $platform->deleteHelpClass($class_id);
        return AjaxReturn($retval);
    }

    /**
     * 添加 帮助类型
     */
    public function addHelpClass()
    {
        if (request()->isAjax()) {
            $class_name = isset($_POST['class_name']) ? $_POST['class_name'] : '';
            $sort = isset($_POST['sort']) ? $_POST['sort'] : '';
            $platform = new Platform();
            $res = $platform->addPlatformHelpClass(1, $class_name, 0, $sort);
            return AjaxReturn($res);
        }
        return view($this->style . 'Config/addHelpClass');
    }

    /**
     * 删除帮助内容标题
     *
     * @return unknown[]
     */
    public function titleDelete()
    {
        $id = request()->post('id', '');
        $platform = new Platform();
        $res = $platform->deleteHelpTitle($id);
        return AjaxReturn($res);
    }

    /**
     * 帮助内容
     *
     * @return multitype:number unknown |Ambigous <\think\response\View, \think\response\$this, \think\response\View>
     */
    public function helpDocument()
    {
        if (request()->isAjax()) {
            $page_index = request()->post("page_index", 1);
            $page_size = request()->post('page_size', PAGESIZE);
            $platform = new Platform();
            $list = $platform->getPlatformHelpDocumentList($page_index, $page_size, '', 'sort');
            return $list;
        }
        return view($this->style . "Config/helpDocument");
    }

    /**
     * 修改内容
     */
    public function updateDocument()
    {
        $platform = new Platform();
        if (request()->isAjax()) {
            $uid = $this->user->getSessionUid();
            $id = isset($_POST['id']) ? $_POST['id'] : '';
            $title = isset($_POST['title']) ? $_POST['title'] : '';
            $class_id = isset($_POST['class_id']) ? $_POST['class_id'] : '';
            $link_url = isset($_POST['link_url']) ? $_POST['link_url'] : '';
            $content = isset($_POST['content']) ? $_POST['content'] : '';
            $image = isset($_POST['image']) ? $_POST['image'] : '';
            $sort = isset($_POST['sort']) ? $_POST['sort'] : 0;
            $revle = $platform->updatePlatformDocument($id, $uid, $class_id, $title, $link_url, $sort, $content, $image);
            return AjaxReturn($revle);
        } else {
            $id = isset($_GET['id']) ? $_GET['id'] : '';
            $this->assign('id', $id);
            $document_detail = $platform->getPlatformDocumentDetail($id);
            $document_detail["content"] = htmlspecialchars($document_detail["content"]);
            $this->assign('document_detail', $document_detail);
            $help_class_list = $platform->getPlatformHelpClassList();
            $this->assign('help_class_list', $help_class_list['data']);
            return view($this->style . 'Config/updateDocument');
        }
    }

    /**
     * 添加内容
     */
    public function addDocument()
    {
        $platform = new Platform();
        if (request()->isAjax()) {
            $uid = $this->user->getSessionUid();
            $title = isset($_POST['title']) ? $_POST['title'] : '';
            $class_id = isset($_POST['class_id']) ? $_POST['class_id'] : '';
            $link_url = isset($_POST['link_url']) ? $_POST['link_url'] : '';
            $content = isset($_POST['content']) ? $_POST['content'] : '';
            $image = isset($_POST['image']) ? $_POST['image'] : '';
            $sort = isset($_POST['sort']) ? $_POST['sort'] : '';
            $result = $platform->addPlatformDocument($uid, $class_id, $title, $link_url, $sort, $content, $image);
            return AjaxReturn($result);
        } else {
            $help_class_list = $platform->getPlatformHelpClassList();
            $this->assign('help_class_list', $help_class_list['data']);
            return view($this->style . 'Config/addDocument');
        }
    }

    /**
     * 用户通知 设置
     *
     * @return \think\response\View
     */
    public function userNotice()
    {
        $web_config = new WebConfig();
        if (request()->isAjax()) {
            $user_notice = isset($_POST['user_notice']) ? $_POST['user_notice'] : '';
            $res = $web_config->setUserNotice($this->instance_id, $user_notice, 1);
            return AjaxReturn($res);
        }
        $user_notice = $web_config->getUserNotice($this->instance_id);
        $this->assign('user_notice', $user_notice);
        return view($this->style . 'Config/userNotice');
    }

    /**
     * 奖励管理
     */
    public function bonuses()
    {
        if (request()->isAjax()) {
            $shop_id = $this->instance_id;
            $sign_point = isset($_POST['sign_point']) ? $_POST['sign_point'] : 0;
            $share_point = isset($_POST['share_point']) ? $_POST['share_point'] : 0;
            $reg_member_self_point = isset($_POST['reg_member_self_point']) ? $_POST['reg_member_self_point'] : 0;
            $reg_member_one_point = 0;
            $reg_member_two_point = 0;
            $reg_member_three_point = 0;
            $reg_promoter_self_point = 0;
            $reg_promoter_one_point = 0;
            $reg_promoter_two_point = 0;
            $reg_promoter_three_point = 0;
            $reg_partner_self_point = 0;
            $reg_partner_one_point = 0;
            $reg_partner_two_point = 0;
            $reg_partner_three_point = 0;
            $into_store_coupon = isset($_POST['into_store_coupon']) ? $_POST['into_store_coupon'] : 0;
            $share_coupon = isset($_POST['share_coupon']) ? $_POST['share_coupon'] : 0;
            $dataShop = new Shop();
            $res = $dataShop->setRewardRule($shop_id, $sign_point, $share_point, $reg_member_self_point, $reg_member_one_point, $reg_member_two_point, $reg_member_three_point, $reg_promoter_self_point, $reg_promoter_one_point, $reg_promoter_two_point, $reg_promoter_three_point, $reg_partner_self_point, $reg_partner_one_point, $reg_partner_two_point, $reg_partner_three_point, $into_store_coupon, $share_coupon);
            return AjaxReturn($res);
        }
        $dataShop = new Shop();
        $res = $dataShop->getRewardRuleDetail($this->instance_id);
        $this->assign("res", $res);
        // 查询未过期的优惠劵
        $coupon = new Promotion();
        $condition['shop_id'] = $this->instance_id;
        $nowTime = date("Y-m-d H:i:s");
        $condition['end_time'] = array(
            ">",
            $nowTime
        );
        $list = $coupon->getCouponTypeList(1, 0, $condition);
        $this->assign("coupon", $list['data']);
        return view($this->style . 'Config/bonuses');
    }

    /**
     * 修改公告
     * 
     * @return Ambigous <multitype:unknown, multitype:unknown unknown string >|Ambigous <\think\response\View, \think\response\$this, \think\response\View>
     */
    public function updateNotice()
    {
        $web_config = new WebConfig();
        $shopid = $this->instance_id;
        if (request()->isAjax()) {
            $notice_message = request()->post('notice_message', '');
            $is_enable = request()->post('is_enable', '');
            $res = $web_config->setNotice($shopid, $notice_message, $is_enable);
            return AjaxReturn($res);
        }
        
        $info = $web_config->getNotice($shopid);
        $this->assign('info', $info);
        return view($this->style . 'Config/updateNotice');
    }

    public function areaManagement()
    {
        $dataAddress = new DataAddress();
        $list = $dataAddress->getProvinceList();
        foreach ($list as $v) {
            if ($dataAddress->getCityCountByProvinceId($v['province_id']) > 0) {
                $v['issetLowerLevel'] = 1;
            } else {
                $v['issetLowerLevel'] = 0;
            }
        }
        $this->assign("list", $list);
        return view($this->style . 'Config/areaManagement');
    }

    public function selectCityListAjax()
    {
        if (request()->isAjax()) {
            $province_id = request()->post('province_id', '');
            $dataAddress = new DataAddress();
            $list = $dataAddress->getCityList($province_id);
            foreach ($list as $v) {
                if ($dataAddress->getDistrictCountByCityId($v['city_id']) > 0) {
                    $v['issetLowerLevel'] = 1;
                } else {
                    $v['issetLowerLevel'] = 0;
                }
            }
            return $list;
        }
    }

    public function selectDistrictListAjax()
    {
        if (request()->isAjax()) {
            $city_id = request()->post('city_id', '');
            $dataAddress = new DataAddress();
            $list = $dataAddress->getDistrictList($city_id);
            return $list;
        }
    }

    public function addCityAjax()
    {
        if (request()->isAjax()) {
            $dataAddress = new DataAddress();
            $city_id = 0;
            $province_id = request()->post('superiorRegionId', '');
            $city_name = request()->post('regionName', '');
            $zipcode = request()->post('zipcode', '');
            $sort = request()->post('regionSort', '');
            $res = $dataAddress->addOrupdateCity($city_id, $province_id, $city_name, $zipcode, $sort);
            return AjaxReturn($res);
        }
    }

    public function updateCityAjax()
    {
        if (request()->isAjax()) {
            $dataAddress = new DataAddress();
            $city_id = request()->post('eventId', '');
            $province_id = request()->post('superiorRegionId', '');
            $city_name = request()->post('regionName', '');
            $zipcode = request()->post('zipcode', '');
            $sort = request()->post('regionSort', '');
            $res = $dataAddress->addOrupdateCity($city_id, $province_id, $city_name, $zipcode, $sort);
            return AjaxReturn($res);
        }
    }

    public function addDistrictAjax()
    {
        if (request()->isAjax()) {
            $dataAddress = new DataAddress();
            $district_id = 0;
            $city_id = request()->post('superiorRegionId', '');
            $district_name = request()->post('regionName', '');
            $sort = request()->post('regionSort', '');
            $res = $dataAddress->addOrupdateDistrict($district_id, $city_id, $district_name, $sort);
            return AjaxReturn($res);
        }
    }

    public function updateDistrictAjax()
    {
        if (request()->isAjax()) {
            $dataAddress = new DataAddress();
            $district_id = request()->post('eventId', '');
            $city_id = request()->post('superiorRegionId', '');
            $district_name = request()->post('regionName', '');
            $sort = request()->post('regionSort', '');
            $res = $dataAddress->addOrupdateDistrict($district_id, $city_id, $district_name, $sort);
            return AjaxReturn($res);
        }
    }

    public function updateProvinceAjax()
    {
        if (request()->isAjax()) {
            $dataAddress = new DataAddress();
            $province_id = request()->post('eventId', '');
            $province_name = request()->post('regionName', '');
            $sort = request()->post('regionSort', '');
            $res = $dataAddress->updateProvince($province_id, $province_name, $sort);
            return AjaxReturn($res);
        }
    }

    public function addProvinceAjax()
    {
        if (request()->isAjax()) {
            $dataAddress = new DataAddress();
            $province_name = request()->post('regionName', '');
            $sort = request()->post('regionSort', '');
            $res = $dataAddress->addProvince($province_name, $sort);
            return AjaxReturn($res);
        }
    }

    public function deleteRegion()
    {
        if (request()->isAjax()) {
            $type = request()->post('type', '');
            $regionId = request()->post('regionId', '');
            $dataAddress = new DataAddress();
            if ($type == 1) {
                $res = $dataAddress->deleteProvince($regionId);
                return AjaxReturn($res);
            }
            if ($type == 2) {
                $res = $dataAddress->deleteCity($regionId);
                return AjaxReturn($res);
            }
            if ($type == 3) {
                $res = $dataAddress->deleteDistrict($regionId);
                return AjaxReturn($res);
            }
        }
    }

    public function updateRegionAjax()
    {
        if (request()->isAjax()) {
            $dataAddress = new DataAddress();
            $upType = request()->post('upType', '');
            $regionType = request()->post('regionType', '');
            $regionName = request()->post('regionName', '');
            $regionSort = request()->post('regionSort', '');
            $regionId = request()->post('regionId', '');
            $res = $dataAddress->updateRegionNameAndRegionSort($upType, $regionType, $regionName, $regionSort, $regionId);
            return AjaxReturn($res);
        }
    }

    /**
     * 购物设置
     */
    public function shopSet()
    {
        if (request()->isAjax()) {
            $shop_id = $this->instance_id;
            $order_auto_delinery = request()->post("order_auto_delinery", '') ? request()->post("order_auto_delinery", '') : 0;
            
            $order_balance_pay = request()->post("order_balance_pay", '') ? request()->post("order_balance_pay", '') : 0;
            $order_delivery_complete_time = request()->post("order_delivery_complete_time", '') ? request()->post("order_delivery_complete_time", '') : 0;
            $order_show_buy_record = request()->post("order_show_buy_record", '') ? request()->post("order_show_buy_record", '') : 0;
            $order_invoice_tax = request()->post("order_invoice_tax", '') ? request()->post("order_invoice_tax", '') : 0;
            $order_invoice_content = request()->post("order_invoice_content", '') ? request()->post("order_invoice_content", '') : '';
            $order_delivery_pay = request()->post("order_delivery_pay", '') ? request()->post("order_delivery_pay", '') : 0;
            $order_buy_close_time = request()->post("order_buy_close_time", '') ? request()->post("order_buy_close_time", '') : 0;
            $buyer_self_lifting = request()->post("buyer_self_lifting", '') ? request()->post("buyer_self_lifting", '') : 0;
            $Config = new WebConfig();
            $retval = $Config->SetShopConfig($shop_id, $order_auto_delinery, $order_balance_pay, $order_delivery_complete_time, $order_show_buy_record, $order_invoice_tax, $order_invoice_content, $order_delivery_pay, $order_buy_close_time, $buyer_self_lifting);
            return AjaxReturn($retval);
        } else {
            $Config = new WebConfig();
            // 订单收货之后多长时间自动完成
            $shop_id = $this->instance_id;
            $shopSet = $Config->getShopConfig($shop_id);
            // dump($shopSet);
            $this->assign("shopSet", $shopSet);
            return view($this->style . "Config/shopSet");
        }
    }

    /**
     * 通知系统
     */
    public function notifyIndex()
    {
        $config_service = new WebConfig();
        $shop_id = $this->instance_id;
        $notify_list = $config_service->getNoticeConfig($shop_id);
        $this->assign("notify_list", $notify_list);
        return view($this->style . 'Config/notifyConfig');
    }

    /**
     * 开启和关闭 邮件 和短信的开启和 关闭
     */
    public function updateNotifyEnable()
    {
        $id = $_POST["id"];
        $is_use = $_POST["is_use"];
        $config_service = new WebConfig();
        $retval = $config_service->updateConfigEnable($id, $is_use);
        return AjaxReturn($retval);
    }

    /**
     * 修改模板
     * 
     * @return \think\response\View
     */
    public function notifyTemplate()
    {
        $type = isset($_GET["type"]) ? $_GET["type"] : "email";
        $config_service = new WebConfig();
        $shop_id = $this->instance_id;
        $template_detail = $config_service->getNoticeTemplateDetail($shop_id, $type);
        $template_type_list = $config_service->getNoticeTemplateType($type);
        for ($i = 0; $i < count($template_type_list); $i ++) {
            $template_code = $template_type_list[$i]["template_code"];
            $is_enable = 0;
            $template_title = "";
            $template_content = "";
            $sign_name = "";
            foreach ($template_detail as $template_obj) {
                if ($template_obj["template_code"] == $template_code) {
                    $is_enable = $template_obj["is_enable"];
                    $template_title = $template_obj["template_title"];
                    $template_content = $template_obj["template_content"];
                    $sign_name = $template_obj["sign_name"];
                    break;
                }
            }
            $template_type_list[$i]["is_enable"] = $is_enable;
            $template_type_list[$i]["template_title"] = $template_title;
            $template_type_list[$i]["template_content"] = $template_content;
            $template_type_list[$i]["sign_name"] = $sign_name;
        }
        $template_item_list = $config_service->getNoticeTemplateItem($template_type_list[0]["template_code"]);
        $this->assign("template_type_list", $template_type_list);
        $this->assign("template_json", json_encode($template_type_list));
        $this->assign("template_select", $template_type_list[0]);
        $this->assign("template_item_list", $template_item_list);
        $this->assign("template_send_item_json", json_encode($template_item_list));
        if ($type == "email") {
            return view($this->style . 'Config/notifyEmailTemplate');
        } else {
            return view($this->style . 'Config/notifySmsTemplate');
        }
    }

    /**
     * 得到可用的变量
     * 
     * @return unknown
     */
    public function getTemplateItem()
    {
        $template_code = $_POST["template_code"];
        $config_service = new WebConfig();
        $template_item_list = $config_service->getNoticeTemplateItem($template_code);
        return $template_item_list;
    }

    /**
     * 更新通知模板
     * 
     * @return multitype:unknown
     */
    public function updateNotifyTemplate()
    {
        $template_code = isset($_POST["type"]) ? $_POST["type"] : "email";
        $template_data = isset($_POST["template_data"]) ? $_POST["template_data"] : "";
        $shop_id = $this->instance_id;
        $config_service = new WebConfig();
        $retval = $config_service->updateNoticeTemplate($shop_id, $template_code, $template_data);
        return AjaxReturn($retval);
    }

    /**
     * 会员提现设置
     *
     * @return multitype:number unknown |Ambigous <\think\response\View, \think\response\$this, \think\response\View>
     */
    public function memberWithdrawSetting()
    {
        if (request()->isAjax()) {
            $shop_id = $this->instance_id;
            $key = 'WITHDRAW_BALANCE';
            $value = array(
                'withdraw_cash_min' => $_POST['cash_min'] ? $_POST['cash_min'] : 0,
                'withdraw_multiple' => $_POST['multiple'] ? $_POST['multiple'] : 1,
                'withdraw_poundage' => $_POST['poundage'] ? $_POST['poundage'] : 0,
                'withdraw_message' => $_POST['message'] ? $_POST['message'] : ''
            );
            $is_use = $_POST['is_use'];
            $config_service = new WebConfig();
            $retval = $config_service->setBalanceWithdrawConfig($shop_id, $key, $value, $is_use);
            return AjaxReturn($retval);
        } else {
            $shop_id = $this->instance_id;
            $config_service = new WebConfig();
            $list = $config_service->getBalanceWithdrawConfig($shop_id);
            // dump($list);
            if (empty($list)) {
                $list['id'] = '';
                $list['value']['withdraw_cash_min'] = '';
                $list['value']['withdraw_multiple'] = '';
                $list['value']['withdraw_poundage'] = '';
                $list['value']['withdraw_message'] = '';
            }
            $this->assign("list", $list);
            return view($this->style . "Config/memberWithdrawSetting");
        }
    }

    /**
     * 用户提现审核
     *
     * @return Ambigous <multitype:unknown, multitype:unknown unknown string >
     */
    public function userCommissionWithdrawAudit()
    {
        $id = $_POST["id"];
        $status = $_POST["status"];
        $user = new User();
        $retval = $user->UserCommissionWithdrawAudit($this->instance_id, $id, $status);
        return AjaxReturn($retval);
    }

    /**
     * 支付
     * 
     * @return Ambigous <\think\response\View, \think\response\$this, \think\response\View>
     */
    public function paymentConfig()
    {
        $config_service = new WebConfig();
        $shop_id = $this->instance_id;
        $pay_list = $config_service->getPayConfig($shop_id);
        $this->assign("pay_list", $pay_list);
        return view($this->style . 'Config/paymentConfig');
    }

    /**
     * 第三方登录页面
     */
    public function partyLogin()
    {
        $web_config = new WebConfig();
        // qq登录配置
        // 获取当前域名
        $domain_name = \think\Request::instance()->domain();
        // 获取回调域名qq回调域名
        $qq_call_back = $domain_name . \think\Request::instance()->root() . '/wap/login/callback';
        // 获取qq配置信息
        $qq_config = $web_config->getQQConfig($this->instance_id);
        // dump($qq_config);
        $qq_config['value']["AUTHORIZE"] = $domain_name;
        $qq_config['value']["CALLBACK"] = $qq_call_back;
        $qq_config['name'] = 'qq登录';
        $this->assign("qq_config", $qq_config);
        // 微信登录配置
        // 微信登录返回
        $wchat_call_back = $domain_name . \think\Request::instance()->root() . '/wap/Login/callback';
        $wchat_config = $web_config->getWchatConfig($this->instance_id);
        $wchat_config['value']["AUTHORIZE"] = $domain_name;
        $wchat_config['value']["CALLBACK"] = $wchat_call_back;
        $wchat_config['name'] = '微信登录';
        $this->assign("wchat_config", $wchat_config);
        return view($this->style . 'Config/partyLogin');
    }

    /**
     * 配送地区管理
     */
    public function distributionAreaManagement()
    {
        $dataAddress = new DataAddress();
        $provinceList = $dataAddress->getProvinceList();
        $cityList = $dataAddress->getCityList();
        foreach ($provinceList as $k => $v) {
            $arr = array();
            foreach ($cityList as $c => $co) {
                if ($co["province_id"] == $v['province_id']) {
                    $arr[] = $co;
                    unset($cityList[$c]);
                }
            }
            $provinceList[$k]['city_list'] = $arr;
        }
        $this->assign("list", $provinceList);
        $districtList = $dataAddress->getDistrictList();
        $this->assign("districtList", $districtList);
        $this->getDistributionArea();
        return view($this->style . "Config/distributionAreaManagement");
    }

    /**
     * 注册与访问
     */
    public function registerAndVisit()
    {
        $config_service = new WebConfig();
        if (request()->isAjax()) {
            $shop_id = $this->instance_id;
            $is_register = request()->post('is_register', '');
            $register_info = request()->post('register_info', '');
            $register_info = empty($register_info) ? '' : rtrim($register_info, ',');
            $name_keyword = request()->post('name_keyword', '');
            $pwd_len = request()->post('pwd_len', '');
            $pwd_complexity = request()->post('pwd_complexity', '');
            $pwd_complexity = empty($pwd_complexity) ? '' : rtrim($pwd_complexity, ',');
            $terms_of_service = request()->post('terms_of_service', '');
            $is_use = request()->post('is_use', '1');
            $res = $config_service->setRegisterAndVisit($shop_id, $is_register, $register_info, $name_keyword, $pwd_len, $pwd_complexity, $terms_of_service, $is_use);
            return AjaxReturn($res);
        } else {
            $register_and_visit = $config_service->getRegisterAndVisit($this->instance_id);
            $this->assign('register_and_visit', json_decode($register_and_visit['value']));
            return view($this->style . "Config/registerAndVisit");
        }
    }

    /**
     * 获取配送地区设置
     */
    public function getDistributionArea()
    {
        $dataAddress = new DataAddress();
        $res = $dataAddress->getDistributionAreaInfo($this->instance_id);
        if ($res != '') {
            $this->assign("provinces", explode(',', $res['province_id']));
            $this->assign("citys", explode(',', $res['city_id']));
            $this->assign("districts", $res["district_id"]);
        }
    }

    /**
     * 通过ajax添加或编辑配送区域
     */
    public function addOrUpdateDistributionAreaAjax()
    {
        if (request()->isAjax()) {
            $dataAddress = new DataAddress();
            $shop_id = $this->instance_id;
            $province_id = request()->post("province_id", "");
            $city_id = request()->post("city_id", "");
            $district_id = request()->post("district_id", "");
            $res = $dataAddress->addOrUpdateDistributionArea($shop_id, $province_id, $city_id, $district_id);
            return AjaxReturn($res);
        }
    }

    /**
     * 物流跟踪
     */
    public function expressMessage()
    {
        if (request()->isAjax()) {
            $config_service = new WebConfig();
            $shop_id = $this->instance_id;
            $appid = request()->post("appid", "");
            $appkey = request()->post("appkey", "");
            $back_url = request()->post('back_url', "");
            $is_use = request()->post("is_use", "");
            $res = $config_service->updateOrderExpressMessageConfig($shop_id, $appid, $appkey, $back_url, $is_use);
            return AjaxReturn($res);
        } else {
            $config_service = new WebConfig();
            $shop_id = $this->instance_id;
            $expressMessageConfig = $config_service->getOrderExpressMessageConfig($shop_id);
            $this->assign('emconfig', $expressMessageConfig);
            
            // var_dump($expressMessageConfig['value']);die;
            return view($this->style . "Config/expressMessage");
        }
    }
}