<?php
/**
 * Member.php
 * Niushop商城系统 - 团队十年电商经验汇集巨献!
 * =========================================================
 * Copy right 2015-2025 山西牛酷信息科技有限公司, 保留所有权利。
 * ----------------------------------------------
 * 官方网址: http://www.niushop.com.cn
 * 这不是一个自由软件！您只能在不用于商业目的的前提下对程序代码进行修改和使用。
 * 任何企业和个人不允许对程序代码以任何形式任何目的再发布。
 * =========================================================
 * @author : niuteam
 * @date : 2015.1.17
 * @version : v1.0.0.0
 */
namespace app\admin\controller;

use data\service\Member as MemberService;
use data\service\Weixin;
use data\service\Member\MemberAccount as MemberAccount;;
use data\service\User;

/**
 * 会员管理
 *
 * @author Administrator
 *        
 */
class Member extends BaseController
{

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * 会员列表主页
     *
     * @return Ambigous <\think\response\View, \think\response\$this, \think\response\View>
     */
    public function memberList()
    {
        if (request()->isAjax()) {
            $page_index = request()->post("page_index",1);
            $page_size = request()->post('page_size',PAGESIZE);
            $search_text =  request()->post('search_text','');  
            $level_id = request()->post('levelid',-1);
       /*     $email = isset($_POST['email']) ? $_POST['email'] : ''; */
            $member = new MemberService();
            $condition = [
            'su.is_member' => 1,
            'su.nick_name|su.user_tel|su.user_email' => array(
                'like',
                '%' . $search_text . '%'
            ),
            
            'su.is_system' => 0
            ];
            if($level_id != -1)
            {
                $condition['nml.level_id'] = $level_id;
            }
            $list = $member->getMemberList($page_index, $page_size, $condition, 'su.reg_time desc');
            
            return $list;
        } else {
            //查询会员等级
            $member = new MemberService(); 
            $list = $member->getMemberLevelList(1,0);
            $this->assign('level_list',$list);
            return view($this->style . 'Member/memberList');
        }
    }
    /**
     * 查询单个 会员
     * @return multitype:unknown
     */
    public function getMemberDetail(){
        $user = new User();
        $uid = request()->post("uid", 0);
        $info = $user->getUserInfoDetail($uid);
        return $info;
    }
    /**
     * 修改会员
     */
    public function updateMember(){
        if(request()->isAjax()){
            $member = new MemberService();
            $uid = request()->post('uid','');
            $user_name = request()->post('user_name','');
            $member_level = request()->post('level_name','');
            $password = request()->post('user_password','');
            $mobile = request()->post('tel','');
            $email = request()->post('email','');
            $nick_name = request()->post('nick_name','');
            $sex = request()->post('sex','');
            $status = request()->post('status','');
            $res = $member->updateMemberByAdmin($uid, $user_name, $email, $sex, $status, $mobile, $nick_name, $member_level);
            return AjaxReturn($res);
        }
    }
    /**
     * 修改密码
     */
    public function updateMemberPassword(){
        $user = new User();
        $userid = request()->post('uid','');
        $password = request()->post('user_password','');
        $result = $user->updateUserInfoByUserid($userid, $password);
         return AjaxReturn($result);
    }
    /**
     * 删除 会员
     * @return multitype:unknown
     */
    public function deleteMember(){
        $member = new MemberService();
        $uid = request()->post("uid", 0);
        $res = $member->deleteMember($uid);
        return AjaxReturn($res);
    }
    /**
     * 获取数据库中用户列表
     */
    public function check_username(){
        if (request()->isAjax()) {
            // 获取数据库中的用户列表
            $username = $_GET['username'];
            $exist = false;
            $member = new MemberService();
            $user_list = $member->getMemberList();
            foreach ($user_list["data"] as $user_list2) {
                if ($user_list2["user_name"] == $username) {
                    $exist = true;
                }
            }
            return $exist;
        }
    }
    
    /**
     * 添加会员信息
     */
    public function addMember(){
        $member = new MemberService();
        $user_name = request()->post('username','');
        $nick_name = request()->post('nickname','');
        $password = request()->post('password','');
        $member_level = request()->post('level_name','');
        $mobile = request()->post('tel','');
        $email = request()->post('email','');
        $sex = request()->post('sex','');
        $status = request()->post('status','');
        $retval = $member ->addMember($user_name, $password, $email, $sex, $status, $mobile, $member_level);
        $result=$member->updateNickNameByUid($retval, $nick_name);
        return AjaxReturn($retval);
    }
    /**
     * 会员积分明细
     */
    public function pointdetail(){
       
        if (request()->isAjax()) {
            $page_index = request()->post("page_index",1);
            $page_size = request()->post('page_size',PAGESIZE);
            $member_id = request()->post('member_id','');
            $search_text = request()->post('search_text');
            $start_date = request()->post('start_date') == "" ? '2010-1-1' : request()->post('start_date');
            $end_date = request()->post('end_date') == "" ? '2099-1-1' : request()->post('end_date');
            $condition['nmar.uid'] = $member_id;
           $condition['nmar.account_type'] = 1;
            $condition["nmar.create_time"] = [
                [
                    ">",
                    $start_date
                ],
                [
                    "<",
                    $end_date
                ]
            ];
            $condition['su.nick_name'] = [
                'like',
                '%' . $search_text . '%'
            ];

            $member = new MemberService();
            $list = $member->getPointList($page_index, $page_size, $condition, $order = '', $field = '*');
           return $list;
        }
        $member_id = $_GET['member_id'];
        $this->assign('member_id',$member_id);
        return view($this->style . 'Member/pointDetailList');
    }
    /**
     * 会员积分管理
     */
    public function pointlist(){
        if (request()->isAjax()) {
            $page_index = request()->post("page_index",1);
            $page_size = request()->post('page_size',PAGESIZE);
            $search_text = request()->post('search_text','');
            $form_type = request()->post('form_type');
            //var_dump($form_type);die;
            $start_date = request()->post('start_date') == "" ? '2010-1-1' : request()->post('start_date');
            $end_date = request()->post('end_date') == "" ? '2099-1-1' : request()->post('end_date');
            $condition['nmar.account_type'] = 1;
            if($form_type != ''){
                $condition['nmar.from_type'] = $form_type;
            }
            $condition["nmar.create_time"] = [
                [
                    ">",
                    $start_date
                ],
                [
                    "<",
                    $end_date
                ]
            ];
            $condition['su.nick_name'] = [
                'like',
                '%' . $search_text . '%'
            ];
           
            $member = new MemberService();
            $list = $member->getPointList($page_index, $page_size, $condition, $order = '', $field = '*');
            //var_dump($list['data']);die;
            return $list;
        }
        return view($this->style . 'Member/pointList');
    }
    
    
    /**
     * 会员余额明细
     */
    public function accountdetail(){
        if (request()->isAjax()) {
            $member = new MemberService();
            $page_index = request()->post("page_index",1);
            $page_size = request()->post('page_size',PAGESIZE);
            $member_id = request()->post('member_id');
            $search_text = request()->post('search_text');
            $start_date = request()->post('start_date') == "" ? '2010-1-1' : request()->post('start_date');
            $end_date = request()->post('end_date') == "" ? '2099-1-1' : request()->post('end_date');
            $condition['nmar.uid'] = $member_id;
            $condition['nmar.account_type'] = 2;
            $condition["nmar.create_time"] = [
                [
                    ">",
                    $start_date
                ],
                [
                    "<",
                    $end_date
                ]
            ];
            $condition['su.nick_name'] = [
                'like',
                '%' . $search_text . '%'
            ];
           
            $list = $member->getAccountList($page_index, $page_size, $condition, $order = '', $field = '*');
            //var_dump($list);die;
            return $list;
        }
        $member_id = $_GET['member_id'];
        $this->assign('member_id',$member_id);
        return view($this->style . 'Member/accountDetailList');
    }
    
    /**
     * 会员余额管理
     */
    public function accountlist(){
    if (request()->isAjax()) {
            $member = new MemberService();
            $page_index = request()->post("page_index",1);
            $page_size = request()->post('page_size',PAGESIZE);
            $search_text = request()->post('search_text','');
            $form_type = request()->post('form_type');
            $start_date = request()->post('start_date') == "" ? '2010-1-1' : request()->post('start_date');
            $end_date = request()->post('end_date') == "" ? '2099-1-1' : request()->post('end_date');
            
            $condition['nmar.account_type'] = 2;
            $condition['su.nick_name'] = [
                         'like',
                    '%' . $search_text . '%'
            ];
            $condition["nmar.create_time"] = [
                [
                    ">",
                    $start_date
                ],
                [
                    "<",
                    $end_date
                ]
            ];
            if($form_type != ''){
                $condition['nmar.from_type'] = $form_type;
            }
            $list = $member->getAccountList($page_index, $page_size, $condition, $order = '', $field = '*');
            //var_dump($list);die;
            return $list;
        }
        
        return view($this->style . 'Member/accountList');
    }
    
    
    /**
     * 用户锁定
     */
    public function memberLock()
    {
        $uid = isset($_POST["id"]) ? $_POST["id"] : '';
        $retval = 0;
        if (! empty($uid)) {
            $member = new MemberService();
            $retval = $member->userLock($uid);
        }
        return AjaxReturn($retval);
    }

    /**
     * 用户解锁
     */
    public function memberUnlock()
    {
        $uid = isset($_POST["id"]) ? $_POST["id"] : '';
        $retval = 0;
        if (! empty($uid)) {
            $member = new MemberService();
            $retval = $member->userUnlock($uid);
        }
        return AjaxReturn($retval);
    }

    /**
     * 粉丝列表
     *
     * @return multitype:number unknown |Ambigous <\think\response\View, \think\response\$this, \think\response\View>
     */
    public function weixinFansList()
    {
        if (request()->isAjax()) {
            $page_index = request()->post("page_index",1);
            $page_size = request()->post('page_size',PAGESIZE);
            $search_text = isset($_POST['search_text']) ? $_POST['search_text'] : '';
            $condition = array(
                'nickname_decode' => array(
                    'like',
                    '%' . $search_text . '%'
                )
            );
            $weixin = new Weixin();
            $list = $weixin->getWeixinFansList($page_index, $page_size, $condition);
            return $list;
        } else {
            return view($this->style . 'Member/weixinFansList');
        }
    }
    /**
     * 积分、余额调整
     */
    public function addMemberAccount(){
        $member = new MemberService();
        $uid = isset($_POST["id"]) ? $_POST["id"] : '';
        $type = isset($_POST["type"]) ? $_POST["type"] : '';
        $num = isset($_POST["num"]) ? $_POST["num"] : '';
        $text = isset($_POST["text"]) ? $_POST["text"] : '';
        $retval = $member->addMemberAccount(0, $type, $uid, $num, $text);
        return AjaxReturn($retval);
    }
    /**
     * 会员等级列表
     */
    public function memberLevelList(){
        $member = new MemberService();
        if(request()->isAjax()){
            $page_index = request()->post("page_index",1);
            $page_size = request()->post('page_size',PAGESIZE);
            $list = $member->getMemberLevelList($page_index, $page_size);
            return $list;
        }
        return view($this->style.'Member/memberLevelList');
    }
    /**
     * 添加会员等级
     */
    public function addMemberLevel(){
        $member = new MemberService();
        if(request()->isAjax()){
            $level_name = request()->post("level_name",'');
            $min_integral = request()->post("min_integral",'');
            $quota = request()->post("quota",'');
            $upgrade = request()->post("upgrade",'');
            $goods_discount = request()->post("goods_discount",'');
            $goods_discount=$goods_discount/100;
            $desc = request()->post("desc",'');
            $relation = request()->post("relation",'');
            $res = $member->addMemberLevel($this->instance_id, $level_name, $min_integral, $quota,$upgrade,$goods_discount, $desc,$relation);
            return AjaxReturn($res);
        }
        return view($this->style.'Member/addMemberLevel');
    }
    /**
     * 修改会员等级
     */
    public function updateMemberLevel(){
        $member = new MemberService();
        if(request()->isAjax()){
            $level_id = request()->post("level_id",0);
            $level_name = request()->post("level_name",'');
            $min_integral = request()->post("min_integral",'');
            $quota = request()->post("quota",'');
            $upgrade = request()->post("upgrade",'');
            $goods_discount = request()->post("goods_discount",'');
            $goods_discount=$goods_discount/100;
            $desc = request()->post("desc",'');
            $relation = request()->post("relation",'');
            $res = $member->updateMemberLevel($level_id, $this->instance_id, $level_name, $min_integral, $quota,$upgrade, $goods_discount, $desc,$relation);
            return AjaxReturn($res);
        }
        $level_id = request()->get("level_id", 0);
        $info = $member->getMemberLevelDetail($level_id);
        $info['goods_discount']=$info['goods_discount']*100;
        $this->assign('info', $info);
        return view($this->style.'Member/updateMemberLevel');
    }
    /**
     * 删除 会员等级
     * @return multitype:unknown
     */
    public function deleteMemberLevel(){
        $member = new MemberService();
        $level_id = request()->post("level_id", 0);
        $res = $member->deleteMemberLevel($level_id);
        return AjaxReturn($res);
    }
    /**
     * 修改 会员等级 单个字段
     * @return multitype:unknown
     */
    public function modityMemberLevelField(){
        $member = new MemberService();
        $level_id = request()->post("level_id", 0);
        $field_name = request()->post("field_name", '');
        $field_value = request()->post("field_value", '');
        $res = $member->modifyMemberLevelField($level_id, $field_name, $field_value);
        return AjaxReturn($res);
    }
    /**
     * 会员提现列表
     */
    public function userCommissionWithdrawList()
    {
        if (request()->isAjax()) {
            $member = new MemberService();
            $pageindex = isset($_POST['pageIndex']) ? $_POST['pageIndex'] : '';
            $user_phone = isset($_POST['user_phone']) ? $_POST['user_phone'] : '';
            if ($user_phone != "") {
                $condition["mobile"] =
                array(
                    "like",
                    "" . $_POST['user_phone'] . "%"
                );
            }
            $uid_string = "";
            $where = array();
            if ($_POST['user_name'] != "") {
                $where["nick_name"] = array(
                    "like",
                    "%" . $_POST['user_name'] . "%"
                );
            }
            if (! empty($where)) {
                $uid_string = $this->getUserUids($where);
                if ($uid_string != "") {
                    $condition["uid"] = array(
                        "in",
                        $uid_string
                    );
                } else {
                    $condition["uid"] = 0;
                }
            }
            $condition["shop_id"] = $this->instance_id;
            $list = $member->getMemberBalanceWithdraw($pageindex, PAGESIZE, $condition, 'ask_for_date desc');
            return $list;
        } else {
            return view($this->style . "Member/userCommissionWithdrawList");
        }
    }
    /**
     * 用户提现审核
     *
     * @return Ambigous <multitype:unknown, multitype:unknown unknown string >
     */
    public function userCommissionWithdrawAudit()
    {
        $id = $_POST["id"];
        $status = $_POST["status"];
        $member = new MemberService();
        $retval = $member->MemberBalanceWithdrawAudit($this->instance_id, $id, $status);
        return AjaxReturn($retval);
    }
    /**
     * 拒绝提现请求
     *
     * @return Ambigous <multitype:unknown, multitype:unknown unknown string >
     */
    public function userCommissionWithdrawRefuse()
    {
        $id = $_POST["id"];
        $status = $_POST["status"];
        $remark = $_POST['remark'];
        $member = new MemberService();
        $retval = $member->userCommissionWithdrawRefuse($this->instance_id, $id, $status, $remark);
        return AjaxReturn($retval);
    }
    /**
     * 查寻符合条件的数据并返回id （多个以“,”隔开）
     *
     * @param unknown $condition
     * @return string
     */
    public function getUserUids($condition)
    {
        $member = new MemberService();
        $list = $member->getMemberAll($condition);
        $uid_string = "";
        foreach ($list as $k => $v) {
            $uid_string = $uid_string . "," . $v["uid"];
        }
        if ($uid_string != "") {
            $uid_string = substr($uid_string, 1);
        }
        return $uid_string;
    }
   /**
    * 获取提现详情
    * @return unknown
    */
    public function getWithdrawalsInfo()
    {   
        $id = $_POST['id']?$_POST['id']:'';
        $member = new MemberService();
        $retval = $member->getMemberWithdrawalsDetails($id);
        return $retval;
    }
    
}