﻿-- Script was generated by Devart dbForge Studio for MySQL, Version 6.0.315.0
-- Product home page: http://www.devart.com/dbforge/mysql/studio
-- Script date 2017-06-23 14:12:51
-- Server version: 5.6.25-log
-- Client version: 4.1

-- 
-- Disable foreign keys
-- 
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;

-- 
-- Set character set the client will use to send SQL statements to the server
--
SET NAMES 'utf8';

-- 
-- Set default database


--
-- Definition for table nc_cms_article
--
DROP TABLE IF EXISTS nc_cms_article;
CREATE TABLE nc_cms_article (
  article_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '文章编号',
  title VARCHAR(50) NOT NULL COMMENT '文章标题',
  class_id INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '文章分类编号',
  short_title VARCHAR(50) NOT NULL DEFAULT '' COMMENT '文章短标题',
  source VARCHAR(50) NOT NULL DEFAULT '' COMMENT '文章来源',
  url VARCHAR(255) NOT NULL DEFAULT '' COMMENT '文章来源链接',
  author VARCHAR(50) NOT NULL COMMENT '文章作者',
  summary VARCHAR(140) NOT NULL DEFAULT '' COMMENT '文章摘要',
  content TEXT NOT NULL COMMENT '文章正文',
  image VARCHAR(255) NOT NULL DEFAULT '' COMMENT '文章标题图片',
  keyword VARCHAR(255) NOT NULL DEFAULT '' COMMENT '文章关键字',
  article_id_array VARCHAR(255) NOT NULL DEFAULT '' COMMENT '相关文章',
  click INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '文章点击量',
  sort TINYINT(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '文章排序0-255',
  commend_flag TINYINT(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '文章推荐标志0-未推荐，1-已推荐',
  comment_flag TINYINT(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '文章是否允许评论1-允许，0-不允许',
  status TINYINT(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '0-草稿、1-待审核、2-已发布、-1-回收站',
  attachment_path TEXT NOT NULL COMMENT '文章附件路径',
  tag VARCHAR(255) NOT NULL DEFAULT '' COMMENT '文章标签',
  comment_count INT(10) UNSIGNED NOT NULL COMMENT '文章评论数',
  last_comment_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '最新评论时间',
  share_count INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '文章分享数',
  publisher_name VARCHAR(50) NOT NULL COMMENT '发布者用户名 ',
  uid INT(10) UNSIGNED NOT NULL COMMENT '发布者编号',
  public_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '发布时间',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '文章发布时间',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '文章修改时间',
  PRIMARY KEY (article_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 187
AVG_ROW_LENGTH = 6553
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = 'CMS文章表';

--
-- Definition for table nc_cms_article_class
--
DROP TABLE IF EXISTS nc_cms_article_class;
CREATE TABLE nc_cms_article_class (
  class_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '分类编号 ',
  pid INT(11) NOT NULL DEFAULT 0 COMMENT '上级分类',
  name VARCHAR(50) NOT NULL COMMENT '分类名称',
  sort INT(11) DEFAULT NULL,
  PRIMARY KEY (class_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 36
AVG_ROW_LENGTH = 1170
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = 'cms文章分类表';

--
-- Definition for table nc_cms_comment
--
DROP TABLE IF EXISTS nc_cms_comment;
CREATE TABLE nc_cms_comment (
  comment_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '评论编号',
  text VARCHAR(2000) NOT NULL COMMENT '评论内容',
  uid INT(10) UNSIGNED NOT NULL COMMENT '评论人编号',
  quote_comment_id INT(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '评论引用',
  up INT(10) UNSIGNED NOT NULL COMMENT '点赞数量',
  comment_time INT(10) UNSIGNED NOT NULL COMMENT '评论时间',
  PRIMARY KEY (comment_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 1
AVG_ROW_LENGTH = 8192
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = 'CMS评论表';

--
-- Definition for table nc_cms_topic
--
DROP TABLE IF EXISTS nc_cms_topic;
CREATE TABLE nc_cms_topic (
  topic_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '专题编号',
  instance_id INT(10) NOT NULL DEFAULT 0 COMMENT '店铺ID',
  title VARCHAR(255) NOT NULL COMMENT '专题标题',
  image VARCHAR(255) NOT NULL DEFAULT '' COMMENT '专题封面',
  status TINYINT(1) NOT NULL DEFAULT 0 COMMENT '专题状态  0草稿  1发布',
  content TEXT NOT NULL COMMENT '专题内容',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '修改时间',
  PRIMARY KEY (topic_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 17
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '专题';

--
-- Definition for table ns_account
--
DROP TABLE IF EXISTS ns_account;
CREATE TABLE ns_account (
  account_id INT(10) NOT NULL AUTO_INCREMENT COMMENT '账户ID',
  account_profit DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '平台的总营业额',
  account_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '平台资金总余额',
  account_return DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '平台利润总额',
  account_deposit DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '保证金总额',
  account_order DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '商城订单总额',
  account_withdraw DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '商城提现总额',
  account_shop DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '店铺总余额',
  account_shop_withdraw DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '店铺总提现',
  PRIMARY KEY (account_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 2
AVG_ROW_LENGTH = 8192
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '商城资金统计';

--
-- Definition for table ns_account_assistant_records
--
DROP TABLE IF EXISTS ns_account_assistant_records;
CREATE TABLE ns_account_assistant_records (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  serial_no VARCHAR(50) NOT NULL DEFAULT '' COMMENT '流水号',
  shop_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺id',
  money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '对应金额',
  account_type TINYINT(1) NOT NULL COMMENT '账户类型',
  type_alis_id INT(11) NOT NULL COMMENT '关联ID',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  remark VARCHAR(255) NOT NULL DEFAULT '' COMMENT '简介',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 1
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '招商员支付记录';

--
-- Definition for table ns_account_order_records
--
DROP TABLE IF EXISTS ns_account_order_records;
CREATE TABLE ns_account_order_records (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  serial_no VARCHAR(50) NOT NULL DEFAULT '' COMMENT '流水号',
  shop_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺id',
  money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '对应金额',
  account_type TINYINT(1) NOT NULL COMMENT '账户类型',
  type_alis_id INT(11) NOT NULL COMMENT '关联ID',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  remark VARCHAR(255) NOT NULL DEFAULT '' COMMENT '简介',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 8
AVG_ROW_LENGTH = 8192
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '金额账户记录';

--
-- Definition for table ns_account_period
--
DROP TABLE IF EXISTS ns_account_period;
CREATE TABLE ns_account_period (
  period_id INT(10) NOT NULL AUTO_INCREMENT COMMENT '账户ID',
  period_year INT(10) NOT NULL COMMENT '账期年份',
  period_month INT(10) NOT NULL COMMENT '账期月份',
  start_time DATETIME NOT NULL COMMENT '开始时间',
  end_time DATETIME NOT NULL COMMENT '结束时间',
  account_profit DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '账期总营业额',
  account_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '账期总发生余额',
  account_return DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '账期利润总额',
  account_deposit DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '账期保证金总额',
  account_order DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '账期订单总额',
  account_withdraw DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '账期店铺提现总额',
  account_shop DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '账期店铺总发生额',
  account_shop_withdraw DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '账期店铺总提现额',
  PRIMARY KEY (period_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 1
AVG_ROW_LENGTH = 16384
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '商城账期结算表';

--
-- Definition for table ns_account_records
--
DROP TABLE IF EXISTS ns_account_records;
CREATE TABLE ns_account_records (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  shop_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺id',
  money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '对应金额',
  account_type TINYINT(1) NOT NULL COMMENT '账户类型',
  type_alis_id INT(11) NOT NULL COMMENT '关联ID',
  is_display TINYINT(1) NOT NULL DEFAULT 1 COMMENT '是否显示',
  is_calculate TINYINT(1) NOT NULL DEFAULT 1 COMMENT '是否参与计算',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  remark VARCHAR(255) NOT NULL DEFAULT '' COMMENT '简介',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 26
AVG_ROW_LENGTH = 1092
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '金额账户记录';

--
-- Definition for table ns_account_return_records
--
DROP TABLE IF EXISTS ns_account_return_records;
CREATE TABLE ns_account_return_records (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  shop_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺id',
  money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '金额',
  return_type INT(11) NOT NULL DEFAULT 0 COMMENT '提成类型',
  type_alis_id INT(11) NOT NULL DEFAULT 0 COMMENT '关联id',
  is_display INT(11) NOT NULL DEFAULT 0 COMMENT '是否显示',
  is_calculate INT(11) NOT NULL DEFAULT 0 COMMENT '是否计算',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  remark VARCHAR(255) NOT NULL DEFAULT '0' COMMENT '备注',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 23
AVG_ROW_LENGTH = 910
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '平台的利润的记录';

--
-- Definition for table ns_account_withdraw_records
--
DROP TABLE IF EXISTS ns_account_withdraw_records;
CREATE TABLE ns_account_withdraw_records (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  serial_no VARCHAR(50) NOT NULL DEFAULT '' COMMENT '流水号',
  shop_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺id',
  money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '对应金额',
  account_type TINYINT(1) NOT NULL COMMENT '账户类型',
  type_alis_id INT(11) NOT NULL COMMENT '关联ID',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  remark VARCHAR(255) NOT NULL DEFAULT '' COMMENT '简介',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 1
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '金额账户记录';

--
-- Definition for table ns_account_withdraw_user_records
--
DROP TABLE IF EXISTS ns_account_withdraw_user_records;
CREATE TABLE ns_account_withdraw_user_records (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  serial_no VARCHAR(50) NOT NULL DEFAULT '' COMMENT '流水号',
  shop_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺id',
  money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '对应金额',
  account_type TINYINT(1) NOT NULL COMMENT '账户类型',
  type_alis_id INT(11) NOT NULL COMMENT '关联ID',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  remark VARCHAR(255) NOT NULL DEFAULT '' COMMENT '简介',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 1
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '会员提现记录表';

--
-- Definition for table ns_attribute
--
DROP TABLE IF EXISTS ns_attribute;
CREATE TABLE ns_attribute (
  attr_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '商品属性ID',
  attr_name VARCHAR(255) NOT NULL DEFAULT '' COMMENT '属性名称',
  is_use TINYINT(1) NOT NULL DEFAULT 1 COMMENT '是否使用',
  spec_id_array VARCHAR(255) NOT NULL DEFAULT '' COMMENT '关联规格',
  sort INT(11) DEFAULT NULL,
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '修改时间',
  PRIMARY KEY (attr_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 29
AVG_ROW_LENGTH = 16384
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '商品相关属性';

--
-- Definition for table ns_attribute_value
--
DROP TABLE IF EXISTS ns_attribute_value;
CREATE TABLE ns_attribute_value (
  attr_value_id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '属性值ID',
  attr_value_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '属性值名称',
  attr_id INT(11) NOT NULL COMMENT '属性ID',
  value VARCHAR(1000) NOT NULL DEFAULT '' COMMENT '属性对应相关数据',
  type INT(11) NOT NULL DEFAULT 1 COMMENT '属性对应输入类型1.直接2.单选3.多选',
  sort INT(11) NOT NULL DEFAULT 1999 COMMENT '排序号',
  is_search TINYINT(1) NOT NULL DEFAULT 1 COMMENT '是否使用',
  PRIMARY KEY (attr_value_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 78
AVG_ROW_LENGTH = 4096
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '商品属性值';

--
-- Definition for table ns_cart
--
DROP TABLE IF EXISTS ns_cart;
CREATE TABLE ns_cart (
  cart_id INT(11) NOT NULL AUTO_INCREMENT COMMENT '购物车id',
  buyer_id INT(11) NOT NULL DEFAULT 0 COMMENT '买家id',
  shop_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺id',
  shop_name VARCHAR(100) NOT NULL DEFAULT '' COMMENT '店铺名称',
  goods_id INT(11) NOT NULL DEFAULT 0 COMMENT '商品id',
  goods_name VARCHAR(200) NOT NULL COMMENT '商品名称',
  sku_id INT(11) NOT NULL DEFAULT 0 COMMENT '商品的skuid',
  sku_name VARCHAR(200) NOT NULL DEFAULT '' COMMENT '商品的sku名称',
  price DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '商品价格',
  num SMALLINT(5) NOT NULL DEFAULT 1 COMMENT '购买商品数量',
  goods_picture INT(11) NOT NULL DEFAULT 0 COMMENT '商品图片',
  bl_id MEDIUMINT(8) NOT NULL DEFAULT 0 COMMENT '组合套装ID',
  PRIMARY KEY (cart_id),
  INDEX member_id (buyer_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 510
AVG_ROW_LENGTH = 1170
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '购物车表';

--
-- Definition for table ns_consult
--
DROP TABLE IF EXISTS ns_consult;
CREATE TABLE ns_consult (
  consult_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '咨询编号',
  goods_id INT(11) UNSIGNED DEFAULT 0 COMMENT '商品编号',
  goods_name VARCHAR(100) NOT NULL COMMENT '商品名称',
  uid INT(11) NOT NULL DEFAULT 0 COMMENT '咨询发布者会员编号(0：游客)',
  member_name VARCHAR(100) NOT NULL DEFAULT '' COMMENT '会员名称',
  shop_id INT(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '店铺编号',
  shop_name VARCHAR(50) NOT NULL COMMENT '店铺名称',
  ct_id INT(10) UNSIGNED NOT NULL COMMENT '咨询类型',
  consult_content VARCHAR(255) NOT NULL DEFAULT '' COMMENT '咨询内容',
  consult_addtime DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '咨询发布时间',
  consult_reply VARCHAR(255) NOT NULL DEFAULT '' COMMENT '咨询回复内容',
  consult_reply_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '咨询回复时间',
  isanonymous TINYINT(1) NOT NULL DEFAULT 0 COMMENT '0表示不匿名 1表示匿名',
  PRIMARY KEY (consult_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 41
AVG_ROW_LENGTH = 1638
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '咨询类型表';

--
-- Definition for table ns_consult_type
--
DROP TABLE IF EXISTS ns_consult_type;
CREATE TABLE ns_consult_type (
  ct_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '咨询类型id',
  ct_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '咨询类型名称',
  ct_introduce TEXT NOT NULL COMMENT '咨询类型详细介绍',
  ct_sort INT(11) DEFAULT NULL,
  PRIMARY KEY (ct_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 4
AVG_ROW_LENGTH = 8192
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '咨询类型表';

--
-- Definition for table ns_coupon
--
DROP TABLE IF EXISTS ns_coupon;
CREATE TABLE ns_coupon (
  coupon_id INT(11) NOT NULL AUTO_INCREMENT COMMENT '优惠券id',
  coupon_type_id INT(11) NOT NULL COMMENT '优惠券类型id',
  shop_id INT(11) NOT NULL COMMENT '店铺Id',
  coupon_code VARCHAR(255) NOT NULL DEFAULT '' COMMENT '优惠券编码',
  uid INT(11) NOT NULL DEFAULT 0 COMMENT '领用人',
  use_order_id INT(11) NOT NULL DEFAULT 0 COMMENT '优惠券使用订单id',
  create_order_id INT(11) NOT NULL DEFAULT 0 COMMENT '创建订单id(优惠券只有是完成订单发放的优惠券时才有值)',
  money DECIMAL(10, 2) NOT NULL COMMENT '面额',
  fetch_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '领取时间',
  use_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '使用时间',
  state TINYINT(4) NOT NULL DEFAULT 0 COMMENT '优惠券状态 0未领用 1已领用（未使用） 2已使用 3已过期',
  start_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '有效期开始时间',
  end_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '有效期结束时间',
  get_type INT(11) NOT NULL DEFAULT 0 COMMENT '获取方式1订单2.首页领取',
  PRIMARY KEY (coupon_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 12283
AVG_ROW_LENGTH = 148
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '优惠券表';

--
-- Definition for table ns_coupon_goods
--
DROP TABLE IF EXISTS ns_coupon_goods;
CREATE TABLE ns_coupon_goods (
  id INT(11) NOT NULL AUTO_INCREMENT,
  coupon_type_id INT(11) NOT NULL COMMENT '优惠券类型id',
  goods_id INT(11) NOT NULL COMMENT '商品id',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 83
AVG_ROW_LENGTH = 606
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '优惠券使用商品表';

--
-- Definition for table ns_coupon_type
--
DROP TABLE IF EXISTS ns_coupon_type;
CREATE TABLE ns_coupon_type (
  coupon_type_id INT(11) NOT NULL AUTO_INCREMENT COMMENT '优惠券类型Id',
  shop_id INT(11) NOT NULL DEFAULT 1 COMMENT '店铺ID',
  coupon_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '优惠券名称',
  money DECIMAL(10, 2) NOT NULL COMMENT '发放面额',
  count INT(11) NOT NULL COMMENT '发放数量',
  max_fetch INT(11) NOT NULL DEFAULT 0 COMMENT '每人最大领取个数 0无限制',
  at_least DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '满多少元使用 0代表无限制',
  need_user_level TINYINT(4) NOT NULL DEFAULT 0 COMMENT '领取人会员等级',
  range_type TINYINT(4) NOT NULL DEFAULT 1 COMMENT '使用范围0部分产品使用 1全场产品使用',
  start_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '有效日期开始时间',
  end_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '有效日期结束时间',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  update_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '修改时间',
  is_show INT(11) NOT NULL DEFAULT 0 COMMENT '是否允许首页显示0不显示1显示',
  PRIMARY KEY (coupon_type_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 34
AVG_ROW_LENGTH = 1365
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '优惠券类型表';

--
-- Definition for table ns_express_company
--
DROP TABLE IF EXISTS ns_express_company;
CREATE TABLE ns_express_company (
  co_id INT(11) NOT NULL AUTO_INCREMENT COMMENT '表序号',
  shop_id INT(11) NOT NULL COMMENT '商铺id',
  company_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '物流公司名称',
  express_no VARCHAR(20) NOT NULL DEFAULT '' COMMENT '物流编号',
  is_enabled INT(11) NOT NULL DEFAULT 1 COMMENT '使用状态',
  image VARCHAR(255) DEFAULT '' COMMENT '物流公司模版图片',
  phone VARCHAR(50) NOT NULL DEFAULT '' COMMENT '联系电话',
  orders INT(11) DEFAULT NULL,
  express_logo VARCHAR(255) DEFAULT '' COMMENT '公司logo',
  PRIMARY KEY (co_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 7406
AVG_ROW_LENGTH = 420
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '物流公司';

--
-- Definition for table ns_express_shipping
--
DROP TABLE IF EXISTS ns_express_shipping;
CREATE TABLE ns_express_shipping (
  sid INT(11) NOT NULL AUTO_INCREMENT COMMENT '运单模版id',
  shop_id INT(11) NOT NULL COMMENT '店铺id',
  template_name VARCHAR(255) NOT NULL DEFAULT '' COMMENT '模版名称',
  co_id INT(11) NOT NULL DEFAULT 0 COMMENT '物流公司 id',
  size_type SMALLINT(6) NOT NULL DEFAULT 1 COMMENT '尺寸类型 1像素px  2毫米mm',
  width SMALLINT(6) NOT NULL DEFAULT 0 COMMENT '宽度',
  height SMALLINT(6) NOT NULL DEFAULT 0 COMMENT '长度',
  image VARCHAR(255) NOT NULL DEFAULT '' COMMENT '快递单图片',
  PRIMARY KEY (sid),
  INDEX IDX_express_shipping_co_id (co_id),
  INDEX IDX_express_shipping_shopId (shop_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 11219
AVG_ROW_LENGTH = 5461
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '运单模板';

--
-- Definition for table ns_express_shipping_items
--
DROP TABLE IF EXISTS ns_express_shipping_items;
CREATE TABLE ns_express_shipping_items (
  sid INT(11) NOT NULL DEFAULT 0 COMMENT '运单模版id',
  field_name VARCHAR(30) NOT NULL COMMENT '字段名称',
  field_display_name VARCHAR(255) NOT NULL COMMENT '打印项名称',
  is_print TINYINT(4) NOT NULL DEFAULT 1 COMMENT '是否打印',
  x INT(11) NOT NULL DEFAULT 0 COMMENT 'x',
  y INT(11) NOT NULL DEFAULT 0 COMMENT 'y',
  PRIMARY KEY (sid, field_name)
)
ENGINE = INNODB
AVG_ROW_LENGTH = 420
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '物流模板打印项';

--
-- Definition for table ns_express_shipping_items_library
--
DROP TABLE IF EXISTS ns_express_shipping_items_library;
CREATE TABLE ns_express_shipping_items_library (
  Id INT(11) NOT NULL AUTO_INCREMENT COMMENT '物流模版打印项库ID',
  shop_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺id',
  field_name VARCHAR(50) NOT NULL COMMENT '字段名',
  field_display_name VARCHAR(50) NOT NULL COMMENT '字段显示名',
  is_enabled BIT(1) NOT NULL DEFAULT b'1' COMMENT '是否启用',
  PRIMARY KEY (Id)
)
ENGINE = INNODB
AUTO_INCREMENT = 14
AVG_ROW_LENGTH = 1260
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '物流模版打印项库';

--
-- Definition for table ns_gift_grant_records
--
DROP TABLE IF EXISTS ns_gift_grant_records;
CREATE TABLE ns_gift_grant_records (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  gift_id INT(11) NOT NULL COMMENT '赠送活动ID',
  goods_id INT(11) NOT NULL COMMENT '赠送商品ID',
  goods_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '赠送商品名称',
  goods_img VARCHAR(255) NOT NULL DEFAULT '' COMMENT '赠送商品图片',
  num INT(11) NOT NULL DEFAULT 1 COMMENT '赠送数量',
  type INT(11) NOT NULL DEFAULT 1 COMMENT '发放方式',
  type_id INT(11) NOT NULL DEFAULT 0 COMMENT '发放相关ID',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '赠送时间',
  memo TEXT NOT NULL COMMENT '备注',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 1
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '赠品发放记录';

--
-- Definition for table ns_goods
--
DROP TABLE IF EXISTS ns_goods;
CREATE TABLE ns_goods (
  goods_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '商品id(SKU)',
  goods_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '商品名称',
  shop_id INT(10) UNSIGNED NOT NULL DEFAULT 1 COMMENT '店铺id',
  category_id INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '商品分类id',
  category_id_1 INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '一级分类id',
  category_id_2 INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '二级分类id',
  category_id_3 INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '三级分类id',
  brand_id INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '品牌id',
  group_id_array VARCHAR(255) NOT NULL DEFAULT '' COMMENT '店铺分类id 首尾用,隔开',
  promotion_type TINYINT(3) NOT NULL DEFAULT 0 COMMENT '促销类型 0无促销，1团购，2限时折扣',
  promote_id INT(11) NOT NULL DEFAULT 0 COMMENT '促销活动ID',
  goods_type TINYINT(4) NOT NULL DEFAULT 1 COMMENT '实物或虚拟商品标志 1实物商品 0 虚拟商品 2 F码商品',
  market_price DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '市场价',
  price DECIMAL(19, 2) NOT NULL DEFAULT 0.00 COMMENT '商品原价格',
  promotion_price DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '商品促销价格',
  cost_price DECIMAL(19, 2) NOT NULL DEFAULT 0.00 COMMENT '成本价',
  point_exchange_type TINYINT(3) NOT NULL DEFAULT 0 COMMENT '积分兑换类型 0 非积分兑换 1 只能积分兑换 ',
  point_exchange INT(11) NOT NULL DEFAULT 0 COMMENT '积分兑换',
  give_point INT(11) NOT NULL DEFAULT 0 COMMENT '购买商品赠送积分',
  is_member_discount INT(1) NOT NULL DEFAULT 0 COMMENT '参与会员折扣',
  shipping_fee DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '运费 0为免运费',
  shipping_fee_id INT(11) NOT NULL DEFAULT 0 COMMENT '售卖区域id 物流模板id  ns_order_shipping_fee 表id',
  stock INT(10) NOT NULL DEFAULT 0 COMMENT '商品库存',
  max_buy INT(11) NOT NULL DEFAULT 0 COMMENT '限购 0 不限购',
  clicks INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '商品点击数量',
  min_stock_alarm INT(11) NOT NULL DEFAULT 0 COMMENT '库存预警值',
  sales INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '销售数量',
  collects INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '收藏数量',
  star TINYINT(3) UNSIGNED NOT NULL DEFAULT 5 COMMENT '好评星级',
  evaluates INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '评价数',
  shares INT(11) NOT NULL DEFAULT 0 COMMENT '分享数',
  province_id INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '一级地区id',
  city_id INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '二级地区id',
  picture INT(11) NOT NULL DEFAULT 0 COMMENT '商品主图',
  keywords VARCHAR(255) NOT NULL DEFAULT '' COMMENT '商品关键词',
  introduction VARCHAR(255) NOT NULL DEFAULT '' COMMENT '商品简介，促销语',
  description TEXT NOT NULL COMMENT '商品详情',
  QRcode VARCHAR(255) NOT NULL DEFAULT '' COMMENT '商品二维码',
  code VARCHAR(50) NOT NULL DEFAULT '' COMMENT '商家编号',
  is_stock_visible INT(1) NOT NULL DEFAULT 0 COMMENT '页面不显示库存',
  is_hot INT(1) NOT NULL DEFAULT 0 COMMENT '是否热销商品',
  is_recommend INT(1) NOT NULL DEFAULT 0 COMMENT '是否推荐',
  is_new INT(1) NOT NULL DEFAULT 0 COMMENT '是否新品',
  is_pre_sale INT(11) DEFAULT 0,
  is_bill INT(1) NOT NULL DEFAULT 0 COMMENT '是否开具增值税发票 1是，0否',
  state TINYINT(3) NOT NULL DEFAULT 1 COMMENT '商品状态 0下架，1正常，10违规（禁售）',
  sale_date DATETIME NOT NULL COMMENT '上下架时间',
  create_time DATETIME NOT NULL COMMENT '商品添加时间',
  update_time DATETIME DEFAULT NULL COMMENT '商品编辑时间',
  sort INT(11) NOT NULL DEFAULT 0 COMMENT '排序',
  img_id_array VARCHAR(1000) DEFAULT NULL COMMENT '商品图片序列',
  sku_img_array VARCHAR(1000) DEFAULT NULL COMMENT '商品sku应用图片列表  属性,属性值，图片ID',
  match_point FLOAT(10, 2) DEFAULT NULL COMMENT '实物与描述相符（根据评价计算）',
  match_ratio FLOAT(10, 2) DEFAULT NULL COMMENT '实物与描述相符（根据评价计算）百分比',
  real_sales INT(10) NOT NULL DEFAULT 0 COMMENT '实际销量',
  goods_attribute_id INT(11) NOT NULL DEFAULT 0 COMMENT '商品类型',
  goods_spec_format TEXT NOT NULL COMMENT '商品规格',
  PRIMARY KEY (goods_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 260
AVG_ROW_LENGTH = 16554
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '商品表';

--
-- Definition for table ns_goods_attribute
--
DROP TABLE IF EXISTS ns_goods_attribute;
CREATE TABLE ns_goods_attribute (
  attr_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  goods_id INT(11) NOT NULL COMMENT '商品ID',
  shop_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺ID',
  attr_value_id INT(11) NOT NULL COMMENT '属性值id',
  attr_value VARCHAR(255) NOT NULL DEFAULT '' COMMENT '属性值名称',
  attr_value_name VARCHAR(255) NOT NULL DEFAULT '' COMMENT '属性值对应数据值',
  sort INT(11) NOT NULL DEFAULT 0 COMMENT '排序',
  create_time VARCHAR(255) NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  PRIMARY KEY (attr_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 347
AVG_ROW_LENGTH = 315
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '商品属性表';

--
-- Definition for table ns_goods_attribute_deleted
--
DROP TABLE IF EXISTS ns_goods_attribute_deleted;
CREATE TABLE ns_goods_attribute_deleted (
  attr_id INT(10) NOT NULL,
  goods_id INT(11) NOT NULL COMMENT '商品ID',
  shop_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺ID',
  attr_value_id INT(11) NOT NULL COMMENT '属性值id',
  attr_value VARCHAR(255) NOT NULL DEFAULT '' COMMENT '属性值名称',
  attr_value_name VARCHAR(255) NOT NULL DEFAULT '' COMMENT '属性值对应数据值',
  sort INT(11) NOT NULL DEFAULT 0 COMMENT '排序',
  create_time VARCHAR(255) NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间'
)
ENGINE = INNODB
AVG_ROW_LENGTH = 315
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '商品属性回收站表';

--
-- Definition for table ns_goods_attribute_value
--
DROP TABLE IF EXISTS ns_goods_attribute_value;
CREATE TABLE ns_goods_attribute_value (
  attr_value_id INT(11) NOT NULL AUTO_INCREMENT COMMENT '商品属性值ID',
  attr_id INT(11) NOT NULL COMMENT '商品属性ID',
  attr_value VARCHAR(255) NOT NULL DEFAULT '' COMMENT '值名称',
  is_visible BIT(1) NOT NULL DEFAULT b'1' COMMENT '是否可视',
  sort INT(11) DEFAULT NULL,
  create_time DATETIME NOT NULL,
  PRIMARY KEY (attr_value_id),
  INDEX IDX_category_propvalues_c_pId (attr_id),
  INDEX IDX_category_propvalues_orders (sort),
  INDEX IDX_category_propvalues_value (attr_value)
)
ENGINE = INNODB
AUTO_INCREMENT = 317
AVG_ROW_LENGTH = 1092
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '商品规格值模版表';

--
-- Definition for table ns_goods_brand
--
DROP TABLE IF EXISTS ns_goods_brand;
CREATE TABLE ns_goods_brand (
  brand_id BIGINT(20) NOT NULL AUTO_INCREMENT COMMENT '索引ID',
  shop_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺ID',
  brand_name VARCHAR(100) NOT NULL COMMENT '品牌名称',
  brand_initial VARCHAR(1) NOT NULL COMMENT '品牌首字母',
  brand_pic VARCHAR(100) NOT NULL DEFAULT '' COMMENT '图片',
  brand_recommend TINYINT(1) NOT NULL DEFAULT 0 COMMENT '推荐，0为否，1为是，默认为0',
  sort INT(11) DEFAULT NULL,
  brand_category_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '类别名称',
  category_id_array VARCHAR(1000) NOT NULL DEFAULT '' COMMENT '所属分类id组',
  brand_ads VARCHAR(255) NOT NULL DEFAULT '' COMMENT '品牌推荐广告',
  category_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '品牌所属分类名称',
  category_id_1 INT(11) NOT NULL DEFAULT 0 COMMENT '一级分类ID',
  category_id_2 INT(11) NOT NULL DEFAULT 0 COMMENT '二级分类ID',
  category_id_3 INT(11) NOT NULL DEFAULT 0 COMMENT '三级分类ID',
  PRIMARY KEY (brand_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 39
AVG_ROW_LENGTH = 1024
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '品牌表';

--
-- Definition for table ns_goods_category
--
DROP TABLE IF EXISTS ns_goods_category;
CREATE TABLE ns_goods_category (
  category_id INT(11) NOT NULL AUTO_INCREMENT,
  category_name VARCHAR(50) NOT NULL DEFAULT '',
  short_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '商品分类简称 ',
  pid INT(11) NOT NULL DEFAULT 0,
  level TINYINT(4) NOT NULL DEFAULT 0,
  is_visible INT(11) NOT NULL DEFAULT 1 COMMENT '是否显示  1 显示 0 不显示',
  attr_id INT(11) NOT NULL DEFAULT 0 COMMENT '关联商品类型ID',
  attr_name VARCHAR(255) NOT NULL DEFAULT '' COMMENT '关联类型名称',
  keywords VARCHAR(255) NOT NULL DEFAULT '',
  description VARCHAR(255) DEFAULT '',
  sort INT(11) DEFAULT NULL,
  category_pic VARCHAR(255) NOT NULL DEFAULT '' COMMENT '商品分类图片',
  PRIMARY KEY (category_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 315
AVG_ROW_LENGTH = 244
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '商品分类表';

--
-- Definition for table ns_goods_deleted
--
DROP TABLE IF EXISTS ns_goods_deleted;
CREATE TABLE ns_goods_deleted (
  goods_id INT(10) NOT NULL DEFAULT 0 COMMENT '商品id(SKU)',
  goods_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '商品名称',
  shop_id INT(10) UNSIGNED NOT NULL DEFAULT 1 COMMENT '店铺id',
  category_id INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '商品分类id',
  category_id_1 INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '一级分类id',
  category_id_2 INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '二级分类id',
  category_id_3 INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '三级分类id',
  brand_id INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '品牌id',
  group_id_array VARCHAR(255) NOT NULL DEFAULT '' COMMENT '店铺分类id 首尾用,隔开',
  promotion_type TINYINT(3) NOT NULL DEFAULT 0 COMMENT '促销类型 0无促销，1团购，2限时折扣',
  promote_id INT(11) NOT NULL DEFAULT 0 COMMENT '促销活动ID',
  goods_type TINYINT(4) NOT NULL DEFAULT 1 COMMENT '实物或虚拟商品标志 1实物商品 0 虚拟商品 2 F码商品',
  market_price DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '市场价',
  price DECIMAL(19, 2) NOT NULL DEFAULT 0.00 COMMENT '商品原价格',
  promotion_price DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '商品促销价格',
  cost_price DECIMAL(19, 2) NOT NULL DEFAULT 0.00 COMMENT '成本价',
  point_exchange_type TINYINT(3) NOT NULL DEFAULT 0 COMMENT '积分兑换类型 0 非积分兑换 1 只能积分兑换 ',
  point_exchange INT(11) NOT NULL DEFAULT 0 COMMENT '积分兑换',
  give_point INT(11) NOT NULL DEFAULT 0 COMMENT '购买商品赠送积分',
  is_member_discount INT(1) NOT NULL DEFAULT 0 COMMENT '参与会员折扣',
  shipping_fee DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '运费 0为免运费',
  shipping_fee_id INT(11) NOT NULL DEFAULT 0 COMMENT '售卖区域id 物流模板id  ns_order_shipping_fee 表id',
  stock INT(10) NOT NULL DEFAULT 0 COMMENT '商品库存',
  max_buy INT(11) NOT NULL DEFAULT 0 COMMENT '限购 0 不限购',
  clicks INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '商品点击数量',
  min_stock_alarm INT(11) NOT NULL DEFAULT 0 COMMENT '库存预警值',
  sales INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '销售数量',
  collects INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '收藏数量',
  star TINYINT(3) UNSIGNED NOT NULL DEFAULT 5 COMMENT '好评星级',
  evaluates INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '评价数',
  shares INT(11) NOT NULL DEFAULT 0 COMMENT '分享数',
  province_id INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '一级地区id',
  city_id INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '二级地区id',
  picture INT(11) NOT NULL DEFAULT 0 COMMENT '商品主图',
  keywords VARCHAR(255) NOT NULL DEFAULT '' COMMENT '商品关键词',
  introduction VARCHAR(255) NOT NULL DEFAULT '' COMMENT '商品简介，促销语',
  description TEXT NOT NULL COMMENT '商品详情',
  QRcode VARCHAR(255) NOT NULL DEFAULT '' COMMENT '商品二维码',
  code VARCHAR(50) NOT NULL DEFAULT '' COMMENT '商家编号',
  is_stock_visible INT(1) NOT NULL DEFAULT 0 COMMENT '页面不显示库存',
  is_hot INT(1) NOT NULL DEFAULT 0 COMMENT '是否热销商品',
  is_recommend INT(1) NOT NULL DEFAULT 0 COMMENT '是否推荐',
  is_new INT(1) NOT NULL DEFAULT 0 COMMENT '是否新品',
  is_pre_sale INT(1) NOT NULL DEFAULT 0 COMMENT '是否预售',
  is_bill INT(1) NOT NULL DEFAULT 0 COMMENT '是否开具增值税发票 1是，0否',
  state TINYINT(3) NOT NULL DEFAULT 1 COMMENT '商品状态 0下架，1正常，10违规（禁售）',
  sale_date DATETIME NOT NULL COMMENT '上下架时间',
  create_time DATETIME NOT NULL COMMENT '商品添加时间',
  update_time DATETIME DEFAULT NULL COMMENT '商品编辑时间',
  sort INT(11) NOT NULL DEFAULT 0 COMMENT '排序',
  img_id_array VARCHAR(1000) DEFAULT NULL COMMENT '商品图片序列',
  sku_img_array VARCHAR(1000) DEFAULT NULL COMMENT '商品sku应用图片列表  属性,属性值，图片ID',
  match_point FLOAT(10, 2) DEFAULT NULL COMMENT '实物与描述相符（根据评价计算）',
  match_ratio FLOAT(10, 2) DEFAULT NULL COMMENT '实物与描述相符（根据评价计算）百分比',
  real_sales INT(10) NOT NULL DEFAULT 0 COMMENT '实际销量',
  goods_attribute_id INT(11) NOT NULL DEFAULT 0 COMMENT '商品类型',
  goods_spec_format TEXT NOT NULL COMMENT '商品规格'
)
ENGINE = INNODB
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '商品回收站表';

--
-- Definition for table ns_goods_evaluate
--
DROP TABLE IF EXISTS ns_goods_evaluate;
CREATE TABLE ns_goods_evaluate (
  id INT(11) NOT NULL AUTO_INCREMENT COMMENT '评价ID',
  order_id INT(11) NOT NULL COMMENT '订单ID',
  order_no BIGINT(20) UNSIGNED NOT NULL COMMENT '订单编号',
  order_goods_id INT(11) NOT NULL COMMENT '订单项ID',
  goods_id INT(11) NOT NULL COMMENT '商品ID',
  goods_name VARCHAR(100) NOT NULL COMMENT '商品名称',
  goods_price DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '商品价格',
  goods_image VARCHAR(255) NOT NULL DEFAULT '' COMMENT '商品图片',
  shop_id INT(11) NOT NULL COMMENT '店铺ID',
  shop_name VARCHAR(100) NOT NULL COMMENT '店铺名称',
  content VARCHAR(255) NOT NULL DEFAULT '' COMMENT '评价内容',
  addtime DATETIME DEFAULT NULL COMMENT '评价时间',
  image VARCHAR(255) NOT NULL DEFAULT '' COMMENT '评价图片',
  explain_first VARCHAR(255) NOT NULL DEFAULT '' COMMENT '解释内容',
  member_name VARCHAR(100) NOT NULL DEFAULT '' COMMENT '评价人名称',
  uid INT(11) NOT NULL COMMENT '评价人编号',
  is_anonymous TINYINT(1) NOT NULL DEFAULT 0 COMMENT '0表示不是 1表示是匿名评价',
  scores TINYINT(1) NOT NULL COMMENT '1-5分',
  again_content VARCHAR(255) NOT NULL DEFAULT '' COMMENT '追加评价内容',
  again_addtime DATETIME DEFAULT NULL COMMENT '追加评价时间',
  again_image VARCHAR(255) NOT NULL DEFAULT '' COMMENT '追加评价图片',
  again_explain VARCHAR(255) NOT NULL DEFAULT '' COMMENT '追加解释内容',
  explain_type INT(11) DEFAULT 0 COMMENT '1好评2中评3差评',
  is_show INT(1) DEFAULT 1 COMMENT '1显示 0隐藏',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 64
AVG_ROW_LENGTH = 1489
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '商品评价表';

--
-- Definition for table ns_goods_group
--
DROP TABLE IF EXISTS ns_goods_group;
CREATE TABLE ns_goods_group (
  group_id INT(11) NOT NULL AUTO_INCREMENT,
  shop_id INT(11) NOT NULL,
  group_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '分类名称',
  pid INT(11) NOT NULL DEFAULT 0 COMMENT '上级id 最多2级',
  level TINYINT(4) NOT NULL DEFAULT 0 COMMENT '级别',
  is_visible INT(1) NOT NULL DEFAULT 1 COMMENT '是否可视',
  group_pic VARCHAR(100) NOT NULL DEFAULT '' COMMENT '图片',
  sort INT(11) DEFAULT NULL,
  PRIMARY KEY (group_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 109
AVG_ROW_LENGTH = 160
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '商品本店分类';

--
-- Definition for table ns_goods_sku
--
DROP TABLE IF EXISTS ns_goods_sku;
CREATE TABLE ns_goods_sku (
  sku_id INT(11) NOT NULL AUTO_INCREMENT COMMENT '表序号',
  goods_id INT(11) NOT NULL DEFAULT 0 COMMENT '商品编号',
  sku_name VARCHAR(500) NOT NULL DEFAULT '' COMMENT 'SKU名称',
  attr_value_items VARCHAR(255) NOT NULL DEFAULT '' COMMENT '属性和属性值 id串 attribute + attribute value 表ID分号分隔',
  attr_value_items_format VARCHAR(500) NOT NULL DEFAULT '' COMMENT '属性和属性值id串组合json格式',
  market_price DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '市场价',
  price DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '价格',
  promote_price DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '促销价格',
  cost_price DECIMAL(19, 2) NOT NULL DEFAULT 0.00 COMMENT '成本价',
  stock INT(11) NOT NULL DEFAULT 0 COMMENT '库存',
  picture INT(11) NOT NULL DEFAULT 0 COMMENT '如果是第一个sku编码, 可以加图片',
  code VARCHAR(255) NOT NULL DEFAULT '' COMMENT '商家编码',
  QRcode VARCHAR(255) NOT NULL DEFAULT '' COMMENT '商品二维码',
  create_date DATETIME DEFAULT NULL COMMENT '创建时间',
  update_date DATETIME DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (sku_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 1092
AVG_ROW_LENGTH = 481
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '商品skui规格价格库存信息表';

--
-- Definition for table ns_goods_sku_deleted
--
DROP TABLE IF EXISTS ns_goods_sku_deleted;
CREATE TABLE ns_goods_sku_deleted (
  sku_id INT(11) NOT NULL DEFAULT 0 COMMENT '表序号',
  goods_id INT(11) NOT NULL DEFAULT 0 COMMENT '商品编号',
  sku_name VARCHAR(500) NOT NULL DEFAULT '' COMMENT 'SKU名称',
  attr_value_items VARCHAR(255) NOT NULL DEFAULT '' COMMENT '属性和属性值 id串 attribute + attribute value 表ID分号分隔',
  attr_value_items_format VARCHAR(500) NOT NULL DEFAULT '' COMMENT '属性和属性值id串组合json格式',
  market_price DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '市场价',
  price DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '价格',
  promote_price DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '促销价格',
  cost_price DECIMAL(19, 2) NOT NULL DEFAULT 0.00 COMMENT '成本价',
  stock INT(11) NOT NULL DEFAULT 0 COMMENT '库存',
  picture INT(11) NOT NULL DEFAULT 0 COMMENT '如果是第一个sku编码, 可以加图片',
  code VARCHAR(255) NOT NULL DEFAULT '' COMMENT '商家编码',
  QRcode VARCHAR(255) NOT NULL DEFAULT '' COMMENT '商品二维码',
  create_date DATETIME DEFAULT NULL COMMENT '创建时间',
  update_date DATETIME DEFAULT NULL COMMENT '修改时间'
)
ENGINE = INNODB
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '商品skui规格价格库存信息回收站表';

--
-- Definition for table ns_goods_spec
--
DROP TABLE IF EXISTS ns_goods_spec;
CREATE TABLE ns_goods_spec (
  spec_id INT(11) NOT NULL AUTO_INCREMENT COMMENT '属性ID',
  shop_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺ID',
  spec_name VARCHAR(255) NOT NULL DEFAULT '' COMMENT '属性名称',
  is_visible TINYINT(1) NOT NULL DEFAULT 0 COMMENT '是否可视',
  sort INT(11) NOT NULL DEFAULT 0 COMMENT '排序',
  create_time DATETIME NOT NULL COMMENT '创建日期',
  show_type INT(11) NOT NULL DEFAULT 1 COMMENT '展示方式 1 文字 2 颜色 3 图片',
  PRIMARY KEY (spec_id),
  INDEX IDX_category_props_categoryId (shop_id),
  INDEX IDX_category_props_orders (sort)
)
ENGINE = INNODB
AUTO_INCREMENT = 113
AVG_ROW_LENGTH = 3276
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '商品属性（规格）表';

--
-- Definition for table ns_goods_spec_value
--
DROP TABLE IF EXISTS ns_goods_spec_value;
CREATE TABLE ns_goods_spec_value (
  spec_value_id INT(11) NOT NULL AUTO_INCREMENT COMMENT '商品属性值ID',
  spec_id INT(11) NOT NULL COMMENT '商品属性ID',
  spec_value_name VARCHAR(255) NOT NULL DEFAULT '' COMMENT '商品属性值名称',
  spec_value_data VARCHAR(255) NOT NULL DEFAULT '' COMMENT '商品属性值数据',
  is_visible TINYINT(1) NOT NULL DEFAULT 0 COMMENT '是否可视',
  sort INT(11) NOT NULL DEFAULT 0 COMMENT '排序',
  create_time DATETIME NOT NULL,
  PRIMARY KEY (spec_value_id),
  INDEX IDX_category_propvalues_c_pId (spec_id),
  INDEX IDX_category_propvalues_orders (sort),
  INDEX IDX_category_propvalues_value (spec_value_name)
)
ENGINE = INNODB
AUTO_INCREMENT = 620
AVG_ROW_LENGTH = 1092
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '商品规格值模版表';

--
-- Definition for table ns_member
--
DROP TABLE IF EXISTS ns_member;
CREATE TABLE ns_member (
  uid INT(11) NOT NULL COMMENT '用户ID',
  member_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '前台用户名',
  member_level INT(11) NOT NULL DEFAULT 0 COMMENT '会员等级',
  reg_time DATETIME NOT NULL COMMENT '注册时间',
  memo VARCHAR(1000) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (uid)
)
ENGINE = INNODB
AVG_ROW_LENGTH = 147
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '前台用户表';

--
-- Definition for table ns_member_account
--
DROP TABLE IF EXISTS ns_member_account;
CREATE TABLE ns_member_account (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  uid INT(11) NOT NULL COMMENT '会员uid',
  shop_id INT(11) NOT NULL COMMENT '店铺ID',
  point INT(11) NOT NULL DEFAULT 0 COMMENT '会员积分',
  balance DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '余额',
  coin INT(11) NOT NULL DEFAULT 0 COMMENT '购物币',
  member_cunsum DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '会员消费',
  member_sum_point INT(11) NOT NULL DEFAULT 0 COMMENT '会员累计积分',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 27
AVG_ROW_LENGTH = 3276
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '会员账户统计表';

--
-- Definition for table ns_member_account_records
--
DROP TABLE IF EXISTS ns_member_account_records;
CREATE TABLE ns_member_account_records (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  uid INT(11) NOT NULL DEFAULT 0 COMMENT '用户ID',
  shop_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺ID',
  account_type INT(11) NOT NULL DEFAULT 1 COMMENT '账户类型1.积分2.余额3.购物币',
  sign SMALLINT(6) NOT NULL DEFAULT 1 COMMENT '正负号',
  number DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '数量',
  from_type SMALLINT(6) NOT NULL DEFAULT 0 COMMENT '产生方式1.商城订单2.订单退还3.兑换4.充值5.签到6.分享7.注册8.提现9提现退还',
  data_id INT(11) NOT NULL DEFAULT 0 COMMENT '相关表的数据ID',
  text VARCHAR(255) NOT NULL DEFAULT '' COMMENT '数据相关内容描述文本',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 421
AVG_ROW_LENGTH = 108
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '会员流水账表';

--
-- Definition for table ns_member_balance_withdraw
--
DROP TABLE IF EXISTS ns_member_balance_withdraw;
CREATE TABLE ns_member_balance_withdraw (
  id INT(11) NOT NULL AUTO_INCREMENT,
  shop_id INT(11) NOT NULL COMMENT '店铺编号',
  withdraw_no VARCHAR(255) NOT NULL DEFAULT '' COMMENT '提现流水号',
  uid INT(11) NOT NULL COMMENT '会员id',
  bank_name VARCHAR(50) NOT NULL COMMENT '提现银行名称',
  account_number VARCHAR(50) NOT NULL COMMENT '提现银行账号',
  realname VARCHAR(10) NOT NULL COMMENT '提现账户姓名',
  mobile VARCHAR(20) NOT NULL COMMENT '手机',
  cash DECIMAL(10, 2) NOT NULL COMMENT '提现金额',
  ask_for_date DATETIME NOT NULL COMMENT '提现日期',
  payment_date DATETIME DEFAULT NULL COMMENT '到账日期',
  status SMALLINT(6) NOT NULL DEFAULT 0 COMMENT '当前状态 0已申请(等待处理) 1已同意 -1 已拒绝',
  memo VARCHAR(255) NOT NULL DEFAULT '' COMMENT '备注',
  modify_date DATETIME DEFAULT NULL COMMENT '修改日期',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 9
AVG_ROW_LENGTH = 4096
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '会员余额提现记录表';

--
-- Definition for table ns_member_bank_account
--
DROP TABLE IF EXISTS ns_member_bank_account;
CREATE TABLE ns_member_bank_account (
  id INT(11) NOT NULL AUTO_INCREMENT,
  uid INT(11) NOT NULL COMMENT '会员id',
  bank_type VARCHAR(50) NOT NULL DEFAULT '1' COMMENT '账号类型 1银行卡2支付宝',
  branch_bank_name VARCHAR(50) DEFAULT NULL COMMENT '支行信息',
  realname VARCHAR(50) NOT NULL DEFAULT '' COMMENT '真实姓名',
  account_number VARCHAR(50) NOT NULL DEFAULT '' COMMENT '银行账号',
  mobile VARCHAR(20) NOT NULL DEFAULT '' COMMENT '手机号',
  is_default INT(11) NOT NULL DEFAULT 0 COMMENT '是否默认账号',
  create_date DATETIME DEFAULT NULL COMMENT '创建日期',
  modify_date DATETIME DEFAULT NULL COMMENT '修改日期',
  PRIMARY KEY (id),
  INDEX IDX_member_bank_account_uid (uid)
)
ENGINE = INNODB
AUTO_INCREMENT = 128
AVG_ROW_LENGTH = 16384
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '会员提现账号';

--
-- Definition for table ns_member_express_address
--
DROP TABLE IF EXISTS ns_member_express_address;
CREATE TABLE ns_member_express_address (
  id INT(11) NOT NULL AUTO_INCREMENT,
  uid INT(11) NOT NULL COMMENT '会员基本资料表ID',
  consigner VARCHAR(255) NOT NULL DEFAULT '' COMMENT '收件人',
  mobile VARCHAR(11) NOT NULL DEFAULT '' COMMENT '手机',
  phone VARCHAR(20) NOT NULL DEFAULT '' COMMENT '固定电话',
  province INT(11) NOT NULL DEFAULT 0 COMMENT '省',
  city INT(11) NOT NULL DEFAULT 0 COMMENT '市',
  district INT(11) NOT NULL DEFAULT 0 COMMENT '区县',
  address VARCHAR(255) NOT NULL DEFAULT '' COMMENT '详细地址',
  zip_code VARCHAR(6) NOT NULL DEFAULT '' COMMENT '邮编',
  alias VARCHAR(50) NOT NULL DEFAULT '' COMMENT '地址别名',
  is_default INT(11) NOT NULL DEFAULT 0 COMMENT '默认收货地址',
  PRIMARY KEY (id),
  INDEX IDX_member_express_address_uid (uid)
)
ENGINE = INNODB
AUTO_INCREMENT = 123
AVG_ROW_LENGTH = 2340
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '会员收货地址管理';

--
-- Definition for table ns_member_favorites
--
DROP TABLE IF EXISTS ns_member_favorites;
CREATE TABLE ns_member_favorites (
  log_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '记录ID',
  uid INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '会员ID',
  fav_id INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '商品或店铺ID',
  fav_type VARCHAR(20) NOT NULL DEFAULT 'goods' COMMENT '类型:goods为商品,shop为店铺,默认为商品',
  fav_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '收藏时间',
  shop_id INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '店铺ID',
  shop_name VARCHAR(20) NOT NULL DEFAULT '' COMMENT '店铺名称',
  shop_logo VARCHAR(255) NOT NULL DEFAULT '' COMMENT '店铺logo',
  goods_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '商品名称',
  goods_image VARCHAR(100) NOT NULL DEFAULT '' COMMENT '商品图片',
  log_price DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '商品收藏时价格',
  log_msg VARCHAR(1000) NOT NULL DEFAULT '' COMMENT '收藏备注',
  PRIMARY KEY (log_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 234
AVG_ROW_LENGTH = 8192
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '收藏表';

--
-- Definition for table ns_member_gift
--
DROP TABLE IF EXISTS ns_member_gift;
CREATE TABLE ns_member_gift (
  gift_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  uid INT(11) NOT NULL COMMENT '会员ID',
  promotion_gift_id INT(11) NOT NULL COMMENT '赠品活动ID',
  goods_id INT(11) NOT NULL COMMENT '赠品ID',
  goods_name VARCHAR(255) NOT NULL DEFAULT '' COMMENT '赠品名称',
  goods_picture INT(11) NOT NULL DEFAULT 0 COMMENT '赠品图片',
  num INT(11) NOT NULL DEFAULT 1 COMMENT '赠品数量',
  get_type INT(11) NOT NULL DEFAULT 1 COMMENT '获取方式',
  get_type_id INT(11) NOT NULL COMMENT '获取方式对应ID',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  `desc` TEXT NOT NULL COMMENT '说明',
  PRIMARY KEY (gift_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 1
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '会员赠品表';

--
-- Definition for table ns_member_level
--
DROP TABLE IF EXISTS ns_member_level;
CREATE TABLE ns_member_level (
  level_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '等级ID',
  shop_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺ID',
  level_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '等级名称',
  min_integral INT(11) NOT NULL DEFAULT 0 COMMENT '累计积分',
  goods_discount DECIMAL(3, 2) NOT NULL DEFAULT 1.00 COMMENT '折扣率',
  `desc` VARCHAR(1000) NOT NULL DEFAULT '' COMMENT '等级描述',
  is_default INT(11) NOT NULL DEFAULT 0 COMMENT '是否是默认',
  quota INT(11) NOT NULL DEFAULT 0 COMMENT '消费额度',
  `upgrade` INT(11) NOT NULL COMMENT '升级条件  1.累计积分 2.消费额度 3.同时满足',
  relation INT(11) NOT NULL DEFAULT 1 COMMENT '1.或 2. 且',
  PRIMARY KEY (level_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 48
AVG_ROW_LENGTH = 16384
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '会员等级';

--
-- Definition for table ns_member_recharge
--
DROP TABLE IF EXISTS ns_member_recharge;
CREATE TABLE ns_member_recharge (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  recharge_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '支付金额',
  uid VARCHAR(255) NOT NULL COMMENT '用户uid',
  out_trade_no VARCHAR(255) NOT NULL DEFAULT '' COMMENT '支付流水号',
  create_time VARCHAR(255) NOT NULL DEFAULT '0' COMMENT '创建时间',
  is_pay VARCHAR(255) NOT NULL DEFAULT '0' COMMENT '是否支付',
  status VARCHAR(255) NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 8
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '会员充值余额记录';

--
-- Definition for table ns_offpay_area
--
DROP TABLE IF EXISTS ns_offpay_area;
CREATE TABLE ns_offpay_area (
  shop_id INT(11) DEFAULT NULL COMMENT '店铺Id',
  province_id TEXT DEFAULT NULL COMMENT '省Id组合',
  city_id TEXT DEFAULT NULL COMMENT '市Id组合',
  district_id TEXT DEFAULT NULL COMMENT '县Id组合'
)
ENGINE = INNODB
AVG_ROW_LENGTH = 16384
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '货到付款支持地区表';

--
-- Definition for table ns_order
--
DROP TABLE IF EXISTS ns_order;
CREATE TABLE ns_order (
  order_id INT(11) NOT NULL AUTO_INCREMENT COMMENT '订单id',
  order_no VARCHAR(255) DEFAULT '' COMMENT '订单编号',
  out_trade_no VARCHAR(100) NOT NULL DEFAULT '0' COMMENT '外部交易号',
  order_type TINYINT(4) NOT NULL DEFAULT 1 COMMENT '订单类型',
  payment_type TINYINT(4) NOT NULL DEFAULT 0 COMMENT '支付类型。取值范围：

WEIXIN (微信自有支付)

WEIXIN_DAIXIAO (微信代销支付)

ALIPAY (支付宝支付)',
  shipping_type TINYINT(4) NOT NULL DEFAULT 1 COMMENT '订单配送方式',
  order_from VARCHAR(255) NOT NULL DEFAULT '' COMMENT '订单来源',
  buyer_id INT(11) NOT NULL COMMENT '买家id',
  user_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '买家会员名称',
  pay_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '订单付款时间',
  buyer_ip VARCHAR(20) NOT NULL DEFAULT '' COMMENT '买家ip',
  buyer_message VARCHAR(255) NOT NULL DEFAULT '' COMMENT '买家附言',
  buyer_invoice VARCHAR(255) NOT NULL DEFAULT '' COMMENT '买家发票信息',
  shipping_time DATETIME NOT NULL COMMENT '买家要求配送时间',
  sign_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '买家签收时间',
  receiver_mobile VARCHAR(11) NOT NULL DEFAULT '' COMMENT '收货人的手机号码',
  receiver_province INT(11) NOT NULL COMMENT '收货人所在省',
  receiver_city INT(11) NOT NULL COMMENT '收货人所在城市',
  receiver_district INT(11) NOT NULL COMMENT '收货人所在街道',
  receiver_address VARCHAR(255) NOT NULL DEFAULT '' COMMENT '收货人详细地址',
  receiver_zip VARCHAR(6) NOT NULL DEFAULT '' COMMENT '收货人邮编',
  receiver_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '收货人姓名',
  shop_id INT(11) NOT NULL COMMENT '卖家店铺id',
  shop_name VARCHAR(100) NOT NULL DEFAULT '' COMMENT '卖家店铺名称',
  seller_star TINYINT(4) NOT NULL DEFAULT 0 COMMENT '卖家对订单的标注星标',
  seller_memo VARCHAR(255) NOT NULL DEFAULT '' COMMENT '卖家对订单的备注',
  consign_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '卖家发货时间',
  consign_time_adjust INT(11) NOT NULL DEFAULT 0 COMMENT '卖家延迟发货时间',
  goods_money DECIMAL(19, 2) NOT NULL COMMENT '商品总价',
  order_money DECIMAL(10, 2) NOT NULL COMMENT '订单总价',
  point INT(11) NOT NULL COMMENT '订单消耗积分',
  point_money DECIMAL(10, 2) NOT NULL COMMENT '订单消耗积分抵多少钱',
  coupon_money DECIMAL(10, 2) NOT NULL COMMENT '订单代金券支付金额',
  coupon_id INT(11) NOT NULL COMMENT '订单代金券id',
  user_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '订单余额支付金额',
  user_platform_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '用户平台余额支付',
  promotion_money DECIMAL(10, 2) NOT NULL COMMENT '订单优惠活动金额',
  shipping_money DECIMAL(10, 2) NOT NULL COMMENT '订单运费',
  pay_money DECIMAL(10, 2) NOT NULL COMMENT '订单实付金额',
  refund_money DECIMAL(10, 2) NOT NULL COMMENT '订单退款金额',
  coin_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '购物币金额',
  give_point INT(11) NOT NULL COMMENT '订单赠送积分',
  give_coin DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '订单成功之后返购物币',
  order_status TINYINT(4) NOT NULL COMMENT '订单状态',
  pay_status TINYINT(4) NOT NULL COMMENT '订单付款状态',
  shipping_status TINYINT(4) NOT NULL COMMENT '订单配送状态',
  review_status TINYINT(4) NOT NULL COMMENT '订单评价状态',
  feedback_status TINYINT(4) NOT NULL COMMENT '订单维权状态',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '订单创建时间',
  finish_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '订单完成时间',
  is_evaluate SMALLINT(6) NOT NULL DEFAULT 0 COMMENT '是否评价 0为未评价 1为已评价 2为已追评',
  tax_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (order_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 526
AVG_ROW_LENGTH = 440
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '订单表';

--
-- Definition for table ns_order_action
--
DROP TABLE IF EXISTS ns_order_action;
CREATE TABLE ns_order_action (
  action_id INT(11) NOT NULL AUTO_INCREMENT COMMENT '动作id',
  order_id INT(11) NOT NULL COMMENT '订单id',
  action VARCHAR(255) NOT NULL DEFAULT '' COMMENT '动作内容',
  uid INT(11) NOT NULL DEFAULT 0 COMMENT '操作人id',
  user_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '操作人',
  order_status INT(11) NOT NULL COMMENT '订单大状态',
  order_status_text VARCHAR(255) NOT NULL DEFAULT '' COMMENT '订单状态名称',
  action_time DATETIME NOT NULL COMMENT '操作时间',
  PRIMARY KEY (action_id)
)
ENGINE = MEMORY
AUTO_INCREMENT = 35
AVG_ROW_LENGTH = 1706
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '订单操作表';

--
-- Definition for table ns_order_goods
--
DROP TABLE IF EXISTS ns_order_goods;
CREATE TABLE ns_order_goods (
  order_goods_id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '订单项ID',
  order_id INT(11) NOT NULL COMMENT '订单ID',
  goods_id INT(11) NOT NULL COMMENT '商品ID',
  goods_name VARCHAR(50) NOT NULL COMMENT '商品名称',
  sku_id INT(11) NOT NULL COMMENT 'skuID',
  sku_name VARCHAR(50) NOT NULL COMMENT 'sku名称',
  price DECIMAL(19, 2) NOT NULL DEFAULT 0.00 COMMENT '商品价格',
  cost_price DECIMAL(19, 2) NOT NULL DEFAULT 0.00 COMMENT '商品成本价',
  num VARCHAR(255) NOT NULL DEFAULT '0' COMMENT '购买数量',
  adjust_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '调整金额',
  goods_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '商品总价',
  goods_picture INT(11) NOT NULL DEFAULT 0 COMMENT '商品图片',
  shop_id INT(11) NOT NULL DEFAULT 1 COMMENT '店铺ID',
  buyer_id INT(11) NOT NULL DEFAULT 0 COMMENT '购买人ID',
  point_exchange_type INT(11) NOT NULL DEFAULT 0 COMMENT '积分兑换类型0.非积分兑换1.积分兑换',
  goods_type VARCHAR(255) NOT NULL DEFAULT '1' COMMENT '商品类型',
  promotion_id INT(11) NOT NULL DEFAULT 0 COMMENT '促销ID',
  promotion_type_id INT(11) NOT NULL DEFAULT 0 COMMENT '促销类型',
  order_type INT(11) NOT NULL DEFAULT 1 COMMENT '订单类型',
  order_status INT(11) NOT NULL DEFAULT 0 COMMENT '订单状态',
  give_point INT(11) NOT NULL DEFAULT 0 COMMENT '积分数量',
  shipping_status INT(11) NOT NULL DEFAULT 0 COMMENT '物流状态',
  refund_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '退款时间',
  refund_type INT(11) NOT NULL DEFAULT 1 COMMENT '退款方式',
  refund_require_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '退款金额',
  refund_reason VARCHAR(255) NOT NULL DEFAULT '' COMMENT '退款原因',
  refund_shipping_code VARCHAR(255) NOT NULL DEFAULT '' COMMENT '退款物流单号',
  refund_shipping_company VARCHAR(255) NOT NULL DEFAULT '0' COMMENT '退款物流公司名称',
  refund_real_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '实际退款金额',
  refund_status INT(1) NOT NULL DEFAULT 0 COMMENT '退款状态',
  memo VARCHAR(255) NOT NULL DEFAULT '' COMMENT '备注',
  is_evaluate SMALLINT(6) NOT NULL DEFAULT 0 COMMENT '是否评价 0为未评价 1为已评价 2为已追评',
  PRIMARY KEY (order_goods_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 586
AVG_ROW_LENGTH = 289
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '订单商品表';

--
-- Definition for table ns_order_goods_express
--
DROP TABLE IF EXISTS ns_order_goods_express;
CREATE TABLE ns_order_goods_express (
  id INT(11) NOT NULL AUTO_INCREMENT,
  order_id INT(11) NOT NULL COMMENT '订单id',
  order_goods_id_array VARCHAR(255) NOT NULL COMMENT '订单项商品组合列表',
  express_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '包裹名称  （包裹- 1 包裹 - 2）',
  shipping_type TINYINT(4) NOT NULL COMMENT '发货方式1 需要物流 0无需物流',
  express_company_id INT(11) NOT NULL COMMENT '快递公司id',
  express_company VARCHAR(255) NOT NULL DEFAULT '' COMMENT '物流公司名称',
  express_no VARCHAR(50) NOT NULL COMMENT '运单编号',
  shipping_time DATETIME NOT NULL COMMENT '发货时间',
  uid INT(11) NOT NULL COMMENT '用户id',
  user_name VARCHAR(50) NOT NULL COMMENT '用户名',
  memo VARCHAR(255) NOT NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 59
AVG_ROW_LENGTH = 606
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '商品订单物流信息表（多次发货）';

--
-- Definition for table ns_order_goods_promotion_details
--
DROP TABLE IF EXISTS ns_order_goods_promotion_details;
CREATE TABLE ns_order_goods_promotion_details (
  id INT(11) NOT NULL AUTO_INCREMENT,
  order_id INT(11) NOT NULL COMMENT '订单ID',
  sku_id INT(11) NOT NULL COMMENT '商品skuid',
  promotion_type VARBINARY(255) NOT NULL COMMENT '优惠类型规则ID（满减对应规则）',
  promotion_id INT(11) NOT NULL COMMENT '优惠ID',
  discount_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '优惠的金额，单位：元，精确到小数点后两位',
  used_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '使用时间',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 178
AVG_ROW_LENGTH = 8192
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '订单商品优惠详情';

--
-- Definition for table ns_order_payment
--
DROP TABLE IF EXISTS ns_order_payment;
CREATE TABLE ns_order_payment (
  out_trade_no VARCHAR(30) NOT NULL COMMENT '支付单编号',
  shop_id INT(11) NOT NULL DEFAULT 0 COMMENT '执行支付的相关店铺ID（0平台）',
  type INT(11) NOT NULL DEFAULT 1 COMMENT '订单类型1.商城订单2.交易商支付',
  type_alis_id INT(11) NOT NULL DEFAULT 0 COMMENT '订单类型关联ID',
  pay_body VARCHAR(255) NOT NULL DEFAULT '' COMMENT '订单支付简介',
  pay_detail VARCHAR(1000) NOT NULL DEFAULT '' COMMENT '订单支付详情',
  pay_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '支付金额',
  pay_status TINYINT(4) NOT NULL DEFAULT 0 COMMENT '支付状态',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  pay_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '支付时间',
  pay_type INT(11) NOT NULL DEFAULT 1 COMMENT '支付方式'
)
ENGINE = INNODB
AVG_ROW_LENGTH = 963
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '订单支付表';

--
-- Definition for table ns_order_pickup
--
DROP TABLE IF EXISTS ns_order_pickup;
CREATE TABLE ns_order_pickup (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  order_id INT(10) NOT NULL DEFAULT 0 COMMENT '订单ID',
  name VARCHAR(255) NOT NULL COMMENT '自提点名称',
  address VARCHAR(255) NOT NULL DEFAULT '' COMMENT '自提点地址',
  contact VARCHAR(255) NOT NULL DEFAULT '' COMMENT '联系人',
  phone VARCHAR(255) NOT NULL DEFAULT '' COMMENT '联系电话',
  city_id INT(11) NOT NULL COMMENT '市ID',
  province_id INT(11) NOT NULL COMMENT '省ID',
  district_id INT(11) NOT NULL COMMENT '区县ID',
  supplier_id INT(11) NOT NULL DEFAULT 0 COMMENT '供应门店ID',
  longitude VARCHAR(255) NOT NULL DEFAULT '' COMMENT '经度',
  latitude VARCHAR(255) NOT NULL DEFAULT '' COMMENT '维度',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  buyer_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '提货人姓名',
  buyer_mobile VARCHAR(255) NOT NULL DEFAULT '' COMMENT '提货人电话',
  remark VARCHAR(255) NOT NULL DEFAULT '' COMMENT '提货备注信息',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 1
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '订单自提点管理';

--
-- Definition for table ns_order_promotion_details
--
DROP TABLE IF EXISTS ns_order_promotion_details;
CREATE TABLE ns_order_promotion_details (
  id INT(11) NOT NULL AUTO_INCREMENT,
  order_id INT(11) NOT NULL COMMENT '订单ID',
  promotion_type_id INT(11) NOT NULL COMMENT '优惠类型规则ID（满减对应规则）',
  promotion_id INT(11) NOT NULL COMMENT '优惠ID',
  promotion_type VARCHAR(255) NOT NULL COMMENT '优惠类型',
  promotion_name VARCHAR(50) NOT NULL COMMENT '该优惠活动的名称',
  promotion_condition VARCHAR(255) NOT NULL DEFAULT '' COMMENT '优惠使用条件说明',
  discount_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '优惠的金额，单位：元，精确到小数点后两位',
  used_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '使用时间',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 126
AVG_ROW_LENGTH = 364
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '订单优惠详情';

--
-- Definition for table ns_order_refund
--
DROP TABLE IF EXISTS ns_order_refund;
CREATE TABLE ns_order_refund (
  id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'id',
  order_goods_id INT(11) NOT NULL COMMENT '订单商品表id',
  refund_status VARCHAR(255) NOT NULL COMMENT '操作状态



流程状态(refund_status)	状态名称(refund_status_name)	操作时间

1	买家申请	发起了退款申请,等待卖家处理

2	等待买家退货	卖家已同意退款申请,等待买家退货

3	等待卖家确认收货	买家已退货,等待卖家确认收货

4	等待卖家确认退款	卖家同意退款

0	退款已成功	卖家退款给买家，本次维权结束

-1	退款已拒绝	卖家拒绝本次退款，本次维权结束

-2	退款已关闭	主动撤销退款，退款关闭

-3	退款申请不通过	拒绝了本次退款申请,等待买家修改

',
  action VARCHAR(255) NOT NULL COMMENT '退款操作内容描述',
  action_way TINYINT(4) NOT NULL DEFAULT 0 COMMENT '操作方 1 买家 2 卖家',
  action_userid VARCHAR(255) NOT NULL DEFAULT '0' COMMENT '操作人id',
  action_username VARCHAR(255) NOT NULL DEFAULT '' COMMENT '操作人姓名',
  action_time DATETIME DEFAULT NULL COMMENT '操作时间',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 195
AVG_ROW_LENGTH = 108
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '订单商品退货退款操作表';

--
-- Definition for table ns_order_shipping_fee
--
DROP TABLE IF EXISTS ns_order_shipping_fee;
CREATE TABLE ns_order_shipping_fee (
  shipping_fee_id INT(11) NOT NULL AUTO_INCREMENT COMMENT '售卖区域ID',
  shipping_fee_name VARCHAR(30) NOT NULL COMMENT '售卖区域名称',
  shop_id INT(11) NOT NULL COMMENT '店铺ID',
  create_time DATETIME NOT NULL COMMENT '创建日期',
  update_time DATETIME DEFAULT NULL COMMENT '最后更新时间',
  PRIMARY KEY (shipping_fee_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 21
AVG_ROW_LENGTH = 5461
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '售卖区域';

--
-- Definition for table ns_order_shipping_fee_extend
--
DROP TABLE IF EXISTS ns_order_shipping_fee_extend;
CREATE TABLE ns_order_shipping_fee_extend (
  id INT(11) NOT NULL AUTO_INCREMENT COMMENT '售卖区域扩展ID',
  shipping_fee_id INT(11) NOT NULL COMMENT '售卖区域ID',
  province_id VARCHAR(8000) NOT NULL DEFAULT '0' COMMENT '省级地区ID组成的串，以，隔开，两端也有，',
  city_id VARCHAR(8000) NOT NULL DEFAULT '0' COMMENT '市级地区ID组成的串，以，隔开，两端也有，',
  snum MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT 1 COMMENT '首件数量',
  sprice DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '首件运费',
  xnum MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT 1 COMMENT '续件数量',
  xprice DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '续件运费',
  is_default INT(11) NOT NULL DEFAULT 0 COMMENT '是否默认 1 默认',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 165
AVG_ROW_LENGTH = 1820
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '售卖区域扩展表';

--
-- Definition for table ns_order_shop_return
--
DROP TABLE IF EXISTS ns_order_shop_return;
CREATE TABLE ns_order_shop_return (
  shop_id INT(11) NOT NULL,
  shop_address VARCHAR(255) NOT NULL DEFAULT '' COMMENT '商家地址',
  seller_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '收件人',
  seller_mobile VARCHAR(11) NOT NULL DEFAULT '' COMMENT '收件人手机号',
  seller_zipcode VARCHAR(20) NOT NULL DEFAULT '' COMMENT '邮编',
  create_time DATETIME NOT NULL COMMENT '创建时间',
  modify_time DATETIME DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (shop_id)
)
ENGINE = INNODB
AVG_ROW_LENGTH = 16384
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '店铺退货设置';

--
-- Definition for table ns_pickup_point
--
DROP TABLE IF EXISTS ns_pickup_point;
CREATE TABLE ns_pickup_point (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  shop_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺ID',
  name VARCHAR(255) NOT NULL COMMENT '自提点名称',
  address VARCHAR(255) NOT NULL DEFAULT '' COMMENT '自提点地址',
  contact VARCHAR(255) NOT NULL DEFAULT '' COMMENT '联系人',
  phone VARCHAR(255) NOT NULL DEFAULT '' COMMENT '联系电话',
  city_id INT(11) NOT NULL COMMENT '市ID',
  province_id INT(11) NOT NULL COMMENT '省ID',
  district_id INT(11) NOT NULL COMMENT '区县ID',
  supplier_id INT(11) NOT NULL DEFAULT 0 COMMENT '供应门店ID',
  longitude VARCHAR(255) NOT NULL DEFAULT '' COMMENT '经度',
  latitude VARCHAR(255) NOT NULL DEFAULT '' COMMENT '维度',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 8
AVG_ROW_LENGTH = 4096
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '自提点管理';

--
-- Definition for table ns_platform_adv
--
DROP TABLE IF EXISTS ns_platform_adv;
CREATE TABLE ns_platform_adv (
  adv_id MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '广告自增标识编号',
  ap_id MEDIUMINT(8) UNSIGNED NOT NULL COMMENT '广告位id',
  adv_title VARCHAR(255) NOT NULL DEFAULT '' COMMENT '广告内容描述',
  adv_url VARCHAR(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  adv_image VARCHAR(1000) NOT NULL DEFAULT '' COMMENT '广告内容图片',
  slide_sort INT(11) DEFAULT NULL,
  click_num INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '广告点击率',
  background VARCHAR(255) NOT NULL DEFAULT '#FFFFFF' COMMENT '背景色',
  PRIMARY KEY (adv_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 1043
AVG_ROW_LENGTH = 1170
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '广告表';

--
-- Definition for table ns_platform_adv_position
--
DROP TABLE IF EXISTS ns_platform_adv_position;
CREATE TABLE ns_platform_adv_position (
  ap_id MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '广告位置id',
  ap_name VARCHAR(100) NOT NULL COMMENT '广告位置名',
  ap_intro VARCHAR(255) NOT NULL COMMENT '广告位简介',
  ap_class SMALLINT(1) UNSIGNED NOT NULL COMMENT '广告类别：0图片1文字2幻灯3Flash',
  ap_display SMALLINT(1) UNSIGNED NOT NULL COMMENT '广告展示方式：0幻灯片1多广告展示2单广告展示',
  is_use SMALLINT(1) UNSIGNED NOT NULL COMMENT '广告位是否启用：0不启用1启用',
  ap_height INT(10) NOT NULL COMMENT '广告位高度',
  ap_width INT(10) NOT NULL COMMENT '广告位宽度',
  ap_price INT(10) UNSIGNED DEFAULT NULL COMMENT '广告位单价',
  adv_num INT(10) UNSIGNED DEFAULT NULL COMMENT '拥有的广告数',
  click_num INT(10) UNSIGNED DEFAULT NULL COMMENT '广告位点击率',
  default_content VARCHAR(100) NOT NULL COMMENT '广告位默认内容',
  ap_background_color VARCHAR(50) NOT NULL DEFAULT '#FFFFFF' COMMENT '广告位背景色 默认白色',
  type TINYINT(4) NOT NULL DEFAULT 1 COMMENT '广告位所在位置类型   1 pc端  2 手机端',
  instance_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺id',
  is_del INT(11) DEFAULT 0,
  PRIMARY KEY (ap_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 1168
AVG_ROW_LENGTH = 1489
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '广告位表';

--
-- Definition for table ns_platform_block
--
DROP TABLE IF EXISTS ns_platform_block;
CREATE TABLE ns_platform_block (
  block_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  is_display SMALLINT(4) NOT NULL DEFAULT 1 COMMENT '是否显示',
  block_color VARCHAR(255) NOT NULL COMMENT '颜色风格',
  sort INT(11) DEFAULT NULL,
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '更新时间',
  block_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '板块名称',
  block_short_name VARCHAR(50) DEFAULT NULL COMMENT '板块简称',
  recommend_ad_image_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '推荐单图广告位名称',
  recommend_ad_image INT(11) NOT NULL DEFAULT 0 COMMENT '推荐单图广告位',
  recommend_ad_slide_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '推荐幻灯广告位名称',
  recommend_ad_slide INT(11) NOT NULL COMMENT '推荐幻灯广告位',
  recommend_ad_images_name VARCHAR(255) NOT NULL DEFAULT '0' COMMENT '推荐多图广告位名称',
  recommend_ad_images INT(11) NOT NULL DEFAULT 0 COMMENT '推荐多图广告位',
  recommend_brands VARCHAR(255) NOT NULL DEFAULT '' COMMENT '推荐品牌',
  recommend_categorys VARCHAR(255) NOT NULL DEFAULT '' COMMENT '推荐商品分类',
  recommend_goods_category_name_1 VARCHAR(50) NOT NULL DEFAULT '' COMMENT '推荐分类商品别名',
  recommend_goods_category_1 INT(11) NOT NULL DEFAULT 0 COMMENT '推荐显示商品分类',
  recommend_goods_category_name_2 VARCHAR(50) NOT NULL DEFAULT '' COMMENT '推荐分类商品别名',
  recommend_goods_category_2 INT(11) NOT NULL DEFAULT 0 COMMENT '推荐显示商品分类',
  recommend_goods_category_name_3 VARCHAR(50) NOT NULL DEFAULT '' COMMENT '推荐分类商品别名',
  recommend_goods_category_3 INT(11) NOT NULL DEFAULT 0 COMMENT '推荐显示商品分类',
  shop_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺id',
  block_data LONGTEXT DEFAULT NULL COMMENT '板块数据',
  PRIMARY KEY (block_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 10
AVG_ROW_LENGTH = 2340
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '首页促销板块';

--
-- Definition for table ns_platform_goods_recommend
--
DROP TABLE IF EXISTS ns_platform_goods_recommend;
CREATE TABLE ns_platform_goods_recommend (
  recommend_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  goods_id INT(11) NOT NULL COMMENT '推荐商品ID',
  state INT(11) NOT NULL DEFAULT 1 COMMENT '推荐状态',
  class_id INT(11) NOT NULL DEFAULT 1 COMMENT '推荐类型',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '修改时间',
  PRIMARY KEY (recommend_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 159
AVG_ROW_LENGTH = 442
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '平台商品推荐';

--
-- Definition for table ns_platform_goods_recommend_class
--
DROP TABLE IF EXISTS ns_platform_goods_recommend_class;
CREATE TABLE ns_platform_goods_recommend_class (
  class_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  class_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '类型名称',
  class_type INT(11) NOT NULL DEFAULT 1 COMMENT '推荐模块1.系统固有模块2.平台增加模块',
  is_use TINYINT(1) NOT NULL DEFAULT 1 COMMENT '是否使用',
  sort INT(11) NOT NULL DEFAULT 255 COMMENT '排序号',
  shop_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺id',
  PRIMARY KEY (class_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 15
AVG_ROW_LENGTH = 2340
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '店铺商品推荐类别';

--
-- Definition for table ns_platform_help_class
--
DROP TABLE IF EXISTS ns_platform_help_class;
CREATE TABLE ns_platform_help_class (
  class_id INT(11) NOT NULL AUTO_INCREMENT COMMENT '表主键',
  type INT(11) NOT NULL DEFAULT 1 COMMENT '1.帮助类别2.会员协议类别3.开店协议类别',
  class_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '类型名称',
  parent_class_id INT(11) NOT NULL DEFAULT 0 COMMENT '上级ID',
  sort INT(11) NOT NULL DEFAULT 0 COMMENT '排序号',
  PRIMARY KEY (class_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 7
AVG_ROW_LENGTH = 4096
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '平台说明类型';

--
-- Definition for table ns_platform_help_document
--
DROP TABLE IF EXISTS ns_platform_help_document;
CREATE TABLE ns_platform_help_document (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '表主键',
  uid INT(11) NOT NULL COMMENT '最后修改人ID',
  class_id INT(11) NOT NULL COMMENT '所属说明类型ID',
  title VARCHAR(255) NOT NULL DEFAULT '' COMMENT '主题',
  link_url VARCHAR(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  sort INT(11) NOT NULL DEFAULT 0 COMMENT '排序号',
  content TEXT NOT NULL COMMENT '内容',
  image VARCHAR(255) NOT NULL DEFAULT '' COMMENT '图片',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  modufy_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '修改时间',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 19
AVG_ROW_LENGTH = 1489
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '平台说明内容';

--
-- Definition for table ns_platform_link
--
DROP TABLE IF EXISTS ns_platform_link;
CREATE TABLE ns_platform_link (
  link_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '索引id',
  link_title VARCHAR(100) NOT NULL COMMENT '标题',
  link_url VARCHAR(100) NOT NULL COMMENT '链接',
  link_pic VARCHAR(100) NOT NULL COMMENT '图片',
  link_sort INT(11) DEFAULT NULL,
  is_blank INT(11) NOT NULL DEFAULT 1 COMMENT '是否新窗口打开 1.是 2.否',
  is_show INT(11) NOT NULL DEFAULT 1 COMMENT '是否显示 1.是 2.否',
  PRIMARY KEY (link_id)
)
ENGINE = MYISAM
AUTO_INCREMENT = 62
AVG_ROW_LENGTH = 50
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '友情链接表';

--
-- Definition for table ns_point_config
--
DROP TABLE IF EXISTS ns_point_config;
CREATE TABLE ns_point_config (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  shop_id INT(11) NOT NULL COMMENT '店铺ID',
  is_open TINYINT(4) NOT NULL DEFAULT 0 COMMENT '是否启动',
  convert_rate DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '1积分对应金额',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '修改时间',
  `desc` TEXT NOT NULL COMMENT '积分说明',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 5
AVG_ROW_LENGTH = 16384
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '积分设置表';

--
-- Definition for table ns_promotion_bundling
--
DROP TABLE IF EXISTS ns_promotion_bundling;
CREATE TABLE ns_promotion_bundling (
  bl_id INT(11) NOT NULL AUTO_INCREMENT COMMENT '组合ID',
  bl_name VARCHAR(50) NOT NULL COMMENT '组合名称',
  shop_id INT(11) NOT NULL COMMENT '店铺id',
  shop_name VARCHAR(100) NOT NULL COMMENT '店铺名称',
  bl_price DECIMAL(10, 2) NOT NULL COMMENT '商品组合价格',
  shipping_fee_type TINYINT(1) NOT NULL COMMENT '运费承担方式 1卖家承担运费 2买家承担运费',
  shipping_fee DECIMAL(10, 2) NOT NULL COMMENT '运费',
  status TINYINT(1) NOT NULL DEFAULT 1 COMMENT '组合状态 0-关闭/1-开启',
  PRIMARY KEY (bl_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 1
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '组合销售活动表';

--
-- Definition for table ns_promotion_bundling_goods
--
DROP TABLE IF EXISTS ns_promotion_bundling_goods;
CREATE TABLE ns_promotion_bundling_goods (
  bl_goods_id INT(11) NOT NULL AUTO_INCREMENT COMMENT '组合商品id',
  bl_id INT(11) NOT NULL COMMENT '组合id',
  goods_id INT(10) UNSIGNED NOT NULL COMMENT '商品id',
  goods_name VARCHAR(50) NOT NULL COMMENT '商品名称',
  goods_picture VARCHAR(100) NOT NULL COMMENT '商品图片',
  bl_goods_price DECIMAL(10, 2) NOT NULL COMMENT '商品组合价格',
  sort INT(11) DEFAULT NULL,
  PRIMARY KEY (bl_goods_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 1
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '组合销售活动商品表';

--
-- Definition for table ns_promotion_discount
--
DROP TABLE IF EXISTS ns_promotion_discount;
CREATE TABLE ns_promotion_discount (
  discount_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  shop_id INT(11) NOT NULL DEFAULT 1 COMMENT '店铺ID',
  shop_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '店铺名称',
  discount_name VARCHAR(255) NOT NULL DEFAULT '' COMMENT '活动名称',
  start_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '开始时间',
  end_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '结束时间',
  status TINYINT(1) NOT NULL DEFAULT 0 COMMENT '活动状态(0-未发布/1-正常/3-关闭/4-结束)',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '修改时间',
  remark TEXT NOT NULL COMMENT '备注',
  PRIMARY KEY (discount_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 36
AVG_ROW_LENGTH = 4096
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '限时折扣';

--
-- Definition for table ns_promotion_discount_goods
--
DROP TABLE IF EXISTS ns_promotion_discount_goods;
CREATE TABLE ns_promotion_discount_goods (
  discount_goods_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  discount_id INT(11) NOT NULL COMMENT '对应活动',
  start_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '开始时间',
  end_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '结束时间',
  goods_id INT(11) NOT NULL COMMENT '商品ID',
  status TINYINT(1) NOT NULL DEFAULT 0 COMMENT '状态',
  discount DECIMAL(10, 2) NOT NULL COMMENT '活动折扣或者减现信息',
  goods_name VARCHAR(255) NOT NULL DEFAULT '' COMMENT '商品名称',
  goods_picture INT(11) NOT NULL COMMENT '商品图片',
  PRIMARY KEY (discount_goods_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 91
AVG_ROW_LENGTH = 712
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '限时折扣商品列表';

--
-- Definition for table ns_promotion_full_mail
--
DROP TABLE IF EXISTS ns_promotion_full_mail;
CREATE TABLE ns_promotion_full_mail (
  mail_id INT(11) NOT NULL AUTO_INCREMENT,
  shop_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺id',
  is_open TINYINT(4) NOT NULL DEFAULT 0 COMMENT '是否开启 0未开启 1已开启',
  full_mail_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '包邮所需订单金额',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '更新时间',
  PRIMARY KEY (mail_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 3
AVG_ROW_LENGTH = 16384
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '满额包邮';

--
-- Definition for table ns_promotion_gift
--
DROP TABLE IF EXISTS ns_promotion_gift;
CREATE TABLE ns_promotion_gift (
  gift_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '赠品活动id ',
  start_time DATETIME NOT NULL COMMENT '赠品有效期开始时间',
  days INT(10) UNSIGNED NOT NULL COMMENT '领取有效期(多少天)',
  end_time DATETIME NOT NULL COMMENT '赠品有效期结束时间',
  max_num VARCHAR(50) NOT NULL COMMENT '领取限制(次/人 (0表示不限领取次数))',
  shop_id VARCHAR(100) NOT NULL COMMENT '店铺id',
  gift_name VARCHAR(255) NOT NULL COMMENT '赠品活动名称',
  create_time DATETIME NOT NULL COMMENT '创建时间',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '修改时间',
  PRIMARY KEY (gift_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 6
AVG_ROW_LENGTH = 8192
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '赠品活动表';

--
-- Definition for table ns_promotion_gift_goods
--
DROP TABLE IF EXISTS ns_promotion_gift_goods;
CREATE TABLE ns_promotion_gift_goods (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'id ',
  gift_id INT(10) UNSIGNED NOT NULL COMMENT '赠品id ',
  goods_id INT(10) UNSIGNED NOT NULL COMMENT '商品id',
  goods_name VARCHAR(50) NOT NULL COMMENT '商品名称',
  goods_picture VARCHAR(100) NOT NULL COMMENT '商品图片',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 9
AVG_ROW_LENGTH = 8192
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '商品赠品表';

--
-- Definition for table ns_promotion_mansong
--
DROP TABLE IF EXISTS ns_promotion_mansong;
CREATE TABLE ns_promotion_mansong (
  mansong_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '满送活动编号',
  mansong_name VARCHAR(50) NOT NULL COMMENT '活动名称',
  start_time DATETIME NOT NULL COMMENT '活动开始时间',
  end_time DATETIME NOT NULL COMMENT '活动结束时间',
  shop_id INT(10) UNSIGNED NOT NULL COMMENT '店铺编号',
  shop_name VARCHAR(50) NOT NULL COMMENT '店铺名称',
  status TINYINT(1) UNSIGNED NOT NULL COMMENT '活动状态(0-未发布/1-正常/3-关闭/4-结束)',
  remark VARCHAR(200) NOT NULL COMMENT '备注',
  type TINYINT(1) NOT NULL DEFAULT 1 COMMENT '1.普通优惠  2.多级优惠',
  range_type TINYINT(1) NOT NULL DEFAULT 1 COMMENT '1全部商品 0部分商品',
  create_time DATETIME NOT NULL COMMENT '创建时间',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '修改时间',
  PRIMARY KEY (mansong_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 21
AVG_ROW_LENGTH = 1638
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '满就送活动表';

--
-- Definition for table ns_promotion_mansong_goods
--
DROP TABLE IF EXISTS ns_promotion_mansong_goods;
CREATE TABLE ns_promotion_mansong_goods (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  mansong_id INT(11) NOT NULL COMMENT '满减送ID',
  goods_id INT(11) NOT NULL COMMENT '商品ID',
  goods_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '商品名称',
  goods_picture VARCHAR(255) NOT NULL DEFAULT '' COMMENT '商品图片',
  start_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '开始时间',
  end_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '结束时间',
  status TINYINT(4) NOT NULL DEFAULT 0 COMMENT '活动状态',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 51
AVG_ROW_LENGTH = 1489
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '满减送商品';

--
-- Definition for table ns_promotion_mansong_rule
--
DROP TABLE IF EXISTS ns_promotion_mansong_rule;
CREATE TABLE ns_promotion_mansong_rule (
  rule_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '规则编号',
  mansong_id INT(10) UNSIGNED NOT NULL COMMENT '活动编号',
  price DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '级别价格(满多少)',
  discount DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '减现金优惠金额（减多少金额）',
  free_shipping TINYINT(4) NOT NULL DEFAULT 0 COMMENT '免邮费',
  give_point INT(11) NOT NULL DEFAULT 0 COMMENT '送积分数量（0表示不送）',
  give_coupon INT(11) NOT NULL DEFAULT 0 COMMENT '送优惠券的id（0表示不送）',
  gift_id INT(11) NOT NULL COMMENT '礼品(赠品)id',
  PRIMARY KEY (rule_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 50
AVG_ROW_LENGTH = 1170
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '满就送活动规则表';

--
-- Definition for table ns_reward_rule
--
DROP TABLE IF EXISTS ns_reward_rule;
CREATE TABLE ns_reward_rule (
  shop_id INT(10) UNSIGNED NOT NULL,
  sign_point INT(11) NOT NULL DEFAULT 0 COMMENT '签到送积分',
  share_point INT(11) NOT NULL DEFAULT 0 COMMENT '分享送积分',
  reg_member_self_point INT(11) NOT NULL DEFAULT 0 COMMENT '注册会员 自己获得的积分',
  reg_member_one_point INT(11) NOT NULL DEFAULT 0 COMMENT '注册会员 上级获得的积分',
  reg_member_two_point INT(11) NOT NULL DEFAULT 0 COMMENT '注册会员 上上级获得的积分',
  reg_member_three_point INT(11) NOT NULL DEFAULT 0 COMMENT '注册会员 上上上级获得的积分',
  reg_promoter_self_point INT(11) NOT NULL DEFAULT 0 COMMENT '成为推广员 自己获得的积分',
  reg_promoter_one_point INT(11) NOT NULL DEFAULT 0 COMMENT '成为推广员 上级获得的积分',
  reg_promoter_two_point INT(11) NOT NULL DEFAULT 0 COMMENT '成为推广员 上上级获得的积分',
  reg_promoter_three_point INT(11) NOT NULL DEFAULT 0 COMMENT '成为推广员 上上上级获得的积分',
  reg_partner_self_point INT(11) NOT NULL DEFAULT 0 COMMENT '成为股东 自己获得的积分',
  reg_partner_one_point INT(11) NOT NULL DEFAULT 0 COMMENT '成为股东 上级获得的积分',
  reg_partner_two_point INT(11) NOT NULL DEFAULT 0 COMMENT '成为股东 上上级获得的积分',
  reg_partner_three_point INT(11) NOT NULL DEFAULT 0 COMMENT '成为股东 上上上级获得的积分',
  into_store_coupon INT(11) NOT NULL DEFAULT 0 COMMENT '进店领用优惠券  存入优惠券id(coupon_id)',
  share_coupon INT(11) NOT NULL DEFAULT 0 COMMENT '分享领用优惠券  存入优惠券id(coupon_id)',
  PRIMARY KEY (shop_id)
)
ENGINE = INNODB
AVG_ROW_LENGTH = 16384
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '奖励规则表';

--
-- Definition for table ns_shop
--
DROP TABLE IF EXISTS ns_shop;
CREATE TABLE ns_shop (
  shop_id INT(11) NOT NULL COMMENT '店铺索引id',
  shop_name VARCHAR(50) NOT NULL COMMENT '店铺名称',
  shop_type INT(11) NOT NULL COMMENT '店铺类型等级',
  uid INT(11) NOT NULL COMMENT '会员id',
  shop_group_id INT(11) NOT NULL COMMENT '店铺分类',
  shop_company_name VARCHAR(50) DEFAULT NULL COMMENT '店铺公司名称',
  province_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT 0 COMMENT '店铺所在省份ID',
  city_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT 0 COMMENT '店铺所在市ID',
  shop_address VARCHAR(100) NOT NULL DEFAULT '' COMMENT '详细地区',
  shop_zip VARCHAR(10) NOT NULL DEFAULT '' COMMENT '邮政编码',
  shop_state TINYINT(1) NOT NULL DEFAULT 1 COMMENT '店铺状态，0关闭，1开启，2审核中',
  shop_close_info VARCHAR(255) DEFAULT NULL COMMENT '店铺关闭原因',
  shop_sort INT(11) NOT NULL DEFAULT 0 COMMENT '店铺排序',
  shop_create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '店铺时间',
  shop_end_time DATETIME DEFAULT NULL COMMENT '店铺关闭时间',
  shop_logo VARCHAR(255) DEFAULT NULL COMMENT '店铺logo',
  shop_banner VARCHAR(255) DEFAULT NULL COMMENT '店铺横幅',
  shop_avatar VARCHAR(150) DEFAULT NULL COMMENT '店铺头像',
  shop_keywords VARCHAR(255) NOT NULL DEFAULT '' COMMENT '店铺seo关键字',
  shop_description VARCHAR(255) NOT NULL DEFAULT '' COMMENT '店铺seo描述',
  shop_qq VARCHAR(50) DEFAULT NULL COMMENT 'QQ',
  shop_ww VARCHAR(50) DEFAULT NULL COMMENT '阿里旺旺',
  shop_phone VARCHAR(20) DEFAULT NULL COMMENT '商家电话',
  shop_domain VARCHAR(50) DEFAULT NULL COMMENT '店铺二级域名',
  shop_domain_times TINYINT(1) UNSIGNED DEFAULT 0 COMMENT '二级域名修改次数',
  shop_recommend TINYINT(1) NOT NULL DEFAULT 0 COMMENT '推荐，0为否，1为是，默认为0',
  shop_credit INT(10) NOT NULL DEFAULT 0 COMMENT '店铺信用',
  shop_desccredit FLOAT NOT NULL DEFAULT 0 COMMENT '描述相符度分数',
  shop_servicecredit FLOAT NOT NULL DEFAULT 0 COMMENT '服务态度分数',
  shop_deliverycredit FLOAT NOT NULL DEFAULT 0 COMMENT '发货速度分数',
  shop_collect INT(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '店铺收藏数量',
  shop_stamp VARCHAR(200) DEFAULT NULL COMMENT '店铺印章',
  shop_printdesc VARCHAR(500) DEFAULT NULL COMMENT '打印订单页面下方说明文字',
  shop_sales DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '店铺销售额（不计算退款）',
  shop_account DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '店铺账户余额',
  shop_cash DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '店铺可提现金额',
  shop_workingtime VARCHAR(100) DEFAULT NULL COMMENT '工作时间',
  live_store_name VARCHAR(255) DEFAULT NULL COMMENT '商铺名称',
  live_store_address VARCHAR(255) DEFAULT NULL COMMENT '商家地址',
  live_store_tel VARCHAR(255) DEFAULT NULL COMMENT '商铺电话',
  live_store_bus VARCHAR(255) DEFAULT NULL COMMENT '公交线路',
  shop_vrcode_prefix CHAR(3) DEFAULT NULL COMMENT '商家兑换码前缀',
  store_qtian TINYINT(1) DEFAULT 0 COMMENT '7天退换',
  shop_zhping TINYINT(1) DEFAULT 0 COMMENT '正品保障',
  shop_erxiaoshi TINYINT(1) DEFAULT 0 COMMENT '两小时发货',
  shop_tuihuo TINYINT(1) DEFAULT 0 COMMENT '退货承诺',
  shop_shiyong TINYINT(1) DEFAULT 0 COMMENT '试用中心',
  shop_shiti TINYINT(1) DEFAULT 0 COMMENT '实体验证',
  shop_xiaoxie TINYINT(1) DEFAULT 0 COMMENT '消协保证',
  shop_huodaofk TINYINT(1) DEFAULT 0 COMMENT '货到付款',
  shop_free_time VARCHAR(10) DEFAULT NULL COMMENT '商家配送时间',
  shop_region VARCHAR(50) DEFAULT NULL COMMENT '店铺默认配送区域',
  recommend_uid INT(11) NOT NULL DEFAULT 0 COMMENT '推荐招商员用户id',
  shop_qrcode VARCHAR(255) NOT NULL DEFAULT '' COMMENT '店铺公众号',
  PRIMARY KEY (shop_id)
)
ENGINE = INNODB
AVG_ROW_LENGTH = 16384
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '店铺数据表';

--
-- Definition for table ns_shop_ad
--
DROP TABLE IF EXISTS ns_shop_ad;
CREATE TABLE ns_shop_ad (
  id INT(11) NOT NULL AUTO_INCREMENT,
  shop_id INT(11) NOT NULL,
  ad_image VARCHAR(255) NOT NULL DEFAULT '' COMMENT '广告图片',
  link_url VARCHAR(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  sort INT(11) NOT NULL DEFAULT 0 COMMENT '排序',
  type INT(1) NOT NULL DEFAULT 0 COMMENT '类型 0 -- pc端  1-- 手机端 ',
  background VARCHAR(255) NOT NULL DEFAULT '#FFFFFF' COMMENT '背景色',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 1
AVG_ROW_LENGTH = 5461
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '店铺广告设置';

--
-- Definition for table ns_shop_coin_records
--
DROP TABLE IF EXISTS ns_shop_coin_records;
CREATE TABLE ns_shop_coin_records (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  shop_id INT(11) NOT NULL COMMENT '店铺ID',
  num DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '购物币数量',
  account_type INT(11) NOT NULL DEFAULT 1 COMMENT '增加或减少类型',
  type_alis_id INT(11) NOT NULL DEFAULT 0 COMMENT '关联ID',
  is_display TINYINT(1) NOT NULL DEFAULT 1 COMMENT '是否显示',
  text VARCHAR(255) NOT NULL DEFAULT '' COMMENT '简介',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 1
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '店铺购物币记录';

--
-- Definition for table ns_shop_express_address
--
DROP TABLE IF EXISTS ns_shop_express_address;
CREATE TABLE ns_shop_express_address (
  express_address_id INT(11) NOT NULL AUTO_INCREMENT COMMENT '物流地址id',
  shop_id INT(11) NOT NULL COMMENT '商铺id',
  contact VARCHAR(100) NOT NULL DEFAULT '' COMMENT '联系人',
  mobile VARCHAR(50) NOT NULL DEFAULT '' COMMENT '手机',
  phone VARCHAR(50) NOT NULL DEFAULT '' COMMENT '电话',
  company_name VARCHAR(100) NOT NULL DEFAULT '' COMMENT '公司名称',
  province SMALLINT(6) NOT NULL DEFAULT 0 COMMENT '所在地省',
  city SMALLINT(6) NOT NULL DEFAULT 0 COMMENT '所在地市',
  district SMALLINT(6) NOT NULL DEFAULT 0 COMMENT '所在地区县',
  zipcode VARCHAR(6) NOT NULL DEFAULT '' COMMENT '邮编',
  address VARCHAR(100) NOT NULL DEFAULT '' COMMENT '详细地址',
  is_consigner TINYINT(2) NOT NULL DEFAULT 0 COMMENT '发货地址标记',
  is_receiver TINYINT(2) NOT NULL DEFAULT 0 COMMENT '收货地址标记',
  create_date DATETIME DEFAULT NULL COMMENT '创建日期',
  modify_date DATETIME DEFAULT NULL COMMENT '修改日期',
  PRIMARY KEY (express_address_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 29
AVG_ROW_LENGTH = 1092
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '物流地址';

--
-- Definition for table ns_shop_group
--
DROP TABLE IF EXISTS ns_shop_group;
CREATE TABLE ns_shop_group (
  shop_group_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '分组ID',
  group_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '分组名称',
  group_sort INT(11) NOT NULL DEFAULT 1 COMMENT '分组排序号',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '修改时间',
  PRIMARY KEY (shop_group_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 7
AVG_ROW_LENGTH = 2730
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '店铺分组表';

--
-- Definition for table ns_shop_navigation
--
DROP TABLE IF EXISTS ns_shop_navigation;
CREATE TABLE ns_shop_navigation (
  nav_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  shop_id INT(11) NOT NULL COMMENT '店铺ID',
  nav_title VARCHAR(255) NOT NULL DEFAULT '' COMMENT '导航名称',
  nav_url VARCHAR(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  type INT(11) NOT NULL DEFAULT 3 COMMENT '纵向所在位置1.头部2.中部3底部',
  sort INT(11) NOT NULL COMMENT '排序号',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '修改时间',
  align INT(11) NOT NULL DEFAULT 1 COMMENT '横向所在位置1 左  2  右',
  nav_type INT(11) DEFAULT 1,
  is_blank INT(11) DEFAULT 0,
  template_name VARCHAR(255) DEFAULT '',
  PRIMARY KEY (nav_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 51
AVG_ROW_LENGTH = 1489
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '店铺导航管理';

--
-- Definition for table ns_shop_navigation_template
--
DROP TABLE IF EXISTS ns_shop_navigation_template;
CREATE TABLE ns_shop_navigation_template (
  template_id INT(11) NOT NULL AUTO_INCREMENT,
  template_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '模板名称',
  template_url VARCHAR(255) NOT NULL DEFAULT '' COMMENT '访问路径',
  is_use INT(11) NOT NULL DEFAULT 1 COMMENT '是否有效',
  use_type INT(11) NOT NULL COMMENT '1 shop端 0wap端',
  create_time DATETIME NOT NULL COMMENT '创建时间',
  PRIMARY KEY (template_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 4
AVG_ROW_LENGTH = 5461
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '导航 的 系统默认模板';

--
-- Definition for table ns_shop_order_account_records
--
DROP TABLE IF EXISTS ns_shop_order_account_records;
CREATE TABLE ns_shop_order_account_records (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  shop_id INT(11) NOT NULL COMMENT '店铺ID',
  order_id INT(11) NOT NULL COMMENT '订单ID',
  order_no VARCHAR(255) NOT NULL DEFAULT '' COMMENT '订单编号',
  order_goods_id INT(11) NOT NULL COMMENT '订单项ID',
  goods_pay_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '订单项实际支付金额',
  rate DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '商品平台佣金比率',
  shop_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '店铺获取金额',
  platform_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '平台获取金额',
  is_refund TINYINT(1) NOT NULL DEFAULT 0 COMMENT '是否产生退款',
  refund_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '实际退款金额',
  shop_refund_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '店铺扣减余额',
  platform_refund_money DECIMAL(10, 2) NOT NULL DEFAULT 0.00 COMMENT '平台扣减余额',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  is_issue TINYINT(4) NOT NULL DEFAULT 0 COMMENT '是否已经结算',
  remark VARCHAR(255) NOT NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 35
AVG_ROW_LENGTH = 655
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '店铺针对订单的金额分配';

--
-- Definition for table ns_shop_weixin_share
--
DROP TABLE IF EXISTS ns_shop_weixin_share;
CREATE TABLE ns_shop_weixin_share (
  shop_id INT(11) NOT NULL,
  goods_param_1 VARCHAR(255) NOT NULL DEFAULT '' COMMENT '商品分享价格标示',
  goods_param_2 VARCHAR(255) NOT NULL DEFAULT '' COMMENT '商品分享内容',
  shop_param_1 VARCHAR(255) NOT NULL DEFAULT '' COMMENT '店铺分享标题',
  shop_param_2 VARCHAR(255) NOT NULL DEFAULT '' COMMENT '店铺分享主题',
  shop_param_3 VARCHAR(255) NOT NULL DEFAULT '' COMMENT '店铺分享内容',
  qrcode_param_1 VARCHAR(255) NOT NULL DEFAULT '' COMMENT '二维码分享主题',
  qrcode_param_2 VARCHAR(255) NOT NULL DEFAULT '' COMMENT '二维码分享内容',
  PRIMARY KEY (shop_id)
)
ENGINE = INNODB
AVG_ROW_LENGTH = 16384
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '店铺分享内容设置';

--
-- Definition for table sys_album_class
--
DROP TABLE IF EXISTS sys_album_class;
CREATE TABLE sys_album_class (
  album_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '相册id',
  shop_id INT(10) NOT NULL DEFAULT 1 COMMENT '店铺id',
  pid INT(11) NOT NULL DEFAULT 0 COMMENT '上级相册ID',
  album_name VARCHAR(100) NOT NULL COMMENT '相册名称',
  album_cover VARCHAR(255) NOT NULL DEFAULT '' COMMENT '相册封面',
  is_default TINYINT(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否为默认相册,1代表默认',
  create_time DATETIME NOT NULL COMMENT '创建时间',
  sort INT(11) DEFAULT NULL,
  PRIMARY KEY (album_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 32
AVG_ROW_LENGTH = 16384
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '相册表';

--
-- Definition for table sys_album_picture
--
DROP TABLE IF EXISTS sys_album_picture;
CREATE TABLE sys_album_picture (
  pic_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '相册图片表id',
  shop_id INT(10) UNSIGNED DEFAULT 1 COMMENT '所属实例id',
  album_id INT(10) UNSIGNED NOT NULL COMMENT '相册id',
  is_wide INT(11) NOT NULL DEFAULT 0 COMMENT '是否宽屏',
  pic_name VARCHAR(100) NOT NULL COMMENT '图片名称',
  pic_tag VARCHAR(255) NOT NULL DEFAULT '' COMMENT '图片标签',
  pic_cover VARCHAR(255) NOT NULL COMMENT '原图图片路径',
  pic_size VARCHAR(255) NOT NULL COMMENT '原图大小',
  pic_spec VARCHAR(100) NOT NULL COMMENT '原图规格',
  pic_cover_big VARCHAR(255) NOT NULL DEFAULT '' COMMENT '大图路径',
  pic_size_big VARCHAR(255) NOT NULL DEFAULT '0' COMMENT '大图大小',
  pic_spec_big VARCHAR(100) NOT NULL DEFAULT '' COMMENT '大图规格',
  pic_cover_mid VARCHAR(255) NOT NULL DEFAULT '' COMMENT '中图路径',
  pic_size_mid VARCHAR(255) NOT NULL DEFAULT '0' COMMENT '中图大小',
  pic_spec_mid VARCHAR(100) NOT NULL DEFAULT '' COMMENT '中图规格',
  pic_cover_small VARCHAR(255) NOT NULL DEFAULT '' COMMENT '小图路径',
  pic_size_small VARCHAR(255) NOT NULL DEFAULT '0' COMMENT '小图大小',
  pic_spec_small VARCHAR(255) NOT NULL DEFAULT '' COMMENT '小图规格',
  pic_cover_micro VARCHAR(255) NOT NULL DEFAULT '' COMMENT '微图路径',
  pic_size_micro VARCHAR(255) NOT NULL DEFAULT '0' COMMENT '微图大小',
  pic_spec_micro VARCHAR(255) NOT NULL DEFAULT '' COMMENT '微图规格',
  upload_time DATETIME NOT NULL COMMENT '图片上传时间',
  PRIMARY KEY (pic_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 747
AVG_ROW_LENGTH = 204
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '相册图片表';

--
-- Definition for table sys_area
--
DROP TABLE IF EXISTS sys_area;
CREATE TABLE sys_area (
  area_id INT(11) NOT NULL AUTO_INCREMENT,
  area_name VARCHAR(50) NOT NULL DEFAULT '',
  sort INT(11) DEFAULT NULL,
  PRIMARY KEY (area_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 9
AVG_ROW_LENGTH = 2048
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '全部区域表';

--
-- Definition for table sys_city
--
DROP TABLE IF EXISTS sys_city;
CREATE TABLE sys_city (
  city_id INT(11) NOT NULL AUTO_INCREMENT,
  province_id INT(11) NOT NULL DEFAULT 0,
  city_name VARCHAR(255) NOT NULL DEFAULT '',
  zipcode VARCHAR(6) NOT NULL DEFAULT '',
  sort INT(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (city_id),
  INDEX IDX_g_city_CityName (city_name)
)
ENGINE = INNODB
AUTO_INCREMENT = 357
AVG_ROW_LENGTH = 135
CHARACTER SET utf8
COLLATE utf8_general_ci;

--
-- Definition for table sys_config
--
DROP TABLE IF EXISTS sys_config;
CREATE TABLE sys_config (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  instance_id INT(11) NOT NULL DEFAULT 1 COMMENT '实例ID',
  `key` VARCHAR(255) NOT NULL DEFAULT '' COMMENT '配置项WCHAT,QQ,WPAY,ALIPAY...',
  value VARCHAR(1000) NOT NULL DEFAULT '' COMMENT '配置值json',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '修改时间',
  `desc` VARCHAR(1000) NOT NULL DEFAULT '' COMMENT '描述',
  is_use TINYINT(4) NOT NULL DEFAULT 0 COMMENT '是否启用 1启用 0不启用',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 128
AVG_ROW_LENGTH = 963
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '第三方配置表';

--
-- Definition for table sys_district
--
DROP TABLE IF EXISTS sys_district;
CREATE TABLE sys_district (
  district_id INT(11) NOT NULL AUTO_INCREMENT,
  city_id INT(11) DEFAULT 0,
  district_name VARCHAR(255) NOT NULL DEFAULT '',
  sort INT(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (district_id),
  INDEX IDX_g_district_DistrictName (district_name)
)
ENGINE = INNODB
AUTO_INCREMENT = 2870
AVG_ROW_LENGTH = 50
CHARACTER SET utf8
COLLATE utf8_general_ci;

--
-- Definition for table sys_instance
--
DROP TABLE IF EXISTS sys_instance;
CREATE TABLE sys_instance (
  instance_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  instance_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '实例名',
  instance_typeid INT(11) NOT NULL DEFAULT 2 COMMENT '实例类型ID',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  qrcode VARCHAR(255) NOT NULL DEFAULT '' COMMENT '实例二维码',
  remark TEXT DEFAULT NULL COMMENT '实例简介',
  PRIMARY KEY (instance_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 20
AVG_ROW_LENGTH = 1365
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '系统实例表';

--
-- Definition for table sys_instance_type
--
DROP TABLE IF EXISTS sys_instance_type;
CREATE TABLE sys_instance_type (
  instance_typeid INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '实例类型ID',
  type_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '实例类型名称',
  type_module_array TEXT NOT NULL COMMENT '实例类型权限',
  type_desc TEXT NOT NULL COMMENT '实例类型说明',
  type_sort INT(11) NOT NULL DEFAULT 1 COMMENT '排序号',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '修改时间',
  PRIMARY KEY (instance_typeid)
)
ENGINE = INNODB
AUTO_INCREMENT = 3
AVG_ROW_LENGTH = 8192
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '实例类型';

--
-- Definition for table sys_module
--
DROP TABLE IF EXISTS sys_module;
CREATE TABLE sys_module (
  module_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '模块ID',
  module_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '模块标题',
  module VARCHAR(255) NOT NULL DEFAULT 'admin' COMMENT '项目名',
  controller VARCHAR(255) NOT NULL DEFAULT '' COMMENT '控制器名',
  method VARCHAR(255) NOT NULL DEFAULT '' COMMENT '方法名',
  pid INT(10) NOT NULL DEFAULT 0 COMMENT '上级模块ID',
  level INT(11) NOT NULL DEFAULT 1 COMMENT '深度等级',
  url VARCHAR(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  is_menu TINYINT(1) NOT NULL DEFAULT 0 COMMENT '是否是菜单',
  is_dev TINYINT(1) NOT NULL DEFAULT 0 COMMENT '是否仅开发者模式可见',
  sort INT(10) NOT NULL DEFAULT 0 COMMENT '排序（同级有效）',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  modify_time DATETIME DEFAULT NULL,
  `desc` TEXT DEFAULT NULL COMMENT '模块描述',
  module_picture VARCHAR(255) NOT NULL DEFAULT '' COMMENT '模块图片',
  icon_class VARCHAR(255) NOT NULL DEFAULT '' COMMENT '矢量图class',
  is_control_auth TINYINT(1) NOT NULL DEFAULT 1 COMMENT '是否控制权限',
  PRIMARY KEY (module_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 524
AVG_ROW_LENGTH = 606
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '系统模块表';

--
-- Definition for table sys_notice
--
DROP TABLE IF EXISTS sys_notice;
CREATE TABLE sys_notice (
  id INT(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  shopid INT(11) NOT NULL COMMENT '店铺ID（单店版为0）',
  notice_message VARCHAR(255) DEFAULT '' COMMENT '公告内容',
  is_enable TINYINT(1) DEFAULT 0 COMMENT '是否启用（0：隐藏，1：显示）',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 8
AVG_ROW_LENGTH = 16384
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '网站公告';

--
-- Definition for table sys_notice_template
--
DROP TABLE IF EXISTS sys_notice_template;
CREATE TABLE sys_notice_template (
  template_id INT(11) NOT NULL AUTO_INCREMENT COMMENT '模板id',
  template_type VARCHAR(50) NOT NULL DEFAULT '' COMMENT '模板类型',
  instance_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺id',
  template_code VARCHAR(50) NOT NULL DEFAULT '' COMMENT '模板编号',
  template_title VARCHAR(50) NOT NULL DEFAULT '' COMMENT '模板编号',
  template_content TEXT NOT NULL COMMENT '模板名称',
  sign_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '签名',
  is_enable INT(11) NOT NULL DEFAULT 0 COMMENT '是否开启',
  modify_time DATETIME NOT NULL COMMENT '更新时间',
  PRIMARY KEY (template_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 55
AVG_ROW_LENGTH = 1170
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '通知模版设置';

--
-- Definition for table sys_notice_template_item
--
DROP TABLE IF EXISTS sys_notice_template_item;
CREATE TABLE sys_notice_template_item (
  id INT(11) NOT NULL AUTO_INCREMENT,
  item_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '项名称',
  show_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '显示名称',
  replace_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '替换字段名字',
  type_ids VARCHAR(255) NOT NULL COMMENT '关联type类型',
  `order` INT(11) NOT NULL DEFAULT 0 COMMENT '排序',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 12
AVG_ROW_LENGTH = 1820
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '通知模板项';

--
-- Definition for table sys_notice_template_type
--
DROP TABLE IF EXISTS sys_notice_template_type;
CREATE TABLE sys_notice_template_type (
  type_id INT(11) NOT NULL AUTO_INCREMENT,
  template_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '模板名称',
  template_code VARCHAR(50) NOT NULL DEFAULT '' COMMENT '模板编号',
  template_type VARCHAR(50) NOT NULL DEFAULT '' COMMENT '模板类型',
  PRIMARY KEY (type_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 11
AVG_ROW_LENGTH = 2340
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '通知模板类型';

--
-- Definition for table sys_province
--
DROP TABLE IF EXISTS sys_province;
CREATE TABLE sys_province (
  province_id INT(11) NOT NULL AUTO_INCREMENT,
  area_id TINYINT(4) NOT NULL DEFAULT 0,
  province_name VARCHAR(255) NOT NULL DEFAULT '',
  sort INT(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (province_id),
  INDEX IDX_g_province_ProvinceName (province_name)
)
ENGINE = INNODB
AUTO_INCREMENT = 42
AVG_ROW_LENGTH = 481
CHARACTER SET utf8
COLLATE utf8_general_ci;

--
-- Definition for table sys_user
--
DROP TABLE IF EXISTS sys_user;
CREATE TABLE sys_user (
  uid INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  instance_id INT(11) NOT NULL DEFAULT 0 COMMENT '实例信息',
  user_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '用户名',
  user_password VARCHAR(255) NOT NULL DEFAULT '' COMMENT '用户密码（MD5）',
  user_status INT(11) NOT NULL DEFAULT 1 COMMENT '用户状态  用户状态默认为1',
  user_headimg VARCHAR(255) NOT NULL DEFAULT '' COMMENT '用户头像',
  is_system INT(1) NOT NULL DEFAULT 0 COMMENT '是否是系统后台用户 0 不是 1 是',
  is_member INT(11) NOT NULL DEFAULT 0 COMMENT '是否是前台会员',
  user_tel VARCHAR(20) NOT NULL DEFAULT '' COMMENT '手机号',
  user_tel_bind INT(1) NOT NULL DEFAULT 0 COMMENT '手机号是否绑定 0 未绑定 1 绑定 ',
  user_qq VARCHAR(255) DEFAULT '' COMMENT 'qq号',
  qq_openid VARCHAR(255) NOT NULL DEFAULT '' COMMENT 'qq互联id',
  qq_info VARCHAR(2000) NOT NULL DEFAULT '' COMMENT 'qq账号相关信息',
  user_email VARCHAR(50) NOT NULL DEFAULT '' COMMENT '邮箱',
  user_email_bind INT(1) NOT NULL DEFAULT 0 COMMENT '是否邮箱绑定',
  wx_openid VARCHAR(255) DEFAULT NULL COMMENT '微信用户openid',
  wx_sub_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '微信用户关注时间',
  wx_notsub_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '微信用户取消关注时间',
  wx_is_sub INT(1) NOT NULL DEFAULT 0 COMMENT '微信用户是否关注',
  wx_info VARCHAR(2000) DEFAULT NULL COMMENT '微信用户信息',
  other_info VARCHAR(255) DEFAULT NULL COMMENT '附加信息',
  reg_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '注册时间',
  current_login_ip VARCHAR(255) DEFAULT NULL COMMENT '当前登录ip',
  current_login_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '当前登录时间',
  current_login_type INT(11) DEFAULT NULL COMMENT '当前登录的操作终端类型',
  last_login_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '上次登录时间',
  last_login_ip VARCHAR(255) DEFAULT NULL COMMENT '上次登录ip',
  last_login_type INT(11) DEFAULT NULL COMMENT '上次登录的操作终端类型',
  login_num INT(11) NOT NULL DEFAULT 0 COMMENT '登录次数',
  real_name VARCHAR(50) DEFAULT '' COMMENT '真实姓名',
  sex SMALLINT(6) DEFAULT 0 COMMENT '性别 0保密 1男 2女',
  birthday DATE DEFAULT '0000-00-00' COMMENT '生日',
  location VARCHAR(255) DEFAULT '' COMMENT '所在地',
  nick_name VARCHAR(50) DEFAULT '牛酷用户' COMMENT '用户昵称',
  wx_unionid VARCHAR(255) NOT NULL DEFAULT '' COMMENT '微信unionid',
  qrcode_template_id INT(11) NOT NULL DEFAULT 0 COMMENT '模板id',
  PRIMARY KEY (uid)
)
ENGINE = INNODB
AUTO_INCREMENT = 48
AVG_ROW_LENGTH = 372
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '系统用户表';

--
-- Definition for table sys_user_admin
--
DROP TABLE IF EXISTS sys_user_admin;
CREATE TABLE sys_user_admin (
  uid INT(11) NOT NULL DEFAULT 0 COMMENT 'user用户ID',
  admin_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '用户姓名',
  group_id_array INT(11) NOT NULL DEFAULT 0 COMMENT '系统用户组',
  is_admin INT(1) NOT NULL DEFAULT 0 COMMENT '是否是系统管理员组',
  admin_status INT(11) DEFAULT 1 COMMENT '状态 默认为1',
  `desc` TEXT DEFAULT NULL COMMENT '附加信息',
  PRIMARY KEY (uid)
)
ENGINE = INNODB
AVG_ROW_LENGTH = 910
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '后台管理员表';

--
-- Definition for table sys_user_group
--
DROP TABLE IF EXISTS sys_user_group;
CREATE TABLE sys_user_group (
  group_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  instance_id INT(11) NOT NULL DEFAULT 1 COMMENT '实例ID',
  group_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '用户组名称',
  group_status INT(11) NOT NULL DEFAULT 1 COMMENT '用户组状态',
  is_system INT(1) NOT NULL DEFAULT 0 COMMENT '是否是系统用户组',
  module_id_array TEXT NOT NULL COMMENT '系统模块ID组，用，隔开',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '修改时间',
  `desc` TEXT DEFAULT NULL COMMENT '描述',
  PRIMARY KEY (group_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 8
AVG_ROW_LENGTH = 963
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '系统用户组表';

--
-- Definition for table sys_user_log
--
DROP TABLE IF EXISTS sys_user_log;
CREATE TABLE sys_user_log (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  uid INT(11) NOT NULL DEFAULT 0 COMMENT '操作用户ID',
  is_system INT(11) NOT NULL DEFAULT 1 COMMENT '是否是后台操作',
  controller VARCHAR(255) NOT NULL DEFAULT '' COMMENT '操作控制器',
  method VARCHAR(255) NOT NULL DEFAULT '' COMMENT '操作方案',
  data TEXT DEFAULT NULL COMMENT '传输数据',
  ip VARCHAR(255) DEFAULT NULL COMMENT 'ip地址',
  create_time DATETIME NOT NULL COMMENT '创建时间',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 9187
AVG_ROW_LENGTH = 82
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '用户操作日志';

--
-- Definition for table sys_web_style
--
DROP TABLE IF EXISTS sys_web_style;
CREATE TABLE sys_web_style (
  style_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  style_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '样式名称',
  style_path VARCHAR(255) NOT NULL DEFAULT '' COMMENT '样式路径',
  stye_img VARCHAR(255) NOT NULL DEFAULT '' COMMENT '样式图片路径',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '修改时间',
  `desc` TEXT DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (style_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 2
AVG_ROW_LENGTH = 16384
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '网站前台样式表';

--
-- Definition for table sys_website
--
DROP TABLE IF EXISTS sys_website;
CREATE TABLE sys_website (
  website_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  title VARCHAR(255) NOT NULL DEFAULT '' COMMENT '网站标题',
  logo VARCHAR(255) NOT NULL DEFAULT '' COMMENT '网站logo',
  web_desc VARCHAR(1000) NOT NULL DEFAULT '' COMMENT '网站描述',
  key_words VARCHAR(255) NOT NULL DEFAULT '' COMMENT '网站关键字',
  web_icp VARCHAR(255) NOT NULL DEFAULT '' COMMENT '网站备案号',
  style_id INT(10) NOT NULL DEFAULT 0 COMMENT '网站风格',
  web_address VARCHAR(255) NOT NULL DEFAULT '' COMMENT '网站联系地址',
  web_qrcode VARCHAR(255) NOT NULL DEFAULT '' COMMENT '网站公众号二维码',
  web_url VARCHAR(255) NOT NULL DEFAULT '' COMMENT '店铺网址',
  web_email VARCHAR(255) NOT NULL DEFAULT '' COMMENT '网站邮箱',
  web_phone VARCHAR(255) NOT NULL DEFAULT '' COMMENT '网站联系方式',
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '网站创建时间',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '网站修改时间',
  web_qq VARCHAR(255) NOT NULL DEFAULT '' COMMENT '网站qq号',
  web_weixin VARCHAR(255) NOT NULL DEFAULT '' COMMENT '网站微信号',
  web_status INT(10) NOT NULL DEFAULT 1 COMMENT '网站运营状态1.开启 2.关闭 ',
  third_count TEXT NOT NULL COMMENT '第三方统计',
  close_reason VARCHAR(255) NOT NULL DEFAULT '' COMMENT '站点关闭原因',
  wap_status INT(10) NOT NULL DEFAULT 1 COMMENT '手机端运营状态 1.开启2.关闭',
  PRIMARY KEY (website_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 2
AVG_ROW_LENGTH = 16384
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '网站信息表';

--
-- Definition for table sys_weixin_auth
--
DROP TABLE IF EXISTS sys_weixin_auth;
CREATE TABLE sys_weixin_auth (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  instance_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺id',
  authorizer_appid VARCHAR(255) NOT NULL DEFAULT '' COMMENT '店铺的appid  授权之后不用刷新',
  authorizer_refresh_token VARCHAR(255) NOT NULL DEFAULT '' COMMENT '店铺授权之后的刷新token，每月刷新',
  authorizer_access_token VARCHAR(255) NOT NULL DEFAULT '' COMMENT '店铺的公众号token，只有2小时',
  func_info VARCHAR(1000) NOT NULL DEFAULT '' COMMENT '授权项目',
  nick_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '公众号昵称',
  head_img VARCHAR(255) NOT NULL DEFAULT '' COMMENT '公众号头像url',
  user_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '公众号原始账号',
  alias VARCHAR(255) NOT NULL DEFAULT '' COMMENT '公众号原始名称',
  qrcode_url VARCHAR(255) NOT NULL DEFAULT '' COMMENT '公众号二维码url',
  auth_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '授权时间',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 3
AVG_ROW_LENGTH = 8192
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '店铺(实例)微信公众账号授权';

--
-- Definition for table sys_weixin_default_replay
--
DROP TABLE IF EXISTS sys_weixin_default_replay;
CREATE TABLE sys_weixin_default_replay (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  instance_id INT(11) NOT NULL COMMENT '店铺id',
  reply_media_id INT(11) NOT NULL COMMENT '回复媒体内容id',
  sort INT(11) NOT NULL,
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 2
AVG_ROW_LENGTH = 16384
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '关注时回复';

--
-- Definition for table sys_weixin_fans
--
DROP TABLE IF EXISTS sys_weixin_fans;
CREATE TABLE sys_weixin_fans (
  fans_id INT(11) NOT NULL AUTO_INCREMENT COMMENT '粉丝ID',
  uid INT(11) NOT NULL DEFAULT 0 COMMENT '会员编号ID',
  source_uid INT(11) NOT NULL DEFAULT 0 COMMENT '推广人uid',
  instance_id INT(11) NOT NULL COMMENT '店铺ID',
  nickname VARCHAR(255) NOT NULL COMMENT '昵称',
  nickname_decode VARCHAR(255) DEFAULT '',
  headimgurl VARCHAR(500) NOT NULL DEFAULT '' COMMENT '头像',
  sex SMALLINT(6) NOT NULL DEFAULT 1 COMMENT '性别',
  language VARCHAR(20) NOT NULL DEFAULT '' COMMENT '用户语言',
  country VARCHAR(60) NOT NULL DEFAULT '' COMMENT '国家',
  province VARCHAR(255) NOT NULL DEFAULT '' COMMENT '省',
  city VARCHAR(255) NOT NULL DEFAULT '' COMMENT '城市',
  district VARCHAR(255) NOT NULL DEFAULT '' COMMENT '行政区/县',
  openid VARCHAR(255) NOT NULL DEFAULT '' COMMENT '用户的标识，对当前公众号唯一     用户的唯一身份ID',
  unionid VARCHAR(255) NOT NULL DEFAULT '' COMMENT '粉丝unionid',
  groupid INT(11) NOT NULL DEFAULT 0 COMMENT '粉丝所在组id',
  is_subscribe BIGINT(1) NOT NULL DEFAULT 1 COMMENT '是否订阅',
  subscribe_date DATETIME NOT NULL COMMENT '订阅时间',
  unsubscribe_date DATETIME DEFAULT NULL COMMENT '解订阅时间',
  update_date DATETIME DEFAULT NULL COMMENT '粉丝信息最后更新时间',
  memo VARCHAR(255) NOT NULL COMMENT '备注',
  PRIMARY KEY (fans_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 12
AVG_ROW_LENGTH = 1638
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '微信公众号获取粉丝列表';

--
-- Definition for table sys_weixin_follow_replay
--
DROP TABLE IF EXISTS sys_weixin_follow_replay;
CREATE TABLE sys_weixin_follow_replay (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  instance_id INT(11) NOT NULL COMMENT '店铺id',
  reply_media_id INT(11) NOT NULL COMMENT '回复媒体内容id',
  sort INT(11) NOT NULL,
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 12
AVG_ROW_LENGTH = 16384
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '关注时回复';

--
-- Definition for table sys_weixin_functions_button
--
DROP TABLE IF EXISTS sys_weixin_functions_button;
CREATE TABLE sys_weixin_functions_button (
  button_id INT(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  instance_id INT(11) NOT NULL COMMENT '实例',
  button_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '模块名',
  keyname VARCHAR(20) NOT NULL DEFAULT '' COMMENT '触发关键词',
  url VARCHAR(255) NOT NULL DEFAULT '' COMMENT '触发网址',
  hits INT(11) NOT NULL DEFAULT 0 COMMENT '触发次数',
  is_enabled INT(1) NOT NULL DEFAULT 1 COMMENT '是否启用',
  is_system INT(1) DEFAULT 0,
  orders INT(11) NOT NULL DEFAULT 0 COMMENT '排序号',
  create_time DATETIME DEFAULT NULL COMMENT '创建日期',
  modify_time DATETIME DEFAULT NULL COMMENT '修改日期',
  PRIMARY KEY (button_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 1
AVG_ROW_LENGTH = 1489
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '微信功能按钮';

--
-- Definition for table sys_weixin_instance_msg
--
DROP TABLE IF EXISTS sys_weixin_instance_msg;
CREATE TABLE sys_weixin_instance_msg (
  id INT(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  instance_id INT(11) NOT NULL COMMENT '店铺id（单店版为0）',
  template_no VARCHAR(55) NOT NULL COMMENT '模版编号',
  template_id VARBINARY(55) DEFAULT NULL COMMENT '微信模板消息的ID',
  title VARCHAR(100) NOT NULL COMMENT '模版标题',
  is_enable BIT(1) DEFAULT b'0' COMMENT '是否启用',
  headtext VARCHAR(255) NOT NULL COMMENT '头部文字',
  bottomtext VARCHAR(255) NOT NULL COMMENT '底部文字',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 6
AVG_ROW_LENGTH = 4096
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '微信实例消息';

--
-- Definition for table sys_weixin_key_replay
--
DROP TABLE IF EXISTS sys_weixin_key_replay;
CREATE TABLE sys_weixin_key_replay (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  instance_id INT(11) NOT NULL COMMENT '店铺id',
  `key` VARCHAR(255) NOT NULL COMMENT '关键词',
  match_type TINYINT(4) NOT NULL COMMENT '匹配类型1模糊匹配2全部匹配',
  reply_media_id INT(11) NOT NULL COMMENT '回复媒体内容id',
  sort INT(11) NOT NULL,
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 6
AVG_ROW_LENGTH = 16384
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '关键词回复';

--
-- Definition for table sys_weixin_media
--
DROP TABLE IF EXISTS sys_weixin_media;
CREATE TABLE sys_weixin_media (
  media_id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '图文消息id',
  title VARCHAR(50) NOT NULL DEFAULT '' COMMENT '标题',
  instance_id INT(11) NOT NULL DEFAULT 0 COMMENT '实例id店铺id',
  type VARCHAR(255) NOT NULL DEFAULT '1' COMMENT '类型1文本(项表无内容) 2单图文 3多图文',
  sort INT(11) NOT NULL DEFAULT 0,
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建日期',
  modify_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '修改日期',
  PRIMARY KEY (media_id),
  UNIQUE INDEX id (media_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 47
AVG_ROW_LENGTH = 1170
CHARACTER SET utf8
COLLATE utf8_general_ci;

--
-- Definition for table sys_weixin_media_item
--
DROP TABLE IF EXISTS sys_weixin_media_item;
CREATE TABLE sys_weixin_media_item (
  id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'id',
  media_id INT(11) NOT NULL COMMENT '图文消息id',
  title VARCHAR(50) NOT NULL COMMENT '标题',
  author VARCHAR(50) NOT NULL COMMENT '作者',
  cover VARCHAR(200) NOT NULL COMMENT '图文消息封面',
  show_cover_pic TINYINT(4) NOT NULL DEFAULT 1 COMMENT '封面图片显示在正文中',
  summary VARCHAR(200) NOT NULL COMMENT '摘要',
  content TEXT NOT NULL COMMENT '正文',
  content_source_url VARCHAR(200) NOT NULL DEFAULT '' COMMENT '图文消息的原文地址，即点击“阅读原文”后的URL',
  sort INT(11) NOT NULL DEFAULT 0 COMMENT '排序号',
  hits INT(11) NOT NULL DEFAULT 0 COMMENT '阅读次数',
  PRIMARY KEY (id),
  INDEX id (media_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 85
AVG_ROW_LENGTH = 712
CHARACTER SET utf8
COLLATE utf8_general_ci;

--
-- Definition for table sys_weixin_menu
--
DROP TABLE IF EXISTS sys_weixin_menu;
CREATE TABLE sys_weixin_menu (
  menu_id INT(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  instance_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺id',
  menu_name VARCHAR(50) NOT NULL DEFAULT '' COMMENT '菜单名称',
  ico VARCHAR(32) NOT NULL DEFAULT '' COMMENT '菜图标单',
  pid INT(11) NOT NULL DEFAULT 0 COMMENT '父菜单',
  menu_event_type TINYINT(4) NOT NULL DEFAULT 1 COMMENT '1普通url 2 图文素材 3 功能',
  media_id INT(11) NOT NULL DEFAULT 0 COMMENT '图文消息ID',
  menu_event_url VARCHAR(255) NOT NULL DEFAULT '' COMMENT '菜单url',
  hits INT(11) NOT NULL DEFAULT 0 COMMENT '触发数',
  sort INT(11) NOT NULL DEFAULT 0 COMMENT '排序',
  create_date DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建日期',
  modify_date DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '修改日期',
  PRIMARY KEY (menu_id),
  INDEX IDX_biz_shop_menu_orders (sort),
  INDEX IDX_biz_shop_menu_shopId (instance_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 196
AVG_ROW_LENGTH = 1638
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '微设置->微店菜单';

--
-- Definition for table sys_weixin_msg_template
--
DROP TABLE IF EXISTS sys_weixin_msg_template;
CREATE TABLE sys_weixin_msg_template (
  id INT(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  template_no VARCHAR(55) NOT NULL COMMENT '编号',
  title VARCHAR(100) NOT NULL COMMENT '标题',
  contents VARCHAR(255) NOT NULL DEFAULT '' COMMENT '内容示例',
  template_id VARCHAR(55) DEFAULT '' COMMENT '模版id',
  headtext VARCHAR(255) DEFAULT NULL COMMENT '头部文字',
  bottomtext VARCHAR(255) DEFAULT NULL COMMENT '底部文字',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 1
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '微信消息模版';

--
-- Definition for table sys_weixin_qrcode_template
--
DROP TABLE IF EXISTS sys_weixin_qrcode_template;
CREATE TABLE sys_weixin_qrcode_template (
  id INT(11) NOT NULL AUTO_INCREMENT COMMENT '实例ID',
  instance_id INT(11) NOT NULL DEFAULT 0 COMMENT '店铺id',
  background VARCHAR(255) NOT NULL DEFAULT '' COMMENT '背景图片',
  nick_font_color VARCHAR(255) NOT NULL DEFAULT '#000' COMMENT '昵称字体颜色',
  nick_font_size SMALLINT(6) NOT NULL DEFAULT 12 COMMENT '昵称字体大小',
  is_logo_show SMALLINT(6) NOT NULL DEFAULT 1 COMMENT 'logo是否显示',
  header_left VARCHAR(6) NOT NULL DEFAULT '0px' COMMENT '头部左边距',
  header_top VARCHAR(6) NOT NULL DEFAULT '0px' COMMENT '头部上边距',
  name_left VARCHAR(6) NOT NULL DEFAULT '0px' COMMENT '昵称左边距',
  name_top VARCHAR(6) NOT NULL DEFAULT '0px' COMMENT '昵称上边距',
  logo_left VARCHAR(6) NOT NULL DEFAULT '0px' COMMENT 'logo左边距',
  logo_top VARCHAR(6) NOT NULL DEFAULT '0px' COMMENT 'logo上边距',
  code_left VARCHAR(6) NOT NULL DEFAULT '0px' COMMENT '二维码左边距',
  code_top VARCHAR(6) NOT NULL DEFAULT '0px' COMMENT '二维码上边距',
  is_check TINYINT(4) NOT NULL DEFAULT 0 COMMENT '是否默认',
  is_remove TINYINT(4) NOT NULL DEFAULT 0 COMMENT '是否删除  0未删除 1删除',
  template_url VARCHAR(255) NOT NULL DEFAULT '' COMMENT '模板样式路径',
  PRIMARY KEY (id)
)
ENGINE = INNODB
AUTO_INCREMENT = 80
AVG_ROW_LENGTH = 5461
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '微信推广二维码模板管理';

--
-- Definition for table sys_weixin_user_msg
--
DROP TABLE IF EXISTS sys_weixin_user_msg;
CREATE TABLE sys_weixin_user_msg (
  msg_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  uid INT(11) NOT NULL,
  msg_type VARCHAR(255) NOT NULL,
  content TEXT DEFAULT NULL,
  create_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  is_replay INT(11) NOT NULL DEFAULT 0 COMMENT '是否回复',
  PRIMARY KEY (msg_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 2
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '微信用户消息表';

--
-- Definition for table sys_weixin_user_msg_replay
--
DROP TABLE IF EXISTS sys_weixin_user_msg_replay;
CREATE TABLE sys_weixin_user_msg_replay (
  replay_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  msg_id INT(11) NOT NULL,
  replay_uid INT(11) NOT NULL COMMENT '当前客服uid',
  replay_type VARCHAR(255) NOT NULL,
  content TEXT DEFAULT NULL,
  replay_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (replay_id)
)
ENGINE = INNODB
AUTO_INCREMENT = 1
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '微信用户消息回复表';

--
-- Definition for table sys_wexin_onekeysubscribe
--
DROP TABLE IF EXISTS sys_wexin_onekeysubscribe;
CREATE TABLE sys_wexin_onekeysubscribe (
  instance_id INT(11) NOT NULL COMMENT '实例ID',
  url VARCHAR(300) NOT NULL DEFAULT '' COMMENT '一键关注url',
  PRIMARY KEY (instance_id)
)
ENGINE = INNODB
AVG_ROW_LENGTH = 2048
CHARACTER SET utf8
COLLATE utf8_general_ci
COMMENT = '微信一键关注设置';

DELIMITER $$

--
-- Definition for procedure sp_ns_ordersClose
--
DROP PROCEDURE IF EXISTS sp_ns_ordersClose$$
CREATE DEFINER = 'root'@'%'
PROCEDURE sp_ns_ordersClose()
  COMMENT '订单关闭'
BEGIN
   DECLARE is_end int DEFAULT 0;
   DECLARE $p_order_id, $p_pay_status, $p_point, $p_coupon_id, $p_buyer_id, $p_shop_id INT DEFAULT 0;
   DECLARE $p_user_money, $p_user_platform_money, $p_coin_money decimal(10,2) DEFAULT 0;
   DECLARE $p_point_sum decimal(10,2) DEFAULT 0;
   DECLARE $p_user_account_count INT DEFAULT 0;
   DECLARE $p_convert varchar(255) DEFAULT '';
   DECLARE cusor_order CURSOR FOR
            SELECT no.order_id FROM ns_order no WHERE no.order_status=0 AND TIMESTAMPDIFF(MINUTE,no.create_time, NOW())>60;
   DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET is_end=1;
   OPEN cusor_order;
   FETCH cusor_order INTO $p_order_id;
   WHILE is_end!=1 DO 
         #查询订单的详细信息
         SELECT nos.pay_status, nos.point, nos.coupon_id, nos.user_money, nos.buyer_id, nos.shop_id, nos.user_platform_money, nos.coin_money INTO 
             $p_pay_status, $p_point, $p_coupon_id, $p_user_money, $p_buyer_id, $p_shop_id, $p_user_platform_money, $p_coin_money    
            FROM ns_order nos WHERE nos.order_id=$p_order_id;
         #更新订单的状态
         UPDATE ns_order no SET no.order_status=5 WHERE no.order_id =$p_order_id;
         #积分返还
         IF $p_point>0 THEN
            SELECT IFNULL(SUM(nmar.number), 0) INTO $p_point_sum FROM ns_member_account_records nmar WHERE nmar.shop_id=$p_shop_id AND nmar.uid =$p_buyer_id AND nmar.account_type=1;
            IF $p_point_sum>=0 THEN
                SELECT IFNULL(COUNT(nma.id), 0) INTO $p_user_account_count FROM ns_member_account nma WHERE nma.uid =$p_buyer_id AND nma.shop_id=$p_shop_id;
                IF $p_user_account_count=0 THEN 
                    #当前用户没有账户 创建用户
                    INSERT INTO ns_member_account ( uid, shop_id, point, member_sum_point) VALUES ($p_buyer_id, $p_shop_id, $p_point_sum, $p_point_sum);
                ELSE
                    #更新用户的积分账户
                    UPDATE ns_member_account nma SET nma.point=$p_point_sum, nma.member_sum_point=nma.member_sum_point+$p_point_sum WHERE nma.uid=$p_buyer_id AND nma.shop_id=$p_shop_id;
                END IF;
            END IF;
          END IF;
          IF $p_coin_money>0 THEN 
              SELECT sc.value INTO $p_convert FROM sys_config sc WHERE sc.`key` ='COIN_CONFIG' LIMIT 1;
              -- SET $p_convert=REPLACE($p_convert, '{"convert_rate":', "")', )
          END IF;
        
   END WHILE;
   CLOSE cusor_order;
END
$$

--
-- Definition for procedure test
--
DROP PROCEDURE IF EXISTS test$$
CREATE DEFINER = 'root'@'%'
PROCEDURE test()
  COMMENT '应用批量处理'
BEGIN
  DECLARE p_count, p_i, p_uid, p_shop_id, p_region_id int;
  SELECT COUNT( npra.region_agent_id) INTO p_count FROM nfx_promoter_region_agent npra WHERE npra.is_audit = 1;
  SET p_i = 0;
  WHILE p_i < p_count DO 
    SELECT uid, shop_id, npra.region_agent_id INTO p_uid, p_shop_id, p_region_id FROM nfx_promoter_region_agent npra WHERE npra.is_audit = 1 LIMIT p_i, 1;
    UPDATE nfx_shop_member_association nsma set region_center_id=p_region_id WHERE nsma.uid = p_uid AND nsma.shop_id = p_shop_id;
    SET p_i = p_i + 1;
    END WHILE;
        
END
$$

DELIMITER ;

-- 
-- Dumping data for table nc_cms_article
--
INSERT INTO nc_cms_article VALUES
(169, 'Niushop商城招商活动进行中', 22, '招商', '', '', '路飞', '', '我司于2017年1月1日起，诚邀有意加入Niushop商城商家平台的企业商家。我们将与您一起展望探讨未来电商平台的发展规划，并与您分享电子商务行业的广阔前景，共创美好未来！招商基本信息如下：品类：综合百货全品类', '', '招商', '', 10, 1, 0, 0, 2, '', '招商', 0, '0000-00-00 00:00:00', 0, '2', 2, '2017-02-20 14:43:41', '2017-02-20 14:43:41', '2017-02-20 14:50:48'),
(170, '关于假冒客服诈骗的声明', 13, '假冒客服诈骗', '', '', '路飞', '假冒客服诈骗', '亲爱的各位网友，近期我们接到消费者反映，有不法人员打着Niushop客服的名义，用手机号或者模仿400电话，以淘库系统维护、订单异常等无法发货需要退款为由，以加用户QQ或其他形式发送仿冒我司退款平台的钓鱼网站，或者通过引导消费者进行ATM转账、声称消费者中奖、向消费者电话推销打折卡和贵宾卡等手段进行诈骗活动。Niushop特此声明：全天候客服电话4000-380-888只用于接听客户来电，进行外呼业务时不会显示4000-380-888、+4000-380-888、8614000-380-888、或手机号码 ，更不会以QQ方式与用户沟通；Niushop工作人员从未引导消费者进行ATM转账；从未以消费者中奖为由，收取所谓的邮寄费、过关费等；从未以电话、QQ等工具推销过任何形式的打折卡、贵宾卡；也从未以订单无效需为消费者退款为由主动索取消费者银行卡信息。如有任何组织或个人以淘库名义通过电话  、QQ等聊天工具向客户收取前述费用或者推销打折卡、贵宾卡的，或者使用各种即时通讯工具发送商品需重新支付或退款的链接的，均属诈骗行为。客户若遇到类似情况，可及时反馈Niushop客服人员；若因此遭受损失，Niushop建议客户及时报警，并通知Niushop客户服务人员。Niushop将积极配合相关部门对此类行为进行调查处理，并尽一切努力，协助客户维护合法权益，淘库保留追究相关违 法人员法律责任的一切权利。另外，Niushop特别提醒消费者，有关Niushop的客服电话，请以Niushop平台网站公布的信息为准，谨防上当受骗。', '', '诈骗', '', 20, 2, 0, 1, 2, '', '诈骗', 0, '0000-00-00 00:00:00', 0, '2', 2, '2017-02-20 14:54:07', '2017-02-20 14:54:07', '0000-00-00 00:00:00'),
(171, '购物流程', 15, '流程', '', '', '路飞', '购物流程', '怎样注册？您可以直接点击"会员注册"进行注册。注册很简单，您只需按注册向导的要求输入一些基本信息即可。为了准确地为您服务，请务必在注册时填写您的真实信息，我们会为您保密。输入的帐号要4-10位，仅可使用英文字母、数字"-"。怎样成为会员?答：您可以直接点击"会员登录与注册"进行注册。注册很简单，您只需根据系统提示输入相关资料即可，请您填写完毕时，务必核对填写内容的准确性，并谨记您的会员账号和密码，以便您查询订单或是希望网站提供予您更多的服务时用以核对您的身份。如何在网上下单购买，怎么一个操作流程呢？答：这种方式和您逛商场的方式十分相似，您只要按照我们的商品分类页面或进入"钻石珠宝"、"个性定制"等逐页按照链接指明的路径浏览就可以了。 一旦看中了您喜欢的商品，您可以随时点击"放入购物篮"按钮将它放入"购物篮"。随后，您可以按"去收银台"。我们的商品十分丰富，不过您别担心，我们在每一页中都设立了详细明白的导航条，您是不会迷路的。', '', '购物', '', 50, 3, 0, 0, 2, '', '购物', 0, '0000-00-00 00:00:00', 0, '2', 2, '2017-02-20 15:13:01', '2017-02-20 15:13:01', '2017-03-09 18:55:39'),
(172, 'NIUSHOP商城论坛技术支持', 13, '送货', '', '', '路飞', '送货上门', '1、送货上门、货到付款订单：快递员送货上门时，请您务必当面对照发货单核对商品，如果出现商品数量缺少、商品破损，请您当场办理整单商品的退货。若订单中含有赠品，请一并退回。一旦您确认签字，我们将无法为您办理退换或补发。特别提示：如果您的订单使用帐户余额或礼券支付，只有退货商品的金额小于实际应付款金额时才可办理。如果您的订单中含有赠品，将无法提供此项服务；如果是成套商品，您只能整套退货。如果是捆绑商品，您在退主商品的同时需要将赠品一起退回。2、邮局邮寄订单：请您在领取包裹时务必检查外包装，如果发现包裹破损，请您不要签收，随后请及时将包裹单原件邮寄给我们，您的包裹单原件将作为我们为您办理补发或退款的唯一证明。收到包裹单后，我们将为您办理相关手续。如您未拆开外包装箱，也可以当场全部退货。平邮订单，在收到包裹时，如发现包裹破损，请您要求邮局出具包裹破损证明。注：敬请您在验货签收时仔细核对发票，如果出现发票开错或漏开，请您及时联系我们，注明订单号、邮寄地址和收信人姓名，我们接到您的信息后会尽快为您开具，并邮寄给您。', '', '送货', '', 0, 5, 0, 0, 2, '', '送货', 0, '0000-00-00 00:00:00', 0, '1', 1, '2017-02-20 15:42:56', '2017-02-20 15:42:56', '2017-06-10 16:07:32'),
(173, 'NIUSHOP商城开发团队简介', 13, '免邮', '', '', '路飞', '满百免邮', '1. Niushop自营商品：注册会员在Niushop网站购买满100元以上（含100元）的商品，即可享受免费配送的服务（偏远地区除外）； 2. 入驻卖家商品配送费用以卖家在商品信息页公示的运费信息为准。', '', '邮费', '', 45, 6, 0, 1, 2, '', '免邮', 0, '0000-00-00 00:00:00', 0, '2', 2, '2017-02-20 15:59:25', '2017-02-20 15:59:25', '2017-02-20 17:52:00'),
(174, 'NIUSHOP商城授权服务', 13, '注册', '', '', '路飞', '会员注册', '尊敬的用户，欢迎您注册成为本网站用户。在注册前请您仔细阅读如下服务条款：本服务协议双方为本网站与本网站用户，本服务协议具有合同效力。您确认本服务协议后，本服务协议即在您和本网站之间产生法律效力。请您务必在注册之前认真阅读全部服务协议内容，如有任何疑问，可向本网站咨询。无论您事实上是否在注册之前认真阅读了本服务协议，只要您点击协议正本下方的"注册"按钮并按照本网站注册程序成功注册为用户，您的行为仍然表示您同意并签署了本服务协议。1．本网站服务条款的确认和接纳本网站各项服务的所有权和运作权归本网站拥有。2．用户必须：(1)自行配备上网的所需设备， 包括个人电脑、调制解调器或其他必备上网装置。(2)自行负担个人上网所支付的与此服务有关的电话费用、 网络费用。3．用户在本网站上交易平台上不得发布下列违法信息：(1)反对宪法所确定的基本原则的；(2).危害国家安全，泄露国家秘密，颠覆国家政权，破坏国家统一的；(3).损害国家荣誉和利益的；(4).煽动民族仇恨、民族歧视，破坏民族团结的；(5).破坏国家宗教政策，宣扬邪教和封建迷信的；(6).散布谣言，扰乱社会秩序，破坏社会稳定的；(7).散布淫秽、色情、赌博、暴力、凶杀、恐怖或者教唆犯罪的；(8).侮辱或者诽谤他人，侵害他人合法权益的；(9).含有法律、行政法规禁止的其他内容的。4． 有关个人资料用户同意：(1) 提供及时、详尽及准确的个人资料。(2).同意接收来自本网站的信息。(3) 不断更新注册资料，符合及时、详尽准确的要求。所有原始键入的资料将引用为注册资料。(4)本网站不公开用户的姓名、地址、电子邮箱和笔名，以下情况除外：（a）用户授权本网站透露这些信息。（b）相应的法律及程序要求本网站提供用户的个人资料。如果用户提供的资料包含有不正确的信息，本网站保留结束用户使用本网站信息服务资格的权利。5. 用户在注册时应当选择稳定性及安全性相对较好的电子邮箱，并且同意接受并阅读本网站发往用户的各类电子邮件。如用户未及时从自己的电子邮箱接受电子邮件或因用户电子邮箱或用户电子邮件接收及阅读程序本身的问题使电子邮件无法正常接收或阅读的，只要本网站成功发送了电子邮件，应当视为用户已经接收到相关的电子邮件。电子邮件在发信服务器上所记录的发出时间视为送达时间。6． 服务条款的修改本网站有权在必要时修改服务条款，本网站服务条款一旦发生变动，将会在重要页面上提示修改内容。如果不同意所改动的内容，用户可以主动取消获得的本网站信息服务。如果用户继续享用本网站信息服务，则视为接受服务条款的变动。本网站保留随时修改或中断服务而不需通知用户的权利。本网站行使修改或中断服务的权利，不需对用户或第三方负责。7． 用户隐私制度尊重用户个人隐私是本网站的一项基本政策。所以，本网站一定不会在未经合法用户授权时公开、编辑或透露其注册资料及保存在本网站中的非公开内容，除非有法律许可要求或本网站在诚信的基础上认为透露这些信息在以下四种情况是必要的：(1) 遵守有关法律规定，遵从本网站合法服务程序。(2) 保持维护本网站的商标所有权。(3) 在紧急情况下竭力维护用户个人和社会大众的隐私安全。(4)符合其他相关的要求。本网站保留发布会员人口分析资询的权利。8．用户的帐号、密码和安全性你一旦注册成功成为用户，你将得到一个密码和帐号。如果你不保管好自己的帐号和密码安全，将负全部责任。另外，每个用户都要对其帐户中的所有活动和事件负全责。你可随时根据指示改变你的密码，也可以结束旧的帐户重开一个新帐户。用户同意若发现任何非法使用用户帐号或安全漏洞的情况，请立即通告本网站。9． 拒绝提供担保用户明确同意信息服务的使用由用户个人承担风险。 本网站不担保服务不会受中断，对服务的及时性，安全性，出错发生都不作担保，但会在能力范围内，避免出错。10．有限责任本网站对任何直接、间接、偶然、特殊及继起的损害不负责任，这些损害来自：不正当使用本网站服务，或用户传送的信息不符合规定等。这些行为都有可能导致本网站形象受损，所以本网站事先提出这种损害的可能性，同时会尽量避免这种损害的发生。11．信息的储存及限制本网站有判定用户的行为是否符合本网站服务条款的要求和精神的权利，如果用户违背本网站服务条款的规定，本网站有权中断其服务的帐号。12．用户管理用户必须遵循：(1) 使用信息服务不作非法用途。(2) 不干扰或混乱网络服务。(3) 遵守所有使用服务的网络协议、规定、程序和惯例。用户的行为准则是以因特网法规，政策、程序和惯例为根据的。13．保障用户同意保障和维护本网站全体成员的利益，负责支付由用户使用超出服务范围引起的律师费用，违反服务条款的损害补偿费用，其它人使用用户的电脑、帐号和其它知识产权的追索费。14．结束服务用户或本网站可随时根据实际情况中断一项或多项服务。本网站不需对任何个人或第三方负责而随时中断服务。用户若反对任何服务条款的建议或对后来的条款修改有异议，或对本网站服务不满，用户可以行使如下权利：(1) 不再使用本网站信息服务。(2) 通知本网站停止对该用户的服务。结束用户服务后，用户使用本网站服务的权利马上中止。从那时起，用户没有权利，本网站也没有义务传送任何未处理的信息或未完成的服务给用户或第三方。15．通告所有发给用户的通告都可通过重要页面的公告或电子邮件或常规的信件传送。服务条款的修改、服务变更、或其它重要事件的通告都会以此形式进行。16．信息内容的所有权本网站定义的信息内容包括：文字、软件、声音、相片、录象、图表；在广告中全部内容；本网站为用户提供的其它信息。所有这些内容受版权、商标、标签和其它财产所有权法律的保护。所以，用户只能在本网站和广告商授权下才能使用这些内容，而不能擅自复制、再造这些内容、或创造与内容有关的派生产品。17．法律本网站信息服务条款要与中华人民共和国的法律解释一致。用户和本网站一致同意服从本网站所在地有管辖权的法院管辖。如发生本网站服务条款与中华人民共和国法律相抵触时，则这些条款将完全按法律规定重新解释，而其它条款则依旧保持对用户的约束力。', '', '会员', '', 100, 7, 0, 0, 2, '', '会员', 0, '0000-00-00 00:00:00', 0, '2', 2, '2017-02-20 16:10:34', '2017-02-20 16:10:34', '2017-02-20 17:49:28'),
(175, 'NIUSHOP商城开发手册', 13, '商城上线啦！', '', '', '', '', '亲爱的NIUSHOP用户：&nbsp; &nbsp; &nbsp; &nbsp;NIUSHOP商城终于和大家见面了。&nbsp; &nbsp; &nbsp; &nbsp;我们通过商城将会把更多的便利和活动奖励送给各位新老客户。在这里，无论是上家还是下家，只要您诚信经营、实力出众，便可向官方申请成为优质上家/下家。审核通过成为优质用户，即可享受由代练通优质商城为您提供的专享特权。&nbsp; &nbsp; &nbsp; &nbsp;多种便捷，优质专享，NIUSHOP商城，只为优质的您专力打造。&nbsp; &nbsp; &nbsp; &nbsp;如果您有什么宝贵意见或发现我们不足的地方还望指出，感谢您一直以来对代练通的大力支持！代练通运营团队2016年11月1日', '', '', '', 0, 0, 0, 0, 2, '', '', 0, '0000-00-00 00:00:00', 0, '1', 1, '2017-02-20 16:14:35', '2017-02-20 16:14:35', '2017-06-10 16:07:10'),
(176, 'NIUSHOP商城测试版震撼发布', 13, '招商', '', '', '路飞', '招商入驻', '一.申请入驻1.核对资质信息：商家首先关注Niushop商城入驻标准，确认符合要求2.提交入驻申请：商家务必按照邮件要求将信息发送到各类目负责人邮箱3.双方沟通：收到资料后，Niushop招商负责人会第一时间与您取得联系4.确认合作意向：招商负责人会与您就合作条款、要求进行沟通，双方确认合作意向二.签订合同1.发送合同：招商负责人邮寄合同到商家处2.资质合同审核：商家按照要求签订合同、提交资质文件到Niushop3.资质合同审核：Niushop相关部门审核合同与资质文件三.开店准备1.准备产品资料：商家准备需要合作产品的相关图片及说明2.交纳相关费用：商家交纳保证金3.开店销售：产品运营经理将与您取得联系安排开店事宜四.入驻指南1.资金要求：公司注册资金50万及50万以上人民币；2.授权资质：需要确保授权链条的完整，即申请入驻企业拿到的授权能够逐级逆推回品牌商；3.提供发票：所有入驻的企业必须给消费者提供正规发票，发票盖章的公司名称必须与商家与淘库合作的公司名称一致；4.申请类型：Niushop商城暂不接受未取得国家商标总局颁发的商标注册证或商标受理通知书的境外品牌的开店申请；5.真实有效：请务必保证您入驻前后提供的相关资质的真实有效性（若您提供的相关资质为第三方提供，如商标注册证、授权书等，请务必先行核实其真实有效性），一旦发现虚假资质，您的公司将被列入非诚信商家名单，Niushop商城将不再与您进行合作，并将扣除保证金。五.费用构成1.仅根据实际销售额（商品售价+配送费）收取佣金，无销售无佣金。六.佣金收取商品分类佣金比例手机通讯、数码、电脑、大家电、小家电、数码配件、办公用品3%家居、个护健康、美容化妆4%服装鞋靴、箱包配饰、钟表、珠宝首饰、玩具、乐器、&nbsp;图书音像5%家装建材、五金电器、汽车用品、运动用品、宠物用品6%闪购 、团购、拍卖、其他服务1%生鲜、果蔬、食品饮料、母婴、酒类、其他食品2%七.开店类型1.合作主体为品牌国代、省代及市代理商2.运营店名称为：专营店八.联系方式1.电子邮箱：&nbsp;2.服务热线：3.未开通地区及境外请拨：九.对公账号户　名:牛酷网络科技有限公司帐　号:&nbsp;开户行:&nbsp;备　注:&nbsp;请注明您的用户名、联系电话/手机等温馨提醒：请您在投诉中提供部门及相关人员、投诉原因，以便我们核实处理，谢谢！', '', '招商', '', 200, 4, 0, 1, 2, '', '招商', 0, '0000-00-00 00:00:00', 12, '1', 1, '2017-02-20 16:15:19', '2017-02-20 16:15:19', '2017-06-07 11:33:35'),
(177, 'NIUSHOP官网', 10, '', '', '', '', '', '<p>\n\t<strong><em><span style="color:#E53333;font-size:24px;">反对上述答复</span></em></strong> \n</p>\n<p>\n\t<table style="width:100%;" cellpadding="2" cellspacing="0" border="1" bordercolor="#000000">\n\t\t<tbody>\n\t\t\t<tr>\n\t\t\t\t<td>\n\t\t\t\t\t<br />\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<br />\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td>\n\t\t\t\t\t<br />\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<br />\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td>\n\t\t\t\t\t<br />\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<br />\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t</tbody>\n\t</table>\n</p>', '', '232132', '', 0, 0, 0, 0, 2, '', '', 0, '0000-00-00 00:00:00', 0, '1', 1, '2017-02-20 17:54:46', '2017-02-20 17:54:46', '2017-06-07 19:48:30'),
(178, '用户注册协议', 24, '', '', '', '', '牛酷商城用户注册协议', '牛酷商城用户注册协议本协议是您与牛酷商城网站（简称"本站"）所有者（以下简称为"牛酷商城"）之间就牛酷商城网站服务等相关事宜所订立的契约，请您仔细阅读本注册协议，您点击"同意并继续"按钮后，本协议即构成对双方有约束力的法律文件。第1条 本站服务条款的确认和接纳1.1本站的各项电子服务的所有权和运作权归牛酷商城所有。用户同意所有注册协议条款并完成注册程序，才能成为本站的正式用户。用户确认：本协议条款是处理双方权利义务的契约，始终有效，法律另有强制性规定或双方另有特别约定的，依其规定。1.2用户点击同意本协议的，即视为用户确认自己具有享受本站服务、下单购物等相应的权利能力和行为能力，能够独立承担法律责任。1.3如果您在18周岁以下，您只能在父母或监护人的监护参与下才能使用本站。第2条 本站服务2.1牛酷商城通过互联网依法为用户提供互联网信息等服务，用户在完全同意本协议及本站规定的情况下，方有权使用本站的相关服务。2.2用户必须自行准备如下设备和承担如下开支：（1）上网设备，包括并不限于电脑或者其他上网终端、调制解调器及其他必备的上网装置；（2）上网开支，包括并不限于网络接入费、上网设备租用费、手机流量费等。第3条 用户信息3.1用户应自行诚信向本站提供注册资料，用户同意其提供的注册资料真实、准确、完整、合法有效，用户注册资料如有变动的，应及时更新其注册资料。如果用户提供的注册资料不合法、不真实、不准确、不详尽的，用户需承担因此引起的相应责任及后果，并且牛酷商城保留终止用户使用牛酷商城各项服务的权利。3.2用户在本站进行浏览、下单购物等活动时，涉及用户真实姓名/名称、通信地址、联系电话、电子邮箱等隐私信息的，本站将予以严格保密，除非得到用户的授权或法律另有规定，本站不会向外界披露用户隐私信息。第4条 用户依法言行义务本协议依据国家相关法律法规规章制定，用户同意严格遵守以下义务：（1）不得传输或发表：煽动抗拒、破坏宪法和法律、行政法规实施的言论，煽动颠覆国家政权，推翻社会主义制度的言论，煽动分裂国家、破坏国家统一的的言论，煽动民族仇恨、民族歧视、破坏民族团结的言论；（2）从中国大陆向境外传输资料信息时必须符合中国有关法规；第5条 其他5.1牛酷商城网站所有者是指在政府部门依法许可或备案的牛酷商城网站经营主体。5.2您点击本协议下方的"同意并继续"按钮即视为您完全接受本协议，在点击之前请您再次确认已知悉并完全理解本协议的全部内容。', '', '', '', 0, 0, 0, 0, 2, '文章附件', '用户注册协议', 0, '0000-00-00 00:00:00', 0, '1', 1, '2017-03-03 10:48:33', '2017-03-03 10:48:33', '2017-06-10 16:03:30');

-- 
-- Dumping data for table nc_cms_article_class
--
INSERT INTO nc_cms_article_class VALUES
(8, 0, '新手上路', 0),
(9, 0, '支付方式', 0),
(10, 0, '配送服务', 3),
(11, 0, '售后服务', 4),
(12, 0, '商家合作', 5),
(13, 8, '常见问题', 1),
(14, 8, '订单查询', 2),
(15, 8, '购物流程', 3),
(16, 9, '网上支付', 0),
(17, 9, '货到付款', 9),
(18, 10, '验货签收', 1),
(19, 10, '订单进度查询', 9),
(20, 11, '验货签收', 19),
(21, 11, '订单进度查询', 2),
(22, 12, '商家入驻', 1),
(23, 0, '用户协议', 6),
(24, 23, '用户注册协议', 2);

-- 
-- Dumping data for table nc_cms_comment
--

-- Table `niushop_1.04`.nc_cms_comment does not contain any data (it is empty)

-- 
-- Dumping data for table nc_cms_topic
--

-- Table `niushop_1.04`.nc_cms_topic does not contain any data (it is empty)

-- 
-- Dumping data for table ns_account
--

-- Table `niushop_1.04`.ns_account does not contain any data (it is empty)

-- 
-- Dumping data for table ns_account_assistant_records
--

-- Table `niushop_1.04`.ns_account_assistant_records does not contain any data (it is empty)

-- 
-- Dumping data for table ns_account_order_records
--

-- Table `niushop_1.04`.ns_account_order_records does not contain any data (it is empty)

-- 
-- Dumping data for table ns_account_period
--

-- Table `niushop_1.04`.ns_account_period does not contain any data (it is empty)

-- 
-- Dumping data for table ns_account_records
--

-- Table `niushop_1.04`.ns_account_records does not contain any data (it is empty)

-- 
-- Dumping data for table ns_account_return_records
--

-- Table `niushop_1.04`.ns_account_return_records does not contain any data (it is empty)

-- 
-- Dumping data for table ns_account_withdraw_records
--

-- Table `niushop_1.04`.ns_account_withdraw_records does not contain any data (it is empty)

-- 
-- Dumping data for table ns_account_withdraw_user_records
--

-- Table `niushop_1.04`.ns_account_withdraw_user_records does not contain any data (it is empty)

-- 
-- Dumping data for table ns_attribute
--
INSERT INTO ns_attribute VALUES
(28, '连衣裙', 1, '110,111', 255, '2017-06-10 14:03:46', '2017-06-10 14:19:05');

-- 
-- Dumping data for table ns_attribute_value
--
INSERT INTO ns_attribute_value VALUES
(74, '风格', 28, '\n\n\t\t\t', 1, 0, 1),
(75, '通勤', 28, ' 韩版,中国风版', 2, 1, 1),
(76, '裙长', 28, '', 1, 2, 1),
(77, '款式', 28, '', 1, 3, 1);

-- 
-- Dumping data for table ns_cart
--
INSERT INTO ns_cart VALUES
(508, 1, 0, 'Niushop开源商城', 259, '女士夏装胖MM加肥加大中长款连衣裙宽松大码无袖背心裙孕妇打底裙', 1091, '女士夏装胖MM加肥加大中长款连衣裙宽松大码无袖背心裙孕妇打底裙', 12.95, 1, 744, 0),
(509, 1, 0, 'Niushop开源商城', 244, 'Koradior/珂莱蒂尔正品新款韩版夏季碎花修身复古印花网纱连衣裙', 1071, 'L ', 489.30, 1, 742, 0);

-- 
-- Dumping data for table ns_consult
--

-- Table `niushop_1.04`.ns_consult does not contain any data (it is empty)

-- 
-- Dumping data for table ns_consult_type
--

-- Table `niushop_1.04`.ns_consult_type does not contain any data (it is empty)

-- 
-- Dumping data for table ns_coupon
--

-- Table `niushop_1.04`.ns_coupon does not contain any data (it is empty)

-- 
-- Dumping data for table ns_coupon_goods
--
INSERT INTO ns_coupon_goods VALUES
(63, 24, 90),
(64, 24, 91),
(65, 24, 93),
(66, 24, 94),
(67, 25, 90),
(68, 25, 91),
(69, 25, 93),
(70, 25, 94),
(71, 25, 95),
(72, 26, 215),
(73, 26, 90),
(74, 26, 91),
(75, 26, 93),
(76, 27, 98),
(81, 31, 90),
(82, 31, 91);

-- 
-- Dumping data for table ns_coupon_type
--

-- Table `niushop_1.04`.ns_coupon_type does not contain any data (it is empty)

-- 
-- Dumping data for table ns_express_company
--
INSERT INTO ns_express_company VALUES
(7405, 0, '申通', '0001', 1, '', '', 1, 'upload/express/1497101952.jpg');

-- 
-- Dumping data for table ns_express_shipping
--
INSERT INTO ns_express_shipping VALUES
(11218, 0, '申通', 7405, 1, 869, 480, 'upload/express/1497094431.JPG');

-- 
-- Dumping data for table ns_express_shipping_items
--
INSERT INTO ns_express_shipping_items VALUES
(11218, 'A1', '订单编号', 1, 336, 53),
(11218, 'A10', '收件人邮编', 1, 252, 230),
(11218, 'A11', '货到付款物流编号', 1, 10, 288),
(11218, 'A12', '代收金额', 1, 64, 388),
(11218, 'A13', '备注', 1, 10, 313),
(11218, 'A2', '发件人公司', 1, 460, 214),
(11218, 'A3', '发件人地址', 1, 132, 102),
(11218, 'A4', '发件人姓名', 1, 325, 313),
(11218, 'A5', '发件人电话', 1, 10, 213),
(11218, 'A6', '发件人邮编', 1, 10, 238),
(11218, 'A7', '收件人地址', 1, 10, 263),
(11218, 'A8', '收件人姓名', 1, 310, 148),
(11218, 'A9', '收件人电话', 1, 187, 354);

-- 
-- Dumping data for table ns_express_shipping_items_library
--
INSERT INTO ns_express_shipping_items_library VALUES
(1, 0, 'A1', '订单编号', True),
(2, 0, 'A2', '发件人公司', True),
(3, 0, 'A8', '收件人姓名', True),
(4, 0, 'A10', '收件人邮编', True),
(5, 0, 'A4', '发件人姓名', True),
(6, 0, 'A3', '发件人地址', True),
(7, 0, 'A9', '收件人电话', True),
(8, 0, 'A12', '代收金额', True),
(9, 0, 'A5', '发件人电话', True),
(10, 0, 'A6', '发件人邮编', True),
(11, 0, 'A7', '收件人地址', True),
(12, 0, 'A11', '货到付款物流编号', True),
(13, 0, 'A13', '备注', True);

-- 
-- Dumping data for table ns_gift_grant_records
--

-- Table `niushop_1.04`.ns_gift_grant_records does not contain any data (it is empty)

-- 
-- Dumping data for table ns_goods
--
INSERT INTO ns_goods VALUES
(239, 'MG小象小清新裙子女夏装2017新款网纱假两件雪纺连衣裙条纹衬衫裙', 0, 314, 311, 313, 314, 0, '108', 0, 0, 1, 176.00, 88.00, 88.00, 176.00, 0, 0, 0, 0, 0.00, 0, 391, 0, 0, 10, 11, 0, 0, 0, 0, 0, 0, 735, '', '假两件的设计充满层次感，外围的薄纱如梦似幻', '<p><img align="absmiddle" src="https://img.alicdn.com/imgextra/i4/479184430/TB2su2XnYFlpuFjy0FgXXbRBVXa_!!479184430.jpg" class="" width="750" height="610" style="font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; border: 0px; vertical-align: top; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i4/479184430/TB2UnO0n9tkpuFjy0FhXXXQzFXa_!!479184430.jpg" class="" width="750" height="358" style="font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; border: 0px; vertical-align: top; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i2/479184430/TB2Wf2xqSFmpuFjSZFrXXayOXXa_!!479184430.jpg" class="" width="750" height="681" style="font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; border: 0px; vertical-align: top;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i1/479184430/TB2tk7wgb_0UKFjy1XaXXbKfXXa_!!479184430.jpg" class="" width="750" height="923" style="font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; border: 0px; vertical-align: top; max-width: 750px;"/></p><p><img src="https://img.alicdn.com/imgextra/i1/479184430/TB2VkKap0BopuFjSZPcXXc9EpXa_!!479184430.png" class="" width="674" height="27" style="border: 0px; vertical-align: middle;"/></p><p><img src="https://img.alicdn.com/imgextra/i1/479184430/TB22lJwnB8lpuFjSspaXXXJKpXa_!!479184430.png" class="" width="674" height="62" style="border: 0px; vertical-align: middle;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i1/479184430/TB2la.mlKtTMeFjSZFOXXaTiVXa_!!479184430.jpg" class="" width="750" height="1358" style="border: 0px; vertical-align: middle; max-width: 750px;"/><a href="https://item.taobao.com/item.htm?spm=0.0.0.0.vab6wI&id=550316002283" target="_blank" style="text-decoration: none; color: rgb(51, 102, 204); outline: 0px;"><img align="absmiddle" src="https://img.alicdn.com/imgextra/i3/479184430/TB25nxcrxtmpuFjSZFqXXbHFpXa_!!479184430.jpg" class="" width="750" height="813" style="border: 0px; vertical-align: middle;"/></a></p><p>&nbsp;</p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img align="absmiddle" src="https://img.alicdn.com/imgextra/i4/479184430/TB2O11Jn3NlpuFjy0FfXXX3CpXa_!!479184430.jpg" class="" width="750" height="940" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i1/479184430/TB2khK0nYtlpuFjSspfXXXLUpXa_!!479184430.jpg" class="" width="750" height="1224" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i1/479184430/TB23nOLn4dkpuFjy0FbXXaNnpXa_!!479184430.jpg" class="" width="750" height="1101" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i1/479184430/TB2FeGNn9hlpuFjSspkXXa1ApXa_!!479184430.jpg" class="" width="750" height="937" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i4/479184430/TB2q9K3n4XkpuFjy0FiXXbUfFXa_!!479184430.jpg" class="" width="750" height="991" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i3/479184430/TB2rpfqnYplpuFjSspiXXcdfFXa_!!479184430.jpg" class="" width="750" height="794" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i2/479184430/TB2ZeW5n3xlpuFjSszgXXcJdpXa_!!479184430.jpg" class="" width="750" height="740" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i2/479184430/TB2yJvdnYtlpuFjSspoXXbcDpXa_!!479184430.jpg" class="" width="750" height="1007" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i4/479184430/TB2d8P3n9FjpuFjSszhXXaBuVXa_!!479184430.jpg" class="" width="750" height="758" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i3/479184430/TB2an19n9xjpuFjSszeXXaeMVXa_!!479184430.jpg" class="" width="750" height="892" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i3/479184430/TB2RtC5n80kpuFjy1zdXXXuUVXa_!!479184430.jpg" class="" width="750" height="1266" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i3/479184430/TB2XzWZnYXlpuFjSszfXXcSGXXa_!!479184430.jpg" class="" width="750" height="1313" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i3/479184430/TB2YmHenYJkpuFjy1zcXXa5FFXa_!!479184430.jpg" class="" width="750" height="767" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i3/479184430/TB2SdvpnYVkpuFjSspcXXbSMVXa_!!479184430.jpg" class="" width="750" height="806" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i4/479184430/TB2A1CRn4XlpuFjSsphXXbJOXXa_!!479184430.jpg" class="" width="750" height="414" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i1/479184430/TB2_tvpnYVkpuFjSspcXXbSMVXa_!!479184430.jpg" class="" width="750" height="423" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i4/479184430/TB2lpLDn88kpuFjSspeXXc7IpXa_!!479184430.jpg" class="" width="750" height="417" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i2/479184430/TB2_VnqnYplpuFjSspiXXcdfFXa_!!479184430.jpg" class="" width="750" height="441" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i3/479184430/TB2HJzpnYVkpuFjSspcXXbSMVXa_!!479184430.jpg" class="" width="750" height="420" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i2/479184430/TB2JLeJn3NlpuFjy0FfXXX3CpXa_!!479184430.jpg" class="" width="750" height="433" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/><img align="absmiddle" src="https://img.alicdn.com/imgextra/i1/479184430/TB2zlY3n9FjpuFjSszhXXaBuVXa_!!479184430.jpg" class="" width="750" height="436" style="border: 0px; vertical-align: top; line-height: 1.5; max-width: 750px;"/></p>', 'upload/goods_qrcode/goods_qrcode_239.png', '', 1, 0, 0, 0, 0, 0, 1, '2017-06-10 15:39:44', '2017-06-10 15:39:44', '2017-06-10 19:24:56', 0, '735,737,738,736', '', NULL, NULL, 11, 28, '[{"spec_name":"颜色分类","spec_id":111,"value":[{"spec_value_name":"蓝色","spec_name":"颜色分类","spec_id":111,"spec_value_id":618,"spec_show_type":3,"spec_value_data":"upload/goods_sku/239/1497080401.jpg"}]},{"spec_name":"尺码","spec_id":110,"value":[{"spec_value_name":"S","spec_name":"尺码","spec_id":110,"spec_value_id":611,"spec_show_type":1,"spec_value_data":""},{"spec_value_name":"M","spec_name":"尺码","spec_id":110,"spec_value_id":612,"spec_show_type":1,"spec_value_data":""}]}]'),
(244, 'Koradior/珂莱蒂尔正品新款韩版夏季碎花修身复古印花网纱连衣裙', 0, 314, 311, 313, 314, 0, '108', 0, 0, 1, 699.00, 699.00, 699.00, 699.00, 0, 0, 0, 0, 0.00, 0, 299, 0, 0, 10, 1, 0, 0, 0, 0, 0, 0, 742, '修身 碎花 短袖 收腰 连衣裙', '修身 碎花 短袖 收腰 连衣裙', '<p><span style="margin: 0px; padding: 0px;"></span></p><ul class="content_kkk list-paddingleft-2" style="list-style-type: none;"><li><p><a href="https://koradior.tmall.com/p/rd713742.htm?spm=a1z10.1-b-s.w5001-14441446041.6.EtB240&scene=taobao_shop" target="_blank" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082370604983.jpg" alt=" 790.jpg" border="0" style="margin: 0px; padding: 0px; border: 0px; vertical-align: middle;"/></a></p></li><li><p><a href="https://koradior.tmall.com/p/rd117672.htm?scene=taobao_shop" target="_blank" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082371135365.jpg" alt=" 790.jpg" usemap="#qipaohaibao" border="0" style="margin: 0px; padding: 0px; border: 0px; vertical-align: middle;"/><map name="qipaohaibao" style="margin: 0px; padding: 0px;"><area coords="22,302,393,408" href="https://taoquan.taobao.com/coupon/unify_apply.htm?sellerId=692195348&activityId=43f2b5eb2d434b0fbd3a4859f24ad011&scene=taobao_shop" target="_blank" style="margin: 0px; padding: 0px; outline: none;"/></map></a></p></li><li><p>&nbsp;</p></li><li><p><br/></p></li></ul><p></p><p><span style="margin: 0px; padding: 0px;text-decoration:line-through;"><strong style="margin: 0px; padding: 0px;"></strong></span></p><p><span style="margin: 0px; padding: 0px;text-decoration:line-through;"><strong style="margin: 0px; padding: 0px;"></strong></span></p><p></p><p><br/><img align="absmiddle" src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082377250014.jpg" class="img-ks-lazyload" style="line-height: 1.4; margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; float: none;"/><img align="absmiddle" src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082377748322.jpg" class="img-ks-lazyload" style="line-height: 1.4; margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; float: none;"/><img align="absmiddle" src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082377138532.jpg" class="img-ks-lazyload" style="line-height: 1.4; margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; float: none;"/><img align="absmiddle" src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082378756283.jpg" class="img-ks-lazyload" style="line-height: 1.4; margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; float: none;"/><img class="desc_anchor img-ks-lazyload" id="desc-module-1" src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082376514272.gif" style="margin: 0px; padding: 0px; border: 0px; height: 1px; display: block; clear: both; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top;"/></p><p><img class="desc_anchor img-ks-lazyload" id="desc-module-2" src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082376514272.gif" style="margin: 0px; padding: 0px; border: 0px; height: 1px; display: block; clear: both; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; line-height: 1.4;"><img align="absmiddle" src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082379469476.jpg" class="img-ks-lazyload" style="margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; float: none;"/><img align="absmiddle" src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082379396279.jpg" class="img-ks-lazyload" style="margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; float: none;"/><img align="absmiddle" src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082380370374.jpg" class="img-ks-lazyload" style="margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; float: none;"/><img align="absmiddle" src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082381738855.jpg" class="img-ks-lazyload" style="margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; float: none;"/><img align="absmiddle" src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082381624950.jpg" class="img-ks-lazyload" style="margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; float: none;"/></p><p><img class="desc_anchor img-ks-lazyload" id="desc-module-3" src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082376514272.gif" style="margin: 0px; padding: 0px; border: 0px; height: 1px; display: block; clear: both; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; line-height: 1.4;"><img align="absmiddle" src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082382963094.jpg" class="img-ks-lazyload" style="margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top; float: none;"/></p><p><img class="desc_anchor img-ks-lazyload" id="desc-module-4" src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082376514272.gif" style="margin: 0px; padding: 0px; border: 0px; height: 1px; display: block; clear: both; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; line-height: 1.4;"></p><p><img width="790" src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082387129839.png" alt="价格说明" style="margin: 0px; padding: 0px; border: 0px; vertical-align: top;"/></p><p><span style="margin: 0px; padding: 0px;text-decoration:line-through;"><strong style="margin: 0px; padding: 0px;"></strong></span></p><p><span style="margin: 0px; padding: 0px;"></span></p><p style="margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.4;"></p><p></p><p><span style="margin: 0px; padding: 0px;text-decoration:line-through;"><strong style="margin: 0px; padding: 0px;"></strong></span></p><p><span style="margin: 0px; padding: 0px;text-decoration:line-through;"><strong style="margin: 0px; padding: 0px;"></strong></span></p><p><span style="margin: 0px; padding: 0px;"></span></p><p><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082388207628.jpg" style="margin: 0px; padding: 0px; border: 0px; vertical-align: middle;"/></p><p></p><p><br/></p>', 'upload/goods_qrcode/goods_qrcode_244.png', '0101010', 1, 0, 0, 0, 0, 0, 1, '2017-06-10 16:14:44', '2017-06-10 16:14:44', NULL, 0, '742', '', NULL, NULL, 1, 28, '[{"spec_name":"尺码","spec_id":110,"value":[{"spec_value_name":"S","spec_name":"尺码","spec_id":110,"spec_value_id":611,"spec_show_type":1,"spec_value_data":""},{"spec_value_name":"M","spec_name":"尺码","spec_id":110,"spec_value_id":612,"spec_show_type":1,"spec_value_data":""},{"spec_value_name":"L","spec_name":"尺码","spec_id":110,"spec_value_id":614,"spec_show_type":1,"spec_value_data":""}]}]'),
(245, 'COCOON/可可尼2017女装夏装新品性感一字肩荷叶袖印花连衣裙', 0, 314, 311, 313, 314, 0, '108', 0, 0, 1, 1600.00, 1600.00, 1600.00, 1600.00, 0, 0, 0, 0, 0.00, 0, 599, 0, 0, 10, 1, 0, 0, 0, 0, 0, 0, 743, '', '唯美印花 性感一字领 个性荷叶边', '<p><span style="margin: 0px; padding: 0px;"></span></p><p style="margin-top: 0px; margin-bottom: 0px; padding: 0px; line-height: 1.4;"><a href="https://cocoon.tmall.com/p/rd210335.htm?spm=a220o.1000855.w5001-14849963586.11.60IwV7&scene=taobao_shop" target="_blank" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082822520684.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a></p><p></p><p><span style="margin: 0px; padding: 0px;text-decoration:line-through;"><strong style="margin: 0px; padding: 0px;"></strong></span></p><p><span style="margin: 0px; padding: 0px;text-decoration:line-through;"><strong style="margin: 0px; padding: 0px;"></strong></span></p><p><span style="margin: 0px; padding: 0px;"></span></p><p><a href="https://taoquan.taobao.com/coupon/unify_apply.htm?sellerId=468333872&activityId=4894b75096214b06b56f33af8c5372ac&scene=taobao_shop" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082822199624.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a><a href="https://taoquan.taobao.com/coupon/unify_apply.htm?sellerId=468333872&activityId=053e5b65df2246c78497b7cef8d5880c&scene=taobao_shop" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082823475974.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a><a href="https://taoquan.taobao.com/coupon/unify_apply.htm?sellerId=468333872&activityId=4adcb7b7e2034d84a11b9b02695e13a0&scene=taobao_shop" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082823542329.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a><a href="https://cocoon.tmall.com/p/rd593187.htm?scene=taobao_shop" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082824767730.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a><a href="https://cocoon.tmall.com/p/rd020700.htm?scene=taobao_shop" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082824419602.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a><a href="https://cocoon.tmall.com/p/rd210335.htm?scene=taobao_shop" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082825131376.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a><a href="https://cocoon.tmall.com/category-305690774.htm?spm=a1z10.5-b-s.w4011-14849963636.4.lFR775&search=y&scene=taobao_shop#TmshopSrchNav" target="_blank" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082825139896.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a><a href="https://cocoon.tmall.com/category-305690770.htm?spm=a1z10.5-b-s.w4010-14849963634.25.ZnJngW&search=y&catName=%C9%CF%D2%C2&scene=taobao_shop#bd" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082826134297.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a><a href="https://cocoon.tmall.com/category-305690772.htm?spm=a1z10.5-b-s.w4010-14849963634.33.9eF7Qu&search=y&catName=%D5%EB%D6%AF%C9%C0&scene=taobao_shop#bd" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082826716694.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a><a href="https://cocoon.tmall.com/category-305690769.htm?spm=a1z10.5-b-s.w4010-14849963634.36.mF3YSt&search=y&catName=%CD%E2%CC%D7&scene=taobao_shop#bd" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082827833310.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a><a href="https://cocoon.tmall.com/category-305690775.htm?spm=a1z10.5-b-s.w4010-14849963634.53.sBahoi&search=y&catName=%B0%EB%C9%ED%C8%B9&scene=taobao_shop#bd" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082827104838.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a><a href="https://cocoon.tmall.com/category-305690776.htm?spm=a1z10.5-b-s.w4010-14849963634.46.5TUJ9L&search=y&catName=%BF%E3%D7%B0&scene=taobao_shop#bd" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082827137843.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a><a href="https://detail.tmall.com/item.htm?id=546248160427&scene=taobao_shop" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082828738382.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a><a href="https://detail.tmall.com/item.htm?spm=a1z10.1-b-s.w5003-16278381321.8.r0yt4P&id=546290242776&scene=taobao_shop" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082829819196.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a><a href="https://detail.tmall.com/item.htm?spm=a1z10.1-b-s.w5003-16278381321.15.1YeFbh&id=546411680844&scene=taobao_shop" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082829951432.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a><a href="https://detail.tmall.com/item.htm?spm=a1z10.1-b-s.w5003-16278381321.2.r0yt4P&id=545229314759&scene=taobao_shop" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082829521588.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a><a href="https://detail.tmall.com/item.htm?spm=a220o.1000855.w5003-16148622147.17.xI9pp1&id=529101771694&rn=1bdf4e9551b25565b5a80b8236649c35&abbucket=3&scene=taobao_shop" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082830132150.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a><a href="https://detail.tmall.com/item.htm?id=545229186856&scene=taobao_shop" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082830114658.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a><a href="https://detail.tmall.com/item.htm?id=545194660752&scene=taobao_shop" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082831115785.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a><a href="https://detail.tmall.com/item.htm?id=542500807918&scene=taobao_shop" style="margin: 0px; padding: 0px; text-decoration: none; color: rgb(41, 83, 166); outline: 0px;"><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082832124004.jpg" style="margin: 0px; padding: 0px; border: 0px none; border-collapse: collapse; vertical-align: middle;"/></a></p><p></p><p><span style="margin: 0px; padding: 0px;text-decoration:line-through;"><strong style="margin: 0px; padding: 0px;"></strong></span></p><p><img class="desc_anchor img-ks-lazyload" id="desc-module-1" src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082832136561.gif" style="margin: 0px; padding: 0px; border: 0px; height: 1px; display: block; clear: both; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top;"/></p><p><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082833528860.jpg" class="img-ks-lazyload" style="margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top;"/></p><p><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082833106387.jpg" class="img-ks-lazyload" style="margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top;"/></p><p><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082834361165.jpg" class="img-ks-lazyload" style="margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top;"/></p><p><img class="desc_anchor img-ks-lazyload" id="desc-module-2" src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082832136561.gif" style="margin: 0px; padding: 0px; border: 0px; height: 1px; display: block; clear: both; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top;"/></p><p><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082835572322.jpg" class="img-ks-lazyload" style="margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top;"/></p><p><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082835870748.jpg" class="img-ks-lazyload" style="margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top;"/></p><p><img class="desc_anchor img-ks-lazyload" id="desc-module-3" src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082832136561.gif" style="margin: 0px; padding: 0px; border: 0px; height: 1px; display: block; clear: both; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top;"/></p><p><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082836891231.jpg" class="img-ks-lazyload" style="margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top;"/></p><p><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082837652576.jpg" class="img-ks-lazyload" style="margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top;"/></p><p><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082838225959.jpg" class="img-ks-lazyload" style="margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top;"/></p><p><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082838861711.jpg" class="img-ks-lazyload" style="margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top;"/></p><p><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082839129848.jpg" class="img-ks-lazyload" style="margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top;"/></p><p><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082840230865.jpg" class="img-ks-lazyload" style="margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top;"/></p><p><img src="/niushop_b2c/upload/ueditor/php/upload/image/20170610/1497082840187059.jpg" class="img-ks-lazyload" style="margin: 0px; padding: 0px; border: 0px; animation: ks-fadeIn 350ms linear 0ms 1 normal both; opacity: 1; vertical-align: top;"/></p><p><br/></p>', 'upload/goods_qrcode/goods_qrcode_245.png', '0202', 1, 0, 1, 1, 0, 0, 1, '2017-06-10 16:22:28', '2017-06-10 16:22:28', NULL, 0, '743', '', NULL, NULL, 1, 28, '[{"spec_name":"尺码","spec_id":110,"value":[{"spec_value_name":"S","spec_name":"尺码","spec_id":110,"spec_value_id":611,"spec_show_type":1,"spec_value_data":""},{"spec_value_name":"M","spec_name":"尺码","spec_id":110,"spec_value_id":612,"spec_show_type":1,"spec_value_data":""},{"spec_value_name":"L","spec_name":"尺码","spec_id":110,"spec_value_id":614,"spec_show_type":1,"spec_value_data":""}]},{"spec_name":"颜色分类","spec_id":111,"value":[{"spec_value_name":"蓝色","spec_name":"颜色分类","spec_id":111,"spec_value_id":618,"spec_show_type":3,"spec_value_data":"upload/goods_sku/0/1497082898.jpg"},{"spec_value_name":"红色","spec_name":"颜色分类","spec_id":111,"spec_value_id":613,"spec_show_type":3,"spec_value_data":"upload/goods_sku/0/1497082895.jpg"}]}]'),
(259, '女士夏装胖MM加肥加大中长款连衣裙宽松大码无袖背心裙孕妇打底裙', 0, 314, 311, 313, 314, 0, '108,107', 0, 0, 1, 69.00, 25.90, 25.90, 5.00, 0, 0, 0, 0, 0.00, 0, 1000, 0, 10, 10, 10, 0, 0, 0, 10, 0, 0, 744, '夏', '女士夏装胖MM加肥加大中长款连衣裙宽松大码无袖背心裙孕妇打底裙', '<p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img src="https://img.alicdn.com/imgextra/i3/2002910652/TB2vX7LfdFopuFjSZFHXXbSlXXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="460" style="border: 0px; vertical-align: top; max-width: 750px;"/><img src="https://img.alicdn.com/imgextra/i4/2002910652/TB2r8mWX1tTMeFjSZFOXXaTiVXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="1125" style="border: 0px; vertical-align: top; max-width: 750px;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);">&nbsp;</p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img src="https://img.alicdn.com/imgextra/i3/2002910652/TB2VvI7el8lpuFjy0FnXXcZyXXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="1125" style="border: 0px; vertical-align: top; max-width: 750px;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);">&nbsp;</p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img src="https://img.alicdn.com/imgextra/i2/2002910652/TB2bE7YebtlpuFjSspoXXbcDpXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="750" style="border: 0px; vertical-align: top; max-width: 750px;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);">&nbsp;</p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img src="https://img.alicdn.com/imgextra/i3/2002910652/TB2XboNfipnpuFjSZFIXXXh2VXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="750" style="border: 0px; vertical-align: top; max-width: 750px;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);">&nbsp;</p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img src="https://img.alicdn.com/imgextra/i2/2002910652/TB2iekGelNkpuFjy0FaXXbRCVXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="750" style="border: 0px; vertical-align: top; max-width: 750px;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);">&nbsp;</p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img src="https://img.alicdn.com/imgextra/i3/2002910652/TB2iucSegxlpuFjSszgXXcJdpXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="750" style="border: 0px; vertical-align: top; max-width: 750px;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);">&nbsp;</p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img src="https://img.alicdn.com/imgextra/i4/2002910652/TB2vqsPfodnpuFjSZPhXXbChpXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="1125" style="border: 0px; vertical-align: top; max-width: 750px;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);">&nbsp;</p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img src="https://img.alicdn.com/imgextra/i3/2002910652/TB2NpgUfipnpuFjSZFkXXc4ZpXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="750" style="border: 0px; vertical-align: top; max-width: 750px;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);">&nbsp;</p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img src="https://img.alicdn.com/imgextra/i4/2002910652/TB2iPAUfm8mpuFjSZFMXXaxpVXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="1125" style="border: 0px; vertical-align: top; max-width: 750px;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);">&nbsp;</p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img src="https://img.alicdn.com/imgextra/i2/2002910652/TB26lIKemhlpuFjSspkXXa1ApXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="750" style="border: 0px; vertical-align: top; max-width: 750px;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);">&nbsp;</p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img src="https://img.alicdn.com/imgextra/i3/2002910652/TB2gm79ebFkpuFjy1XcXXclapXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="1125" style="border: 0px; vertical-align: top; max-width: 750px;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);">&nbsp;</p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img src="https://img.alicdn.com/imgextra/i4/2002910652/TB25XAIfohnpuFjSZFpXXcpuXXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="750" style="border: 0px; vertical-align: top; max-width: 750px;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);">&nbsp;</p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img src="https://img.alicdn.com/imgextra/i2/2002910652/TB2xFo4emFjpuFjSspbXXXagVXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="750" style="border: 0px; vertical-align: top; max-width: 750px;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);">&nbsp;</p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img src="https://img.alicdn.com/imgextra/i3/2002910652/TB2T237el8kpuFjSspeXXc7IpXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="750" style="border: 0px; vertical-align: top; max-width: 750px;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);">&nbsp;</p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img src="https://img.alicdn.com/imgextra/i4/2002910652/TB2zTc9ebFkpuFjy1XcXXclapXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="750" style="border: 0px; vertical-align: top; max-width: 750px;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);">&nbsp;</p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img src="https://img.alicdn.com/imgextra/i4/2002910652/TB2slQUfm8mpuFjSZFMXXaxpVXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="750" style="border: 0px; vertical-align: top; max-width: 750px;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);">&nbsp;</p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img src="https://img.alicdn.com/imgextra/i2/2002910652/TB2uP3JeeJ8puFjy1XbXXagqVXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="469" style="border: 0px; vertical-align: top; max-width: 750px;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);">&nbsp;</p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img src="https://img.alicdn.com/imgextra/i4/2002910652/TB2WQkUfm8mpuFjSZFMXXaxpVXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="469" style="border: 0px; vertical-align: top; max-width: 750px;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);">&nbsp;</p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img src="https://img.alicdn.com/imgextra/i2/2002910652/TB20R3QfhhmpuFjSZFyXXcLdFXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="469" style="border: 0px; vertical-align: top; max-width: 750px;"/></p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);">&nbsp;</p><p style="margin-top: 1.12em; margin-bottom: 1.12em; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; line-height: 21px; white-space: normal; background-color: rgb(255, 255, 255);"><img src="https://img.alicdn.com/imgextra/i2/2002910652/TB2Re2bXhRDOuFjSZFzXXcIipXa_!!2002910652.jpg" class="" align="absmiddle" width="750" height="469" style="border: 0px; vertical-align: top; max-width: 750px;"/></p><p><br/></p>', 'upload/goods_qrcode/goods_qrcode_259.png', '10001', 1, 0, 0, 0, 0, 0, 1, '2017-06-10 22:21:50', '2017-06-10 22:21:50', NULL, 0, '744,745', '', NULL, NULL, 0, 28, '[]');

-- 
-- Dumping data for table ns_goods_attribute
--
INSERT INTO ns_goods_attribute VALUES
(283, 244, 0, 74, '风格', '通勤', 0, '2017-06-10 16:14:45'),
(284, 244, 0, 76, '裙长', '中长裙', 0, '2017-06-10 16:14:45'),
(285, 244, 0, 77, '款式', '其他/other', 0, '2017-06-10 16:14:45'),
(286, 244, 0, 75, '通勤', ' 韩版', 0, '2017-06-10 16:14:45'),
(287, 245, 0, 74, '风格', '通勤', 0, '2017-06-10 16:22:29'),
(288, 245, 0, 76, '裙长', '短裙', 0, '2017-06-10 16:22:29'),
(289, 245, 0, 77, '款式', '其他/other', 0, '2017-06-10 16:22:29'),
(290, 245, 0, 75, '通勤', ' 韩版', 0, '2017-06-10 16:22:29'),
(291, 239, 0, 74, '风格', '街头', 0, '2017-06-10 19:24:56'),
(292, 239, 0, 76, '裙长', '中裙', 0, '2017-06-10 19:24:56'),
(293, 239, 0, 77, '款式', '欧美', 0, '2017-06-10 19:24:56'),
(294, 239, 0, 75, '通勤', ' 韩版', 0, '2017-06-10 19:24:56'),
(343, 259, 0, 74, '风格', '无袖背心裙', 0, '2017-06-10 22:21:50'),
(344, 259, 0, 76, '裙长', '长裙', 0, '2017-06-10 22:21:50'),
(345, 259, 0, 77, '款式', '其他/other', 0, '2017-06-10 22:21:50'),
(346, 259, 0, 75, '通勤', '中国风版', 0, '2017-06-10 22:21:50');

-- 
-- Dumping data for table ns_goods_attribute_deleted
--

-- Table `niushop_1.04`.ns_goods_attribute_deleted does not contain any data (it is empty)

-- 
-- Dumping data for table ns_goods_attribute_value
--
INSERT INTO ns_goods_attribute_value VALUES
(39, 1, '121', True, 0, '2016-11-22 04:58:51'),
(40, 36, '黑色', True, 0, '2016-11-22 05:19:10'),
(41, 36, '棕黄色', True, 0, '2016-11-22 05:19:18'),
(42, 37, '37', True, 0, '2016-11-22 05:19:28'),
(43, 37, '38', True, 0, '2016-11-22 05:19:30'),
(44, 37, '39', True, 0, '2016-11-22 05:19:35'),
(45, 37, '40', True, 0, '2016-11-22 05:19:36'),
(46, 37, '41', True, 0, '2016-11-22 05:19:37'),
(47, 37, '42', True, 0, '2016-11-22 05:19:39'),
(48, 37, '43', True, 0, '2016-11-22 05:19:42'),
(49, 38, '青年款', True, 0, '2016-11-22 05:20:08'),
(50, 38, '老年款', True, 0, '2016-11-22 05:20:13'),
(51, 36, '1121', True, 0, '2016-11-22 05:53:41'),
(52, 37, '11', True, 0, '2016-11-22 05:55:04'),
(53, 36, '蓝色', True, 0, '2016-11-22 06:00:20'),
(54, 36, '12', True, 0, '2016-11-22 06:02:21'),
(55, 36, '23', True, 0, '2016-11-22 06:02:23'),
(56, 36, '12121', True, 0, '2016-11-23 11:07:33'),
(57, 36, '5151', True, 0, '2016-11-23 11:14:18'),
(58, 37, '2121', True, 0, '2016-11-23 11:15:15'),
(59, 36, '1212', True, 0, '2016-11-23 11:19:30'),
(60, 36, '1', True, 0, '2016-11-23 11:29:21'),
(61, 36, '121', True, 0, '2016-11-23 12:07:07'),
(62, 36, '10', True, 0, '2016-11-23 12:20:19'),
(63, 36, '11', True, 0, '2016-11-23 02:34:11'),
(64, 37, '111', True, 0, '2016-11-23 02:39:23'),
(65, 36, '41', True, 0, '2016-11-23 02:58:42'),
(66, 36, '44', True, 0, '2016-11-23 03:00:49'),
(67, 36, '59', True, 0, '2016-11-23 03:03:12'),
(68, 37, '51', True, 0, '2016-11-23 03:09:45'),
(69, 37, '10', True, 0, '2016-11-23 03:17:30'),
(70, 37, '25', True, 0, '2016-11-23 03:18:44'),
(71, 36, '红色', True, 0, '2016-11-23 06:10:34'),
(72, 36, '4141', True, 0, '2016-11-23 06:21:58'),
(73, 36, '145151', True, 0, '2016-11-23 06:22:52'),
(74, 36, '白色', True, 0, '2016-11-23 06:25:23'),
(75, 36, '110', True, 0, '2016-11-24 10:00:22'),
(76, 37, '111222', True, 0, '2016-11-24 10:00:57'),
(77, 36, '测试', True, 0, '2016-11-24 02:20:31'),
(78, 36, '22', True, 0, '2016-11-25 01:46:20'),
(79, 36, '111', True, 0, '2016-11-25 01:59:29'),
(80, 37, '1', True, 0, '2016-11-25 02:01:42'),
(81, 37, '22', True, 0, '2016-11-25 02:02:00'),
(82, 36, '2', True, 0, '2016-11-25 02:11:00'),
(83, 36, '3', True, 0, '2016-11-25 02:19:47'),
(84, 36, '4', True, 0, '2016-11-25 02:19:50'),
(85, 36, '5', True, 0, '2016-11-25 02:19:58'),
(86, 36, '6', True, 0, '2016-11-25 02:20:02'),
(87, 36, '7', True, 0, '2016-11-25 02:20:05'),
(88, 36, '8', True, 0, '2016-11-25 02:20:07'),
(89, 36, '9', True, 0, '2016-11-25 02:39:27'),
(90, 36, '13', True, 0, '2016-11-25 02:40:19'),
(91, 36, '33', True, 0, '2016-11-25 04:31:14'),
(92, 37, '2', True, 0, '2016-11-25 05:23:09'),
(93, 37, '44', True, 0, '2016-11-25 05:34:19'),
(94, 36, '34', True, 0, '2016-11-25 05:43:15'),
(95, 37, '3', True, 0, '2016-11-28 09:27:40'),
(96, 36, '65', True, 0, '2016-11-28 09:43:25'),
(97, 36, '22233', True, 0, '2016-11-28 10:01:33'),
(98, 37, '5', True, 0, '2016-11-28 10:30:59'),
(99, 37, '12', True, 0, '2016-11-28 10:32:49'),
(100, 36, '521', True, 0, '2016-11-28 10:32:58'),
(101, 38, '9999', True, 0, '2016-11-28 10:40:53'),
(102, 38, '1515', True, 0, '2016-11-28 10:40:55'),
(103, 36, '123', True, 0, '2016-11-28 11:01:55'),
(104, 37, '56', True, 0, '2016-11-28 11:12:56'),
(105, 37, '4', True, 0, '2016-11-28 11:16:23'),
(106, 37, '323', True, 0, '2016-11-28 11:17:26'),
(107, 37, '16', True, 0, '2016-11-28 11:17:33'),
(108, 36, '55', True, 0, '2016-11-28 11:21:59'),
(109, 37, '99', True, 0, '2016-11-28 11:23:12'),
(110, 37, '6', True, 0, '2016-11-28 11:29:03'),
(111, 37, '46', True, 0, '2016-11-28 03:28:14'),
(112, 36, 'oo', True, 0, '2016-11-28 05:05:38'),
(113, 36, '36', True, 0, '2016-11-28 05:13:56'),
(114, 38, '少年款', True, 0, '2016-11-28 05:24:54'),
(115, 36, 'dghdf', True, 0, '2016-11-30 02:05:39'),
(116, 36, '相册GV', True, 0, '2016-11-30 02:08:46'),
(117, 36, 'dfgdf', True, 0, '2016-11-30 02:08:55'),
(118, 36, '颜色', True, 0, '2016-11-30 03:44:30'),
(119, 36, '31', True, 0, '2016-11-30 03:46:22'),
(120, 36, '13啊', True, 0, '2016-11-30 03:47:11'),
(121, 37, '15', True, 0, '2016-12-01 11:40:20'),
(122, 38, '4', True, 0, '2016-12-01 11:50:10'),
(123, 38, '3', True, 0, '2016-12-01 11:52:09'),
(124, 37, '17', True, 0, '2016-12-01 11:53:18'),
(125, 38, 'GEEK', True, 0, '2016-12-01 11:53:36'),
(126, 38, 'Android', True, 0, '2016-12-01 11:53:40'),
(127, 36, 'red', True, 0, '2016-12-01 11:55:14'),
(128, 36, 'blue', True, 0, '2016-12-01 11:55:15'),
(129, 36, 'black', True, 0, '2016-12-01 11:55:17'),
(130, 36, 'yellow', True, 0, '2016-12-01 11:55:18'),
(131, 38, '男款', True, 0, '2016-12-01 11:58:36'),
(132, 38, '女款', True, 0, '2016-12-01 11:58:38'),
(133, 37, '496', True, 0, '2016-12-01 12:17:32'),
(134, 37, '8', True, 0, '2016-12-01 12:21:52'),
(135, 37, '14', True, 0, '2016-12-01 12:23:11'),
(136, 38, 'ggg', True, 0, '2016-12-01 12:24:41'),
(137, 38, '7', True, 0, '2016-12-02 01:27:04'),
(138, 38, '8', True, 0, '2016-12-02 01:27:04'),
(139, 38, '9', True, 0, '2016-12-02 01:27:05'),
(140, 37, '36', True, 0, '2016-12-02 04:22:39'),
(141, 36, '14', True, 0, '2016-12-02 04:25:25'),
(142, 36, '122', True, 0, '2016-12-02 04:58:09'),
(143, 38, '55', True, 0, '2016-12-02 04:59:22'),
(144, 36, '124', True, 0, '2016-12-05 10:02:36'),
(145, 36, '00', True, 0, '2017-02-07 02:10:54'),
(146, 36, '888', True, 0, '2017-02-07 02:11:09'),
(147, 37, '888', True, 0, '2017-02-07 02:11:19'),
(148, 37, '4545', True, 0, '2017-02-07 02:11:22'),
(149, 36, '红', True, 0, '2017-02-10 05:27:33'),
(150, 36, '蓝', True, 0, '2017-02-10 05:27:36'),
(151, 36, '白', True, 0, '2017-02-10 05:27:39'),
(152, 40, 'PHP学习手册', True, 0, '2017-02-16 03:49:42'),
(153, 40, 'PHP设计模式', True, 0, '2017-02-16 03:49:48'),
(154, 40, 'PHP经典示例', True, 0, '2017-02-16 03:49:57'),
(155, 37, '24K', True, 0, '2017-02-20 10:28:52'),
(156, 37, '25K', True, 0, '2017-02-20 10:29:02'),
(157, 37, '26K', True, 0, '2017-02-20 10:29:05'),
(158, 38, '迷香', True, 0, '2017-02-20 05:02:48'),
(159, 37, '大的', True, 0, '2017-02-20 05:05:15'),
(160, 38, '花语', True, 0, '2017-02-20 05:02:55'),
(161, 37, '小的', True, 0, '2017-02-20 05:05:22'),
(162, 38, '田园', True, 0, '2017-02-20 05:03:00'),
(163, 37, '中等', True, 0, '2017-02-20 05:05:35'),
(164, 38, '少女', True, 0, '2017-02-20 05:05:52'),
(165, 38, '润唇膏/啫喱', True, 0, '2017-02-20 05:08:51'),
(166, 37, '180ml', True, 0, '2017-02-20 05:18:25'),
(167, 37, '120ml', True, 0, '2017-02-20 05:18:35'),
(168, 37, '440g', True, 0, '2017-02-20 05:28:48'),
(169, 37, '200g', True, 0, '2017-02-20 05:28:54'),
(170, 36, '粉色', True, 0, '2017-02-20 05:32:50'),
(171, 37, '小瓶', True, 0, '2017-02-20 05:33:00'),
(172, 37, '大瓶', True, 0, '2017-02-20 05:33:07'),
(173, 37, '15g', True, 0, '2017-02-20 05:38:02'),
(174, 37, '20g', True, 0, '2017-02-20 05:38:05'),
(175, 38, '150ml', True, 0, '2017-02-20 05:44:02'),
(176, 38, '100ml', True, 0, '2017-02-20 05:44:07'),
(177, 38, '135ml', True, 0, '2017-02-20 05:44:16'),
(178, 36, '乳白色', True, 0, '2017-02-20 05:44:54'),
(179, 38, '1号', True, 0, '2017-02-20 05:51:12'),
(180, 38, '3号', True, 0, '2017-02-20 05:51:15'),
(181, 37, '600ml', True, 0, '2017-02-20 05:55:24'),
(182, 37, '400ml', True, 0, '2017-02-20 05:55:28'),
(183, 36, '粉红', True, 0, '2017-02-20 05:56:09'),
(184, 36, '红蓝相间', True, 0, '2017-02-20 06:00:07'),
(185, 36, '纯白', True, 0, '2017-02-20 06:00:17'),
(186, 37, '4g', True, 0, '2017-02-20 06:07:06'),
(187, 37, '6g', True, 0, '2017-02-20 06:07:09'),
(188, 37, '3g', True, 0, '2017-02-20 06:07:13'),
(189, 36, '绿色', True, 0, '2017-02-20 06:15:13'),
(190, 37, '12包', True, 0, '2017-02-20 06:20:23'),
(191, 37, '19包', True, 0, '2017-02-20 06:20:29'),
(192, 37, '10包', True, 0, '2017-02-20 06:20:34'),
(193, 37, '20包', True, 0, '2017-02-20 06:26:55'),
(194, 37, '15包', True, 0, '2017-02-20 06:27:00'),
(195, 36, '天蓝色', True, 0, '2017-02-20 06:27:28'),
(196, 37, '20斤', True, 0, '2017-02-20 06:34:47'),
(197, 37, '15斤', True, 0, '2017-02-20 06:34:52'),
(198, 37, '10斤', True, 0, '2017-02-20 06:34:55'),
(199, 37, '12包装', True, 0, '2017-02-20 06:42:39'),
(200, 37, '10包装', True, 0, '2017-02-20 06:42:53'),
(201, 37, '100g', True, 0, '2017-02-20 06:48:55'),
(202, 37, '3kg', True, 0, '2017-02-20 06:57:31'),
(203, 37, '3kg+3kg', True, 0, '2017-02-20 06:57:39'),
(204, 37, '3kg+500g', True, 0, '2017-02-20 06:57:57'),
(205, 37, '大号', True, 0, '2017-02-20 07:03:00'),
(206, 37, '小号', True, 0, '2017-02-20 07:03:03'),
(207, 37, '中号‘’', True, 0, '2017-02-20 07:03:06'),
(208, 36, '花色', True, 0, '2017-02-20 07:43:09'),
(209, 37, '1.8米', True, 0, '2017-02-20 07:55:10'),
(210, 36, '亮白色', True, 0, '2017-02-20 07:55:17'),
(211, 36, '奶绿色', True, 0, '2017-02-20 07:55:33'),
(212, 37, '三斤', True, 0, '2017-02-20 07:57:52'),
(213, 37, '四斤', True, 0, '2017-02-20 07:57:57'),
(214, 36, '雅黑', True, 0, '2017-02-20 08:00:26'),
(215, 36, '雅灰', True, 0, '2017-02-20 08:00:36'),
(216, 36, '灰色‘’', True, 0, '2017-02-20 08:03:11'),
(217, 36, '灰色', True, 0, '2017-02-20 08:03:34'),
(218, 36, '玫瑰金', True, 0, '2017-02-20 08:01:28'),
(219, 37, '50*30*10', True, 0, '2017-02-20 08:06:17'),
(220, 37, '50*27*10', True, 0, '2017-02-20 08:06:26'),
(221, 36, '棕色‘’', True, 0, '2017-02-20 08:09:14'),
(222, 37, '128GB', True, 0, '2017-02-20 08:10:45'),
(223, 37, '64Gb', True, 0, '2017-02-20 08:10:52'),
(224, 37, '32GB', True, 0, '2017-02-20 08:11:07'),
(225, 36, '银色', True, 0, '2017-02-20 08:13:41'),
(226, 36, '珠光白', True, 0, '2017-02-20 08:17:18'),
(227, 36, '金色', True, 0, '2017-02-20 08:22:54'),
(228, 36, '玫瑰金色', True, 0, '2017-02-20 08:23:06'),
(229, 36, '刘金光', True, 0, '2017-02-20 08:27:25'),
(230, 36, '流金光', True, 0, '2017-02-20 08:27:45'),
(231, 36, '粉红色', True, 0, '2017-02-20 08:30:22'),
(232, 37, '60英寸', True, 0, '2017-02-20 08:38:32'),
(233, 36, '玫瑰色‘’', True, 0, '2017-02-20 08:45:24'),
(234, 36, '无线黑色', True, 0, '2017-02-20 08:46:14'),
(235, 38, '1000转', True, 0, '2017-02-20 08:49:11'),
(236, 38, '1200转', True, 0, '2017-02-20 08:49:14'),
(237, 37, '55英寸', True, 0, '2017-02-20 08:51:27'),
(238, 37, '45英寸', True, 0, '2017-02-20 08:51:35'),
(239, 37, '50英寸', True, 0, '2017-02-20 08:51:43'),
(240, 36, '灰白', True, 0, '2017-02-20 08:55:13'),
(241, 37, '20英寸', True, 0, '2017-02-20 08:58:50'),
(242, 37, '21英寸', True, 0, '2017-02-20 08:58:53'),
(243, 37, '23英寸‘’', True, 0, '2017-02-20 08:58:57'),
(244, 37, '23英寸', True, 0, '2017-02-20 08:59:06'),
(245, 37, '1L*6盒', True, 0, '2017-02-21 09:26:37'),
(246, 38, '果干类', True, 0, '2017-02-21 09:34:24'),
(247, 38, '软糖', True, 0, '2017-02-21 09:39:17'),
(248, 36, '橘红色', True, 0, '2017-02-21 09:44:52'),
(249, 36, '深红色', True, 0, '2017-02-21 09:45:06'),
(250, 38, '袋装', True, 0, '2017-02-21 09:47:04'),
(251, 41, '2支装', True, 0, '2017-02-21 09:49:23'),
(252, 41, '6支装', True, 0, '2017-02-21 09:49:31'),
(253, 36, '橘色', True, 0, '2017-02-21 09:53:19'),
(254, 38, '水果味', True, 0, '2017-02-21 09:52:22'),
(255, 38, '蒙自石榴', True, 0, '2017-02-21 09:57:43'),
(256, 38, '鳕鱼', True, 0, '2017-02-21 10:01:24'),
(257, 38, '金枕', True, 0, '2017-02-21 10:10:41'),
(258, 38, '单品', True, 0, '2017-02-21 10:17:00'),
(259, 38, '猫山王', True, 0, '2017-02-21 10:20:32'),
(260, 38, '火龙果', True, 0, '2017-02-21 10:26:36'),
(261, 36, '红黑相间', True, 0, '2017-02-21 10:28:18'),
(262, 36, '多功能破壁机', True, 0, '2017-02-21 10:46:45'),
(263, 36, '智能加热破壁机', True, 0, '2017-02-21 10:46:58'),
(264, 42, '优惠套装一', True, 0, '2017-02-21 10:50:28'),
(265, 42, '优惠套装二', True, 0, '2017-02-21 10:50:39'),
(266, 36, '黄色', True, 0, '2017-02-21 10:54:14'),
(267, 36, '橙色', True, 0, '2017-02-21 11:00:24'),
(268, 36, '卡通小树', True, 0, '2017-02-21 11:20:55'),
(269, 36, '树熊宝宝', True, 0, '2017-02-21 11:21:03'),
(270, 36, '布偶印记', True, 0, '2017-02-21 11:21:20'),
(271, 36, '嘟嘟小熊', True, 0, '2017-02-21 11:21:26'),
(272, 36, '希腊爬藤', True, 0, '2017-02-21 11:21:42'),
(273, 36, '紫色', True, 0, '2017-02-21 11:25:45'),
(274, 36, '咖啡色', True, 0, '2017-02-21 11:30:28'),
(275, 37, '1.8米床', True, 0, '2017-02-21 11:56:38'),
(276, 37, '1.5米床', True, 0, '2017-02-21 11:56:56'),
(277, 37, '五斤', True, 0, '2017-02-21 12:00:53'),
(278, 37, '六斤', True, 0, '2017-02-21 12:00:59'),
(279, 37, '七斤', True, 0, '2017-02-21 12:01:03'),
(280, 36, '苏菲花园', True, 0, '2017-02-21 12:06:28'),
(281, 36, '北欧风尚', True, 0, '2017-02-21 12:06:37'),
(282, 36, '简单爱', True, 0, '2017-02-21 12:07:11'),
(283, 36, '初雪', True, 0, '2017-02-21 12:07:16'),
(284, 36, '橘红', True, 0, '2017-02-21 12:13:58'),
(285, 36, '天蓝', True, 0, '2017-02-21 12:14:14'),
(286, 36, '黑白相间', True, 0, '2017-02-21 12:24:11'),
(287, 36, '灰黑', True, 0, '2017-02-21 12:24:35'),
(288, 38, '即食海参', True, 0, '2017-02-21 01:40:20'),
(289, 38, '腌制水产', True, 0, '2017-02-21 01:43:05'),
(290, 38, '盐焗口味', True, 0, '2017-02-21 01:47:59'),
(291, 38, '鲜花饼', True, 0, '2017-02-21 01:51:59'),
(292, 38, '苦荞茶', True, 0, '2017-02-21 01:57:12'),
(293, 38, '菩提心', True, 0, '2017-02-21 01:59:06'),
(294, 38, '冷冻水产', True, 0, '2017-02-21 02:01:58'),
(295, 36, '酒红色', True, 0, '2017-02-21 02:03:19'),
(296, 38, '均码', True, 0, '2017-02-21 02:05:00'),
(297, 36, '卡其', True, 0, '2017-02-21 02:18:04'),
(298, 37, 's', True, 0, '2017-02-21 02:21:07'),
(299, 37, 'l', True, 0, '2017-02-21 02:21:10'),
(300, 37, 'm', True, 0, '2017-02-21 02:21:13'),
(301, 37, 'XL', True, 0, '2017-02-21 02:40:32'),
(302, 36, '墨绿', True, 0, '2017-02-21 02:44:28'),
(303, 36, '64G', True, 0, '2017-02-21 03:26:02'),
(304, 36, '128G', True, 0, '2017-02-21 03:26:05'),
(305, 37, '64G', True, 0, '2017-02-21 03:26:33'),
(306, 37, '128G', True, 0, '2017-02-21 03:26:38'),
(307, 43, '55', True, 0, '2017-03-02 17:00:35'),
(308, 43, '44', True, 0, '2017-03-02 17:00:38'),
(309, 43, '43', True, 0, '2017-03-02 17:00:39'),
(310, 43, '42', True, 0, '2017-03-02 17:00:41'),
(311, 43, '41', True, 0, '2017-03-02 17:00:42'),
(312, 37, '45', True, 0, '2017-03-02 17:03:25'),
(313, 38, '多门式', True, 0, '2017-05-02 19:00:00'),
(314, 38, '多门', True, 0, '2017-05-02 19:05:05'),
(315, 36, '卡其色', True, 0, '2017-05-02 19:17:27'),
(316, 38, '鲜奶水果蛋糕', True, 0, '2017-05-03 18:19:35');

-- 
-- Dumping data for table ns_goods_brand
--
INSERT INTO ns_goods_brand VALUES
(38, 0, '爱马仕', 'A', 'upload/goods_brand/1497084737.jpg', 1, 1, '', '', 'upload/goods_brand/1497084740.jpg', '鞋靴/箱包/配件', 312, -1, -1);

-- 
-- Dumping data for table ns_goods_category
--
INSERT INTO ns_goods_category VALUES
(311, '女装/男装/内衣', '女装', 0, 1, 1, 0, '', '衣服', '', 0, ''),
(312, '鞋靴/箱包/配件', '配饰', 0, 1, 1, 0, '', '鞋靴/箱包/配件', '', 1, ''),
(313, '女装', '女装', 311, 2, 1, 0, '', '女装', '', 0, ''),
(314, '连衣裙', '连衣裙', 313, 3, 1, 28, '连衣裙', '连衣裙', '', 0, 'upload/goods_category/1497086116.jpg');

-- 
-- Dumping data for table ns_goods_deleted
--

-- Table `niushop_1.04`.ns_goods_deleted does not contain any data (it is empty)

-- 
-- Dumping data for table ns_goods_evaluate
--

-- Table `niushop_1.04`.ns_goods_evaluate does not contain any data (it is empty)

-- 
-- Dumping data for table ns_goods_group
--
INSERT INTO ns_goods_group VALUES
(107, 0, '女装', 0, 1, 1, '', 0),
(108, 0, '连衣裙', 107, 2, 1, '', 0);

-- 
-- Dumping data for table ns_goods_sku
--
INSERT INTO ns_goods_sku VALUES
(1063, 239, '蓝色 S ', '111:618;110:611', '111:618;110:611', 176.00, 88.00, 88.00, 176.00, 198, 0, '', '', '2017-06-10 15:40:30', '2017-06-10 19:24:56'),
(1064, 239, '蓝色 M ', '111:618;110:612', '111:618;110:612', 180.00, 99.00, 99.00, 180.00, 196, 0, '', '', '2017-06-10 15:47:55', '2017-06-10 19:24:56'),
(1069, 244, 'S ', '110:611', '110:611', 699.00, 699.00, 699.00, 699.00, 99, 0, '010101', '', '2017-06-10 16:14:44', NULL),
(1070, 244, 'M ', '110:612', '110:612', 699.00, 699.00, 699.00, 699.00, 100, 0, '010101', '', '2017-06-10 16:14:44', NULL),
(1071, 244, 'L ', '110:614', '110:614', 699.00, 699.00, 699.00, 699.00, 100, 0, '010101', '', '2017-06-10 16:14:44', NULL),
(1072, 245, 'S 蓝色 ', '110:611;111:618', '110:611;111:618', 1643.00, 1643.00, 1643.00, 1643.00, 100, 0, '101010', '', '2017-06-10 16:22:28', NULL),
(1073, 245, 'S 红色 ', '110:611;111:613', '110:611;111:613', 1600.00, 1600.00, 1600.00, 1600.00, 99, 0, '101010', '', '2017-06-10 16:22:29', NULL),
(1074, 245, 'M 蓝色 ', '110:612;111:618', '110:612;111:618', 1643.00, 1643.00, 1643.00, 1643.00, 100, 0, '101010', '', '2017-06-10 16:22:29', NULL),
(1075, 245, 'M 红色 ', '110:612;111:613', '110:612;111:613', 1600.00, 1600.00, 1600.00, 1600.00, 100, 0, '101010', '', '2017-06-10 16:22:29', NULL),
(1076, 245, 'L 蓝色 ', '110:614;111:618', '110:614;111:618', 1643.00, 1643.00, 1643.00, 1643.00, 100, 0, '101010', '', '2017-06-10 16:22:29', NULL),
(1077, 245, 'L 红色 ', '110:614;111:613', '110:614;111:613', 1600.00, 1600.00, 1600.00, 1600.00, 100, 0, '101010', '', '2017-06-10 16:22:29', NULL),
(1091, 259, '女士夏装胖MM加肥加大中长款连衣裙宽松大码无袖背心裙孕妇打底裙', '', '', 69.00, 25.90, 25.90, 5.00, 1000, 0, '10001', '', '2017-06-10 22:21:50', NULL);

-- 
-- Dumping data for table ns_goods_sku_deleted
--

-- Table `niushop_1.04`.ns_goods_sku_deleted does not contain any data (it is empty)

-- 
-- Dumping data for table ns_goods_spec
--
INSERT INTO ns_goods_spec VALUES
(110, 0, '尺码', 1, 0, '2017-06-10 14:04:57', 1),
(111, 0, '颜色分类', 1, 1, '2017-06-10 14:06:12', 3);

-- 
-- Dumping data for table ns_goods_spec_value
--
INSERT INTO ns_goods_spec_value VALUES
(611, 110, 'S', '', 1, 255, '2017-06-10 14:04:57'),
(612, 110, 'M', '', 1, 255, '2017-06-10 14:04:57'),
(613, 111, '红色', '', 1, 255, '2017-06-10 14:06:12'),
(614, 110, 'L', '', 1, 0, '2017-06-10 14:09:27'),
(615, 110, 'XL', '', 1, 0, '2017-06-10 14:09:40'),
(616, 110, '2XL', '', 1, 0, '2017-06-10 14:09:48'),
(617, 110, '3XL', '', 1, 0, '2017-06-10 14:09:51'),
(618, 111, '蓝色', '', 1, 0, '2017-06-10 14:19:57');

-- 
-- Dumping data for table ns_member
--

-- Table `niushop_1.04`.ns_member does not contain any data (it is empty)

-- 
-- Dumping data for table ns_member_account
--
INSERT INTO ns_member_account VALUES
(4, 1, 0, 0, 0.00, 0, 0.00, 0);

-- 
-- Dumping data for table ns_member_account_records
--

-- Table `niushop_1.04`.ns_member_account_records does not contain any data (it is empty)

-- 
-- Dumping data for table ns_member_balance_withdraw
--

-- Table `niushop_1.04`.ns_member_balance_withdraw does not contain any data (it is empty)

-- 
-- Dumping data for table ns_member_bank_account
--

-- Table `niushop_1.04`.ns_member_bank_account does not contain any data (it is empty)

-- 
-- Dumping data for table ns_member_express_address
--

-- Table `niushop_1.04`.ns_member_express_address does not contain any data (it is empty)

-- 
-- Dumping data for table ns_member_favorites
--

-- Table `niushop_1.04`.ns_member_favorites does not contain any data (it is empty)

-- 
-- Dumping data for table ns_member_gift
--

-- Table `niushop_1.04`.ns_member_gift does not contain any data (it is empty)

-- 
-- Dumping data for table ns_member_level
--
INSERT INTO ns_member_level VALUES
(47, 0, '普通会员', 0, 1.00, '', 1, 0, 0, 2);

-- 
-- Dumping data for table ns_member_recharge
--

-- Table `niushop_1.04`.ns_member_recharge does not contain any data (it is empty)

-- 
-- Dumping data for table ns_offpay_area
--

-- Table `niushop_1.04`.ns_offpay_area does not contain any data (it is empty)

-- 
-- Dumping data for table ns_order
--

-- Table `niushop_1.04`.ns_order does not contain any data (it is empty)

-- 
-- Dumping data for table ns_order_action
--

-- Table `niushop_1.04`.ns_order_action does not contain any data (it is empty)

-- 
-- Dumping data for table ns_order_goods
--

-- Table `niushop_1.04`.ns_order_goods does not contain any data (it is empty)

-- 
-- Dumping data for table ns_order_goods_express
--

-- Table `niushop_1.04`.ns_order_goods_express does not contain any data (it is empty)

-- 
-- Dumping data for table ns_order_goods_promotion_details
--

-- Table `niushop_1.04`.ns_order_goods_promotion_details does not contain any data (it is empty)

-- 
-- Dumping data for table ns_order_payment
--

-- Table `niushop_1.04`.ns_order_payment does not contain any data (it is empty)

-- 
-- Dumping data for table ns_order_pickup
--

-- Table `niushop_1.04`.ns_order_pickup does not contain any data (it is empty)

-- 
-- Dumping data for table ns_order_promotion_details
--

-- Table `niushop_1.04`.ns_order_promotion_details does not contain any data (it is empty)

-- 
-- Dumping data for table ns_order_refund
--

-- Table `niushop_1.04`.ns_order_refund does not contain any data (it is empty)

-- 
-- Dumping data for table ns_order_shipping_fee
--
INSERT INTO ns_order_shipping_fee VALUES
(14, '默认模板', 0, '2017-06-10 19:34:56', NULL),
(17, '东部', 0, '2017-06-10 20:55:58', NULL),
(18, '西部', 0, '2017-06-10 21:27:27', NULL),
(19, '北部', 0, '2017-06-10 20:58:27', NULL),
(20, '南部', 0, '2017-06-10 20:59:20', NULL);

-- 
-- Dumping data for table ns_order_shipping_fee_extend
--
INSERT INTO ns_order_shipping_fee_extend VALUES
(151, 14, '', '', 1, 10.00, 1, 10.00, 1),
(152, 15, '', '', 1, 10.00, 10, 10.00, 1),
(153, 15, '16,17,7', '152,167,166,165,164,163,162,161,160,159,158,157,156,155,154,153,168,169,181,180,179,178,177,176,175,174,173,172,171,170,182,51,52,53,54,55,56,57,58,59', 1, 1.00, 1, 1.00, 0),
(154, 16, '', '', 1, 1.00, 1, 1.00, 1),
(155, 17, '', '', 1, 10.00, 10, 10.00, 1),
(156, 17, '10,3,19', '74,85,84,83,82,81,80,79,78,77,76,75,86,3,12,11,10,9,8,7,6,5,4,13,197,208,210,211,212,213,214,215,216,207,206,198,199,200,201,202,203,204,205,217,209', 1, 10.00, 1, 5.00, 0),
(159, 19, '', '', 1, 10.00, 10, 10.00, 1),
(160, 19, '6,7,8', '37,49,48,47,46,45,44,43,42,41,40,39,38,50,51,52,53,54,55,56,57,58,59,60,71,70,69,68,67,66,65,64,63,62,61,72', 1, 10.00, 1, 15.00, 0),
(161, 20, '', '', 1, 10.00, 15, 10.00, 1),
(162, 20, '22,23,24,25,26', '234,235,247,248,249,250,251,252,253,254,246,245,244,236,237,238,239,240,241,242,243,255,256,257,258,259,260,261,262,263,264,265,279,278,277,276,275,274,273,272,271,270,269,268,267,266,280,281,282,283,284,285,286,287', 1, 10.00, 1, 10.00, 0),
(163, 18, '', '', 1, 10.00, 10, 10.00, 1),
(164, 18, '27,28,29,30,31', '288,296,295,294,293,292,291,290,289,297,298,310,309,308,307,306,305,304,303,302,301,300,299,311,312,313,314,315,316,317,318,319,320,321,322,323,324,325,341,340,339,338,337,336,335,334,333,332,331,330,329,328,327,326,342', 1, 10.00, 1, 10.00, 0);

-- 
-- Dumping data for table ns_order_shop_return
--
INSERT INTO ns_order_shop_return VALUES
(0, '山西太原', 'Niushop公司', '15800000000', '03568', '2017-06-10 09:49:37', '2017-06-10 21:29:04');

-- 
-- Dumping data for table ns_pickup_point
--

-- Table `niushop_1.04`.ns_pickup_point does not contain any data (it is empty)

-- 
-- Dumping data for table ns_platform_adv
--
INSERT INTO ns_platform_adv VALUES
(942, 1051, '商城推广图', 'http://www.niushop.com.cn', 'upload/advertising/1497067441.png', 0, 0, '#ff1b35'),
(943, 1052, '商城logo后的小广告', 'http://www.niushop.com.cn', 'upload/advertising/1497067657.png', 0, 0, '#ffffff'),
(944, 1052, 'logo栏右侧广告', 'http://www.niushop.com.cn', 'upload/advertising/1497068024.png', 1, 0, '#ffffff'),
(945, 1053, 'NIUSHOP开源商城', '#', 'upload/advertising/1497067819.png', 0, 0, '#c0c0c0'),
(947, 1053, '滚动图3', '#', 'upload/advertising/1497067855.jpg', 2, 0, '#ffffff'),
(948, 1054, '广告栏一图片1', 'javascript:;', 'upload/advertising/1497067960.png', 0, 0, '#ffffff'),
(949, 1054, '广告栏一图片2', 'javascript:;', 'upload/advertising/1497068146.png', 1, 0, '#ffffff'),
(950, 1054, '广告栏一图片3', 'javascript:;', 'upload/advertising/1497068172.png', 2, 0, '#ffffff'),
(951, 1054, '广告栏一图片4', 'javascript:;', 'upload/advertising/1497085006.png', 3, 0, '#ffffff'),
(952, 1054, '广告栏一图片5', 'javascript:;', 'upload/advertising/1497068187.png', 4, 0, '#ffffff'),
(954, 1056, '滚动一', '#', 'upload/advertising/1497068837.png', 0, 0, '#ffffff'),
(955, 1056, '滚动二', '#', 'upload/advertising/1497068854.png', 1, 0, '#ffffff'),
(956, 1056, '滚动三', '#', 'upload/advertising/1497068869.png', 2, 0, '#ffffff'),
(957, 1057, '推荐楼层1楼——单图广告图', '#', 'upload/advertising/1497068896.png', 0, 0, '#ffffff'),
(958, 1058, '推荐楼层1楼——轮播图1', '#', 'upload/advertising/1497069144.png', 0, 0, '#ffffff'),
(959, 1058, '推荐楼层1楼——轮播图2', '#', 'upload/advertising/1497069159.png', 1, 0, '#ffffff'),
(960, 1058, '推荐楼层1楼——轮播图3', '#', 'upload/advertising/1497069175.png', 2, 0, '#ffffff'),
(961, 1059, '推荐楼层1楼——多图1', '#', 'upload/advertising/1497069290.png', 0, 0, '#ffffff'),
(962, 1059, '推荐楼层1楼——多图2', '#', 'upload/advertising/1497069302.png', 1, 0, '#ffffff'),
(963, 1059, '推荐楼层1楼——多图3', '#', 'upload/advertising/1497069321.png', 2, 0, '#ffffff'),
(964, 1059, '推荐楼层1楼——多图4', '#', 'upload/advertising/1497069393.png', 3, 0, '#ffffff'),
(965, 1059, '推荐楼层1楼——多图5', '#', 'upload/advertising/1497069408.png', 4, 0, '#ffffff'),
(967, 1060, '推荐楼层2楼——单图广告图', '#', 'upload/advertising/1497069441.png', 0, 0, '#ffffff'),
(968, 1063, '推荐楼层3楼——单图广告图', '#', 'upload/advertising/1497069606.png', 0, 0, '#ffffff'),
(970, 1064, '推荐楼层4楼——单图广告图', '#', 'upload/advertising/1497069629.png', 0, 0, '#ffffff'),
(971, 1065, '推荐楼层5楼——单图广告图', '#', 'upload/advertising/1497069657.png', 0, 0, '#ffffff'),
(972, 1066, '推荐楼层6楼——单图广告图', '#', 'upload/advertising/1497069679.png', 0, 0, '#ffffff'),
(973, 1050, '推荐楼层2楼——轮播图1', '#', 'upload/admin/common/1487673767.png', 1, 0, '#FFFFFF'),
(974, 1050, '推荐楼层2楼——轮播图2', '#', 'upload/admin/common/1487673796.png', 2, 0, '#FFFFFF'),
(975, 1050, '推荐楼层2楼——轮播图3', '#', 'upload/admin/common/1487673822.png', 3, 0, '#FFFFFF'),
(976, 1061, '推荐楼层2楼——轮播图1', '#', 'upload/advertising/1497069460.png', 1, 0, '#ffffff'),
(977, 1061, '推荐楼层2楼——轮播图2', '#', 'upload/advertising/1497069501.png', 2, 0, '#ffffff'),
(978, 1061, '推荐楼层2楼——轮播图3', '#', 'upload/advertising/1497069514.png', 3, 0, '#ffffff'),
(979, 1067, '推荐楼层3楼——轮播图1', '#', 'upload/advertising/1497069703.png', 0, 0, '#ffffff'),
(980, 1067, '推荐楼层3楼——轮播图2', '#', 'upload/advertising/1497069729.png', 1, 0, '#ffffff'),
(981, 1067, '推荐楼层3楼——轮播图3', '#', 'upload/advertising/1497069741.png', 2, 0, '#ffffff'),
(982, 1068, '推荐楼层4楼——轮播图1', '#', 'upload/advertising/1497069758.png', 0, 0, '#ffffff'),
(983, 1068, '推荐楼层4楼——轮播图2', '#', 'upload/advertising/1497069771.png', 1, 0, '#ffffff'),
(984, 1068, '推荐楼层4楼——轮播图3', '#', 'upload/advertising/1497069786.png', 2, 0, '#ffffff'),
(985, 1069, '推荐楼层5楼——轮播图1', '#', 'upload/advertising/1497069806.png', 0, 0, '#ffffff'),
(986, 1069, '推荐楼层5楼——轮播图2', '#', 'upload/advertising/1497069818.png', 1, 0, '#ffffff'),
(987, 1069, '推荐楼层5楼——轮播图3', '#', 'upload/advertising/1497069833.png', 2, 0, '#ffffff'),
(988, 1070, '推荐楼层6楼——轮播图1', '#', 'upload/advertising/1497069853.png', 0, 0, '#ffffff'),
(989, 1070, '推荐楼层6楼——轮播图2', '#', 'upload/advertising/1497069865.png', 1, 0, '#ffffff'),
(990, 1070, '推荐楼层6楼——轮播图3', '#', 'upload/advertising/1497069876.png', 2, 0, '#ffffff'),
(991, 1062, '推荐楼层2楼——多图1', '#', 'upload/advertising/1497069535.png', 0, 0, '#ffffff'),
(992, 1062, '推荐楼层2楼——多图2', '#', 'upload/advertising/1497069549.png', 1, 0, '#ffffff'),
(993, 1062, '推荐楼层2楼——多图3', '#', 'upload/advertising/1497069561.png', 2, 0, '#ffffff'),
(994, 1062, '推荐楼层2楼——多图4', '#', 'upload/advertising/1497069575.png', 3, 0, '#ffffff'),
(995, 1062, '推荐楼层2楼——多图5', '#', 'upload/advertising/1497069587.png', 4, 0, '#ffffff'),
(996, 1071, '推荐楼层3楼——多图1', '#', 'upload/advertising/1497069893.png', 0, 0, '#ffffff'),
(997, 1071, '推荐楼层3楼——多图2', '#', 'upload/advertising/1497069906.png', 1, 0, '#ffffff'),
(998, 1071, '推荐楼层3楼——多图3', '#', 'upload/advertising/1497069923.png', 2, 0, '#ffffff'),
(999, 1071, '推荐楼层3楼——多图4', '#', 'upload/advertising/1497070037.png', 3, 0, '#ffffff'),
(1000, 1071, '推荐楼层3楼——多图5', '#', 'upload/advertising/1497070051.png', 4, 0, '#ffffff'),
(1001, 1072, '推荐楼层4楼——多图1', '#', 'upload/advertising/1497070074.png', 0, 0, '#ffffff'),
(1002, 1072, '推荐楼层4楼——多图2', '#', 'upload/advertising/1497070086.png', 1, 0, '#ffffff'),
(1003, 1072, '推荐楼层4楼——多图3', '#', 'upload/advertising/1497070098.png', 2, 0, '#ffffff'),
(1004, 1072, '推荐楼层4楼——多图4', '#', 'upload/advertising/1497070109.png', 4, 0, '#ffffff'),
(1005, 1072, '推荐楼层4楼——多图5', '#', 'upload/advertising/1497070120.png', 5, 0, '#ffffff'),
(1006, 1073, '推荐楼层5楼——多图1', '#', 'upload/advertising/1497070139.png', 0, 0, '#ffffff'),
(1007, 1073, '推荐楼层5楼——多图2', '#', 'upload/advertising/1497070151.png', 1, 0, '#ffffff'),
(1008, 1073, '推荐楼层5楼——多图3', '#', 'upload/advertising/1497070191.png', 2, 0, '#ffffff'),
(1009, 1073, '推荐楼层5楼——多图4', '#', 'upload/advertising/1497070203.png', 3, 0, '#ffffff'),
(1010, 1073, '推荐楼层5楼——多图5', '#', 'upload/advertising/1497070217.png', 4, 0, '#ffffff'),
(1011, 1074, '推荐楼层6楼——多图1', '#', 'upload/advertising/1497070237.png', 0, 0, '#ffffff'),
(1012, 1074, '推荐楼层6楼——多图2', '#', 'upload/advertising/1497070248.png', 1, 0, '#ffffff'),
(1013, 1074, '推荐楼层6楼——多图3', '#', 'upload/advertising/1497070260.png', 2, 0, '#ffffff'),
(1014, 1074, '推荐楼层6楼——多图4', '#', 'upload/advertising/1497070272.png', 3, 0, '#ffffff'),
(1015, 1074, '推荐楼层6楼——多图5', '#', 'upload/advertising/1497070289.png', 4, 0, '#ffffff'),
(1016, 1075, '轮播图1', '#', 'upload/advertising/1497070321.png', 1, 0, '#22334d'),
(1017, 1076, 'banner图一', '#', 'upload/advertising/1497070389.jpg', 0, 0, '#ffffff'),
(1018, 1102, '默认广告', '', 'upload/advertising/1497070577.jpg', 1, 0, '#ffffff'),
(1019, 1075, '轮播图2', '#', 'upload/advertising/1497070334.png', 2, 0, '#130f09'),
(1020, 1075, '轮播图3', '#', 'upload/advertising/1497070349.png', 3, 0, '#a9dff9'),
(1021, 1076, '牛酷logo', '#', 'upload/advertising/1497070514.jpg', 1, 0, '#ffffff'),
(1022, 1076, 'banner图2', '#', 'upload/advertising/1497070493.jpg', 2, 0, '#ffffff'),
(1023, 1076, 'banner图3', '#', 'upload/advertising/1497070540.jpg', 3, 0, '#ffffff'),
(1024, 1053, '广告3', '#', 'upload/advertising/1497067871.png', 2, 0, '#ff8000'),
(1025, 1053, '广告4', '#', 'upload/advertising/1497067886.png', 3, 0, '#ff0080'),
(1028, 1103, '轮播3', '#', 'upload/advertising/1497070612.png', 3, 0, '#000000'),
(1029, 1105, '手机端图片一', '#', 'upload/advertising/1497070640.png', 1, 0, '#000000'),
(1030, 1105, '手机端图片二', '#', 'upload/advertising/1497070655.png', 2, 0, '#000000'),
(1031, 1106, '手机端限时折扣', '#', 'upload/advertising/1497070677.png', 0, 0, '#000000'),
(1032, 1107, '店铺推广中心广告位1', '#', 'upload/advertising/1497070700.png', 0, 0, '#ff0000'),
(1033, 1152, '平台会员中心中间广告位', '#', 'upload/advertising/1497070745.png', 0, 0, '#000000'),
(1034, 1153, '店铺会员中心广告位', '#', 'upload/advertising/1497070769.png', 0, 0, '#000000'),
(1038, 1162, '品牌专区广告位', '#', 'upload/advertising/1497070819.png', 0, 0, '#000000'),
(1039, 1163, '限时折扣专区广告位', '#', 'upload/advertising/1497070836.png', 0, 0, '#000000'),
(1040, 1164, '手机端商城热卖', '#', 'upload/advertising/1497070853.png', 1, 0, '#000000'),
(1041, 1165, '积分中心广告', '#', 'upload/advertising/1497070872.png', 1, 0, '#000000');

-- 
-- Dumping data for table ns_platform_adv_position
--
INSERT INTO ns_platform_adv_position VALUES
(1051, '平台首页最顶部广告栏', '平台首页最顶部广告栏', 0, 2, 1, 1000, 1000, NULL, NULL, NULL, 'upload/advertising/1497067441.png', '#000000', 1, 0, 0),
(1052, '商城logo栏小广告', '商城logo栏小广告', 0, 2, 1, 90, 170, NULL, NULL, NULL, 'upload/advertising/1497067657.png', '#FFFFFF', 1, 0, 0),
(1053, '商城首页滚动图片栏', '商城首页滚动图片栏', 0, 2, 1, 443, 800, NULL, NULL, NULL, 'upload/advertising/1497067819.png', '#FFFFFF', 1, 0, 0),
(1054, '广告栏一', '广告栏一', 0, 2, 1, 140, 242, NULL, NULL, NULL, 'upload/advertising/1497067960.png', '', 1, 0, 0),
(1056, '限时折扣轮播图', '限时折扣轮播图', 0, 2, 1, 443, 1903, NULL, NULL, NULL, 'upload/advertising/1497068837.png', '#FFFFFF', 1, 0, 0),
(1057, '推荐楼层1楼——单图广告位', '推荐楼层1楼——单图广告位', 0, 2, 1, 485, 210, NULL, NULL, NULL, 'upload/advertising/1497068896.png', '#ffffff', 1, 0, 0),
(1058, '推荐楼层1楼——轮播图广告位', '推荐楼层1楼——轮播图广告位', 0, 0, 1, 485, 390, NULL, NULL, NULL, 'upload/advertising/1497069144.png', '#FFFFFF', 1, 0, 0),
(1059, '推荐楼层1楼——多图广告位', '推荐楼层1楼——多图广告位', 0, 1, 1, 300, 202, NULL, NULL, NULL, 'upload/advertising/1497069290.png', '#FFFFFF', 1, 0, 0),
(1060, '推荐楼层2楼——单图广告位', '推荐楼层2楼——单图广告位', 0, 2, 1, 485, 210, NULL, NULL, NULL, 'upload/advertising/1497069441.png', '#ffffff', 1, 0, 0),
(1061, '推荐楼层2楼——轮播图广告位', '推荐楼层2楼——轮播图广告位', 0, 0, 1, 485, 390, NULL, NULL, NULL, 'upload/advertising/1497069460.png', '#FFFFFF', 1, 0, 0),
(1062, '推荐楼层2楼——多图广告位', '推荐楼层2楼——多图广告位', 0, 1, 1, 300, 202, NULL, NULL, NULL, 'upload/advertising/1497069549.png', '#FFFFFF', 1, 0, 0),
(1063, '推荐楼层3楼——单图广告位', '推荐楼层3楼——单图广告位', 0, 2, 1, 485, 210, NULL, NULL, NULL, 'upload/advertising/1497069606.png', '#FFFFFF', 1, 0, 0),
(1064, '推荐楼层4楼——单图广告位', '推荐楼层4楼——单图广告位', 0, 2, 1, 485, 210, NULL, NULL, NULL, 'upload/advertising/1497069629.png', '#FFFFFF', 1, 0, 0),
(1065, '推荐楼层5楼——单图广告位', '推荐楼层5楼——单图广告位', 0, 2, 1, 485, 210, NULL, NULL, NULL, 'upload/advertising/1497069657.png', '#FFFFFF', 1, 0, 0),
(1066, '推荐楼层6楼——单图广告位', '推荐楼层6楼——单图广告位', 0, 2, 1, 485, 210, NULL, NULL, NULL, 'upload/advertising/1497069679.png', '#FFFFFF', 1, 0, 0),
(1067, '推荐楼层3楼——轮播图广告位', '推荐楼层3楼——轮播图广告位', 0, 0, 1, 485, 390, NULL, NULL, NULL, 'upload/advertising/1497069703.png', '#FFFFFF', 1, 0, 0),
(1068, '推荐楼层4楼——轮播图广告位', '推荐楼层4楼——轮播图广告位', 0, 0, 1, 485, 390, NULL, NULL, NULL, 'upload/advertising/1497069758.png', '#FFFFFF', 1, 0, 0),
(1069, '推荐楼层5楼——轮播图广告位', '推荐楼层5楼——轮播图广告位', 0, 0, 1, 485, 390, NULL, NULL, NULL, 'upload/advertising/1497069806.png', '#FFFFFF', 1, 0, 0),
(1070, '推荐楼层6楼——轮播图广告位', '推荐楼层6楼——轮播图广告位', 0, 0, 1, 485, 390, NULL, NULL, NULL, 'upload/advertising/1497069853.png', '#FFFFFF', 1, 0, 0),
(1071, '推荐楼层3楼——多图广告位', '推荐楼层3楼——多图广告位', 0, 1, 1, 300, 202, NULL, NULL, NULL, 'upload/advertising/1497069893.png', '#FFFFFF', 1, 0, 0),
(1072, '推荐楼层4楼——多图广告位', '推荐楼层4楼——多图广告位', 0, 1, 1, 300, 202, NULL, NULL, NULL, 'upload/advertising/1497070074.png', '#FFFFFF', 1, 0, 0),
(1073, '推荐楼层5楼——多图广告位', '推荐楼层5楼——多图广告位', 0, 1, 1, 300, 202, NULL, NULL, NULL, 'upload/advertising/1497070139.png', '#FFFFFF', 1, 0, 0),
(1074, '推荐楼层6楼——多图广告位', '推荐楼层6楼——多图广告位', 0, 1, 1, 300, 202, NULL, NULL, NULL, 'upload/advertising/1497070237.png', '#FFFFFF', 1, 0, 0),
(1075, '品牌专区banana轮播图', '品牌专区banana轮播图', 0, 0, 1, 443, 1210, NULL, NULL, NULL, 'upload/advertising/1497070321.png', '#000000', 1, 0, 0),
(1076, '积分中心', '积分中心banana图', 0, 2, 1, 320, 910, NULL, NULL, NULL, 'upload/advertising/1497070389.jpg', '#000000', 1, 0, 0),
(1102, '积分商场广告位2', '长条广告', 0, 2, 1, 60, 1210, NULL, NULL, NULL, 'upload/advertising/1497070577.jpg', '#000000', 1, 0, 0),
(1103, '登录页面轮播图', '登录页面轮播图', 0, 0, 1, 0, 0, NULL, NULL, NULL, 'upload/advertising/1497070612.png', '', 1, 0, 0),
(1105, '手机端首页最顶部广告栏', '牛酷商城', 0, 1, 0, 175, 320, NULL, NULL, NULL, 'upload/advertising/1497070640.png', '', 2, 0, 1),
(1106, '手机端限时折扣广告', '手机端限时折扣广告', 0, 2, 1, 192, 720, NULL, NULL, NULL, 'upload/advertising/1497070677.png', '#ffffff', 2, 0, 0),
(1107, '店铺推广中心广告', '店铺推广中心广告111', 0, 2, 1, 188, 750, NULL, NULL, NULL, 'upload/advertising/1497070700.png', '', 2, 0, 0),
(1152, '平台会员中心广告位', '平台会员中心广告位1', 0, 2, 1, 100, 750, NULL, NULL, NULL, 'upload/advertising/1497070745.png', '', 2, 0, 0),
(1153, '店铺会员中心广告位', '店铺会员中心广告位', 0, 2, 1, 100, 750, NULL, NULL, NULL, 'upload/advertising/1497070769.png', '', 2, 0, 0),
(1162, '品牌专区广告', '品牌专区广告', 0, 2, 1, 192, 720, NULL, NULL, NULL, 'upload/advertising/1497070819.png', '', 2, 0, 0),
(1163, '限时折扣专区广告位', '限时折扣专区广告位', 0, 2, 1, 130, 720, NULL, NULL, NULL, 'upload/advertising/1497070836.png', '', 2, 0, 0),
(1164, '手机端商城热卖', '手机端商城热卖', 0, 2, 1, 100, 100, NULL, NULL, NULL, 'upload/advertising/1497070853.png', '#000000', 2, 0, 0),
(1165, '积分中心广告位', '积分中心广告位', 0, 2, 1, 100, 100, NULL, NULL, NULL, 'upload/advertising/1497070872.png', '#000000', 2, 0, 0),
(1166, '测试广告位', '', 0, 2, 0, 123, 123, NULL, NULL, NULL, '', '#000000', 1, 0, 0);

-- 
-- Dumping data for table ns_platform_block
--

-- Table `niushop_1.04`.ns_platform_block does not contain any data (it is empty)

-- 
-- Dumping data for table ns_platform_goods_recommend
--

-- Table `niushop_1.04`.ns_platform_goods_recommend does not contain any data (it is empty)

-- 
-- Dumping data for table ns_platform_goods_recommend_class
--
INSERT INTO ns_platform_goods_recommend_class VALUES
(1, '新品推荐', 1, 1, 255, 0),
(2, '精品推荐', 1, 1, 255, 0),
(3, '热卖商品', 1, 1, 255, 0);

-- 
-- Dumping data for table ns_platform_help_class
--
INSERT INTO ns_platform_help_class VALUES
(1, 1, '新手上路', 0, 1),
(2, 1, '配送与支付', 0, 2),
(3, 1, '会员中心', 0, 3),
(4, 1, '服务保证', 0, 4),
(5, 1, '联系我们', 0, 5);

-- 
-- Dumping data for table ns_platform_help_document
--
INSERT INTO ns_platform_help_document VALUES
(1, 1, 1, '购物流程', '', 0, '', '', '0000-00-00 00:00:00', '2017-06-10 17:56:51'),
(2, 2, 2, '支付方式说明', '', 5, '<p>支付方式说明</p>', '', '0000-00-00 00:00:00', '2017-05-03 19:15:55'),
(3, 1, 3, '售后流程', '', 1, '', '', '0000-00-00 00:00:00', '2017-06-03 14:28:31'),
(5, 2, 3, '资金管理', '', 6, '<p>资金管理</p>', '', '0000-00-00 00:00:00', '2017-05-05 14:10:39'),
(6, 2, 3, '我的收藏', '', 7, '<p>我的收藏</p>', '', '0000-00-00 00:00:00', '2017-05-03 19:00:15'),
(7, 2, 2, '货到付款区域', '', 3, '<p>货到付款区域</p>', '', '2017-02-20 11:05:01', '2017-05-03 19:15:13'),
(8, 2, 2, '配送支付智能查询', '', 4, '<p>配送支付智能查询</p>', '', '2017-02-20 11:05:42', '2017-05-03 19:15:33'),
(9, 2, 4, '退换货原则', '', 9, '<p>退换货原则</p>', '', '2017-02-20 11:10:38', '2017-05-03 19:03:26'),
(10, 2, 4, '售后服务保证', '', 9, '<p>售后服务保证</p>', '', '2017-02-20 11:11:03', '2017-05-03 19:03:47'),
(11, 2, 4, '产品质量保证', '', 10, '<p>产品质量保证</p>', '', '2017-02-20 11:11:36', '2017-05-03 19:04:03'),
(12, 2, 5, '网站故障报告', '', 11, '<p>网站故障报告</p>', '', '2017-02-20 11:12:18', '2017-05-03 19:05:46'),
(13, 2, 1, '订购方式', '', 2, '<p>订购方式</p>', '', '2017-04-26 19:29:08', '2017-05-03 19:14:16'),
(14, 1, 3, '我的订单', '', 8, '<p>我的订单</p>', '', '2017-05-03 18:57:46', '2017-06-10 21:55:58'),
(15, 2, 5, '选机咨询', '', 12, '<p>选机咨询</p>', '', '2017-05-03 19:04:42', '2017-05-03 19:06:05'),
(16, 2, 5, '投诉与建议', '', 13, '<p>投诉与建议</p>', '', '2017-05-03 19:05:11', '2017-05-05 14:12:01');

-- 
-- Dumping data for table ns_platform_link
--

-- Table `niushop_1.04`.ns_platform_link does not contain any data (it is empty)

-- 
-- Dumping data for table ns_point_config
--
INSERT INTO ns_point_config VALUES
(4, 0, 1, 0.00, '2017-06-10 09:49:45', '2017-06-10 20:49:42', '');

-- 
-- Dumping data for table ns_promotion_bundling
--

-- Table `niushop_1.04`.ns_promotion_bundling does not contain any data (it is empty)

-- 
-- Dumping data for table ns_promotion_bundling_goods
--

-- Table `niushop_1.04`.ns_promotion_bundling_goods does not contain any data (it is empty)

-- 
-- Dumping data for table ns_promotion_discount
--
INSERT INTO ns_promotion_discount VALUES
(33, 0, 'Niushop开源商城', '连衣裙活动', '2017-06-10 16:37:12', '2017-10-27 16:37:14', 3, '2017-06-10 16:37:28', '0000-00-00 00:00:00', ''),
(34, 0, 'Niushop开源商城', '测试活动', '2017-06-10 22:14:06', '2017-12-29 22:14:08', 3, '2017-06-10 22:14:16', '0000-00-00 00:00:00', ''),
(35, 0, 'Niushop开源商城', '测试活动', '2017-06-10 22:22:22', '2017-12-30 22:22:24', 3, '2017-06-10 22:22:37', '0000-00-00 00:00:00', '');

-- 
-- Dumping data for table ns_promotion_discount_goods
--
INSERT INTO ns_promotion_discount_goods VALUES
(85, 33, '2017-06-10 16:37:12', '2017-10-27 16:37:14', 239, 3, 5.00, 'MG小象小清新裙子女夏装2017新款网纱假两件雪纺连衣裙条纹衬衫裙', 735),
(86, 34, '2017-06-10 22:14:06', '2017-12-29 22:14:08', 240, 3, 3.00, 'ONLY2017夏季新品字母刺绣层次大口袋宽松连衣裙女|117261526', 740),
(87, 34, '2017-06-10 22:14:06', '2017-12-29 22:14:08', 244, 3, 7.00, 'Koradior/珂莱蒂尔正品新款韩版夏季碎花修身复古印花网纱连衣裙', 742),
(88, 34, '2017-06-10 22:14:06', '2017-12-29 22:14:08', 245, 3, 8.00, 'COCOON/可可尼2017女装夏装新品性感一字肩荷叶袖印花连衣裙', 743),
(90, 35, '2017-06-10 22:22:22', '2017-12-30 22:22:24', 259, 3, 5.00, '女士夏装胖MM加肥加大中长款连衣裙宽松大码无袖背心裙孕妇打底裙', 744);

-- 
-- Dumping data for table ns_promotion_full_mail
--
INSERT INTO ns_promotion_full_mail VALUES
(2, 0, 0, 0.00, '2017-06-10 09:49:51', '0000-00-00 00:00:00');

-- 
-- Dumping data for table ns_promotion_gift
--

-- Table `niushop_1.04`.ns_promotion_gift does not contain any data (it is empty)

-- 
-- Dumping data for table ns_promotion_gift_goods
--

-- Table `niushop_1.04`.ns_promotion_gift_goods does not contain any data (it is empty)

-- 
-- Dumping data for table ns_promotion_mansong
--

-- Table `niushop_1.04`.ns_promotion_mansong does not contain any data (it is empty)

-- 
-- Dumping data for table ns_promotion_mansong_goods
--

-- Table `niushop_1.04`.ns_promotion_mansong_goods does not contain any data (it is empty)

-- 
-- Dumping data for table ns_promotion_mansong_rule
--

-- Table `niushop_1.04`.ns_promotion_mansong_rule does not contain any data (it is empty)

-- 
-- Dumping data for table ns_reward_rule
--
INSERT INTO ns_reward_rule VALUES
(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

-- 
-- Dumping data for table ns_shop
--

-- Table `niushop_1.04`.ns_shop does not contain any data (it is empty)

-- 
-- Dumping data for table ns_shop_ad
--

-- Table `niushop_1.04`.ns_shop_ad does not contain any data (it is empty)

-- 
-- Dumping data for table ns_shop_coin_records
--

-- Table `niushop_1.04`.ns_shop_coin_records does not contain any data (it is empty)

-- 
-- Dumping data for table ns_shop_express_address
--

-- Table `niushop_1.04`.ns_shop_express_address does not contain any data (it is empty)

-- 
-- Dumping data for table ns_shop_group
--
INSERT INTO ns_shop_group VALUES
(1, '珠宝/首饰', 8, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(2, '服装鞋包', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(3, '3C数码', 2, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(4, '美容护理', 3, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(5, '家居用品', 4, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(6, '食品/保健', 5, '0000-00-00 00:00:00', '0000-00-00 00:00:00');

-- 
-- Dumping data for table ns_shop_navigation
--
INSERT INTO ns_shop_navigation VALUES
(4, 1, '合作洽谈', 'http://b2c.niushop.com.cn/', 2, 3, '2017-01-18 18:18:18', '2017-06-10 21:05:31', 0, 1, 0, ''),
(9, 1, '关于我们', 'http://b2c.niushop.com.cn/', 2, 3, '2017-01-18 18:48:54', '2017-06-10 21:05:36', 0, 1, 0, ''),
(12, 1, '联系我们', 'http://www.niushop.com.cn/about.html', 3, 2, '2017-01-18 19:04:57', '2017-05-09 10:10:27', 0, 1, 0, ''),
(19, 1, '首页', 'http://b2c.niushop.com.cn/', 3, 2, '2017-02-15 17:09:19', '2017-06-10 21:05:19', 0, 1, 0, ''),
(22, 1, '官网', 'http://www.niushop.com.cn/web/index.html', 3, 2, '2017-05-09 09:45:29', '2017-05-09 10:00:49', 0, 1, 0, ''),
(23, 1, '产品版本', 'http://www.niushop.com.cn/online.html', 3, 2, '2017-05-09 09:46:34', '2017-05-09 10:09:20', 0, 1, 0, ''),
(24, 1, '项目定制', 'http://www.niushop.com.cn/customized.html', 3, 2, '2017-05-09 09:47:12', '2017-05-09 10:09:49', 0, 1, 0, ''),
(29, 1, '关于我们', 'http://www.niushop.com.cn/about.html', 3, 2, '2017-05-09 10:10:41', '2017-05-09 10:10:41', 0, 1, 0, '');

-- 
-- Dumping data for table ns_shop_navigation_template
--
INSERT INTO ns_shop_navigation_template VALUES
(1, '首页', '/index', 1, 1, '2017-06-17 21:37:08'),
(2, '限时折扣', '/index/discount', 1, 1, '2017-06-17 21:37:08'),
(3, '品牌列表', '/goods/brandlist', 1, 1, '2017-06-17 21:37:08');

-- 
-- Dumping data for table ns_shop_order_account_records
--
INSERT INTO ns_shop_order_account_records VALUES
(6, 1, 221, '', 334, 3100.00, 5.00, 2945.00, 155.00, 1, 0.00, 0.00, 0.00, '2017-03-27 17:27:31', 0, ''),
(8, 1, 223, '', 336, 3100.00, 5.00, -155.00, 155.00, 0, 0.00, 0.00, 0.00, '2017-03-29 15:15:19', 0, ''),
(9, 1, 225, '', 337, 5889.00, 5.00, -294.45, 294.45, 0, 0.00, 0.00, 0.00, '2017-03-29 17:17:48', 0, ''),
(10, 1, 225, '', 338, 145.00, 5.00, -7.25, 7.25, 0, 0.00, 0.00, 0.00, '2017-03-29 17:17:48', 0, ''),
(11, 1, 226, '', 339, 5889.00, 5.00, -294.45, 294.45, 0, 0.00, 0.00, 0.00, '2017-03-29 17:44:27', 0, ''),
(12, 1, 226, '', 340, 3100.00, 5.00, -155.00, 155.00, 0, 0.00, 0.00, 0.00, '2017-03-29 17:44:27', 0, ''),
(13, 1, 227, '', 341, 5889.00, 5.00, -294.45, 294.45, 0, 0.00, 0.00, 0.00, '2017-03-29 18:31:27', 0, ''),
(14, 1, 227, '', 342, 3100.00, 5.00, -155.00, 155.00, 0, 0.00, 0.00, 0.00, '2017-03-29 18:31:27', 0, ''),
(15, 1, 227, '', 343, 145.00, 5.00, -7.25, 7.25, 0, 0.00, 0.00, 0.00, '2017-03-29 18:31:27', 0, ''),
(16, 1, 228, '', 344, 5889.00, 5.00, -294.45, 294.45, 0, 0.00, 0.00, 0.00, '2017-03-29 18:36:24', 0, ''),
(17, 1, 228, '', 345, 3100.00, 5.00, -155.00, 155.00, 0, 0.00, 0.00, 0.00, '2017-03-29 18:36:24', 0, ''),
(18, 1, 228, '', 346, 145.00, 5.00, -7.25, 7.25, 0, 0.00, 0.00, 0.00, '2017-03-29 18:36:24', 0, ''),
(19, 1, 239, '', 351, 3100.00, 5.00, -155.00, 155.00, 0, 0.00, 0.00, 0.00, '2017-04-06 11:09:40', 0, ''),
(20, 1, 240, '', 352, 5889.00, 5.00, -294.45, 294.45, 0, 0.00, 0.00, 0.00, '2017-04-06 16:02:52', 1, ''),
(21, 1, 242, '', 355, 5889.00, 5.00, -294.45, 294.45, 0, 0.00, 0.00, 0.00, '2017-04-06 16:24:19', 0, ''),
(22, 1, 242, '', 356, 290.00, 5.00, -14.50, 14.50, 0, 0.00, 0.00, 0.00, '2017-04-06 16:24:19', 0, ''),
(23, 1, 243, '', 357, 290.00, 5.00, -14.50, 14.50, 0, 0.00, 0.00, 0.00, '2017-04-06 16:40:51', 1, ''),
(24, 1, 244, '', 358, 11778.00, 5.00, -588.90, 588.90, 0, 0.00, 0.00, 0.00, '2017-04-06 16:59:22', 0, ''),
(25, 1, 245, '', 359, 5889.00, 5.00, -294.45, 294.45, 0, 0.00, 0.00, 0.00, '2017-04-06 17:03:08', 1, ''),
(26, 1, 247, '', 361, 5889.00, 15.10, -889.24, 889.24, 0, 0.00, 0.00, 0.00, '2017-04-11 16:14:00', 0, ''),
(27, 1, 251, '', 362, 5889.00, 15.10, -889.24, 889.24, 0, 0.00, 0.00, 0.00, '2017-04-12 18:51:29', 0, ''),
(28, 1, 252, '', 363, 3100.00, 15.10, -468.10, 468.10, 0, 0.00, 0.00, 0.00, '2017-04-12 18:57:22', 0, ''),
(29, 1, 254, '', 365, 5967.00, 15.10, -901.02, 901.02, 0, 0.00, 0.00, 0.00, '2017-04-12 19:18:41', 0, ''),
(30, 1, 256, '', 367, 5889.00, 15.10, -889.24, 889.24, 0, 0.00, 0.00, 0.00, '2017-04-12 19:19:44', 0, ''),
(31, 1, 257, '', 368, 5889.00, 15.10, -889.24, 889.24, 0, 0.00, 0.00, 0.00, '2017-04-12 19:21:36', 0, ''),
(32, 1, 258, '', 369, 5689.00, 15.10, -859.04, 859.04, 0, 0.00, 0.00, 0.00, '2017-04-12 19:22:33', 0, ''),
(33, 1, 259, '', 370, 5689.00, 15.10, -859.04, 859.04, 0, 0.00, 0.00, 0.00, '2017-04-12 19:28:45', 0, ''),
(34, 1, 260, '', 371, 5909.00, 15.10, -892.26, 892.26, 0, 0.00, 0.00, 0.00, '2017-04-13 10:25:39', 0, '');

-- 
-- Dumping data for table ns_shop_weixin_share
--
INSERT INTO ns_shop_weixin_share VALUES
(0, '', '', '欢迎打开', '分享赚佣金', '', '   二维码', '注册有优惠');

-- 
-- Dumping data for table sys_album_class
--
INSERT INTO sys_album_class VALUES
(30, 0, 0, '默认相册', '', 1, '2017-06-10 11:20:31', 1),
(31, 0, 0, '连衣裙', '', 0, '2017-06-10 14:28:53', 1);

-- 
-- Dumping data for table sys_album_picture
--
INSERT INTO sys_album_picture VALUES
(735, 0, 31, 0, '1497076871', 'TB29KDBn3JlpuFjSspjXXcT', 'upload/goods/1497076871.jpg', '400,400', '400,400', 'upload/goods/14970768711.jpg', '700,700', '700,700', 'upload/goods/14970768712.jpg', '360,360', '360,360', 'upload/goods/14970768713.jpg', '240,240', '240,240', 'upload/goods/14970768714.jpg', '60,60', '60,60', '2017-06-10 14:41:11'),
(736, 0, 31, 0, '1497076874', 'TB2YL50nYtlpuFjSspfXXXLUpXa_!!479184430', 'upload/goods/1497076874.jpg', '400,400', '400,400', 'upload/goods/14970768741.jpg', '700,700', '700,700', 'upload/goods/14970768742.jpg', '360,360', '360,360', 'upload/goods/14970768743.jpg', '240,240', '240,240', 'upload/goods/14970768744.jpg', '60,60', '60,60', '2017-06-10 14:41:14'),
(737, 0, 31, 0, '1497076875', 'TB2IPNMnrplpuFjSspiXXcdfFXa_!!479184430', 'upload/goods/1497076875.jpg', '400,400', '400,400', 'upload/goods/14970768751.jpg', '700,700', '700,700', 'upload/goods/14970768752.jpg', '360,360', '360,360', 'upload/goods/14970768753.jpg', '240,240', '240,240', 'upload/goods/14970768754.jpg', '60,60', '60,60', '2017-06-10 14:41:16'),
(738, 0, 31, 0, '1497076878', 'TB1U9rSRpXXXXbFXFXXXXXXXXXX_!!2-item_pic', 'upload/goods/1497076878.jpg', '400,400', '400,400', 'upload/goods/14970768781.jpg', '700,700', '700,700', 'upload/goods/14970768782.jpg', '360,360', '360,360', 'upload/goods/14970768783.jpg', '240,240', '240,240', 'upload/goods/14970768784.jpg', '60,60', '60,60', '2017-06-10 14:41:18'),
(739, 0, 31, 0, '1497080716', 'TB2pNs2gHXlpuFjSszfXXcSGXXa-356060330', 'upload/goods/1497080716.jpg', '1200,1200', '1200,1200', 'upload/goods/14970807171.jpg', '700,700', '700,700', 'upload/goods/14970807172.jpg', '360,360', '360,360', 'upload/goods/14970807173.jpg', '240,240', '240,240', 'upload/goods/14970807174.jpg', '60,60', '60,60', '2017-06-10 15:45:17'),
(740, 0, 31, 0, '1497080721', 'TB2pNs2gHXlpuFjSszfXXcSGXXa-356060330', 'upload/goods/1497080721.jpg', '430,430', '430,430', 'upload/goods/14970807211.jpg', '700,700', '700,700', 'upload/goods/14970807212.jpg', '360,360', '360,360', 'upload/goods/14970807213.jpg', '240,240', '240,240', 'upload/goods/14970807214.jpg', '60,60', '60,60', '2017-06-10 15:45:22'),
(742, 0, 31, 0, '1497082319', 'TB22z1BopXXXXaLXXXXXXXXXXXX_!!692195348', 'upload/goods/1497082319.jpg', '430,430', '430,430', 'upload/goods/14970823191.jpg', '700,700', '700,700', 'upload/goods/14970823192.jpg', '360,360', '360,360', 'upload/goods/14970823193.jpg', '240,240', '240,240', 'upload/goods/14970823194.jpg', '60,60', '60,60', '2017-06-10 16:11:59'),
(743, 0, 31, 0, '1497082939', 'TB21QGblSBjpuFjSsplXXa5MVXa_!!468333872', 'upload/goods/1497082939.jpg', '430,430', '430,430', 'upload/goods/14970829391.jpg', '700,700', '700,700', 'upload/goods/14970829392.jpg', '360,360', '360,360', 'upload/goods/14970829393.jpg', '240,240', '240,240', 'upload/goods/14970829394.jpg', '60,60', '60,60', '2017-06-10 16:22:19'),
(744, 0, 31, 0, '1497104384', 'TB2k_XyfAqvpuFjSZFhXXaOgXXa_!!2002910652', 'upload/goods/1497104384.jpg', '750,750', '750,750', 'upload/goods/14971043841.jpg', '700,700', '700,700', 'upload/goods/14971043842.jpg', '360,360', '360,360', 'upload/goods/14971043843.jpg', '240,240', '240,240', 'upload/goods/14971043844.jpg', '60,60', '60,60', '2017-06-10 22:19:44'),
(745, 0, 31, 0, '1497104397', 'TB2r27NfipnpuFjSZFIXXXh2VXa_!!2002910652', 'upload/goods/1497104397.jpg', '800,800', '800,800', 'upload/goods/14971043971.jpg', '700,700', '700,700', 'upload/goods/14971043972.jpg', '360,360', '360,360', 'upload/goods/14971043973.jpg', '240,240', '240,240', 'upload/goods/14971043974.jpg', '60,60', '60,60', '2017-06-10 22:19:57'),
(746, 0, 30, 0, '1497104411', 'TB2r27NfipnpuFjSZFIXXXh2VXa_!!2002910652', 'upload/goods/1497104411.jpg', '800,800', '800,800', 'upload/goods/14971044111.jpg', '700,700', '700,700', 'upload/goods/14971044112.jpg', '360,360', '360,360', 'upload/goods/14971044113.jpg', '240,240', '240,240', 'upload/goods/14971044114.jpg', '60,60', '60,60', '2017-06-10 22:20:11');

-- 
-- Dumping data for table sys_area
--
INSERT INTO sys_area VALUES
(1, '华东', 0),
(2, '华北', 0),
(3, '华南', 0),
(4, '华中', 0),
(5, '东北', 0),
(6, '西北', 0),
(7, '西南', 0),
(8, '港澳台', 0);

-- 
-- Dumping data for table sys_city
--
INSERT INTO sys_city VALUES
(1, 1, '北京市', '100000', 1),
(2, 2, '天津市', '100000', 0),
(3, 3, '石家庄市', '050000', 0),
(4, 3, '唐山市', '063000', 0),
(5, 3, '秦皇岛市', '066000', 0),
(6, 3, '邯郸市', '056000', 0),
(7, 3, '邢台市', '054000', 0),
(8, 3, '保定市', '071000', 0),
(9, 3, '张家口市', '075000', 0),
(10, 3, '承德市', '067000', 0),
(11, 3, '沧州市', '061000', 0),
(12, 3, '廊坊市', '065000', 0),
(13, 3, '衡水市', '053000', 0),
(14, 4, '太原市', '030000', 0),
(15, 4, '大同市', '037000', 0),
(16, 4, '阳泉市', '045000', 0),
(17, 4, '长治市', '046000', 0),
(18, 4, '晋城市', '048000', 0),
(19, 4, '朔州市', '036000', 0),
(20, 4, '晋中市', '030600', 0),
(21, 4, '运城市', '044000', 0),
(22, 4, '忻州市', '034000', 0),
(23, 4, '临汾市', '041000', 0),
(24, 4, '吕梁市', '030500', 0),
(25, 5, '呼和浩特市', '010000', 0),
(26, 5, '包头市', '014000', 0),
(27, 5, '乌海市', '016000', 0),
(28, 5, '赤峰市', '024000', 0),
(29, 5, '通辽市', '028000', 0),
(30, 5, '鄂尔多斯市', '010300', 0),
(31, 5, '呼伦贝尔市', '021000', 0),
(32, 5, '巴彦淖尔市', '014400', 0),
(33, 5, '乌兰察布市', '011800', 0),
(34, 5, '兴安盟', '137500', 0),
(35, 5, '锡林郭勒盟', '011100', 0),
(36, 5, '阿拉善盟', '016000', 0),
(37, 6, '沈阳市', '110000', 0),
(38, 6, '大连市', '116000', 0),
(39, 6, '鞍山市', '114000', 0),
(40, 6, '抚顺市', '113000', 0),
(41, 6, '本溪市', '117000', 0),
(42, 6, '丹东市', '118000', 0),
(43, 6, '锦州市', '121000', 0),
(44, 6, '营口市', '115000', 0),
(45, 6, '阜新市', '123000', 0),
(46, 6, '辽阳市', '111000', 0),
(47, 6, '盘锦市', '124000', 0),
(48, 6, '铁岭市', '112000', 0),
(49, 6, '朝阳市', '122000', 0),
(50, 6, '葫芦岛市', '125000', 0),
(51, 7, '长春市', '130000', 0),
(52, 7, '吉林市', '132000', 0),
(53, 7, '四平市', '136000', 0),
(54, 7, '辽源市', '136200', 0),
(55, 7, '通化市', '134000', 0),
(56, 7, '白山市', '134300', 0),
(57, 7, '松原市', '131100', 0),
(58, 7, '白城市', '137000', 0),
(59, 7, '延边朝鲜族自治州', '133000', 0),
(60, 8, '哈尔滨市', '150000', 0),
(61, 8, '齐齐哈尔市', '161000', 0),
(62, 8, '鸡西市', '158100', 0),
(63, 8, '鹤岗市', '154100', 0),
(64, 8, '双鸭山市', '155100', 0),
(65, 8, '大庆市', '163000', 0),
(66, 8, '伊春市', '152300', 0),
(67, 8, '佳木斯市', '154000', 0),
(68, 8, '七台河市', '154600', 0),
(69, 8, '牡丹江市', '157000', 0),
(70, 8, '黑河市', '164300', 0),
(71, 8, '绥化市', '152000', 0),
(72, 8, '大兴安岭地区', '165000', 0),
(73, 9, '上海市', '200000', 0),
(74, 10, '南京市', '210000', 0),
(75, 10, '无锡市', '214000', 0),
(76, 10, '徐州市', '221000', 0),
(77, 10, '常州市', '213000', 0),
(78, 10, '苏州市', '215000', 0),
(79, 10, '南通市', '226000', 0),
(80, 10, '连云港市', '222000', 0),
(81, 10, '淮安市', '223200', 0),
(82, 10, '盐城市', '224000', 0),
(83, 10, '扬州市', '225000', 0),
(84, 10, '镇江市', '212000', 0),
(85, 10, '泰州市', '225300', 0),
(86, 10, '宿迁市', '223800', 0),
(87, 11, '杭州市', '310000', 0),
(88, 11, '宁波市', '315000', 0),
(89, 11, '温州市', '325000', 0),
(90, 11, '嘉兴市', '314000', 0),
(91, 11, '湖州市', '313000', 0),
(92, 11, '绍兴市', '312000', 0),
(93, 11, '金华市', '321000', 0),
(94, 11, '衢州市', '324000', 0),
(95, 11, '舟山市', '316000', 0),
(96, 11, '台州市', '318000', 0),
(97, 11, '丽水市', '323000', 0),
(98, 12, '合肥市', '230000', 0),
(99, 12, '芜湖市', '241000', 0),
(100, 12, '蚌埠市', '233000', 0),
(101, 12, '淮南市', '232000', 0),
(102, 12, '马鞍山市', '243000', 0),
(103, 12, '淮北市', '235000', 0),
(104, 12, '铜陵市', '244000', 0),
(105, 12, '安庆市', '246000', 0),
(106, 12, '黄山市', '242700', 0),
(107, 12, '滁州市', '239000', 0),
(108, 12, '阜阳市', '236100', 0),
(109, 12, '宿州市', '234100', 0),
(110, 12, '巢湖市', '238000', 0),
(111, 12, '六安市', '237000', 0),
(112, 12, '亳州市', '236800', 0),
(113, 12, '池州市', '247100', 0),
(114, 12, '宣城市', '366000', 0),
(115, 13, '福州市', '350000', 0),
(116, 13, '厦门市', '361000', 0),
(117, 13, '莆田市', '351100', 0),
(118, 13, '三明市', '365000', 0),
(119, 13, '泉州市', '362000', 0),
(120, 13, '漳州市', '363000', 0),
(121, 13, '南平市', '353000', 0),
(122, 13, '龙岩市', '364000', 0),
(123, 13, '宁德市', '352100', 0),
(124, 14, '南昌市', '330000', 0),
(125, 14, '景德镇市', '333000', 0),
(126, 14, '萍乡市', '337000', 0),
(127, 14, '九江市', '332000', 0),
(128, 14, '新余市', '338000', 0),
(129, 14, '鹰潭市', '335000', 0),
(130, 14, '赣州市', '341000', 0),
(131, 14, '吉安市', '343000', 0),
(132, 14, '宜春市', '336000', 0),
(133, 14, '抚州市', '332900', 0),
(134, 14, '上饶市', '334000', 0),
(135, 15, '济南市', '250000', 0),
(136, 15, '青岛市', '266000', 0),
(137, 15, '淄博市', '255000', 0),
(138, 15, '枣庄市', '277100', 0),
(139, 15, '东营市', '257000', 0),
(140, 15, '烟台市', '264000', 0),
(141, 15, '潍坊市', '261000', 0),
(142, 15, '济宁市', '272100', 0),
(143, 15, '泰安市', '271000', 0),
(144, 15, '威海市', '265700', 0),
(145, 15, '日照市', '276800', 0),
(146, 15, '莱芜市', '271100', 0),
(147, 15, '临沂市', '276000', 0),
(148, 15, '德州市', '253000', 0),
(149, 15, '聊城市', '252000', 0),
(150, 15, '滨州市', '256600', 0),
(151, 15, '荷泽市', '255000', 0),
(152, 16, '郑州市', '450000', 0),
(153, 16, '开封市', '475000', 0),
(154, 16, '洛阳市', '471000', 0),
(155, 16, '平顶山市', '467000', 0),
(156, 16, '安阳市', '454900', 0),
(157, 16, '鹤壁市', '456600', 0),
(158, 16, '新乡市', '453000', 0),
(159, 16, '焦作市', '454100', 0),
(160, 16, '濮阳市', '457000', 0),
(161, 16, '许昌市', '461000', 0),
(162, 16, '漯河市', '462000', 0),
(163, 16, '三门峡市', '472000', 0),
(164, 16, '南阳市', '473000', 0),
(165, 16, '商丘市', '476000', 0),
(166, 16, '信阳市', '464000', 0),
(167, 16, '周口市', '466000', 0),
(168, 16, '驻马店市', '463000', 0),
(169, 17, '武汉市', '430000', 0),
(170, 17, '黄石市', '435000', 0),
(171, 17, '十堰市', '442000', 0),
(172, 17, '宜昌市', '443000', 0),
(173, 17, '襄樊市', '441000', 0),
(174, 17, '鄂州市', '436000', 0),
(175, 17, '荆门市', '448000', 0),
(176, 17, '孝感市', '432100', 0),
(177, 17, '荆州市', '434000', 0),
(178, 17, '黄冈市', '438000', 0),
(179, 17, '咸宁市', '437000', 0),
(180, 17, '随州市', '441300', 0),
(181, 17, '恩施土家族苗族自治州', '445000', 0),
(182, 17, '神农架', '442400', 0),
(183, 18, '长沙市', '410000', 0),
(184, 18, '株洲市', '412000', 0),
(185, 18, '湘潭市', '411100', 0),
(186, 18, '衡阳市', '421000', 0),
(187, 18, '邵阳市', '422000', 0),
(188, 18, '岳阳市', '414000', 0),
(189, 18, '常德市', '415000', 0),
(190, 18, '张家界市', '427000', 0),
(191, 18, '益阳市', '413000', 0),
(192, 18, '郴州市', '423000', 0),
(193, 18, '永州市', '425000', 0),
(194, 18, '怀化市', '418000', 0),
(195, 18, '娄底市', '417000', 0),
(196, 18, '湘西土家族苗族自治州', '416000', 0),
(197, 19, '广州市', '510000', 0),
(198, 19, '韶关市', '521000', 0),
(199, 19, '深圳市', '518000', 0),
(200, 19, '珠海市', '519000', 0),
(201, 19, '汕头市', '515000', 0),
(202, 19, '佛山市', '528000', 0),
(203, 19, '江门市', '529000', 0),
(204, 19, '湛江市', '524000', 0),
(205, 19, '茂名市', '525000', 0),
(206, 19, '肇庆市', '526000', 0),
(207, 19, '惠州市', '516000', 0),
(208, 19, '梅州市', '514000', 0),
(209, 19, '汕尾市', '516600', 1),
(210, 19, '河源市', '517000', 0),
(211, 19, '阳江市', '529500', 0),
(212, 19, '清远市', '511500', 0),
(213, 19, '东莞市', '511700', 0),
(214, 19, '中山市', '528400', 0),
(215, 19, '潮州市', '515600', 0),
(216, 19, '揭阳市', '522000', 0),
(217, 19, '云浮市', '527300', 0),
(218, 20, '南宁市', '530000', 0),
(219, 20, '柳州市', '545000', 0),
(220, 20, '桂林市', '541000', 0),
(221, 20, '梧州市', '543000', 0),
(222, 20, '北海市', '536000', 0),
(223, 20, '防城港市', '538000', 0),
(224, 20, '钦州市', '535000', 0),
(225, 20, '贵港市', '537100', 0),
(226, 20, '玉林市', '537000', 0),
(227, 20, '百色市', '533000', 0),
(228, 20, '贺州市', '542800', 0),
(229, 20, '河池市', '547000', 0),
(230, 20, '来宾市', '546100', 0),
(231, 20, '崇左市', '532200', 0),
(232, 21, '海口市', '570000', 0),
(233, 21, '三亚市', '572000', 0),
(234, 22, '重庆市', '400000', 0),
(235, 23, '成都市', '610000', 0),
(236, 23, '自贡市', '643000', 0),
(237, 23, '攀枝花市', '617000', 0),
(238, 23, '泸州市', '646100', 0),
(239, 23, '德阳市', '618000', 0),
(240, 23, '绵阳市', '621000', 0),
(241, 23, '广元市', '628000', 0),
(242, 23, '遂宁市', '629000', 0),
(243, 23, '内江市', '641000', 0),
(244, 23, '乐山市', '614000', 0),
(245, 23, '南充市', '637000', 0),
(246, 23, '眉山市', '612100', 0),
(247, 23, '宜宾市', '644000', 0),
(248, 23, '广安市', '638000', 0),
(249, 23, '达州市', '635000', 0),
(250, 23, '雅安市', '625000', 0),
(251, 23, '巴中市', '635500', 0),
(252, 23, '资阳市', '641300', 0),
(253, 23, '阿坝藏族羌族自治州', '624600', 0),
(254, 23, '甘孜藏族自治州', '626000', 0),
(255, 23, '凉山彝族自治州', '615000', 0),
(256, 24, '贵阳市', '55000', 0),
(257, 24, '六盘水市', '553000', 0),
(258, 24, '遵义市', '563000', 0),
(259, 24, '安顺市', '561000', 0),
(260, 24, '铜仁地区', '554300', 0),
(261, 24, '黔西南布依族苗族自治州', '551500', 0),
(262, 24, '毕节地区', '551700', 0),
(263, 24, '黔东南苗族侗族自治州', '551500', 0),
(264, 24, '黔南布依族苗族自治州', '550100', 0),
(265, 25, '昆明市', '650000', 0),
(266, 25, '曲靖市', '655000', 0),
(267, 25, '玉溪市', '653100', 0),
(268, 25, '保山市', '678000', 0),
(269, 25, '昭通市', '657000', 0),
(270, 25, '丽江市', '674100', 0),
(271, 25, '思茅市', '665000', 0),
(272, 25, '临沧市', '677000', 0),
(273, 25, '楚雄彝族自治州', '675000', 0),
(274, 25, '红河哈尼族彝族自治州', '654400', 0),
(275, 25, '文山壮族苗族自治州', '663000', 0),
(276, 25, '西双版纳傣族自治州', '666200', 0),
(277, 25, '大理白族自治州', '671000', 0),
(278, 25, '德宏傣族景颇族自治州', '678400', 0),
(279, 25, '怒江傈僳族自治州', '671400', 0),
(280, 25, '迪庆藏族自治州', '674400', 0),
(281, 26, '拉萨市', '850000', 0),
(282, 26, '昌都地区', '854000', 0),
(283, 26, '山南地区', '856000', 0),
(284, 26, '日喀则地区', '857000', 0),
(285, 26, '那曲地区', '852000', 0),
(286, 26, '阿里地区', '859100', 0),
(287, 26, '林芝地区', '860100', 0),
(288, 27, '西安市', '710000', 0),
(289, 27, '铜川市', '727000', 0),
(290, 27, '宝鸡市', '721000', 0),
(291, 27, '咸阳市', '712000', 0),
(292, 27, '渭南市', '714000', 0),
(293, 27, '延安市', '716000', 0),
(294, 27, '汉中市', '723000', 0),
(295, 27, '榆林市', '719000', 0),
(296, 27, '安康市', '725000', 0),
(297, 27, '商洛市', '711500', 0),
(298, 28, '兰州市', '730000', 0),
(299, 28, '嘉峪关市', '735100', 0),
(300, 28, '金昌市', '737100', 0),
(301, 28, '白银市', '730900', 0),
(302, 28, '天水市', '741000', 0),
(303, 28, '武威市', '733000', 0),
(304, 28, '张掖市', '734000', 0),
(305, 28, '平凉市', '744000', 0),
(306, 28, '酒泉市', '735000', 0),
(307, 28, '庆阳市', '744500', 0),
(308, 28, '定西市', '743000', 0),
(309, 28, '陇南市', '742100', 0),
(310, 28, '临夏回族自治州', '731100', 0),
(311, 28, '甘南藏族自治州', '747000', 0),
(312, 29, '西宁市', '810000', 0),
(313, 29, '海东地区', '810600', 0),
(314, 29, '海北藏族自治州', '810300', 0),
(315, 29, '黄南藏族自治州', '811300', 0),
(316, 29, '海南藏族自治州', '813000', 0),
(317, 29, '果洛藏族自治州', '814000', 0),
(318, 29, '玉树藏族自治州', '815000', 0),
(319, 29, '海西蒙古族藏族自治州', '817000', 0),
(320, 30, '银川市', '750000', 0),
(321, 30, '石嘴山市', '753000', 0),
(322, 30, '吴忠市', '751100', 0),
(323, 30, '固原市', '756000', 0),
(324, 30, '中卫市', '751700', 0),
(325, 31, '乌鲁木齐市', '830000', 0),
(326, 31, '克拉玛依市', '834000', 0),
(327, 31, '吐鲁番地区', '838000', 0),
(328, 31, '哈密地区', '839000', 0),
(329, 31, '昌吉回族自治州', '831100', 0),
(330, 31, '博尔塔拉蒙古自治州', '833400', 0),
(331, 31, '巴音郭楞蒙古自治州', '841000', 0),
(332, 31, '阿克苏地区', '843000', 0),
(333, 31, '克孜勒苏柯尔克孜自治州', '835600', 0),
(334, 31, '喀什地区', '844000', 0),
(335, 31, '和田地区', '848000', 0),
(336, 31, '伊犁哈萨克自治州', '833200', 0),
(337, 31, '塔城地区', '834700', 0),
(338, 31, '阿勒泰地区', '836500', 0),
(339, 31, '石河子市', '832000', 0),
(340, 31, '阿拉尔市', '843300', 0),
(341, 31, '图木舒克市', '843900', 0),
(342, 31, '五家渠市', '831300', 0),
(343, 32, '香港特别行政区', '000000', 0),
(344, 33, '澳门特别行政区', '000000', 0),
(345, 34, '台湾省', '000000', 0);

-- 
-- Dumping data for table sys_config
--
INSERT INTO sys_config VALUES
(12, 0, 'USERNOTICE', '""', '2017-02-23 14:08:01', '2017-06-10 21:55:38', '', 1),
(13, 0, 'HOTKEY', '[]', '2017-02-23 14:35:49', '2017-06-10 22:33:49', '', 1),
(14, 0, 'DEFAULTKEY', '""', '2017-02-23 14:36:28', '2017-06-10 22:33:55', '', 1),
(17, 0, 'QQLOGIN', '{"APP_KEY":"","APP_SECRET":"","AUTHORIZE":"http:\\/\\/localhost","CALLBACK":"http:\\/\\/localhost\\/niushop_b2c_demo\\/niushop_b2c_demo\\/wap\\/login\\/callback"}', '2017-03-01 14:48:45', '2017-06-10 22:37:27', 'qq', 0),
(18, 0, 'WCHAT', '{"APP_KEY":"","APP_SECRET":"","AUTHORIZE":"http:\\/\\/localhost","CALLBACK":"http:\\/\\/localhost\\/niushop_b2c_demo\\/niushop_b2c_demo\\/wap\\/Login\\/callback"}', '2017-03-01 14:49:07', '2017-06-10 22:37:20', '微信', 0),
(21, 0, 'ALIPAY', '{"ali_partnerid":"","ali_seller":"","ali_key":""}', '2017-03-02 16:18:17', '2017-06-10 22:36:49', '', 0),
(22, 0, 'EMAILMESSAGE', '{"email_host":"","email_port":"","email_addr":"","email_id":"","email_pass":""}', '2017-03-03 15:00:50', '2017-06-10 22:11:08', '', 0),
(27, 0, 'WXOPENPLATFORM', '', '2017-03-30 11:52:59', '2017-06-08 14:34:32', '', 1),
(28, 0, 'LOGINVERIFYCODE', '{"platform":0,"admin":"0","pc":"0"}', '2017-04-01 10:48:19', '2017-06-10 19:42:52', '', 1),
(31, 0, 'COIN_CONFIG', '', '2017-04-17 10:36:33', '2017-06-08 14:34:32', '购物币现金转化关系', 1),
(38, 0, 'ORDER_BUY_CLOSE_TIME', '', '0000-00-00 00:00:00', '2017-06-08 14:34:32', '订单下单之后多少分钟未支付则关闭订单', 1),
(39, 0, 'ORDER_DELIVERY_COMPLETE_TIME', '10', '0000-00-00 00:00:00', '2017-06-10 22:19:05', '收货后多长时间自动完成', 1),
(40, 0, 'ORDER_AUTO_DELIVERY', '7', '0000-00-00 00:00:00', '2017-06-10 22:19:05', '订单收货之后多长时间自动完成', 1),
(41, 0, 'ORDER_BALANCE_PAY', '1', '0000-00-00 00:00:00', '2017-06-10 22:19:05', '是否开启余额支付', 1),
(42, 0, 'ORDER_INVOICE_TAX', '1.11', '0000-00-00 00:00:00', '2017-06-10 22:19:05', '发票税率', 1),
(43, 0, 'ORDER_INVOICE_CONTENT', 'sss', '0000-00-00 00:00:00', '2017-06-10 22:19:05', '发票内容', 1),
(44, 0, 'ORDER_SHOW_BUY_RECORD', '1', '0000-00-00 00:00:00', '2017-06-10 22:19:05', '是否显示购买记录', 1),
(45, 0, 'SEO_TITLE', 'niushop', '2017-06-06 20:13:14', '2017-06-10 18:25:04', '标题附加字', 1),
(46, 0, 'SEO_META', 'niushop', '2017-06-06 20:13:14', '2017-06-10 18:25:04', '商城关键词', 1),
(47, 0, 'SEO_DESC', '开源商城', '2017-06-06 20:13:14', '2017-06-10 18:25:04', '关键词描述', 1),
(48, 0, 'SEO_OTHER', '', '2017-06-06 20:13:14', '2017-06-10 18:25:04', '其他页头信息', 1),
(107, 0, 'ORDER_DELIVERY_PAY', '1', '2017-06-07 16:51:06', '2017-06-10 22:19:05', '是否开启货到付款', 1),
(108, 0, 'WITHDRAW_BALANCE', '{"withdraw_cash_min":"1","withdraw_multiple":"1","withdraw_poundage":0,"withdraw_message":""}', '2017-06-07 18:18:36', '2017-06-10 22:38:09', '会员余额提现设置', 1),
(109, 0, 'REGISTER_INTEGRAL', '1', '2017-06-09 12:17:57', '2017-06-10 18:56:09', '注册送积分', 1),
(111, 0, 'SHARE_INTEGRAL', '0', '2017-06-09 12:17:57', '2017-06-10 18:56:09', '分享送积分', 1),
(112, 0, 'SIGN_INTEGRAL', '0', '2017-06-09 12:42:50', '2017-06-10 18:56:09', '签到送积分', 1),
(113, 0, 'MOBILEMESSAGE', '{"appKey":"","secretKey":"","freeSignName":""}', '2017-06-10 15:35:08', '2017-06-10 22:37:10', '', 1),
(116, 0, 'LOGINVERIFYCODE', '{"platform":0,"admin":"0","pc":"0"}', '2017-06-10 17:02:51', '2017-06-10 19:42:52', '', 1),
(122, 0, 'HOTKEY', '[]', '2017-06-10 17:39:26', '2017-06-10 22:33:49', '', 1),
(123, 0, 'DEFAULTKEY', '""', '2017-06-10 17:39:42', '2017-06-10 22:33:55', '', 1),
(125, 0, 'WPAY', '{"appid":"","appkey":"","mch_id":"","mch_key":""}', '2017-06-10 17:32:03', '2017-06-10 22:36:59', '', 0),
(127, 0, 'SHOPWCHAT', '{"appid":"","appsecret":""}', '2017-06-10 17:48:10', '2017-06-10 17:49:20', '', 1);

-- 
-- Dumping data for table sys_district
--
INSERT INTO sys_district VALUES
(1, 1, '东城区', 0),
(2, 1, '西城区', 0),
(3, 1, '崇文区', 0),
(4, 1, '宣武区', 0),
(5, 1, '朝阳区', 0),
(6, 1, '丰台区', 0),
(7, 1, '石景山区', 0),
(8, 1, '海淀区', 0),
(9, 1, '门头沟区', 0),
(10, 1, '房山区', 0),
(11, 1, '通州区', 0),
(12, 1, '顺义区', 0),
(13, 1, '昌平区', 0),
(14, 1, '大兴区', 0),
(15, 1, '怀柔区', 0),
(16, 1, '平谷区', 0),
(17, 1, '密云县', 0),
(18, 1, '延庆县', 0),
(19, 2, '和平区', 0),
(20, 2, '河东区', 0),
(21, 2, '河西区', 0),
(22, 2, '南开区', 0),
(23, 2, '河北区', 0),
(24, 2, '红桥区', 0),
(25, 2, '塘沽区', 0),
(26, 2, '汉沽区', 0),
(27, 2, '大港区', 0),
(28, 2, '东丽区', 0),
(29, 2, '西青区', 0),
(30, 2, '津南区', 0),
(31, 2, '北辰区', 0),
(32, 2, '武清区', 0),
(33, 2, '宝坻区', 0),
(34, 2, '宁河县', 0),
(35, 2, '静海县', 0),
(36, 2, '蓟县', 0),
(37, 3, '长安区', 0),
(38, 3, '桥东区', 0),
(39, 3, '桥西区', 0),
(40, 3, '新华区', 0),
(41, 3, '井陉矿区', 0),
(42, 3, '裕华区', 0),
(43, 3, '井陉县', 0),
(44, 3, '正定县', 0),
(45, 3, '栾城县', 0),
(46, 3, '行唐县', 0),
(47, 3, '灵寿县', 0),
(48, 3, '高邑县', 0),
(49, 3, '深泽县', 0),
(50, 3, '赞皇县', 0),
(51, 3, '无极县', 0),
(52, 3, '平山县', 0),
(53, 3, '元氏县', 0),
(54, 3, '赵县', 0),
(55, 3, '辛集市', 0),
(56, 3, '藁城市', 0),
(57, 3, '晋州市', 0),
(58, 3, '新乐市', 0),
(59, 3, '鹿泉市', 0),
(60, 4, '路南区', 0),
(61, 4, '路北区', 0),
(62, 4, '古冶区', 0),
(63, 4, '开平区', 0),
(64, 4, '丰南区', 0),
(65, 4, '丰润区', 0),
(66, 4, '滦县', 0),
(67, 4, '滦南县', 0),
(68, 4, '乐亭县', 0),
(69, 4, '迁西县', 0),
(70, 4, '玉田县', 0),
(71, 4, '唐海县', 0),
(72, 4, '遵化市', 0),
(73, 4, '迁安市', 0),
(74, 5, '海港区', 0),
(75, 5, '山海关区', 0),
(76, 5, '北戴河区', 0),
(77, 5, '青龙满族自治县', 0),
(78, 5, '昌黎县', 0),
(79, 5, '抚宁县', 0),
(80, 5, '卢龙县', 0),
(81, 6, '邯山区', 0),
(82, 6, '丛台区', 0),
(83, 6, '复兴区', 0),
(84, 6, '峰峰矿区', 0),
(85, 6, '邯郸县', 0),
(86, 6, '临漳县', 0),
(87, 6, '成安县', 0),
(88, 6, '大名县', 0),
(89, 6, '涉县', 0),
(90, 6, '磁县', 0),
(91, 6, '肥乡县', 0),
(92, 6, '永年县', 0),
(93, 6, '邱县', 0),
(94, 6, '鸡泽县', 0),
(95, 6, '广平县', 0),
(96, 6, '馆陶县', 0),
(97, 6, '魏县', 0),
(98, 6, '曲周县', 0),
(99, 6, '武安市', 0),
(100, 7, '桥东区', 0),
(101, 7, '桥西区', 0),
(102, 7, '邢台县', 0),
(103, 7, '临城县', 0),
(104, 7, '内丘县', 0),
(105, 7, '柏乡县', 0),
(106, 7, '隆尧县', 0),
(107, 7, '任县', 0),
(108, 7, '南和县', 0),
(109, 7, '宁晋县', 0),
(110, 7, '巨鹿县', 0),
(111, 7, '新河县', 0),
(112, 7, '广宗县', 0),
(113, 7, '平乡县', 0),
(114, 7, '威县', 0),
(115, 7, '清河县', 0),
(116, 7, '临西县', 0),
(117, 7, '南宫市', 0),
(118, 7, '沙河市', 0),
(119, 8, '新市区', 0),
(120, 8, '北市区', 0),
(121, 8, '南市区', 0),
(122, 8, '满城县', 0),
(123, 8, '清苑县', 0),
(124, 8, '涞水县', 0),
(125, 8, '阜平县', 0),
(126, 8, '徐水县', 0),
(127, 8, '定兴县', 0),
(128, 8, '唐县', 0),
(129, 8, '高阳县', 0),
(130, 8, '容城县', 0),
(131, 8, '涞源县', 0),
(132, 8, '望都县', 0),
(133, 8, '安新县', 0),
(134, 8, '易县', 0),
(135, 8, '曲阳县', 0),
(136, 8, '蠡县', 0),
(137, 8, '顺平县', 0),
(138, 8, '博野县', 0),
(139, 8, '雄县', 0),
(140, 8, '涿州市', 0),
(141, 8, '定州市', 0),
(142, 8, '安国市', 0),
(143, 8, '高碑店市', 0),
(144, 9, '桥东区', 0),
(145, 9, '桥西区', 0),
(146, 9, '宣化区', 0),
(147, 9, '下花园区', 0),
(148, 9, '宣化县', 0),
(149, 9, '张北县', 0),
(150, 9, '康保县', 0),
(151, 9, '沽源县', 0),
(152, 9, '尚义县', 0),
(153, 9, '蔚县', 0),
(154, 9, '阳原县', 0),
(155, 9, '怀安县', 0),
(156, 9, '万全县', 0),
(157, 9, '怀来县', 0),
(158, 9, '涿鹿县', 0),
(159, 9, '赤城县', 0),
(160, 9, '崇礼县', 0),
(161, 10, '双桥区', 0),
(162, 10, '双滦区', 0),
(163, 10, '鹰手营子矿区', 0),
(164, 10, '承德县', 0),
(165, 10, '兴隆县', 0),
(166, 10, '平泉县', 0),
(167, 10, '滦平县', 0),
(168, 10, '隆化县', 0),
(169, 10, '丰宁满族自治县', 0),
(170, 10, '宽城满族自治县', 0),
(171, 10, '围场满族蒙古族自治县', 0),
(172, 11, '新华区', 0),
(173, 11, '运河区', 0),
(174, 11, '沧县', 0),
(175, 11, '青县', 0),
(176, 11, '东光县', 0),
(177, 11, '海兴县', 0),
(178, 11, '盐山县', 0),
(179, 11, '肃宁县', 0),
(180, 11, '南皮县', 0),
(181, 11, '吴桥县', 0),
(182, 11, '献县', 0),
(183, 11, '孟村回族自治县', 0),
(184, 11, '泊头市', 0),
(185, 11, '任丘市', 0),
(186, 11, '黄骅市', 0),
(187, 11, '河间市', 0),
(188, 12, '安次区', 0),
(189, 12, '广阳区', 0),
(190, 12, '固安县', 0),
(191, 12, '永清县', 0),
(192, 12, '香河县', 0),
(193, 12, '大城县', 0),
(194, 12, '文安县', 0),
(195, 12, '大厂回族自治县', 0),
(196, 12, '霸州市', 0),
(197, 12, '三河市', 0),
(198, 13, '桃城区', 0),
(199, 13, '枣强县', 0),
(200, 13, '武邑县', 0),
(201, 13, '武强县', 0),
(202, 13, '饶阳县', 0),
(203, 13, '安平县', 0),
(204, 13, '故城县', 0),
(205, 13, '景县', 0),
(206, 13, '阜城县', 0),
(207, 13, '冀州市', 0),
(208, 13, '深州市', 0),
(209, 14, '小店区', 0),
(210, 14, '迎泽区', 0),
(211, 14, '杏花岭区', 0),
(212, 14, '尖草坪区', 0),
(213, 14, '万柏林区', 0),
(214, 14, '晋源区', 0),
(215, 14, '清徐县', 0),
(216, 14, '阳曲县', 0),
(217, 14, '娄烦县', 0),
(218, 14, '古交市', 0),
(219, 15, '城区', 0),
(220, 15, '矿区', 0),
(221, 15, '南郊区', 0),
(222, 15, '新荣区', 0),
(223, 15, '阳高县', 0),
(224, 15, '天镇县', 0),
(225, 15, '广灵县', 0),
(226, 15, '灵丘县', 0),
(227, 15, '浑源县', 0),
(228, 15, '左云县', 0),
(229, 15, '大同县', 0),
(230, 16, '城区', 0),
(231, 16, '矿区', 0),
(232, 16, '郊区', 0),
(233, 16, '平定县', 0),
(234, 16, '盂县', 0),
(235, 17, '城区', 0),
(236, 17, '郊区', 0),
(237, 17, '长治县', 0),
(238, 17, '襄垣县', 0),
(239, 17, '屯留县', 0),
(240, 17, '平顺县', 0),
(241, 17, '黎城县', 0),
(242, 17, '壶关县', 0),
(243, 17, '长子县', 0),
(244, 17, '武乡县', 0),
(245, 17, '沁县', 0),
(246, 17, '沁源县', 0),
(247, 17, '潞城市', 0),
(248, 18, '城区', 0),
(249, 18, '沁水县', 0),
(250, 18, '阳城县', 0),
(251, 18, '陵川县', 0),
(252, 18, '泽州县', 0),
(253, 18, '高平市', 0),
(254, 19, '朔城区', 0),
(255, 19, '平鲁区', 0),
(256, 19, '山阴县', 0),
(257, 19, '应县', 0),
(258, 19, '右玉县', 0),
(259, 19, '怀仁县', 0),
(260, 20, '榆次区', 0),
(261, 20, '榆社县', 0),
(262, 20, '左权县', 0),
(263, 20, '和顺县', 0),
(264, 20, '昔阳县', 0),
(265, 20, '寿阳县', 0),
(266, 20, '太谷县', 0),
(267, 20, '祁县', 0),
(268, 20, '平遥县', 0),
(269, 20, '灵石县', 0),
(270, 20, '介休市', 0),
(271, 21, '盐湖区', 0),
(272, 21, '临猗县', 0),
(273, 21, '万荣县', 0),
(274, 21, '闻喜县', 0),
(275, 21, '稷山县', 0),
(276, 21, '新绛县', 0),
(277, 21, '绛县', 0),
(278, 21, '垣曲县', 0),
(279, 21, '夏县', 0),
(280, 21, '平陆县', 0),
(281, 21, '芮城县', 0),
(282, 21, '永济市', 0),
(283, 21, '河津市', 0),
(284, 22, '忻府区', 0),
(285, 22, '定襄县', 0),
(286, 22, '五台县', 0),
(287, 22, '代县', 0),
(288, 22, '繁峙县', 0),
(289, 22, '宁武县', 0),
(290, 22, '静乐县', 0),
(291, 22, '神池县', 0),
(292, 22, '五寨县', 0),
(293, 22, '岢岚县', 0),
(294, 22, '河曲县', 0),
(295, 22, '保德县', 0),
(296, 22, '偏关县', 0),
(297, 22, '原平市', 0),
(298, 23, '尧都区', 0),
(299, 23, '曲沃县', 0),
(300, 23, '翼城县', 0),
(301, 23, '襄汾县', 0),
(302, 23, '洪洞县', 0),
(303, 23, '古县', 0),
(304, 23, '安泽县', 0),
(305, 23, '浮山县', 0),
(306, 23, '吉县', 0),
(307, 23, '乡宁县', 0),
(308, 23, '大宁县', 0),
(309, 23, '隰县', 0),
(310, 23, '永和县', 0),
(311, 23, '蒲县', 0),
(312, 23, '汾西县', 0),
(313, 23, '侯马市', 0),
(314, 23, '霍州市', 0),
(315, 24, '离石区', 0),
(316, 24, '文水县', 0),
(317, 24, '交城县', 0),
(318, 24, '兴县', 0),
(319, 24, '临县', 0),
(320, 24, '柳林县', 0),
(321, 24, '石楼县', 0),
(322, 24, '岚县', 0),
(323, 24, '方山县', 0),
(324, 24, '中阳县', 0),
(325, 24, '交口县', 0),
(326, 24, '孝义市', 0),
(327, 24, '汾阳市', 0),
(328, 25, '新城区', 0),
(329, 25, '回民区', 0),
(330, 25, '玉泉区', 0),
(331, 25, '赛罕区', 0),
(332, 25, '土默特左旗', 0),
(333, 25, '托克托县', 0),
(334, 25, '和林格尔县', 0),
(335, 25, '清水河县', 0),
(336, 25, '武川县', 0),
(337, 26, '东河区', 0),
(338, 26, '昆都仑区', 0),
(339, 26, '青山区', 0),
(340, 26, '石拐区', 0),
(341, 26, '白云矿区', 0),
(342, 26, '九原区', 0),
(343, 26, '土默特右旗', 0),
(344, 26, '固阳县', 0),
(345, 26, '达尔罕茂明安联合旗', 0),
(346, 27, '海勃湾区', 0),
(347, 27, '海南区', 0),
(348, 27, '乌达区', 0),
(349, 28, '红山区', 0),
(350, 28, '元宝山区', 0),
(351, 28, '松山区', 0),
(352, 28, '阿鲁科尔沁旗', 0),
(353, 28, '巴林左旗', 0),
(354, 28, '巴林右旗', 0),
(355, 28, '林西县', 0),
(356, 28, '克什克腾旗', 0),
(357, 28, '翁牛特旗', 0),
(358, 28, '喀喇沁旗', 0),
(359, 28, '宁城县', 0),
(360, 28, '敖汉旗', 0),
(361, 29, '科尔沁区', 0),
(362, 29, '科尔沁左翼中旗', 0),
(363, 29, '科尔沁左翼后旗', 0),
(364, 29, '开鲁县', 0),
(365, 29, '库伦旗', 0),
(366, 29, '奈曼旗', 0),
(367, 29, '扎鲁特旗', 0),
(368, 29, '霍林郭勒市', 0),
(369, 30, '东胜区', 0),
(370, 30, '达拉特旗', 0),
(371, 30, '准格尔旗', 0),
(372, 30, '鄂托克前旗', 0),
(373, 30, '鄂托克旗', 0),
(374, 30, '杭锦旗', 0),
(375, 30, '乌审旗', 0),
(376, 30, '伊金霍洛旗', 0),
(377, 31, '海拉尔区', 0),
(378, 31, '阿荣旗', 0),
(379, 31, '莫力达瓦达斡尔族自治旗', 0),
(380, 31, '鄂伦春自治旗', 0),
(381, 31, '鄂温克族自治旗', 0),
(382, 31, '陈巴尔虎旗', 0),
(383, 31, '新巴尔虎左旗', 0),
(384, 31, '新巴尔虎右旗', 0),
(385, 31, '满洲里市', 0),
(386, 31, '牙克石市', 0),
(387, 31, '扎兰屯市', 0),
(388, 31, '额尔古纳市', 0),
(389, 31, '根河市', 0),
(390, 32, '临河区', 0),
(391, 32, '五原县', 0),
(392, 32, '磴口县', 0),
(393, 32, '乌拉特前旗', 0),
(394, 32, '乌拉特中旗', 0),
(395, 32, '乌拉特后旗', 0),
(396, 32, '杭锦后旗', 0),
(397, 33, '集宁区', 0),
(398, 33, '卓资县', 0),
(399, 33, '化德县', 0),
(400, 33, '商都县', 0),
(401, 33, '兴和县', 0),
(402, 33, '凉城县', 0),
(403, 33, '察哈尔右翼前旗', 0),
(404, 33, '察哈尔右翼中旗', 0),
(405, 33, '察哈尔右翼后旗', 0),
(406, 33, '四子王旗', 0),
(407, 33, '丰镇市', 0),
(408, 34, '乌兰浩特市', 0),
(409, 34, '阿尔山市', 0),
(410, 34, '科尔沁右翼前旗', 0),
(411, 34, '科尔沁右翼中旗', 0),
(412, 34, '扎赉特旗', 0),
(413, 34, '突泉县', 0),
(414, 35, '二连浩特市', 0),
(415, 35, '锡林浩特市', 0),
(416, 35, '阿巴嘎旗', 0),
(417, 35, '苏尼特左旗', 0),
(418, 35, '苏尼特右旗', 0),
(419, 35, '东乌珠穆沁旗', 0),
(420, 35, '西乌珠穆沁旗', 0),
(421, 35, '太仆寺旗', 0),
(422, 35, '镶黄旗', 0),
(423, 35, '正镶白旗', 0),
(424, 35, '正蓝旗', 0),
(425, 35, '多伦县', 0),
(426, 36, '阿拉善左旗', 0),
(427, 36, '阿拉善右旗', 0),
(428, 36, '额济纳旗', 0),
(429, 37, '和平区', 0),
(430, 37, '沈河区', 0),
(431, 37, '大东区', 0),
(432, 37, '皇姑区', 0),
(433, 37, '铁西区', 0),
(434, 37, '苏家屯区', 0),
(435, 37, '东陵区', 0),
(436, 37, '新城子区', 0),
(437, 37, '于洪区', 0),
(438, 37, '辽中县', 0),
(439, 37, '康平县', 0),
(440, 37, '法库县', 0),
(441, 37, '新民市', 0),
(442, 38, '中山区', 0),
(443, 38, '西岗区', 0),
(444, 38, '沙河口区', 0),
(445, 38, '甘井子区', 0),
(446, 38, '旅顺口区', 0),
(447, 38, '金州区', 0),
(448, 38, '长海县', 0),
(449, 38, '瓦房店市', 0),
(450, 38, '普兰店市', 0),
(451, 38, '庄河市', 0),
(452, 39, '铁东区', 0),
(453, 39, '铁西区', 0),
(454, 39, '立山区', 0),
(455, 39, '千山区', 0),
(456, 39, '台安县', 0),
(457, 39, '岫岩满族自治县', 0),
(458, 39, '海城市', 0),
(459, 40, '新抚区', 0),
(460, 40, '东洲区', 0),
(461, 40, '望花区', 0),
(462, 40, '顺城区', 0),
(463, 40, '抚顺县', 0),
(464, 40, '新宾满族自治县', 0),
(465, 40, '清原满族自治县', 0),
(466, 41, '平山区', 0),
(467, 41, '溪湖区', 0),
(468, 41, '明山区', 0),
(469, 41, '南芬区', 0),
(470, 41, '本溪满族自治县', 0),
(471, 41, '桓仁满族自治县', 0),
(472, 42, '元宝区', 0),
(473, 42, '振兴区', 0),
(474, 42, '振安区', 0),
(475, 42, '宽甸满族自治县', 0),
(476, 42, '东港市', 0),
(477, 42, '凤城市', 0),
(478, 43, '古塔区', 0),
(479, 43, '凌河区', 0),
(480, 43, '太和区', 0),
(481, 43, '黑山县', 0),
(482, 43, '义县', 0),
(483, 43, '凌海市', 0),
(484, 43, '北宁市', 0),
(485, 44, '站前区', 0),
(486, 44, '西市区', 0),
(487, 44, '鲅鱼圈区', 0),
(488, 44, '老边区', 0),
(489, 44, '盖州市', 0),
(490, 44, '大石桥市', 0),
(491, 45, '海州区', 0),
(492, 45, '新邱区', 0),
(493, 45, '太平区', 0),
(494, 45, '清河门区', 0),
(495, 45, '细河区', 0),
(496, 45, '阜新蒙古族自治县', 0),
(497, 45, '彰武县', 0),
(498, 46, '白塔区', 0),
(499, 46, '文圣区', 0),
(500, 46, '宏伟区', 0),
(501, 46, '弓长岭区', 0),
(502, 46, '太子河区', 0),
(503, 46, '辽阳县', 0),
(504, 46, '灯塔市', 0),
(505, 47, '双台子区', 0),
(506, 47, '兴隆台区', 0),
(507, 47, '大洼县', 0),
(508, 47, '盘山县', 0),
(509, 48, '银州区', 0),
(510, 48, '清河区', 0),
(511, 48, '铁岭县', 0),
(512, 48, '西丰县', 0),
(513, 48, '昌图县', 0),
(514, 48, '调兵山市', 0),
(515, 48, '开原市', 0),
(516, 49, '双塔区', 0),
(517, 49, '龙城区', 0),
(518, 49, '朝阳县', 0),
(519, 49, '建平县', 0),
(520, 49, '喀喇沁左翼蒙古族自治县', 0),
(521, 49, '北票市', 0),
(522, 49, '凌源市', 0),
(523, 50, '连山区', 0),
(524, 50, '龙港区', 0),
(525, 50, '南票区', 0),
(526, 50, '绥中县', 0),
(527, 50, '建昌县', 0),
(528, 50, '兴城市', 0),
(529, 51, '南关区', 0),
(530, 51, '宽城区', 0),
(531, 51, '朝阳区', 0),
(532, 51, '二道区', 0),
(533, 51, '绿园区', 0),
(534, 51, '双阳区', 0),
(535, 51, '农安县', 0),
(536, 51, '九台市', 0),
(537, 51, '榆树市', 0),
(538, 51, '德惠市', 0),
(539, 52, '昌邑区', 0),
(540, 52, '龙潭区', 0),
(541, 52, '船营区', 0),
(542, 52, '丰满区', 0),
(543, 52, '永吉县', 0),
(544, 52, '蛟河市', 0),
(545, 52, '桦甸市', 0),
(546, 52, '舒兰市', 0),
(547, 52, '磐石市', 0),
(548, 53, '铁西区', 0),
(549, 53, '铁东区', 0),
(550, 53, '梨树县', 0),
(551, 53, '伊通满族自治县', 0),
(552, 53, '公主岭市', 0),
(553, 53, '双辽市', 0),
(554, 54, '龙山区', 0),
(555, 54, '西安区', 0),
(556, 54, '东丰县', 0),
(557, 54, '东辽县', 0),
(558, 55, '东昌区', 0),
(559, 55, '二道江区', 0),
(560, 55, '通化县', 0),
(561, 55, '辉南县', 0),
(562, 55, '柳河县', 0),
(563, 55, '梅河口市', 0),
(564, 55, '集安市', 0),
(565, 56, '八道江区', 0),
(566, 56, '抚松县', 0),
(567, 56, '靖宇县', 0),
(568, 56, '长白朝鲜族自治县', 0),
(569, 56, '江源县', 0),
(570, 56, '临江市', 0),
(571, 57, '宁江区', 0),
(572, 57, '前郭尔罗斯蒙古族自治县', 0),
(573, 57, '长岭县', 0),
(574, 57, '乾安县', 0),
(575, 57, '扶余县', 0),
(576, 58, '洮北区', 0),
(577, 58, '镇赉县', 0),
(578, 58, '通榆县', 0),
(579, 58, '洮南市', 0),
(580, 58, '大安市', 0),
(581, 59, '延吉市', 0),
(582, 59, '图们市', 0),
(583, 59, '敦化市', 0),
(584, 59, '珲春市', 0),
(585, 59, '龙井市', 0),
(586, 59, '和龙市', 0),
(587, 59, '汪清县', 0),
(588, 59, '安图县', 0),
(589, 60, '道里区', 0),
(590, 60, '南岗区', 0),
(591, 60, '道外区', 0),
(592, 60, '香坊区', 0),
(593, 60, '动力区', 0),
(594, 60, '平房区', 0),
(595, 60, '松北区', 0),
(596, 60, '呼兰区', 0),
(597, 60, '依兰县', 0),
(598, 60, '方正县', 0),
(599, 60, '宾县', 0),
(600, 60, '巴彦县', 0),
(601, 60, '木兰县', 0),
(602, 60, '通河县', 0),
(603, 60, '延寿县', 0),
(604, 60, '阿城市', 0),
(605, 60, '双城市', 0),
(606, 60, '尚志市', 0),
(607, 60, '五常市', 0),
(608, 61, '龙沙区', 0),
(609, 61, '建华区', 0),
(610, 61, '铁锋区', 0),
(611, 61, '昂昂溪区', 0),
(612, 61, '富拉尔基区', 0),
(613, 61, '碾子山区', 0),
(614, 61, '梅里斯达斡尔族区', 0),
(615, 61, '龙江县', 0),
(616, 61, '依安县', 0),
(617, 61, '泰来县', 0),
(618, 61, '甘南县', 0),
(619, 61, '富裕县', 0),
(620, 61, '克山县', 0),
(621, 61, '克东县', 0),
(622, 61, '拜泉县', 0),
(623, 61, '讷河市', 0),
(624, 62, '鸡冠区', 0),
(625, 62, '恒山区', 0),
(626, 62, '滴道区', 0),
(627, 62, '梨树区', 0),
(628, 62, '城子河区', 0),
(629, 62, '麻山区', 0),
(630, 62, '鸡东县', 0),
(631, 62, '虎林市', 0),
(632, 62, '密山市', 0),
(633, 63, '向阳区', 0),
(634, 63, '工农区', 0),
(635, 63, '南山区', 0),
(636, 63, '兴安区', 0),
(637, 63, '东山区', 0),
(638, 63, '兴山区', 0),
(639, 63, '萝北县', 0),
(640, 63, '绥滨县', 0),
(641, 64, '尖山区', 0),
(642, 64, '岭东区', 0),
(643, 64, '四方台区', 0),
(644, 64, '宝山区', 0),
(645, 64, '集贤县', 0),
(646, 64, '友谊县', 0),
(647, 64, '宝清县', 0),
(648, 64, '饶河县', 0),
(649, 65, '萨尔图区', 0),
(650, 65, '龙凤区', 0),
(651, 65, '让胡路区', 0),
(652, 65, '红岗区', 0),
(653, 65, '大同区', 0),
(654, 65, '肇州县', 0),
(655, 65, '肇源县', 0),
(656, 65, '林甸县', 0),
(657, 65, '杜尔伯特蒙古族自治县', 0),
(658, 66, '伊春区', 0),
(659, 66, '南岔区', 0),
(660, 66, '友好区', 0),
(661, 66, '西林区', 0),
(662, 66, '翠峦区', 0),
(663, 66, '新青区', 0),
(664, 66, '美溪区', 0),
(665, 66, '金山屯区', 0),
(666, 66, '五营区', 0),
(667, 66, '乌马河区', 0),
(668, 66, '汤旺河区', 0),
(669, 66, '带岭区', 0),
(670, 66, '乌伊岭区', 0),
(671, 66, '红星区', 0),
(672, 66, '上甘岭区', 0),
(673, 66, '嘉荫县', 0),
(674, 66, '铁力市', 0),
(675, 67, '永红区', 0),
(676, 67, '向阳区', 0),
(677, 67, '前进区', 0),
(678, 67, '东风区', 0),
(679, 67, '郊区', 0),
(680, 67, '桦南县', 0),
(681, 67, '桦川县', 0),
(682, 67, '汤原县', 0),
(683, 67, '抚远县', 0),
(684, 67, '同江市', 0),
(685, 67, '富锦市', 0),
(686, 68, '新兴区', 0),
(687, 68, '桃山区', 0),
(688, 68, '茄子河区', 0),
(689, 68, '勃利县', 0),
(690, 69, '东安区', 0),
(691, 69, '阳明区', 0),
(692, 69, '爱民区', 0),
(693, 69, '西安区', 0),
(694, 69, '东宁县', 0),
(695, 69, '林口县', 0),
(696, 69, '绥芬河市', 0),
(697, 69, '海林市', 0),
(698, 69, '宁安市', 0),
(699, 69, '穆棱市', 0),
(700, 70, '爱辉区', 0),
(701, 70, '嫩江县', 0),
(702, 70, '逊克县', 0),
(703, 70, '孙吴县', 0),
(704, 70, '北安市', 0),
(705, 70, '五大连池市', 0),
(706, 71, '北林区', 0),
(707, 71, '望奎县', 0),
(708, 71, '兰西县', 0),
(709, 71, '青冈县', 0),
(710, 71, '庆安县', 0),
(711, 71, '明水县', 0),
(712, 71, '绥棱县', 0),
(713, 71, '安达市', 0),
(714, 71, '肇东市', 0),
(715, 71, '海伦市', 0),
(716, 72, '呼玛县', 0),
(717, 72, '塔河县', 0),
(718, 72, '漠河县', 0),
(719, 73, '黄浦区', 0),
(720, 73, '卢湾区', 0),
(721, 73, '徐汇区', 0),
(722, 73, '长宁区', 0),
(723, 73, '静安区', 0),
(724, 73, '普陀区', 0),
(725, 73, '闸北区', 0),
(726, 73, '虹口区', 0),
(727, 73, '杨浦区', 0),
(728, 73, '闵行区', 0),
(729, 73, '宝山区', 0),
(730, 73, '嘉定区', 0),
(731, 73, '浦东新区', 0),
(732, 73, '金山区', 0),
(733, 73, '松江区', 0),
(734, 73, '青浦区', 0),
(735, 73, '南汇区', 0),
(736, 73, '奉贤区', 0),
(737, 73, '崇明县', 0),
(738, 74, '玄武区', 0),
(739, 74, '白下区', 0),
(740, 74, '秦淮区', 0),
(741, 74, '建邺区', 0),
(742, 74, '鼓楼区', 0),
(743, 74, '下关区', 0),
(744, 74, '浦口区', 0),
(745, 74, '栖霞区', 0),
(746, 74, '雨花台区', 0),
(747, 74, '江宁区', 0),
(748, 74, '六合区', 0),
(749, 74, '溧水县', 0),
(750, 74, '高淳县', 0),
(751, 75, '崇安区', 0),
(752, 75, '南长区', 0),
(753, 75, '北塘区', 0),
(754, 75, '锡山区', 0),
(755, 75, '惠山区', 0),
(756, 75, '滨湖区', 0),
(757, 75, '江阴市', 0),
(758, 75, '宜兴市', 0),
(759, 76, '鼓楼区', 0),
(760, 76, '云龙区', 0),
(761, 76, '九里区', 0),
(762, 76, '贾汪区', 0),
(763, 76, '泉山区', 0),
(764, 76, '丰县', 0),
(765, 76, '沛县', 0),
(766, 76, '铜山县', 0),
(767, 76, '睢宁县', 0),
(768, 76, '新沂市', 0),
(769, 76, '邳州市', 0),
(770, 77, '天宁区', 0),
(771, 77, '钟楼区', 0),
(772, 77, '戚墅堰区', 0),
(773, 77, '新北区', 0),
(774, 77, '武进区', 0),
(775, 77, '溧阳市', 0),
(776, 77, '金坛市', 0),
(777, 78, '沧浪区', 0),
(778, 78, '平江区', 0),
(779, 78, '金阊区', 0),
(780, 78, '虎丘区', 0),
(781, 78, '吴中区', 0),
(782, 78, '相城区', 0),
(783, 78, '常熟市', 0),
(784, 78, '张家港市', 0),
(785, 78, '昆山市', 0),
(786, 78, '吴江市', 0),
(787, 78, '太仓市', 0),
(788, 79, '崇川区', 0),
(789, 79, '港闸区', 0),
(790, 79, '海安县', 0),
(791, 79, '如东县', 0),
(792, 79, '启东市', 0),
(793, 79, '如皋市', 0),
(794, 79, '通州市', 0),
(795, 79, '海门市', 0),
(796, 80, '连云区', 0),
(797, 80, '新浦区', 0),
(798, 80, '海州区', 0),
(799, 80, '赣榆县', 0),
(800, 80, '东海县', 0),
(801, 80, '灌云县', 0),
(802, 80, '灌南县', 0),
(803, 81, '清河区', 0),
(804, 81, '楚州区', 0),
(805, 81, '淮阴区', 0),
(806, 81, '清浦区', 0),
(807, 81, '涟水县', 0),
(808, 81, '洪泽县', 0),
(809, 81, '盱眙县', 0),
(810, 81, '金湖县', 0),
(811, 82, '亭湖区', 0),
(812, 82, '盐都区', 0),
(813, 82, '响水县', 0),
(814, 82, '滨海县', 0),
(815, 82, '阜宁县', 0),
(816, 82, '射阳县', 0),
(817, 82, '建湖县', 0),
(818, 82, '东台市', 0),
(819, 82, '大丰市', 0),
(820, 83, '广陵区', 0),
(821, 83, '邗江区', 0),
(822, 83, '维扬区', 0),
(823, 83, '宝应县', 0),
(824, 83, '仪征市', 0),
(825, 83, '高邮市', 0),
(826, 83, '江都市', 0),
(827, 84, '京口区', 0),
(828, 84, '润州区', 0),
(829, 84, '丹徒区', 0),
(830, 84, '丹阳市', 0),
(831, 84, '扬中市', 0),
(832, 84, '句容市', 0),
(833, 85, '海陵区', 0),
(834, 85, '高港区', 0),
(835, 85, '兴化市', 0),
(836, 85, '靖江市', 0),
(837, 85, '泰兴市', 0),
(838, 85, '姜堰市', 0),
(839, 86, '宿城区', 0),
(840, 86, '宿豫区', 0),
(841, 86, '沭阳县', 0),
(842, 86, '泗阳县', 0),
(843, 86, '泗洪县', 0),
(844, 87, '上城区', 0),
(845, 87, '下城区', 0),
(846, 87, '江干区', 0),
(847, 87, '拱墅区', 0),
(848, 87, '西湖区', 0),
(849, 87, '滨江区', 0),
(850, 87, '萧山区', 0),
(851, 87, '余杭区', 0),
(852, 87, '桐庐县', 0),
(853, 87, '淳安县', 0),
(854, 87, '建德市', 0),
(855, 87, '富阳市', 0),
(856, 87, '临安市', 0),
(857, 88, '海曙区', 0),
(858, 88, '江东区', 0),
(859, 88, '江北区', 0),
(860, 88, '北仑区', 0),
(861, 88, '镇海区', 0),
(862, 88, '鄞州区', 0),
(863, 88, '象山县', 0),
(864, 88, '宁海县', 0),
(865, 88, '余姚市', 0),
(866, 88, '慈溪市', 0),
(867, 88, '奉化市', 0),
(868, 89, '鹿城区', 0),
(869, 89, '龙湾区', 0),
(870, 89, '瓯海区', 0),
(871, 89, '洞头县', 0),
(872, 89, '永嘉县', 0),
(873, 89, '平阳县', 0),
(874, 89, '苍南县', 0),
(875, 89, '文成县', 0),
(876, 89, '泰顺县', 0),
(877, 89, '瑞安市', 0),
(878, 89, '乐清市', 0),
(879, 90, '秀城区', 0),
(880, 90, '秀洲区', 0),
(881, 90, '嘉善县', 0),
(882, 90, '海盐县', 0),
(883, 90, '海宁市', 0),
(884, 90, '平湖市', 0),
(885, 90, '桐乡市', 0),
(886, 91, '吴兴区', 0),
(887, 91, '南浔区', 0),
(888, 91, '德清县', 0),
(889, 91, '长兴县', 0),
(890, 91, '安吉县', 0),
(891, 92, '越城区', 0),
(892, 92, '绍兴县', 0),
(893, 92, '新昌县', 0),
(894, 92, '诸暨市', 0),
(895, 92, '上虞市', 0),
(896, 92, '嵊州市', 0),
(897, 93, '婺城区', 0),
(898, 93, '金东区', 0),
(899, 93, '武义县', 0),
(900, 93, '浦江县', 0),
(901, 93, '磐安县', 0),
(902, 93, '兰溪市', 0),
(903, 93, '义乌市', 0),
(904, 93, '东阳市', 0),
(905, 93, '永康市', 0),
(906, 94, '柯城区', 0),
(907, 94, '衢江区', 0),
(908, 94, '常山县', 0),
(909, 94, '开化县', 0),
(910, 94, '龙游县', 0),
(911, 94, '江山市', 0),
(912, 95, '定海区', 0),
(913, 95, '普陀区', 0),
(914, 95, '岱山县', 0),
(915, 95, '嵊泗县', 0),
(916, 96, '椒江区', 0),
(917, 96, '黄岩区', 0),
(918, 96, '路桥区', 0),
(919, 96, '玉环县', 0),
(920, 96, '三门县', 0),
(921, 96, '天台县', 0),
(922, 96, '仙居县', 0),
(923, 96, '温岭市', 0),
(924, 96, '临海市', 0),
(925, 97, '莲都区', 0),
(926, 97, '青田县', 0),
(927, 97, '缙云县', 0),
(928, 97, '遂昌县', 0),
(929, 97, '松阳县', 0),
(930, 97, '云和县', 0),
(931, 97, '庆元县', 0),
(932, 97, '景宁畲族自治县', 0),
(933, 97, '龙泉市', 0),
(934, 98, '瑶海区', 0),
(935, 98, '庐阳区', 0),
(936, 98, '蜀山区', 0),
(937, 98, '包河区', 0),
(938, 98, '长丰县', 0),
(939, 98, '肥东县', 0),
(940, 98, '肥西县', 0),
(941, 99, '镜湖区', 0),
(942, 99, '马塘区', 0),
(943, 99, '新芜区', 0),
(944, 99, '鸠江区', 0),
(945, 99, '芜湖县', 0),
(946, 99, '繁昌县', 0),
(947, 99, '南陵县', 0),
(948, 100, '龙子湖区', 0),
(949, 100, '蚌山区', 0),
(950, 100, '禹会区', 0),
(951, 100, '淮上区', 0),
(952, 100, '怀远县', 0),
(953, 100, '五河县', 0),
(954, 100, '固镇县', 0),
(955, 101, '大通区', 0),
(956, 101, '田家庵区', 0),
(957, 101, '谢家集区', 0),
(958, 101, '八公山区', 0),
(959, 101, '潘集区', 0),
(960, 101, '凤台县', 0),
(961, 102, '金家庄区', 0),
(962, 102, '花山区', 0),
(963, 102, '雨山区', 0),
(964, 102, '当涂县', 0),
(965, 103, '杜集区', 0),
(966, 103, '相山区', 0),
(967, 103, '烈山区', 0),
(968, 103, '濉溪县', 0),
(969, 104, '铜官山区', 0),
(970, 104, '狮子山区', 0),
(971, 104, '郊区', 0),
(972, 104, '铜陵县', 0),
(973, 105, '迎江区', 0),
(974, 105, '大观区', 0),
(975, 105, '郊区', 0),
(976, 105, '怀宁县', 0),
(977, 105, '枞阳县', 0),
(978, 105, '潜山县', 0),
(979, 105, '太湖县', 0),
(980, 105, '宿松县', 0),
(981, 105, '望江县', 0),
(982, 105, '岳西县', 0),
(983, 105, '桐城市', 0),
(984, 106, '屯溪区', 0),
(985, 106, '黄山区', 0),
(986, 106, '徽州区', 0),
(987, 106, '歙县', 0),
(988, 106, '休宁县', 0),
(989, 106, '黟县', 0),
(990, 106, '祁门县', 0),
(991, 107, '琅琊区', 0),
(992, 107, '南谯区', 0),
(993, 107, '来安县', 0),
(994, 107, '全椒县', 0),
(995, 107, '定远县', 0),
(996, 107, '凤阳县', 0),
(997, 107, '天长市', 0),
(998, 107, '明光市', 0),
(999, 108, '颍州区', 0),
(1000, 108, '颍东区', 0),
(1001, 108, '颍泉区', 0),
(1002, 108, '临泉县', 0),
(1003, 108, '太和县', 0),
(1004, 108, '阜南县', 0),
(1005, 108, '颍上县', 0),
(1006, 108, '界首市', 0),
(1007, 109, '埇桥区', 0),
(1008, 109, '砀山县', 0),
(1009, 109, '萧县', 0),
(1010, 109, '灵璧县', 0),
(1011, 109, '泗县', 0),
(1012, 110, '居巢区', 0),
(1013, 110, '庐江县', 0),
(1014, 110, '无为县', 0),
(1015, 110, '含山县', 0),
(1016, 110, '和县', 0),
(1017, 111, '金安区', 0),
(1018, 111, '裕安区', 0),
(1019, 111, '寿县', 0),
(1020, 111, '霍邱县', 0),
(1021, 111, '舒城县', 0),
(1022, 111, '金寨县', 0),
(1023, 111, '霍山县', 0),
(1024, 112, '谯城区', 0),
(1025, 112, '涡阳县', 0),
(1026, 112, '蒙城县', 0),
(1027, 112, '利辛县', 0),
(1028, 113, '贵池区', 0),
(1029, 113, '东至县', 0),
(1030, 113, '石台县', 0),
(1031, 113, '青阳县', 0),
(1032, 114, '宣州区', 0),
(1033, 114, '郎溪县', 0),
(1034, 114, '广德县', 0),
(1035, 114, '泾县', 0),
(1036, 114, '绩溪县', 0),
(1037, 114, '旌德县', 0),
(1038, 114, '宁国市', 0),
(1039, 115, '鼓楼区', 0),
(1040, 115, '台江区', 0),
(1041, 115, '仓山区', 0),
(1042, 115, '马尾区', 0),
(1043, 115, '晋安区', 0),
(1044, 115, '闽侯县', 0),
(1045, 115, '连江县', 0),
(1046, 115, '罗源县', 0),
(1047, 115, '闽清县', 0),
(1048, 115, '永泰县', 0),
(1049, 115, '平潭县', 0),
(1050, 115, '福清市', 0),
(1051, 115, '长乐市', 0),
(1052, 116, '思明区', 0),
(1053, 116, '海沧区', 0),
(1054, 116, '湖里区', 0),
(1055, 116, '集美区', 0),
(1056, 116, '同安区', 0),
(1057, 116, '翔安区', 0),
(1058, 117, '城厢区', 0),
(1059, 117, '涵江区', 0),
(1060, 117, '荔城区', 0),
(1061, 117, '秀屿区', 0),
(1062, 117, '仙游县', 0),
(1063, 118, '梅列区', 0),
(1064, 118, '三元区', 0),
(1065, 118, '明溪县', 0),
(1066, 118, '清流县', 0),
(1067, 118, '宁化县', 0),
(1068, 118, '大田县', 0),
(1069, 118, '尤溪县', 0),
(1070, 118, '沙县', 0),
(1071, 118, '将乐县', 0),
(1072, 118, '泰宁县', 0),
(1073, 118, '建宁县', 0),
(1074, 118, '永安市', 0),
(1075, 119, '鲤城区', 0),
(1076, 119, '丰泽区', 0),
(1077, 119, '洛江区', 0),
(1078, 119, '泉港区', 0),
(1079, 119, '惠安县', 0),
(1080, 119, '安溪县', 0),
(1081, 119, '永春县', 0),
(1082, 119, '德化县', 0),
(1083, 119, '金门县', 0),
(1084, 119, '石狮市', 0),
(1085, 119, '晋江市', 0),
(1086, 119, '南安市', 0),
(1087, 120, '芗城区', 0),
(1088, 120, '龙文区', 0),
(1089, 120, '云霄县', 0),
(1090, 120, '漳浦县', 0),
(1091, 120, '诏安县', 0),
(1092, 120, '长泰县', 0),
(1093, 120, '东山县', 0),
(1094, 120, '南靖县', 0),
(1095, 120, '平和县', 0),
(1096, 120, '华安县', 0),
(1097, 120, '龙海市', 0),
(1098, 121, '延平区', 0),
(1099, 121, '顺昌县', 0),
(1100, 121, '浦城县', 0),
(1101, 121, '光泽县', 0),
(1102, 121, '松溪县', 0),
(1103, 121, '政和县', 0),
(1104, 121, '邵武市', 0),
(1105, 121, '武夷山市', 0),
(1106, 121, '建瓯市', 0),
(1107, 121, '建阳市', 0),
(1108, 122, '新罗区', 0),
(1109, 122, '长汀县', 0),
(1110, 122, '永定县', 0),
(1111, 122, '上杭县', 0),
(1112, 122, '武平县', 0),
(1113, 122, '连城县', 0),
(1114, 122, '漳平市', 0),
(1115, 123, '蕉城区', 0),
(1116, 123, '霞浦县', 0),
(1117, 123, '古田县', 0),
(1118, 123, '屏南县', 0),
(1119, 123, '寿宁县', 0),
(1120, 123, '周宁县', 0),
(1121, 123, '柘荣县', 0),
(1122, 123, '福安市', 0),
(1123, 123, '福鼎市', 0),
(1124, 124, '东湖区', 0),
(1125, 124, '西湖区', 0),
(1126, 124, '青云谱区', 0),
(1127, 124, '湾里区', 0),
(1128, 124, '青山湖区', 0),
(1129, 124, '南昌县', 0),
(1130, 124, '新建县', 0),
(1131, 124, '安义县', 0),
(1132, 124, '进贤县', 0),
(1133, 125, '昌江区', 0),
(1134, 125, '珠山区', 0),
(1135, 125, '浮梁县', 0),
(1136, 125, '乐平市', 0),
(1137, 126, '安源区', 0),
(1138, 126, '湘东区', 0),
(1139, 126, '莲花县', 0),
(1140, 126, '上栗县', 0),
(1141, 126, '芦溪县', 0),
(1142, 127, '庐山区', 0),
(1143, 127, '浔阳区', 0),
(1144, 127, '九江县', 0),
(1145, 127, '武宁县', 0),
(1146, 127, '修水县', 0),
(1147, 127, '永修县', 0),
(1148, 127, '德安县', 0),
(1149, 127, '星子县', 0),
(1150, 127, '都昌县', 0),
(1151, 127, '湖口县', 0),
(1152, 127, '彭泽县', 0),
(1153, 127, '瑞昌市', 0),
(1154, 128, '渝水区', 0),
(1155, 128, '分宜县', 0),
(1156, 129, '月湖区', 0),
(1157, 129, '余江县', 0),
(1158, 129, '贵溪市', 0),
(1159, 130, '章贡区', 0),
(1160, 130, '赣县', 0),
(1161, 130, '信丰县', 0),
(1162, 130, '大余县', 0),
(1163, 130, '上犹县', 0),
(1164, 130, '崇义县', 0),
(1165, 130, '安远县', 0),
(1166, 130, '龙南县', 0),
(1167, 130, '定南县', 0),
(1168, 130, '全南县', 0),
(1169, 130, '宁都县', 0),
(1170, 130, '于都县', 0),
(1171, 130, '兴国县', 0),
(1172, 130, '会昌县', 0),
(1173, 130, '寻乌县', 0),
(1174, 130, '石城县', 0),
(1175, 130, '瑞金市', 0),
(1176, 130, '南康市', 0),
(1177, 131, '吉州区', 0),
(1178, 131, '青原区', 0),
(1179, 131, '吉安县', 0),
(1180, 131, '吉水县', 0),
(1181, 131, '峡江县', 0),
(1182, 131, '新干县', 0),
(1183, 131, '永丰县', 0),
(1184, 131, '泰和县', 0),
(1185, 131, '遂川县', 0),
(1186, 131, '万安县', 0),
(1187, 131, '安福县', 0),
(1188, 131, '永新县', 0),
(1189, 131, '井冈山市', 0),
(1190, 132, '袁州区', 0),
(1191, 132, '奉新县', 0),
(1192, 132, '万载县', 0),
(1193, 132, '上高县', 0),
(1194, 132, '宜丰县', 0),
(1195, 132, '靖安县', 0),
(1196, 132, '铜鼓县', 0),
(1197, 132, '丰城市', 0),
(1198, 132, '樟树市', 0),
(1199, 132, '高安市', 0),
(1200, 133, '临川区', 0),
(1201, 133, '南城县', 0),
(1202, 133, '黎川县', 0),
(1203, 133, '南丰县', 0),
(1204, 133, '崇仁县', 0),
(1205, 133, '乐安县', 0),
(1206, 133, '宜黄县', 0),
(1207, 133, '金溪县', 0),
(1208, 133, '资溪县', 0),
(1209, 133, '东乡县', 0),
(1210, 133, '广昌县', 0),
(1211, 134, '信州区', 0),
(1212, 134, '上饶县', 0),
(1213, 134, '广丰县', 0),
(1214, 134, '玉山县', 0),
(1215, 134, '铅山县', 0),
(1216, 134, '横峰县', 0),
(1217, 134, '弋阳县', 0),
(1218, 134, '余干县', 0),
(1219, 134, '鄱阳县', 0),
(1220, 134, '万年县', 0),
(1221, 134, '婺源县', 0),
(1222, 134, '德兴市', 0),
(1223, 135, '历下区', 0),
(1224, 135, '市中区', 0),
(1225, 135, '槐荫区', 0),
(1226, 135, '天桥区', 0),
(1227, 135, '历城区', 0),
(1228, 135, '长清区', 0),
(1229, 135, '平阴县', 0),
(1230, 135, '济阳县', 0),
(1231, 135, '商河县', 0),
(1232, 135, '章丘市', 0),
(1233, 136, '市南区', 0),
(1234, 136, '市北区', 0),
(1235, 136, '四方区', 0),
(1236, 136, '黄岛区', 0),
(1237, 136, '崂山区', 0),
(1238, 136, '李沧区', 0),
(1239, 136, '城阳区', 0),
(1240, 136, '胶州市', 0),
(1241, 136, '即墨市', 0),
(1242, 136, '平度市', 0),
(1243, 136, '胶南市', 0),
(1244, 136, '莱西市', 0),
(1245, 137, '淄川区', 0),
(1246, 137, '张店区', 0),
(1247, 137, '博山区', 0),
(1248, 137, '临淄区', 0),
(1249, 137, '周村区', 0),
(1250, 137, '桓台县', 0),
(1251, 137, '高青县', 0),
(1252, 137, '沂源县', 0),
(1253, 138, '市中区', 0),
(1254, 138, '薛城区', 0),
(1255, 138, '峄城区', 0),
(1256, 138, '台儿庄区', 0),
(1257, 138, '山亭区', 0),
(1258, 138, '滕州市', 0),
(1259, 139, '东营区', 0),
(1260, 139, '河口区', 0),
(1261, 139, '垦利县', 0),
(1262, 139, '利津县', 0),
(1263, 139, '广饶县', 0),
(1264, 140, '芝罘区', 0),
(1265, 140, '福山区', 0),
(1266, 140, '牟平区', 0),
(1267, 140, '莱山区', 0),
(1268, 140, '长岛县', 0),
(1269, 140, '龙口市', 0),
(1270, 140, '莱阳市', 0),
(1271, 140, '莱州市', 0),
(1272, 140, '蓬莱市', 0),
(1273, 140, '招远市', 0),
(1274, 140, '栖霞市', 0),
(1275, 140, '海阳市', 0),
(1276, 141, '潍城区', 0),
(1277, 141, '寒亭区', 0),
(1278, 141, '坊子区', 0),
(1279, 141, '奎文区', 0),
(1280, 141, '临朐县', 0),
(1281, 141, '昌乐县', 0),
(1282, 141, '青州市', 0),
(1283, 141, '诸城市', 0),
(1284, 141, '寿光市', 0),
(1285, 141, '安丘市', 0),
(1286, 141, '高密市', 0),
(1287, 141, '昌邑市', 0),
(1288, 142, '市中区', 0),
(1289, 142, '任城区', 0),
(1290, 142, '微山县', 0),
(1291, 142, '鱼台县', 0),
(1292, 142, '金乡县', 0),
(1293, 142, '嘉祥县', 0),
(1294, 142, '汶上县', 0),
(1295, 142, '泗水县', 0),
(1296, 142, '梁山县', 0),
(1297, 142, '曲阜市', 0),
(1298, 142, '兖州市', 0),
(1299, 142, '邹城市', 0),
(1300, 143, '泰山区', 0),
(1301, 143, '岱岳区', 0),
(1302, 143, '宁阳县', 0),
(1303, 143, '东平县', 0),
(1304, 143, '新泰市', 0),
(1305, 143, '肥城市', 0),
(1306, 144, '环翠区', 0),
(1307, 144, '文登市', 0),
(1308, 144, '荣成市', 0),
(1309, 144, '乳山市', 0),
(1310, 145, '东港区', 0),
(1311, 145, '岚山区', 0),
(1312, 145, '五莲县', 0),
(1313, 145, '莒县', 0),
(1314, 146, '莱城区', 0),
(1315, 146, '钢城区', 0),
(1316, 147, '兰山区', 0),
(1317, 147, '罗庄区', 0),
(1318, 147, '河东区', 0),
(1319, 147, '沂南县', 0),
(1320, 147, '郯城县', 0),
(1321, 147, '沂水县', 0),
(1322, 147, '苍山县', 0),
(1323, 147, '费县', 0),
(1324, 147, '平邑县', 0),
(1325, 147, '莒南县', 0),
(1326, 147, '蒙阴县', 0),
(1327, 147, '临沭县', 0),
(1328, 148, '德城区', 0),
(1329, 148, '陵县', 0),
(1330, 148, '宁津县', 0),
(1331, 148, '庆云县', 0),
(1332, 148, '临邑县', 0),
(1333, 148, '齐河县', 0),
(1334, 148, '平原县', 0),
(1335, 148, '夏津县', 0),
(1336, 148, '武城县', 0),
(1337, 148, '乐陵市', 0),
(1338, 148, '禹城市', 0),
(1339, 149, '东昌府区', 0),
(1340, 149, '阳谷县', 0),
(1341, 149, '莘县', 0),
(1342, 149, '茌平县', 0),
(1343, 149, '东阿县', 0),
(1344, 149, '冠县', 0),
(1345, 149, '高唐县', 0),
(1346, 149, '临清市', 0),
(1347, 150, '滨城区', 0),
(1348, 150, '惠民县', 0),
(1349, 150, '阳信县', 0),
(1350, 150, '无棣县', 0),
(1351, 150, '沾化县', 0),
(1352, 150, '博兴县', 0),
(1353, 150, '邹平县', 0),
(1354, 151, '牡丹区', 0),
(1355, 151, '曹县', 0),
(1356, 151, '单县', 0),
(1357, 151, '成武县', 0),
(1358, 151, '巨野县', 0),
(1359, 151, '郓城县', 0),
(1360, 151, '鄄城县', 0),
(1361, 151, '定陶县', 0),
(1362, 151, '东明县', 0),
(1363, 152, '中原区', 0),
(1364, 152, '二七区', 0),
(1365, 152, '管城回族区', 0),
(1366, 152, '金水区', 0),
(1367, 152, '上街区', 0),
(1368, 152, '惠济区', 0),
(1369, 152, '中牟县', 0),
(1370, 152, '巩义市', 0),
(1371, 152, '荥阳市', 0),
(1372, 152, '新密市', 0),
(1373, 152, '新郑市', 0),
(1374, 152, '登封市', 0),
(1375, 153, '龙亭区', 0),
(1376, 153, '顺河回族区', 0),
(1377, 153, '鼓楼区', 0),
(1378, 153, '南关区', 0),
(1379, 153, '郊区', 0),
(1380, 153, '杞县', 0),
(1381, 153, '通许县', 0),
(1382, 153, '尉氏县', 0),
(1383, 153, '开封县', 0),
(1384, 153, '兰考县', 0),
(1385, 154, '老城区', 0),
(1386, 154, '西工区', 0),
(1387, 154, '廛河回族区', 0),
(1388, 154, '涧西区', 0),
(1389, 154, '吉利区', 0),
(1390, 154, '洛龙区', 0),
(1391, 154, '孟津县', 0),
(1392, 154, '新安县', 0),
(1393, 154, '栾川县', 0),
(1394, 154, '嵩县', 0),
(1395, 154, '汝阳县', 0),
(1396, 154, '宜阳县', 0),
(1397, 154, '洛宁县', 0),
(1398, 154, '伊川县', 0),
(1399, 154, '偃师市', 0),
(1400, 155, '新华区', 0),
(1401, 155, '卫东区', 0),
(1402, 155, '石龙区', 0),
(1403, 155, '湛河区', 0),
(1404, 155, '宝丰县', 0),
(1405, 155, '叶县', 0),
(1406, 155, '鲁山县', 0),
(1407, 155, '郏县', 0),
(1408, 155, '舞钢市', 0),
(1409, 155, '汝州市', 0),
(1410, 156, '文峰区', 0),
(1411, 156, '北关区', 0),
(1412, 156, '殷都区', 0),
(1413, 156, '龙安区', 0),
(1414, 156, '安阳县', 0),
(1415, 156, '汤阴县', 0),
(1416, 156, '滑县', 0),
(1417, 156, '内黄县', 0),
(1418, 156, '林州市', 0),
(1419, 157, '鹤山区', 0),
(1420, 157, '山城区', 0),
(1421, 157, '淇滨区', 0),
(1422, 157, '浚县', 0),
(1423, 157, '淇县', 0),
(1424, 158, '红旗区', 0),
(1425, 158, '卫滨区', 0),
(1426, 158, '凤泉区', 0),
(1427, 158, '牧野区', 0),
(1428, 158, '新乡县', 0),
(1429, 158, '获嘉县', 0),
(1430, 158, '原阳县', 0),
(1431, 158, '延津县', 0),
(1432, 158, '封丘县', 0),
(1433, 158, '长垣县', 0),
(1434, 158, '卫辉市', 0),
(1435, 158, '辉县市', 0),
(1436, 159, '解放区', 0),
(1437, 159, '中站区', 0),
(1438, 159, '马村区', 0),
(1439, 159, '山阳区', 0),
(1440, 159, '修武县', 0),
(1441, 159, '博爱县', 0),
(1442, 159, '武陟县', 0),
(1443, 159, '温县', 0),
(1444, 159, '济源市', 0),
(1445, 159, '沁阳市', 0),
(1446, 159, '孟州市', 0),
(1447, 160, '华龙区', 0),
(1448, 160, '清丰县', 0),
(1449, 160, '南乐县', 0),
(1450, 160, '范县', 0),
(1451, 160, '台前县', 0),
(1452, 160, '濮阳县', 0),
(1453, 161, '魏都区', 0),
(1454, 161, '许昌县', 0),
(1455, 161, '鄢陵县', 0),
(1456, 161, '襄城县', 0),
(1457, 161, '禹州市', 0),
(1458, 161, '长葛市', 0),
(1459, 162, '源汇区', 0),
(1460, 162, '郾城区', 0),
(1461, 162, '召陵区', 0),
(1462, 162, '舞阳县', 0),
(1463, 162, '临颍县', 0),
(1464, 163, '市辖区', 0),
(1465, 163, '湖滨区', 0),
(1466, 163, '渑池县', 0),
(1467, 163, '陕县', 0),
(1468, 163, '卢氏县', 0),
(1469, 163, '义马市', 0),
(1470, 163, '灵宝市', 0),
(1471, 164, '宛城区', 0),
(1472, 164, '卧龙区', 0),
(1473, 164, '南召县', 0),
(1474, 164, '方城县', 0),
(1475, 164, '西峡县', 0),
(1476, 164, '镇平县', 0),
(1477, 164, '内乡县', 0),
(1478, 164, '淅川县', 0),
(1479, 164, '社旗县', 0),
(1480, 164, '唐河县', 0),
(1481, 164, '新野县', 0),
(1482, 164, '桐柏县', 0),
(1483, 164, '邓州市', 0),
(1484, 165, '梁园区', 0),
(1485, 165, '睢阳区', 0),
(1486, 165, '民权县', 0),
(1487, 165, '睢县', 0),
(1488, 165, '宁陵县', 0),
(1489, 165, '柘城县', 0),
(1490, 165, '虞城县', 0),
(1491, 165, '夏邑县', 0),
(1492, 165, '永城市', 0),
(1493, 166, '浉河区', 0),
(1494, 166, '平桥区', 0),
(1495, 166, '罗山县', 0),
(1496, 166, '光山县', 0),
(1497, 166, '新县', 0),
(1498, 166, '商城县', 0),
(1499, 166, '固始县', 0),
(1500, 166, '潢川县', 0),
(1501, 166, '淮滨县', 0),
(1502, 166, '息县', 0),
(1503, 167, '川汇区', 0),
(1504, 167, '扶沟县', 0),
(1505, 167, '西华县', 0),
(1506, 167, '商水县', 0),
(1507, 167, '沈丘县', 0),
(1508, 167, '郸城县', 0),
(1509, 167, '淮阳县', 0),
(1510, 167, '太康县', 0),
(1511, 167, '鹿邑县', 0),
(1512, 167, '项城市', 0),
(1513, 168, '驿城区', 0),
(1514, 168, '西平县', 0),
(1515, 168, '上蔡县', 0),
(1516, 168, '平舆县', 0),
(1517, 168, '正阳县', 0),
(1518, 168, '确山县', 0),
(1519, 168, '泌阳县', 0),
(1520, 168, '汝南县', 0),
(1521, 168, '遂平县', 0),
(1522, 168, '新蔡县', 0),
(1523, 169, '江岸区', 0),
(1524, 169, '江汉区', 0),
(1525, 169, '硚口区', 0),
(1526, 169, '汉阳区', 0),
(1527, 169, '武昌区', 0),
(1528, 169, '青山区', 0),
(1529, 169, '洪山区', 0),
(1530, 169, '东西湖区', 0),
(1531, 169, '汉南区', 0),
(1532, 169, '蔡甸区', 0),
(1533, 169, '江夏区', 0),
(1534, 169, '黄陂区', 0),
(1535, 169, '新洲区', 0),
(1536, 170, '黄石港区', 0),
(1537, 170, '西塞山区', 0),
(1538, 170, '下陆区', 0),
(1539, 170, '铁山区', 0),
(1540, 170, '阳新县', 0),
(1541, 170, '大冶市', 0),
(1542, 171, '茅箭区', 0),
(1543, 171, '张湾区', 0),
(1544, 171, '郧县', 0),
(1545, 171, '郧西县', 0),
(1546, 171, '竹山县', 0),
(1547, 171, '竹溪县', 0),
(1548, 171, '房县', 0),
(1549, 171, '丹江口市', 0),
(1550, 172, '西陵区', 0),
(1551, 172, '伍家岗区', 0),
(1552, 172, '点军区', 0),
(1553, 172, '猇亭区', 0),
(1554, 172, '夷陵区', 0),
(1555, 172, '远安县', 0),
(1556, 172, '兴山县', 0),
(1557, 172, '秭归县', 0),
(1558, 172, '长阳土家族自治县', 0),
(1559, 172, '五峰土家族自治县', 0),
(1560, 172, '宜都市', 0),
(1561, 172, '当阳市', 0),
(1562, 172, '枝江市', 0),
(1563, 173, '襄城区', 0),
(1564, 173, '樊城区', 0),
(1565, 173, '襄阳区', 0),
(1566, 173, '南漳县', 0),
(1567, 173, '谷城县', 0),
(1568, 173, '保康县', 0),
(1569, 173, '老河口市', 0),
(1570, 173, '枣阳市', 0),
(1571, 173, '宜城市', 0),
(1572, 174, '梁子湖区', 0),
(1573, 174, '华容区', 0),
(1574, 174, '鄂城区', 0),
(1575, 175, '东宝区', 0),
(1576, 175, '掇刀区', 0),
(1577, 175, '京山县', 0),
(1578, 175, '沙洋县', 0),
(1579, 175, '钟祥市', 0),
(1580, 176, '孝南区', 0),
(1581, 176, '孝昌县', 0),
(1582, 176, '大悟县', 0),
(1583, 176, '云梦县', 0),
(1584, 176, '应城市', 0),
(1585, 176, '安陆市', 0),
(1586, 176, '汉川市', 0),
(1587, 177, '沙市区', 0),
(1588, 177, '荆州区', 0),
(1589, 177, '公安县', 0),
(1590, 177, '监利县', 0),
(1591, 177, '江陵县', 0),
(1592, 177, '石首市', 0),
(1593, 177, '洪湖市', 0),
(1594, 177, '松滋市', 0),
(1595, 178, '黄州区', 0),
(1596, 178, '团风县', 0),
(1597, 178, '红安县', 0),
(1598, 178, '罗田县', 0),
(1599, 178, '英山县', 0),
(1600, 178, '浠水县', 0),
(1601, 178, '蕲春县', 0),
(1602, 178, '黄梅县', 0),
(1603, 178, '麻城市', 0),
(1604, 178, '武穴市', 0),
(1605, 179, '咸安区', 0),
(1606, 179, '嘉鱼县', 0),
(1607, 179, '通城县', 0),
(1608, 179, '崇阳县', 0),
(1609, 179, '通山县', 0),
(1610, 179, '赤壁市', 0),
(1611, 180, '曾都区', 0),
(1612, 180, '广水市', 0),
(1613, 181, '恩施市', 0),
(1614, 181, '利川市', 0),
(1615, 181, '建始县', 0),
(1616, 181, '巴东县', 0),
(1617, 181, '宣恩县', 0),
(1618, 181, '咸丰县', 0),
(1619, 181, '来凤县', 0),
(1620, 181, '鹤峰县', 0),
(1621, 182, '仙桃市', 0),
(1622, 182, '潜江市', 0),
(1623, 182, '天门市', 0),
(1624, 182, '神农架林区', 0),
(1625, 183, '芙蓉区', 0),
(1626, 183, '天心区', 0),
(1627, 183, '岳麓区', 0),
(1628, 183, '开福区', 0),
(1629, 183, '雨花区', 0),
(1630, 183, '长沙县', 0),
(1631, 183, '望城县', 0),
(1632, 183, '宁乡县', 0),
(1633, 183, '浏阳市', 0),
(1634, 184, '荷塘区', 0),
(1635, 184, '芦淞区', 0),
(1636, 184, '石峰区', 0),
(1637, 184, '天元区', 0),
(1638, 184, '株洲县', 0),
(1639, 184, '攸县', 0),
(1640, 184, '茶陵县', 0),
(1641, 184, '炎陵县', 0),
(1642, 184, '醴陵市', 0),
(1643, 185, '雨湖区', 0),
(1644, 185, '岳塘区', 0),
(1645, 185, '湘潭县', 0),
(1646, 185, '湘乡市', 0),
(1647, 185, '韶山市', 0),
(1648, 186, '珠晖区', 0),
(1649, 186, '雁峰区', 0),
(1650, 186, '石鼓区', 0),
(1651, 186, '蒸湘区', 0),
(1652, 186, '南岳区', 0),
(1653, 186, '衡阳县', 0),
(1654, 186, '衡南县', 0),
(1655, 186, '衡山县', 0),
(1656, 186, '衡东县', 0),
(1657, 186, '祁东县', 0),
(1658, 186, '耒阳市', 0),
(1659, 186, '常宁市', 0),
(1660, 187, '双清区', 0),
(1661, 187, '大祥区', 0),
(1662, 187, '北塔区', 0),
(1663, 187, '邵东县', 0),
(1664, 187, '新邵县', 0),
(1665, 187, '邵阳县', 0),
(1666, 187, '隆回县', 0),
(1667, 187, '洞口县', 0),
(1668, 187, '绥宁县', 0),
(1669, 187, '新宁县', 0),
(1670, 187, '城步苗族自治县', 0),
(1671, 187, '武冈市', 0),
(1672, 188, '岳阳楼区', 0),
(1673, 188, '云溪区', 0),
(1674, 188, '君山区', 0),
(1675, 188, '岳阳县', 0),
(1676, 188, '华容县', 0),
(1677, 188, '湘阴县', 0),
(1678, 188, '平江县', 0),
(1679, 188, '汨罗市', 0),
(1680, 188, '临湘市', 0),
(1681, 189, '武陵区', 0),
(1682, 189, '鼎城区', 0),
(1683, 189, '安乡县', 0),
(1684, 189, '汉寿县', 0),
(1685, 189, '澧县', 0),
(1686, 189, '临澧县', 0),
(1687, 189, '桃源县', 0),
(1688, 189, '石门县', 0),
(1689, 189, '津市市', 0),
(1690, 190, '永定区', 0),
(1691, 190, '武陵源区', 0),
(1692, 190, '慈利县', 0),
(1693, 190, '桑植县', 0),
(1694, 191, '资阳区', 0),
(1695, 191, '赫山区', 0),
(1696, 191, '南县', 0),
(1697, 191, '桃江县', 0),
(1698, 191, '安化县', 0),
(1699, 191, '沅江市', 0),
(1700, 192, '北湖区', 0),
(1701, 192, '苏仙区', 0),
(1702, 192, '桂阳县', 0),
(1703, 192, '宜章县', 0),
(1704, 192, '永兴县', 0),
(1705, 192, '嘉禾县', 0),
(1706, 192, '临武县', 0),
(1707, 192, '汝城县', 0),
(1708, 192, '桂东县', 0),
(1709, 192, '安仁县', 0),
(1710, 192, '资兴市', 0),
(1711, 193, '芝山区', 0),
(1712, 193, '冷水滩区', 0),
(1713, 193, '祁阳县', 0),
(1714, 193, '东安县', 0),
(1715, 193, '双牌县', 0),
(1716, 193, '道县', 0),
(1717, 193, '江永县', 0),
(1718, 193, '宁远县', 0),
(1719, 193, '蓝山县', 0),
(1720, 193, '新田县', 0),
(1721, 193, '江华瑶族自治县', 0),
(1722, 194, '鹤城区', 0),
(1723, 194, '中方县', 0),
(1724, 194, '沅陵县', 0),
(1725, 194, '辰溪县', 0),
(1726, 194, '溆浦县', 0),
(1727, 194, '会同县', 0),
(1728, 194, '麻阳苗族自治县', 0),
(1729, 194, '新晃侗族自治县', 0),
(1730, 194, '芷江侗族自治县', 0),
(1731, 194, '靖州苗族侗族自治县', 0),
(1732, 194, '通道侗族自治县', 0),
(1733, 194, '洪江市', 0),
(1734, 195, '娄星区', 0),
(1735, 195, '双峰县', 0),
(1736, 195, '新化县', 0),
(1737, 195, '冷水江市', 0),
(1738, 195, '涟源市', 0),
(1739, 196, '吉首市', 0),
(1740, 196, '泸溪县', 0),
(1741, 196, '凤凰县', 0),
(1742, 196, '花垣县', 0),
(1743, 196, '保靖县', 0),
(1744, 196, '古丈县', 0),
(1745, 196, '永顺县', 0),
(1746, 196, '龙山县', 0),
(1747, 197, '东山区', 0),
(1748, 197, '荔湾区', 0),
(1749, 197, '越秀区', 0),
(1750, 197, '海珠区', 0),
(1751, 197, '天河区', 0),
(1752, 197, '芳村区', 0),
(1753, 197, '白云区', 0),
(1754, 197, '黄埔区', 0),
(1755, 197, '番禺区', 0),
(1756, 197, '花都区', 0),
(1757, 197, '增城市', 0),
(1759, 198, '武江区', 0),
(1760, 198, '浈江区', 0),
(1761, 198, '曲江区', 0),
(1762, 198, '始兴县', 0),
(1763, 198, '仁化县', 0),
(1764, 198, '翁源县', 0),
(1765, 198, '乳源瑶族自治县', 0),
(1766, 198, '新丰县', 0),
(1767, 198, '乐昌市', 0),
(1768, 198, '南雄市', 0),
(1769, 199, '罗湖区', 0),
(1770, 199, '福田区', 0),
(1771, 199, '南山区', 0),
(1772, 199, '宝安区', 0),
(1773, 199, '龙岗区', 0),
(1774, 199, '盐田区', 0),
(1775, 200, '香洲区', 0),
(1776, 200, '斗门区', 0),
(1777, 200, '金湾区', 0),
(1778, 201, '龙湖区', 0),
(1779, 201, '金平区', 0),
(1780, 201, '濠江区', 0),
(1781, 201, '潮阳区', 0),
(1782, 201, '潮南区', 0),
(1783, 201, '澄海区', 0),
(1784, 201, '南澳县', 0),
(1785, 202, '禅城区', 0),
(1786, 202, '南海区', 0),
(1787, 202, '顺德区', 0),
(1788, 202, '三水区', 0),
(1789, 202, '高明区', 0),
(1790, 203, '蓬江区', 0),
(1791, 203, '江海区', 0),
(1792, 203, '新会区', 0),
(1793, 203, '台山市', 0),
(1794, 203, '开平市', 0),
(1795, 203, '鹤山市', 0),
(1796, 203, '恩平市', 0),
(1797, 204, '赤坎区', 0),
(1798, 204, '霞山区', 0),
(1799, 204, '坡头区', 0),
(1800, 204, '麻章区', 0),
(1801, 204, '遂溪县', 0),
(1802, 204, '徐闻县', 0),
(1803, 204, '廉江市', 0),
(1804, 204, '雷州市', 0),
(1805, 204, '吴川市', 0),
(1806, 205, '茂南区', 0),
(1807, 205, '茂港区', 0),
(1808, 205, '电白县', 0),
(1809, 205, '高州市', 0),
(1810, 205, '化州市', 0),
(1811, 205, '信宜市', 0),
(1812, 206, '端州区', 0),
(1813, 206, '鼎湖区', 0),
(1814, 206, '广宁县', 0),
(1815, 206, '怀集县', 0),
(1816, 206, '封开县', 0),
(1817, 206, '德庆县', 0),
(1818, 206, '高要市', 0),
(1819, 206, '四会市', 0),
(1820, 207, '惠城区', 0),
(1821, 207, '惠阳区', 0),
(1822, 207, '博罗县', 0),
(1823, 207, '惠东县', 0),
(1824, 207, '龙门县', 0),
(1825, 208, '梅江区', 0),
(1826, 208, '梅县', 0),
(1827, 208, '大埔县', 0),
(1828, 208, '丰顺县', 0),
(1829, 208, '五华县', 0),
(1830, 208, '平远县', 0),
(1831, 208, '蕉岭县', 0),
(1832, 208, '兴宁市', 0),
(1833, 209, '城区', 0),
(1834, 209, '海丰县', 0),
(1835, 209, '陆河县', 0),
(1836, 209, '陆丰市', 0),
(1837, 210, '源城区', 0),
(1838, 210, '紫金县', 0),
(1839, 210, '龙川县', 0),
(1840, 210, '连平县', 0),
(1841, 210, '和平县', 0),
(1842, 210, '东源县', 0),
(1843, 211, '江城区', 0),
(1844, 211, '阳西县', 0),
(1845, 211, '阳东县', 0),
(1846, 211, '阳春市', 0),
(1847, 212, '清城区', 0),
(1848, 212, '佛冈县', 0),
(1849, 212, '阳山县', 0),
(1850, 212, '连山壮族瑶族自治县', 0),
(1851, 212, '连南瑶族自治县', 0),
(1852, 212, '清新县', 0),
(1853, 212, '英德市', 0),
(1854, 212, '连州市', 0),
(1855, 215, '湘桥区', 0),
(1856, 215, '潮安县', 0),
(1857, 215, '饶平县', 0),
(1858, 216, '榕城区', 0),
(1859, 216, '揭东县', 0),
(1860, 216, '揭西县', 0),
(1861, 216, '惠来县', 0),
(1862, 216, '普宁市', 0),
(1863, 217, '云城区', 0),
(1864, 217, '新兴县', 0),
(1865, 217, '郁南县', 0),
(1866, 217, '云安县', 0),
(1867, 217, '罗定市', 0),
(1868, 218, '兴宁区', 0),
(1869, 218, '青秀区', 0),
(1870, 218, '江南区', 0),
(1871, 218, '西乡塘区', 0),
(1872, 218, '良庆区', 0),
(1873, 218, '邕宁区', 0),
(1874, 218, '武鸣县', 0),
(1875, 218, '隆安县', 0),
(1876, 218, '马山县', 0),
(1877, 218, '上林县', 0),
(1878, 218, '宾阳县', 0),
(1879, 218, '横县', 0),
(1880, 219, '城中区', 0),
(1881, 219, '鱼峰区', 0),
(1882, 219, '柳南区', 0),
(1883, 219, '柳北区', 0),
(1884, 219, '柳江县', 0),
(1885, 219, '柳城县', 0),
(1886, 219, '鹿寨县', 0),
(1887, 219, '融安县', 0),
(1888, 219, '融水苗族自治县', 0),
(1889, 219, '三江侗族自治县', 0),
(1890, 220, '秀峰区', 0),
(1891, 220, '叠彩区', 0),
(1892, 220, '象山区', 0),
(1893, 220, '七星区', 0),
(1894, 220, '雁山区', 0),
(1895, 220, '阳朔县', 0),
(1896, 220, '临桂县', 0),
(1897, 220, '灵川县', 0),
(1898, 220, '全州县', 0),
(1899, 220, '兴安县', 0),
(1900, 220, '永福县', 0),
(1901, 220, '灌阳县', 0),
(1902, 220, '龙胜各族自治县', 0),
(1903, 220, '资源县', 0),
(1904, 220, '平乐县', 0),
(1905, 220, '荔蒲县', 0),
(1906, 220, '恭城瑶族自治县', 0),
(1907, 221, '万秀区', 0),
(1908, 221, '蝶山区', 0),
(1909, 221, '长洲区', 0),
(1910, 221, '苍梧县', 0),
(1911, 221, '藤县', 0),
(1912, 221, '蒙山县', 0),
(1913, 221, '岑溪市', 0),
(1914, 222, '海城区', 0),
(1915, 222, '银海区', 0),
(1916, 222, '铁山港区', 0),
(1917, 222, '合浦县', 0),
(1918, 223, '港口区', 0),
(1919, 223, '防城区', 0),
(1920, 223, '上思县', 0),
(1921, 223, '东兴市', 0),
(1922, 224, '钦南区', 0),
(1923, 224, '钦北区', 0),
(1924, 224, '灵山县', 0),
(1925, 224, '浦北县', 0),
(1926, 225, '港北区', 0),
(1927, 225, '港南区', 0),
(1928, 225, '覃塘区', 0),
(1929, 225, '平南县', 0),
(1930, 225, '桂平市', 0),
(1931, 226, '玉州区', 0),
(1932, 226, '容县', 0),
(1933, 226, '陆川县', 0),
(1934, 226, '博白县', 0),
(1935, 226, '兴业县', 0),
(1936, 226, '北流市', 0),
(1937, 227, '右江区', 0),
(1938, 227, '田阳县', 0),
(1939, 227, '田东县', 0),
(1940, 227, '平果县', 0),
(1941, 227, '德保县', 0),
(1942, 227, '靖西县', 0),
(1943, 227, '那坡县', 0),
(1944, 227, '凌云县', 0),
(1945, 227, '乐业县', 0),
(1946, 227, '田林县', 0),
(1947, 227, '西林县', 0),
(1948, 227, '隆林各族自治县', 0),
(1949, 228, '八步区', 0),
(1950, 228, '昭平县', 0),
(1951, 228, '钟山县', 0),
(1952, 228, '富川瑶族自治县', 0),
(1953, 229, '金城江区', 0),
(1954, 229, '南丹县', 0),
(1955, 229, '天峨县', 0),
(1956, 229, '凤山县', 0),
(1957, 229, '东兰县', 0),
(1958, 229, '罗城仫佬族自治县', 0),
(1959, 229, '环江毛南族自治县', 0),
(1960, 229, '巴马瑶族自治县', 0),
(1961, 229, '都安瑶族自治县', 0),
(1962, 229, '大化瑶族自治县', 0),
(1963, 229, '宜州市', 0),
(1964, 230, '兴宾区', 0),
(1965, 230, '忻城县', 0),
(1966, 230, '象州县', 0),
(1967, 230, '武宣县', 0),
(1968, 230, '金秀瑶族自治县', 0),
(1969, 230, '合山市', 0),
(1970, 231, '江洲区', 0),
(1971, 231, '扶绥县', 0),
(1972, 231, '宁明县', 0),
(1973, 231, '龙州县', 0),
(1974, 231, '大新县', 0),
(1975, 231, '天等县', 0),
(1976, 231, '凭祥市', 0),
(1977, 232, '秀英区', 0),
(1978, 232, '龙华区', 0),
(1979, 232, '琼山区', 0),
(1980, 232, '美兰区', 0),
(1981, 233, '五指山市', 0),
(1982, 233, '琼海市', 0),
(1983, 233, '儋州市', 0),
(1984, 233, '文昌市', 0),
(1985, 233, '万宁市', 0),
(1986, 233, '东方市', 0),
(1987, 233, '定安县', 0),
(1988, 233, '屯昌县', 0),
(1989, 233, '澄迈县', 0),
(1990, 233, '临高县', 0),
(1991, 233, '白沙黎族自治县', 0),
(1992, 233, '昌江黎族自治县', 0),
(1993, 233, '乐东黎族自治县', 0),
(1994, 233, '陵水黎族自治县', 0),
(1995, 233, '保亭黎族苗族自治县', 0),
(1996, 233, '琼中黎族苗族自治县', 0),
(1997, 233, '西沙群岛', 0),
(1998, 233, '南沙群岛', 0),
(1999, 233, '中沙群岛的岛礁及其海域', 0),
(2000, 234, '万州区', 0),
(2001, 234, '涪陵区', 0),
(2002, 234, '渝中区', 0),
(2003, 234, '大渡口区', 0),
(2004, 234, '江北区', 0),
(2005, 234, '沙坪坝区', 0),
(2006, 234, '九龙坡区', 0),
(2007, 234, '南岸区', 0),
(2008, 234, '北碚区', 0),
(2009, 234, '万盛区', 0),
(2010, 234, '双桥区', 0),
(2011, 234, '渝北区', 0),
(2012, 234, '巴南区', 0),
(2013, 234, '黔江区', 0),
(2014, 234, '长寿区', 0),
(2015, 234, '綦江县', 0),
(2016, 234, '潼南县', 0),
(2017, 234, '铜梁县', 0),
(2018, 234, '大足县', 0),
(2019, 234, '荣昌县', 0),
(2020, 234, '璧山县', 0),
(2021, 234, '梁平县', 0),
(2022, 234, '城口县', 0),
(2023, 234, '丰都县', 0),
(2024, 234, '垫江县', 0),
(2025, 234, '武隆县', 0),
(2026, 234, '忠县', 0),
(2027, 234, '开县', 0),
(2028, 234, '云阳县', 0),
(2029, 234, '奉节县', 0),
(2030, 234, '巫山县', 0),
(2031, 234, '巫溪县', 0),
(2032, 234, '石柱土家族自治县', 0),
(2033, 234, '秀山土家族苗族自治县', 0),
(2034, 234, '酉阳土家族苗族自治县', 0),
(2035, 234, '彭水苗族土家族自治县', 0),
(2036, 234, '江津市', 0),
(2037, 234, '合川市', 0),
(2038, 234, '永川市', 0),
(2039, 234, '南川市', 0),
(2040, 235, '锦江区', 0),
(2041, 235, '青羊区', 0),
(2042, 235, '金牛区', 0),
(2043, 235, '武侯区', 0),
(2044, 235, '成华区', 0),
(2045, 235, '龙泉驿区', 0),
(2046, 235, '青白江区', 0),
(2047, 235, '新都区', 0),
(2048, 235, '温江区', 0),
(2049, 235, '金堂县', 0),
(2050, 235, '双流县', 0),
(2051, 235, '郫县', 0),
(2052, 235, '大邑县', 0),
(2053, 235, '蒲江县', 0),
(2054, 235, '新津县', 0),
(2055, 235, '都江堰市', 0),
(2056, 235, '彭州市', 0),
(2057, 235, '邛崃市', 0),
(2058, 235, '崇州市', 0),
(2059, 236, '自流井区', 0),
(2060, 236, '贡井区', 0),
(2061, 236, '大安区', 0),
(2062, 236, '沿滩区', 0),
(2063, 236, '荣县', 0),
(2064, 236, '富顺县', 0),
(2065, 237, '东区', 0),
(2066, 237, '西区', 0),
(2067, 237, '仁和区', 0),
(2068, 237, '米易县', 0),
(2069, 237, '盐边县', 0),
(2070, 238, '江阳区', 0),
(2071, 238, '纳溪区', 0),
(2072, 238, '龙马潭区', 0),
(2073, 238, '泸县', 0),
(2074, 238, '合江县', 0),
(2075, 238, '叙永县', 0),
(2076, 238, '古蔺县', 0),
(2077, 239, '旌阳区', 0),
(2078, 239, '中江县', 0),
(2079, 239, '罗江县', 0),
(2080, 239, '广汉市', 0),
(2081, 239, '什邡市', 0),
(2082, 239, '绵竹市', 0),
(2083, 240, '涪城区', 0),
(2084, 240, '游仙区', 0),
(2085, 240, '三台县', 0),
(2086, 240, '盐亭县', 0),
(2087, 240, '安县', 0),
(2088, 240, '梓潼县', 0),
(2089, 240, '北川羌族自治县', 0),
(2090, 240, '平武县', 0),
(2091, 240, '江油市', 0),
(2092, 241, '市中区', 0),
(2093, 241, '元坝区', 0),
(2094, 241, '朝天区', 0),
(2095, 241, '旺苍县', 0),
(2096, 241, '青川县', 0),
(2097, 241, '剑阁县', 0),
(2098, 241, '苍溪县', 0),
(2099, 242, '船山区', 0),
(2100, 242, '安居区', 0),
(2101, 242, '蓬溪县', 0),
(2102, 242, '射洪县', 0),
(2103, 242, '大英县', 0),
(2104, 243, '市中区', 0),
(2105, 243, '东兴区', 0),
(2106, 243, '威远县', 0),
(2107, 243, '资中县', 0),
(2108, 243, '隆昌县', 0),
(2109, 244, '市中区', 0),
(2110, 244, '沙湾区', 0),
(2111, 244, '五通桥区', 0),
(2112, 244, '金口河区', 0),
(2113, 244, '犍为县', 0),
(2114, 244, '井研县', 0),
(2115, 244, '夹江县', 0),
(2116, 244, '沐川县', 0),
(2117, 244, '峨边彝族自治县', 0),
(2118, 244, '马边彝族自治县', 0),
(2119, 244, '峨眉山市', 0),
(2120, 245, '顺庆区', 0),
(2121, 245, '高坪区', 0),
(2122, 245, '嘉陵区', 0),
(2123, 245, '南部县', 0),
(2124, 245, '营山县', 0),
(2125, 245, '蓬安县', 0),
(2126, 245, '仪陇县', 0),
(2127, 245, '西充县', 0),
(2128, 245, '阆中市', 0),
(2129, 246, '东坡区', 0),
(2130, 246, '仁寿县', 0),
(2131, 246, '彭山县', 0),
(2132, 246, '洪雅县', 0),
(2133, 246, '丹棱县', 0),
(2134, 246, '青神县', 0),
(2135, 247, '翠屏区', 0),
(2136, 247, '宜宾县', 0),
(2137, 247, '南溪县', 0),
(2138, 247, '江安县', 0),
(2139, 247, '长宁县', 0),
(2140, 247, '高县', 0),
(2141, 247, '珙县', 0),
(2142, 247, '筠连县', 0),
(2143, 247, '兴文县', 0),
(2144, 247, '屏山县', 0),
(2145, 248, '广安区', 0),
(2146, 248, '岳池县', 0),
(2147, 248, '武胜县', 0),
(2148, 248, '邻水县', 0),
(2149, 248, '华蓥市', 0),
(2150, 249, '通川区', 0),
(2151, 249, '达县', 0),
(2152, 249, '宣汉县', 0),
(2153, 249, '开江县', 0),
(2154, 249, '大竹县', 0),
(2155, 249, '渠县', 0),
(2156, 249, '万源市', 0),
(2157, 250, '雨城区', 0),
(2158, 250, '名山县', 0),
(2159, 250, '荥经县', 0),
(2160, 250, '汉源县', 0),
(2161, 250, '石棉县', 0),
(2162, 250, '天全县', 0),
(2163, 250, '芦山县', 0),
(2164, 250, '宝兴县', 0),
(2165, 251, '巴州区', 0),
(2166, 251, '通江县', 0),
(2167, 251, '南江县', 0),
(2168, 251, '平昌县', 0),
(2169, 252, '雁江区', 0),
(2170, 252, '安岳县', 0),
(2171, 252, '乐至县', 0),
(2172, 252, '简阳市', 0),
(2173, 253, '汶川县', 0),
(2174, 253, '理县', 0),
(2175, 253, '茂县', 0),
(2176, 253, '松潘县', 0),
(2177, 253, '九寨沟县', 0),
(2178, 253, '金川县', 0),
(2179, 253, '小金县', 0),
(2180, 253, '黑水县', 0),
(2181, 253, '马尔康县', 0),
(2182, 253, '壤塘县', 0),
(2183, 253, '阿坝县', 0),
(2184, 253, '若尔盖县', 0),
(2185, 253, '红原县', 0),
(2186, 254, '康定县', 0),
(2187, 254, '泸定县', 0),
(2188, 254, '丹巴县', 0),
(2189, 254, '九龙县', 0),
(2190, 254, '雅江县', 0),
(2191, 254, '道孚县', 0),
(2192, 254, '炉霍县', 0),
(2193, 254, '甘孜县', 0),
(2194, 254, '新龙县', 0),
(2195, 254, '德格县', 0),
(2196, 254, '白玉县', 0),
(2197, 254, '石渠县', 0),
(2198, 254, '色达县', 0),
(2199, 254, '理塘县', 0),
(2200, 254, '巴塘县', 0),
(2201, 254, '乡城县', 0),
(2202, 254, '稻城县', 0),
(2203, 254, '得荣县', 0),
(2204, 255, '西昌市', 0),
(2205, 255, '木里藏族自治县', 0),
(2206, 255, '盐源县', 0),
(2207, 255, '德昌县', 0),
(2208, 255, '会理县', 0),
(2209, 255, '会东县', 0),
(2210, 255, '宁南县', 0),
(2211, 255, '普格县', 0),
(2212, 255, '布拖县', 0),
(2213, 255, '金阳县', 0),
(2214, 255, '昭觉县', 0),
(2215, 255, '喜德县', 0),
(2216, 255, '冕宁县', 0),
(2217, 255, '越西县', 0),
(2218, 255, '甘洛县', 0),
(2219, 255, '美姑县', 0),
(2220, 255, '雷波县', 0),
(2221, 256, '南明区', 0),
(2222, 256, '云岩区', 0),
(2223, 256, '花溪区', 0),
(2224, 256, '乌当区', 0),
(2225, 256, '白云区', 0),
(2226, 256, '小河区', 0),
(2227, 256, '开阳县', 0),
(2228, 256, '息烽县', 0),
(2229, 256, '修文县', 0),
(2230, 256, '清镇市', 0),
(2231, 257, '钟山区', 0),
(2232, 257, '六枝特区', 0),
(2233, 257, '水城县', 0),
(2234, 257, '盘县', 0),
(2235, 258, '红花岗区', 0),
(2236, 258, '汇川区', 0),
(2237, 258, '遵义县', 0),
(2238, 258, '桐梓县', 0),
(2239, 258, '绥阳县', 0),
(2240, 258, '正安县', 0),
(2241, 258, '道真仡佬族苗族自治县', 0),
(2242, 258, '务川仡佬族苗族自治县', 0),
(2243, 258, '凤冈县', 0),
(2244, 258, '湄潭县', 0),
(2245, 258, '余庆县', 0),
(2246, 258, '习水县', 0),
(2247, 258, '赤水市', 0),
(2248, 258, '仁怀市', 0),
(2249, 259, '西秀区', 0),
(2250, 259, '平坝县', 0),
(2251, 259, '普定县', 0),
(2252, 259, '镇宁布依族苗族自治县', 0),
(2253, 259, '关岭布依族苗族自治县', 0),
(2254, 259, '紫云苗族布依族自治县', 0),
(2255, 260, '铜仁市', 0),
(2256, 260, '江口县', 0),
(2257, 260, '玉屏侗族自治县', 0),
(2258, 260, '石阡县', 0),
(2259, 260, '思南县', 0),
(2260, 260, '印江土家族苗族自治县', 0),
(2261, 260, '德江县', 0),
(2262, 260, '沿河土家族自治县', 0),
(2263, 260, '松桃苗族自治县', 0),
(2264, 260, '万山特区', 0),
(2265, 261, '兴义市', 0),
(2266, 261, '兴仁县', 0),
(2267, 261, '普安县', 0),
(2268, 261, '晴隆县', 0),
(2269, 261, '贞丰县', 0),
(2270, 261, '望谟县', 0),
(2271, 261, '册亨县', 0),
(2272, 261, '安龙县', 0),
(2273, 262, '毕节市', 0),
(2274, 262, '大方县', 0),
(2275, 262, '黔西县', 0),
(2276, 262, '金沙县', 0),
(2277, 262, '织金县', 0),
(2278, 262, '纳雍县', 0),
(2279, 262, '威宁彝族回族苗族自治县', 0),
(2280, 262, '赫章县', 0),
(2281, 263, '凯里市', 0),
(2282, 263, '黄平县', 0),
(2283, 263, '施秉县', 0),
(2284, 263, '三穗县', 0),
(2285, 263, '镇远县', 0),
(2286, 263, '岑巩县', 0),
(2287, 263, '天柱县', 0),
(2288, 263, '锦屏县', 0),
(2289, 263, '剑河县', 0),
(2290, 263, '台江县', 0),
(2291, 263, '黎平县', 0),
(2292, 263, '榕江县', 0),
(2293, 263, '从江县', 0),
(2294, 263, '雷山县', 0),
(2295, 263, '麻江县', 0),
(2296, 263, '丹寨县', 0),
(2297, 264, '都匀市', 0),
(2298, 264, '福泉市', 0),
(2299, 264, '荔波县', 0),
(2300, 264, '贵定县', 0),
(2301, 264, '瓮安县', 0),
(2302, 264, '独山县', 0),
(2303, 264, '平塘县', 0),
(2304, 264, '罗甸县', 0),
(2305, 264, '长顺县', 0),
(2306, 264, '龙里县', 0),
(2307, 264, '惠水县', 0),
(2308, 264, '三都水族自治县', 0),
(2309, 265, '五华区', 0),
(2310, 265, '盘龙区', 0),
(2311, 265, '官渡区', 0),
(2312, 265, '西山区', 0),
(2313, 265, '东川区', 0),
(2314, 265, '呈贡县', 0),
(2315, 265, '晋宁县', 0),
(2316, 265, '富民县', 0),
(2317, 265, '宜良县', 0),
(2318, 265, '石林彝族自治县', 0),
(2319, 265, '嵩明县', 0),
(2320, 265, '禄劝彝族苗族自治县', 0),
(2321, 265, '寻甸回族彝族自治县', 0),
(2322, 265, '安宁市', 0),
(2323, 266, '麒麟区', 0),
(2324, 266, '马龙县', 0),
(2325, 266, '陆良县', 0),
(2326, 266, '师宗县', 0),
(2327, 266, '罗平县', 0),
(2328, 266, '富源县', 0),
(2329, 266, '会泽县', 0),
(2330, 266, '沾益县', 0),
(2331, 266, '宣威市', 0),
(2332, 267, '红塔区', 0),
(2333, 267, '江川县', 0),
(2334, 267, '澄江县', 0),
(2335, 267, '通海县', 0),
(2336, 267, '华宁县', 0),
(2337, 267, '易门县', 0),
(2338, 267, '峨山彝族自治县', 0),
(2339, 267, '新平彝族傣族自治县', 0),
(2340, 267, '元江哈尼族彝族傣族自治县', 0),
(2341, 268, '隆阳区', 0),
(2342, 268, '施甸县', 0),
(2343, 268, '腾冲县', 0),
(2344, 268, '龙陵县', 0),
(2345, 268, '昌宁县', 0),
(2346, 269, '昭阳区', 0),
(2347, 269, '鲁甸县', 0),
(2348, 269, '巧家县', 0),
(2349, 269, '盐津县', 0),
(2350, 269, '大关县', 0),
(2351, 269, '永善县', 0),
(2352, 269, '绥江县', 0),
(2353, 269, '镇雄县', 0),
(2354, 269, '彝良县', 0),
(2355, 269, '威信县', 0),
(2356, 269, '水富县', 0),
(2357, 270, '古城区', 0),
(2358, 270, '玉龙纳西族自治县', 0),
(2359, 270, '永胜县', 0),
(2360, 270, '华坪县', 0),
(2361, 270, '宁蒗彝族自治县', 0),
(2362, 271, '翠云区', 0),
(2363, 271, '普洱哈尼族彝族自治县', 0),
(2364, 271, '墨江哈尼族自治县', 0),
(2365, 271, '景东彝族自治县', 0),
(2366, 271, '景谷傣族彝族自治县', 0),
(2367, 271, '镇沅彝族哈尼族拉祜族自治县', 0),
(2368, 271, '江城哈尼族彝族自治县', 0),
(2369, 271, '孟连傣族拉祜族佤族自治县', 0),
(2370, 271, '澜沧拉祜族自治县', 0),
(2371, 271, '西盟佤族自治县', 0),
(2372, 272, '临翔区', 0),
(2373, 272, '凤庆县', 0),
(2374, 272, '云县', 0),
(2375, 272, '永德县', 0),
(2376, 272, '镇康县', 0),
(2377, 272, '双江拉祜族佤族布朗族傣族自治县', 0),
(2378, 272, '耿马傣族佤族自治县', 0),
(2379, 272, '沧源佤族自治县', 0),
(2380, 273, '楚雄市', 0),
(2381, 273, '双柏县', 0),
(2382, 273, '牟定县', 0),
(2383, 273, '南华县', 0),
(2384, 273, '姚安县', 0),
(2385, 273, '大姚县', 0),
(2386, 273, '永仁县', 0),
(2387, 273, '元谋县', 0),
(2388, 273, '武定县', 0),
(2389, 273, '禄丰县', 0),
(2390, 274, '个旧市', 0),
(2391, 274, '开远市', 0),
(2392, 274, '蒙自县', 0),
(2393, 274, '屏边苗族自治县', 0),
(2394, 274, '建水县', 0),
(2395, 274, '石屏县', 0),
(2396, 274, '弥勒县', 0),
(2397, 274, '泸西县', 0),
(2398, 274, '元阳县', 0),
(2399, 274, '红河县', 0),
(2400, 274, '金平苗族瑶族傣族自治县', 0),
(2401, 274, '绿春县', 0),
(2402, 274, '河口瑶族自治县', 0),
(2403, 275, '文山县', 0),
(2404, 275, '砚山县', 0),
(2405, 275, '西畴县', 0),
(2406, 275, '麻栗坡县', 0),
(2407, 275, '马关县', 0),
(2408, 275, '丘北县', 0),
(2409, 275, '广南县', 0),
(2410, 275, '富宁县', 0),
(2411, 276, '景洪市', 0),
(2412, 276, '勐海县', 0),
(2413, 276, '勐腊县', 0),
(2414, 277, '大理市', 0),
(2415, 277, '漾濞彝族自治县', 0),
(2416, 277, '祥云县', 0),
(2417, 277, '宾川县', 0),
(2418, 277, '弥渡县', 0),
(2419, 277, '南涧彝族自治县', 0),
(2420, 277, '巍山彝族回族自治县', 0),
(2421, 277, '永平县', 0),
(2422, 277, '云龙县', 0),
(2423, 277, '洱源县', 0),
(2424, 277, '剑川县', 0),
(2425, 277, '鹤庆县', 0),
(2426, 278, '瑞丽市', 0),
(2427, 278, '潞西市', 0),
(2428, 278, '梁河县', 0),
(2429, 278, '盈江县', 0),
(2430, 278, '陇川县', 0),
(2431, 279, '泸水县', 0),
(2432, 279, '福贡县', 0),
(2433, 279, '贡山独龙族怒族自治县', 0),
(2434, 279, '兰坪白族普米族自治县', 0),
(2435, 280, '香格里拉县', 0),
(2436, 280, '德钦县', 0),
(2437, 280, '维西傈僳族自治县', 0),
(2438, 281, '城关区', 0),
(2439, 281, '林周县', 0),
(2440, 281, '当雄县', 0),
(2441, 281, '尼木县', 0),
(2442, 281, '曲水县', 0),
(2443, 281, '堆龙德庆县', 0),
(2444, 281, '达孜县', 0),
(2445, 281, '墨竹工卡县', 0),
(2446, 282, '昌都县', 0),
(2447, 282, '江达县', 0),
(2448, 282, '贡觉县', 0),
(2449, 282, '类乌齐县', 0),
(2450, 282, '丁青县', 0),
(2451, 282, '察雅县', 0),
(2452, 282, '八宿县', 0),
(2453, 282, '左贡县', 0),
(2454, 282, '芒康县', 0),
(2455, 282, '洛隆县', 0),
(2456, 282, '边坝县', 0),
(2457, 283, '乃东县', 0),
(2458, 283, '扎囊县', 0),
(2459, 283, '贡嘎县', 0),
(2460, 283, '桑日县', 0),
(2461, 283, '琼结县', 0),
(2462, 283, '曲松县', 0),
(2463, 283, '措美县', 0),
(2464, 283, '洛扎县', 0),
(2465, 283, '加查县', 0),
(2466, 283, '隆子县', 0),
(2467, 283, '错那县', 0),
(2468, 283, '浪卡子县', 0),
(2469, 284, '日喀则市', 0),
(2470, 284, '南木林县', 0),
(2471, 284, '江孜县', 0),
(2472, 284, '定日县', 0),
(2473, 284, '萨迦县', 0),
(2474, 284, '拉孜县', 0),
(2475, 284, '昂仁县', 0),
(2476, 284, '谢通门县', 0),
(2477, 284, '白朗县', 0),
(2478, 284, '仁布县', 0),
(2479, 284, '康马县', 0),
(2480, 284, '定结县', 0),
(2481, 284, '仲巴县', 0),
(2482, 284, '亚东县', 0),
(2483, 284, '吉隆县', 0),
(2484, 284, '聂拉木县', 0),
(2485, 284, '萨嘎县', 0),
(2486, 284, '岗巴县', 0),
(2487, 285, '那曲县', 0),
(2488, 285, '嘉黎县', 0),
(2489, 285, '比如县', 0),
(2490, 285, '聂荣县', 0),
(2491, 285, '安多县', 0),
(2492, 285, '申扎县', 0),
(2493, 285, '索县', 0),
(2494, 285, '班戈县', 0),
(2495, 285, '巴青县', 0),
(2496, 285, '尼玛县', 0),
(2497, 286, '普兰县', 0),
(2498, 286, '札达县', 0),
(2499, 286, '噶尔县', 0),
(2500, 286, '日土县', 0),
(2501, 286, '革吉县', 0),
(2502, 286, '改则县', 0),
(2503, 286, '措勤县', 0),
(2504, 287, '林芝县', 0),
(2505, 287, '工布江达县', 0),
(2506, 287, '米林县', 0),
(2507, 287, '墨脱县', 0),
(2508, 287, '波密县', 0),
(2509, 287, '察隅县', 0),
(2510, 287, '朗县', 0),
(2511, 288, '新城区', 0),
(2512, 288, '碑林区', 0),
(2513, 288, '莲湖区', 0),
(2514, 288, '灞桥区', 0),
(2515, 288, '未央区', 0),
(2516, 288, '雁塔区', 0),
(2517, 288, '阎良区', 0),
(2518, 288, '临潼区', 0),
(2519, 288, '长安区', 0),
(2520, 288, '蓝田县', 0),
(2521, 288, '周至县', 0),
(2522, 288, '户县', 0),
(2523, 288, '高陵县', 0),
(2524, 289, '王益区', 0),
(2525, 289, '印台区', 0),
(2526, 289, '耀州区', 0),
(2527, 289, '宜君县', 0),
(2528, 290, '渭滨区', 0),
(2529, 290, '金台区', 0),
(2530, 290, '陈仓区', 0),
(2531, 290, '凤翔县', 0),
(2532, 290, '岐山县', 0),
(2533, 290, '扶风县', 0),
(2534, 290, '眉县', 0),
(2535, 290, '陇县', 0),
(2536, 290, '千阳县', 0),
(2537, 290, '麟游县', 0),
(2538, 290, '凤县', 0),
(2539, 290, '太白县', 0),
(2540, 291, '秦都区', 0),
(2541, 291, '杨凌区', 0),
(2542, 291, '渭城区', 0),
(2543, 291, '三原县', 0),
(2544, 291, '泾阳县', 0),
(2545, 291, '乾县', 0),
(2546, 291, '礼泉县', 0),
(2547, 291, '永寿县', 0),
(2548, 291, '彬县', 0),
(2549, 291, '长武县', 0),
(2550, 291, '旬邑县', 0),
(2551, 291, '淳化县', 0),
(2552, 291, '武功县', 0),
(2553, 291, '兴平市', 0),
(2554, 292, '临渭区', 0),
(2555, 292, '华县', 0),
(2556, 292, '潼关县', 0),
(2557, 292, '大荔县', 0),
(2558, 292, '合阳县', 0),
(2559, 292, '澄城县', 0),
(2560, 292, '蒲城县', 0),
(2561, 292, '白水县', 0),
(2562, 292, '富平县', 0),
(2563, 292, '韩城市', 0),
(2564, 292, '华阴市', 0),
(2565, 293, '宝塔区', 0),
(2566, 293, '延长县', 0),
(2567, 293, '延川县', 0),
(2568, 293, '子长县', 0),
(2569, 293, '安塞县', 0),
(2570, 293, '志丹县', 0),
(2571, 293, '吴旗县', 0),
(2572, 293, '甘泉县', 0),
(2573, 293, '富县', 0),
(2574, 293, '洛川县', 0),
(2575, 293, '宜川县', 0),
(2576, 293, '黄龙县', 0),
(2577, 293, '黄陵县', 0),
(2578, 294, '汉台区', 0),
(2579, 294, '南郑县', 0),
(2580, 294, '城固县', 0),
(2581, 294, '洋县', 0),
(2582, 294, '西乡县', 0),
(2583, 294, '勉县', 0),
(2584, 294, '宁强县', 0),
(2585, 294, '略阳县', 0),
(2586, 294, '镇巴县', 0),
(2587, 294, '留坝县', 0),
(2588, 294, '佛坪县', 0),
(2589, 295, '榆阳区', 0),
(2590, 295, '神木县', 0),
(2591, 295, '府谷县', 0),
(2592, 295, '横山县', 0),
(2593, 295, '靖边县', 0),
(2594, 295, '定边县', 0),
(2595, 295, '绥德县', 0),
(2596, 295, '米脂县', 0),
(2597, 295, '佳县', 0),
(2598, 295, '吴堡县', 0),
(2599, 295, '清涧县', 0),
(2600, 295, '子洲县', 0),
(2601, 296, '汉滨区', 0),
(2602, 296, '汉阴县', 0),
(2603, 296, '石泉县', 0),
(2604, 296, '宁陕县', 0),
(2605, 296, '紫阳县', 0),
(2606, 296, '岚皋县', 0),
(2607, 296, '平利县', 0),
(2608, 296, '镇坪县', 0),
(2609, 296, '旬阳县', 0),
(2610, 296, '白河县', 0),
(2611, 297, '商州区', 0),
(2612, 297, '洛南县', 0),
(2613, 297, '丹凤县', 0),
(2614, 297, '商南县', 0),
(2615, 297, '山阳县', 0),
(2616, 297, '镇安县', 0),
(2617, 297, '柞水县', 0),
(2618, 298, '城关区', 0),
(2619, 298, '七里河区', 0),
(2620, 298, '西固区', 0),
(2621, 298, '安宁区', 0),
(2622, 298, '红古区', 0),
(2623, 298, '永登县', 0),
(2624, 298, '皋兰县', 0),
(2625, 298, '榆中县', 0),
(2626, 300, '金川区', 0),
(2627, 300, '永昌县', 0),
(2628, 301, '白银区', 0),
(2629, 301, '平川区', 0),
(2630, 301, '靖远县', 0),
(2631, 301, '会宁县', 0),
(2632, 301, '景泰县', 0),
(2633, 302, '秦城区', 0),
(2634, 302, '北道区', 0),
(2635, 302, '清水县', 0),
(2636, 302, '秦安县', 0),
(2637, 302, '甘谷县', 0),
(2638, 302, '武山县', 0),
(2639, 302, '张家川回族自治县', 0),
(2640, 303, '凉州区', 0),
(2641, 303, '民勤县', 0),
(2642, 303, '古浪县', 0),
(2643, 303, '天祝藏族自治县', 0),
(2644, 304, '甘州区', 0),
(2645, 304, '肃南裕固族自治县', 0),
(2646, 304, '民乐县', 0),
(2647, 304, '临泽县', 0),
(2648, 304, '高台县', 0),
(2649, 304, '山丹县', 0),
(2650, 305, '崆峒区', 0),
(2651, 305, '泾川县', 0),
(2652, 305, '灵台县', 0),
(2653, 305, '崇信县', 0),
(2654, 305, '华亭县', 0),
(2655, 305, '庄浪县', 0),
(2656, 305, '静宁县', 0),
(2657, 306, '肃州区', 0),
(2658, 306, '金塔县', 0),
(2659, 306, '安西县', 0),
(2660, 306, '肃北蒙古族自治县', 0),
(2661, 306, '阿克塞哈萨克族自治县', 0),
(2662, 306, '玉门市', 0),
(2663, 306, '敦煌市', 0),
(2664, 307, '西峰区', 0),
(2665, 307, '庆城县', 0),
(2666, 307, '环县', 0),
(2667, 307, '华池县', 0),
(2668, 307, '合水县', 0),
(2669, 307, '正宁县', 0),
(2670, 307, '宁县', 0),
(2671, 307, '镇原县', 0),
(2672, 308, '安定区', 0),
(2673, 308, '通渭县', 0),
(2674, 308, '陇西县', 0),
(2675, 308, '渭源县', 0),
(2676, 308, '临洮县', 0),
(2677, 308, '漳县', 0),
(2678, 308, '岷县', 0),
(2679, 309, '武都区', 0),
(2680, 309, '成县', 0),
(2681, 309, '文县', 0),
(2682, 309, '宕昌县', 0),
(2683, 309, '康县', 0),
(2684, 309, '西和县', 0),
(2685, 309, '礼县', 0),
(2686, 309, '徽县', 0),
(2687, 309, '两当县', 0),
(2688, 310, '临夏市', 0),
(2689, 310, '临夏县', 0),
(2690, 310, '康乐县', 0),
(2691, 310, '永靖县', 0),
(2692, 310, '广河县', 0),
(2693, 310, '和政县', 0),
(2694, 310, '东乡族自治县', 0),
(2695, 310, '积石山保安族东乡族撒拉族自治县', 0),
(2696, 311, '合作市', 0),
(2697, 311, '临潭县', 0),
(2698, 311, '卓尼县', 0),
(2699, 311, '舟曲县', 0),
(2700, 311, '迭部县', 0),
(2701, 311, '玛曲县', 0),
(2702, 311, '碌曲县', 0),
(2703, 311, '夏河县', 0),
(2704, 312, '城东区', 0),
(2705, 312, '城中区', 0),
(2706, 312, '城西区', 0),
(2707, 312, '城北区', 0),
(2708, 312, '大通回族土族自治县', 0),
(2709, 312, '湟中县', 0),
(2710, 312, '湟源县', 0),
(2711, 313, '平安县', 0),
(2712, 313, '民和回族土族自治县', 0),
(2713, 313, '乐都县', 0),
(2714, 313, '互助土族自治县', 0),
(2715, 313, '化隆回族自治县', 0),
(2716, 313, '循化撒拉族自治县', 0),
(2717, 314, '门源回族自治县', 0),
(2718, 314, '祁连县', 0),
(2719, 314, '海晏县', 0),
(2720, 314, '刚察县', 0),
(2721, 315, '同仁县', 0),
(2722, 315, '尖扎县', 0),
(2723, 315, '泽库县', 0),
(2724, 315, '河南蒙古族自治县', 0),
(2725, 316, '共和县', 0),
(2726, 316, '同德县', 0),
(2727, 316, '贵德县', 0),
(2728, 316, '兴海县', 0),
(2729, 316, '贵南县', 0),
(2730, 317, '玛沁县', 0),
(2731, 317, '班玛县', 0),
(2732, 317, '甘德县', 0),
(2733, 317, '达日县', 0),
(2734, 317, '久治县', 0),
(2735, 317, '玛多县', 0),
(2736, 318, '玉树县', 0),
(2737, 318, '杂多县', 0),
(2738, 318, '称多县', 0),
(2739, 318, '治多县', 0),
(2740, 318, '囊谦县', 0),
(2741, 318, '曲麻莱县', 0),
(2742, 319, '格尔木市', 0),
(2743, 319, '德令哈市', 0),
(2744, 319, '乌兰县', 0),
(2745, 319, '都兰县', 0),
(2746, 319, '天峻县', 0),
(2747, 320, '兴庆区', 0),
(2748, 320, '西夏区', 0),
(2749, 320, '金凤区', 0),
(2750, 320, '永宁县', 0),
(2751, 320, '贺兰县', 0),
(2752, 320, '灵武市', 0),
(2753, 321, '大武口区', 0),
(2754, 321, '惠农区', 0),
(2755, 321, '平罗县', 0),
(2756, 322, '利通区', 0),
(2757, 322, '盐池县', 0),
(2758, 322, '同心县', 0),
(2759, 322, '青铜峡市', 0),
(2760, 323, '原州区', 0),
(2761, 323, '西吉县', 0),
(2762, 323, '隆德县', 0),
(2763, 323, '泾源县', 0),
(2764, 323, '彭阳县', 0),
(2765, 324, '沙坡头区', 0),
(2766, 324, '中宁县', 0),
(2767, 324, '海原县', 0),
(2768, 325, '天山区', 0),
(2769, 325, '沙依巴克区', 0),
(2770, 325, '新市区', 0),
(2771, 325, '水磨沟区', 0),
(2772, 325, '头屯河区', 0),
(2773, 325, '达坂城区', 0),
(2774, 325, '东山区', 0),
(2775, 325, '乌鲁木齐县', 0),
(2776, 326, '独山子区', 0),
(2777, 326, '克拉玛依区', 0),
(2778, 326, '白碱滩区', 0),
(2779, 326, '乌尔禾区', 0),
(2780, 327, '吐鲁番市', 0),
(2781, 327, '鄯善县', 0),
(2782, 327, '托克逊县', 0),
(2783, 328, '哈密市', 0),
(2784, 328, '巴里坤哈萨克自治县', 0),
(2785, 328, '伊吾县', 0),
(2786, 329, '昌吉市', 0),
(2787, 329, '阜康市', 0),
(2788, 329, '米泉市', 0),
(2789, 329, '呼图壁县', 0),
(2790, 329, '玛纳斯县', 0),
(2791, 329, '奇台县', 0),
(2792, 329, '吉木萨尔县', 0),
(2793, 329, '木垒哈萨克自治县', 0),
(2794, 330, '博乐市', 0),
(2795, 330, '精河县', 0),
(2796, 330, '温泉县', 0),
(2797, 331, '库尔勒市', 0),
(2798, 331, '轮台县', 0),
(2799, 331, '尉犁县', 0),
(2800, 331, '若羌县', 0),
(2801, 331, '且末县', 0),
(2802, 331, '焉耆回族自治县', 0),
(2803, 331, '和静县', 0),
(2804, 331, '和硕县', 0),
(2805, 331, '博湖县', 0),
(2806, 332, '阿克苏市', 0),
(2807, 332, '温宿县', 0),
(2808, 332, '库车县', 0),
(2809, 332, '沙雅县', 0),
(2810, 332, '新和县', 0),
(2811, 332, '拜城县', 0),
(2812, 332, '乌什县', 0),
(2813, 332, '阿瓦提县', 0),
(2814, 332, '柯坪县', 0),
(2815, 333, '阿图什市', 0),
(2816, 333, '阿克陶县', 0),
(2817, 333, '阿合奇县', 0),
(2818, 333, '乌恰县', 0),
(2819, 334, '喀什市', 0),
(2820, 334, '疏附县', 0),
(2821, 334, '疏勒县', 0),
(2822, 334, '英吉沙县', 0),
(2823, 334, '泽普县', 0),
(2824, 334, '莎车县', 0),
(2825, 334, '叶城县', 0),
(2826, 334, '麦盖提县', 0),
(2827, 334, '岳普湖县', 0),
(2828, 334, '伽师县', 0),
(2829, 334, '巴楚县', 0),
(2830, 334, '塔什库尔干塔吉克自治县', 0),
(2831, 335, '和田市', 0),
(2832, 335, '和田县', 0),
(2833, 335, '墨玉县', 0),
(2834, 335, '皮山县', 0),
(2835, 335, '洛浦县', 0),
(2836, 335, '策勒县', 0),
(2837, 335, '于田县', 0),
(2838, 335, '民丰县', 0),
(2839, 336, '伊宁市', 0),
(2840, 336, '奎屯市', 0),
(2841, 336, '伊宁县', 0),
(2842, 336, '察布查尔锡伯自治县', 0),
(2843, 336, '霍城县', 0),
(2844, 336, '巩留县', 0),
(2845, 336, '新源县', 0),
(2846, 336, '昭苏县', 0),
(2847, 336, '特克斯县', 0),
(2848, 336, '尼勒克县', 0),
(2849, 337, '塔城市', 0),
(2850, 337, '乌苏市', 0),
(2851, 337, '额敏县', 0),
(2852, 337, '沙湾县', 0),
(2853, 337, '托里县', 0),
(2854, 337, '裕民县', 0),
(2855, 337, '和布克赛尔蒙古自治县', 0),
(2856, 338, '阿勒泰市', 0),
(2857, 338, '布尔津县', 0),
(2858, 338, '富蕴县', 0),
(2859, 338, '福海县', 0),
(2860, 338, '哈巴河县', 0),
(2861, 338, '青河县', 0),
(2862, 338, '吉木乃县', 0),
(2867, 352, '宛平县', 1),
(2868, 352, '111111', 5),
(2869, 345, '台北', 2);

-- 
-- Dumping data for table sys_instance
--
INSERT INTO sys_instance VALUES
(19, 'Niushop开源商城', 1, '2016-10-27 12:03:38', '', '''''');

-- 
-- Dumping data for table sys_instance_type
--

-- Table `niushop_1.04`.sys_instance_type does not contain any data (it is empty)

-- 
-- Dumping data for table sys_module
--
INSERT INTO sys_module VALUES
(120, '系统', 'admin', 'System', 'moduleList', 0, 1, 'System/moduleList.html', 1, 1, 999, '2016-10-26 11:55:52', '2016-10-30 10:31:57', '''''', '', '', 1),
(121, '模块列表', 'admin', 'System', 'moduleList', 120, 2, 'System/moduleList.html', 1, 1, 2, '0000-00-00 00:00:00', NULL, '''''', '', '', 1),
(122, '添加模块', 'admin', 'System', 'addModule', 121, 3, 'System/addModule.html', 0, 1, 1, '0000-00-00 00:00:00', '2016-11-24 16:36:37', '添加模块', '', '', 1),
(123, '修改模块', 'admin', 'System', 'editModule', 121, 3, 'System/editModule.html', 0, 1, 2, '0000-00-00 00:00:00', '2016-11-24 16:37:26', '修改模块', '', '', 1),
(126, '用户', 'admin', 'Auth', 'userList', 0, 1, 'Auth/userList.html', 1, 0, 9, '0000-00-00 00:00:00', '2017-01-17 18:57:43', '', '', '', 1),
(127, '用户列表', 'admin', 'Auth', 'userList', 126, 2, 'Auth/UserList.html', 1, 0, 0, '0000-00-00 00:00:00', NULL, NULL, '', '', 1),
(128, '用户组列表', 'admin', 'Auth', 'authGroupList', 126, 2, 'Auth/authGroupList.html', 1, 0, 0, '0000-00-00 00:00:00', '2016-11-24 16:41:59', '用户组', '', '', 1),
(129, '删除模块', 'admin', 'System', 'delModule', 121, 3, 'System/delModule.html', 0, 0, 0, '2016-10-28 09:32:30', '2016-11-24 16:38:43', '模块列表', '', '', 1),
(133, '添加用户组', 'admin', 'Auth', 'addUserGroup', 128, 3, 'Auth/addUserGroup.html', 0, 0, 2, '2016-10-28 12:22:24', '2016-11-24 16:43:28', '用户组', '', '', 1),
(137, '会员', 'admin', 'Member', 'memberList', 0, 1, 'Member/memberList.html', 1, 0, 4, '2016-11-01 18:05:17', '2017-04-26 19:38:45', '', '', '', 1),
(139, '相册管理', 'admin', 'System', 'albumList', 149, 2, 'System/albumList.html', 1, 0, 10, '2016-11-03 15:28:14', '2017-06-07 15:13:30', '相册管理', '', '', 1),
(144, '编辑用户', 'admin', 'Auth', 'editUser', 127, 3, 'Auth/editUser.html', 0, 0, 5, '2016-11-11 12:10:47', '2016-11-24 16:42:43', '用户', '', '', 1),
(145, '会员列表', 'admin', 'member', 'memberlist', 137, 2, 'member/memberlist.html', 1, 0, 1, '2016-11-11 14:35:13', '2016-11-11 14:36:43', '', '', '', 1),
(149, '商品', 'admin', 'Goods', 'goodsList', 0, 1, 'Goods/goodsList.html', 1, 0, 1, '2016-11-16 11:49:08', '2017-05-05 16:32:47', '商品模块', '', '', 1),
(150, '商品列表', 'admin', 'Goods', 'goodsList', 149, 2, 'Goods/goodsList.html', 1, 0, 1, '2016-11-16 11:50:36', '2017-04-11 16:18:45', '商品列表', '', '', 0),
(151, '商品发布', 'admin', 'Goods', 'addGoods', 149, 2, 'Goods/addGoods.html', 1, 0, 2, '2016-11-16 11:51:47', NULL, '商品发布', '', '', 1),
(164, '运费模板管理', 'admin', 'Express', 'Transportation', 184, 2, 'Express/Transportation.html', 1, 0, 2, '2016-11-18 14:44:42', '2017-01-20 14:38:36', '运费模板管理', '', '', 1),
(169, '图片管理', 'admin', 'System', 'albumPictureList', 139, 3, 'System/albumPictureList.html', 0, 0, 5, '2016-11-18 18:25:08', '2016-11-24 16:39:50', 'sfgsdf', '', '', 1),
(170, '添加运费模板', 'admin', 'Express', 'TransportationAdd', 164, 3, 'Express/TransportationAdd.html', 0, 0, 1, '2016-11-21 11:56:50', '2017-01-20 14:39:36', '添加运费模板', '', '', 1),
(171, '商品分组', 'admin', 'Goods', 'goodsGroupList', 149, 2, 'Goods/goodsGroupList.html', 1, 0, 3, '2016-11-23 11:54:58', '2016-11-24 12:03:02', '商品分组', '', '', 1),
(172, '添加商品分组', 'admin', 'Goods', 'addGoodsGroup', 171, 3, 'Goods/addGoodsGroup.html', 0, 0, 6, '2016-11-23 11:57:04', '2016-11-24 12:04:03', '添加商品分组', '', '', 1),
(176, '运费模板修改', 'admin', 'Express', 'TransportationEdit', 164, 3, 'Express/TransportationEdit.html', 0, 0, 6, '2016-11-25 10:23:45', NULL, 'sd', '', '', 1),
(179, '营销', 'admin', 'Promotion', 'couponTypeList', 0, 1, 'Promotion/couponTypeList.html', 1, 0, 3, '2016-11-30 15:40:52', '2016-11-30 15:42:05', '优惠券类型列表', '', '', 1),
(180, '优惠券', 'admin', 'Promotion', 'couponTypeList', 179, 2, 'Promotion/couponTypeList.html', 1, 0, 1, '2016-11-30 15:44:06', NULL, '优惠券类型列表', '', '', 1),
(184, '订单', 'admin', 'Order', 'OrderList', 0, 1, 'Order/OrderList.html', 1, 0, 2, '2016-12-01 11:32:17', NULL, '订单列表', '', '', 1),
(185, '订单列表', 'admin', 'Order', 'orderList', 184, 2, 'Order/orderList.html', 1, 0, 1, '2016-12-01 11:33:30', NULL, '订单列表', '', '', 1),
(186, '添加优惠券', 'admin', 'Promotion', 'addCouponType', 180, 3, 'Promotion/addCouponType.html', 1, 0, 2, '2016-12-01 14:19:31', NULL, '添加优惠券类型', '', '', 1),
(187, '修改优惠券', 'admin', 'Promotion', 'updateCouponType', 180, 3, 'Promotion/updateCouponType.html', 1, 0, 3, '2016-12-05 10:29:03', NULL, '修改优惠券类型', '', '', 1),
(189, '物流公司', 'admin', 'Express', 'expressCompany', 184, 2, 'Express/expressCompany.html', 1, 0, 4, '2016-12-09 11:41:06', '2017-01-20 14:39:04', '物流公司', '', '', 1),
(190, '订单详情', 'admin', 'Order', 'orderDetail', 185, 3, 'Order/orderDetail.html', 0, 0, 1, '2016-12-09 12:36:13', NULL, '订单详情', '', '', 1),
(191, '添加物流公司', 'admin', 'Express', 'addExpressCompany', 189, 3, 'Express/addExpressCompany.html', 1, 0, 1, '2016-12-09 15:17:08', NULL, '添加物流公司', '', '', 1),
(192, '物流公司修改', 'admin', 'Express', 'updateExpressCompany', 189, 3, 'Express/updateExpressCompany.html', 1, 0, 2, '2016-12-09 16:23:28', NULL, '物流公司修改排序', '', '', 1),
(194, '退款详情', 'admin', 'Order', 'orderRefundDetail', 185, 3, 'Order/orderRefundDetail.html', 0, 0, 2, '2016-12-16 15:07:54', NULL, '退款详情', '', '', 1),
(195, '赠品', 'admin', 'Promotion', 'giftList', 179, 2, 'Promotion/giftList.html', 0, 0, 3, '2016-12-19 10:04:34', '2017-05-08 11:59:48', '', '', '', 1),
(196, '添加赠品', 'admin', 'Promotion', 'addGift', 195, 3, 'Promotion/addGift.html', 1, 0, 0, '2016-12-19 10:14:24', '2016-12-19 11:18:59', '添加赠品', '', '', 1),
(197, '修改赠品', 'admin', 'Promotion', 'updateGift', 195, 3, 'Promotion/updateGift.html', 1, 0, 0, '2016-12-19 10:15:15', '2016-12-19 11:19:18', '修改赠品', '', '', 1),
(198, '满减送', 'admin', 'Promotion', 'mansongList', 179, 2, 'Promotion/mansongList.html', 1, 0, 4, '2016-12-19 17:09:40', '2016-12-19 17:09:57', '满减送', '', '', 1),
(199, '添加满减满送', 'admin', 'Promotion', 'addMansong', 198, 3, 'Promotion/addMansong.html', 1, 0, 0, '2016-12-19 17:38:31', NULL, '满减送', '', '', 1),
(200, '编辑满减送', 'admin', 'Promotion', 'updateMansong', 198, 3, 'Promotion/updateMansong.html', 1, 0, 1, '2016-12-28 14:37:39', NULL, '编辑满减送', '', '', 1),
(201, '限时折扣', 'admin', 'Promotion', 'getDiscountList', 179, 2, 'Promotion/getDiscountList.html', 1, 0, 5, '2017-01-09 16:08:03', NULL, '限时折扣', '', '', 1),
(202, '添加限时折扣', 'admin', 'Promotion', 'addDiscount', 201, 3, 'Promotion/addDiscount.html', 1, 0, 0, '2017-01-09 16:38:24', NULL, '添加限时折扣', '', '', 1),
(203, '修改限时折扣', 'admin', 'Promotion', 'updateDiscount', 201, 3, 'Promotion/updateDiscount.html', 1, 0, 1, '2017-01-09 16:39:11', '2017-01-09 18:40:51', '修改限时折扣', '', '', 1),
(210, '修改商品分组', 'admin', 'Goods', 'updateGoodsGroup', 171, 3, 'Goods/updateGoodsGroup.html', 0, 0, 2, '2017-01-11 15:38:18', '2017-01-11 17:11:57', '修改商品分组', '', '', 1),
(218, '设置', 'admin', 'config', 'webConfig', 0, 1, 'config/webConfig.html', 1, 0, 6, '2017-01-17 09:42:35', '2017-04-28 10:56:17', '店铺设置', '', '', 1),
(221, '支付配置', 'admin', 'config', 'paymentConfig', 218, 2, 'config/paymentConfig.html', 1, 0, 4, '2017-01-17 11:23:47', '2017-06-07 15:27:08', '支付配置', '''''', '', 1),
(334, '咨询管理', 'admin', 'Saleservice', 'consultList', 149, 2, 'Saleservice/consultList.html', 1, 0, 8, '2017-03-07 16:35:02', '2017-06-02 16:35:53', '咨询管理，未回复咨询，已回复咨询', '', '', 1),
(335, '微信', 'admin', 'wchat', 'config', 0, 1, 'wchat/config.html', 1, 0, 7, '2017-03-08 11:55:38', '2017-04-24 14:31:32', '微信', '', '', 1),
(336, '公众号管理', 'admin', 'wchat', 'config', 335, 2, 'wchat/config.html', 1, 0, 1, '2017-03-08 11:56:56', NULL, '公众号管理', '', '', 1),
(339, '微信菜单管理', 'admin', 'wchat', 'menu', 335, 2, 'wchat/menu.html', 1, 0, 2, '2017-03-09 16:01:21', NULL, '微信菜单管理', '', '', 1),
(340, '推广二维码管理', 'admin', 'wchat', 'weixinQrcodeTemplate', 335, 2, 'wchat/weixinQrcodeTemplate.html', 1, 0, 3, '2017-03-09 16:03:16', '2017-03-22 11:29:01', '推广二维码管理', '', '', 1),
(341, '回复设置', 'admin', 'wchat', 'replayconfig', 335, 2, 'wchat/replayconfig.html', 1, 0, 4, '2017-03-09 16:04:22', NULL, '', '', '', 1),
(342, '消息素材管理', 'admin', 'wchat', 'materialmessage', 335, 2, 'wchat/materialmessage.html', 1, 0, 6, '2017-03-09 16:05:31', NULL, '', '', '', 1),
(343, '分享内容设置', 'admin', 'wchat', 'shareconfig', 335, 2, 'wchat/shareconfig.html', 1, 0, 7, '2017-03-09 16:06:44', NULL, '', '', '', 1),
(344, '模板消息设置', 'admin', 'wchat', 'messageTemplate', 335, 2, 'wchat/messageTemplate.html', 1, 0, 8, '2017-03-09 16:07:36', '2017-05-17 10:06:09', '', '', '', 1),
(358, '自定义推广二维码', 'admin', 'Wchat', 'qrcode', 340, 3, 'Wchat/qrcode.html', 0, 0, 1, '2017-03-22 11:27:37', '2017-03-22 11:27:58', '自定义二维码', '', '', 1),
(359, '修改回复', 'admin', 'wchat', 'addOrupdatekeyreplay', 341, 3, 'wchat/addOrupdatekeyreplay.html', 1, 0, 1, '2017-03-23 10:34:58', NULL, '', '', '', 1),
(360, '添加用户', 'admin', 'Auth', 'addUser', 127, 3, 'Auth/addUser.html', 0, 0, 1, '2017-03-23 10:38:51', NULL, '添加用户', '', '', 1),
(361, '一键关注设置', 'admin', 'wchat', 'oneKeySubscribe', 335, 2, 'wchat/oneKeySubscribe.html', 0, 0, 6, '2017-03-24 09:29:39', '2017-06-02 14:52:43', '一键关注设置', '', '', 1),
(381, '广告位', 'admin', 'System', 'shopAdvPositionList', 477, 2, 'System/shopAdvPositionList.html', 1, 0, 9, '2017-03-29 15:57:43', '2017-06-01 20:37:56', '广告位设置', '', '', 1),
(382, '广告管理', 'admin', 'System', 'shopAdvList', 381, 3, 'System/shopAdvList.html', 0, 0, 0, '2017-03-29 19:00:55', NULL, '广告管理', '', '', 1),
(383, '添加广告位', 'admin', 'System', 'addShopAdvPosition', 381, 3, 'System/addShopAdvPosition.html', 0, 0, 0, '2017-03-30 08:50:09', NULL, '添加广告位', '', '', 1),
(387, '广告位编辑', 'admin', 'System', 'updateShopAdvPosition', 381, 3, 'System/updateShopAdvPosition.html', 1, 0, 0, '2017-03-30 13:21:06', NULL, '广告位编辑', '', '', 1),
(388, '添加广告', 'admin', 'System', 'addShopAdv', 381, 3, 'System/addShopAdv.html', 0, 0, 0, '2017-03-30 14:09:00', NULL, '添加广告', '', '', 1),
(389, '广告编辑', 'admin', 'System', 'updateShopAdv', 381, 3, 'System/updateShopAdv.html', 0, 0, 0, '2017-03-30 14:57:18', NULL, '', '', '', 1),
(390, '促销版块', 'admin', 'System', 'goodsRecommendClass', 477, 2, 'System/goodsRecommendClass.html', 1, 0, 10, '2017-03-30 16:16:54', '2017-06-01 20:38:14', '促销版块管理', '', '', 1),
(392, '首页版块', 'admin', 'System', 'blockList', 477, 2, 'System/blockList.html', 1, 0, 11, '2017-03-31 15:56:52', '2017-06-01 20:38:31', '', '', '', 1),
(394, '添加版块', 'admin', 'System', 'addBlock', 392, 3, 'System/addBlock.html', 0, 0, 0, '2017-03-31 16:18:38', NULL, '', '', '', 1),
(395, '板块编辑', 'admin', 'System', 'updateBlock', 392, 3, 'System/updateBlock.html', 0, 0, 0, '2017-03-31 16:19:48', '2017-03-31 17:28:58', '', '', '', 1),
(398, '个人资料', 'admin', 'Auth', 'userDetail', 126, 2, 'Auth/userDetail.html', 1, 0, 0, '2017-04-01 14:59:55', '2017-05-09 10:54:50', '个人资料', '', '', 0),
(403, '销售排行', 'admin', 'account', 'shopGoodsSalesRank', 409, 2, 'account/shopGoodsSalesRank.html', 1, 0, 9, '2017-04-01 17:48:10', '2017-06-07 15:15:01', '商品销售排行', '', '', 1),
(405, '商品销售统计', 'admin', 'account', 'shopGoodsAccountList', 403, 3, 'account/shopGoodsAccountList.html', 0, 0, 6, '2017-04-01 18:32:22', NULL, '商品销售统计', '', '', 1),
(409, '资产', 'admin', 'Account', 'shopSalesAccount', 0, 1, 'Account/shopSalesAccount.html', 1, 0, 11, '2017-04-27 16:24:48', '2017-05-05 16:53:32', '资产', '', '', 1),
(418, '网站设置', 'admin', 'config', 'webconfig', 218, 2, 'config/webconfig.html', 1, 0, 2, '2017-04-21 14:10:47', NULL, '', '', '', 1),
(419, '商品分类', 'admin', 'goods', 'goodsCategoryList', 149, 2, 'goods/goodsCategoryList.html', 1, 0, 2, '2017-04-21 14:21:41', NULL, '商品分类', '', '', 1),
(420, '添加商品分类', 'admin', 'goods', 'addGoodsCategory', 419, 3, 'goods/addGoodsCategory.html', 1, 0, 2, '2017-04-21 14:23:31', '2017-04-21 14:23:48', '添加商品分类', '', '', 1),
(421, '修改商品分类', 'admin', 'goods', 'updateGoodsCategory', 419, 3, 'goods/updateGoodsCategory.html', 1, 0, 1, '2017-04-21 14:25:20', NULL, '修改商品分类', '', '', 1),
(422, '删除商品分类', 'admin', 'goods', 'deleteGoodsCategory', 419, 3, 'goods/deleteGoodsCategory.html', 1, 0, 2, '2017-04-21 14:26:13', NULL, '删除商品分类', '', '', 1),
(423, '商品品牌', 'admin', 'goods', 'goodsBrandList', 149, 2, 'goods/goodsBrandList.html', 1, 0, 3, '2017-04-21 14:27:18', NULL, '商品品牌列表', '', '', 1),
(424, '添加商品品牌', 'admin', 'goods', 'addGoodsBrand', 423, 3, 'goods/addGoodsBrand.html', 1, 0, 1, '2017-04-21 14:28:16', NULL, '添加商品品牌', '', '', 1),
(425, '修改商品品牌', 'admin', 'goods', 'updateGoodsBrand', 423, 3, 'goods/updateGoodsBrand.html', 1, 0, 4, '2017-04-21 14:29:29', NULL, '修改商品品牌', '', '', 1),
(427, '导航管理', 'admin', 'config', 'shopNavigationList', 477, 2, 'config/shopNavigationList.html', 1, 0, 1, '2017-04-21 16:02:32', '2017-06-01 20:38:53', '导航', '', '', 1),
(428, '添加导航', 'admin', 'config', 'addShopNavigation', 427, 3, 'config/addShopNavigation.html', 1, 0, 2, '2017-04-21 16:05:09', NULL, '添加导航', '', '', 0),
(429, '修改导航', 'admin', 'config', 'updateShopNavigation', 427, 3, 'config/updateShopNavigation.html', 1, 0, 3, '2017-04-21 16:15:15', NULL, '修改导航', '', '', 0),
(430, '友情链接', 'admin', 'config', 'linkList', 477, 2, 'config/linkList.html', 1, 0, 13, '2017-04-21 17:01:09', '2017-06-01 20:39:10', '友情链接', '', '', 1),
(431, '文章', 'admin', 'Cms', 'articleList', 0, 1, 'Cms/articleList.html', 1, 0, 8, '2017-04-21 21:48:32', '2017-04-21 21:50:19', 'Cms系统', '', '', 1),
(432, '文章列表', 'admin', 'cms', 'articleList', 431, 2, 'cms/articleList.html', 1, 0, 1, '2017-04-21 21:53:28', '2017-04-21 21:53:57', '文章列表', '', '', 1),
(433, '文章分类', 'admin', 'cms', 'articleClassList', 431, 2, 'cms/articleClassList.html', 1, 0, 2, '2017-04-21 21:55:34', '2017-04-21 21:55:52', '文章列表', '', '', 1),
(434, '评论列表', 'admin', 'cms', 'commentArticle', 431, 2, 'cms/commentArticle.html', 0, 0, 3, '2017-04-21 21:56:31', '2017-06-10 16:53:17', '评论列表', '', '', 1),
(435, '搜索设置', 'admin', 'Config', 'searchConfig', 477, 2, 'config/searchConfig.html', 1, 0, 14, '2017-04-26 14:23:22', '2017-06-01 20:53:21', '搜索设置', '', '', 1),
(436, '添加友情链接', 'admin', 'Config', 'addlink', 430, 3, 'config/addlink.html', 0, 0, 1, '2017-04-26 15:04:33', '2017-04-26 15:05:06', '添加友情链接', '', '', 1),
(437, '编辑友情链接', 'admin', 'Config', 'updateLink', 430, 3, 'config/updatelink.html', 0, 0, 2, '2017-04-26 15:33:38', NULL, '编辑友情链接', '', '', 1),
(438, '验证码设置', 'admin', 'Config', 'codeConfig', 218, 2, 'config/codeconfig.html', 1, 0, 15, '2017-04-26 15:41:45', '2017-04-26 15:49:38', '验证码设置', '', '', 1),
(439, '通知系统', 'admin', 'Config', 'notifyIndex', 218, 2, 'config/notifyIndex.html', 1, 0, 16, '2017-04-26 16:19:55', '2017-06-06 12:20:14', 'messageConfig', '', '', 1),
(440, '帮助类型', 'admin', 'Config', 'helpClass', 477, 2, 'config/helpclass.html', 1, 0, 17, '2017-04-26 17:45:34', '2017-06-01 20:39:46', '帮助类型', '', '', 1),
(441, '帮助内容', 'admin', 'Config', 'helpDocument', 477, 2, 'config/helpdocument.html', 1, 0, 18, '2017-04-26 18:13:18', '2017-06-01 20:40:03', '帮助内容', '', '', 1),
(442, '添加帮助类型', 'admin', 'Config', 'addHelpClass', 440, 3, 'config/addhelpclass.html', 0, 0, 1, '2017-04-26 18:14:33', NULL, '添加帮助类型', '', '', 1),
(443, '修改帮助内容', 'admin', 'Config', 'updateDocument', 441, 3, 'config/updatedocument.html', 0, 0, 2, '2017-04-26 18:43:29', NULL, 'updateDocument.html', '', '', 1),
(444, '添加帮助内容', 'admin', 'Config', 'addDocument', 441, 3, 'config/adddocument.html', 0, 0, 2, '2017-04-26 19:24:26', NULL, 'aaddDocument', '', '', 1),
(445, '用户通知', 'admin', 'Config', 'userNotice', 477, 2, 'config/usernotice.html', 1, 0, 19, '2017-04-26 19:30:56', '2017-06-01 20:45:21', 'userNotice', '', '', 1),
(446, '积分管理', 'admin', 'Promotion', 'pointConfig', 179, 2, 'promotion/pointconfig.html', 1, 0, 1, '2017-04-26 19:35:30', '2017-06-08 11:53:35', '1', '', '', 1),
(447, '粉丝列表', 'admin', 'Member', 'weixinFansList', 137, 2, 'Member/weixinFansList.html', 1, 0, 2, '2017-04-27 15:38:22', NULL, '粉丝列表', '', '', 1),
(450, '修改消息素材', 'admin', 'Wchat', 'updateMedia', 342, 3, 'Wchat/updateMedia.html', 1, 0, 1, '2017-04-27 16:34:38', '2017-04-27 16:38:17', '', '', '', 1),
(451, '添加消息素材', 'admin', 'Wchat', 'addMedia', 342, 3, 'Wchat/addMedia.html', 1, 0, 1, '2017-04-27 16:39:31', NULL, '', '', '', 1),
(452, '添加文章', 'admin', 'Cms', 'addArticle', 432, 3, 'cms/addarticle.html', 0, 0, 4, '2017-04-27 18:06:11', '2017-04-27 18:43:45', '', '', '', 1),
(454, '销售统计', 'admin', 'Account', 'orderAccountCount', 409, 2, 'Account/orderAccountCount.html', 0, 0, 6, '2017-04-27 18:46:01', '2017-05-05 18:55:04', '', '', '', 1),
(455, '修改文章', 'admin', 'Cms', 'updateArticle', 432, 3, 'CMS/updateArticle.html', 0, 0, 2, '2017-04-28 09:43:00', NULL, '', '', '', 1),
(456, '第三方登录', 'admin', 'Config', 'partyLogin', 218, 2, 'config/partyLogin.html', 1, 0, 22, '2017-04-28 10:47:26', '2017-06-08 14:30:36', '', '', '', 1),
(457, '销售明细', 'admin', 'Account', 'orderRecordsList', 454, 3, 'account/orderrecordslist.html', 0, 0, 2, '2017-05-02 14:04:40', '2017-05-02 14:10:19', '', '', '', 1),
(459, '销售概况', 'admin', 'account', 'shopSalesAccount', 409, 2, 'account/shopSalesAccount.html', 1, 0, 1, '2017-05-03 09:46:41', '2017-05-05 16:52:01', '', '', '', 1),
(460, '热卖商品', 'admin', 'account', 'bestSellerGoods', 463, 3, 'account/bestSellerGoods.html', 0, 0, 1, '2017-05-04 11:05:20', '2017-05-05 16:16:30', '', '', '', 1),
(461, '同行热卖', 'admin', 'account', 'shopGoodsGroupSaleCount', 409, 2, 'account/shopGoodsGroupSaleCount.html', 1, 0, 4, '2017-05-05 09:10:58', '2017-05-05 10:23:19', '', '', '', 1),
(462, '运营报告', 'admin', 'account', 'shopReport', 409, 2, 'account/shopReport.html', 1, 0, 5, '2017-05-05 09:23:32', NULL, '', '', '', 1),
(463, '商品分析', 'admin', 'account', 'shopGoodsSalesList', 409, 2, 'account/shopGoodsSalesList.html', 1, 0, 2, '2017-05-05 10:03:19', NULL, '', '', '', 1),
(467, '首页', 'admin', 'Index', 'index', 0, 1, 'Index/index.html', 1, 0, 0, '2017-05-11 14:53:32', '2017-06-10 13:14:36', '', '', '', 1),
(469, '满额包邮', 'admin', 'Promotion', 'fullShipping', 179, 2, 'Promotion/fullShipping', 1, 0, 6, '2017-05-16 17:49:22', NULL, '满额包邮设置', '', '', 1),
(471, '商家地址', 'admin', 'Order', 'returnSetting', 184, 2, 'Order/returnSetting', 1, 0, 5, '2017-05-31 15:29:20', '2017-05-31 15:34:06', '退货设置', '', '', 1),
(472, '添加或修改', 'admin', 'Order', 'addReturn', 471, 3, 'Order/addReturn', 1, 0, 1, '2017-05-31 15:31:32', '2017-05-31 15:34:27', '添加退货', '', '', 1),
(474, '首页公告', 'admin', 'Config', 'updateNotice', 477, 2, 'Config/updateNotice', 1, 0, 15, '2017-06-01 12:32:47', '2017-06-01 20:39:26', '公告', '', '', 1),
(477, '站点', 'admin', 'config', 'shopNavigationList', 0, 1, 'config/shopNavigationList', 1, 0, 0, '2017-06-01 15:51:55', '2017-06-07 15:45:12', '导航管理', '', '', 1),
(478, '商品评价', 'admin', 'Goods', 'goodsComment', 149, 2, 'Goods/goodsComment', 1, 0, 8, '2017-06-01 17:55:14', NULL, '', '', '', 1),
(479, '商品规格', 'admin', 'goods', 'goodsspeclist', 149, 2, 'goods/goodsspeclist', 1, 0, 6, '2017-06-01 18:47:58', '2017-06-02 09:54:39', '商品规格', '', '', 1),
(480, '添加商品规格', 'admin', 'Goods', 'addGoodsSpec', 479, 3, 'Goods/addGoodsSpec', 0, 1, 1, '2017-06-02 10:01:35', NULL, '', '', '', 1),
(481, '修改商品规格', 'admin', 'Goods', 'updateGoodsSpec', 479, 3, 'Goods/updateGoodsSpec', 0, 1, 0, '2017-06-02 15:02:35', NULL, '', '', '', 1),
(482, '商品类型', 'admin', 'goods', 'attributelist', 149, 2, 'goods/attributelist', 1, 0, 7, '2017-06-02 16:33:54', '2017-06-02 16:34:57', '', '', '', 1),
(484, '添加商品类型', 'admin', 'Goods', 'addAttributeService', 482, 3, 'Goods/addAttributeService', 0, 1, 0, '2017-06-02 17:24:57', '2017-06-03 10:44:33', '', '', '', 1),
(485, '修改商品类型', 'admin', 'Goods', 'updateGoodsAttribute', 482, 3, 'Goods/updateGoodsAttribute', 0, 1, 0, '2017-06-02 17:34:44', NULL, '', '', '', 1),
(486, '地区管理', 'admin', 'Config', 'areaManagement', 218, 2, 'Config/areaManagement', 1, 0, 23, '2017-06-03 09:13:10', NULL, '', '', '', 1),
(487, '模板编辑', 'admin', 'Express', 'expressTemplate', 189, 3, 'Express/expressTemplate', 0, 1, 0, '2017-06-03 11:19:53', NULL, '', '', '', 1),
(488, '会员等级', 'admin', 'member', 'memberlevellist', 137, 2, 'member/memberlevellist', 1, 0, 3, '2017-06-03 11:59:20', NULL, '会员等级', '', '', 1),
(489, '添加等级', 'admin', 'member', 'addMemberLevel', 488, 3, 'member/addMemberLevel', 1, 0, 1, '2017-06-03 17:58:15', NULL, '添加等级', '', '', 1),
(490, '修改等级', 'admin', 'member', 'updateMemberLevel', 488, 3, 'member/updateMemberLevel', 1, 0, 0, '2017-06-03 17:58:53', '2017-06-03 18:28:12', '修改等级', '', '', 1),
(491, '专题列表', 'admin', 'cms', 'topicList', 431, 2, 'cms/topicList.html', 1, 0, 4, '2017-06-05 10:36:19', '2017-06-05 11:18:33', '专题列表', '', '', 1),
(492, '添加专题', 'admin', 'cms', 'addTopic', 491, 3, 'cms/addTopic', 1, 0, 1, '2017-06-05 10:44:00', '2017-06-05 11:19:13', '添加专题', '', '', 1),
(493, '修改专题', 'admin', 'cms', 'updateTopic', 491, 3, 'cms/updateTopic', 1, 0, 2, '2017-06-05 10:44:56', '2017-06-05 11:19:41', '修改专题', '', '', 1),
(494, '购物设置', 'admin', 'Config', 'shopSet', 218, 2, 'Config/shopSet.html', 1, 0, 44, '2017-06-06 10:40:45', '2017-06-06 10:44:22', '购物设置', '', '', 1),
(495, '邮件设置', 'admin', 'config', 'messageConfig', 439, 3, 'config/messageConfig.html', 0, 1, 0, '2017-06-06 14:46:37', NULL, '', '', '', 1),
(496, '短信设置', 'admin', 'config', 'messageConfig', 439, 3, 'config/messageConfig.html', 0, 1, 0, '2017-06-06 14:47:16', NULL, '', '', '', 1),
(497, '会员积分明细', 'admin', 'Member', 'pointdetail', 145, 3, 'Member/pointdetail', 0, 1, 0, '2017-06-06 16:57:52', NULL, '', '', '', 1),
(498, '会员余额明细', 'admin', 'Member', 'accountdetail', 145, 3, 'Member/accountdetail', 0, 1, 0, '2017-06-06 18:21:52', NULL, '', '', '', 1),
(499, 'seo设置', 'admin', 'config', 'seoConfig', 418, 3, 'Config/seoConfig', 1, 0, 2, '2017-06-06 20:08:05', '2017-06-06 20:10:54', 'seo设置', '', '', 1),
(501, '微信支付', 'admin', 'Config', 'payConfig', 221, 3, 'Config/payConfig', 1, 0, 1, '2017-06-07 15:44:10', NULL, '微信支付', '', '', 1),
(502, '支付宝支付', 'admin', 'Config', 'payAliConfig', 221, 3, 'Config/payAliConfig', 1, 0, 2, '2017-06-07 15:49:40', NULL, '支付宝支付', '', '', 1),
(503, '会员提现设置', 'admin', 'config', 'memberWithdrawSetting', 218, 2, 'config/memberWithdrawSetting', 1, 0, 45, '2017-06-07 15:52:14', '2017-06-07 15:57:02', '会员提现设置', '', '', 1),
(504, '会员提现', 'admin', 'Member', 'userCommissionWithdrawList', 137, 2, 'Member/userCommissionWithdrawList', 1, 0, 4, '2017-06-07 15:56:11', '2017-06-07 15:57:22', '会员提现', '', '', 1),
(506, '模板管理', 'admin', 'config', 'notifyTemplate', 439, 3, 'config/notifyTemplate.html', 0, 1, 0, '2017-06-08 09:48:59', '2017-06-09 10:11:08', '', '', '', 1),
(507, '积分设置', 'admin', 'promotion', 'integral', 446, 3, 'promotion/integral.html', 1, 0, 0, '2017-06-08 12:29:26', NULL, '积分奖励', '', '', 1),
(508, '积分奖励', 'admin', 'promotion', 'integral', 446, 3, 'promotion/integral.html', 1, 0, 0, '2017-06-08 12:30:01', NULL, '积分奖励', '', '', 1),
(509, '积分管理', 'admin', 'member', 'pointlist', 137, 2, 'member/pointlist', 1, 1, 5, '2017-06-08 15:13:27', '2017-06-08 15:17:02', '', '', '', 1),
(510, '余额管理', 'admin', 'member', 'accountlist', 137, 2, 'member/accountlist', 1, 1, 6, '2017-06-08 15:15:42', '2017-06-08 15:17:22', '', '', '', 1),
(512, '微信登录', 'admin', 'config', 'loginconfig', 456, 3, 'config/loginconfig', 1, 0, 2, '2017-06-08 15:32:29', '2017-06-08 15:39:29', '微信登录', '', '', 1),
(513, 'qq登录', 'admin', 'Config', 'loginconfig', 456, 3, 'Config/loginconfig', 1, 0, 1, '2017-06-08 15:33:58', '2017-06-08 15:39:12', 'qq登录', '', '', 1),
(515, '欢迎页', 'admin', 'index', 'index', 467, 2, 'index/index', 1, 0, 0, '2017-06-09 11:31:02', NULL, '欢迎页', '', '', 1),
(517, '商品回收站', 'admin', 'Goods', 'recycle', 149, 2, 'Goods/recycleList.html', 1, 0, 11, '2017-06-14 21:13:16', '2017-06-14 21:13:16', '', '', '', 1),
(518, '回收站列表', 'admin', 'Goods', 'recycleList', 517, 3, 'Goods/recycleList.html', 0, 1, 0, '2017-06-14 21:13:16', '2017-06-14 21:13:16', '', '', '', 1),
(519, '配送地区管理', 'admin', 'Config', 'distributionAreaManagement', 218, 2, 'Config/distributionAreaManagement', 1, 0, 24, '2017-06-17 21:36:54', '2017-06-17 21:36:54', '', '', '', 1),
(520, '自提点管理', 'admin', 'Shop', 'pickupPointList', 184, 2, 'Shop/pickupPointList', 1, 1, 6, '2017-06-22 20:49:19', '2017-06-22 20:49:19', '', '', '', 1),
(521, '添加自提点', 'admin', 'Shop', 'addpickuppoint', 520, 3, 'Shop/addpickuppoint', 0, 1, 0, '2017-06-22 20:49:19', '2017-06-22 20:49:19', '', '', '', 1),
(522, '修改自提点', 'admin', 'Shop', 'updatePickupPoint', 520, 3, 'Shop/updatePickupPoint', 0, 1, 0, '2017-06-22 20:49:19', '2017-06-22 20:49:19', '', '', '', 1),
(523, '物流跟踪', 'admin', 'config', 'expressMessage', 218, 2, 'config/expressMessage', 1, 1, 47, '2017-06-23 14:23:10', '2017-06-23 14:23:10', '', '', '', 1);

-- 
-- Dumping data for table sys_notice
--
INSERT INTO sys_notice VALUES
(7, 0, '首页公告用户通知', 1);

-- 
-- Dumping data for table sys_notice_template
--
INSERT INTO sys_notice_template VALUES
(41, 'sms', 0, 'after_register', '', '', '', 0, '2017-06-10 22:11:27'),
(42, 'sms', 0, 'register_validate', '', '', '', 1, '2017-06-10 22:11:27'),
(43, 'sms', 0, 'recharge_success', '', '', '', 0, '2017-06-10 22:11:27'),
(44, 'sms', 0, 'confirm_order', '', '', '', 0, '2017-06-10 22:11:27'),
(45, 'sms', 0, 'pay_success', '', '', '', 0, '2017-06-10 22:11:27'),
(46, 'sms', 0, 'create_order', '', '', '', 0, '2017-06-10 22:11:27'),
(47, 'sms', 0, 'order_deliver', '', '', '', 0, '2017-06-10 22:11:27'),
(48, 'email', 0, 'after_register', '', '\n', '', 1, '2017-06-10 18:22:25'),
(49, 'email', 0, 'register_validate', 'dddd', 'dsdsdf{验证码}\n', '', 1, '2017-06-10 18:22:25'),
(50, 'email', 0, 'recharge_success', '', '', '', 0, '2017-06-10 18:22:25'),
(51, 'email', 0, 'confirm_order', '', '', '', 0, '2017-06-10 18:22:25'),
(52, 'email', 0, 'pay_success', '', '', '', 0, '2017-06-10 18:22:25'),
(53, 'email', 0, 'create_order', '', '', '', 0, '2017-06-10 18:22:25'),
(54, 'email', 0, 'order_deliver', '', '', '', 0, '2017-06-10 18:22:25');

-- 
-- Dumping data for table sys_notice_template_item
--
INSERT INTO sys_notice_template_item VALUES
(1, '商场名称', '{商场名称}', 'shop_name', 'after_register,recharge_success,create_order,pay_success,confirm_order,order_deliver', 0),
(2, '用户名称', '{用户名称}', 'user_name', 'after_register,recharge_success,create_order,pay_success,confirm_order,order_deliver,bind_mobile,bind_email', 1),
(5, '商品名称', '{商品名称}', 'goods_name', 'order_deliver', 4),
(6, '商品规格', '{商品规格}', 'goods_sku', 'order_deliver', 5),
(7, '主订单号', '{主订单号}', 'order_no', 'create_order,pay_success,confirm_order,order_deliver', 6),
(8, '订单金额', '{订单金额}', 'order_money', 'create_order,pay_success,confirm_order,order_deliver', 7),
(9, '商品金额', '{商品金额}', 'goods_money', 'create_order,pay_success,order_deliver', 8),
(10, '验证码', '{验证码}', 'number', 'register_validate,forgot_password,bind_mobile,bind_email', 9),
(11, '充值金额', '{充值金额}', 'recharge_money', 'recharge_success', 0);

-- 
-- Dumping data for table sys_notice_template_type
--
INSERT INTO sys_notice_template_type VALUES
(1, '注册成功', 'after_register', 'all'),
(2, '注册验证', 'register_validate', 'all'),
(3, '充值成功', 'recharge_success', 'all'),
(4, '确认订单', 'confirm_order', 'all'),
(5, '付款成功', 'pay_success', 'all'),
(6, '下单成功', 'create_order', 'all'),
(7, '订单发货', 'order_deliver', 'all'),
(8, '找回密码', 'forgot_password', 'all'),
(9, '手机绑定', 'bind_mobile', 'sms'),
(10, '邮箱绑定', 'bind_email', 'email');

-- 
-- Dumping data for table sys_province
--
INSERT INTO sys_province VALUES
(1, 2, '北京市4', 1),
(2, 2, '天津市', 0),
(3, 2, '河北省', 0),
(4, 2, '山西省', 0),
(5, 2, '内蒙古自治区', 0),
(6, 5, '辽宁省', 0),
(7, 5, '吉林省', 0),
(8, 5, '黑龙江省', 0),
(9, 1, '上海市', 0),
(10, 1, '江苏省', 0),
(11, 1, '浙江省', 0),
(12, 1, '安徽省', 0),
(13, 3, '福建省', 0),
(14, 1, '江西省', 0),
(15, 2, '山东省', 0),
(16, 4, '河南省', 0),
(17, 4, '湖北省', 0),
(18, 4, '湖南省', 0),
(19, 3, '广东省', 0),
(20, 3, '广西壮族自治区', 0),
(21, 3, '海南省', 0),
(22, 7, '重庆市', 0),
(23, 7, '四川省', 0),
(24, 7, '贵州省', 0),
(25, 7, '云南省', 0),
(26, 7, '西藏自治区', 0),
(27, 6, '陕西省', 0),
(28, 6, '甘肃省', 0),
(29, 6, '青海省', 0),
(30, 6, '宁夏回族自治区', 0),
(31, 6, '新疆维吾尔自治区', 0),
(32, 8, '香港特别行政区', 0),
(33, 8, '澳门特别行政区', 0),
(34, 8, '台湾省', 0);

-- 
-- Dumping data for table sys_user
--

-- Table `niushop_1.04`.sys_user does not contain any data (it is empty)

-- 
-- Dumping data for table sys_user_admin
--

-- Table `niushop_1.04`.sys_user_admin does not contain any data (it is empty)

-- 
-- Dumping data for table sys_user_group
--

-- Table `niushop_1.04`.sys_user_group does not contain any data (it is empty)

-- 
-- Dumping data for table sys_user_log
--

-- Table `niushop_1.04`.sys_user_log does not contain any data (it is empty)

-- 
-- Dumping data for table sys_web_style
--
INSERT INTO sys_web_style VALUES
(1, '默认样式', 'default', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL);

-- 
-- Dumping data for table sys_website
--
INSERT INTO sys_website VALUES
(1, 'Niushop开源商城', 'upload/common/1497068501.png', '开源商城', 'keywords2', '0300259', 1, '山西省太原市', 'upload/common/1497068665.png', 'http://www.niushop.com.cn/', '1518079521@qq.com', '400-886-7993', '2016-10-26 11:21:52', '2017-06-10 22:29:12', '1518079521', 'y159753', 1, '', '对不起，牛酷商城维护中，大家敬请期待...', 1);

-- 
-- Dumping data for table sys_weixin_auth
--

-- Table `niushop_1.04`.sys_weixin_auth does not contain any data (it is empty)

-- 
-- Dumping data for table sys_weixin_default_replay
--

-- Table `niushop_1.04`.sys_weixin_default_replay does not contain any data (it is empty)

-- 
-- Dumping data for table sys_weixin_fans
--

-- Table `niushop_1.04`.sys_weixin_fans does not contain any data (it is empty)

-- 
-- Dumping data for table sys_weixin_follow_replay
--

-- Table `niushop_1.04`.sys_weixin_follow_replay does not contain any data (it is empty)

-- 
-- Dumping data for table sys_weixin_functions_button
--

-- Table `niushop_1.04`.sys_weixin_functions_button does not contain any data (it is empty)

-- 
-- Dumping data for table sys_weixin_instance_msg
--
INSERT INTO sys_weixin_instance_msg VALUES
(1, 0, 'OPENTM207103254', '', '退款申请', True, '您已申请退款，我们将尽快处理您的退款申请。您可以在“退换货”中查看到退款申请的进度', '如您在退款中遇到问题，请联系我们的客服人员，协助您处理！'),
(2, 0, 'OPENTM205986235', '', '退款结果通知', True, '亲，您的退款订单已被拒绝。', '如您还有疑问，请联系客服。'),
(3, 0, 'OPENTM200444326', '', '订单付款成功通知', True, '亲，您的订单已付款成功', '感谢您的惠顾'),
(4, 0, 'OPENTM200444240', '', '订单提交成功通知', True, '亲！您的订单已创建成功，点击进入完成付款。', '感谢亲的支持，我们将以最好的服务来回报亲。'),
(5, 0, 'OPENTM201541214', '', '订单发货通知', True, '亲，你的宝贝已发货', '请注意查收。');

-- 
-- Dumping data for table sys_weixin_key_replay
--

-- Table `niushop_1.04`.sys_weixin_key_replay does not contain any data (it is empty)

-- 
-- Dumping data for table sys_weixin_media
--

-- Table `niushop_1.04`.sys_weixin_media does not contain any data (it is empty)

-- 
-- Dumping data for table sys_weixin_media_item
--

-- Table `niushop_1.04`.sys_weixin_media_item does not contain any data (it is empty)

-- 
-- Dumping data for table sys_weixin_menu
--

-- Table `niushop_1.04`.sys_weixin_menu does not contain any data (it is empty)

-- 
-- Dumping data for table sys_weixin_msg_template
--

-- Table `niushop_1.04`.sys_weixin_msg_template does not contain any data (it is empty)

-- 
-- Dumping data for table sys_weixin_qrcode_template
--
INSERT INTO sys_weixin_qrcode_template VALUES
(79, 0, 'upload/common/1497105842.png', '#2b2b2b', 23, 1, '59px', '15px', '118px', '20px', '95px', '310px', '91px', '96px', 1, 0, 'upload/qrcode/promote_qrcode_template/qrcode_template_79_0.png');

-- 
-- Dumping data for table sys_weixin_user_msg
--

-- Table `niushop_1.04`.sys_weixin_user_msg does not contain any data (it is empty)

-- 
-- Dumping data for table sys_weixin_user_msg_replay
--

-- Table `niushop_1.04`.sys_weixin_user_msg_replay does not contain any data (it is empty)

-- 
-- Dumping data for table sys_wexin_onekeysubscribe
--

-- Table `niushop_1.04`.sys_wexin_onekeysubscribe does not contain any data (it is empty)

-- 
-- Enable foreign keys
-- 
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;