<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: ajax.php 17 2014-06-26 03:29:37Z along $
#
#	Copyright (C) 2008-2014 PHPDisk Team. All Rights Reserved.
#
*/

include "includes/commons.inc.php";

switch($action){
	case 'get_dl_list':
		$pid = (int)gpc('pid','P',0);
		if(!$pid){
			exit('Error');
		}else{
			$rs = $db->fetch_one_array("select file_param,p_credit,userid from {$tpf}posts where pid='$pid'");
			if($rs){
				$file_list = '<div class="dl_box2">';
				if(!$pd_uid){
					$file_list .= '<div align="center" class="tips_box">下载此文件需要 <a href="'.urr("account","action=login").'">[登录网站]</a></div>';
				}else{
					$num = @$db->result_first("select count(*) from {$tpf}buy_files where pid='$pid' and action='common' and userid='$pd_uid'");
					if(!$num && is_vip($pd_uid)){
						$num = @$db->result_first("select count(*) from {$tpf}buy_files where pid='$pid' and action='vip' and userid='$pd_uid'");
					}
					if((!$num && $rs[p_credit] && $pd_uid<>$rs[userid])){
						$file_list .= '<div align="center" class="tips_box">1. <a href="javascript:;" onclick="buy_file('.$pid.')">此文件需要付费，现在购买文件</a></div>';
						$file_list .= '<div align="center" class="tips_box">2. <a href="javascript:;" onclick="buy_file_vip('.$pid.')">使用VIP特权免费下载</a></div>';
					}else{
						$file_list .= '<ul>';
						$f_arr = unserialize($rs[file_param]);
						for($i=0;$i<count($f_arr[1]);$i++){
							$file_list .= '<li><a href="'.$f_arr[0][$i].'" onclick="down_process('.$pid.');" target="_blank"><img src="images/down_file_icon.gif" align="absmiddle" border="0"/>'.$f_arr[1][$i].'</a></li>';
						}
						$file_list .= '</ul>';
					}
				}
				//}
				$file_list .= '</div>';
			}
			unset($rs);
			echo 'true|'.$file_list;
		}
		break;
	case 'buy_file':
	case 'buy_file_vip':
		$pid = (int)gpc('pid','P',0);
		if(!$pid || !$pd_uid){
			exit('Error');
		}else{
			$success = false;
			$rs = $db->fetch_one_array("select p_credit,userid from {$tpf}posts where pid='$pid'");
			$file_list = '<div class="dl_box2">';
			if($action=='buy_file_vip'){
				if(!is_vip($pd_uid)){
					$file_list .= '<div align="center" class="tips_box">您不是VIP用户或VIP已过期，无法使用特权下载。<a href="javascript:;" onclick="get_dl_list('.$pid.')">[返回]</a></div>';
				}else{
					$param = unserialize(get_vip($myinfo[vip_id],'param'));
					$s_time = strtotime(date('Y-m-d').'0:0:0');
					$vip_day_down_count = (int)@$db->result_first("select count(*) from {$tpf}buy_files where action='vip' and userid='$pd_uid' and (in_time between $s_time and $timestamp)");
					if($vip_day_down_count>=(int)$param[down_num]){
						$file_list .= '<div align="center" class="tips_box">!!今日VIP特权免费下载数已用完<br>请明天重试或 <a href="javascript:;" onclick="buy_file('.$pid.')"><u>[现在使用付费下载]</u></a></div>';
						$success = false;
					}else{
						add_buy_files($pd_uid,$pid,'vip',$rs[p_credit]);
						$file_list .= '<div align="center" class="tips_box">购买资源成功，加载中...请稍候</div>';
						$success = true;
					}
				}
			}else{
				$promo_credit = 1;
				if($settings[promo_time]<>''){
					$hour = date('G');
					$arr = explode(',',$settings[promo_time]);
					if(in_array($hour,$arr)){
						$promo_credit = 2;
					}
				}
				if($rs[p_credit] && $myinfo[credit]>=$rs[p_credit]){
					add_buy_files($pd_uid,$pid,'common',$rs[p_credit]);
					add_credit_log($pid,$rs[p_credit],'buy_file',$pd_uid);
					add_credit_log($pid,$rs[p_credit]*$promo_credit,'sell_file',$rs[userid]);
					do_stat('buy_file','-'.$rs[p_credit],$rs[userid]);
					do_stat('sell_file',$rs[p_credit]*$promo_credit,$rs[userid]);
					$db->query_unbuffered("update {$tpf}users set credit=credit-$rs[p_credit] where userid='$pd_uid' limit 1");
					$db->query_unbuffered("update {$tpf}users set credit=credit+$rs[p_credit] where userid='$rs[userid]' limit 1");
					$db->query_unbuffered("insert into {$tpf}posts set downs=downs+1 where pid='$pid'");
					$file_list .= '<div align="center" class="tips_box">购买资源成功，加载中...请稍候</div>';
					$success = true;
				}else{
					$file_list .= '<div align="center" class="tips_box txtred">您的积分不足，无法购买下载此资源，<a href="'.urr("pay","").'"><span class="txtblue f14">现在充值</span></a></div>';
					$success = false;
				}
			}
			$file_list .= '</div>';
		}
		unset($rs);
		echo $success ? 'true|'.$file_list : $file_list;
		break;
	case 'add_cate':
		$cate_name = trim(gpc('cate_name','P',''));
		if(checklength($cate_name,1,150)){
			$error = true;
			$rtn = __('add_folder_error');
		}
		$num = @$db->result_first("select count(*) from {$tpf}folders where userid='$pd_uid' and folder_name='$cate_name'");
		if($num){
			$error = true;
			$rtn = __('folder_exists');
		}
		if(!$error){
			$ins = array(
			'folder_name' => $cate_name,
			'userid' => $pd_uid,
			'in_time'=>$timestamp,
			);
			$db->query_unbuffered("insert into {$tpf}folders set ".$db->sql_array($ins)."");
			$id = $db->insert_id();
			echo 'true|'.$id;
		}else{
			echo $rtn;
		}
		break;
	case 'load_cate':
		$uid = (int)gpc('uid','P','');
		$sel_id = (int)gpc('sel_id','P','');
		$str = '<select id="up_folder_id" name="up_folder_id">'.LF;
		$str .= '<option value="0">'.__('root_folder').'</option>'.LF;
		$str .= get_folder_option(0,$sel_id);
		$str .= '</select>';

		echo $str;
		break;
	case 'add_disk':
		$folder_id = (int)gpc('folder_id','GP',0);
		$pg = (int)gpc('pg','GP',0);

		$str = '<div class="add_box">';
		$str .= '<div class="l">';
		$str .= '<div id="sfd_0"><img src="images/ico_home.gif" align="absmiddle" border="0" /><a href="javascript:;" onclick="add_disk(0,0)">根目录</a></div>'.get_folder_list(0,0,$folder_id).'</div>';
		$str .= '<div class="r">';

		$pg = $pg ? $pg : 1;
		$perpage = 10;
		$sql_do = " {$tpf}files where userid='$pd_uid' and folder_id='$folder_id' and is_del=0";
		$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_do}");
		$total_num = $rs['total_num'];
		$start_num = ($pg-1) * $perpage;
		$q = $db->query("select file_id,file_name,file_extension,file_size,file_time,yun_fid from $sql_do order by file_id desc limit $start_num,$perpage");
		$files = array();
		while ($rs = $db->fetch_array($q)) {
			$files[] = $rs;
		}
		$db->free($q);
		unset($rs);
		if(count($files)){
			foreach($files as $k => $v){
				$str .= '<li>';
				$str .= '<a href="javascript:;" onclick="javascript:add_file_addr(\''.$v[file_name].'\',\''.urr("dfile","file_id=".$v[file_id]).'&yun_fid={$rs[yun_fid]}\')" title="'.$v[file_name].'"><span style="float:right;" title="添加">[+]</span>'.file_icon($v[file_extension]).$v[file_name].'</a>';
				$display = $k!=0 ? 'display:none;' : '';
				$str .= '<div style="'.$display.' clear:both;">大小：'.get_size($v[file_size]).'&nbsp;&nbsp;时间：'.date('Y-m-d',$v[file_time]).'&nbsp;&nbsp;类型：'.strtoupper($v[file_extension]).'</div></li>';
			}
		}else{
			$str .= '<li align="center">暂无文件记录</li>';
		}
		$str .= '</div><div class="clear"></div>';
		$str .= '<div align="right">'.multi_ajax($action,$folder_id,$total_num, $perpage, $pg).'</div>';
		$str .= '</div>';
		$str .= '<script>';
		$str .= '$(document).ready(function(){';
		$str .= '$(".add_box .r li").each(function(){';
		$str .= '	var li_obj = $(this).find("div");';
		$str .= '	$(this).mouseover(function(){';
		$str .= '		li_obj.css("display","");';
		$str .= '		li_obj.addClass("alt_bg txtgreen");';
		$str .= '	}).mouseout(function(){';
		$str .= '		li_obj.css("display","none");';
		$str .= '		li_obj.removeClass("alt_bg txtgreen");';
		$str .= '	});';
		$str .= '});';
		$str .= 	'$(".add_box .r li").mouseover(function(){';
		$str .= 	'$(this).addClass("alt_bg bd1");';
		$str .= '}).mouseout(function(){';
		$str .= 	'$(this).removeClass("alt_bg bd1");';
		$str .= '});';
		$str .= '});';
		$str .= '</script>';

		echo $str;
		break;
	case 'chg_cate':
		$cate_id = (int)gpc('cate_id','P',0);
		if($cate_id){
			$q = $db->query("select cate_id,pid,cate_name from {$tpf}categories where pid='$cate_id'");
			$str = '<option value="-1">- 请选择 -</option>';
			while ($rs = $db->fetch_array($q)) {
				$str .= '<option value="'.$rs[cate_id].'">'.$rs[cate_name].'</option>';
			}
			$db->free($q);
			unset($rs);
			echo $str;
		}
		break;
	case 'digg':
		$file_id = (int)gpc('file_id','G',0);
		$dig_type = (int)gpc('dig_type','G',0);
		$digg_cookie = gpc("phpdisk_digg_{$file_id}",'C','');
		if(!$digg_cookie){
			$rs = $db->fetch_one_array("select good_count,bad_count,userid from {$tpf}files where file_id='$file_id' limit 1");
			if($rs){
				$good_count = (int)$rs['good_count']+1;
				$bad_count = (int)$rs['bad_count']+1;
				$userid = (int)$rs['userid'];
			}
			unset($rs);
			if($dig_type ==1){
				$db->query_unbuffered("update {$tpf}files set good_count=good_count+1 where file_id='$file_id'");
			}elseif($dig_type ==2){
				$db->query_unbuffered("update {$tpf}files set bad_count=bad_count+1 where file_id='$file_id'");
			}
			pd_setcookie("phpdisk_digg_{$file_id}", $file_id, $timestamp+3600);
			echo "var re=new Array();re[0]=".$file_id.";re[1]=".$dig_type.";re[2]=\"success\";re[3]=\"".__('vote_success')."\";";
		}else{
			echo "var re=new Array();re[0]=".$file_id.";re[1]=".$dig_type.";re[2]=\"fail\";re[3]=\"".__('cannot_same_vote')."\";";
		}
		break;
	case 'down_process':

		$pid = (int)gpc('pid','P',0);
		$ref_fail =false;
		$arr = explode('/',$_SERVER['HTTP_REFERER']);
		$arr2 = explode('/',$settings[phpdisk_url]);
		if($_SERVER['HTTP_HOST']!='localhost'){
			if(!$_SERVER['HTTP_REFERER'] || $arr[2]!=$arr2[2]){
				$ref_fail =true;
			}
		}
		if($ref_fail || !is_numeric($pid)){
			echo 'Bad View!';
			exit;
		}
		$rs = $db->fetch_one_array("select userid from {$tpf}posts where pid='$pid' and is_del=0 and is_checked=1");
		$down_stat = (int)gpc('down_stat','C','');
		if(!$down_stat){
			pd_setcookie('down_stat',1,100);
			$rs[userid] && do_stat('downs',0,$rs[userid]);
			$db->query_unbuffered("update {$tpf}posts set downs=downs+1 where pid='$pid'");
		}
		echo 'true';
		break;
	case 'save_as':
		$file_id = (int)gpc('file_id','G',0);
		if($pd_uid){
			$rs = $db->fetch_one_array("select * from {$tpf}files where file_id='$file_id' limit 1");
			if($rs){
				$has_file = @$db->result_first("select count(*) from {$tpf}files where file_name='{$rs[file_name]}' and file_extension='{$rs[file_extension]}' and file_size='{$rs[file_size]}' and userid='$pd_uid' limit 1");
				if(($rs['userid'] ==$pd_uid) || $has_file){
					$rtn ='ufile';
				}else{
					$ins = array(
					'file_name' => '[转]'.$rs['file_name'],
					'file_key' => random(8),
					'file_extension' => $rs['file_extension'],
					'is_image' => $rs['is_image'],
					'file_mime' => $rs['file_mime'],
					'file_description' => $rs['file_description'],
					'file_store_path' => $rs['file_store_path'],
					'file_real_name' => $rs['file_real_name'],
					'file_md5' => $rs['file_md5'],
					'server_oid' => $rs['server_oid'],
					'file_size' => $rs['file_size'],
					'file_time' => $timestamp,
					'in_share' => 1,
					'is_checked' => $rs['is_checked'],
					'userid' => $pd_uid,
					'ip' => get_ip(),
					);
					$db->query_unbuffered("insert into {$tpf}files set ".$db->sql_array($ins)."");
					$rtn = 'true';
				}
			}
			unset($rs);
		}else{
			$rtn = 'false';
		}
		echo $rtn;
		break;
	case 'conv_credit':
		if($pd_uid){
			$credit_type = gpc('credit_type','P','');
			switch($credit_type){
				case 'credit':
					if(!$myinfo[credit] && !$myinfo[dl_credit]){
						echo '积分为零，无法兑换金钱，请努力推广赚钱吧。';
					}else{
						if(conv_credit($pd_uid)){
							echo 'true';
						}else{
							echo __('conv_credit_error');
						}
					}
					break;
				default:
					echo 'Invalid Action';
			}
		}else{
			echo 'Invalid User!';
		}
		break;

	case 'check_code':
		$code = trim(gpc('code','P',''));
		//$_SESSION[my_imgcode][code];
		if(strtolower($code)==strtolower($_SESSION[my_imgcode][code])){
			echo 'true';
		}else{
			echo 'false';
		}
		break;
	case 'chk_username':
		$r_username = trim(gpc('r_username','P',''));
		if(checklength($r_username,2,60)){
			echo __('username_length_error');
		}elseif(is_bad_chars($r_username)){
			echo __('username_has_bad_chars');
		}else{
			$num = @$db->result_first("select count(*) from {$tpf}users where username='$r_username'");
			if($num){
				echo __('username_already_exists');
			}else{
				echo 'true|'.__('username_can_reg');
			}
		}
		break;
	case 'chk_email':
		$r_email = trim(gpc('r_email','P',''));

		if(!checkemail($r_email)){
			echo __('invalid_email');
		}else{
			$num = @$db->result_first("select count(*) from {$tpf}users where email='$r_email'");
			if($num){
				echo __('email_already_exists');
			}else{
				echo 'true|'.__('email_can_reg');
			}
		}
		break;
	case 'fd_stat':
		$folder_id = (int)gpc('folder_id','P',0);
		if($folder_id){
			$file_size = (int)@$db->result_first("select sum(file_size) from {$tpf}files where folder_id='$folder_id'");
			$db->query_unbuffered("update {$tpf}folders set folder_size='$file_size' where folder_id='$folder_id'");
			echo 'true|'.get_size($file_size);
		}
		break;

	case 'space_pwd':
		$code = gpc('code','P','');
		$userid = (int)gpc('uid','P',0);
		if($code){
			$num = (int)@$db->result_first("select count(*) from {$tpf}users where space_pwd='$code' and userid='$userid'");
			if($num){
				pd_setcookie('c_space_pwd',$code);
				echo 'true|'.__('space_pwd_ok');
			}else{
				echo __('space_pwd_fail');
			}
		}else{
			echo __('space_pwd_fail');
		}
		break;
	case 'admin_space_pwd':
		$userid = (int)gpc('uid','P',0);
		if($pd_gid==1 && $userid){
			$space_pwd = (int)@$db->result_first("select space_pwd from {$tpf}users where userid='$userid'");
			if($space_pwd){
				pd_setcookie('c_space_pwd',$space_pwd);
				echo 'true|'.__('space_pwd_ok');
			}else{
				echo __('space_pwd_fail');
			}
		}else{
			echo __('space_pwd_error');
		}
		break;
	case 'bind_user':
		$flid = gpc('flid','P','');
		$username = gpc('username','P','');
		$password = gpc('password','P','');

		if($username && $password){
			$md5_pwd = md5($password);
			$userid = @$db->result_first("select userid from {$tpf}users where username='$username' and password='$md5_pwd'");
			if($userid){
				$db->query_unbuffered("update {$tpf}fastlogin set userid='$userid' where flid='$flid' ");
				$rs = $db->fetch_one_array("select userid,gid,username,password,email from {$tpf}users where userid='$userid'");
				if($rs){
					pd_setcookie('phpdisk_fcore_info',pd_encode("{$rs[userid]}\t{$rs[gid]}\t{$rs[username]}\t{$rs[password]}\t{$rs[email]}"));
				}
				echo 'true|'.__('fastlogin_ok');
			}else{
				echo __('username_password_error');
			}
		}else{
			echo __('username_password_is_null');
		}
		break;
	case 'guest_visit':
		$flid = gpc('flid','P','');
		$rs = $db->fetch_one_array("select auth_type,nickname from {$tpf}fastlogin where flid='$flid'");
		if($rs[nickname]){
			$nickname = addslashes(trim($rs[nickname]));
			$num = @$db->result_first("select count(*) from {$tpf}users where username='$nickname'");
		}
		unset($rs);
		if($num){
			$reg_name = $nickname.'_'.random(2);
		}else{
			$tmp_uid = (int)@$db->result_first("select userid from {$tpf}users order by userid desc limit 1");
			$reg_name = $nickname ? addslashes($nickname) : 'guest-'.($tmp_uid+1);
		}
		$ins = array(
		'username' => $reg_name,
		'password' => md5($timestamp),
		'email' => $timestamp.'@guest.tmp',
		'gid' => 4,
		'reg_time' => $timestamp,
		'reg_ip' => $onlineip,
		'space_name' => $reg_name.'的文件',
		'can_edit'=>1,
		);
		$db->query_unbuffered("insert into {$tpf}users set ".$db->sql_array($ins)."");
		$uid = $db->insert_id();
		$db->query_unbuffered("update {$tpf}fastlogin set userid='$uid' where flid='$flid' ");
		$rs = $db->fetch_one_array("select userid,gid,username,password,email from {$tpf}users where userid='$uid'");
		if($rs){
			pd_setcookie('phpdisk_fcore_info',pd_encode("{$rs[userid]}\t{$rs[gid]}\t{$rs[username]}\t{$rs[password]}\t{$rs[email]}"));
		}
		echo 'true|'.__('fastlogin_ok');
		break;

	case 'load_file_addr':
		$file_id = (int)gpc('file_id','P',0);
		if($file_id){
			$rs = $db->fetch_one_array("select * from {$tpf}files where file_id='$file_id'");
			if($rs[yun_fid]){
				$a_down = 'http://d.yun.phpdisk.com/down-'.$rs[yun_fid];
			}else{
				if(display_plugin('multi_server','open_multi_server_plugin',$settings['open_multi_server'],0)){
					$rs2 = $db->fetch_one_array("select server_host,server_dl_host from {$tpf}servers where server_oid='{$rs[server_oid]}' limit 1");
					if($rs2){
						$a_down = $rs2['server_host'].create_down_url($rs);
						if($rs['file_time'] && $timestamp-$rs['file_time']>600){
							if($rs2[server_dl_host]){
								$arr = explode(LF,$rs2[server_dl_host]);
								$a_down = $arr[0].create_down_url($rs);
							}
						}

					}
					unset($rs2);
				}
				unset($rs);
			}
			echo 'true|<a href="'.$a_down.'" target="_blank">[下载]</a>';
		}else{
			echo 'NO file_id';
		}
		break;
	case 'cp_index':
		$setting = array(
		'open_index_fast_upload_box' => 0,
		'open_index_site_desc' => 0,
		'open_index_file_list' => 0,
		);
		$settings = gpc('setting','P',$setting);
		$settings[open_index_fast_upload_box] = $settings[open_index_fast_upload_box] ? 1 : 0;
		$settings[open_index_site_desc] = $settings[open_index_site_desc] ? 1 : 0;
		$settings[open_index_file_list] = $settings[open_index_file_list] ? 1 : 0;
		if(!$error && $pd_gid==1){
			settings_cache($settings);
			echo __('diy_update_success');
		}else{
			echo __('diy_update_fail');
		}
		break;

	case 'cp_viewfile':
		$setting = array(
		'open_viewfile_file_list' => 0,
		);
		$settings = gpc('setting','P',$setting);
		$settings[open_viewfile_file_list] = $settings[open_viewfile_file_list] ? 1 : 0;

		if(!$error && $pd_gid==1){
			settings_cache($settings);
			echo __('diy_update_success');
		}else{
			echo __('diy_update_fail');
		}
		break;
	case 'uploadCloud':
		$folder_id = (int)gpc('folder_id','P',0);
		$data = trim(gpc('data','P',''));

		if($data){
			$file_key = random(8);
			if(strpos($data,',')!==false){
				$add_sql = $msg = '';
				$arr = explode(',',$data);
				for($i=0;$i<count($arr)-1;$i++){
					$file = unserialize(base64_decode($arr[$i]));
					$file[file_description] = $db->escape(trim($file[file_description]));
					$file[file_extension] = $db->escape(trim($file[file_extension]));
					$file[file_name] = $db->escape(trim($file[file_name]));
					$file[file_id] = (int)$file[file_id];
					$file[file_size] = (int)$file[file_size];
					$report_status =0;
					$report_arr = explode(',',$settings['report_word']);
					if(count($report_arr)){
						foreach($report_arr as $value){
							if (strpos($file['file_name'],$value) !== false){
								$report_status = 2;
							}
						}
					}
					$num = @$db->result_first("select count(*) from {$tpf}files where yun_fid='{$file[file_id]}' and userid='$pd_uid'");
					if($num && $file[file_id]){
						$tmp_ext = $file[file_extension] ? '.'.$file[file_extension] : '';
						$msg .=	$file[file_name].$tmp_ext.',';
					}else{
						$add_sql .= "($file[file_id],'$file[file_name]','$file_key','$file[file_extension]','application/octet-stream','$file[file_description]','$file[file_size]','$timestamp','$is_checked','$in_share','$report_status','$pd_uid','$folder_id','$onlineip'),";
					}
				}
				if($add_sql){
					$add_sql = is_utf8() ? $add_sql : iconv('utf-8','gbk',$add_sql);
					$add_sql = substr($add_sql,0,-1);
					$db->query_unbuffered("insert into {$tpf}files(yun_fid,file_name,file_key,file_extension,file_mime,file_description,file_size,file_time,is_checked,in_share,report_status,userid,folder_id,ip) values $add_sql ;");
				}
			}else{
				$file = unserialize(base64_decode($data));
				$file[file_description] = $db->escape(trim($file[file_description]));
				$file[file_extension] = $db->escape(trim($file[file_extension]));
				$file[file_name] = $db->escape(trim($file[file_name]));
				$file[file_id] = (int)$file[file_id];
				$file[file_size] = (int)$file[file_size];
				$num = @$db->result_first("select count(*) from {$tpf}files where yun_fid='{$file[file_id]}' and userid='$pd_uid'");
				if($num && $file[file_id]){
					$tmp_ext = $file[file_extension] ? '.'.$file[file_extension] : '';
					$msg = $file[file_name].$tmp_ext;
				}else{
					$report_status =0;
					$report_arr = explode(',',$settings['report_word']);
					if(count($report_arr)){
						foreach($report_arr as $value){
							if (strpos($file['file_name'],$value) !== false){
								$report_status = 2;
							}
						}
					}
					$ins = array(
					'yun_fid' => $file[file_id],
					'file_name' => $file[file_name],
					'file_key' => $file_key,
					'file_extension' => $file[file_extension],
					'file_mime' => 'application/octet-stream',
					'file_description' => $file[file_description],
					'file_size' => $file['file_size'],
					'file_time' => $timestamp,
					'is_checked' => 1,
					'in_share' => 1,
					'report_status' => $report_status,
					'userid' => $pd_uid,
					'folder_id' => $folder_id,
					'ip' => $onlineip,
					);
					$sql = "insert into {$tpf}files set ".$db->sql_array($ins).";";
					$db->query_unbuffered(is_utf8() ? $sql : iconv('utf-8','gbk',$sql));
				}
			}
			$msg = $msg ? '文件已存在：'.substr($msg,0,-1).',不能重复添加' : '';
			echo 'true|'.$msg;
		}else{
			echo 'false';
		}
		break;
	case 'load_down_addr1':
		$file_id = (int)gpc('file_id','P','');
		$file = $db->fetch_one_array("select * from {$tpf}files where file_id='$file_id' limit 1");
		$file['dl'] = create_down_url($file);
		$nodes = get_nodes($file[server_oid]);
		$str = '';
		if(count($nodes)){
			for($i = 0; $i < count($nodes); $i++) {
				if($nodes[$i]['parent_id'] == 0) {
					for($j = 0; $j < count($nodes); $j++) {
						if($nodes[$j]['parent_id'] == $nodes[$i]['node_id']) {
							if($settings['open_thunder'] && $nodes[$j]['down_type']==1){
								$thunder_url = thunder_encode($nodes[$j]['host'].$file[dl]);
								$str .="<a oncontextmenu=ThunderNetwork_SetHref(this) onclick=\"down_process2('{$file[file_id]}');return OnDownloadClick_Simple(this,2,4)\" href=\"###\" thunderResTitle=\"{$file['file_name']}\" thunderType=\"\" thunderPid=\"{$settings['thunder_pid']}\" thunderHref=\"{$thunder_url}\" class=\"down_btn\"><span>".$nodes[$j]['icon'].$nodes[$j]['subject']."</span></a>";
							}elseif($settings['open_flashget'] && $nodes[$j]['down_type']==2){
								$flashget_url = flashget_encode($nodes[$j]['host'].$file[dl],$settings['flashget_uid']);
								$str .="<a href=\"###\" onClick=\"down_process2('{$file[file_id]}');ConvertURL2FG('{$flashget_url}','".$nodes[$j]['host'].$file[dl]."',{$settings['flashget_uid']});return false;\" oncontextmenu=\"Flashget_SetHref(this)\" fg=\"{$flashget_url}\" class=\"down_btn\"><span>".$nodes[$j]['icon'].$nodes[$j]['subject']."</span></a>";
							}else{
								$str .="<a href=\"".$nodes[$j]['host'].$file[dl]."\" onclick=\"down_process2('{$file[file_id]}');\" target=\"_blank\" class=\"down_btn\"><span>".$nodes[$j]['icon'].$nodes[$j]['subject']."</span></a>";
							}
						}
					}
				}
			}
			unset($nodes);
		}
		echo 'true|'.$str;
		break;
	case 'load_down_addr2':
		$file_id = (int)gpc('file_id','P','');
		$file = $db->fetch_one_array("select * from {$tpf}files where file_id='$file_id' limit 1");
		$file['dl'] = create_down_url($file);
		$nodes = get_nodes($file[server_oid]);
		$nodes = get_nodes($file[server_oid]);
		$str = '';
		if(count($nodes)){
			for($i = 0; $i < count($nodes); $i++) {
				if($nodes[$i]['parent_id'] == 0) {
					$str .= "<div class=\"tit2\"><img src=\"images/icon_nav.gif\" align=\"absmiddle\" border=\"0\" />{$nodes[$i]['subject']}</div>";
					$str .= "<div class=\"d0\">";
					for($j = 0; $j < count($nodes); $j++) {
						if($nodes[$j]['parent_id'] == $nodes[$i]['node_id']) {
							if($j%2==0){
								$str .= "<div class=\"d1\" align=\"center\">";
								if($settings['open_thunder'] && $nodes[$j]['down_type']==1){
									$thunder_url = thunder_encode($nodes[$j]['host'].$file[dl]);
									$str .= "<a oncontextmenu=ThunderNetwork_SetHref(this) onclick=\"down_process2('{$file[file_id]}');return OnDownloadClick_Simple(this,2,4)\" href=\"###\" thunderResTitle=\"{$file['file_name']}\" thunderType=\"\" thunderPid=\"{$settings['thunder_pid']}\" thunderHref=\"{$thunder_url}\" class=\"down_btn\"><span>".$nodes[$j]['icon'].$nodes[$j]['subject']."</span></a>";
								}elseif($settings['open_flashget'] && $nodes[$j]['down_type']==2){
									$flashget_url = flashget_encode($nodes[$j]['host'].$file[dl],$settings['flashget_uid']);
									$str .= "<a href=\"###\" onClick=\"down_process2('{$file[file_id]}');ConvertURL2FG('{$flashget_url}','".$nodes[$j]['host'].$file[dl]."',{$settings['flashget_uid']});return false;\" oncontextmenu=\"Flashget_SetHref(this)\" fg=\"{$flashget_url}\" class=\"down_btn\"><span>".$nodes[$j]['icon'].$nodes[$j]['subject']."</span></a>";
								}else{
									$str .= "<a href=\"".$nodes[$j]['host'].$file[dl]."\" onclick=\"down_process2('{$file[file_id]}');\" target=\"_blank\"><span>".$nodes[$j]['icon'].$nodes[$j]['subject']."</span></a>";
								}
								$str .= "</div>";
							}else{
								$str .= "<div class=\"d2\" align=\"center\">";
								if($settings['open_thunder'] && $nodes[$j]['down_type']==1){
									$thunder_url = thunder_encode($nodes[$j]['host'].$file[dl]);
									$str .= "<a oncontextmenu=ThunderNetwork_SetHref(this) onclick=\"down_process2('{$file[file_id]}');return OnDownloadClick_Simple(this,2,4)\" href=\"###\" thunderResTitle=\"{$file['file_name']}\" thunderType=\"\" thunderPid=\"{$settings['thunder_pid']}\" thunderHref=\"{$thunder_url}\" class=\"down_btn\"><span>".$nodes[$j]['icon'].$nodes[$j]['subject']."</span></a>";
								}elseif($settings['open_flashget'] && $nodes[$j]['down_type']==2){
									$flashget_url = flashget_encode($nodes[$j]['host'].$file[dl],$settings['flashget_uid']);
									$str .= "<a href=\"###\" onClick=\"down_process2('{$file[file_id]}');ConvertURL2FG('{$flashget_url}','".$nodes[$j]['host'].$file[dl]."',{$settings['flashget_uid']});return false;\" oncontextmenu=\"Flashget_SetHref(this)\" fg=\"{$flashget_url}\" class=\"down_btn\"><span>".$nodes[$j]['icon'].$nodes[$j]['subject']."</span></a>";
								}else{
									$str .= "<a href=\"".$nodes[$j]['host'].$file[dl]."\" onclick=\"down_process2('{$file[file_id]}');\" target=\"_blank\"><span>".$nodes[$j]['icon'].$nodes[$j]['subject']."</span></a>";
								}
								$str .= "</div>";
							}
						}
					}

					$str .= "<div class=\"clear\"></div>";
					$str .= "</div>";
				}
			}
			unset($nodes);
		}
		echo 'true|'.$str;
		break;
}

include PHPDISK_ROOT."./includes/footer.inc.php";

function multi_ajax($action,$id,$total, $perpage, $curpage ) {
	$multipage = '';
	//$mpurl .= strpos($mpurl, '?') ? '&amp;' : '?';
	if($total > $perpage) {
		$pg = 10;
		$offset = 5;
		$pgs = @ceil($total / $perpage);
		if($pg > $pgs) {
			$from = 1;
			$to = $pgs;
		} else {
			$from = $curpage - $offset;
			$to = $curpage + $pg - $offset - 1;
			if($from < 1) {
				$to = $curpage + 1 - $from;
				$from = 1;
				if(($to - $from) < $pg && ($to - $from) < $pgs) {
					$to = $pg;
				}
			} elseif($to > $pgs) {
				$from = $curpage - $pgs + $to;
				$to = $pgs;
				if(($to - $from) < $pg && ($to - $from) < $pgs) {
					$from = $pgs - $pg + 1;
				}
			}
		}

		$multipage = ($curpage - $offset > 1 && $pgs > $pg ? '<a href="javascript:;" onclick="'.$action.'('.$id.',1);" class="p_redirect">&laquo;</a>' : '').($curpage > 1 ? '<a href="javascript:;" onclick="'.$action.'('.$id.','.($curpage - 1).');" class="p_redirect">&#8249;</a>' : '');
		for($i = $from; $i <= $to; $i++) {
			$multipage .= $i == $curpage ? '<span class="p_curpage">'.$i.'</span>' : '<a href="javascript:;" onclick="'.$action.'('.$id.','.$i.');" class="p_num">'.$i.'</a>';
		}
		$multipage .= ($curpage < $pgs ? '<a href="javascript:;" onclick="'.$action.'('.$id.','.($curpage + 1).');" class="p_redirect">&#8250;</a>' : '').($to < $pgs ? '<a href="javascript:;" onclick="'.$action.'('.$id.','.$pgs.');" class="p_redirect">&raquo;</a>' : '');
		$multipage = $multipage ? '<div class="p_bar"><span class="p_info">Total:&nbsp;<b>'.$total.'</b>&nbsp;</span>'.$multipage.'</div>' : '';
	}
	return $multipage;
}
?>