<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: search.php 6 2013-09-02 09:05:24Z along $
#
#	Copyright (C) 2008-2014 PHPDisk Team. All Rights Reserved.
#
*/
include '../includes/commons.inc.php';
require_once 'JSON.php';

$my_sign = trim(gpc('my_sign','GP',''));
$uid = (int)gpc('uid','GP',0);
$uid = $uid ? $uid : $pd_uid;

$ext_arr = array(
'image' => array('gif', 'jpg', 'jpeg', 'png', 'bmp'),
'flash' => array('swf', 'flv'),
'media' => array('swf', 'flv', 'mp3', 'wav', 'wma', 'wmv', 'mid', 'avi', 'mpg', 'asf', 'rm', 'rmvb'),
'file' => array('doc', 'docx', 'xls', 'xlsx', 'ppt', 'htm', 'html', 'txt', 'zip', 'rar', 'gz', 'bz2'),
);

//PHP上传失败
if (!empty($_FILES['imgFile']['error'])) {
	switch($_FILES['imgFile']['error']){
		case '1':
			$error = '超过php.ini允许的大小。';
			break;
		case '2':
			$error = '超过表单允许的大小。';
			break;
		case '3':
			$error = '图片只有部分被上传。';
			break;
		case '4':
			$error = '请选择图片。';
			break;
		case '6':
			$error = '找不到临时目录。';
			break;
		case '7':
			$error = '写文件到硬盘出错。';
			break;
		case '8':
			$error = '此类文件不允许上传';
			break;
		case '999':
		default:
			$error = '未知错误。';
	}
	alert($error);
}

//有上传文件时
if (empty($_FILES) === false) {
	$file = $_FILES['imgFile'];
	$file['name'] = $db->escape($file['name']);

	$file_real_path = PHPDISK_ROOT.'/'.$settings['file_path'].'/';
	$file_store_path = date('Y/m/d/');

	make_dir($file_real_path.$file_store_path);
	//检查目录
	if (@is_dir($file_real_path.$file_store_path) === false) {
		alert("上传目录不存在。");
	}
	//检查目录写权限
	if (@is_writable($file_real_path.$file_store_path) === false) {
		alert("上传目录没有写权限。");
	}
	if(!$uid){
		alert("未登录,上传失败");
	}
	$md5_sign = md5($settings[encrypt_key].$uid);
	if($my_sign<>$md5_sign){		
		alert("参数较验失败");
	}
	$file_extension = get_extension($file['name']);
	if(!in_array($file_extension,$ext_arr[image])){
		alert('只允许上传 jpg,jpeg,png,gif,bmp图片文件');
	}
	$esp = strlen($file_extension)+1;
	if($file_extension){
		$file_name = substr($file['name'],0,strlen($file['name'])-$esp);
	}else{
		$file_name = $file['name'];
	}

	$file_real_name = md5(uniqid(mt_rand(),true).microtime().$uid);

	$file_real_name_store = is_utf8() ? convert_str('utf-8','gbk',$file_real_name) : $file_real_name;
	$file_ext = get_real_ext($file_extension);
	$dest_file = $file_real_path.$file_store_path.$file_real_name_store.$file_ext;

	if(upload_file($file['tmp_name'],$dest_file)){
		$file_key = random(8);

		$file_mime = strtolower($db->escape($file['type']));
		$is_image = 1;

		$db->ping();
		$server_oid = 0;
		$ins = array(
		'file_name' => $file_name,
		'file_key' => $file_key,
		'file_extension' => $file_extension,
		'is_image' => $is_image,
		'file_mime' => $file_mime,
		'file_description' => $file_description ? $file_description : '',
		'file_store_path' => $file_store_path,
		'file_real_name' => $file_real_name,
		'file_md5' => $file_md5 ? $file_md5 : '',
		'server_oid' => (int)$server_oid,
		'file_size' => $file['size'],
		'file_time' => $timestamp,
		'is_checked' => 1,
		'report_status' => 0,
		'userid' => $uid,
		'folder_id' => -1,
		'ip' => $onlineip,
		);
		$file_url = $settings[file_path].'/'.$file_store_path.$file_real_name.'.'.$file_extension;
		$db->query_unbuffered("insert into {$tpf}files set ".$db->sql_array($ins).";");

		@unlink($file['tmp_name']);

		header('Content-type: text/html; charset=UTF-8');
		$json = new Services_JSON();
		echo $json->encode(array('error' => 0, 'url' => $file_url));
		exit;
	}else{
		alert("上传文件失败。");
	}
}

function alert($msg) {
	header('Content-type: text/html; charset=UTF-8');
	$json = new Services_JSON();
	echo $json->encode(array('error' => 1, 'message' => $msg));
	exit;
}
?>