<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: profile.inc.php 17 2014-06-26 03:29:37Z along $
#
#	Copyright (C) 2008-2014 PHPDisk Team. All Rights Reserved.
#
*/

if(!defined('IN_PHPDISK') || !defined('IN_MYDISK')) {
	exit('[PHPDisk] Access Denied');
}

$myinfo = get_profile($pd_uid);
$curr_downline_rate = $myinfo[downline_income] ? $myinfo[downline_income].'%' : ($settings[downline_income] ? $settings[downline_income].'%' : 0);

switch($action){
	case 'files':
		$folder_id = (int)gpc('folder_id','GP',0);

		if($folder_id==-1){
			$nav_path = '<a href="'.urr("mydisk","item=profile&action=files").'">文件管理</a>&raquo; <a href="'.urr("mydisk","item=profile&action=files&folder_id=-1").'">描述图片</a>';
		}else{
			$nav_path = '<a href="'.urr("mydisk","item=profile&action=files").'">文件管理</a>&raquo; '.nav_path($folder_id,$pd_uid,0,1);
		}

		if($task=='search'){
			$word = trim(gpc('word','G',''));
			$sql_tmp = $word ? " and (file_name like '%$word%' or file_extension like '%$word%')" : '';
			if($folder_id){
				$sql_do = "{$tpf}files where userid='$pd_uid' and is_del=0 and folder_id='$folder_id' $sql_tmp";
			}else{
				$sql_do = "{$tpf}files where userid='$pd_uid' and is_del=0 and folder_id='0' $sql_tmp";
			}
		}else{
			if($folder_id){
				$sql_do = "{$tpf}files where userid='$pd_uid' and is_del=0 and folder_id='$folder_id'";
			}else{
				$sql_do = "{$tpf}files where userid='$pd_uid' and is_del=0 and folder_id='0'";
			}
		}
		if($task!='search' && $pg==1){
			$q = $db->query("select fd.*,u.username from {$tpf}folders fd,{$tpf}users u where fd.parent_id='$folder_id' and fd.userid='$pd_uid' and fd.userid=u.userid order by folder_order asc,folder_id desc");
			$folders_array = array();
			while ($rs = $db->fetch_array($q)) {
				$rs[a_folder_view] = urr("mydisk","item=profile&action=files&folder_id={$rs[folder_id]}");
				$rs[a_folder] = urr("space","username=".rawurlencode($rs[username])."&folder_id={$rs[folder_id]}");
				$rs[a_edit] = urr("mydisk","item=folders&action=modify_folder&folder_id={$rs[folder_id]}");
				$rs[a_del] = urr("mydisk","item=folders&action=folder_delete&folder_id={$rs[folder_id]}");
				$rs[folder_size] = get_size($rs[folder_size]);
				$rs[in_time] = date('Y-m-d H:i:s',$rs[in_time]);
				$folders_array[] = $rs;
			}
			$db->free($q);
			unset($rs);
		}

		$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_do}");
		$total_num = $rs['total_num'];
		$start_num = ($pg-1) * $perpage;

		$q = $db->query("select * from {$sql_do} order by show_order asc, file_id desc limit $start_num,$perpage");
		$files_array = array();
		while($rs = $db->fetch_array($q)){
			$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
			$rs['file_name_all'] = $rs['file_name'].$tmp_ext;
			$rs['file_name'] = cutstr($rs['file_name'].$tmp_ext,80);
			$rs['file_new'] = ($timestamp-$rs['file_time']<86400) ? '<img src="images/new.png" align="absmiddle" border="0"/>' : '';
			$rs['file_time'] = date('Y-m-d H:i:s',$rs[file_time]);
			$rs['file_size'] = get_size($rs['file_size']);
			$rs[file_description] = clear_html(filter_word($rs['file_description']),80);
			$rs['a_viewfile'] = urr("dfile","file_id={$rs[file_id]}&yun_fid={$rs[yun_fid]}");
			$rs['a_postfile'] = urr("mydisk","item=post&action=add_post&file_id={$rs['file_id']}");
			$rs['a_modify'] = urr("mydisk","item=files&action=modify_file&file_id={$rs['file_id']}");
			$files_array[] = $rs;
		}
		$db->free($q);
		unset($rs);

		$page_nav = multi($total_num, $perpage, $pg, urr("mydisk","item=$item&action=$action&folder_id=$folder_id"));
		if($task=='search'){
			$page_nav = multi($total_num, $perpage, $pg, urr("mydisk","item=$item&action=$action&task=$task&folder_id=$folder_id&word=".rawurlencode($word)));
		}else{
			$page_nav = multi($total_num, $perpage, $pg, urr("mydisk","item=$item&action=$action&folder_id=$folder_id"));
		}
		require_once template_echo('profile',$user_tpl_dir);
		break;
	case 'mod_pwd':
		if($task =='mod_pwd'){
			form_auth(gpc('formhash','P',''),formhash());

			$old_pwd = trim(gpc('old_pwd','P',''));
			$new_pwd = trim(gpc('new_pwd','P',''));
			$cfm_pwd = trim(gpc('cfm_pwd','P',''));

			$rs = $db->fetch_one_array("select userid from {$tpf}users where password='".md5($old_pwd)."' and userid='$pd_uid'");
			if(!$rs){
				$error = true;
				$sysmsg[] = __('invalid_password');
			}
			unset($rs);
			if(checklength($new_pwd,6,20)){
				$error = true;
				$sysmsg[] = __('password_max_min');
			}elseif($new_pwd != $cfm_pwd){
				$error = true;
				$sysmsg[] = __('confirm_password_invalid');
			}else{
				$md5_pwd = md5($new_pwd);
			}
			if(display_plugin('api','open_uc_plugin',$settings['connect_uc'],0)){
				$ucresult = uc_user_edit($pd_username, $old_pwd, $new_pwd,'');
				if($ucresult < 0) {
					$error = true;
					$sysmsg[] = 'UC:'.__('invalid_password');
				}
			}
			if(!$error){
				$sql = "update {$tpf}users set password='$md5_pwd' where userid='$pd_uid'";
				$db->query_unbuffered($sql);
				pd_setcookie('phpdisk_fcore_info','');
				$sysmsg[] = __('password_modify_success');
				redirect(urr("account","action=login"),$sysmsg,2000,'top');
			}else{
				redirect('back',$sysmsg);
			}
		}elseif($task=='mod_pwd2'){
			form_auth(gpc('formhash','P',''),formhash());

			$old_pwd = trim(gpc('old_pwd','P',''));
			$new_pwd = trim(gpc('new_pwd','P',''));
			$cfm_pwd = trim(gpc('cfm_pwd','P',''));

			$rs = $db->fetch_one_array("select userid from {$tpf}users where income_pwd='".md5($old_pwd)."' and userid='$pd_uid'");
			if(!$rs){
				$error = true;
				$sysmsg[] = '当前提现密码不正确';
			}
			unset($rs);
			if(checklength($new_pwd,6,20)){
				$error = true;
				$sysmsg[] = __('password_max_min');
			}elseif($new_pwd != $cfm_pwd){
				$error = true;
				$sysmsg[] = '确认提现密码不正确';
			}else{
				$md5_pwd = md5($new_pwd);
			}
			if(!$error){
				$sql = "update {$tpf}users set income_pwd='$md5_pwd' where userid='$pd_uid'";
				$db->query_unbuffered($sql);
				$sysmsg[] = '提现密码修改成功';
				redirect(urr("mydisk","item=profile&action=$action"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			require_once template_echo('profile',$user_tpl_dir);
		}
		break;

	case 'myannounce':
		if($task=='myannounce'){
			form_auth(gpc('formhash','P',''),formhash());
			$my_announce = gpc('my_announce','P','',0);

			if($my_announce && checklength($my_announce,1,6000)){
				$error = true;
				$sysmsg[] = __('my_announce_error');
			}else{
				$my_announce = preg_replace("/<(\/?i?frame.*?)>/si","",$my_announce);
				$my_announce = preg_replace("/<(\/?script.*?)>/si","",$my_announce);
			}
			if(!$error){
				$ins = array(
				'my_announce'=>$my_announce,
				);
				$db->query_unbuffered("update {$tpf}users set ".$db->sql_array($ins)." where userid='$pd_uid'");
				$sysmsg[] = __('my_announce_update_success');
				redirect('back',$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			$my_announce = $db->result_first("select my_announce from {$tpf}users where userid='$pd_uid'");
			$my_announce = str_replace('<br>',LF,$my_announce);
			require_once template_echo('profile',$user_tpl_dir);
		}
		break;
	case 'income':
		$same_pwd = @$db->result_first("select count(*) from {$tpf}users where password=income_pwd and userid='$pd_uid'");
		$rs = $db->fetch_one_array("select * from {$tpf}users where userid='$pd_uid'");
		if($rs){
			$wealth_lost = $rs['wealth_lost'] ? (int)$rs['wealth_lost'] : ($settings['wealth_lost'] ? (int)$settings['wealth_lost'] : 0);
			$wealth = $rs['wealth'];
			$income_account = $rs['income_account'];
			$income_name = $rs['income_name'];
			$income_type = $rs['income_type'];
			$income_type_txt = $arr[$income_type];

			$tmp = unserialize($rs['money_rate']);
			if($tmp['how_downs'] && $tmp['how_money']){
				$how_downs = $tmp['how_downs'];
				$how_money = $tmp['how_money'];
			}else{
				$how_downs = $settings['how_downs'];
				$how_money = $settings['how_money'];
			}
		}
		unset($rs);

		if($task =='to_income'){
			form_auth(gpc('formhash','P',''),formhash());
			$money = trim(gpc('money','P',''));
			$income_pwd = gpc('income_pwd','P','');

			if(!is_numeric($money)){
				$error = true;
				$sysmsg[] = __('money_not_numeric');
			}else{
				$money = (int)$money;
			}
			if(!$income_pwd || md5($income_pwd)!=$myinfo[income_pwd]){
				$error = true;
				$sysmsg[] = '提现密码不正确';
			}
			if((int)$settings['min_to_income'] > $money){
				$error = true;
				$sysmsg[] = __('min_to_income').$settings['min_to_income'];
			}
			if($wealth <$money){
				$error = true;
				$sysmsg[] = __('your_input_too_big');
			}else{
				$now_wealth = $wealth-$money;
			}
			if(!$income_account || !$income_name){
				$error = true;
				$sysmsg[] = __('income_account_not_set');
			}

			if(!$error){
				$ins = array(
				'order_number' => get_order_number(),
				'income_account' => $income_account,
				'income_name' => $income_name,
				'income_type' => $income_type,
				'o_status' => 'pendding',
				'userid' => $pd_uid,
				'money' => $money,
				'ip' => $onlineip,
				'in_time' => $timestamp,
				);
				$db->query_unbuffered("insert into {$tpf}income_orders set ".$db->sql_array($ins)."");
				$db->query_unbuffered("update {$tpf}users set wealth=$now_wealth where userid='$pd_uid'");
				$sysmsg[] = __('add_income_order_success');
				redirect('back',$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			$curr_credit_rate = $myinfo[credit_rate] ? exp_credit_rate($myinfo[credit_rate]) : (($settings[how_downs_credit] && $settings[how_money_credit]) ? $settings[how_downs_credit].'==￥'.$settings[how_money_credit] : '');

			$freeze_money = @$db->result_first("select sum(money) from {$tpf}income_orders where userid='$pd_uid' and o_status='pendding'");
			$freeze_money = $freeze_money ? '<span class="txtgray">（'.__('incoming').':￥'.$freeze_money.'）</span>' : '';
			$my_downlines = @$db->result_first("select count(*) from {$tpf}buddys where userid='$pd_uid'");
			require_once template_echo('profile',$user_tpl_dir);
		}
		break;
	case 'income_log':
		$sql_do = " {$tpf}income_orders io,{$tpf}users u where io.userid=u.userid and io.userid='$pd_uid'";
		$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_do}");
		$total_num = $rs['total_num'];
		$start_num = ($pg-1) * $perpage;

		$q = $db->query("select * from {$sql_do} order by order_id desc limit $start_num,$perpage");
		$orders = array();
		while($rs = $db->fetch_array($q)){
			$rs['o_status'] = get_income_status($rs['o_status']);
			$rs['in_time'] = date('Y-m-d H:i:s',$rs['in_time']);
			$orders[] = $rs;
		}
		$db->free($q);
		unset($rs);

		$page_nav = multi($total_num, $perpage, $pg, urr("mydisk","item=profile&action=income_log"));
		require_once template_echo('profile',$user_tpl_dir);
		break;
	case 'credit_log':
		$sql_do = get_table_credit_log()." c,{$tpf}posts p where c.userid='$pd_uid' and c.pid=p.pid";
		$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_do}");
		$total_num = $rs['total_num'];
		$start_num = ($pg-1) * $perpage;

		$q = $db->query("select c.*,p.p_name,p.seo from {$sql_do} order by c.in_time desc limit $start_num,$perpage");
		$orders = array();
		while($rs = $db->fetch_array($q)){
			$rs[credit] = $rs[action]=='buy_file' ? '<span class="txtred">-'.$rs[credit].'</span>' : '<span class="txtblue">+'.$rs[credit].'</span>';
			$rs[action] = $ca_arr[$rs[action]];
			$rs[a_view] = urr("viewpost","pid=$rs[pid]&seo=$rs[seo]");
			$rs['in_time'] = date('Y-m-d',$rs['in_time']);
			$orders[] = $rs;
		}
		$db->free($q);
		unset($rs);

		$page_nav = multi($total_num, $perpage, $pg, urr("mydisk","item=profile&action=$action"));
		require_once template_echo('profile',$user_tpl_dir);
		break;
	case 'invite':
		$invite_url = $settings['invite_register_encode'] ? $settings['phpdisk_url'].urr("account","action=register&".pd_encode('uid='.$pd_uid)) : $settings['phpdisk_url'].'reg-'.$pd_uid.'.html';
		require_once template_echo('profile',$user_tpl_dir);
		break;
	case 'chg_logo':
		if($task =='mod_pro'){

			form_auth(gpc('formhash','P',''),formhash());
			$space_name = trim(gpc('space_name','P',''));

			if(checklength($space_name,1,250)){
				$error = true;
				$sysmsg[] = __('space_name_error');
			}
			if(!$error){
				$ins = array(
				'space_name' => htmlspecialchars($space_name),
				);
				$db->query_unbuffered("update {$tpf}users set ".$db->sql_array($ins)." where userid='$pd_uid'");
				$sysmsg[] = __('space_name_update_success');
				redirect('back',$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}elseif($task=='space_pwd'){
			auth_task_space_pwd();
		}else{
			$rs = $db->fetch_one_array("select space_name,space_pwd from {$tpf}users where userid='$pd_uid'");
			if($rs){
				$space_name = $rs['space_name'];
				$space_pwd = $rs['space_pwd'];
			}
			unset($rs);

			require_once template_echo($item,$user_tpl_dir);
		}
		break;

	case 'income_set':
		if($task=='income_set'){
			form_auth(gpc('formhash','P',''),formhash());
			$income_account = trim(gpc('income_account','P',''));
			$income_name = trim(gpc('income_name','P',''));
			$income_type = trim(gpc('income_type','P',''));

			if(!$error){
				$ins = array(
				'income_account' => $income_account,
				'income_name' => $income_name,
				'income_type' => $income_type,
				);
				$db->query_unbuffered("update {$tpf}users set ".$db->sql_array($ins)." where userid='$pd_uid'");
				$sysmsg[] = __('income_set_update_success');
				redirect('back',$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			$rs = $db->fetch_one_array("select income_account,income_name,income_type from {$tpf}users where userid='$pd_uid'");
			if($rs){
				$income_account = $rs['income_account'];
				$income_name = $rs['income_name'];
				$income_type = $rs['income_type'];
			}
			unset($rs);
			require_once template_echo('profile',$user_tpl_dir);
		}
		break;

	case 'dl_users':
		$perpage = 20;
		$sql_do = "{$tpf}buddys b,{$tpf}users u where b.userid='$pd_uid' and b.touserid=u.userid";
		$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_do}");
		$total_num = $rs['total_num'];
		$start_num = ($pg-1) * $perpage;

		$q = $db->query("select u.credit,u.username,u.qq,u.userid,b.is_system from $sql_do order by bdid desc limit $start_num,$perpage");
		$buddys = array();
		while ($rs = $db->fetch_array($q)) {
			$rs[credit] = get_discount($rs[userid],$rs[credit]);
			$rs[is_system] = $rs[is_system] ? __('system_promo') : __('self_promo');
			$rs[a_space] = urr("space","username=".rawurlencode($rs[username]));
			$rs[qq] = $rs[qq] ? '<a target="_blank" href="http://wpa.qq.com/msgrd?v=3&uin='.$rs[qq].'&site=qq&menu=yes"><img border="0" src="http://wpa.qq.com/pa?p=2:'.$rs[qq].':52" alt="点击这里给我发消息" title="点击这里给我发消息"/></a>' : '';
			$buddys[] = $rs;
		}
		$db->free($q);
		unset($rs);
		$page_nav = multi($total_num, $perpage, $pg, "mydisk.php?item=profile&action=$action");

		require_once template_echo('profile',$user_tpl_dir);
		break;

	case 'guest':
		if($task=='guest'){
			auth_task_guest();
		}else{
			$ref = $_SERVER['HTTP_REFERER'];
			$can_edit = (int)$myinfo[can_edit];
			require_once template_echo('profile',$user_tpl_dir);
		}
		break;
	case 'multi_upload':
		$max_user_file_size = str_replace(' ','',get_user_file_size($pd_gid));
		$rs = $db->fetch_one_array("select gid,user_file_types from {$tpf}users where userid='$pd_uid'");
		$group_set = $group_settings[$rs[gid]];
		if($group_set['group_file_types']){
			$arr = explode(',',trim($group_set['group_file_types']));
			for($i=0;$i<count($arr);$i++){
				$user_file_types .= '*.'.$arr[$i].';';
			}
		}else{
			if($rs['user_file_types']){
				$arr = explode(',',trim($rs['user_file_types']));
				for($i=0;$i<count($arr);$i++){
					$user_file_types .= '*.'.$arr[$i].';';
				}
			}else{
				$user_file_types = '*.*';
			}
		}
		$upload_url = get_upload_url();

		require_once template_echo('profile',$user_tpl_dir);
		break;
	default:
		$ip = new ipLocation();
		$address = $ip->getaddress($myinfo[reg_ip]);
		$reg_ip_a = '('.convert_str('GB2312','utf-8',$address[area1].' '.$address[area2]).')';
		$address = $ip->getaddress($myinfo[last_login_ip]);
		$last_login_ip_a = '('.convert_str('GB2312','utf-8',$address[area1].' '.$address[area2]).')';

		$vip_end_time = get_profile($pd_uid,'vip_end_time');
		if($vip_end_time>$timestamp){
			$vip_end_time_txt = date('Y-m-d',get_profile($pd_uid,'vip_end_time'));
		}else{
			$vip_end_time_txt = date('Y-m-d',get_profile($pd_uid,'vip_end_time')).', <span class="txtred">('.__('vip_end_time_expire').')</span>';
		}
		require_once template_echo('profile',$user_tpl_dir);

}

?>